//
//  ViewController.h
//  FiscalDemo
//
//  Created by Flex on 9/4/12.
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#define USE_DTDEVICES
#define USE_EACCESSORY

#import <UIKit/UIKit.h>
#ifdef USE_EACCESSORY
#import <ExternalAccessory/ExternalAccessory.h>
#endif

#import "ProgressViewController.h"
#import "FP_BGR.h"
#import "FMP10_ROU.h"
#import "FMP350_BGR.h"
#import "fpBase.h"
#import "GROUP_C_BGR.h"
#ifdef USE_DTDEVICES
#import "DTDevices.h"
#endif

@interface MainViewController : UIViewController
{
    IBOutlet UITableView *printersTable;
    IBOutlet UIButton *discoverButton;
    IBOutlet ProgressViewController *progressViewController;
	IBOutlet UITextView *displayText;
    IBOutlet UILabel *accLabel;
    
    IBOutlet UIButton *testButton;
    IBOutlet UILabel *testLabel;
    IBOutlet UITextField *testTimeField;
    
    //class for bulgarian fiscal printers
    FP_BGR *fp_bgr;
    //class for new bulgarian fiscal printers
    FMP350_BGR *fmp350_bgr;

    //class for romanian fmp-10
    FMP10_ROU *fmp10_rou;
    //class for generic fiscal printer, contains custom command only
    fpBase *fiscalPrinter;

    //the new fiscal printers, group C
    GROUP_C_BGR *groupC_bgr;

#ifdef USE_DTDEVICES
    DTDevices *dtdev;
    NSMutableArray *btDevices;
#endif
    
#ifdef USE_EACCESSORY
    EAAccessory *acc;
    EASession *accSession;
    bool accConnected;
    NSTimer *testTimer;
    int testPasses;
#endif
}

#ifdef USE_DTDEVICES
-(IBAction)onDiscover:(id)sender;
-(IBAction)onConnect:(id)sender;
-(IBAction)onDisconnect:(id)sender;
#endif

-(IBAction)onTest:(id)sender;

@end
