
//
//  ViewController.m
//  FiscalDemo
//
//  Created by Flex on 9/4/12.
//  Copyright (c) 2012 Datecs. All rights reserved.
//


#import "MainViewController.h"

@interface MainViewController ()

@end

@implementation MainViewController

-(BOOL)textFieldShouldEndEditing:(UITextField *)theTextField;
{
    return YES;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField;
{
    [textField resignFirstResponder];
    return YES;
}


-(void)displayAlert:(NSString *)title message:(NSString *)message
{
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil, nil];
	[alert show];
}

#define ERRMSG(title) {UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:error.localizedDescription delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil, nil]; [alert show];}

#ifdef USE_DTDEVICES

-(void)connectionState:(int)state {
    NSDateFormatter *dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateStyle:NSDateFormatterLongStyle];
    
	switch (state) {
		case CONN_DISCONNECTED:
		case CONN_CONNECTING:
			[displayText setText:[NSString stringWithFormat:@"Device not connected\nSDK: ver %d.%d (%@)",dtdev.sdkVersion/100,dtdev.sdkVersion%100,[dateFormat stringFromDate:dtdev.sdkBuildDate]]];
			break;
		case CONN_CONNECTED:
			[displayText setText:[NSString stringWithFormat:@"SDK: ver %d.%d (%@)\n%@ %@ connected\nHardware revision: %@\nFirmware revision: %@\nSerial number: %@",dtdev.sdkVersion/100,dtdev.sdkVersion%100,[dateFormat stringFromDate:dtdev.sdkBuildDate],dtdev.deviceName,dtdev.deviceModel,dtdev.hardwareRevision,dtdev.firmwareRevision,dtdev.serialNumber]];
            
			[printersTable reloadData];
			break;
	}
}

-(void)barcodeData:(NSString *)barcode type:(int)type
{
    [self displayAlert:@"Barcode" message:[NSString stringWithFormat:@"Type: %@\nBarcode: %@",[dtdev barcodeType2Text:type],barcode]];
}


-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
	if(buttonIndex == 1)
	{
        [self discoverPrinters];
	}
}

-(IBAction)onDiscover:(id)sender
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Bluetooth Discover"
                                                   message:@"Bluetooth discover will clean out current list of devices. If your printer is set to save pairing info and gets non-discoverable after the first connection, it will not be found anymore. Do you want to proceed?"
                                                   delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"Ok", nil];
    [alert show];
}

-(void)discoverPrinters
{
    NSError *error;
    
    [btDevices removeAllObjects];
    [printersTable reloadData];
    
    [progressViewController viewWillAppear:FALSE];
    [self.view addSubview:progressViewController.view];
    [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.01]];
    if(![dtdev btDiscoverDevicesInBackground:8 maxTime:10 codTypes:0 error:&error])
    {
        [progressViewController.view removeFromSuperview];
        ERRMSG(@"Bluetooth Error");
    }
}

-(void)deviceFeatureSupported:(int)feature value:(int)value
{
    if(feature==FEAT_BLUETOOTH)
    {
        [printersTable reloadData];
    }
}


-(void)bluetoothDeviceDiscovered:(NSString *)btAddress name:(NSString *)btName
{
    if([btName isEqualToString:@"FMP-10"])
    {
        [btDevices addObject:btAddress];
        [btDevices addObject:btName];
    }
}

-(void)bluetoothDiscoverComplete:(BOOL)success
{
    [progressViewController.view removeFromSuperview];
    
	NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    [prefs setObject:btDevices forKey:@"bluetoothDevices"];
    [prefs synchronize];
    
    [printersTable reloadData];
    if(!success)
        [self displayAlert:@"Bluetooth Error" message:@"Printer discovery failed!"];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Number of sections is the number of region dictionaries
    return 1;
}

- (NSString *)tableView:(UITableView *)aTableView titleForHeaderInSection:(NSInteger)section {
	return @"Fiscal Printers";
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Number of rows is the number of names in the region dictionary for the specified section
    if([dtdev getSupportedFeature:FEAT_BLUETOOTH error:nil]!=FEAT_UNSUPPORTED)
        return [btDevices count]/2;
    else
        return 0;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSError *error=nil;
    
	if(dtdev.connstate!=CONN_CONNECTED)
		return;
	
    [progressViewController viewWillAppear:FALSE];
    [self.view addSubview:progressViewController.view];
    [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.01]];
    
    NSString *selectedAddress=[btDevices objectAtIndex:indexPath.row*2];
    
    if([dtdev.btConnectedDevices containsObject:selectedAddress])
    {
        [dtdev btDisconnect:selectedAddress error:nil];
    }else
    {
        NSError *error=nil;
        if([dtdev btConnect:selectedAddress pin:@"0000" error:&error])
        {
            NSLog(@"error: %@",error.localizedDescription);
            if(![fp_bgr connectWithStreams:dtdev.btInputStream outputStream:dtdev.btOutputStream error:&error])
            {
                [dtdev btDisconnect:selectedAddress error:nil];
                ERRMSG(NSLocalizedString(@"Fiscal device connection failed",nil));
            }
        }
        NSLog(@"error: %@",error.localizedDescription);
    }
    
    [progressViewController.view removeFromSuperview];
    [tableView reloadData];

    if(error)
        ERRMSG(NSLocalizedString(@"Bluetooth Error",nil));
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	UITableViewCell *cell=[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"SettingsCell"];
	
    [cell.textLabel setText:[btDevices objectAtIndex:indexPath.row*2+1]];
    [cell.detailTextLabel setText:[btDevices objectAtIndex:indexPath.row*2]];
    if([dtdev.btConnectedDevices containsObject:[btDevices objectAtIndex:indexPath.row*2]])
        cell.accessoryType=UITableViewCellAccessoryCheckmark;
    else
        cell.accessoryType=UITableViewCellAccessoryNone;

	return cell;
}
#endif

#ifdef USE_EACCESSORY
-(BOOL)connectToAccessory:(EAAccessory *)accessory
{
    NSError *error;
    
    accSession=[[EASession alloc] initWithAccessory:accessory forProtocol:[accessory.protocolStrings objectAtIndex:0]];
    if(!accSession)
    {//bail out
        [NSThread sleepForTimeInterval:0.1];
        accSession=[[EASession alloc] initWithAccessory:accessory forProtocol:[accessory.protocolStrings objectAtIndex:0]];
        if(!accSession)
            return false;
    }
    //for romanian printers
//    if(![fmp10_rou connectWithStreams:accSession.inputStream outputStream:accSession.outputStream error:&error])
    //for bulgarian printers
    int protocol = 0;
    if([[accessory.protocolStrings objectAtIndex:0] isEqualToString:@"com.datecs.printer.fiscal.2"])
        protocol=1;
//    if(![fmp350_bgr connectWithStreams:accSession.inputStream outputStream:accSession.outputStream packetFormat:protocol error:&error])
//    if(![fp_bgr connectWithStreams:accSession.inputStream outputStream:accSession.outputStream packetFormat:protocol error:&error])
    //generic fiscal printer
//    if(![fiscalPrinter connectWithStreams:accSession.inputStream outputStream:accSession.outputStream packetFormat:protocol error:&error])
    if(![groupC_bgr connectWithStreams:accSession.inputStream outputStream:accSession.outputStream packetFormat:protocol error:&error])
    {
        ERRMSG(NSLocalizedString(@"Fiscal device connection failed",nil));
        return false;
    }

        NSDictionary *tmpResult;

        groupC_bgr.sellParameterOperatorCode = @"1";
        groupC_bgr.sellParameterOperatorPassword = @"0000";
        groupC_bgr.sellParameterOperatorTillNumber = @"1";

        tmpResult = [groupC_bgr receipt_NonFiscal_OpenAndReturnError:&error];
        if(tmpResult)
        {
            if (![groupC_bgr receipt_NonFiscal_TextInputText:@" Демонстрация на печат" bold:@"" italic:@"" height:@"" underLine:@"" alignment:@"" error:&error]) return 0;
            if (![groupC_bgr receipt_NonFiscal_TextInputText:@" в рамките на нефискален бон." bold:@"" italic:@"" height:@"" underLine:@"" alignment:@"" error:&error]) return 0;

            tmpResult = [groupC_bgr receipt_NonFiscal_CloseAndReturnError:&error];
            return true;
        }else
            return false;


//    NSDictionary *tmpResult;
//
//    fmp350_bgr.sellParameterOperatorCode = @"1";
//    fmp350_bgr.sellParameterOperatorPassword = @"0000";
//    fmp350_bgr.sellParameterOperatorTillNumber = @"1";
//
//    tmpResult = [fmp350_bgr fiscalReceiptOpenAndReturnError:&error];
//    if(tmpResult)
//    {
//        if (![fmp350_bgr fiscalReceiptPrintText:@" Демонстрация на печат" error:&error]) return 0;
//        if (![fmp350_bgr fiscalReceiptPrintText:@" в рамките на фискален бон." error:&error]) return 0;
//
//        fmp350_bgr.sellParameterTextRow1 = @" Първи ред в продажбата ";
//        fmp350_bgr.sellParameterTextRow2 = @"";
//        fmp350_bgr.sellParameterTaxGroup = @"B";
//        fmp350_bgr.sellParameterPrice = @"0.01";
//        fmp350_bgr.sellParameterQuantity = @"1.00";
//        if (![fmp350_bgr fiscalReceiptSellAndReturnError:&error]) return 0;
//
//
//        fmp350_bgr.totalParameterPaidMode = @"0";
//        fmp350_bgr.totalParameterAmount = @"0.01";
//        if (![fmp350_bgr fiscalReceiptTotalAndReturnError:&error]) return 0;
//
//        if (![fmp350_bgr fiscalReceiptCloseAndReturnError:&error]) return 0;
//    }

//    NSDictionary *tmpResult;
//    tmpResult = [fmp350_bgr nonFiscalReceiptOpenAndReturnError:&error];
//    if(tmpResult)
//    {
//        if (![fmp350_bgr nonFiscalReceiptPrintText:@" Демонстрация на печат" error:&error]) return false;
//        if (![fmp350_bgr nonFiscalReceiptPrintText:@" в рамките на нефискален бон." error:&error]) return false;
//        tmpResult = [fmp350_bgr nonFiscalReceiptCloseAndReturnError:&error];
//        return true;
//    }else
//        return false;

    return true;
}

-(EAAccessory *)findAccessory:(NSString *)channel
{
    NSArray *accessories = [[EAAccessoryManager sharedAccessoryManager]	connectedAccessories];
    
    for (EAAccessory *obj in accessories)
    {
        NSLog(@"EAAccessoryDidConnect: connectionID:%d name:%@ "
            "manufacturer:%@ modelNumber:%@ serialNumber:%@ "
            "firmwareRevision:%@ hardwareRevision:%@ protocolStrings:%@ ",
            obj.connectionID, obj.name, obj.manufacturer,
            obj.modelNumber, obj.serialNumber, obj.firmwareRevision,
            obj.hardwareRevision, obj.protocolStrings);
        
        if(obj && obj.name && obj.protocolStrings && obj.protocolStrings.count>0 && [[[obj.protocolStrings objectAtIndex:0] lowercaseString] isEqualToString:[channel lowercaseString]])
        {
            return obj;
        }
    }
    
    return nil;
}

-(void)EAAccessoryDidConnect:(NSNotification *)notification
{
    if(!accConnected)
    {
        accConnected=true;
        acc=[self findAccessory:@"com.datecs.printer.fiscal"];
        if(!acc)
            acc=[self findAccessory:@"com.datecs.printer.fiscal.2"];
        if(acc)
        {
            accConnected=[self connectToAccessory:acc];
            NSLog(@"Connect result1: %d",accConnected);
            
            if(accConnected)
            {//do something on a background thread
//                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
//                    NSError *error;
//                    //just read the curent (not last) status bytes, sample command
//                    [fmp10_rou getStatusBytesAndReturnError:&error];
//                    //sample - print
//                    [fmp10_rou nonFiscalReceiptOpenAndReturnError:&error];
//                    [fmp10_rou nonFiscalReceiptPrintText:@" Demonstation print" error:&error];
//                    [fmp10_rou nonFiscalReceiptPrintText:@" inside nonfiscal receipt." error:&error];
//                    [fmp10_rou nonFiscalReceiptCloseAndReturnError:&error];
//                });
            }
        }else
            accConnected=false;
    }
    if(accConnected)
        accLabel.text=@"Connected!";
    else
        accLabel.text=@"Disconnected!";
}

-(void)EAAccessoryDidDisconnect:(NSNotification *)notification
{
    if(accConnected/* && ![self findAccessory:@"com.datecs.printer.fiscal"]*/)
    {
        //[fmp350_bgr disconnect];
//        [fp_bgr disconnect];
        [fiscalPrinter disconnect];
        accConnected=false;
    }
    if(accConnected)
        accLabel.text=@"Connected!";
    else
        accLabel.text=@"Disconnected!";
}
#endif


-(void)deviceConnected
{
}

-(void)deviceDisconnected
{
    [printersTable reloadData];
}

#ifdef USE_EACCESSORY


-(BOOL)fiscalReceipt:(NSError **)error
{
    fmp10_rou.sellParameterOperatorCode = @"1";
    fmp10_rou.sellParameterOperatorPassword = @"0000";
    fmp10_rou.sellParameterOperatorTillNumber = @"1";
    
    NSDictionary *tmpResult;
    tmpResult = [fmp10_rou fiscalReceiptOpenAndReturnError:error];
    if(tmpResult)
    {
        if (![fmp10_rou fiscalReceiptPrintText:@" Demonstation fiscal receipt" error:error]) return false;
        
        fmp10_rou.sellParameterTextRow1 = @" Text row 1 ";
        fmp10_rou.sellParameterTextRow2 = @" Text row 2 ";
        fmp10_rou.sellParameterTaxGroup = @"B";
        fmp10_rou.sellParameterPrice = @"1.00";
        fmp10_rou.sellParameterQuantity = @"3.00";
        if (![fmp10_rou fiscalReceiptSellAndReturnError:error]) return 0;
        
        if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
        if (![fmp10_rou fiscalReceiptPrintText:@" Subtotal demo " error:error]) return 0;
        if (![fmp10_rou fiscalReceiptPrintText:@" and 99% discount " error:error]) return 0;
        fmp10_rou.subtotalParameterPercent = @"-99.00";
        tmpResult = [fmp10_rou fiscalReceiptSubtotalAndReturnError:error];
        if (!tmpResult) return 0;
        
        fmp10_rou.totalParameterTextRow1 = @" Text row 1 ";
        fmp10_rou.totalParameterTextRow2 = @" Text row 2 ";
        fmp10_rou.totalParameterPaidMode = @"P";
        fmp10_rou.totalParameterAmount = @"20.00";
        if (![fmp10_rou fiscalReceiptTotalAndReturnError:error]) return 0;
        
        if (![fmp10_rou fiscalReceiptCloseAndReturnError:error]) return 0;
        return true;
    }
    return false;
}
-(void)testTimerFunc
{
    NSError *error;
    if(![self fiscalReceipt:&error])
    {
        [testButton setTitle:@"Start Testing" forState:UIControlStateNormal];
        [testTimer invalidate];
        testTimer=nil;
        testLabel.text=[NSString stringWithFormat:@"Test failed, runs: %d",testPasses];
    }else
    {
        testPasses++;
        [self testUpdateStats];
    }
}

-(void)testUpdateStats
{
    if(testTimer)
        testLabel.text=[NSString stringWithFormat:@"Test runs: %d",testPasses];
}

-(IBAction)onTest:(id)sender
{
    if(!testTimer)
    {
        if(accConnected)
        {
            testTimer=[NSTimer scheduledTimerWithTimeInterval:testTimeField.text.integerValue target:self selector:@selector(testTimerFunc) userInfo:nil repeats:true];
            testPasses=0;
            [testButton setTitle:@"Stop Testing" forState:UIControlStateNormal];
            [self testUpdateStats];
        }
    }else
    {
        [testButton setTitle:@"Start Testing" forState:UIControlStateNormal];
        [testTimer invalidate];
        testTimer=nil;
        testLabel.text=[NSString stringWithFormat:@"Test stopped runs: %d",testPasses];
    }
    
}

-(IBAction)onDemo:(id)sender
{
    NSError *error;
    NSDictionary *tmpResult;
    tmpResult = [fp_bgr nonFiscalReceiptOpenAndReturnError:&error];
    if(tmpResult)
    {
        if (![fp_bgr nonFiscalReceiptPrintText:@" Демонстрация на печат" error:&error])
        {
            ERRMSG(@"Failed1");
        }
        if (![fp_bgr nonFiscalReceiptPrintText:@" в рамките на нефискален бон." error:&error])
        {
            ERRMSG(@"Failed2");
        }
        tmpResult = [fp_bgr nonFiscalReceiptCloseAndReturnError:&error];
    }else
        ERRMSG(@"Failed3");
}
#endif

- (void)viewWillAppear:(BOOL)animated
{
	//update display according to current dtdev state
#ifdef USE_DTDEVICES
	[self connectionState:dtdev.connstate];
#endif
    
#ifdef USE_EACCESSORY
    [self EAAccessoryDidConnect:nil];
#endif
}

-(void)UIApplicationDidEnterBackground:(NSNotification *)notification
{
#ifdef USE_EACCESSORY
    NSLog(@"UIApplicationDidEnterBackground");
    [self EAAccessoryDidDisconnect:nil];
#endif
}

-(void)UIApplicationWillEnterForeground:(NSNotification *)notification
{
#ifdef USE_EACCESSORY
    NSLog(@"UIApplicationWillEnterForeground");
    [self EAAccessoryDidConnect:nil];
#endif
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    //The fiscal printers bulgaria implementation
    fp_bgr=[FP_BGR sharedInstance];
    [fp_bgr addDelegate:self];

    //The fmp10
    fmp10_rou=[FMP10_ROU sharedInstance];
    [fmp10_rou addDelegate:self];

    //FMP-350
    fmp350_bgr=[FMP350_BGR sharedInstance];
    [fmp350_bgr addDelegate:self];
    
    //The generic FiscalPrinter implementation, used when accessory connects
    fiscalPrinter=[fpBase sharedInstance];
    fiscalPrinter.delegate=self;

    groupC_bgr=[GROUP_C_BGR sharedInstance];
    groupC_bgr.delegate=self;

#ifdef USE_DTDEVICES
    dtdev=[DTDevices sharedDevice];
    [dtdev addDelegate:self];
    [dtdev connect];

	NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    
	btDevices=[[prefs arrayForKey:@"bluetoothDevices"] mutableCopy];
    if(!btDevices)
        btDevices=[[NSMutableArray alloc] init];
    [printersTable reloadData];
#endif

#ifdef USE_EACCESSORY
    accConnected=false;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(EAAccessoryDidConnect:) name:EAAccessoryDidConnectNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(EAAccessoryDidDisconnect:) name:EAAccessoryDidDisconnectNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(UIApplicationDidEnterBackground:) name:UIApplicationDidEnterBackgroundNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(UIApplicationWillEnterForeground:) name:UIApplicationWillEnterForegroundNotification object:nil];
    [[EAAccessoryManager sharedAccessoryManager] registerForLocalNotifications];
#endif
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}


@end
