//
//  FMP350_BGR.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 23.02.2016
//  Modified on 23.02.2016
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface FMP350_BGR : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream packetFormat:(int)format error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) BOOL deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) BOOL infoMandatoryZReportEndOfDay;
@property(readonly) BOOL infoMandatoryEKLPrintBeforeZReport;
@property(readonly) BOOL infoMandatoryEKLSave;
@property(readonly) BOOL infoMandatoryMonthlyReport;
@property(readonly) BOOL infoMandatoryYearlyReport;
@property(readonly) BOOL statusDisplayNotConnected;
@property(readonly) BOOL statusTransparentDisplayMode;
@property(readonly) BOOL statusFiscalMemoryMissing;
@property(readonly) BOOL statusPrintingHeadOverheated;
@property(readonly) BOOL statusSeconRollNoPaperPlace;
@property(readonly) BOOL statusSeconRollOutOfPaper;
@property(readonly) BOOL statusEndOfEKL;
@property(readonly) BOOL statusDrawerOpened;
@property(readonly) BOOL statusEKLNotEmpty;
@property(readonly) BOOL statusEKLPrinted;
@property(readonly) BOOL statusEKLNearEnd;
@property(readonly) BOOL statusKLENNearEnd;
@property(readonly) BOOL statusSecondRollNotEnoughPaper;
@property(readonly) BOOL statusAutomaticPaperCutting;
@property(readonly) BOOL statusPrintingHeadNotConnected;
@property(readonly) BOOL supportEKL;
@property(readonly) BOOL supportNRATerminal;
@property(readonly) BOOL supportKLEN;
@property(readonly) BOOL supportEIK;
@property(readonly) BOOL supportServiceContractsInformation;
@property(readonly) BOOL supportIOSANumber;
@property(readonly) BOOL supportFiscalReceipts;
@property(readonly) BOOL supportRotatedFiscalReceipts;
@property(readonly) BOOL supportNonFiscalReceipts;
@property(readonly) BOOL supportRotatedNonFiscalReceipts;
@property(readonly) BOOL supportBluetooth;
@property(readonly) BOOL supportWiFi;
@property(readonly) BOOL supportTCPIP;
@property(readonly) BOOL supportFTP;
@property(readonly) BOOL supportHTTP;
@property(readonly) BOOL supportSoftwareSwitches;
@property(readonly) BOOL supportClientDisplay;
@property(readonly) BOOL supportDrawerOpening;
@property(readonly) BOOL supportDrawerStatus;
@property(readonly) BOOL supportSecondRoll;
@property(readonly) BOOL supportAutoCutPaper;
@property(readonly) BOOL supportAdditionalMatrixPrint;
@property(readonly) BOOL supportPrintingHeadTemperatureControl;
@property(readonly) BOOL supportAsynchronousMode;
@property(readonly) BOOL supportTransactionsBufferForCommands;
@property(readonly) BOOL supportReceiptVoid;
@property(readonly) BOOL supportSaleRowVoid;
@property(readonly) BOOL supportVoidReceipt;
@property(readonly) BOOL supportVoidSale;
@property(readonly) BOOL statusEIKSet;
@property(readonly) BOOL statusSerialNumberSet;
@property(readonly) BOOL statusFMNumberSet;
@property(readonly) BOOL statusPrinterFiscalized;
@property(readonly) BOOL statusFiscalMemoryFormated;
@property(readonly) BOOL statusTaxRatesOk;
@property(readonly) BOOL statusLowBattery;
@property(readonly) BOOL statusGeneralErrorType1;
@property(readonly) BOOL statusGeneralErrorType2;
@property(readonly) BOOL statusPrintingHeadFailure;
@property(readonly) BOOL statusPrinterClockNotSet;
@property(readonly) BOOL statusInvalidCommand;
@property(readonly) BOOL statusSyntaxError;
@property(readonly) BOOL statusNRATerminalNotRespond;
@property(readonly) BOOL statusRamError;
@property(readonly) BOOL statusRamCleared;
@property(readonly) BOOL statusCommandNotAllowed;
@property(readonly) BOOL statusFieldOverflow;
@property(readonly) BOOL statusFiscalMemoryFull;
@property(readonly) BOOL statusFiscalMemoryReadError;
@property(readonly) BOOL statusFiscalMemoryWriteError;
@property(readonly) BOOL statusFiscalMemoryReadOnly;
@property(readonly) BOOL statusOutOfPaper;
@property(readonly) BOOL statusEndOfKLEN;
@property(readonly) BOOL statusFiscalReceiptOpened;
@property(readonly) BOOL statusNonFiscalReceiptOpened;
@property(readonly) BOOL statusRotatedReceiptOpened;
@property(readonly) BOOL statusFiscalMemoryNearEnd;
@property(readonly) BOOL statusCoverWasOpened;
@property(readonly) BOOL statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) BOOL infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterAdjustmentType;
@property(copy) NSString *sellParameterAdjustmentValue;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *subtotalParameterAdjustmentType;
@property(copy) NSString *subtotalParameterAdjustmentValue;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;
@property(copy) NSString *dailyReportType;



/* human-oriented interface - begin */

///*some informations*/
-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;
-(BOOL)diagnosticInfoPrintAndReturnError:(NSError **)error;
//
///*non-fiscal bon*/
-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;
-(BOOL)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;
//
///*fiscal bon*/
-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
-(BOOL)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
-(BOOL)fiscalReceiptSellAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;
-(BOOL)printBarcodeDataType:(NSString *)dataType dataValue:(NSString *)dataValue error:(NSError **)error;
//
///*emergency*/
-(BOOL)checkAndResolveAndReturnError:(NSError **)error;
//
//Report
-(BOOL)printDailyReportAndReturnError:(NSError **)error;



/* human-oriented interface - end */



/* machine-oriented interface - begin */    
	-(NSDictionary *)command38Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command39Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command42Variant0Version0Text:(NSString *)text error:(NSError **)error ;
    -(NSDictionary *)command44Variant0Version0Lines:(NSString *)lines error:(NSError **)error ;
    -(NSDictionary *)command45Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command48Variant0Version0OpCode:(NSString *)opCode opPwd:(NSString *)opPwd tillNmb:(NSString *)tillNmb invoice:(NSString *)invoice error:(NSError **)error ;
    -(NSDictionary *)command49Variant0Version0PluName:(NSString *)pluName taxCd:(NSString *)taxCd price:(NSString *)price quantity:(NSString *)quantity discountType:(NSString *)discountType discountValue:(NSString *)discountValue department:(NSString *)department error:(NSError **)error ;
    -(NSDictionary *)command50Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command51Variant0Version0Print:(NSString *)print discountType:(NSString *)discountType discountValue:(NSString *)discountValue error:(NSError **)error ;
    -(NSDictionary *)command53Variant0Version0PaidMode:(NSString *)paidMode amount:(NSString *)amount error:(NSError **)error ;
    -(NSDictionary *)command53Variant1Version0PaidMode:(NSString *)paidMode amount:(NSString *)amount change:(NSString *)change error:(NSError **)error ;
    -(NSDictionary *)command54Variant0Version0Text:(NSString *)text error:(NSError **)error ;
    -(NSDictionary *)command56Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command57Variant0Version0Seller:(NSString *)seller receiver:(NSString *)receiver buyer:(NSString *)buyer address1:(NSString *)address1 address2:(NSString *)address2 typeTAXN:(NSString *)typeTAXN tAXN:(NSString *)tAXN vATN:(NSString *)vATN error:(NSError **)error ;
    -(NSDictionary *)command58Variant0Version0PluCode:(NSString *)pluCode quanity:(NSString *)quanity price:(NSString *)price discountType:(NSString *)discountType discountValue:(NSString *)discountValue error:(NSError **)error ;
    -(NSDictionary *)command60Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command61Variant0Version0DateTime:(NSString *)dateTime error:(NSError **)error ;
    -(NSDictionary *)command62Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command64Variant0Version0Type:(NSString *)type error:(NSError **)error ;
    -(NSDictionary *)command65Variant0Version0Type:(NSString *)type error:(NSError **)error ;
    -(NSDictionary *)command66Variant0Version0Start:(NSString *)start end:(NSString *)end error:(NSError **)error ;
    -(NSDictionary *)command66Variant1Version0End:(NSString *)end error:(NSError **)error ;
    -(NSDictionary *)command68Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command69Variant0Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command70Variant0Version0Type:(NSString *)type amount:(NSString *)amount error:(NSError **)error ;
    -(NSDictionary *)command71Variant0Version0InfoType:(NSString *)infoType error:(NSError **)error ;
    -(NSDictionary *)command72Variant0Version0SerialNumber:(NSString *)serialNumber tAXnumber:(NSString *)tAXnumber error:(NSError **)error ;
    -(NSDictionary *)command74Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command76Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command80Variant0Version0Hz:(NSString *)hz mSec:(NSString *)mSec error:(NSError **)error ;
    -(NSDictionary *)command83Variant0Version0TaxA:(NSString *)taxA taxB:(NSString *)taxB taxC:(NSString *)taxC taxD:(NSString *)taxD taxE:(NSString *)taxE taxF:(NSString *)taxF taxG:(NSString *)taxG taxH:(NSString *)taxH decimalPoint:(NSString *)decimalPoint error:(NSError **)error ;
    -(NSDictionary *)command84Variant0Version0BarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData error:(NSError **)error ;
    -(NSDictionary *)command86Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command87Variant0Version0ItemGroup:(NSString *)itemGroup error:(NSError **)error ;
    -(NSDictionary *)command88Variant0Version0DepartmentNumber:(NSString *)departmentNumber error:(NSError **)error ;
    -(NSDictionary *)command89Variant0Version0TestType:(NSString *)testType error:(NSError **)error ;
    -(NSDictionary *)command90Variant0Version0NewFormat:(NSString *)newFormat error:(NSError **)error ;
    -(NSDictionary *)command90Variant1Version0Calculate:(NSString *)calculate error:(NSError **)error ;
    -(NSDictionary *)command91Variant0Version0SerialNumber:(NSString *)serialNumber fMnumber:(NSString *)fMnumber error:(NSError **)error ;
    -(NSDictionary *)command92Variant0Version0Type:(NSString *)type error:(NSError **)error ;
    -(NSDictionary *)command94Variant0Version0Type:(NSString *)type startDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error ;
    -(NSDictionary *)command95Variant0Version0Type:(NSString *)type startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    -(NSDictionary *)command98Variant0Version0TAXnumber:(NSString *)tAXnumber error:(NSError **)error ;
    -(NSDictionary *)command99Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command100Variant0Version0Code:(NSString *)code error:(NSError **)error ;
    -(NSDictionary *)command101Variant0Version0OperatorCode:(NSString *)operatorCode oldPassword:(NSString *)oldPassword newPassword:(NSString *)newPassword error:(NSError **)error ;
    -(NSDictionary *)command103Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command105Variant0Version0FirstOper:(NSString *)firstOper lastOper:(NSString *)lastOper clear:(NSString *)clear error:(NSError **)error ;
    -(NSDictionary *)command107Variant0Version0Option:(NSString *)option error:(NSError **)error ;
    -(NSDictionary *)command107Variant1Version0Option:(NSString *)option PLU:(NSString *)PLU taxGr:(NSString *)taxGr dep:(NSString *)dep group:(NSString *)group priceType:(NSString *)priceType price:(NSString *)price addQty:(NSString *)addQty quantity:(NSString *)quantity bar1:(NSString *)bar1 bar2:(NSString *)bar2 bar3:(NSString *)bar3 bar4:(NSString *)bar4 itemName:(NSString *)itemName error:(NSError **)error ;
    -(NSDictionary *)command107Variant2Version0Option:(NSString *)option PLU:(NSString *)PLU quantity:(NSString *)quantity error:(NSError **)error ;
    -(NSDictionary *)command107Variant3Version0Option:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant3Version1Option:(NSString *)option deleteAll:(NSString *)deleteAll lastPLU:(NSString *)lastPLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant4Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant5Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant6Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant7Version0Option:(NSString *)option error:(NSError **)error ;
    -(NSDictionary *)command107Variant8Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant9Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant10Version0Option:(NSString *)option error:(NSError **)error ;
    -(NSDictionary *)command107Variant11Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command107Variant12Version0Option:(NSString *)option PLU:(NSString *)PLU error:(NSError **)error ;
    -(NSDictionary *)command109Variant0Version0AndReturnError:(NSError **)error ;
    -(NSDictionary *)command110Variant0Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command110Variant1Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command110Variant2Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command110Variant3Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command110Variant4Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command110Variant5Version0ReportType:(NSString *)reportType error:(NSError **)error ;
    -(NSDictionary *)command111Variant0Version0ReportType:(NSString *)reportType startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    -(NSDictionary *)command112Variant0Version0Operator:(NSString *)operator error:(NSError **)error ;
    -(NSDictionary *)command116Variant0Version0Operation:(NSString *)operation address:(NSString *)address nBytes:(NSString *)nBytes error:(NSError **)error ;
    -(NSDictionary *)command124Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate type:(NSString *)type error:(NSError **)error ;
    -(NSDictionary *)command125Variant0Version0Option:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;
    -(NSDictionary *)command125Variant1Version0Option:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;
    -(NSDictionary *)command125Variant2Version0Option:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;
    -(NSDictionary *)command125Variant3Version0Option:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;

/* machine-oriented interface - end */


@end
