//
//  GROUP_A_BGR.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 08.06.2019
//  Modified on 08.06.2019
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface GROUP_A_BGR : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream packetFormat:(int)format error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) BOOL deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) BOOL infoMandatoryZReportEndOfDay;
@property(readonly) BOOL infoMandatoryEKLPrintBeforeZReport;
@property(readonly) BOOL infoMandatoryEKLSave;
@property(readonly) BOOL infoMandatoryMonthlyReport;
@property(readonly) BOOL infoMandatoryYearlyReport;
@property(readonly) BOOL statusDisplayNotConnected;
@property(readonly) BOOL statusTransparentDisplayMode;
@property(readonly) BOOL statusFiscalMemoryMissing;
@property(readonly) BOOL statusPrintingHeadOverheated;
@property(readonly) BOOL statusSeconRollNoPaperPlace;
@property(readonly) BOOL statusSeconRollOutOfPaper;
@property(readonly) BOOL statusEndOfEKL;
@property(readonly) BOOL statusDrawerOpened;
@property(readonly) BOOL statusEKLNotEmpty;
@property(readonly) BOOL statusEKLPrinted;
@property(readonly) BOOL statusEKLNearEnd;
@property(readonly) BOOL statusKLENNearEnd;
@property(readonly) BOOL statusSecondRollNotEnoughPaper;
@property(readonly) BOOL statusAutomaticPaperCutting;
@property(readonly) BOOL statusPrintingHeadNotConnected;
@property(readonly) BOOL supportEKL;
@property(readonly) BOOL supportNRATerminal;
@property(readonly) BOOL supportKLEN;
@property(readonly) BOOL supportEIK;
@property(readonly) BOOL supportServiceContractsInformation;
@property(readonly) BOOL supportIOSANumber;
@property(readonly) BOOL supportFiscalReceipts;
@property(readonly) BOOL supportRotatedFiscalReceipts;
@property(readonly) BOOL supportNonFiscalReceipts;
@property(readonly) BOOL supportRotatedNonFiscalReceipts;
@property(readonly) BOOL supportBluetooth;
@property(readonly) BOOL supportWiFi;
@property(readonly) BOOL supportTCPIP;
@property(readonly) BOOL supportFTP;
@property(readonly) BOOL supportHTTP;
@property(readonly) BOOL supportSoftwareSwitches;
@property(readonly) BOOL supportClientDisplay;
@property(readonly) BOOL supportDrawerOpening;
@property(readonly) BOOL supportDrawerStatus;
@property(readonly) BOOL supportSecondRoll;
@property(readonly) BOOL supportAutoCutPaper;
@property(readonly) BOOL supportAdditionalMatrixPrint;
@property(readonly) BOOL supportPrintingHeadTemperatureControl;
@property(readonly) BOOL supportAsynchronousMode;
@property(readonly) BOOL supportTransactionsBufferForCommands;
@property(readonly) BOOL supportReceiptVoid;
@property(readonly) BOOL supportSaleRowVoid;
@property(readonly) BOOL supportVoidReceipt;
@property(readonly) BOOL supportVoidSale;
@property(readonly) BOOL statusEIKSet;
@property(readonly) BOOL statusSerialNumberSet;
@property(readonly) BOOL statusFMNumberSet;
@property(readonly) BOOL statusPrinterFiscalized;
@property(readonly) BOOL statusFiscalMemoryFormated;
@property(readonly) BOOL statusTaxRatesOk;
@property(readonly) BOOL statusLowBattery;
@property(readonly) BOOL statusGeneralErrorType1;
@property(readonly) BOOL statusGeneralErrorType2;
@property(readonly) BOOL statusPrintingHeadFailure;
@property(readonly) BOOL statusPrinterClockNotSet;
@property(readonly) BOOL statusInvalidCommand;
@property(readonly) BOOL statusSyntaxError;
@property(readonly) BOOL statusNRATerminalNotRespond;
@property(readonly) BOOL statusRamError;
@property(readonly) BOOL statusRamCleared;
@property(readonly) BOOL statusCommandNotAllowed;
@property(readonly) BOOL statusFieldOverflow;
@property(readonly) BOOL statusFiscalMemoryFull;
@property(readonly) BOOL statusFiscalMemoryReadError;
@property(readonly) BOOL statusFiscalMemoryWriteError;
@property(readonly) BOOL statusFiscalMemoryReadOnly;
@property(readonly) BOOL statusOutOfPaper;
@property(readonly) BOOL statusEndOfKLEN;
@property(readonly) BOOL statusFiscalReceiptOpened;
@property(readonly) BOOL statusNonFiscalReceiptOpened;
@property(readonly) BOOL statusRotatedReceiptOpened;
@property(readonly) BOOL statusFiscalMemoryNearEnd;
@property(readonly) BOOL statusCoverWasOpened;
@property(readonly) BOOL statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) BOOL infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterAdjustmentType;
@property(copy) NSString *sellParameterAdjustmentValue;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *subtotalParameterAdjustmentType;
@property(copy) NSString *subtotalParameterAdjustmentValue;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;
@property(copy) NSString *dailyReportType;



/* human-oriented interface - begin */

/////*some informations*/
//-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;
//-(BOOL)diagnosticInfoPrintAndReturnError:(NSError **)error;
////
/////*non-fiscal bon*/
//-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;
////
/////*fiscal bon*/
//-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(BOOL)fiscalReceiptSellAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;
//-(BOOL)printBarcodeDataType:(NSString *)dataType dataValue:(NSString *)dataValue error:(NSError **)error;
//
///*emergency*/
-(BOOL)checkAndResolveAndReturnError:(NSError **)error;
//
////Report
//-(BOOL)printDailyReportAndReturnError:(NSError **)error;



/* human-oriented interface - end */



/* machine-oriented interface - begin */

    // Command number(Dec): 33 - please check fiscal device documentation.
    -(BOOL)display_ClearAndReturnError:(NSError **)error ;
    // Command number(Dec): 35 - please check fiscal device documentation.
    -(BOOL)display_Show_LowerLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 47 - please check fiscal device documentation.
    -(BOOL)display_Show_UpperLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 63 - please check fiscal device documentation.
    -(BOOL)display_Show_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 100 - please check fiscal device documentation.
    -(BOOL)display_Show_TextTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 38 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_OpenAndReturnError:(NSError **)error ;
    // Command number(Dec): 39 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(BOOL)receipt_NonFiscal_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(BOOL)receipt_PNonFiscal_Textheight:(NSString *)height flags:(NSString *)flags inputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 122 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscalRotated_OpenAndReturnError:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(BOOL)receipt_NonFiscalRotated_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 124 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscalRotated_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A05OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A06OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A07OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A08OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A09OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A10OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A11OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A12OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A13OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A14OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A15OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_A16OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber uNP:(NSString *)uNP stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoUNP:(NSString *)stornoUNP stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_01_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_02_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_A01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_A03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber uNP:(NSString *)uNP error:(NSError **)error ;
    // Command number(Dec): 56 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Invoice_01_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_A02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_A04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice uNP:(NSString *)uNP error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Invoice_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice uNP:(NSString *)uNP error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_01EIKType:(NSString *)eIKType eIK:(NSString *)eIK error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_02EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_03EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_04EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_05EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_06EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo address1:(NSString *)address1 error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_07EIKType:(NSString *)eIKType eIK:(NSString *)eIK sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo address1:(NSString *)address1 address2:(NSString *)address2 error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_SaleTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_MinimumtaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1UnTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2UntextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1CByPercentTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2CByPercenttextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CByPercentWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnCByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1UnCByPercentTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2UnCByPercenttextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnCByPercentWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1CBySumTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2CBySumtextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CBySumWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnCBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1UnCBySumTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2UnCBySumtextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_UnCBySumWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSaleTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1TextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_Minimumdepartment:(NSString *)department singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_UnTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1UnTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2UntextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_UnWTextdepartment:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1CByPercentTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2CByPercenttextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_UnCByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1UnCByPercentTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2UnCByPercenttextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1CBySumTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2CBySumtextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CBySumWTextdepartment:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_UnCBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1UnCBySumTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2UnCBySumtextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_UnCBySumWTextdepartment:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySaleTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_UnTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_CByPercentTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_UnCByPercentTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_CBySumTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_UnCBySumTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_MinimumTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSaleTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_UnTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_CByPercentTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_UnCByPercentTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_CBySumTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_UnCBySumTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_MinimumTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLU_SaleTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_CByPercentTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_CBySumTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_UnTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_UnCByPercentTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_UnCBySumTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_SaleTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_CByPercentTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_CBySumTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_UnTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_UnCByPercentTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_UnCBySumTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSaleDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_CByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_CBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_UnDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_UnCByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_UnCBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_SaleDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_Sale_CByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_Sale_CBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_SaleUnDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_SaleUn_CByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_SaleUn_CBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity measure:(NSString *)measure abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_SubtotalToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Subtotal_CByPercentToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Subtotal_CBySumToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow1TextRow1:(NSString *)textRow1 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow2textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountWithoutTextpaidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_TotalTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_TextRow1TextRow1:(NSString *)textRow1 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_TextRow2textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_WithoutTexterror:(NSError **)error ;
    // Command number(Dec): 44 - please check fiscal device documentation.
    -(BOOL)receipt_Paper_FeedLinesCount:(NSString *)linesCount error:(NSError **)error ;
    // Command number(Dec): 45 - please check fiscal device documentation.
    -(BOOL)receipt_Paper_CutAndReturnError:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(BOOL)receipt_Fiscal_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(BOOL)receipt_PFiscalText_01font:(NSString *)font flags:(NSString *)flags inputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(BOOL)receipt_PFiscalText_02font:(NSString *)font inputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 60 - please check fiscal device documentation.
    -(BOOL)receipt_Fiscal_CancelAndReturnError:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)receipt_CashIn_CashOutAmount:(NSString *)amount error:(NSError **)error ;
    // Command number(Dec): 84 - please check fiscal device documentation.
    -(BOOL)receipt_Print_Barcode_01BarcodeType:(NSString *)barcodeType alignment:(NSString *)alignment barcodeData:(NSString *)barcodeData error:(NSError **)error ;
    // Command number(Dec): 84 - please check fiscal device documentation.
    -(BOOL)receipt_Print_Barcode_02BarcodeType:(NSString *)barcodeType alignment:(NSString *)alignment barcodeData:(NSString *)barcodeData error:(NSError **)error ;
    // Command number(Dec): 92 - please check fiscal device documentation.
    -(BOOL)receipt_Separating_LineLineType:(NSString *)lineType error:(NSError **)error ;
    // Command number(Dec): 92 - please check fiscal device documentation.
    -(BOOL)receipt_Separating_LineWLineType:(NSString *)lineType linemask:(NSString *)linemask error:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Current_InfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 106 - please check fiscal device documentation.
    -(BOOL)receipt_Drawer_KickOutMSec:(NSString *)mSec error:(NSError **)error ;
    // Command number(Dec): 109 - please check fiscal device documentation.
    -(BOOL)receipt_Print_DuplicateCount:(NSString *)count error:(NSError **)error ;
    // Command number(Dec): 34 - please check fiscal device documentation.
    -(NSDictionary *)report_Service_ContractsOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 69 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosure_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 69 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosure_02Option:(NSString *)option withoutClearOpInfo:(NSString *)withoutClearOpInfo error:(NSError **)error ;
    // Command number(Dec): 73 - please check fiscal device documentation.
    -(BOOL)report_FMByNumRangeStartNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 73 - please check fiscal device documentation.
    -(BOOL)report_FMByNumRange_SHA1startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)report_FMByDateRange_ShortFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 94 - please check fiscal device documentation.
    -(BOOL)report_FMByDateRangeFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 94 - please check fiscal device documentation.
    -(BOOL)report_FMByDateRange_SHA1fromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 95 - please check fiscal device documentation.
    -(BOOL)report_FMByNumRange_ShortStartNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 105 - please check fiscal device documentation.
    -(BOOL)report_OperatorsAndReturnError:(NSError **)error ;
    // Command number(Dec): 108 - please check fiscal device documentation.
    -(NSDictionary *)report_ExtDailyClosure_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 108 - please check fiscal device documentation.
    -(NSDictionary *)report_ExtDailyClosure_02Option:(NSString *)option withoutClearOpInfo:(NSString *)withoutClearOpInfo error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_ItemsOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_Items_InRangeOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_Items_InRangeByGroupOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU group:(NSString *)group error:(NSError **)error ;
    // Command number(Dec): 117 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartments_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 117 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartments_02Option:(NSString *)option withoutClearOpInfo:(NSString *)withoutClearOpInfo error:(NSError **)error ;
    // Command number(Dec): 118 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartmentsAndItems_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 118 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartmentsAndItems_02Option:(NSString *)option withoutClearOpInfo:(NSString *)withoutClearOpInfo error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemsInformationOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemOption:(NSString *)option taxGroup:(NSString *)taxGroup targetPLU:(NSString *)targetPLU group:(NSString *)group singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity itemName:(NSString *)itemName error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemWithReplaceOption:(NSString *)option taxGroup:(NSString *)taxGroup targetPLU:(NSString *)targetPLU group:(NSString *)group singlePrice:(NSString *)singlePrice replace:(NSString *)replace quantity:(NSString *)quantity itemName:(NSString *)itemName error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemQuantityOption:(NSString *)option targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemsInRangeOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_All_ItemsDOption:(NSString *)dOption aOption:(NSString *)aOption error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextItemOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 36 - please check fiscal device documentation.
    -(NSDictionary *)config_SetLANIPAddress:(NSString *)iPAddress subnetMask:(NSString *)subnetMask portNumber:(NSString *)portNumber defaultGateway:(NSString *)defaultGateway dHCP:(NSString *)dHCP mACAddress:(NSString *)mACAddress error:(NSError **)error ;
    // Command number(Dec): 41 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_SwitchesSwitches:(NSString *)switches error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_HeaderLineItem:(NSString *)item value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_FooterLineItem:(NSString *)item value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_AutoFormatOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_BarcodeHeightOption:(NSString *)option value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_AutoCuttingOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintDensityOption:(NSString *)option value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_enable_EUROption:(NSString *)option on:(NSString *)on rate:(NSString *)rate error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_disable_EUROption:(NSString *)option off:(NSString *)off error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_FontSizeOption:(NSString *)option value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintLogoOption:(NSString *)option offOn:(NSString *)offOn height:(NSString *)height error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintDepartmentOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_enable_PrintSuppressionOption:(NSString *)option on:(NSString *)on lines:(NSString *)lines seconds:(NSString *)seconds error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_disable_PrintSuppressionOption:(NSString *)option off:(NSString *)off error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_ExtraSpaceOption:(NSString *)option value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_SIMOption:(NSString *)option indexValue:(NSString *)indexValue error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintTaxDDSOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_CashDrawerPulseOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_WarningTimeRangeOption:(NSString *)option warnTimeRec:(NSString *)warnTimeRec warnTimeGInfo:(NSString *)warnTimeGInfo error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_FeedButtonOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_OptionalErrorTextOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 61 - please check fiscal device documentation.
    -(BOOL)config_Set_DateTimeDateTime:(NSString *)dateTime error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_InvoiceRangeStartValue:(NSString *)startValue endValue:(NSString *)endValue error:(NSError **)error ;
    // Command number(Dec): 75 - please check fiscal device documentation.
    -(BOOL)config_Restore_PrintSuppressionRestoreOption:(NSString *)restoreOption error:(NSError **)error ;
    // Command number(Dec): 85 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_AdditionalPaymentNameOption:(NSString *)option additionalPaymentName:(NSString *)additionalPaymentName error:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(BOOL)config_Set_DepartmentNameDepartmentNumber:(NSString *)departmentNumber taxGroup:(NSString *)taxGroup textRow1:(NSString *)textRow1 error:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(BOOL)config_Set_DepartmentNameTwoRowsDepartmentNumber:(NSString *)departmentNumber taxGroup:(NSString *)taxGroup textRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 101 - please check fiscal device documentation.
    -(BOOL)config_Set_OperatorPasswordOperatorCode:(NSString *)operatorCode oldPassword:(NSString *)oldPassword newPassword:(NSString *)newPassword error:(NSError **)error ;
    // Command number(Dec): 102 - please check fiscal device documentation.
    -(BOOL)config_Set_OperatorNameOperatorCode:(NSString *)operatorCode password:(NSString *)password operatorName:(NSString *)operatorName error:(NSError **)error ;
    // Command number(Dec): 34 - please check fiscal device documentation.
    -(NSDictionary *)info_Service_ContractsAndReturnError:(NSError **)error ;
    // Command number(Dec): 36 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LANSettingsAndReturnError:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PrintOptionOption:(NSString *)option targetOption:(NSString *)targetOption error:(NSError **)error ;
    // Command number(Dec): 50 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRatesByPeriodStartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTime_01AndReturnError:(NSError **)error ;
    // Command number(Dec): 64 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastFiscRecordAndReturnError:(NSError **)error ;
    // Command number(Dec): 64 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastFiscRecord_01error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_InvoiceRangeAndReturnError:(NSError **)error ;
    // Command number(Dec): 68 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FreeFMRecordsAndReturnError:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CashIn_CashOutAndReturnError:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(BOOL)info_Print_Diagnostic_0AndReturnError:(NSError **)error ;
    // Command number(Dec): 74 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_StatusBytesOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 74 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NotPrintedRowsCountOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 74 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NRADocumentsOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 76 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FTransactionStatusOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_FMReportByDTRangeFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_MonthlyFMReportStartValue:(NSString *)startValue error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_YearlyFMReportStartValue:(NSString *)startValue error:(NSError **)error ;
    // Command number(Dec): 81 - please check fiscal device documentation.
    -(BOOL)info_Get_VoltageAndTemperatureVoltage:(NSString *)voltage temperature:(NSString *)temperature error:(NSError **)error ;
    // Command number(Dec): 83 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DecimalsAndTaxRatesAndReturnError:(NSError **)error ;
    // Command number(Dec): 85 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalPaymentNamesOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMRecord_LastDateTimeOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMRecord_LastDateTime_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 88 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DepartmentInfoDepartmentNumber:(NSString *)departmentNumber error:(NSError **)error ;
    // Command number(Dec): 90 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DiagnosticInfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 93 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DailyCorrectionsAndReturnError:(NSError **)error ;
    // Command number(Dec): 97 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRatesAndReturnError:(NSError **)error ;
    // Command number(Dec): 99 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EIKAndReturnError:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrentRecieptInfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_02AndReturnError:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_03error:(NSError **)error ;
    // Command number(Dec): 112 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_OperatorsDataOperator:(NSString *)operator error:(NSError **)error ;
    // Command number(Dec): 113 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastDocumentNumberAndReturnError:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ActiveTaxesClosureNumber:(NSString *)closureNumber option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_SumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NettoSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_VATSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NumbersClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRateValuesClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_RAMResetDateTimeClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalPaymentsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CorrectionsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CashInCashOutClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TurnoverClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(BOOL)klen_Print_ValidationSubcommand01:(NSString *)subcommand01 subcommand02:(NSString *)subcommand02 error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(BOOL)klen_Print_SHA1Subcommand01:(NSString *)subcommand01 subcommand02:(NSString *)subcommand02 error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_KLENInfo_ZReportSubcommand01:(NSString *)subcommand01 subcommand02:(NSString *)subcommand02 zReportNumber:(NSString *)zReportNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_ZReportInfoSubcommand01:(NSString *)subcommand01 subcommand02:(NSString *)subcommand02 zReportNumber:(NSString *)zReportNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_InfoSubcommand01:(NSString *)subcommand01 subcommand02:(NSString *)subcommand02 error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Find_DocumentSubcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType documentNumber:(NSString *)documentNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRangeSubcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRange_InZReport_01Subcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType zReportNumber:(NSString *)zReportNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRange_InZReport_02Subcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType zReportNumber:(NSString *)zReportNumber documentNumber:(NSString *)documentNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRange_InZReportSubcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType zReportNumber:(NSString *)zReportNumber startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRange_ByDateTimeSubcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_NextTextRowSubcommand01:(NSString *)subcommand01 error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocumentSubcommand01:(NSString *)subcommand01 fontSize:(NSString *)fontSize documentType:(NSString *)documentType documentNumber:(NSString *)documentNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocsInRangeSubcommand01:(NSString *)subcommand01 fontSize:(NSString *)fontSize documentType:(NSString *)documentType startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocsInRange_InZReportSubcommand01:(NSString *)subcommand01 fontSize:(NSString *)fontSize documentType:(NSString *)documentType zReportNumber:(NSString *)zReportNumber startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocsFromDateToDateSubcommand01:(NSString *)subcommand01 fontSize:(NSString *)fontSize documentType:(NSString *)documentType fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_W_ByNumberOption:(NSString *)option startNumber:(NSString *)startNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_W_ByNumbersRangeOption:(NSString *)option startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_W_ByDateRangeOption:(NSString *)option optionD:(NSString *)optionD fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_W_GetNextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_Y_ByNumberOption:(NSString *)option startNumber:(NSString *)startNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_Y_ByNumbersRangeOption:(NSString *)option startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_Y_ByDateRangeOption:(NSString *)option optionD:(NSString *)optionD fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_Y_GetNextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_V_ByNumberOption:(NSString *)option startNumber:(NSString *)startNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_V_ByNumbersRangeOption:(NSString *)option startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_V_ByDateRangeOption:(NSString *)option optionD:(NSString *)optionD fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_V_GetNextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_ExV_ByNumberOption:(NSString *)option exOption:(NSString *)exOption startNumber:(NSString *)startNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_ExV_ByNumbersRangeOption:(NSString *)option exOption:(NSString *)exOption startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_ExV_ByDateRangeOption:(NSString *)option exOption:(NSString *)exOption optionD:(NSString *)optionD fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_SInfo_ExV_GetNextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 80 - please check fiscal device documentation.
    -(BOOL)other_Sound_SignalSoundData:(NSString *)soundData error:(NSError **)error ;
    // Command number(Dec): 72 - please check fiscal device documentation.
    -(NSDictionary *)service_FiscalizationSerialNumber:(NSString *)serialNumber error:(NSError **)error ;
    // Command number(Dec): 83 - please check fiscal device documentation.
    -(BOOL)service_Set_DecimalsAndTaxRatesMutiplier:(NSString *)mutiplier decimals:(NSString *)decimals currencyName:(NSString *)currencyName enabledMask:(NSString *)enabledMask taxA:(NSString *)taxA taxB:(NSString *)taxB taxC:(NSString *)taxC taxD:(NSString *)taxD taxE:(NSString *)taxE taxF:(NSString *)taxF taxG:(NSString *)taxG taxH:(NSString *)taxH error:(NSError **)error ;
    // Command number(Dec): 89 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_ProductionTestAreaOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 91 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_SerialNumberSerialNumber:(NSString *)serialNumber fMNumber:(NSString *)fMNumber error:(NSError **)error ;
    // Command number(Dec): 98 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_EIKEikValue:(NSString *)eikValue eikName:(NSString *)eikName error:(NSError **)error ;
    // Command number(Dec): 128 - please check fiscal device documentation.
    -(BOOL)service_RAM_ResetAndReturnError:(NSError **)error ;
    // Command number(Dec): 133 - please check fiscal device documentation.
    -(BOOL)service_Disable_PrintDisabled:(NSString *)disabled error:(NSError **)error ;
    // Command number(Dec): 134 - please check fiscal device documentation.
    -(NSDictionary *)service_Format_KLENOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 135 - please check fiscal device documentation.
    -(NSDictionary *)service_Test_GPRSOption:(NSString *)option error:(NSError **)error ;


/* machine-oriented interface - end */


@end


