//
//  GROUP_B_BGR.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 08.06.2019
//  Modified on 08.06.2019
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface GROUP_B_BGR : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream packetFormat:(int)format error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) BOOL deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) BOOL infoMandatoryZReportEndOfDay;
@property(readonly) BOOL infoMandatoryEKLPrintBeforeZReport;
@property(readonly) BOOL infoMandatoryEKLSave;
@property(readonly) BOOL infoMandatoryMonthlyReport;
@property(readonly) BOOL infoMandatoryYearlyReport;
@property(readonly) BOOL statusDisplayNotConnected;
@property(readonly) BOOL statusTransparentDisplayMode;
@property(readonly) BOOL statusFiscalMemoryMissing;
@property(readonly) BOOL statusPrintingHeadOverheated;
@property(readonly) BOOL statusSeconRollNoPaperPlace;
@property(readonly) BOOL statusSeconRollOutOfPaper;
@property(readonly) BOOL statusEndOfEKL;
@property(readonly) BOOL statusDrawerOpened;
@property(readonly) BOOL statusEKLNotEmpty;
@property(readonly) BOOL statusEKLPrinted;
@property(readonly) BOOL statusEKLNearEnd;
@property(readonly) BOOL statusKLENNearEnd;
@property(readonly) BOOL statusSecondRollNotEnoughPaper;
@property(readonly) BOOL statusAutomaticPaperCutting;
@property(readonly) BOOL statusPrintingHeadNotConnected;
@property(readonly) BOOL supportEKL;
@property(readonly) BOOL supportNRATerminal;
@property(readonly) BOOL supportKLEN;
@property(readonly) BOOL supportEIK;
@property(readonly) BOOL supportServiceContractsInformation;
@property(readonly) BOOL supportIOSANumber;
@property(readonly) BOOL supportFiscalReceipts;
@property(readonly) BOOL supportRotatedFiscalReceipts;
@property(readonly) BOOL supportNonFiscalReceipts;
@property(readonly) BOOL supportRotatedNonFiscalReceipts;
@property(readonly) BOOL supportBluetooth;
@property(readonly) BOOL supportWiFi;
@property(readonly) BOOL supportTCPIP;
@property(readonly) BOOL supportFTP;
@property(readonly) BOOL supportHTTP;
@property(readonly) BOOL supportSoftwareSwitches;
@property(readonly) BOOL supportClientDisplay;
@property(readonly) BOOL supportDrawerOpening;
@property(readonly) BOOL supportDrawerStatus;
@property(readonly) BOOL supportSecondRoll;
@property(readonly) BOOL supportAutoCutPaper;
@property(readonly) BOOL supportAdditionalMatrixPrint;
@property(readonly) BOOL supportPrintingHeadTemperatureControl;
@property(readonly) BOOL supportAsynchronousMode;
@property(readonly) BOOL supportTransactionsBufferForCommands;
@property(readonly) BOOL supportReceiptVoid;
@property(readonly) BOOL supportSaleRowVoid;
@property(readonly) BOOL supportVoidReceipt;
@property(readonly) BOOL supportVoidSale;
@property(readonly) BOOL statusEIKSet;
@property(readonly) BOOL statusSerialNumberSet;
@property(readonly) BOOL statusFMNumberSet;
@property(readonly) BOOL statusPrinterFiscalized;
@property(readonly) BOOL statusFiscalMemoryFormated;
@property(readonly) BOOL statusTaxRatesOk;
@property(readonly) BOOL statusLowBattery;
@property(readonly) BOOL statusGeneralErrorType1;
@property(readonly) BOOL statusGeneralErrorType2;
@property(readonly) BOOL statusPrintingHeadFailure;
@property(readonly) BOOL statusPrinterClockNotSet;
@property(readonly) BOOL statusInvalidCommand;
@property(readonly) BOOL statusSyntaxError;
@property(readonly) BOOL statusNRATerminalNotRespond;
@property(readonly) BOOL statusRamError;
@property(readonly) BOOL statusRamCleared;
@property(readonly) BOOL statusCommandNotAllowed;
@property(readonly) BOOL statusFieldOverflow;
@property(readonly) BOOL statusFiscalMemoryFull;
@property(readonly) BOOL statusFiscalMemoryReadError;
@property(readonly) BOOL statusFiscalMemoryWriteError;
@property(readonly) BOOL statusFiscalMemoryReadOnly;
@property(readonly) BOOL statusOutOfPaper;
@property(readonly) BOOL statusEndOfKLEN;
@property(readonly) BOOL statusFiscalReceiptOpened;
@property(readonly) BOOL statusNonFiscalReceiptOpened;
@property(readonly) BOOL statusRotatedReceiptOpened;
@property(readonly) BOOL statusFiscalMemoryNearEnd;
@property(readonly) BOOL statusCoverWasOpened;
@property(readonly) BOOL statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) BOOL infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterAdjustmentType;
@property(copy) NSString *sellParameterAdjustmentValue;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *subtotalParameterAdjustmentType;
@property(copy) NSString *subtotalParameterAdjustmentValue;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;
@property(copy) NSString *dailyReportType;



/* human-oriented interface - begin */

/////*some informations*/
//-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;
//-(BOOL)diagnosticInfoPrintAndReturnError:(NSError **)error;
////
/////*non-fiscal bon*/
//-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;
////
/////*fiscal bon*/
//-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(BOOL)fiscalReceiptSellAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;
//-(BOOL)printBarcodeDataType:(NSString *)dataType dataValue:(NSString *)dataValue error:(NSError **)error;
//
///*emergency*/
-(BOOL)checkAndResolveAndReturnError:(NSError **)error;
//
////Report
//-(BOOL)printDailyReportAndReturnError:(NSError **)error;



/* human-oriented interface - end */



/* machine-oriented interface - begin */

    // Command number(Dec): 33 - please check fiscal device documentation.
    -(BOOL)display_ClearAndReturnError:(NSError **)error ;
    // Command number(Dec): 35 - please check fiscal device documentation.
    -(BOOL)display_Show_LowerLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 47 - please check fiscal device documentation.
    -(BOOL)display_Show_UpperLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 63 - please check fiscal device documentation.
    -(BOOL)display_Show_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 100 - please check fiscal device documentation.
    -(NSDictionary *)display_Show_TextAndReturnError:(NSError **)error ;
    // Command number(Dec): 38 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_OpenAndReturnError:(NSError **)error ;
    // Command number(Dec): 39 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(BOOL)receipt_NonFiscal_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(BOOL)receipt_PNonFiscal_TextHeight:(NSString *)height inputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword stornoUNP:(NSString *)stornoUNP tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B05OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword stornoUNP:(NSString *)stornoUNP tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_B06OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword stornoUNP:(NSString *)stornoUNP tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_B01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_B03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber error:(NSError **)error ;
    // Command number(Dec): 56 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_B02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_B04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Invoice_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_08EIK:(NSString *)eIK eIKType:(NSString *)eIKType error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_09EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_10EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_11EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_12EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_13EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo address1:(NSString *)address1 error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(BOOL)receipt_PrintClientInfo_14EIK:(NSString *)eIK eIKType:(NSString *)eIKType sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNo:(NSString *)taxNo address1:(NSString *)address1 address2:(NSString *)address2 error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_SaleTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_MinimumtaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1CByPercentTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2CByPercenttextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CByPercentWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow1CBySumTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_TextRow2CBySumtextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_Sale_CBySumWTexttaxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSaleTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1TextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_Minimumdepartment:(NSString *)department singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CByPercentTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1CByPercentTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2CByPercenttextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CByPercentWTextdepartment:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CBySumTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow1CBySumTextRow1:(NSString *)textRow1 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_TextRow2CBySumtextRow2:(NSString *)textRow2 department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(BOOL)receipt_DSale_CBySumWTextdepartment:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySaleTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_CByPercentTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_CBySumTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplaySale_MinimumTextRow:(NSString *)textRow taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSaleTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_CByPercentTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_CBySumTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 52 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDSale_MinimumTextRow:(NSString *)textRow department:(NSString *)department singlePrice:(NSString *)singlePrice error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLU_SaleTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_CByPercentTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUSale_CBySumTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_SaleTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_CByPercentTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_PLUDep_Sale_CBySumTargetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSaleDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_CByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayPLUSale_CBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_SaleDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_Sale_CByPercentDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(BOOL)receipt_DisplayDepPLU_Sale_CBySumDChar:(NSString *)dChar targetPLU:(NSString *)targetPLU department:(NSString *)department quantity:(NSString *)quantity abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_SubtotalToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Subtotal_CByPercentToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay percent:(NSString *)percent error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Subtotal_CBySumToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay abs:(NSString *)abs error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow1TextRow1:(NSString *)textRow1 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountTextRow2textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_PAmountWithoutTextpaidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_TotalTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_TextRow1TextRow1:(NSString *)textRow1 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_TextRow2textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_WithoutTexterror:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PinPad_TotalTextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount pinpadPaidMode:(NSString *)pinpadPaidMode error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PinPad_TotalTextRow1TextRow1:(NSString *)textRow1 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount pinpadPaidMode:(NSString *)pinpadPaidMode error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PinPad_TotalTextRow2textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount pinpadPaidMode:(NSString *)pinpadPaidMode error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PinPad_TotalWTextpaidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount pinpadPaidMode:(NSString *)pinpadPaidMode error:(NSError **)error ;
    // Command number(Dec): 44 - please check fiscal device documentation.
    -(BOOL)receipt_Paper_FeedLinesCount:(NSString *)linesCount error:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(BOOL)receipt_Fiscal_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 60 - please check fiscal device documentation.
    -(BOOL)receipt_Fiscal_CancelAndReturnError:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)receipt_CashIn_CashOutAmount:(NSString *)amount error:(NSError **)error ;
    // Command number(Dec): 92 - please check fiscal device documentation.
    -(BOOL)receipt_Separating_LineLineType:(NSString *)lineType error:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Current_InfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 106 - please check fiscal device documentation.
    -(BOOL)receipt_Drawer_KickOutMSec:(NSString *)mSec error:(NSError **)error ;
    // Command number(Dec): 109 - please check fiscal device documentation.
    -(BOOL)receipt_Print_DuplicateCount:(NSString *)count error:(NSError **)error ;
    // Command number(Dec): 69 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosure_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 73 - please check fiscal device documentation.
    -(BOOL)report_FMByNumRangeStartNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)report_FMByDateRange_ShortFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 94 - please check fiscal device documentation.
    -(BOOL)report_FMByDateRangeFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 95 - please check fiscal device documentation.
    -(BOOL)report_FMByNumRange_ShortStartNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 105 - please check fiscal device documentation.
    -(BOOL)report_OperatorsAndReturnError:(NSError **)error ;
    // Command number(Dec): 108 - please check fiscal device documentation.
    -(NSDictionary *)report_ExtDailyClosure_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_ItemsOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_Items_InRangeOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_Items_InRangeByGroupOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU group:(NSString *)group error:(NSError **)error ;
    // Command number(Dec): 117 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartments_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 118 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosureByDepartmentsAndItems_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemsInformationOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemOption:(NSString *)option taxGroup:(NSString *)taxGroup targetPLU:(NSString *)targetPLU group:(NSString *)group singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity itemName:(NSString *)itemName error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemWithReplaceOption:(NSString *)option taxGroup:(NSString *)taxGroup targetPLU:(NSString *)targetPLU group:(NSString *)group singlePrice:(NSString *)singlePrice replace:(NSString *)replace quantity:(NSString *)quantity itemName:(NSString *)itemName error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemQuantityOption:(NSString *)option targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemsInRangeOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_All_ItemsDOption:(NSString *)dOption aOption:(NSString *)aOption error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextItemOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Set_ClientDataOption:(NSString *)option eikValue:(NSString *)eikValue eikType:(NSString *)eikType receiver:(NSString *)receiver client:(NSString *)client taxNo:(NSString *)taxNo address1:(NSString *)address1 address2:(NSString *)address2 error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Del_ClientDataOption:(NSString *)option eikValue:(NSString *)eikValue error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_ClientDataOption:(NSString *)option eikValue:(NSString *)eikValue error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Set_SellerNameOption:(NSString *)option seller:(NSString *)seller error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(BOOL)clients_Get_SellerNameOption:(NSString *)option seller:(NSString *)seller error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_FirstClientDataOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_NextClientDataOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Del_AllClientDataOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_HeaderLineItem:(NSString *)item value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_FooterLineItem:(NSString *)item value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_AutoFormatOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintDensityOption:(NSString *)option value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_enable_EUROption:(NSString *)option on:(NSString *)on rate:(NSString *)rate error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_disable_EUROption:(NSString *)option off:(NSString *)off error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintLogoOption:(NSString *)option offOn:(NSString *)offOn height:(NSString *)height error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintDepartmentOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_PrintTaxDDSOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(BOOL)config_Set_CashDrawerPulseOption:(NSString *)option offOn:(NSString *)offOn error:(NSError **)error ;
    // Command number(Dec): 61 - please check fiscal device documentation.
    -(BOOL)config_Set_DateTimeDateTime:(NSString *)dateTime error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_InvoiceRangeStartValue:(NSString *)startValue endValue:(NSString *)endValue error:(NSError **)error ;
    // Command number(Dec): 85 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_AdditionalPaymentNameOption:(NSString *)option additionalPaymentName:(NSString *)additionalPaymentName error:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(BOOL)config_Set_DepartmentNameDepartmentNumber:(NSString *)departmentNumber taxGroup:(NSString *)taxGroup textRow1:(NSString *)textRow1 error:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(BOOL)config_Set_DepartmentNameTwoRowsDepartmentNumber:(NSString *)departmentNumber taxGroup:(NSString *)taxGroup textRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error ;
    // Command number(Dec): 101 - please check fiscal device documentation.
    -(BOOL)config_Set_OperatorPasswordOperatorCode:(NSString *)operatorCode oldPassword:(NSString *)oldPassword newPassword:(NSString *)newPassword error:(NSError **)error ;
    // Command number(Dec): 102 - please check fiscal device documentation.
    -(BOOL)config_Set_OperatorNameOperatorCode:(NSString *)operatorCode password:(NSString *)password operatorName:(NSString *)operatorName error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PrintOptionOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 50 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRatesByPeriodStartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTime_01AndReturnError:(NSError **)error ;
    // Command number(Dec): 64 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastFiscRecordAndReturnError:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_04Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_05Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_06Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_07Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_08Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_09Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_10Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_InvoiceRangeAndReturnError:(NSError **)error ;
    // Command number(Dec): 68 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FreeFMRecordsAndReturnError:(NSError **)error ;
    // Command number(Dec): 68 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FreeFMRecords_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CashIn_CashOutAndReturnError:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Print_Diagnostic_0AndReturnError:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Print_Diagnostic_1Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_PrintInfo_GPRSOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_PrintInfo_TaxTerminalOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxTerminalInfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ModemInfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FlashMemoryInfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 74 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_StatusBytesOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 76 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FTransactionStatusOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_FMReportByDTRangeFromDate:(NSString *)fromDate toDate:(NSString *)toDate error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_MonthlyFMReportStartValue:(NSString *)startValue error:(NSError **)error ;
    // Command number(Dec): 79 - please check fiscal device documentation.
    -(BOOL)info_Print_Short_YearlyFMReportStartValue:(NSString *)startValue error:(NSError **)error ;
    // Command number(Dec): 83 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DecimalsAndTaxRatesAndReturnError:(NSError **)error ;
    // Command number(Dec): 85 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalPaymentNamesOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMRecord_LastDateTimeOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMRecord_LastDateTime_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Registration_DT_NumOption:(NSString *)option number:(NSString *)number error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeRegistration_DT_NumOption:(NSString *)option number:(NSString *)number error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Registration_CountOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeRegistration_CountOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 88 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DepartmentInfoDepartmentNumber:(NSString *)departmentNumber error:(NSError **)error ;
    // Command number(Dec): 88 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Department_StornoInfoDepartmentNumber:(NSString *)departmentNumber stornoType:(NSString *)stornoType error:(NSError **)error ;
    // Command number(Dec): 90 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DiagnosticInfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 97 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRatesAndReturnError:(NSError **)error ;
    // Command number(Dec): 99 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EIKAndReturnError:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrentRecieptInfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_11Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 112 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_OperatorsDataOperator:(NSString *)operator error:(NSError **)error ;
    // Command number(Dec): 112 - please check fiscal device documentation.
    -(NSDictionary *)info_read_OperatorsInfoOperator:(NSString *)operator option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 113 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastDocumentNumberAndReturnError:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ActiveTaxesClosureNumber:(NSString *)closureNumber option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_SumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NettoSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_VATSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NumbersClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRateValuesClosure1:(NSString *)closure1 option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ReversalTurnoverClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ReversalNetoSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 114 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ReversalVATSumsClosure1:(NSString *)closure1 option:(NSString *)option closure2:(NSString *)closure2 error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Set_DocsRange_ByDateTimeSubcommand01:(NSString *)subcommand01 documentType:(NSString *)documentType fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 119 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_NextTextRowSubcommand01:(NSString *)subcommand01 error:(NSError **)error ;
    // Command number(Dec): 124 - please check fiscal device documentation.
    -(NSDictionary *)klen_FindRange_ByDateTimeOption:(NSString *)option documentType:(NSString *)documentType fromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime error:(NSError **)error ;
    // Command number(Dec): 124 - please check fiscal device documentation.
    -(NSDictionary *)klen_FindRange_ByZReportsOption:(NSString *)option documentType:(NSString *)documentType startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 124 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_InfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Prepare_DocumentOption:(NSString *)option inDocNumber:(NSString *)inDocNumber inDocType:(NSString *)inDocType error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Prepare_DocumentInRangeOption:(NSString *)option inFromDocNumber:(NSString *)inFromDocNumber inDocType:(NSString *)inDocType inToDocNumber:(NSString *)inToDocNumber error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_TextRowOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocumentOption:(NSString *)option inDocNumber:(NSString *)inDocNumber inDocType:(NSString *)inDocType error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_SInfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 80 - please check fiscal device documentation.
    -(BOOL)other_Sound_SignalHz:(NSString *)hz mSec:(NSString *)mSec error:(NSError **)error ;
    // Command number(Dec): 72 - please check fiscal device documentation.
    -(NSDictionary *)service_FiscalizationSerialNumber:(NSString *)serialNumber error:(NSError **)error ;
    // Command number(Dec): 83 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_DecimalsAndTaxRatesInpMultiplier:(NSString *)inpMultiplier inpDecimals:(NSString *)inpDecimals inpCurrencyName:(NSString *)inpCurrencyName inpEnabledMask:(NSString *)inpEnabledMask inpTaxA:(NSString *)inpTaxA inpTaxB:(NSString *)inpTaxB inpTaxC:(NSString *)inpTaxC inpTaxD:(NSString *)inpTaxD inpTaxE:(NSString *)inpTaxE inpTaxF:(NSString *)inpTaxF inpTaxG:(NSString *)inpTaxG inpTaxH:(NSString *)inpTaxH error:(NSError **)error ;
    // Command number(Dec): 89 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_ProductionTestAreaOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 98 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_EIKEikValue:(NSString *)eikValue eikName:(NSString *)eikName error:(NSError **)error ;


/* machine-oriented interface - end */


@end


