//
//  GROUP_C_BGR.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 08.06.2019
//  Modified on 08.06.2019
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface GROUP_C_BGR : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Connect to the fiscal device using streams
 */
-(BOOL)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream packetFormat:(int)format error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) BOOL deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) BOOL infoMandatoryZReportEndOfDay;
@property(readonly) BOOL infoMandatoryEKLPrintBeforeZReport;
@property(readonly) BOOL infoMandatoryEKLSave;
@property(readonly) BOOL infoMandatoryMonthlyReport;
@property(readonly) BOOL infoMandatoryYearlyReport;
@property(readonly) BOOL statusDisplayNotConnected;
@property(readonly) BOOL statusTransparentDisplayMode;
@property(readonly) BOOL statusFiscalMemoryMissing;
@property(readonly) BOOL statusPrintingHeadOverheated;
@property(readonly) BOOL statusSeconRollNoPaperPlace;
@property(readonly) BOOL statusSeconRollOutOfPaper;
@property(readonly) BOOL statusEndOfEKL;
@property(readonly) BOOL statusDrawerOpened;
@property(readonly) BOOL statusEKLNotEmpty;
@property(readonly) BOOL statusEKLPrinted;
@property(readonly) BOOL statusEKLNearEnd;
@property(readonly) BOOL statusKLENNearEnd;
@property(readonly) BOOL statusSecondRollNotEnoughPaper;
@property(readonly) BOOL statusAutomaticPaperCutting;
@property(readonly) BOOL statusPrintingHeadNotConnected;
@property(readonly) BOOL supportEKL;
@property(readonly) BOOL supportNRATerminal;
@property(readonly) BOOL supportKLEN;
@property(readonly) BOOL supportEIK;
@property(readonly) BOOL supportServiceContractsInformation;
@property(readonly) BOOL supportIOSANumber;
@property(readonly) BOOL supportFiscalReceipts;
@property(readonly) BOOL supportRotatedFiscalReceipts;
@property(readonly) BOOL supportNonFiscalReceipts;
@property(readonly) BOOL supportRotatedNonFiscalReceipts;
@property(readonly) BOOL supportBluetooth;
@property(readonly) BOOL supportWiFi;
@property(readonly) BOOL supportTCPIP;
@property(readonly) BOOL supportFTP;
@property(readonly) BOOL supportHTTP;
@property(readonly) BOOL supportSoftwareSwitches;
@property(readonly) BOOL supportClientDisplay;
@property(readonly) BOOL supportDrawerOpening;
@property(readonly) BOOL supportDrawerStatus;
@property(readonly) BOOL supportSecondRoll;
@property(readonly) BOOL supportAutoCutPaper;
@property(readonly) BOOL supportAdditionalMatrixPrint;
@property(readonly) BOOL supportPrintingHeadTemperatureControl;
@property(readonly) BOOL supportAsynchronousMode;
@property(readonly) BOOL supportTransactionsBufferForCommands;
@property(readonly) BOOL supportReceiptVoid;
@property(readonly) BOOL supportSaleRowVoid;
@property(readonly) BOOL supportVoidReceipt;
@property(readonly) BOOL supportVoidSale;
@property(readonly) BOOL statusEIKSet;
@property(readonly) BOOL statusSerialNumberSet;
@property(readonly) BOOL statusFMNumberSet;
@property(readonly) BOOL statusPrinterFiscalized;
@property(readonly) BOOL statusFiscalMemoryFormated;
@property(readonly) BOOL statusTaxRatesOk;
@property(readonly) BOOL statusLowBattery;
@property(readonly) BOOL statusGeneralErrorType1;
@property(readonly) BOOL statusGeneralErrorType2;
@property(readonly) BOOL statusPrintingHeadFailure;
@property(readonly) BOOL statusPrinterClockNotSet;
@property(readonly) BOOL statusInvalidCommand;
@property(readonly) BOOL statusSyntaxError;
@property(readonly) BOOL statusNRATerminalNotRespond;
@property(readonly) BOOL statusRamError;
@property(readonly) BOOL statusRamCleared;
@property(readonly) BOOL statusCommandNotAllowed;
@property(readonly) BOOL statusFieldOverflow;
@property(readonly) BOOL statusFiscalMemoryFull;
@property(readonly) BOOL statusFiscalMemoryReadError;
@property(readonly) BOOL statusFiscalMemoryWriteError;
@property(readonly) BOOL statusFiscalMemoryReadOnly;
@property(readonly) BOOL statusOutOfPaper;
@property(readonly) BOOL statusEndOfKLEN;
@property(readonly) BOOL statusFiscalReceiptOpened;
@property(readonly) BOOL statusNonFiscalReceiptOpened;
@property(readonly) BOOL statusRotatedReceiptOpened;
@property(readonly) BOOL statusFiscalMemoryNearEnd;
@property(readonly) BOOL statusCoverWasOpened;
@property(readonly) BOOL statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) BOOL infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterAdjustmentType;
@property(copy) NSString *sellParameterAdjustmentValue;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *subtotalParameterAdjustmentType;
@property(copy) NSString *subtotalParameterAdjustmentValue;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;
@property(copy) NSString *dailyReportType;



/* human-oriented interface - begin */

/////*some informations*/
//-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;
//-(BOOL)diagnosticInfoPrintAndReturnError:(NSError **)error;
////
/////*non-fiscal bon*/
//-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;
////
/////*fiscal bon*/
//-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
//-(BOOL)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
//-(BOOL)fiscalReceiptSellAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
//-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;
//-(BOOL)printBarcodeDataType:(NSString *)dataType dataValue:(NSString *)dataValue error:(NSError **)error;
//
///*emergency*/
-(BOOL)checkAndResolveAndReturnError:(NSError **)error;
//
////Report
//-(BOOL)printDailyReportAndReturnError:(NSError **)error;



/* human-oriented interface - end */



/* machine-oriented interface - begin */

    // Command number(Dec): 33 - please check fiscal device documentation.
    -(NSDictionary *)display_ClearAndReturnError:(NSError **)error ;
    // Command number(Dec): 35 - please check fiscal device documentation.
    -(NSDictionary *)display_Show_LowerLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 47 - please check fiscal device documentation.
    -(NSDictionary *)display_Show_UpperLineTextData:(NSString *)textData error:(NSError **)error ;
    // Command number(Dec): 63 - please check fiscal device documentation.
    -(NSDictionary *)display_Show_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 38 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_OpenAndReturnError:(NSError **)error ;
    // Command number(Dec): 39 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(NSDictionary *)receipt_NonFiscal_TextInputText:(NSString *)inputText bold:(NSString *)bold italic:(NSString *)italic height:(NSString *)height underLine:(NSString *)underLine alignment:(NSString *)alignment error:(NSError **)error ;
    // Command number(Dec): 42 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PNonFiscal_TextInputText:(NSString *)inputText bold:(NSString *)bold italic:(NSString *)italic height:(NSString *)height underLine:(NSString *)underLine alignment:(NSString *)alignment error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C05OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 43 - please check fiscal device documentation.
    -(NSDictionary *)receipt_StornoOpen_C06OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber stornoType:(NSString *)stornoType stornoDocumentNumber:(NSString *)stornoDocumentNumber stornoDateTime:(NSString *)stornoDateTime stornoFMNumber:(NSString *)stornoFMNumber invoice:(NSString *)invoice invoiceNumber:(NSString *)invoiceNumber stornoReason:(NSString *)stornoReason stornoUNP:(NSString *)stornoUNP error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_C01OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_C03OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 56 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_CloseAndReturnError:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_C02OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_FiscalOpen_C04OperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 48 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Invoice_OpenOperatorNumber:(NSString *)operatorNumber operatorPassword:(NSString *)operatorPassword uNP:(NSString *)uNP tillNumber:(NSString *)tillNumber invoice:(NSString *)invoice error:(NSError **)error ;
    // Command number(Dec): 57 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PrintClientInfo_15SellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName address1:(NSString *)address1 address2:(NSString *)address2 eIKType:(NSString *)eIKType eIK:(NSString *)eIK taxNo:(NSString *)taxNo error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(NSDictionary *)receipt_SaleTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity discountType:(NSString *)discountType discountValue:(NSString *)discountValue department:(NSString *)department error:(NSError **)error ;
    // Command number(Dec): 49 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Sale_UnTextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup singlePrice:(NSString *)singlePrice quantity:(NSString *)quantity discountType:(NSString *)discountType discountValue:(NSString *)discountValue department:(NSString *)department measure:(NSString *)measure error:(NSError **)error ;
    // Command number(Dec): 58 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PLU_SaleTargetPLU:(NSString *)targetPLU quantity:(NSString *)quantity discountType:(NSString *)discountType discountValue:(NSString *)discountValue error:(NSError **)error ;
    // Command number(Dec): 51 - please check fiscal device documentation.
    -(NSDictionary *)receipt_SubtotalToPrint:(NSString *)toPrint toDisplay:(NSString *)toDisplay discountType:(NSString *)discountType discountValue:(NSString *)discountValue error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_TotalPaidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount pinpadPaidMode:(NSString *)pinpadPaidMode error:(NSError **)error ;
    // Command number(Dec): 53 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Total_CurrencyPaidMode:(NSString *)paidMode inputAmount:(NSString *)inputAmount currencyType:(NSString *)currencyType error:(NSError **)error ;
    // Command number(Dec): 44 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Paper_FeedLinesCount:(NSString *)linesCount error:(NSError **)error ;
    // Command number(Dec): 46 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Paper_CutAndReturnError:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_TextInputText:(NSString *)inputText bold:(NSString *)bold italic:(NSString *)italic doubleHeight:(NSString *)doubleHeight underLine:(NSString *)underLine alignment:(NSString *)alignment error:(NSError **)error ;
    // Command number(Dec): 54 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PFiscal_TextInputText:(NSString *)inputText bold:(NSString *)bold italic:(NSString *)italic height:(NSString *)height underLine:(NSString *)underLine alignment:(NSString *)alignment error:(NSError **)error ;
    // Command number(Dec): 60 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Fiscal_CancelAndReturnError:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)receipt_CashIn_CashOutAmountType:(NSString *)amountType amount:(NSString *)amount error:(NSError **)error ;
    // Command number(Dec): 84 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Print_BarcodeBarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData qRCodeSize:(NSString *)qRCodeSize error:(NSError **)error ;
    // Command number(Dec): 92 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Separating_LineLineType:(NSString *)lineType error:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Current_InfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 106 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Drawer_KickOutMSec:(NSString *)mSec error:(NSError **)error ;
    // Command number(Dec): 109 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Print_DuplicateAndReturnError:(NSError **)error ;
    // Command number(Dec): 122 - please check fiscal device documentation.
    -(NSDictionary *)receipt_PVerticalFiscal_TextInputText:(NSString *)inputText error:(NSError **)error ;
    // Command number(Dec): 127 - please check fiscal device documentation.
    -(NSDictionary *)receipt_Print_StampOption:(NSString *)option stampName:(NSString *)stampName error:(NSError **)error ;
    // Command number(Dec): 69 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosure_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 69 - please check fiscal device documentation.
    -(NSDictionary *)report_DailyClosure_02Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(NSDictionary *)report_Item_GroupsItemGroup:(NSString *)itemGroup error:(NSError **)error ;
    // Command number(Dec): 88 - please check fiscal device documentation.
    -(NSDictionary *)report_Department_InfoDepartmentNumber:(NSString *)departmentNumber error:(NSError **)error ;
    // Command number(Dec): 95 - please check fiscal device documentation.
    -(NSDictionary *)report_FMByNumRangeReportType:(NSString *)reportType startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 95 - please check fiscal device documentation.
    -(NSDictionary *)report_FMByNumRange_ShortReportType:(NSString *)reportType startNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error ;
    // Command number(Dec): 105 - please check fiscal device documentation.
    -(NSDictionary *)report_OperatorsOperatorscodeStart:(NSString *)operatorscodeStart operatorscodeEnd:(NSString *)operatorscodeEnd toClear:(NSString *)toClear error:(NSError **)error ;
    // Command number(Dec): 111 - please check fiscal device documentation.
    -(NSDictionary *)report_ItemsOption:(NSString *)option startPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemsInformationOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU taxGroup:(NSString *)taxGroup department:(NSString *)department group:(NSString *)group priceType:(NSString *)priceType singlePrice:(NSString *)singlePrice addQty:(NSString *)addQty quantity:(NSString *)quantity barcode01:(NSString *)barcode01 barcode02:(NSString *)barcode02 barcode03:(NSString *)barcode03 barcode04:(NSString *)barcode04 itemName:(NSString *)itemName error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemUnOption:(NSString *)option targetPLU:(NSString *)targetPLU taxGroup:(NSString *)taxGroup department:(NSString *)department group:(NSString *)group priceType:(NSString *)priceType singlePrice:(NSString *)singlePrice addQty:(NSString *)addQty quantity:(NSString *)quantity barcode01:(NSString *)barcode01 barcode02:(NSString *)barcode02 barcode03:(NSString *)barcode03 barcode04:(NSString *)barcode04 itemName:(NSString *)itemName measurementUnit:(NSString *)measurementUnit error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Set_ItemQuantityOption:(NSString *)option targetPLU:(NSString *)targetPLU quantity:(NSString *)quantity error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemOption:(NSString *)option pluStart:(NSString *)pluStart pluEnd:(NSString *)pluEnd error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_ItemsInRangeOption:(NSString *)option pluStart:(NSString *)pluStart pluEnd:(NSString *)pluEnd error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Delete_All_ItemsOption:(NSString *)option deleteAll:(NSString *)deleteAll pluEnd:(NSString *)pluEnd error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_ItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastFoundItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextItemOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_NextSoldItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_FirstNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 107 - please check fiscal device documentation.
    -(NSDictionary *)items_Get_LastNotProgrammedItemOption:(NSString *)option targetPLU:(NSString *)targetPLU error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Set_ClientDataOption:(NSString *)option clientNumber:(NSString *)clientNumber clientName:(NSString *)clientName typeTAXN:(NSString *)typeTAXN taxNumber:(NSString *)taxNumber recieverName:(NSString *)recieverName vatNumber:(NSString *)vatNumber address01:(NSString *)address01 address02:(NSString *)address02 error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Del_ClientDataOption:(NSString *)option firstClientNumber:(NSString *)firstClientNumber lastClientNumber:(NSString *)lastClientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Del_AllClientDataOption:(NSString *)option firstClientNumber:(NSString *)firstClientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_ClientDataOption:(NSString *)option clientNumber:(NSString *)clientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_FirstProgrammedClientOption:(NSString *)option clientNumber:(NSString *)clientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_LastProgrammedClientOption:(NSString *)option clientNumber:(NSString *)clientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_NextProgrammedClientOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_ClientByTaxNumberOption:(NSString *)option taxNumber:(NSString *)taxNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_FirstNotProgrammedOption:(NSString *)option clientNumber:(NSString *)clientNumber error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)clients_Get_LastNotProgrammedOption:(NSString *)option clientNumber:(NSString *)clientNumber error:(NSError **)error ;
    // Command number(Dec): 61 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DateTimeDateTime:(NSString *)dateTime error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_InvoiceRangeStartValue:(NSString *)startValue endValue:(NSString *)endValue error:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_InvoiceRange_01EndValue:(NSString *)endValue error:(NSError **)error ;
    // Command number(Dec): 101 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_OperatorPasswordOperatorCode:(NSString *)operatorCode oldPassword:(NSString *)oldPassword newPassword:(NSString *)newPassword error:(NSError **)error ;
    // Command number(Dec): 127 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_StampNameOption:(NSString *)option stampName:(NSString *)stampName error:(NSError **)error ;
    // Command number(Dec): 202 - please check fiscal device documentation.
    -(NSDictionary *)config_Start_LogoLoadingParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 202 - please check fiscal device documentation.
    -(NSDictionary *)config_Logo_LoadingDataValue:(NSString *)dataValue error:(NSError **)error ;
    // Command number(Dec): 202 - please check fiscal device documentation.
    -(NSDictionary *)config_Stop_LogoLoadingParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 203 - please check fiscal device documentation.
    -(NSDictionary *)config_Start_StampLoadingParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 203 - please check fiscal device documentation.
    -(NSDictionary *)config_Stamp_LoadingDataValue:(NSString *)dataValue error:(NSError **)error ;
    // Command number(Dec): 203 - please check fiscal device documentation.
    -(NSDictionary *)config_Stop_StampLoadingParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_FpComBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_AutoPaperCuttingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PaperCuttingTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BarCodeHeightVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BarcodeNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ComPortBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ComPortProtocolVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_MainInterfaceTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_TimeOutBeforePrintFlushVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_WorkBatteryIncludedVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Dec2xLineSpacingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PrintFontTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_FooterEmptyLinesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_HeaderMinLinesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LogoPrintAfterFooterVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EnableNearPaperEndVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DateFromNAPServDisableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_AutoPowerOffVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BkLight_AutoOffVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadComPortVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadComBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadConnectionTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadReceiptCopiesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadReceiptInfoVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadPaymentMenuVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PinpadLoyaltyPaymentVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthEnableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthDiscoverabilityVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthPairingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthPinCodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthVersionVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BthAddressVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrLogNumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrExtendedReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrDoveriteliVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrWithoutPasswordsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrAskForPasswordVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrAskForVoidPasswordVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrConnectedOperReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrConnectedDeptReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrConnectedPluSalesReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrConnectedGroupsReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrConnectedCashReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrUserPeriodReportsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrPluDailyClearingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrSafeOpeningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrScaleBarMaskVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrNumberBarcodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_RegModeOnIdleVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_FlushAtEndOnlyVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrMidnightWarningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrMandatorySubtotalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_SellerVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_AutoMonthReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EcrUnsentWarningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_CurrNameLocalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_CurrNameForeignVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ExchangeRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Unit_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_HeaderVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_FooterVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_OperNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_OperPaswVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PayNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Payment_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DPxx_PluCodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyNDB_valueVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyNDB_percentageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyOTS_valueVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyOTS_percentageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyNDB_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_KeyOTS_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ServPaswVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ServMessageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ServiceDateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PrnQualityVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_PrintColumnsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EmptyLineAfterTotalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DblHeigh_totalinregVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Bold_paymentsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DublReceiptsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_IntUseReceiptsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BarcodePrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LogoPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DoveriteliPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ForeignPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_VatPrintEnableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_CondensedPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyZreportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyXreportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyDiagnosticsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyFmReportsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyJournalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyDateTimeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyCloseReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DsblKeyCancelReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ModemModelVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_SimPinVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LanMACVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DHCPenableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LAN_IPVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LAN_NetMaskVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LAN_GatewayVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LAN_PriDNSVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LAN_SecDNSVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_LANport_fpCommandsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_ItemGroups_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Dept_priceVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_Dept_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_DHL_AlgoVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EIK_validationVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_EGN_validationVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_BonusesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_TextReducedVATVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)config_Set_TAXlabelVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 50 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxRatesByPeriodAndReturnError:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 66 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_InvoiceRangeAndReturnError:(NSError **)error ;
    // Command number(Dec): 62 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateTime_01AndReturnError:(NSError **)error ;
    // Command number(Dec): 64 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastFiscRecordDataType:(NSString *)dataType error:(NSError **)error ;
    // Command number(Dec): 65 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfoDataType:(NSString *)dataType error:(NSError **)error ;
    // Command number(Dec): 68 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FreeFMRecordsAndReturnError:(NSError **)error ;
    // Command number(Dec): 70 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CashIn_CashOutAmountType:(NSString *)amountType amount:(NSString *)amount error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Print_Diagnostic_0InfoType:(NSString *)infoType error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(BOOL)info_Print_Diagnostic_XInfoType:(NSString *)infoType error:(NSError **)error ;
    // Command number(Dec): 71 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TaxTerminalInfoInfoType:(NSString *)infoType error:(NSError **)error ;
    // Command number(Dec): 74 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_StatusBytesAndReturnError:(NSError **)error ;
    // Command number(Dec): 76 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FTransactionStatusAndReturnError:(NSError **)error ;
    // Command number(Dec): 86 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMRecord_LastDateTimeAndReturnError:(NSError **)error ;
    // Command number(Dec): 87 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ItemGroupItemGroup:(NSString *)itemGroup error:(NSError **)error ;
    // Command number(Dec): 88 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DepartmentInfoDepartmentNumber:(NSString *)departmentNumber error:(NSError **)error ;
    // Command number(Dec): 90 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DiagnosticInfoCalcCRC:(NSString *)calcCRC error:(NSError **)error ;
    // Command number(Dec): 99 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EIKValueAndReturnError:(NSError **)error ;
    // Command number(Dec): 100 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ErrorDescriptionTargetCode:(NSString *)targetCode error:(NSError **)error ;
    // Command number(Dec): 103 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrentRecieptInfoAndReturnError:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C00Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C02Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C03Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C04Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 110 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AdditionalDailyInfo_C05Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 112 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_OperatorsDataOperator:(NSString *)operator error:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeviceInfo_01Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeviceInfo_02Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeviceInfo_03Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeviceInfo_04Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 123 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeviceInfo_05Option:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 135 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Modem_IMEIOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 135 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_IMSIOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 135 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ModemStatusOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 140 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ClientsInfoOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FpComBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AutoPaperCuttingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PaperCuttingTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BarCodeHeightVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BarcodeNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ComPortBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ComPortProtocolVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_MainInterfaceTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TimeOutBeforePrintFlushVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_WorkBatteryIncludedVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Dec2xLineSpacingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PrintFontTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FooterEmptyLinesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_HeaderMinLinesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LogoPrintAfterFooterVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EnableNearPaperEndVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateFromNAPServDisableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AutoPowerOffVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BkLight_AutoOffVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadComPortVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadComBaudRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadConnectionTypeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadReceiptCopiesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadReceiptInfoVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadPaymentMenuVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PinpadLoyaltyPaymentVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthEnableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthDiscoverabilityVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthPairingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthPinCodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthVersionVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BthAddressVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrLogNumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrExtendedReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrDoveriteliVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrWithoutPasswordsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrAskForPasswordVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrAskForVoidPasswordVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrConnectedOperReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrConnectedDeptReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrConnectedPluSalesReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrConnectedGroupsReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrConnectedCashReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrUserPeriodReportsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrPluDailyClearingVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrSafeOpeningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrScaleBarMaskVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrNumberBarcodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_RegModeOnIdleVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FlushAtEndOnlyVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrMidnightWarningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrMandatorySubtotalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_SellerVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_AutoMonthReportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EcrUnsentWarningVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrNameLocalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrNameForeignVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ExchangeRateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Unit_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_HeaderVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FooterVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_OperNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_OperPaswVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PayNameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Payment_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DPxx_PluCodeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyNDB_valueVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyNDB_percentageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyOTS_valueVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyOTS_percentageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyNDB_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_KeyOTS_forbiddenVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ServPaswVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ServMessageVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ServiceDateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PrnQualityVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_PrintColumnsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EmptyLineAfterTotalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DblHeigh_totalinregVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Bold_paymentsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DublReceiptsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_IntUseReceiptsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BarcodePrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LogoPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DoveriteliPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ForeignPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_VatPrintEnableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CondensedPrintVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyZreportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyXreportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyDiagnosticsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyFmReportsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyJournalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyDateTimeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyCloseReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DsblKeyCancelReceiptVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ModemModelVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_SimPinVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LanMACVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DHCPenableVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LAN_IPVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LAN_NetMaskVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LAN_GatewayVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LAN_PriDNSVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LAN_SecDNSVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LANport_fpCommandsVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_ItemGroups_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Dept_priceVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_Dept_nameVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DHL_AlgoVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EIK_validationVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EGN_validationVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_BonusesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TextReducedVATVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TAXlabelVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nZreportVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nResetVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nVatChangesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nIDnumberChangesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nFMnumberChangesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nTAXnumberChangesVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_valVatVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMDeviceIDVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_IDnumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FMnumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_TAXnumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FmWriteDateTimeVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_LastValiddateVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_UNPVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_StornoUNPVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_FiscalizedVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DFR_neededVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DecimalPointVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nBonVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nFBonVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nInvoiceVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_InvoiceRangeBegVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_InvoiceRangeEndVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nFBonDailyCountVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_nLastFiscalDocVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_CurrClerkVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EJNewJurnalVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_EJNumberVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DateLastSucceededSentVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_NapRegisteredVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 255 - please check fiscal device documentation.
    -(NSDictionary *)info_Get_DeregOnSeverVariableName:(NSString *)variableName index:(NSString *)index value:(NSString *)value error:(NSError **)error ;
    // Command number(Dec): 124 - please check fiscal device documentation.
    -(NSDictionary *)klen_Documents_InRangeFromDateTime:(NSString *)fromDateTime toDateTime:(NSString *)toDateTime inDocType:(NSString *)inDocType error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_SetDocument_ToReadOption:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_GetLine_AsTextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_GetLine_AsDataOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Print_DocumentOption:(NSString *)option docNum:(NSString *)docNum recType:(NSString *)recType error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_SetCSVDocument_ToReadOption:(NSString *)option firstDoc:(NSString *)firstDoc lastDoc:(NSString *)lastDoc error:(NSError **)error ;
    // Command number(Dec): 125 - please check fiscal device documentation.
    -(NSDictionary *)klen_Get_CSVData_AsTextOption:(NSString *)option error:(NSError **)error ;
    // Command number(Dec): 45 - please check fiscal device documentation.
    -(NSDictionary *)other_Check_ConnectionAndReturnError:(NSError **)error ;
    // Command number(Dec): 80 - please check fiscal device documentation.
    -(NSDictionary *)other_Sound_SignalHz:(NSString *)hz mSec:(NSString *)mSec error:(NSError **)error ;
    // Command number(Dec): 202 - please check fiscal device documentation.
    -(NSDictionary *)other_Power_OffParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 202 - please check fiscal device documentation.
    -(NSDictionary *)other_RestartParamValue:(NSString *)paramValue error:(NSError **)error ;
    // Command number(Dec): 83 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_DecimalsAndTaxRatesTaxA:(NSString *)taxA taxB:(NSString *)taxB taxC:(NSString *)taxC taxD:(NSString *)taxD taxE:(NSString *)taxE taxF:(NSString *)taxF taxG:(NSString *)taxG taxH:(NSString *)taxH decimalPoint:(NSString *)decimalPoint error:(NSError **)error ;
    // Command number(Dec): 89 - please check fiscal device documentation.
    -(NSDictionary *)service_Test_FiscalMemoryTestType:(NSString *)testType error:(NSError **)error ;
    // Command number(Dec): 91 - please check fiscal device documentation.
    -(NSDictionary *)service_Set_SerialNumberSerialNumber:(NSString *)serialNumber fMNumber:(NSString *)fMNumber error:(NSError **)error ;


/* machine-oriented interface - end */


@end


