/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.biometric;

import com.datecs.api.biometric.AnsiIso;
import com.datecs.api.biometric.TouchChipException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class TouchChip {
    public static final int IMAGE_SIZE_SMALL = 0;
    public static final int IMAGE_SIZE_LARGE = 1;
    public static final int IMAGE_FORMAT_ANSI = 0;
    public static final int IMAGE_FORMAT_ISO = 1;
    public static final int IMAGE_COMPRESSION_NONE = 0;
    public static final int TEMPLATE_FORMAT_NATIVE = 0;
    public static final int TEMPLATE_FORMAT_ANSI = 1;
    public static final int TEMPLATE_FORMAT_ISO_FMR = 2;
    public static final int TEMPLATE_FORMAT_ISO_FMC_N = 3;
    public static final int TEMPLATE_FORMAT_ISO_FMC_C = 4;

    protected TouchChip() {
    }

    protected abstract byte[] transmit(byte[] var1) throws IOException;

    private byte[] parseResponse(byte[] response) throws TouchChipException, IOException {
        int v;
        int error = 0;
        int index = 0;
        while (index < response.length) {
            v = response[index] & 0xFF;
            if (v >= 48 && v <= 57) break;
            ++index;
        }
        while (index < response.length) {
            v = response[index] & 0xFF;
            if (v < 48 || v > 57) {
                ++index;
                break;
            }
            error = error * 10 + v - 48;
            ++index;
        }
        if (error != 0) {
            throw new TouchChipException(-error);
        }
        byte[] tmp = new byte[response.length - index];
        System.arraycopy(response, index, tmp, 0, tmp.length);
        return tmp;
    }

    private String parseResponseAsString(byte[] response) throws TouchChipException, IOException {
        byte[] result = this.parseResponse(response);
        return new String(result);
    }

    public int enrolIdentity(byte[] identity) throws TouchChipException, IOException {
        if (identity.length > 100) {
            throw new IllegalArgumentException("The parameter 'identity' contains too much data");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(161);
        buffer.write(identity.length);
        buffer.write(identity);
        byte[] response = this.transmit(buffer.toByteArray());
        return Integer.parseInt(this.parseResponseAsString(response));
    }

    public int enrolIdentity(String identity) throws TouchChipException, IOException {
        return this.enrolIdentity(identity.getBytes());
    }

    public void deleteIdentity(int slot) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(162);
        buffer.write(slot);
        byte[] response = this.transmit(buffer.toByteArray());
        this.parseResponse(response);
    }

    public Identity checkIdentity() throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(163);
        byte[] response = this.transmit(buffer.toByteArray());
        byte[] array = this.parseResponse(response);
        return new Identity(array);
    }

    public int[] listSlots() throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(164);
        byte[] response = this.transmit(buffer.toByteArray());
        String[] array = this.parseResponseAsString(response).split(",");
        int[] tmp = new int[array.length];
        int i = 0;
        while (i < array.length) {
            tmp[i] = Integer.parseInt(array[i]);
            ++i;
        }
        return tmp;
    }

    public AnsiIso getIdentity(int imageSize, int imageFormat, int imageCompression, ImageReceiver receiver) throws TouchChipException, IOException {
        int totalBytes = this.getIdentity(imageSize, imageFormat, imageCompression);
        byte[] imageBuffer = new byte[totalBytes];
        int offset = 0;
        if (receiver != null) {
            receiver.onDataReceived(totalBytes, offset, new byte[0]);
        }
        while (offset < totalBytes) {
            int length = Math.min(totalBytes - offset, 2044);
            byte[] data = this.getImageData(offset, length);
            System.arraycopy(data, 0, imageBuffer, offset, data.length);
            offset += data.length;
            if (receiver == null) continue;
            receiver.onDataReceived(totalBytes, offset, data);
        }
        AnsiIso ansiIso = new AnsiIso(imageBuffer, imageFormat == 1);
        return ansiIso;
    }

    private int getIdentity(int imageSize, int imageFormat, int imageCompression) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(166);
        buffer.write(imageSize);
        buffer.write(imageFormat);
        buffer.write(imageCompression);
        byte[] response = this.transmit(buffer.toByteArray());
        byte[] tmp = this.parseResponse(response);
        int totalBytes = (tmp[0] & 0xFF) << 24 | (tmp[1] & 0xFF) << 16 | (tmp[2] & 0xFF) << 8 | (tmp[3] & 0xFF) << 0;
        return totalBytes;
    }

    private byte[] getImageData(int offset, int length) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(167);
        buffer.write(offset >> 24);
        buffer.write(offset >> 16);
        buffer.write(offset >> 8);
        buffer.write(offset >> 0);
        buffer.write(length >> 24);
        buffer.write(length >> 16);
        buffer.write(length >> 8);
        buffer.write(length >> 0);
        byte[] response = this.transmit(buffer.toByteArray());
        return this.parseResponse(response);
    }

    public void wipeIdentity() throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(168);
        byte[] response = this.transmit(buffer.toByteArray());
        this.parseResponse(response);
    }

    public String getLibraryInformation() throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(169);
        byte[] response = this.transmit(buffer.toByteArray());
        byte[] tmp = this.parseResponse(response);
        return new String(tmp);
    }

    public byte[] getTemplate(int format) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(170);
        buffer.write(format);
        byte[] response = this.transmit(buffer.toByteArray());
        byte[] tmp = this.parseResponse(response);
        return tmp;
    }

    public byte[] getTemplate(int format, int slot) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(171);
        buffer.write(slot);
        buffer.write(format);
        byte[] response = this.transmit(buffer.toByteArray());
        byte[] tmp = this.parseResponse(response);
        return tmp;
    }

    public int setTemplate(int format, byte[] data) throws TouchChipException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(172);
        buffer.write(format);
        buffer.write(data.length >> 24);
        buffer.write(data.length >> 16);
        buffer.write(data.length >> 8);
        buffer.write(data.length >> 0);
        buffer.write(data);
        byte[] response = this.transmit(buffer.toByteArray());
        return Integer.parseInt(this.parseResponseAsString(response));
    }

    public static class Identity {
        private int mSlot;
        private byte[] mIdentity;

        Identity(byte[] response) {
            int index = 0;
            index = 0;
            while (index < response.length) {
                int v = response[index] & 0xFF;
                if (v < 48 || v > 57) {
                    ++index;
                    break;
                }
                this.mSlot = this.mSlot * 10 + v - 48;
                ++index;
            }
            this.mIdentity = new byte[response.length - index];
            System.arraycopy(response, index, this.mIdentity, 0, this.mIdentity.length);
        }

        public int getSlot() {
            return this.mSlot;
        }

        public byte[] getIdentity() {
            return this.mIdentity;
        }

        public String getIdentityAsString() {
            return new String(this.mIdentity);
        }

        public String toString() {
            return "Identity [slot=" + this.getSlot() + ",identity=" + this.getIdentityAsString() + "]";
        }
    }

    public static interface ImageReceiver {
        public void onDataReceived(int var1, int var2, byte[] var3);
    }
}

