/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.smartcard;

public final class AnswerToReset {
    public static final int PROTOCOL_T0 = 0;
    public static final int PROTOCOL_T1 = 1;
    private byte[] mATR;

    public AnswerToReset(byte[] atr) {
        if (atr == null) {
            throw new NullPointerException("The atr is null");
        }
        if (atr.length < 1) {
            throw new IllegalArgumentException("The atr.length is less than 1");
        }
        this.mATR = new byte[atr.length];
        System.arraycopy(atr, 0, this.mATR, 0, this.mATR.length);
    }

    public int getProtocol() {
        return this.mATR[0] & 0xFF;
    }

    public byte[] getData() {
        byte[] buf = new byte[this.mATR.length - 1];
        System.arraycopy(this.mATR, 1, buf, 0, buf.length);
        return buf;
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.mATR.length];
        System.arraycopy(this.mATR, 0, b, 0, b.length);
        return b;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Protocol=" + this.getProtocol());
        if (this.mATR.length > 1) {
            sb.append(",ATR=");
            int i = 1;
            while (i < this.mATR.length) {
                sb.append(Integer.toHexString((this.mATR[i] & 0xFF) + 256).toUpperCase().substring(1));
                ++i;
            }
        }
        return sb.toString();
    }
}

