/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.smartcard;

public final class ResponseAPDU {
    private byte[] mAPDU = null;

    public ResponseAPDU(byte[] apdu) {
        if (apdu == null) {
            throw new NullPointerException("The apdu is null");
        }
        if (apdu.length < 2) {
            throw new IllegalArgumentException("The apdu.length is less than 2");
        }
        this.mAPDU = new byte[apdu.length];
        System.arraycopy(apdu, 0, this.mAPDU, 0, this.mAPDU.length);
    }

    public byte[] getData() {
        byte[] buf = new byte[this.mAPDU.length - 2];
        System.arraycopy(this.mAPDU, 0, buf, 0, buf.length);
        return buf;
    }

    public int getSW1() {
        return this.mAPDU[this.mAPDU.length - 2] & 0xFF;
    }

    public int getSW2() {
        return this.mAPDU[this.mAPDU.length - 1] & 0xFF;
    }

    public int getSW() {
        return (this.getSW1() << 8) + this.getSW2();
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.mAPDU.length];
        System.arraycopy(this.mAPDU, 0, b, 0, b.length);
        return b;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SW=" + Integer.toHexString((this.getSW() & 0xFFFF) + 65536).toUpperCase().substring(1));
        if (this.mAPDU.length > 2) {
            sb.append(",ADPU=");
            int i = 0;
            while (i < this.mAPDU.length - 2) {
                sb.append(Integer.toHexString((this.mAPDU[i] & 0xFF) + 256).toUpperCase().substring(1));
                ++i;
            }
        }
        return sb.toString();
    }
}

