/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.card;

public final class FinancialCard {
    private String mNumber;
    private String mName;
    private int mExpMonth;
    private int mExpYear;

    public FinancialCard(String data) {
        int li;
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        if (data.startsWith("%B")) {
            int fi = data.indexOf(94);
            int li2 = data.lastIndexOf(94);
            if (fi > 0) {
                this.mNumber = data.substring(2, fi);
            }
            if (fi < li2) {
                this.mName = data.substring(fi + 1, li2 - 1).trim();
            }
            if (li2 > 0 && li2 + 4 < data.length()) {
                this.mExpYear = (data.charAt(li2 + 1) & 0xF) * 10 + (data.charAt(li2 + 2) & 0xF);
                this.mExpMonth = (data.charAt(li2 + 3) & 0xF) * 10 + (data.charAt(li2 + 4) & 0xF);
            }
        } else if (data.startsWith(";") && (li = data.indexOf(61)) > 0 && li + 4 < data.length()) {
            this.mNumber = data.substring(1, li - 1);
            this.mExpYear = (data.charAt(li + 1) & 0xF) * 10 + (data.charAt(li + 2) & 0xF);
            this.mExpMonth = (data.charAt(li + 3) & 0xF) * 10 + (data.charAt(li + 4) & 0xF);
        }
    }

    public String getNumber() {
        return this.mNumber;
    }

    public String getName() {
        return this.mName;
    }

    public int getExpiryMonth() {
        return this.mExpMonth;
    }

    public int getExpiryYear() {
        return this.mExpYear;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number=" + this.mNumber);
        sb.append(",Name=" + this.mName);
        sb.append(",ExpiryMonth=" + this.mExpMonth);
        sb.append(",ExpiryYear=" + this.mExpYear);
        return sb.toString();
    }
}

