/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.printer;

import com.datecs.api.printer.PrinterInformation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Printer {
    private static final int IO_INTERVAL = 5000;
    private static final int IO_TIME = 5000;
    private static final int CARD_IO_TIME = 11000;
    private static final int BARCODE_IO_TIME = 11000;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int BARCODE_UPCA = 65;
    public static final int BARCODE_UPCE = 66;
    public static final int BARCODE_EAN13 = 67;
    public static final int BARCODE_EAN8 = 68;
    public static final int BARCODE_CODE39 = 69;
    public static final int BARCODE_ITF = 70;
    public static final int BARCODE_CODABAR = 71;
    public static final int BARCODE_CODE93 = 72;
    public static final int BARCODE_CODE128 = 73;
    public static final int BARCODE_PDF417 = 74;
    public static final int BARCODE_CODE128AUTO = 75;
    public static final int BARCODE_EAN128 = 76;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int PAGE_LEFT = 0;
    public static final int PAGE_BOTTOM = 1;
    public static final int PAGE_RIGHT = 2;
    public static final int PAGE_TOP = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_INVERTED = 2;
    private InputStream mIStream;
    private OutputStream mOStream;
    private Settings mSettings;

    public Printer(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mIStream = null;
        this.mOStream = out;
        this.init();
    }

    public Printer(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mIStream = in;
        this.mOStream = out;
        this.init();
    }

    private void init() {
        this.mSettings = new Settings();
        this.mSettings.barcodeAlign = 0;
        this.mSettings.barcodeScale = 3;
        this.mSettings.barcodeHeight = 162;
        this.mSettings.barcodeHriFont = 0;
        this.mSettings.barcodeHriCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("The b is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            throw new NullPointerException("The b is null");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("The b is out of bounds");
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(b, offset, length);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void clearBuffer() throws IOException {
        if (this.mIStream != null) ** GOTO lbl5
        throw new NullPointerException("The in is null");
lbl-1000:
        // 1 sources

        {
            this.mIStream.read();
lbl5:
            // 2 sources

            ** while (this.mIStream.available() > 0)
        }
lbl6:
        // 1 sources

    }

    private int readByte(int wait) throws IOException {
        if (this.mIStream == null) {
            throw new IOException("The in is null");
        }
        long stoptime = System.currentTimeMillis() + (long)wait;
        while (this.mIStream.available() == 0) {
            if (stoptime < System.currentTimeMillis()) {
                throw new IOException("Read timed out");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int status = this.mIStream.read();
        if (status == -1) {
            throw new IOException("The end of the stream is reached");
        }
        return status;
    }

    public int read() throws IOException {
        if (this.mIStream == null) {
            throw new IOException("The in is null");
        }
        if (this.mIStream.available() == 0) {
            return -1;
        }
        return this.mIStream.read();
    }

    public void flush() throws IOException {
        this.mOStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrinterInformation getInformation() throws IOException {
        byte[] buf;
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            buf = new byte[]{27, 90};
            this.mOStream.write(buf);
            this.mOStream.flush();
            int offset = 0;
            buf = new byte[32];
            buf[offset++] = (byte)this.readByte(5000);
            while (offset < buf.length) {
                buf[offset++] = (byte)this.readByte(5000);
            }
        }
        return new PrinterInformation(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVoltage() throws IOException {
        byte[] buf;
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            buf = new byte[]{27, 96};
            this.mOStream.write(buf);
            this.mOStream.flush();
            buf[0] = (byte)this.readByte(5000);
            buf[1] = (byte)this.readByte(5000);
        }
        return ((buf[0] & 0xFF) - 32) * 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTemperature() throws IOException {
        byte[] buf;
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            buf = new byte[]{27, 96};
            this.mOStream.write(buf);
            this.mOStream.flush();
            buf[0] = (byte)this.readByte(5000);
            buf[1] = (byte)this.readByte(5000);
        }
        return (buf[1] & 0xFF) - 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws IOException {
        byte[] buf;
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            buf = new byte[]{27, 118};
            this.mOStream.write(buf);
            this.mOStream.flush();
            buf[0] = (byte)this.readByte(5000);
        }
        return buf[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readCard(boolean first, boolean second, boolean third, int wait) throws IOException {
        String[] sbuf;
        if (!(first || second || third)) {
            throw new IllegalArgumentException("No track selected");
        }
        if (wait < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        int status = 0;
        int tracks = 0;
        if (first) {
            tracks |= 1;
        }
        if (second) {
            tracks |= 2;
        }
        if (third) {
            tracks |= 4;
        }
        byte[] buf = new byte[]{27, 63, (byte)tracks};
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            int repeat = wait / 11000;
            do {
                this.mOStream.write(buf);
                this.mOStream.flush();
            } while ((status = this.readByte(11000)) == 0 && repeat-- > 0);
            int index = -1;
            sbuf = new String[3];
            while (status != 0) {
                switch (status) {
                    case 241: {
                        index = 0;
                        sbuf[0] = "";
                        break;
                    }
                    case 242: {
                        index = 1;
                        sbuf[1] = "";
                        break;
                    }
                    case 243: {
                        index = 2;
                        sbuf[2] = "";
                        break;
                    }
                    default: {
                        if (index < 0) break;
                        int n = index;
                        sbuf[n] = String.valueOf(sbuf[n]) + (char)(status & 0xFF);
                    }
                }
                status = this.readByte(5000);
            }
        }
        return sbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readBarcode(int wait) throws IOException {
        StringBuffer sbuf;
        if (wait < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        int status = 0;
        byte[] buf = new byte[]{27, 114};
        Printer printer = this;
        synchronized (printer) {
            this.clearBuffer();
            int repeat = wait / 11000;
            do {
                this.mOStream.write(buf);
                this.mOStream.flush();
            } while ((status = this.readByte(11000)) == 0 && repeat-- > 0);
            sbuf = new StringBuffer();
            while (status != 0) {
                sbuf.append((char)(status & 0xFF));
                status = this.readByte(5000);
            }
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        byte[] byArray = new byte[14];
        byArray[0] = 27;
        byArray[1] = 64;
        byArray[2] = 27;
        byArray[3] = 50;
        byArray[4] = 27;
        byArray[5] = 73;
        byArray[7] = 27;
        byArray[8] = 33;
        byArray[10] = 29;
        byArray[11] = 76;
        byte[] buf = byArray;
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() throws IOException {
        byte[] buf = new byte[]{27, 43};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printSelfTest() throws IOException {
        byte[] buf = new byte[]{27, 46};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCodetable(int codetable) throws IOException {
        byte[] buf = new byte[]{27, 117, (byte)codetable};
        if (codetable < 0) {
            throw new IllegalArgumentException("The codetable is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineSpace(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 51, (byte)(lines & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlign(int align) throws IOException {
        byte[] buf;
        switch (align) {
            case 0: 
            case 1: 
            case 2: {
                buf = new byte[]{27, 97, (byte)align};
                break;
            }
            default: {
                throw new IllegalArgumentException("The align is illegal");
            }
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedPaper(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 74, (byte)lines};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(s.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(s.getBytes(encoding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTaggedText(byte[] b) throws IOException {
        int LEN = 6;
        int ELE = 123;
        int END = 125;
        int DET = 47;
        int BREAK = "br".hashCode();
        int SMALL = "s".hashCode();
        int BOLD = "b".hashCode();
        int HIGH = "h".hashCode();
        int WIDE = "w".hashCode();
        int UNDERLINE = "u".hashCode();
        int ITALIC = "i".hashCode();
        int RESET = "reset".hashCode();
        int LEFT = "left".hashCode();
        int CENTER = "center".hashCode();
        int RIGHT = "right".hashCode();
        if (b == null) {
            throw new NullPointerException("The b is null");
        }
        int len = b.length;
        byte[] tbuf = new byte[6 + len];
        int toffs = 0;
        byte mode = 0;
        int pos = 0;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 33;
        tbuf[toffs++] = mode;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 73;
        tbuf[toffs++] = 0;
        int i = 0;
        while (i < len) {
            byte value = b[i];
            tbuf[toffs++] = value;
            if (value == 123) {
                pos = toffs;
            } else if (value == 125 && pos >= 1 && toffs - 1 - 6 <= pos) {
                int index;
                boolean set;
                if (tbuf[pos] == 47) {
                    set = false;
                    index = pos + 1;
                } else {
                    set = true;
                    index = pos;
                }
                int hash = 0;
                int hashlen = toffs - 1 - index;
                int j = 0;
                while (j < hashlen) {
                    int c = tbuf[index + j] & 0xFF;
                    if (c >= 65 && c <= 90) {
                        c += 32;
                    }
                    hash = 31 * hash + c;
                    ++j;
                }
                if (hash == BREAK) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 10;
                } else if (hash == SMALL) {
                    mode = set ? (byte)(mode | 1) : (byte)(mode & 0xFFFFFFFE);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == BOLD) {
                    mode = set ? (byte)(mode | 8) : (byte)(mode & 0xFFFFFFF7);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == HIGH) {
                    mode = set ? (byte)(mode | 0x10) : (byte)(mode & 0xFFFFFFEF);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == WIDE) {
                    mode = set ? (byte)(mode | 0x20) : (byte)(mode & 0xFFFFFFDF);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == UNDERLINE) {
                    mode = set ? (byte)(mode | 0x80) : (byte)(mode & 0xFFFFFF7F);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == ITALIC) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 73;
                    tbuf[toffs++] = set ? (byte)1 : 0;
                } else if (hash == RESET) {
                    mode = 0;
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 73;
                    tbuf[toffs++] = 0;
                } else if (hash == LEFT) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 0;
                } else if (hash == CENTER) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 1;
                } else if (hash == RIGHT) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 2;
                }
            }
            ++i;
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(tbuf, 0, toffs);
        }
    }

    public void printTaggedText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes());
    }

    public void printTaggedText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes(encoding));
    }

    private static void convertARGBToGrayscale(int[] argb, int width, int height) {
        int pixels = width * height;
        int i = 0;
        while (i < pixels) {
            int color;
            int r = argb[i] >> 16 & 0xFF;
            int g = argb[i] >> 8 & 0xFF;
            int b = argb[i] & 0xFF;
            argb[i] = color = r * 19 + g * 38 + b * 7 >> 6 & 0xFF;
            ++i;
        }
    }

    private static void ditherImageByFloydSteinberg(int[] grayscale, int width, int height) {
        int stopXM1 = width - 1;
        int stopYM1 = height - 1;
        int[] coef = new int[]{3, 5, 1};
        int y = 0;
        int offs = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int ed;
                int error;
                int v = grayscale[offs];
                if (v < 128) {
                    grayscale[offs] = 0;
                    error = v;
                } else {
                    grayscale[offs] = 255;
                    error = v - 255;
                }
                if (x != stopXM1) {
                    ed = grayscale[offs + 1] + error * 7 / 16;
                    grayscale[offs + 1] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                }
                if (y != stopYM1) {
                    int i = -1;
                    int j = 0;
                    while (i <= 1) {
                        if (x + i >= 0 && x + i < width) {
                            ed = grayscale[offs + width + i] + error * coef[j] / 16;
                            grayscale[offs + width + i] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                        }
                        ++i;
                        ++j;
                    }
                }
                ++x;
                ++offs;
            }
            ++y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printImage(int[] argb, int width, int height, int align, boolean dither) throws IOException {
        byte[] buf = null;
        int bufOffs = 0;
        if (argb == null) {
            throw new NullPointerException("The argb is null");
        }
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The size of image is illegal");
        }
        Printer.convertARGBToGrayscale(argb, width, height);
        if (dither) {
            Printer.ditherImageByFloydSteinberg(argb, width, height);
        }
        buf = new byte[width * 3 + 9];
        Printer printer = this;
        synchronized (printer) {
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 51;
            buf[bufOffs++] = 24;
            this.mOStream.write(buf, 0, bufOffs);
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 97;
            buf[bufOffs++] = (byte)align;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 42;
            buf[bufOffs++] = 33;
            buf[bufOffs++] = (byte)(width % 256);
            buf[bufOffs++] = (byte)(width / 256);
            buf[buf.length - 1] = 10;
            int j = 0;
            int offs = 0;
            while (j < height) {
                int i;
                if (j > 0 && j % 24 == 0) {
                    this.mOStream.write(buf);
                    i = bufOffs;
                    while (i < buf.length - 1) {
                        buf[i] = 0;
                        ++i;
                    }
                }
                i = 0;
                while (i < width) {
                    int n = bufOffs + i * 3 + j % 24 / 8;
                    buf[n] = (byte)(buf[n] | (byte)((argb[offs] < 128 ? 1 : 0) << 7 - j % 8));
                    ++i;
                    ++offs;
                }
                ++j;
            }
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo(boolean wide, boolean high) throws IOException {
        byte mode = 0;
        if (wide) {
            mode = (byte)(mode + 1);
        }
        if (high) {
            mode = (byte)(mode + 2);
        }
        byte[] buf = new byte[]{29, 47, mode};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo() throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 47;
        byte[] buf = byArray;
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    public void setBarcode(int align, boolean small, int scale, int hri, int height) {
        if (align < 0) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (scale < 2 || scale > 4) {
            throw new IllegalArgumentException("The scale is illegal");
        }
        if (hri < 0) {
            throw new IllegalArgumentException("The hri is negative");
        }
        if (height < 1 || height > 255) {
            throw new IllegalArgumentException("The height is illegal");
        }
        this.mSettings.barcodeAlign = align;
        this.mSettings.barcodeHriFont = small ? 1 : 0;
        this.mSettings.barcodeScale = scale;
        this.mSettings.barcodeHriCode = hri;
        this.mSettings.barcodeHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBarcode(int type, byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null.");
        }
        byte[] buf = new byte[21 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 119;
        buf[offs++] = (byte)this.mSettings.barcodeScale;
        buf[offs++] = 29;
        buf[offs++] = 104;
        buf[offs++] = (byte)this.mSettings.barcodeHeight;
        buf[offs++] = 29;
        buf[offs++] = 72;
        buf[offs++] = (byte)this.mSettings.barcodeHriCode;
        buf[offs++] = 29;
        buf[offs++] = 102;
        buf[offs++] = (byte)this.mSettings.barcodeHriFont;
        switch (type) {
            case 65: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCA barcode data must be 11 symbols");
            }
            case 66: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCE barcode data must be 11 symbols");
            }
            case 67: {
                if (data.length == 12) break;
                throw new IllegalArgumentException("The length of EAN13 barcode data must be 12 symbols");
            }
            case 68: {
                if (data.length == 7) break;
                throw new IllegalArgumentException("The length of EAN8 barcode data must be 7 symbols");
            }
            case 74: {
                if (data.length >= 1 && data.length <= 1000) break;
                throw new IllegalArgumentException("The length of PDF417 barcode data must be between 1 and 1000 symbols");
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: {
                if (data.length >= 1 && data.length <= 255) break;
                throw new IllegalArgumentException("The length of barcode data must be between 1 and 255 symbols");
            }
            default: {
                throw new IllegalArgumentException("Invalid barcode type");
            }
        }
        buf[offs++] = 29;
        buf[offs++] = 107;
        buf[offs++] = (byte)type;
        if (type == 73 && data[0] != 123) {
            buf[offs++] = (byte)(data.length + 2);
            buf[offs++] = 123;
            buf[offs++] = 66;
        } else if (type == 74) {
            buf[offs++] = 0;
            buf[offs++] = (byte)(data.length & 0xFF);
            buf[offs++] = (byte)(data.length >> 8 & 0xFF);
        } else {
            buf[offs++] = (byte)data.length;
        }
        int i = 0;
        while (i < data.length) {
            buf[offs++] = data[i];
            ++i;
        }
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf, 0, offs);
        }
    }

    public void printBarcode(int type, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printBarcode(type, data.getBytes());
    }

    public void printQRCode(int size, int eccLv, byte[] data) throws IOException {
        byte[] buf = new byte[10 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 81;
        buf[offs++] = 6;
        buf[offs++] = (byte)size;
        buf[offs++] = (byte)eccLv;
        buf[offs++] = (byte)data.length;
        buf[offs++] = (byte)(data.length >> 8);
        int i = 0;
        while (i < data.length) {
            buf[offs++] = data[i];
            ++i;
        }
        this.write(buf);
    }

    public void printQRCode(int size, int eccLv, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printQRCode(size, eccLv, data.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPageMode() throws IOException {
        byte[] buf = new byte[]{27, 76, 24};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectStandardMode() throws IOException {
        byte[] buf = new byte[]{29, 85};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage() throws IOException {
        byte[] buf = new byte[]{29, 90};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageRegion(int x, int y, int width, int height, int direction) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || direction < 0 || direction > 3) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 87, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), 29, 84, (byte)(direction & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageXY(int x, int y) throws IOException {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 36, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), 29, 36, (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageRectangle(int x, int y, int width, int height, int fillMode) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 82, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageFrame(int x, int y, int width, int height, int fillMode, int thickness) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2 || thickness < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 88, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF), (byte)(thickness & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.mOStream.write(buf);
        }
    }

    private class Settings {
        public int barcodeAlign;
        public int barcodeScale;
        public int barcodeHeight;
        public int barcodeHriFont;
        public int barcodeHriCode;

        private Settings() {
        }
    }
}

