/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.printer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtocolAdapter {
    public static final int CHANNEL_PRINTER = 1;
    public static final int CHANNEL_UNIVERSAL_READER = 16;
    private InputStream mBaseIStream;
    private OutputStream mBaseOStream;

    public ProtocolAdapter(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseIStream = in;
        this.mBaseOStream = out;
    }

    public Channel getChannel(int channel) {
        return new Channel(this, channel);
    }

    public synchronized boolean isProtocolEnabled() throws IOException {
        int status;
        byte[] buf = new byte[4];
        while (this.mBaseIStream.available() > 0) {
            status = this.mBaseIStream.read();
            if (status != -1) continue;
            return false;
        }
        this.mBaseOStream.write(buf);
        this.mBaseOStream.flush();
        int bytes_recv = 0;
        long stop_time = System.currentTimeMillis() + 1000L;
        while (bytes_recv < buf.length) {
            if (this.mBaseIStream.available() > 0) {
                status = this.mBaseIStream.read();
                if (status == -1) {
                    return false;
                }
                buf[bytes_recv++] = (byte)(status & 0xFF);
                continue;
            }
            if (System.currentTimeMillis() > stop_time) {
                return false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return buf[0] == -128;
    }

    public final class Channel {
        private static final int IO_TIOMEOUT = 3000;
        private static final int IO_WAIT = 50;
        private static final int IN_BUFF_SIZE = 2048;
        private static final int HEADER_SIZE = 4;
        private static final int COMMAND_OPEN = 0;
        private static final int COMMAND_CLOSE = 1;
        private static final int COMMAND_SEND = 2;
        private static final int COMMAND_REQUEST = 3;
        private static final int COMMAND_GETSTATUS = 4;
        private static final int COMMAND_SETPORT = 5;
        private static final int STATUS_FAILED = 1;
        private static final int STATUS_FULL = 2;
        private static final int STATUS_INVALID = 4;
        private static final int STATUS_LOWBATTERY = 8;
        private static final int STATUS_OVERHEATED = 16;
        private static final int STATUS_NOPAPER = 32;
        private int mChannel;
        private InputStream mIStream;
        private OutputStream mOStream;
        private byte[] mIBuffer;
        private byte[] mOBuffer;
        private int mIBufferLen;
        private int mLastStatus;
        private ChannelListener mListener;
        private ProtocolAdapter mAdapter;

        private Channel(ProtocolAdapter adapter, int channel) {
            this.mAdapter = adapter;
            this.mChannel = channel;
            this.mIStream = adapter.mBaseIStream;
            this.mOStream = adapter.mBaseOStream;
            this.mOBuffer = new byte[4];
            this.mIBuffer = new byte[2052];
            this.mIBufferLen = 0;
            this.mLastStatus = 0;
            this.mListener = null;
        }

        public int getChannel() {
            return this.mChannel;
        }

        public void setListener(ChannelListener listener) {
            this.mListener = listener;
        }

        private void writePacket(int command, byte[] data, int offs, int length) throws IOException {
            this.mOBuffer[0] = (byte)this.mChannel;
            this.mOBuffer[1] = (byte)command;
            this.mOBuffer[2] = (byte)(data == null ? 0 : length >> 8);
            this.mOBuffer[3] = (byte)(data == null ? 0 : length & 0xFF);
            if (data != null && (offs < 0 || length < 0 || offs + length > data.length)) {
                throw new IndexOutOfBoundsException("The index out of bounds");
            }
            this.mOStream.write(this.mOBuffer);
            if (data != null && length > 0) {
                this.mOStream.write(data, offs, length);
            }
            this.mOStream.flush();
        }

        private void readPacket() throws IOException {
            this.mIBufferLen = 0;
            int bytes_to_recv = 4;
            long stop_time = System.currentTimeMillis() + 3000L;
            while (this.mIBufferLen < bytes_to_recv) {
                if (this.mIStream.available() > 0) {
                    int status = this.mIStream.read(this.mIBuffer, this.mIBufferLen, bytes_to_recv - this.mIBufferLen);
                    if (status == -1) {
                        throw new IOException("The end of the stream is reached");
                    }
                    this.mIBufferLen += status;
                    if (this.mIBufferLen != 4 || (bytes_to_recv += ((this.mIBuffer[2] & 0xFF) << 8) + (this.mIBuffer[3] & 0xFF)) <= this.mIBuffer.length) continue;
                    throw new IOException("Too much data in channel");
                }
                if (stop_time < System.currentTimeMillis()) {
                    throw new IOException("Protocol read timed out");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((this.mIBuffer[0] & 0xFF) != (this.mChannel ^ 0x80)) {
                throw new IOException("The illegal protocol packet");
            }
            this.mLastStatus = this.mIBuffer[1] & 0xFF;
            if ((this.mLastStatus & 1) != 0) {
                throw new IOException("The protocol command failed");
            }
            if ((this.mLastStatus & 4) != 0) {
                throw new IOException("The protocol command is invalid");
            }
            if (this.mChannel == 1 && (this.mLastStatus & 8) > 0 && this.mListener != null) {
                this.mListener.onLowBattery();
            }
            if (this.mChannel == 1 && (this.mLastStatus & 0x10) > 0 && this.mListener != null) {
                this.mListener.onOverHeated();
            }
            if (this.mChannel == 1 && (this.mLastStatus & 0x20) > 0 && this.mListener != null) {
                this.mListener.onNoPaper();
            }
        }

        private void clear() throws IOException {
            while (this.mIStream.available() > 0) {
                this.mIStream.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(byte[] buf, int offset, int length) throws IOException {
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                if (buf != null) {
                    while (length > 0) {
                        int bytes_to_send = length > 2048 ? 2048 : length;
                        this.writePacket(2, buf, offset, bytes_to_send);
                        this.readPacket();
                        if ((this.mLastStatus & 2) > 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        offset += bytes_to_send;
                        length -= bytes_to_send;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int read(byte[] buf, int offset, int length) throws IOException {
            int received;
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                this.writePacket(3, null, 0, 0);
                this.readPacket();
                received = this.mIBufferLen - 4;
                if (length < received) {
                    throw new IOException("Too much data in protocol packet");
                }
                int i = 0;
                while (i < received) {
                    buf[i + offset] = this.mIBuffer[4 + i];
                    ++i;
                }
            }
            return received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() throws IOException {
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                this.writePacket(0, null, 0, 0);
                this.readPacket();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                this.writePacket(1, null, 0, 0);
                this.readPacket();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChannel(int speed, int flow) throws IOException {
            byte[] buf = new byte[]{(byte)speed, (byte)flow};
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                this.writePacket(5, buf, 0, buf.length);
                this.readPacket();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getStatus() throws IOException {
            byte[] buf;
            ProtocolAdapter protocolAdapter = this.mAdapter;
            synchronized (protocolAdapter) {
                this.clear();
                this.writePacket(4, null, 0, 0);
                this.readPacket();
                buf = new byte[this.mIBufferLen - 4];
                int i = 0;
                while (i < buf.length) {
                    buf[i] = this.mIBuffer[4 + i];
                    ++i;
                }
            }
            return buf;
        }

        public InputStream getInputStream() {
            return new InputStream(this){
                private boolean mClosed;
                private byte[] mBuf;
                private int mOffset;
                private int mLength;
                final /* synthetic */ Channel this$1;
                {
                    this.this$1 = channel;
                    this.mClosed = false;
                    this.mBuf = new byte[2048];
                    this.mOffset = 0;
                    this.mLength = 0;
                }

                public int available() throws IOException {
                    if (this.mClosed) {
                        throw new IOException("The stream is closed");
                    }
                    if (this.mLength == 0) {
                        this.mOffset = 0;
                        this.mLength = Channel.access$0(this.this$1, this.mBuf, 0, this.mBuf.length);
                    }
                    return this.mLength;
                }

                public int read() throws IOException {
                    while (this.available() == 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    --this.mLength;
                    return this.mBuf[this.mOffset++] & 0xFF;
                }

                public void close() throws IOException {
                    this.mClosed = true;
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(this){
                private boolean mClosed;
                private byte[] mBuf;
                final /* synthetic */ Channel this$1;
                {
                    this.this$1 = channel;
                    this.mClosed = false;
                }

                public void write(int b) throws IOException {
                    if (this.mBuf == null) {
                        this.mBuf = new byte[1];
                    }
                    this.mBuf[0] = (byte)(b & 0xFF);
                    this.write(this.mBuf);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    if (this.mClosed) {
                        throw new IOException("The stream is closed");
                    }
                    Channel.access$1(this.this$1, b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                public void close() throws IOException {
                    this.mClosed = true;
                }
            };
        }

        static /* synthetic */ int access$0(Channel channel, byte[] byArray, int n, int n2) throws IOException {
            return channel.read(byArray, n, n2);
        }

        static /* synthetic */ void access$1(Channel channel, byte[] byArray, int n, int n2) throws IOException {
            channel.write(byArray, n, n2);
        }
    }

    public static interface ChannelListener {
        public void onLowBattery();

        public void onOverHeated();

        public void onNoPaper();
    }
}

