/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.universalreader;

import com.datecs.api.smartcard.AnswerToReset;
import com.datecs.api.smartcard.ResponseAPDU;
import com.datecs.api.universalreader.TouchEvent;
import com.datecs.api.universalreader.UniversalReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UniversalReader {
    private static final int PACKET_HEADER_SIZE = 4;
    private static final int PACKET_MAX_SIZE = 260;
    private static final int IO_INTERVAL = 3000;
    private static final int IO_TIME = 3000;
    private static final int BARCODE_IO_TIME = 6000;
    private static final int STATUS_ERROR = 1;
    private static final int STATUS_PRESSED = 2;
    private static final int STATUS_AUTO = 4;
    private static final int STATUS_MULTIFRAME = 8;
    private static final int COMMAND_IDENTIFICATION = 1;
    private static final int COMMAND_POWER = 2;
    private static final int COMMAND_SMARTCARD_AVAILABLE = 3;
    private static final int COMMAND_GET_STATUS = 5;
    private static final int COMMAND_SMARTCARD_SELECT = 6;
    private static final int COMMAND_SMARTCARD_RESET = 16;
    private static final int COMMAND_SMARTCARD_APDU_OUT = 17;
    private static final int COMMAND_SMARTCARD_APDU_IN = 18;
    private static final int COMMAND_SMARTCARD_C_APDU = 19;
    private static final int COMMAND_BARCODE_READ = 33;
    private static final int COMMAND_TOUCHSCREEN_GETCOORDS = 49;
    private static final int COMMAND_MIFARE = 57;
    private static final int COMMAND_CAPABILITIES = 254;
    public static final int ERROR_0K = 0;
    public static final int ERROR_INVALID = 1;
    public static final int ERROR_NOTPERMITTED = 2;
    public static final int ERROR_CARD = 3;
    public static final int ERROR_SYNTAX = 4;
    public static final int ERROR_NORESPONCE = 5;
    public static final int ERROR_NODATA = 6;
    public static final int ERROR_BARCODE = 16;
    public static final int ERROR_BARCODE_NODATA = 17;
    public static final int ERROR_BARCODE_INVALID = 18;
    public static final int ERROR_BARCODE_NOTPRESENT = 19;
    public static final int ERROR_MIFARE_TIMEOUT = -1;
    public static final int ERROR_MIFARE_COLLISION = -2;
    public static final int ERROR_MIFARE_PARITY = -3;
    public static final int ERROR_MIFARE_FRAME = -4;
    public static final int ERROR_MIFARE_CRC = -5;
    public static final int ERROR_MIFARE_FIFO = -6;
    public static final int ERROR_MIFARE_EEPROM = -7;
    public static final int ERROR_MIFARE_KEY = -8;
    public static final int ERROR_MIFARE_GENERIC = -9;
    public static final int ERROR_MIFARE_AUTHENTICATION = -10;
    public static final int ERROR_MIFARE_CODE = -11;
    public static final int ERROR_MIFARE_BIT = -12;
    public static final int ERROR_MIFARE_ACCESS = -13;
    public static final int ERROR_MIFARE_VALUE = -14;
    public static final int CAPABILITY_DEBUG = 1;
    public static final int CAPABILITY_SMARTCARD = 2;
    public static final int CAPABILITY_BARCODE = 4;
    public static final int CAPABILITY_TOUCHSCREEN = 8;
    public static final int CAPABILITY_GSM = 16;
    public static final int CAPABILITY_MIFARE = 32;
    public static final int CAPABILITY_BUTTON = 64;
    public static final int CAPABILITY_LCD2X16 = 128;
    public static final int CAPABILITY_FIRMWARE = 256;
    public static final int CAPABILITY_MAGNETIC = 512;
    public static final int CAPABILITY_EV15 = 1024;
    private InputStream mIStream = null;
    private OutputStream mOStream = null;
    private byte mSB1 = 0;
    private byte mSB2 = 0;
    private byte[] mBuf = new byte[260];

    public UniversalReader(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("The in is null.");
        }
        this.mIStream = in;
        if (out == null) {
            throw new NullPointerException("The out is null.");
        }
        this.mOStream = out;
    }

    private void clear() throws IOException {
        while (this.mIStream.available() > 0) {
            this.mIStream.read();
        }
    }

    private void writePacket(int command, byte[] data) throws IOException {
        int len = data != null && data.length > 0 ? data.length : 0;
        if (len > 256) {
            throw new IllegalArgumentException("The data.length is invalid");
        }
        this.mBuf[0] = (byte)(command & 0xFF);
        this.mBuf[1] = 0;
        this.mBuf[2] = 0;
        this.mBuf[3] = (byte)(len & 0xFF);
        if (len > 0) {
            System.arraycopy(data, 0, this.mBuf, 4, len);
        }
        this.mOStream.write(this.mBuf, 0, 4 + len);
        this.mOStream.flush();
    }

    private int read(int wait, byte[] b, int off, int len) throws IOException {
        long stoptime = System.currentTimeMillis() + (long)wait;
        while (this.mIStream.available() == 0) {
            if (stoptime < System.currentTimeMillis()) {
                throw new IOException("Read timed out");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int status = this.mIStream.read(b, off, len);
        if (status == -1) {
            throw new IOException("The end of the stream is reached");
        }
        return status;
    }

    private int readPacket(int wait) throws IOException {
        int off = this.read(wait, this.mBuf, 0, 4);
        while (off < 4) {
            off += this.read(3000, this.mBuf, off, 4 - off);
        }
        this.mSB1 = this.mBuf[0];
        this.mSB2 = this.mBuf[1];
        int len = this.mBuf[3] & 0xFF;
        int total = 4 + len;
        while (off < total) {
            off += this.read(3000, this.mBuf, off, total - off);
        }
        return len;
    }

    private byte[] readFrame(int wait) throws IOException {
        byte[] dbuf = null;
        byte[] tbuf = null;
        do {
            int length = this.readPacket(wait);
            if (dbuf == null) {
                dbuf = new byte[length];
            } else {
                tbuf = new byte[dbuf.length + length];
                System.arraycopy(dbuf, 0, tbuf, 0, dbuf.length);
                dbuf = tbuf;
            }
            System.arraycopy(this.mBuf, 4, dbuf, dbuf.length - length, length);
        } while ((this.mSB1 & 8) != 0);
        return dbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] executeCmd(int command, byte[] data, int wait) throws IOException, UniversalReaderException {
        byte[] buf;
        UniversalReader universalReader = this;
        synchronized (universalReader) {
            this.clear();
            this.writePacket(command, data);
            do {
                String msg;
                buf = this.readFrame(wait);
                if ((this.mSB1 & 1) == 0) continue;
                switch (this.mSB2 & 0xFF) {
                    case 0: {
                        msg = "Operation sucessful";
                        break;
                    }
                    case 1: {
                        msg = "Invalid command code";
                        break;
                    }
                    case 2: {
                        msg = "Command not permitted";
                        break;
                    }
                    case 3: {
                        msg = "Card error";
                        break;
                    }
                    case 4: {
                        msg = "Syntax error";
                        break;
                    }
                    case 5: {
                        msg = "No response from device";
                        break;
                    }
                    case 6: {
                        msg = "No data available";
                        break;
                    }
                    case 16: {
                        msg = "Barcode reader communication error";
                        break;
                    }
                    case 17: {
                        msg = "No barcode read";
                        break;
                    }
                    case 18: {
                        msg = "Barcode reader invalid command";
                        break;
                    }
                    case 19: {
                        msg = "Barcode reader not present";
                        break;
                    }
                    default: {
                        msg = "Unknown reason";
                    }
                }
                throw new UniversalReaderException(msg, this.mSB2 & 0xFF);
            } while ((this.mSB1 & 4) != 0);
        }
        return buf;
    }

    private byte[] executeCmd(int command, byte[] data) throws IOException, UniversalReaderException {
        return this.executeCmd(command, data, 3000);
    }

    public String getIdentification() throws IOException, UniversalReaderException {
        byte[] buf = this.executeCmd(1, null);
        return new String(buf, 0, buf.length - 2);
    }

    public boolean isButtonPressed() throws IOException, UniversalReaderException {
        return this.isButtonPressed(true);
    }

    public boolean isButtonPressed(boolean update) throws IOException, UniversalReaderException {
        if (update) {
            this.executeCmd(5, null);
        }
        return (this.mSB1 & 2) != 0;
    }

    public void turnOff() throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{3};
        this.executeCmd(2, buf);
    }

    public void setAutoOff(int time) throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{4, (byte)(time >> 8), (byte)time};
        this.executeCmd(2, buf);
    }

    public void playSound(int frequency, int duration) throws IOException, UniversalReaderException {
        byte[] byArray = new byte[6];
        byArray[0] = 9;
        byArray[2] = (byte)(frequency >> 8);
        byArray[3] = (byte)frequency;
        byArray[4] = (byte)(duration >> 8);
        byArray[5] = (byte)duration;
        byte[] buf = byArray;
        this.executeCmd(2, buf);
    }

    public void displayText(String first, String second) throws IOException, UniversalReaderException {
        byte[] bufFirst = first.getBytes();
        byte[] bufSecond = second.getBytes();
        byte[] buf = new byte[33];
        buf[0] = 10;
        int i = 0;
        while (i < 16 && i < bufFirst.length) {
            buf[1 + i] = bufFirst[i];
            ++i;
        }
        i = 0;
        while (i < 16 && i < bufSecond.length) {
            buf[17 + i] = bufSecond[i];
            ++i;
        }
        this.executeCmd(2, buf);
    }

    public String getSerialNumber() throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{12};
        buf = this.executeCmd(2, buf);
        StringBuffer sb = new StringBuffer(16);
        int i = 0;
        while (i < buf.length && buf[i] != 0) {
            sb.append((char)buf[i]);
            ++i;
        }
        return sb.toString();
    }

    public int getCapabilities() throws IOException, UniversalReaderException {
        byte[] buf = this.executeCmd(254, null);
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public BarcodeReader getBarcodeReader() {
        return new BarcodeReader();
    }

    public SmartCardReader getSmartCardReader() {
        return new SmartCardReader();
    }

    public TouchScreen getTouchScreen() {
        return new TouchScreen();
    }

    public MifareReader getMifareReader() {
        return new MifareReader();
    }

    public final class BarcodeReader {
        private BarcodeReader() {
        }

        public String read() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(33, null, 6000);
            return new String(buf);
        }
    }

    public final class MifareReader {
        private MifareReader() {
        }

        public void setPower(boolean on) throws IOException, UniversalReaderException {
            byte[] buf;
            if (on) {
                byte[] byArray = new byte[2];
                byArray[1] = 1;
                buf = byArray;
            } else {
                buf = new byte[2];
            }
            UniversalReader.this.executeCmd(57, buf);
        }

        private void checkMifareStatus(byte status) throws UniversalReaderException {
            String msg;
            if (status == 0) {
                return;
            }
            switch (status) {
                case -1: {
                    msg = "Mifare timeout error";
                    break;
                }
                case -2: {
                    msg = "Mifare collision error";
                    break;
                }
                case -3: {
                    msg = "Mifare parity error";
                    break;
                }
                case -4: {
                    msg = "Mifare frame error";
                    break;
                }
                case -5: {
                    msg = "Mifare CRC error";
                    break;
                }
                case -6: {
                    msg = "Mifare FIFO overflow";
                    break;
                }
                case -7: {
                    msg = "Mifare EEPROM error";
                    break;
                }
                case -8: {
                    msg = "Mifare invalid key";
                    break;
                }
                case -9: {
                    msg = "Mifare generic error";
                    break;
                }
                case -10: {
                    msg = "Mifare authentication error";
                    break;
                }
                case -11: {
                    msg = "Mifare code error";
                    break;
                }
                case -12: {
                    msg = "Mifare bit count error";
                    break;
                }
                case -13: {
                    msg = "Mifare access error";
                    break;
                }
                case -14: {
                    msg = "Mifare value error";
                    break;
                }
                default: {
                    msg = "Mifare unknown error " + status;
                }
            }
            throw new UniversalReaderException(msg, status);
        }

        public void config() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{1};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public int request(boolean all) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{2, (byte)(all ? 1 : 0)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 8) + (buf[2] & 0xFF);
        }

        public int anticollision() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{3};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 8) + (buf[4] & 0xFF);
        }

        public int select(int sn) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{4, (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return buf[1] & 0xFF;
        }

        public void authenticate(int sn, int block, int type, byte[] key) throws IOException, UniversalReaderException {
            if (key == null) {
                throw new NullPointerException("The key is null");
            }
            if (key.length != 6) {
                throw new IllegalArgumentException("The key.length is invalid");
            }
            byte[] buf = new byte[]{5, key[0], key[1], key[2], key[3], key[4], key[5], (byte)(type & 0xFF), (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF), (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public byte[] read(int block) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{6, (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            byte[] tbuf = new byte[buf.length - 1];
            System.arraycopy(buf, 1, tbuf, 0, tbuf.length);
            return tbuf;
        }

        public void write(int block, byte[] data) throws IOException, UniversalReaderException {
            if (data == null) {
                throw new NullPointerException("The data is null");
            }
            if (data.length != 16) {
                throw new IllegalArgumentException("The data.length is invalid");
            }
            byte[] buf = new byte[17];
            buf[0] = 7;
            System.arraycopy(data, 0, buf, 1, data.length);
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void increment(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -63, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void decrement(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -64, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void restore(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -62, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void halt() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{9};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public int getSerialNumber() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{10};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 8) + (buf[4] & 0xFF);
        }

        public void writeEeprom(int address, byte[] data) throws IOException, UniversalReaderException {
            if (data == null) {
                throw new NullPointerException("The data is null");
            }
            if (data.length < 1 || data.length > 255) {
                throw new IllegalArgumentException("The data.length is invalid");
            }
            byte[] buf = new byte[3 + data.length];
            buf[0] = 11;
            buf[1] = (byte)(address >> 8);
            buf[2] = (byte)(address & 0xFF);
            System.arraycopy(data, 0, buf, 3, data.length);
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void write(int block, int data) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{12, (byte)(block & 0xFF), (byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)(data & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void loadKey(int selector, byte[] key) throws IOException, UniversalReaderException {
            if (key == null) {
                throw new NullPointerException("The key is null");
            }
            if (key.length != 6) {
                throw new IllegalArgumentException("The key.length is invalid");
            }
            byte[] buf = new byte[]{13, (byte)(selector & 0xFF), key[0], key[1], key[2], key[3], key[4], key[5]};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void authenticate(int sn, int block, int type, int selector) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{14, (byte)(type & 0xFF), (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF), (byte)(selector & 0xFF), (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public byte[] readEeprom(int address, int length) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{15, (byte)(address >> 8), (byte)(address & 0xFF), (byte)(length & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            byte[] tbuf = new byte[buf.length - 1];
            System.arraycopy(buf, 1, tbuf, 0, tbuf.length);
            return tbuf;
        }
    }

    public final class SmartCardReader {
        private SmartCardReader() {
        }

        public void setPower(boolean on) throws IOException, UniversalReaderException {
            byte[] buf = null;
            buf = on ? new byte[]{1} : new byte[1];
            UniversalReader.this.executeCmd(2, buf);
        }

        public AnswerToReset reset() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(16, null);
            return new AnswerToReset(buf);
        }

        public ResponseAPDU write(int cla, int ins, int p1, int p2, byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            int datalen = 0;
            datalen = data != null ? data.length : 0;
            buf = new byte[5 + datalen];
            buf[0] = (byte)(cla & 0xFF);
            buf[1] = (byte)(ins & 0xFF);
            buf[2] = (byte)(p1 & 0xFF);
            buf[3] = (byte)(p2 & 0xFF);
            buf[4] = (byte)(datalen & 0xFF);
            if (datalen > 0) {
                int i = 0;
                while (i < datalen) {
                    buf[i + 5] = data[i];
                    ++i;
                }
            }
            buf = UniversalReader.this.executeCmd(17, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU write(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(17, data);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU read(int cla, int ins, int p1, int p2, int lc) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{(byte)(cla & 0xFF), (byte)(ins & 0xFF), (byte)(p1 & 0xFF), (byte)(p2 & 0xFF), (byte)(lc & 0xFF)};
            buf = UniversalReader.this.executeCmd(18, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU read(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(18, data);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU transmit(int cla, int ins, int p1, int p2, byte[] data) throws IOException, UniversalReaderException {
            int datalen = data != null ? data.length : -1;
            byte[] buf = new byte[5 + datalen];
            buf[0] = (byte)(cla & 0xFF);
            buf[1] = (byte)(ins & 0xFF);
            buf[2] = (byte)(p1 & 0xFF);
            buf[3] = (byte)(p2 & 0xFF);
            if (datalen > -1) {
                buf[4] = (byte)(datalen & 0xFF);
                int i = 0;
                while (i < datalen) {
                    buf[i + 5] = data[i];
                    ++i;
                }
            }
            buf = UniversalReader.this.executeCmd(19, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU transmit(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(19, data);
            return new ResponseAPDU(buf);
        }

        public boolean isCardPresent() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(3, null);
            return buf[0] != 0;
        }

        public void select(int slot) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{(byte)(slot & 0xFF)};
            UniversalReader.this.executeCmd(6, buf);
        }
    }

    public final class TouchScreen {
        private TouchScreen() {
        }

        public TouchEvent[] getEvents() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(49, null);
            if (buf.length == 0) {
                return null;
            }
            return TouchEvent.obtainArray(buf);
        }
    }
}

