/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.samples.j2me;

import com.datecs.api.card.FinancialCard;
import com.datecs.api.printer.Printer;
import com.datecs.samples.j2me.BluetoothDeviceDiscovery;
import com.datecs.samples.j2me.PrinterConnector;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class PrinterSample
extends MIDlet
implements CommandListener,
ItemCommandListener {
    private static final Command CMD_EXIT = new Command("Exit", 7, 1);
    private static final Command CMD_SCAN = new Command("Scan", 8, 1);
    private static final Command CMD_SELECT = new Command("Select", 8, 1);
    private static final Command CMD_PRINT_SELFTEST = new Command("Print Self Test", 8, 1);
    private static final Command CMD_PRINT_TEXT = new Command("Print Text", 8, 1);
    private static final Command CMD_PRINT_IMAGE = new Command("Print Image", 8, 1);
    private static final Command CMD_PRINT_PAGE = new Command("Print Page", 8, 1);
    private static final Command CMD_PRINT_BARCODE = new Command("Print Barcode", 8, 1);
    private static final Command CMD_READ_CARD = new Command("Read Card", 8, 1);
    private static final Command CMD_READ_BARCODE = new Command("Read Barcode", 8, 1);
    private static final int LINES = 110;
    private static Object mLock = new Object();
    private Display mDisplay;
    private Form mForm;
    private TextField mAddressField;
    private Vector mDevices;

    public void appendButtonItem(Form f, Command c) {
        StringItem item = new StringItem("", c.getLabel(), 2);
        item.setDefaultCommand(c);
        item.setItemCommandListener((ItemCommandListener)this);
        item.setLayout(16384);
        item.setPreferredSize(f.getWidth() / 2 - 5, -1);
        f.append((Item)item);
    }

    public void startApp() {
        this.mDisplay = Display.getDisplay((MIDlet)this);
        this.mForm = new Form("Printer sample application");
        this.mForm.addCommand(CMD_EXIT);
        this.mForm.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mForm);
        this.mAddressField = new TextField("Device: ", "000190E61C68", 17, 0);
        this.mAddressField.setDefaultCommand(CMD_SCAN);
        this.mAddressField.setItemCommandListener((ItemCommandListener)this);
        this.mForm.append((Item)this.mAddressField);
        this.appendButtonItem(this.mForm, CMD_PRINT_SELFTEST);
        this.appendButtonItem(this.mForm, CMD_PRINT_TEXT);
        this.appendButtonItem(this.mForm, CMD_PRINT_IMAGE);
        this.appendButtonItem(this.mForm, CMD_PRINT_PAGE);
        this.appendButtonItem(this.mForm, CMD_PRINT_BARCODE);
        this.appendButtonItem(this.mForm, CMD_READ_CARD);
        this.appendButtonItem(this.mForm, CMD_READ_BARCODE);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == CMD_EXIT) {
            if (d == this.mForm) {
                this.destroyApp(true);
                this.notifyDestroyed();
            } else {
                this.mDisplay.setCurrent((Displayable)this.mForm);
            }
        } else if (c == CMD_SELECT) {
            List list = (List)d;
            int selectedIndex = list.getSelectedIndex();
            RemoteDevice remoteDevice = (RemoteDevice)this.mDevices.elementAt(selectedIndex);
            this.mAddressField.setString(remoteDevice.getBluetoothAddress());
            this.mDisplay.setCurrent((Displayable)this.mForm);
        }
    }

    public void commandAction(Command c, Item item) {
        if (c == CMD_SCAN) {
            this.scan();
        } else if (c == CMD_PRINT_SELFTEST) {
            this.printSelfTest();
        } else if (c == CMD_PRINT_TEXT) {
            this.printText();
        } else if (c == CMD_PRINT_IMAGE) {
            this.printImage();
        } else if (c == CMD_PRINT_PAGE) {
            this.printPage();
        } else if (c == CMD_PRINT_BARCODE) {
            this.printBarcode();
        } else if (c == CMD_READ_CARD) {
            this.readCard();
        } else if (c == CMD_READ_BARCODE) {
            this.readBarcode();
        }
    }

    private void info(String text) {
        AlertType.INFO.playSound(Display.getDisplay((MIDlet)this));
        Alert alert = new Alert("Info", text, null, AlertType.INFO);
        alert.setTimeout(-2);
        this.mDisplay.setCurrent(alert, (Displayable)this.mForm);
    }

    private void error(String text) {
        AlertType.ERROR.playSound(Display.getDisplay((MIDlet)this));
        Alert alert = new Alert("Error", text, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.mDisplay.setCurrent(alert, (Displayable)this.mForm);
    }

    private void scan() {
        final List list = new List("Select a printer", 3);
        list.setTicker(new Ticker("Scanning for printers..."));
        list.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)list);
        new Thread(){

            public void run() {
                PrinterSample.this.mDevices = new BluetoothDeviceDiscovery().discovery();
                int deviceCount = PrinterSample.this.mDevices.size();
                int i = 0;
                while (i < deviceCount) {
                    String name;
                    RemoteDevice remoteDevice = (RemoteDevice)PrinterSample.this.mDevices.elementAt(i);
                    String address = remoteDevice.getBluetoothAddress();
                    try {
                        name = remoteDevice.getFriendlyName(true);
                    }
                    catch (IOException e) {
                        name = "[UNKNOWN DEVICE]";
                        e.printStackTrace();
                    }
                    list.append(String.valueOf(address) + " " + name, null);
                    ++i;
                }
                list.setTicker(null);
                list.addCommand(CMD_EXIT);
                list.setSelectCommand(CMD_SELECT);
            }
        }.start();
    }

    private PrinterConnector getConnector() {
        char[] buf = new char[this.mAddressField.size()];
        this.mAddressField.getChars(buf);
        String address = new String(buf);
        PrinterConnector pc = new PrinterConnector(address);
        return pc;
    }

    private void setStatus(String statusText) {
        if (statusText == null) {
            this.mForm.setTicker(null);
        } else {
            this.mForm.setTicker(new Ticker(statusText));
        }
    }

    private void readBarcode() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                String barcode = null;
                Object object = mLock;
                synchronized (object) {
                    block15: {
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Read barcode...");
                                barcode = printer.readBarcode(10000);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
                if (barcode != null) {
                    PrinterSample.this.info(barcode);
                }
            }
        }.start();
    }

    private void readCard() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                String[] tracks = null;
                FinancialCard card = null;
                Object object = mLock;
                synchronized (object) {
                    block23: {
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Read card...");
                                tracks = printer.readCard(true, true, false, 10000);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
                if (tracks != null) {
                    StringBuffer msg = new StringBuffer();
                    if (tracks[0] == null && tracks[1] == null) {
                        msg.append("No card readed. Please try again.");
                    } else {
                        if (tracks[0] != null) {
                            card = new FinancialCard(tracks[0]);
                        } else if (tracks[1] != null) {
                            card = new FinancialCard(tracks[1]);
                        }
                        if (card != null) {
                            msg.append("NUMBER: " + card.getNumber());
                            msg.append("\n");
                            msg.append("HOLDER: " + card.getName());
                            msg.append("\n");
                            msg.append("EXPDATE: " + card.getExpiryMonth() + "/" + card.getExpiryYear());
                            msg.append("\n");
                        }
                        if (tracks[0] != null) {
                            msg.append("\n");
                            msg.append(tracks[0]);
                        }
                        if (tracks[1] != null) {
                            msg.append("\n");
                            msg.append(tracks[1]);
                        }
                    }
                    PrinterSample.this.info(msg.toString());
                }
            }
        }.start();
    }

    private void printBarcode() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                Object object = mLock;
                synchronized (object) {
                    block14: {
                        PrinterSample.this.mForm.setTicker(new Ticker("Print barcode..."));
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Print barcode...");
                                printer.reset();
                                printer.setBarcode(1, false, 2, 2, 100);
                                printer.printBarcode(67, "123456789012");
                                printer.feedPaper(38);
                                printer.setBarcode(1, false, 2, 3, 100);
                                printer.printBarcode(73, "ABCDEF123456");
                                printer.feedPaper(38);
                                printer.setBarcode(1, false, 2, 0, 100);
                                printer.printBarcode(74, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                                printer.feedPaper(110);
                                printer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
            }
        }.start();
    }

    private void printPage() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                Object object = mLock;
                synchronized (object) {
                    block15: {
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Print page...");
                                if (!printer.getInformation().isPageModeSupported()) {
                                    throw new IOException("The printer does not supports page mode");
                                }
                                printer.reset();
                                printer.selectPageMode();
                                printer.setPageRegion(0, 0, 160, 320, 0);
                                printer.setPageXY(0, 4);
                                printer.printTaggedText("{reset}{center}{b}PARAGRAPH I{br}");
                                printer.drawPageRectangle(0, 0, 160, 32, 2);
                                printer.setPageXY(0, 34);
                                printer.printTaggedText("{reset}Text printed from left to right, feed to bottom. Starting point in left top corner of the page.{br}");
                                printer.drawPageFrame(0, 0, 160, 320, 1, 1);
                                printer.setPageRegion(160, 0, 160, 320, 3);
                                printer.setPageXY(0, 4);
                                printer.printTaggedText("{reset}{center}{b}PARAGRAPH II{br}");
                                printer.drawPageRectangle(128, 0, 32, 320, 2);
                                printer.setPageXY(0, 34);
                                printer.printTaggedText("{reset}Text printed from top to bottom, feed to left. Starting point in right top corner of the page.{br}");
                                printer.drawPageFrame(0, 0, 160, 320, 1, 1);
                                printer.setPageRegion(160, 320, 160, 320, 2);
                                printer.setPageXY(0, 4);
                                printer.printTaggedText("{reset}{center}{b}PARAGRAPH III{br}");
                                printer.drawPageRectangle(0, 288, 160, 32, 2);
                                printer.setPageXY(0, 34);
                                printer.printTaggedText("{reset}Text printed from right to left, feed to top. Starting point in right bottom corner of the page.{br}");
                                printer.drawPageFrame(0, 0, 160, 320, 1, 1);
                                printer.setPageRegion(0, 320, 160, 320, 1);
                                printer.setPageXY(0, 4);
                                printer.printTaggedText("{reset}{center}{b}PARAGRAPH IV{br}");
                                printer.drawPageRectangle(0, 0, 32, 320, 2);
                                printer.setPageXY(0, 34);
                                printer.printTaggedText("{reset}Text printed from bottom to top, feed to right. Starting point in left bottom corner of the page.{br}");
                                printer.drawPageFrame(0, 0, 160, 320, 1, 1);
                                printer.printPage();
                                printer.selectStandardMode();
                                printer.feedPaper(110);
                                printer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
            }
        }.start();
    }

    private void printImage() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                Object object = mLock;
                synchronized (object) {
                    block14: {
                        try {
                            try {
                                Image image = Image.createImage((String)"/sample.png");
                                int w = image.getWidth();
                                int h = image.getHeight();
                                int[] argb = new int[w * h];
                                image.getRGB(argb, 0, w, 0, 0, w, h);
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Print image...");
                                printer.reset();
                                printer.printImage(argb, w, h, 0, true);
                                printer.feedPaper(110);
                                printer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
            }
        }.start();
    }

    private void printText() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                StringBuffer sb = new StringBuffer();
                sb.append("{reset}{center}{w}{h}RECEIPT");
                sb.append("{br}");
                sb.append("{br}");
                sb.append("{reset}1. {b}First item{br}");
                sb.append("{reset}{right}{h}$0.50 A{br}");
                sb.append("{reset}2. {u}Second item{br}");
                sb.append("{reset}{right}{h}$1.00 B{br}");
                sb.append("{reset}3. {i}Third item{br}");
                sb.append("{reset}{right}{h}$1.50 C{br}");
                sb.append("{br}");
                sb.append("{reset}{right}{w}{h}TOTAL: {/w}$3.00  {br}");
                sb.append("{br}");
                sb.append("{reset}{center}{s}Thank You!{br}");
                Object object = mLock;
                synchronized (object) {
                    block14: {
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Print text...");
                                printer.reset();
                                printer.printTaggedText(sb.toString());
                                printer.feedPaper(110);
                                printer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                    PrinterSample.this.mForm.setTicker(null);
                }
            }
        }.start();
    }

    private void printSelfTest() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrinterConnector pc = PrinterSample.this.getConnector();
                Object object = mLock;
                synchronized (object) {
                    block14: {
                        try {
                            try {
                                PrinterSample.this.setStatus("Connecting...");
                                pc.open();
                                Printer printer = new Printer(pc.getInputStream(), pc.getOutputStream());
                                PrinterSample.this.setStatus("Print self test...");
                                printer.printSelfTest();
                                printer.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                PrinterSample.this.error(e.getMessage());
                                try {
                                    pc.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                PrinterSample.this.setStatus(null);
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            PrinterSample.this.setStatus(null);
                            throw throwable;
                        }
                        try {
                            pc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        PrinterSample.this.setStatus(null);
                    }
                }
            }
        }.start();
    }
}

