/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.samples.j2me;

import com.datecs.api.printer.ProtocolAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class UniversalReaderConnector {
    private String mUrl;
    private StreamConnection mConnection;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private InputStream mInputStream;
    private OutputStream mOutputStream;
    private boolean mOpen;

    public UniversalReaderConnector(String address) {
        this.mUrl = "btspp://" + address + ":1;authenticate=false;encrypt=false";
        this.mOpen = false;
    }

    public void open() throws IOException {
        this.mConnection = (StreamConnection)Connector.open((String)this.mUrl);
        this.mBaseInputStream = this.mConnection.openInputStream();
        this.mBaseOutputStream = this.mConnection.openOutputStream();
        this.mOpen = true;
        ProtocolAdapter adapter = new ProtocolAdapter(this.mBaseInputStream, this.mBaseOutputStream);
        if (adapter.isProtocolEnabled()) {
            ProtocolAdapter.Channel channelReader = adapter.getChannel(16);
            this.mInputStream = channelReader.getInputStream();
            this.mOutputStream = channelReader.getOutputStream();
        } else {
            this.mInputStream = this.mBaseInputStream;
            this.mOutputStream = this.mBaseOutputStream;
        }
    }

    public void close() throws IOException {
        if (this.mOpen) {
            this.mBaseInputStream.close();
            this.mBaseOutputStream.close();
            this.mConnection.close();
            this.mOpen = false;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.mOpen) {
            throw new IOException("Not connected");
        }
        return this.mInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.mOpen) {
            throw new IOException("Not connected");
        }
        return this.mOutputStream;
    }
}

