/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.samples.j2me;

import com.datecs.api.smartcard.AnswerToReset;
import com.datecs.api.universalreader.TouchEvent;
import com.datecs.api.universalreader.UniversalReader;
import com.datecs.api.universalreader.UniversalReaderException;
import com.datecs.samples.j2me.BluetoothDeviceDiscovery;
import com.datecs.samples.j2me.ExecuteMethods;
import com.datecs.samples.j2me.ResultForm;
import com.datecs.samples.j2me.TouchScreenCanvas;
import com.datecs.samples.j2me.UniversalReaderConnector;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class UniversalReaderSample
extends MIDlet
implements CommandListener,
ItemCommandListener {
    private static final Command CMD_EXIT = new Command("Exit", 7, 1);
    private static final Command CMD_SCAN = new Command("Scan", 8, 1);
    private static final Command CMD_SELECT = new Command("Select", 8, 1);
    private static final Command CMD_BARCODE = new Command("Barcode", 8, 1);
    private static final Command CMD_SMARTCARD = new Command("Smart Card", 8, 1);
    private static final Command CMD_MIFARE = new Command("Mifare", 8, 1);
    private static final Command CMD_TOUCHSCREEN = new Command("Touch Screen", 8, 1);
    private Object mLock = new Object();
    private Display mDisplay;
    private Form mForm;
    private TextField mAddressField;
    private Vector mDevices;

    public void appendButtonItem(Form f, Command c) {
        StringItem item = new StringItem("", c.getLabel(), 2);
        item.setDefaultCommand(c);
        item.setItemCommandListener((ItemCommandListener)this);
        item.setLayout(16384);
        item.setPreferredSize(f.getWidth() / 2 - 5, -1);
        f.append((Item)item);
    }

    protected void startApp() throws MIDletStateChangeException {
        this.mDisplay = Display.getDisplay((MIDlet)this);
        this.mForm = new Form("UniversalReader sample application");
        this.mForm.addCommand(CMD_EXIT);
        this.mForm.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mForm);
        this.mAddressField = new TextField("Device: ", "000190E61C68", 17, 0);
        this.mAddressField.setDefaultCommand(CMD_SCAN);
        this.mAddressField.setItemCommandListener((ItemCommandListener)this);
        this.mForm.append((Item)this.mAddressField);
        this.appendButtonItem(this.mForm, CMD_BARCODE);
        this.appendButtonItem(this.mForm, CMD_SMARTCARD);
        this.appendButtonItem(this.mForm, CMD_MIFARE);
        this.appendButtonItem(this.mForm, CMD_TOUCHSCREEN);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == CMD_EXIT) {
            if (d == this.mForm) {
                this.destroyApp(true);
                this.notifyDestroyed();
            } else {
                ExecuteMethods em = (ExecuteMethods)d;
                em.stop();
                this.mDisplay.setCurrent((Displayable)this.mForm);
            }
        }
    }

    public void commandAction(Command c, Item item) {
        if (c == CMD_SCAN) {
            this.scan();
        } else if (c == CMD_BARCODE) {
            this.readBarcode();
        } else if (c == CMD_SMARTCARD) {
            this.resetSmartCard();
        } else if (c == CMD_MIFARE) {
            this.readMifareCard();
        } else if (c == CMD_TOUCHSCREEN) {
            this.drawTouchScreen();
        }
    }

    private void error(String text) {
        AlertType.ERROR.playSound(Display.getDisplay((MIDlet)this));
        AlertType.INFO.playSound(Display.getDisplay((MIDlet)this));
        Alert alert = new Alert("error", text, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.mDisplay.setCurrent(alert, (Displayable)this.mForm);
    }

    private void scan() {
        final List list = new List("Select a device", 3);
        list.setTicker(new Ticker("Scanning for devices..."));
        this.mDisplay.setCurrent((Displayable)list);
        new Thread(){

            public void run() {
                UniversalReaderSample.this.mDevices = new BluetoothDeviceDiscovery().discovery();
                int deviceCount = UniversalReaderSample.this.mDevices.size();
                int i = 0;
                while (i < deviceCount) {
                    String name;
                    RemoteDevice remoteDevice = (RemoteDevice)UniversalReaderSample.this.mDevices.elementAt(i);
                    String address = remoteDevice.getBluetoothAddress();
                    try {
                        name = remoteDevice.getFriendlyName(true);
                    }
                    catch (IOException e) {
                        name = "[UNKNOWN DEVICE]";
                        e.printStackTrace();
                    }
                    list.append(String.valueOf(address) + " " + name, null);
                    ++i;
                }
                list.setTicker(null);
                list.setCommandListener(new CommandListener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void commandAction(Command c, Displayable d) {
                        if (c == UniversalReaderSample.access$2()) {
                            UniversalReaderSample.access$3(1.access$0(this.this$1)).setCurrent((Displayable)UniversalReaderSample.access$4(1.access$0(this.this$1)));
                        } else if (c == UniversalReaderSample.access$5()) {
                            List list = (List)d;
                            int selectedIndex = list.getSelectedIndex();
                            RemoteDevice remoteDevice = (RemoteDevice)UniversalReaderSample.access$1(1.access$0(this.this$1)).elementAt(selectedIndex);
                            UniversalReaderSample.access$6(1.access$0(this.this$1)).setString(remoteDevice.getBluetoothAddress());
                            UniversalReaderSample.access$3(1.access$0(this.this$1)).setCurrent((Displayable)UniversalReaderSample.access$4(1.access$0(this.this$1)));
                        }
                    }
                });
                list.addCommand(CMD_EXIT);
                list.setSelectCommand(CMD_SELECT);
            }

            static /* synthetic */ UniversalReaderSample access$0(1 var0) {
                return var0.UniversalReaderSample.this;
            }
        }.start();
    }

    private UniversalReaderConnector getConnector() {
        char[] buf = new char[this.mAddressField.size()];
        this.mAddressField.getChars(buf);
        String address = new String(buf);
        UniversalReaderConnector urc = new UniversalReaderConnector(address);
        return urc;
    }

    private void readBarcode() {
        ResultForm form = new ResultForm("Read barcode"){
            private volatile boolean mRun = true;

            public void stop() {
                this.mRun = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() {
                UniversalReaderConnector urc = UniversalReaderSample.this.getConnector();
                Object object = UniversalReaderSample.this.mLock;
                synchronized (object) {
                    block25: {
                        try {
                            this.setStatus("Connecting...");
                            urc.open();
                            UniversalReader universalReader = new UniversalReader(urc.getInputStream(), urc.getOutputStream());
                            UniversalReader.BarcodeReader barcodeReader = universalReader.getBarcodeReader();
                            this.setStatus("Press device button to read barcode ...");
                            while (this.mRun) {
                                boolean pressed = false;
                                if (this.mRun) {
                                    pressed = universalReader.isButtonPressed();
                                }
                                if (!this.mRun) continue;
                                if (pressed) {
                                    try {
                                        String data = barcodeReader.read();
                                        this.append("#" + data.substring(1) + "\n");
                                        continue;
                                    }
                                    catch (UniversalReaderException e) {
                                        e.printStackTrace();
                                        if (e.getErrorCode() == 17) continue;
                                        throw e;
                                    }
                                }
                                try {
                                    Thread.sleep(40L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            UniversalReaderSample.this.error(e.getMessage());
                            try {
                                urc.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            this.setStatus(null);
                            break block25;
                        }
                        catch (UniversalReaderException e) {
                            try {
                                e.printStackTrace();
                                UniversalReaderSample.this.error(e.getMessage());
                                break block25;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    urc.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                this.setStatus(null);
                            }
                        }
                        try {
                            urc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.setStatus(null);
                    }
                }
            }
        };
        form.setCommandListener(this);
        form.addCommand(CMD_EXIT);
        this.mDisplay.setCurrent((Displayable)form);
    }

    private void resetSmartCard() {
        ResultForm form = new ResultForm("Reset Smart Card"){
            private volatile boolean mRun = true;

            private void setAnswerToReset(AnswerToReset atr) {
                byte[] b = atr.getData();
                if (b != null) {
                    StringBuffer sb = new StringBuffer(b.length * 3);
                    sb.append("Smart Card Reset Bytes:\n");
                    int i = 0;
                    while (i < b.length) {
                        sb.append(Integer.toHexString((b[i] & 0xFF) + 256).substring(1));
                        sb.append(' ');
                        ++i;
                    }
                    this.append(sb.toString());
                }
            }

            public void stop() {
                this.mRun = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() {
                UniversalReaderConnector urc = UniversalReaderSample.this.getConnector();
                Object object = UniversalReaderSample.this.mLock;
                synchronized (object) {
                    block28: {
                        try {
                            this.setStatus("Connecting...");
                            urc.open();
                            UniversalReader universalReader = new UniversalReader(urc.getInputStream(), urc.getOutputStream());
                            UniversalReader.SmartCardReader scReader = universalReader.getSmartCardReader();
                            while (this.mRun) {
                                boolean cardPresent = false;
                                this.deleteAll();
                                this.setStatus("Put smart card into reader...");
                                while (this.mRun && !cardPresent) {
                                    if (this.mRun) {
                                        cardPresent = scReader.isCardPresent();
                                    }
                                    if (!this.mRun) continue;
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (this.mRun) {
                                    scReader.setPower(true);
                                    AnswerToReset atr = scReader.reset();
                                    scReader.setPower(false);
                                    this.setAnswerToReset(atr);
                                    this.setStatus("Remove smart card from reader...");
                                }
                                while (this.mRun && cardPresent) {
                                    if (this.mRun) {
                                        cardPresent = scReader.isCardPresent();
                                    }
                                    if (!this.mRun) continue;
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            UniversalReaderSample.this.error(e.getMessage());
                            try {
                                urc.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            this.setStatus(null);
                            break block28;
                        }
                        catch (UniversalReaderException e) {
                            try {
                                e.printStackTrace();
                                UniversalReaderSample.this.error(e.getMessage());
                                break block28;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    urc.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                this.setStatus(null);
                            }
                        }
                        try {
                            urc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.setStatus(null);
                    }
                }
            }
        };
        form.setCommandListener(this);
        form.addCommand(CMD_EXIT);
        this.mDisplay.setCurrent((Displayable)form);
    }

    private void readMifareCard() {
        ResultForm form = new ResultForm("Read Mifare card"){
            private volatile boolean mRun = true;

            public void stop() {
                this.mRun = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() {
                UniversalReaderConnector urc = UniversalReaderSample.this.getConnector();
                int cardSerial = 0;
                int BLOCKS = 4;
                int SECTORS = 4;
                byte[] KEY = new byte[]{-1, -1, -1, -1, -1, -1};
                int KEY_A = 96;
                Object object = UniversalReaderSample.this.mLock;
                synchronized (object) {
                    block31: {
                        try {
                            this.setStatus("Connecting...");
                            urc.open();
                            UniversalReader universalReader = new UniversalReader(urc.getInputStream(), urc.getOutputStream());
                            UniversalReader.MifareReader mifareReader = universalReader.getMifareReader();
                            this.setStatus("Put Mifare card on reader...");
                            mifareReader.setPower(true);
                            mifareReader.config();
                            while (this.mRun) {
                                block30: {
                                    if (!this.mRun) continue;
                                    if (this.mRun) {
                                        try {
                                            Thread.sleep(50L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (this.mRun) {
                                        try {
                                            mifareReader.request(false);
                                            cardSerial = mifareReader.anticollision();
                                            mifareReader.select(cardSerial);
                                            this.append("Card found: #" + Integer.toHexString(cardSerial) + "\n");
                                        }
                                        catch (UniversalReaderException e) {
                                            if (e.getMessage().startsWith("Mifare")) continue;
                                            throw e;
                                        }
                                    }
                                    try {
                                        int sector = 0;
                                        while (sector < 4 && this.mRun) {
                                            mifareReader.authenticate(cardSerial, sector * 4, 96, KEY);
                                            int block = 0;
                                            while (block < 4 && this.mRun) {
                                                int record = sector * 4 + block;
                                                byte[] data = mifareReader.read(record);
                                                StringBuffer sb = new StringBuffer(data.length * 3);
                                                int i = 0;
                                                while (i < data.length) {
                                                    sb.append(Integer.toHexString((data[i] & 0xFF) + 256).substring(1));
                                                    sb.append(' ');
                                                    ++i;
                                                }
                                                this.append("Sector " + sector + ",block " + block + ", data: ");
                                                this.append(sb.toString());
                                                this.append("\n");
                                                ++block;
                                            }
                                            ++sector;
                                        }
                                    }
                                    catch (UniversalReaderException e) {
                                        if (e.getMessage().startsWith("Mifare")) break block30;
                                        throw e;
                                    }
                                }
                                if (!this.mRun) continue;
                                mifareReader.halt();
                            }
                            mifareReader.setPower(false);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            UniversalReaderSample.this.error(e.getMessage());
                            try {
                                urc.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            this.setStatus(null);
                            break block31;
                        }
                        catch (UniversalReaderException e) {
                            try {
                                e.printStackTrace();
                                UniversalReaderSample.this.error(e.getMessage());
                                break block31;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    urc.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                this.setStatus(null);
                            }
                        }
                        try {
                            urc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.setStatus(null);
                    }
                }
            }
        };
        form.setCommandListener(this);
        form.addCommand(CMD_EXIT);
        this.mDisplay.setCurrent((Displayable)form);
    }

    private void drawTouchScreen() {
        TouchScreenCanvas canvas = new TouchScreenCanvas("Draw from touch screen"){
            private volatile boolean mRun = true;
            private TouchEvent mSavedEvent;

            public void stop() {
                this.mRun = false;
            }

            private void append(TouchEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    this.append(events[i]);
                    ++i;
                }
            }

            private void append(TouchEvent event) {
                if (event.getAction() == 0) {
                    if (this.mSavedEvent != null) {
                        int fromX = this.mSavedEvent.getX();
                        int fromY = this.mSavedEvent.getY();
                        int toX = event.getX();
                        int toY = event.getY();
                        this.draw(fromX, fromY, toX, toY);
                    }
                    this.mSavedEvent = event;
                } else {
                    this.mSavedEvent = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() {
                UniversalReaderConnector urc = UniversalReaderSample.this.getConnector();
                Object object = UniversalReaderSample.this.mLock;
                synchronized (object) {
                    block23: {
                        try {
                            this.setStatus("Connecting...");
                            urc.open();
                            UniversalReader universalReader = new UniversalReader(urc.getInputStream(), urc.getOutputStream());
                            UniversalReader.TouchScreen touchScreen = universalReader.getTouchScreen();
                            this.setStatus("Draw on touch screen...");
                            while (this.mRun) {
                                boolean pressed;
                                TouchEvent[] events;
                                if (this.mRun && (events = touchScreen.getEvents()) != null) {
                                    this.append(events);
                                }
                                if (this.mRun && (pressed = universalReader.isButtonPressed(false))) {
                                    this.clear();
                                }
                                if (!this.mRun) continue;
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            UniversalReaderSample.this.error(e.getMessage());
                            try {
                                urc.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            this.setStatus(null);
                            break block23;
                        }
                        catch (UniversalReaderException e) {
                            try {
                                e.printStackTrace();
                                UniversalReaderSample.this.error(e.getMessage());
                                break block23;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    urc.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                this.setStatus(null);
                            }
                        }
                        try {
                            urc.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.setStatus(null);
                    }
                }
            }
        };
        canvas.setCommandListener(this);
        canvas.addCommand(CMD_EXIT);
        this.mDisplay.setCurrent((Displayable)canvas);
    }

    static /* synthetic */ Display access$3(UniversalReaderSample universalReaderSample) {
        return universalReaderSample.mDisplay;
    }

    static /* synthetic */ Form access$4(UniversalReaderSample universalReaderSample) {
        return universalReaderSample.mForm;
    }

    static /* synthetic */ TextField access$6(UniversalReaderSample universalReaderSample) {
        return universalReaderSample.mAddressField;
    }
}

