/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.hub;

import com.datecs.api.hub.HUBException;
import com.datecs.api.hub.HUBIdent;
import com.datecs.api.hub.SerialPort;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HUB
implements Closeable {
    private static final boolean DEBUG = true;
    private static final int HEADER_SIZE = 4;
    private static final int MAX_DATA_SIZE = 256;
    private static final int SERIAL_PORTS = 3;
    private static final int IO_TIMEOUT = 1000;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_RESPONSE = 1;
    public static final int STATUS_NO_DATA = 2;
    public static final int STATUS_INVALID_COMMAND = 3;
    public static final int STATUS_SYNTAX_ERROR = 4;
    public static final int STATUS_INVALID_PARAMETER = 5;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_SERIAL_PORT_RECV = 1;
    public static final int EVENT_USB_RECV = 2;
    public static final int SERIAL_PORT_1 = 0;
    public static final int SERIAL_PORT_2 = 1;
    public static final int SERIAL_PORT_3 = 2;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private boolean mActive;
    private ReceiverThread mReceiver;
    private Response mLastResponse;
    private IOException mLastError;
    private SerialPortImpl[] mSerialPorts;

    public HUB(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The parameter 'inputStream' can not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("The parameter 'outputStream' can not be null");
        }
        this.mBaseInputStream = inputStream;
        this.mBaseOutputStream = outputStream;
        this.startReceiver();
    }

    public HUB(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("The parameter 'fd' can not be null");
        }
        this.mBaseInputStream = new FileInputStream(fd);
        this.mBaseOutputStream = new FileOutputStream(fd);
        this.startReceiver();
    }

    @Override
    public void close() throws IOException {
        this.stopReceiver();
    }

    private synchronized void startReceiver() {
        this.mSerialPorts = new SerialPortImpl[3];
        this.mReceiver = new ReceiverThread();
        this.mReceiver.start();
    }

    private synchronized void stopReceiver() throws IOException {
        if (this.mActive) {
            this.mActive = false;
            this.mBaseInputStream.close();
            this.mBaseOutputStream.close();
        }
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        int i = 0;
        while (i < length) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
            ++i;
        }
        return new String(buf, 0, offs);
    }

    private void write(byte[] b, int offset, int size) throws IOException {
        System.out.println("send(" + size + "):" + HUB.byteArrayToHexString(b, offset, size));
        this.mBaseOutputStream.write(b, offset, size);
        this.mBaseOutputStream.flush();
    }

    private int read(byte[] b, int offset, int size) throws IOException {
        int nbr = this.mBaseInputStream.read(b, offset, size);
        if (nbr < 0) {
            throw new IOException("The end of stream has been reached");
        }
        System.out.println("recv(" + nbr + "):" + HUB.byteArrayToHexString(b, offset, nbr));
        return nbr;
    }

    private void processEvent(int event, byte[] data) {
        switch (event) {
            case 1: {
                int port = data[0] & 0xFF;
                if (this.mSerialPorts[port] == null || !this.mSerialPorts[port].isActive()) break;
                int i = 1;
                while (i < data.length) {
                    this.mSerialPorts[port].addContent(data[i]);
                    ++i;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] transmit(int cmd, byte[] data) throws IOException {
        byte[] tmp = null;
        if (this.mLastError != null) {
            throw this.mLastError;
        }
        if (data != null && data.length > 0) {
            if (data.length > 256) {
                throw new IllegalArgumentException("The parameter 'data' has invalid length");
            }
            tmp = new byte[4 + data.length];
            tmp[0] = (byte)cmd;
            tmp[2] = (byte)(data.length >> 8);
            tmp[3] = (byte)data.length;
            System.arraycopy(data, 0, tmp, 4, data.length);
        } else {
            tmp = new byte[4];
            tmp[0] = (byte)cmd;
        }
        this.write(tmp, 0, tmp.length);
        if (this.mLastResponse == null) {
            ReceiverThread receiverThread = this.mReceiver;
            synchronized (receiverThread) {
                try {
                    this.mReceiver.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mLastResponse == null) {
                throw new IOException("The operation timeout expired");
            }
        }
        if (this.mLastResponse.status != 0) {
            throw new HUBException(this.mLastResponse.status);
        }
        tmp = this.mLastResponse.data;
        this.mLastResponse = null;
        return tmp;
    }

    private synchronized byte[] transmit(int cmd) throws IOException {
        return this.transmit(cmd, null);
    }

    private synchronized byte[] transmit(int cmd, int subCmd, byte[] data) throws IOException {
        byte[] tmp = null;
        if (data != null && data.length > 0) {
            tmp = new byte[1 + data.length];
            tmp[0] = (byte)subCmd;
            System.arraycopy(data, 0, tmp, 1, data.length);
        } else {
            tmp = new byte[]{(byte)subCmd};
        }
        return this.transmit(cmd, tmp);
    }

    private void enablePort(int port) throws IOException {
        this.transmit(16, 1, null);
    }

    private void disablePort(int port) throws IOException {
        this.transmit(17, 1, new byte[]{(byte)port});
    }

    private void writeSerialPort(int port, byte[] data, int offset, int length) throws IOException {
        int totalLen = 0;
        while (totalLen < length) {
            int chunkLen = Math.min(256, length - totalLen);
            byte[] tmp = new byte[chunkLen];
            System.arraycopy(data, offset + totalLen, tmp, 0, chunkLen);
            tmp = this.transmit(19, (byte)port, tmp);
            int nbw = ((tmp[0] & 0xFF) << 8) + (tmp[1] & 0xFF);
            totalLen += nbw;
        }
    }

    public HUBIdent getIdent() throws IOException {
        byte[] tmp = this.transmit(1);
        return HUBIdent.parse(tmp);
    }

    public SerialPort getSerialPort(int port) throws IOException {
        if (port < 0 || port >= 3) {
            throw new IllegalArgumentException("The parameter 'port' has invalid value");
        }
        if (this.mSerialPorts[port] == null || !this.mSerialPorts[port].isActive()) {
            this.enablePort(port);
            this.mSerialPorts[port] = new SerialPortImpl(port);
        }
        return this.mSerialPorts[port];
    }

    private class ReceiverThread
    extends Thread {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buffer = new byte[260];
            int bufferPos = 0;
            HUB.this.mActive = true;
            try {
                do {
                    int dataLen;
                    int packetLen;
                    bufferPos += HUB.this.read(buffer, bufferPos, buffer.length - bufferPos);
                    while (bufferPos >= 4 && bufferPos >= (packetLen = 4 + (dataLen = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF)))) {
                        int status = buffer[0] & 0xFF;
                        if (status == 0) {
                            byte[] tmp = new byte[dataLen];
                            System.arraycopy(buffer, 4, tmp, 0, dataLen);
                            int event = buffer[1] & 0xFF;
                            if (event == 0) {
                                ReceiverThread receiverThread = this;
                                synchronized (receiverThread) {
                                    HUB.this.mLastResponse = new Response(status, tmp);
                                    this.notify();
                                }
                            } else {
                                HUB.this.processEvent(event, tmp);
                            }
                        } else {
                            ReceiverThread receiverThread = this;
                            synchronized (receiverThread) {
                                HUB.this.mLastResponse = new Response(status, null);
                                this.notify();
                            }
                        }
                        System.arraycopy(buffer, packetLen, buffer, 0, bufferPos - packetLen);
                        bufferPos -= packetLen;
                        if (HUB.this.mActive) continue;
                    }
                } while (HUB.this.mActive);
            }
            catch (IOException e) {
                HUB.this.mLastError = e;
                try {
                    HUB.this.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private class Response {
        public final int status;
        public final byte[] data;

        public Response(int status, byte[] data) {
            this.status = status;
            this.data = data;
        }
    }

    private class SerialPortImpl
    implements SerialPort {
        private int mPort;
        private boolean mActive = true;
        private InputStream mInputStream;
        private OutputStream mOutputStream;
        private List<Byte> mRecvQueue = Collections.synchronizedList(new ArrayList(256));

        public SerialPortImpl(int port) {
        }

        private void check() throws IOException {
            if (!this.isActive()) {
                throw new IOException("The port is closed");
            }
            if (HUB.this.mLastError != null) {
                throw HUB.this.mLastError;
            }
        }

        @Override
        public boolean isActive() {
            return this.mActive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addContent(byte b) {
            if (this.isActive()) {
                this.mRecvQueue.add(b);
                List<Byte> list = this.mRecvQueue;
                synchronized (list) {
                    this.mRecvQueue.notify();
                }
            }
        }

        @Override
        public synchronized void setConfig(int baud, int bits, int parity) throws IOException {
            this.check();
        }

        @Override
        public synchronized void setFlowControl(int flowControl) throws IOException {
            this.check();
        }

        @Override
        public synchronized InputStream getDataInputStream() throws IOException {
            this.check();
            if (this.mInputStream == null) {
                this.mInputStream = new InputStream(){

                    @Override
                    public int available() throws IOException {
                        SerialPortImpl.this.check();
                        return SerialPortImpl.this.mRecvQueue.size();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int read() throws IOException {
                        while (this.available() == 0) {
                            List list = SerialPortImpl.this.mRecvQueue;
                            synchronized (list) {
                                try {
                                    SerialPortImpl.this.mRecvQueue.wait(10L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        return (Byte)SerialPortImpl.this.mRecvQueue.remove(0) & 0xFF;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int nbr = 0;
                        if (len == 0) {
                            return 0;
                        }
                        do {
                            b[off] = (byte)this.read();
                            ++off;
                        } while (++nbr < len && this.available() != 0);
                        return nbr;
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return this.read(b, 0, b.length);
                    }

                    @Override
                    public void close() throws IOException {
                        SerialPortImpl.this.check();
                        SerialPortImpl.this.close();
                    }
                };
            }
            return this.mInputStream;
        }

        @Override
        public synchronized OutputStream getDataOutputStream() throws IOException {
            this.check();
            if (this.mOutputStream == null) {
                this.mOutputStream = new OutputStream(){

                    @Override
                    public void close() throws IOException {
                        SerialPortImpl.this.check();
                        SerialPortImpl.this.close();
                    }

                    @Override
                    public void flush() throws IOException {
                        SerialPortImpl.this.check();
                        super.flush();
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.write(new byte[]{(byte)b});
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        SerialPortImpl.this.check();
                        HUB.this.writeSerialPort(SerialPortImpl.this.mPort, b, off, len);
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.write(b, 0, b.length);
                    }
                };
            }
            return this.mOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.mActive) {
                this.mActive = false;
                List<Byte> list = this.mRecvQueue;
                synchronized (list) {
                    this.mRecvQueue.notify();
                }
                HUB.this.disablePort(this.mPort);
            }
        }
    }
}

