/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.linea;

import java.io.IOException;

public class LineaProException
extends IOException {
    private static final long serialVersionUID = 1L;
    public static final int ERROR_NO = 0;
    public static final int ERROR_GENERAL = 1;
    public static final int ERROR_INVALID_LENGTH = 2;
    public static final int ERROR_INVALID_VALUE = 3;
    public static final int ERROR_INVALID_COMMAND = 4;
    public static final int ERROR_TIMEOUT = 5;
    public static final int ERROR_NO_PERM = 6;
    public static final int ERROR_INVALID_KEY = 7;
    public static final int ERROR_INVALID_AUTH = 8;
    public static final int ERROR_BUSY = 9;
    public static final int ERROR_NO_DATA = 10;
    public static final int ERROR_FIRST_DATA = 11;
    public static final int ERROR_LAST_DATA = 12;
    public static final int ERROR_COM = 13;
    public static final int ERROR_FLASH = 14;
    public static final int ERROR_CRYPT = 15;
    public static final int ERROR_OUT_OF_MEMORY = 16;
    public static final int ERROR_CONFIG = 17;
    public static final int ERROR_EMV = 18;
    public static final int ERROR_TAMPERED = 19;
    private int mErrorCode;

    public LineaProException(int errorCode) {
        super(LineaProException.getErrorAsString(errorCode));
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    private static String getErrorAsString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "No error";
            }
            case 1: {
                return "General error";
            }
            case 2: {
                return "Invalid length";
            }
            case 3: {
                return "Invalid value";
            }
            case 4: {
                return "Invalid command";
            }
            case 5: {
                return "Timeout";
            }
            case 6: {
                return "No permission";
            }
            case 7: {
                return "Invalid key";
            }
            case 8: {
                return "Invalid authentication";
            }
            case 9: {
                return "Busy";
            }
            case 10: {
                return "No data";
            }
            case 11: {
                return "First data";
            }
            case 12: {
                return "Last data";
            }
            case 13: {
                return "COM error";
            }
            case 14: {
                return "Flash error";
            }
            case 15: {
                return "Crypt error";
            }
            case 16: {
                return "Out of memory";
            }
            case 17: {
                return "Configuration error";
            }
            case 18: {
                return "EMV error";
            }
            case 19: {
                return "Tampered";
            }
        }
        return "Unspecified error code " + errorCode;
    }

    @Override
    public String toString() {
        return LineaProException.getErrorAsString(this.mErrorCode);
    }
}

