/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.linea;

import java.util.ArrayList;
import java.util.List;

public class LineaProInformation {
    private List<String> mModelNodes = new ArrayList<String>();
    private String mSerialNumber;
    private String mManifaturer;
    private String mName;
    private String mModel;
    private String mVersion;

    LineaProInformation(byte[] infoBytes) {
        ArrayList<String> infoList = new ArrayList<String>();
        int i = 0;
        int j = 0;
        while (i < infoBytes.length) {
            if (infoBytes[i] == 124) {
                infoList.add(new String(infoBytes, j, i - j));
                j = ++i;
            } else if (i + 1 == infoBytes.length) {
                infoList.add(new String(infoBytes, j, i - j + 1));
            }
            ++i;
        }
        System.out.println("Split: " + new String(infoBytes));
        for (String s : infoList) {
            System.out.println("Split line: " + s);
        }
        int infoListSize = infoList.size();
        if (infoListSize > 0) {
            this.mSerialNumber = (String)infoList.get(0);
        }
        if (infoListSize > 1) {
            this.mManifaturer = (String)infoList.get(1);
        }
        if (infoListSize > 2) {
            this.mName = (String)infoList.get(2);
        }
        if (infoListSize > 3) {
            this.mModel = (String)infoList.get(3);
        }
        if (infoListSize > 4) {
            this.mVersion = (String)infoList.get(4);
        }
        if (this.mModel != null) {
            int i2 = 0;
            while (i2 < (this.mModel.length() & 0xFFFFFFFE)) {
                String node = this.mModel.substring(i2, i2 + 2);
                this.mModelNodes.add(node);
                i2 += 2;
            }
        }
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public String getManifaturer() {
        return this.mManifaturer;
    }

    public String getName() {
        return this.mName;
    }

    public String getModel() {
        return this.mModel;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public boolean hasOpticodeEngine() {
        return this.containsNode("1B") || this.containsNode("2B") || this.containsNode("XB");
    }

    public boolean hasNewlandEngine() {
        return this.containsNode("NB");
    }

    public boolean hasBarcodeEngine() {
        return this.hasNewlandEngine() && this.hasOpticodeEngine();
    }

    public boolean hasEncryptedMagneticHead() {
        return this.containsNode("CM") && this.containsNode("AM");
    }

    public boolean hasStandardMagneticHead() {
        return this.containsNode("PM");
    }

    public boolean hasMagneticHead() {
        return this.hasStandardMagneticHead() && this.hasEncryptedMagneticHead();
    }

    private boolean containsNode(String node) {
        for (String s : this.mModelNodes) {
            if (s.compareToIgnoreCase(node) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasExternalSpeaker() {
        return !this.mName.equals("LineaS");
    }
}

