/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.printer;

import com.datecs.api.biometric.TouchChip;
import com.datecs.api.printer.PrinterInformation;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Printer {
    private static final int MAX_PACKET_SIZE = 2044;
    private static boolean sDebug = false;
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int CARD_IO_TIME = 11000;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int BARCODE_UPCA = 65;
    public static final int BARCODE_UPCE = 66;
    public static final int BARCODE_EAN13 = 67;
    public static final int BARCODE_EAN8 = 68;
    public static final int BARCODE_CODE39 = 69;
    public static final int BARCODE_ITF = 70;
    public static final int BARCODE_CODABAR = 71;
    public static final int BARCODE_CODE93 = 72;
    public static final int BARCODE_CODE128 = 73;
    public static final int BARCODE_PDF417 = 74;
    public static final int BARCODE_CODE128AUTO = 75;
    public static final int BARCODE_EAN128 = 76;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int PAGE_LEFT = 0;
    public static final int PAGE_BOTTOM = 1;
    public static final int PAGE_RIGHT = 2;
    public static final int PAGE_TOP = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_INVERTED = 2;
    public static final int SETTINGS_BLUETOOTH = 5;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private IOException mLastError;
    private Settings mSettings;
    private ConnectionListener mConnListener;
    private byte[] mDataBuffer;
    private int mDataBufferLen;

    public Printer(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = null;
        this.mBaseOutputStream = new BufferedOutputStream(out, 2044);
        this.initDefaults();
    }

    public Printer(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = in;
        this.mBaseOutputStream = new BufferedOutputStream(out, 2044);
        this.mDataBuffer = new byte[2044];
        this.initDefaults();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                byte[] buffer = new byte[2044];
                try {
                    try {
                        while (true) {
                            if (Printer.this.mLastError != null) {
                                return;
                            }
                            int bytesRead = Printer.this.read(buffer, 0, buffer.length);
                            byte[] byArray = Printer.this.mDataBuffer;
                            synchronized (byArray) {
                                while (true) {
                                    if (bytesRead + Printer.this.mDataBufferLen <= Printer.this.mDataBuffer.length) {
                                        System.arraycopy(buffer, 0, Printer.this.mDataBuffer, Printer.this.mDataBufferLen, bytesRead);
                                        Printer printer = Printer.this;
                                        printer.mDataBufferLen = printer.mDataBufferLen + bytesRead;
                                        break;
                                    }
                                    byte[] tmp = new byte[Printer.this.mDataBuffer.length + 2044];
                                    System.arraycopy(Printer.this.mDataBuffer, 0, tmp, 0, Printer.this.mDataBufferLen);
                                    Printer.this.mDataBuffer = tmp;
                                }
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException e) {
                        if (sDebug) {
                            e.printStackTrace();
                        }
                        if (Printer.this.mLastError == null) {
                            Printer.this.mLastError = e;
                        }
                        Printer.this.raiseDisconnect();
                        return;
                    }
                }
                finally {
                    Printer.this.raiseDisconnect();
                }
            }
        });
        t.start();
    }

    public synchronized void close() {
        this.mLastError = new IOException("The object is closed");
        try {
            if (this.mBaseInputStream != null) {
                this.mBaseInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mBaseOutputStream != null) {
                this.mBaseOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        int i = 0;
        while (i < length) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
            ++i;
        }
        return new String(buf, 0, offs);
    }

    private void debug(String text) {
        if (sDebug) {
            System.out.println(text);
        }
    }

    private void debug(String text, byte[] buffer, int offset, int count) {
        if (sDebug) {
            this.debug(String.valueOf(text) + Printer.byteArrayToHexString(buffer, offset, count) + "(" + count + ")");
        }
    }

    private void initDefaults() {
        this.mSettings = new Settings();
        this.mSettings.barcodeAlign = 0;
        this.mSettings.barcodeScale = 3;
        this.mSettings.barcodeHeight = 162;
        this.mSettings.barcodeHriFont = 0;
        this.mSettings.barcodeHriCode = 0;
    }

    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int offset, int length) throws IOException {
        this.mBaseOutputStream.write(b, offset, length);
        this.debug("<Printer> >> ", b, offset, length);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.mBaseInputStream.read(buffer, offset, length);
        if (bytesRead < 0) {
            throw new IOException("The end of the stream is reached");
        }
        if (bytesRead > length) {
            throw new IOException("Invalid stream result " + bytesRead);
        }
        if (bytesRead > 0) {
            this.debug("<Printer> << ", buffer, offset, bytesRead);
        }
        return bytesRead;
    }

    private void output(byte[] buffer) throws IOException {
        this.write(buffer);
        this.mBaseOutputStream.flush();
    }

    /*
     * Unable to fully structure code
     */
    private void request(int length, int timeout) throws IOException {
        endTime = System.currentTimeMillis() + (long)timeout;
        if (this.mDataBuffer != null) ** GOTO lbl13
        throw new IOException("Unable to read from input");
lbl-1000:
        // 1 sources

        {
            if (this.mLastError != null) {
                throw this.mLastError;
            }
            if (endTime < System.currentTimeMillis()) {
                throw new IOException("Timeout");
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException var5_4) {
                // empty catch block
            }
lbl13:
            // 3 sources

            ** while (this.mDataBufferLen < length)
        }
lbl14:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        byte[] byArray = this.mDataBuffer;
        synchronized (this.mDataBuffer) {
            this.mDataBufferLen = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void raiseDisconnect() {
        final ConnectionListener l = this.mConnListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onDisconnect();
                }
            }).start();
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.mConnListener = listener;
    }

    public void flush() throws IOException {
        byte[] tmp = new byte[1024];
        this.mBaseOutputStream.write(tmp);
        this.mBaseOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrinterInformation getInformation() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 90});
            byte[] buffer = new byte[32];
            this.request(buffer.length, 1000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            PrinterInformation pi = new PrinterInformation(buffer);
            return pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVoltage() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 96});
            byte[] buffer = new byte[2];
            this.request(buffer.length, 1000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return ((buffer[0] & 0xFF) - 32) * 100;
        }
    }

    public int getVoltagePercentage() throws IOException {
        int voltage = this.getVoltage();
        int percent = 0;
        percent = voltage >= 82 ? 100 : (voltage == 81 ? 97 : (voltage == 80 ? 90 : (voltage == 79 ? 85 : (voltage == 78 ? 78 : (voltage == 77 ? 72 : (voltage == 76 ? 62 : (voltage == 75 ? 50 : (voltage == 74 ? 30 : (voltage == 73 ? 20 : (voltage == 72 ? 15 : (voltage == 71 ? 8 : (voltage == 70 ? 2 : 0))))))))))));
        return percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTemperature() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 96});
            byte[] buffer = new byte[2];
            this.request(buffer.length, 1000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return (buffer[1] & 0xFF) - 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 118});
            byte[] buffer = new byte[1];
            this.request(buffer.length, 1000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return buffer[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readCard(boolean first, boolean second, boolean third, int timeout) throws IOException {
        if (!(first || second || third)) {
            throw new IllegalArgumentException("No track selected");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            int repeat = 0;
            while (repeat < (timeout + 11000) / 11000) {
                int offset = 0;
                this.clear();
                this.output(new byte[]{27, 63, (byte)((first ? 1 : 0) | (second ? 2 : 0) | (third ? 4 : 0))});
                do {
                    this.request(++offset, 11000);
                } while (offset < this.mDataBuffer.length && this.mDataBuffer[offset - 1] != 0);
                if (offset > 1) {
                    String[] track = new String[3];
                    int trackIndex = -1;
                    int i = 0;
                    while (i < offset - 1) {
                        switch (this.mDataBuffer[i] & 0xFF) {
                            case 241: {
                                trackIndex = 0;
                                track[0] = "";
                                break;
                            }
                            case 242: {
                                trackIndex = 1;
                                track[1] = "";
                                break;
                            }
                            case 243: {
                                trackIndex = 2;
                                track[2] = "";
                                break;
                            }
                            default: {
                                if (trackIndex < 0) break;
                                int n = trackIndex;
                                track[n] = String.valueOf(track[n]) + (char)(this.mDataBuffer[i] & 0xFF);
                            }
                        }
                        ++i;
                    }
                    return track;
                }
                ++repeat;
            }
        }
        return new String[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readBarcode(int timeout) throws IOException {
        StringBuffer textBuffer = new StringBuffer();
        int offset = 0;
        if (timeout < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            boolean consumeFF = false;
            this.clear();
            if (timeout == 0) {
                this.output(new byte[]{27, 66, (byte)(timeout + 32)});
            } else {
                this.output(new byte[]{27, 66, (byte)(timeout + 32), 27, 66, 32});
            }
            this.request(1, (timeout + 1) * 1000);
            while (this.mDataBuffer[offset] != 0) {
                if (this.mDataBuffer[offset] == -1) {
                    if (consumeFF) {
                        textBuffer.append('\u00ff');
                        textBuffer.append('\u00ff');
                        consumeFF = false;
                    } else {
                        consumeFF = true;
                    }
                } else {
                    if (consumeFF) {
                        int n = offset;
                        this.mDataBuffer[n] = (byte)(this.mDataBuffer[n] - 32);
                        consumeFF = false;
                    }
                    textBuffer.append((char)(this.mDataBuffer[offset] & 0xFF));
                }
                this.request(++offset, timeout);
            }
        }
        if (textBuffer.length() == 0) {
            return null;
        }
        return textBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        byte[] byArray = new byte[14];
        byArray[0] = 27;
        byArray[1] = 64;
        byArray[2] = 27;
        byArray[3] = 50;
        byArray[4] = 27;
        byArray[5] = 73;
        byArray[7] = 27;
        byArray[8] = 33;
        byArray[10] = 29;
        byArray[11] = 76;
        byte[] buf = byArray;
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() throws IOException {
        byte[] buf = new byte[]{27, 43};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printSelfTest() throws IOException {
        byte[] buf = new byte[]{27, 46};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCodetable(int codetable) throws IOException {
        byte[] buf = new byte[]{27, 117, (byte)codetable};
        if (codetable < 0) {
            throw new IllegalArgumentException("The codetable is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineSpace(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 51, (byte)(lines & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlign(int align) throws IOException {
        byte[] buf;
        switch (align) {
            case 0: 
            case 1: 
            case 2: {
                buf = new byte[]{27, 97, (byte)align};
                break;
            }
            default: {
                throw new IllegalArgumentException("The align is illegal");
            }
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedPaper(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 74, (byte)lines};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beep() throws IOException {
        byte[] tmp = new byte[]{27, 30};
        Printer printer = this;
        synchronized (printer) {
            this.write(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void melody(String data) throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(27);
        o.write(114);
        o.write(data.getBytes());
        Printer printer = this;
        synchronized (printer) {
            this.write(o.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(byte[] b) throws IOException {
        Printer printer = this;
        synchronized (printer) {
            byte[] tmp = b;
            this.write(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.printText(s.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.printText(s.getBytes(encoding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTaggedText(byte[] b) throws IOException {
        int LEN = 6;
        int ELE = 123;
        int END = 125;
        int DET = 47;
        int BREAK = "br".hashCode();
        int SMALL = "s".hashCode();
        int BOLD = "b".hashCode();
        int HIGH = "h".hashCode();
        int WIDE = "w".hashCode();
        int UNDERLINE = "u".hashCode();
        int ITALIC = "i".hashCode();
        int RESET = "reset".hashCode();
        int LEFT = "left".hashCode();
        int CENTER = "center".hashCode();
        int RIGHT = "right".hashCode();
        if (b == null) {
            throw new NullPointerException("The b is null");
        }
        int len = b.length;
        byte[] tbuf = new byte[6 + len];
        int toffs = 0;
        byte mode = 0;
        int pos = 0;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 33;
        tbuf[toffs++] = mode;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 73;
        tbuf[toffs++] = 0;
        int i = 0;
        while (i < len) {
            byte value = b[i];
            tbuf[toffs++] = value;
            if (value == 123) {
                pos = toffs;
            } else if (value == 125 && pos >= 1 && toffs - 1 - 6 <= pos) {
                int index;
                boolean set;
                if (tbuf[pos] == 47) {
                    set = false;
                    index = pos + 1;
                } else {
                    set = true;
                    index = pos;
                }
                int hash = 0;
                int hashlen = toffs - 1 - index;
                int j = 0;
                while (j < hashlen) {
                    int c = tbuf[index + j] & 0xFF;
                    if (c >= 65 && c <= 90) {
                        c += 32;
                    }
                    hash = 31 * hash + c;
                    ++j;
                }
                if (hash == BREAK) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 10;
                } else if (hash == SMALL) {
                    mode = set ? (byte)(mode | 1) : (byte)(mode & 0xFFFFFFFE);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == BOLD) {
                    mode = set ? (byte)(mode | 8) : (byte)(mode & 0xFFFFFFF7);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == HIGH) {
                    mode = set ? (byte)(mode | 0x10) : (byte)(mode & 0xFFFFFFEF);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == WIDE) {
                    mode = set ? (byte)(mode | 0x20) : (byte)(mode & 0xFFFFFFDF);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == UNDERLINE) {
                    mode = set ? (byte)(mode | 0x80) : (byte)(mode & 0xFFFFFF7F);
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                } else if (hash == ITALIC) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 73;
                    tbuf[toffs++] = set ? (byte)1 : 0;
                } else if (hash == RESET) {
                    mode = 0;
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 33;
                    tbuf[toffs++] = mode;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 73;
                    tbuf[toffs++] = 0;
                } else if (hash == LEFT) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 0;
                } else if (hash == CENTER) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 1;
                } else if (hash == RIGHT) {
                    toffs = pos - 1;
                    tbuf[toffs++] = 27;
                    tbuf[toffs++] = 97;
                    tbuf[toffs++] = 2;
                }
            }
            ++i;
        }
        Printer printer = this;
        synchronized (printer) {
            byte[] tmp = new byte[toffs];
            System.arraycopy(tbuf, 0, tmp, 0, tmp.length);
            this.printText(tmp);
        }
    }

    public void printTaggedText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes());
    }

    public void printTaggedText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArabicText(int codetable, String text) throws IOException {
        int ARABIC_RAW = 21;
        int ARABIC_1256M = 23;
        int ARABIC_1256F = 24;
        boolean FROM_RIGHT = true;
        int FROM_LEFT = 2;
        byte[] byArray = new byte[224];
        byArray[32] = 3;
        byArray[34] = 1;
        byArray[36] = 1;
        byArray[38] = 1;
        byArray[40] = 1;
        byArray[43] = 1;
        byArray[44] = 3;
        byArray[45] = 2;
        byArray[47] = 1;
        byArray[48] = 3;
        byArray[49] = 2;
        byArray[51] = 1;
        byArray[52] = 3;
        byArray[53] = 2;
        byArray[55] = 1;
        byArray[56] = 3;
        byArray[57] = 2;
        byArray[59] = 1;
        byArray[60] = 3;
        byArray[61] = 2;
        byArray[63] = 1;
        byArray[64] = 3;
        byArray[65] = 2;
        byArray[67] = 1;
        byArray[68] = 3;
        byArray[69] = 2;
        byArray[71] = 1;
        byArray[72] = 3;
        byArray[73] = 2;
        byArray[75] = 1;
        byArray[76] = 3;
        byArray[77] = 2;
        byArray[79] = 1;
        byArray[81] = 1;
        byArray[83] = 1;
        byArray[85] = 1;
        byArray[87] = 1;
        byArray[89] = 1;
        byArray[91] = 1;
        byArray[93] = 1;
        byArray[94] = 3;
        byArray[95] = 2;
        byArray[97] = 1;
        byArray[98] = 3;
        byArray[99] = 2;
        byArray[101] = 1;
        byArray[102] = 3;
        byArray[103] = 2;
        byArray[105] = 1;
        byArray[106] = 3;
        byArray[107] = 2;
        byArray[109] = 1;
        byArray[110] = 3;
        byArray[111] = 2;
        byArray[113] = 1;
        byArray[114] = 3;
        byArray[115] = 2;
        byArray[117] = 1;
        byArray[118] = 3;
        byArray[119] = 2;
        byArray[121] = 1;
        byArray[122] = 3;
        byArray[123] = 2;
        byArray[125] = 1;
        byArray[126] = 3;
        byArray[127] = 2;
        byArray[129] = 1;
        byArray[130] = 3;
        byArray[131] = 2;
        byArray[133] = 1;
        byArray[134] = 3;
        byArray[135] = 2;
        byArray[137] = 1;
        byArray[138] = 3;
        byArray[139] = 2;
        byArray[141] = 1;
        byArray[143] = 1;
        byArray[144] = 3;
        byArray[145] = 2;
        byArray[147] = 1;
        byArray[148] = 3;
        byArray[149] = 2;
        byArray[151] = 1;
        byArray[153] = 1;
        byArray[154] = 3;
        byArray[155] = 2;
        byArray[157] = 1;
        byArray[159] = 1;
        byArray[161] = 1;
        byArray[162] = 3;
        byArray[163] = 2;
        byArray[164] = 3;
        byArray[165] = 1;
        byArray[167] = 1;
        byArray[168] = 3;
        byArray[169] = 2;
        byArray[171] = 1;
        byArray[172] = 3;
        byArray[173] = 2;
        byArray[175] = 1;
        byArray[210] = 1;
        byArray[211] = 3;
        byArray[212] = 2;
        byArray[214] = 1;
        byArray[216] = 1;
        byte[] ArabicAttr = byArray;
        byte[] byArray2 = new byte[32];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        byArray2[8] = 8;
        byArray2[9] = 9;
        byArray2[10] = 10;
        byArray2[11] = 11;
        byArray2[12] = 12;
        byArray2[13] = 13;
        byArray2[14] = 14;
        byArray2[15] = 15;
        byArray2[16] = 16;
        byArray2[17] = 17;
        byArray2[18] = 18;
        byArray2[19] = 19;
        byArray2[20] = -80;
        byArray2[21] = -79;
        byArray2[22] = -78;
        byArray2[23] = 23;
        byArray2[24] = 24;
        byArray2[25] = 25;
        byArray2[26] = 26;
        byArray2[27] = 27;
        byArray2[28] = 28;
        byArray2[29] = 29;
        byArray2[30] = 30;
        byArray2[31] = 31;
        byte[] Arabic1256F = byArray2;
        byte[] byArray3 = new byte[32];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 4;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 7;
        byArray3[8] = 8;
        byArray3[9] = 9;
        byArray3[10] = 10;
        byArray3[11] = 11;
        byArray3[12] = 12;
        byArray3[13] = 13;
        byArray3[14] = 14;
        byArray3[15] = 15;
        byArray3[16] = 16;
        byArray3[17] = 17;
        byArray3[18] = 18;
        byArray3[19] = 19;
        byArray3[20] = 20;
        byArray3[21] = 21;
        byArray3[22] = 22;
        byArray3[23] = 23;
        byArray3[24] = 24;
        byArray3[25] = 25;
        byArray3[26] = 26;
        byArray3[27] = 27;
        byArray3[28] = 28;
        byArray3[29] = 29;
        byArray3[30] = 30;
        byArray3[31] = 31;
        byte[] Arabic1256M = byArray3;
        byte[][] byArrayArray = new byte[4][];
        byte[] byArray4 = new byte[128];
        byArray4[0] = -54;
        byArray4[1] = 46;
        byArray4[2] = -76;
        byArray4[3] = -49;
        byArray4[4] = -73;
        byArray4[5] = -70;
        byArray4[8] = -67;
        byArray4[9] = -66;
        byArray4[10] = 58;
        byArray4[11] = 28;
        byArray4[13] = 70;
        byArray4[14] = 90;
        byArray4[15] = 88;
        byArray4[16] = -120;
        byArray4[17] = -74;
        byArray4[18] = -75;
        byArray4[19] = -71;
        byArray4[20] = -72;
        byArray4[21] = -68;
        byArray4[24] = -124;
        byArray4[25] = -63;
        byArray4[26] = 88;
        byArray4[27] = 30;
        byArray4[31] = -106;
        byArray4[33] = 12;
        byArray4[34] = -53;
        byArray4[35] = -52;
        byArray4[36] = -51;
        byArray4[37] = -50;
        byArray4[38] = -48;
        byArray4[39] = -47;
        byArray4[41] = -62;
        byArray4[42] = -96;
        byArray4[43] = -56;
        byArray4[45] = 13;
        byArray4[46] = -61;
        byArray4[48] = -65;
        byArray4[49] = -59;
        byArray4[50] = -64;
        byArray4[54] = -46;
        byArray4[55] = -69;
        byArray4[58] = 27;
        byArray4[59] = -55;
        byArray4[63] = 31;
        byArray4[64] = -96;
        byArray4[65] = 41;
        byArray4[66] = 33;
        byArray4[67] = 35;
        byArray4[68] = -98;
        byArray4[69] = 37;
        byArray4[70] = -86;
        byArray4[71] = 39;
        byArray4[72] = 42;
        byArray4[73] = -43;
        byArray4[74] = 50;
        byArray4[75] = 54;
        byArray4[76] = 62;
        byArray4[77] = 66;
        byArray4[78] = 74;
        byArray4[79] = 78;
        byArray4[80] = 80;
        byArray4[81] = 84;
        byArray4[82] = 86;
        byArray4[83] = 92;
        byArray4[84] = 96;
        byArray4[85] = 100;
        byArray4[86] = 104;
        byArray4[87] = -57;
        byArray4[88] = 108;
        byArray4[89] = 112;
        byArray4[90] = 116;
        byArray4[91] = 120;
        byArray4[92] = 32;
        byArray4[93] = 124;
        byArray4[94] = -128;
        byArray4[95] = -82;
        byArray4[97] = -116;
        byArray4[99] = -110;
        byArray4[100] = -104;
        byArray4[101] = -96;
        byArray4[102] = -100;
        byArray4[108] = -92;
        byArray4[109] = -90;
        byArray4[119] = -58;
        byArray4[127] = -41;
        byArrayArray[0] = byArray4;
        byte[] byArray5 = new byte[128];
        byArray5[0] = -54;
        byArray5[1] = 47;
        byArray5[2] = -76;
        byArray5[3] = -49;
        byArray5[4] = -73;
        byArray5[5] = -70;
        byArray5[8] = -67;
        byArray5[9] = -66;
        byArray5[10] = 59;
        byArray5[11] = 28;
        byArray5[13] = 71;
        byArray5[14] = 91;
        byArray5[15] = 89;
        byArray5[16] = -119;
        byArray5[17] = -74;
        byArray5[18] = -75;
        byArray5[19] = -71;
        byArray5[20] = -72;
        byArray5[21] = -68;
        byArray5[24] = -123;
        byArray5[25] = -63;
        byArray5[26] = 89;
        byArray5[27] = 30;
        byArray5[31] = -105;
        byArray5[33] = 12;
        byArray5[34] = -53;
        byArray5[35] = -52;
        byArray5[36] = -51;
        byArray5[37] = -50;
        byArray5[38] = -48;
        byArray5[39] = -47;
        byArray5[41] = -62;
        byArray5[42] = -95;
        byArray5[43] = -56;
        byArray5[45] = 13;
        byArray5[46] = -61;
        byArray5[48] = -65;
        byArray5[49] = -59;
        byArray5[50] = -64;
        byArray5[54] = -46;
        byArray5[55] = -69;
        byArray5[58] = 27;
        byArray5[59] = -55;
        byArray5[63] = 31;
        byArray5[64] = -46;
        byArray5[65] = 41;
        byArray5[66] = 34;
        byArray5[67] = 36;
        byArray5[68] = -97;
        byArray5[69] = 38;
        byArray5[70] = -85;
        byArray5[71] = 40;
        byArray5[72] = 43;
        byArray5[73] = -42;
        byArray5[74] = 51;
        byArray5[75] = 55;
        byArray5[76] = 63;
        byArray5[77] = 67;
        byArray5[78] = 75;
        byArray5[79] = 79;
        byArray5[80] = 81;
        byArray5[81] = 85;
        byArray5[82] = 87;
        byArray5[83] = 93;
        byArray5[84] = 97;
        byArray5[85] = 101;
        byArray5[86] = 105;
        byArray5[87] = -57;
        byArray5[88] = 109;
        byArray5[89] = 113;
        byArray5[90] = 117;
        byArray5[91] = 121;
        byArray5[92] = 32;
        byArray5[93] = 125;
        byArray5[94] = -127;
        byArray5[95] = -81;
        byArray5[97] = -115;
        byArray5[99] = -109;
        byArray5[100] = -103;
        byArray5[101] = -95;
        byArray5[102] = -99;
        byArray5[108] = -91;
        byArray5[109] = -89;
        byArray5[119] = -58;
        byArray5[127] = -40;
        byArrayArray[1] = byArray5;
        byte[] byArray6 = new byte[128];
        byArray6[0] = -54;
        byArray6[1] = 49;
        byArray6[2] = -76;
        byArray6[3] = -49;
        byArray6[4] = -73;
        byArray6[5] = -70;
        byArray6[8] = -67;
        byArray6[9] = -66;
        byArray6[10] = 61;
        byArray6[11] = 28;
        byArray6[13] = 73;
        byArray6[14] = 90;
        byArray6[15] = 88;
        byArray6[16] = -117;
        byArray6[17] = -74;
        byArray6[18] = -75;
        byArray6[19] = -71;
        byArray6[20] = -72;
        byArray6[21] = -68;
        byArray6[24] = -121;
        byArray6[25] = -63;
        byArray6[26] = 88;
        byArray6[27] = 30;
        byArray6[31] = -106;
        byArray6[33] = 12;
        byArray6[34] = -53;
        byArray6[35] = -52;
        byArray6[36] = -51;
        byArray6[37] = -50;
        byArray6[38] = -48;
        byArray6[39] = -47;
        byArray6[41] = -62;
        byArray6[42] = -93;
        byArray6[43] = -56;
        byArray6[45] = 13;
        byArray6[46] = -61;
        byArray6[48] = -65;
        byArray6[49] = -59;
        byArray6[50] = -64;
        byArray6[54] = -46;
        byArray6[55] = -69;
        byArray6[58] = 27;
        byArray6[59] = -55;
        byArray6[63] = 31;
        byArray6[64] = -44;
        byArray6[65] = 41;
        byArray6[66] = 33;
        byArray6[67] = 35;
        byArray6[68] = -98;
        byArray6[69] = 37;
        byArray6[70] = -83;
        byArray6[71] = 39;
        byArray6[72] = 45;
        byArray6[73] = -43;
        byArray6[74] = 53;
        byArray6[75] = 57;
        byArray6[76] = 65;
        byArray6[77] = 69;
        byArray6[78] = 77;
        byArray6[79] = 78;
        byArray6[80] = 80;
        byArray6[81] = 84;
        byArray6[82] = 86;
        byArray6[83] = 95;
        byArray6[84] = 99;
        byArray6[85] = 103;
        byArray6[86] = 107;
        byArray6[87] = -57;
        byArray6[88] = 111;
        byArray6[89] = 115;
        byArray6[90] = 119;
        byArray6[91] = 123;
        byArray6[92] = 32;
        byArray6[93] = 127;
        byArray6[94] = -125;
        byArray6[95] = -121;
        byArray6[97] = -111;
        byArray6[99] = -107;
        byArray6[100] = -101;
        byArray6[101] = -93;
        byArray6[102] = -100;
        byArray6[108] = -92;
        byArray6[109] = -87;
        byArray6[119] = -58;
        byArray6[127] = -41;
        byArrayArray[2] = byArray6;
        byte[] byArray7 = new byte[128];
        byArray7[0] = -54;
        byArray7[1] = 48;
        byArray7[2] = -76;
        byArray7[3] = -49;
        byArray7[4] = -73;
        byArray7[5] = -70;
        byArray7[8] = -67;
        byArray7[9] = -66;
        byArray7[10] = 60;
        byArray7[11] = 28;
        byArray7[13] = 72;
        byArray7[14] = 91;
        byArray7[15] = 89;
        byArray7[16] = -118;
        byArray7[17] = -74;
        byArray7[18] = -75;
        byArray7[19] = -71;
        byArray7[20] = -72;
        byArray7[21] = -68;
        byArray7[24] = -122;
        byArray7[25] = -63;
        byArray7[26] = 89;
        byArray7[27] = 30;
        byArray7[31] = -105;
        byArray7[33] = 12;
        byArray7[34] = -53;
        byArray7[35] = -52;
        byArray7[36] = -51;
        byArray7[37] = -50;
        byArray7[38] = -48;
        byArray7[39] = -47;
        byArray7[41] = -62;
        byArray7[42] = -94;
        byArray7[43] = -56;
        byArray7[45] = 13;
        byArray7[46] = -61;
        byArray7[48] = -65;
        byArray7[49] = -59;
        byArray7[50] = -64;
        byArray7[54] = -46;
        byArray7[55] = -69;
        byArray7[58] = 27;
        byArray7[59] = -55;
        byArray7[63] = 31;
        byArray7[64] = -45;
        byArray7[65] = 41;
        byArray7[66] = 34;
        byArray7[67] = 36;
        byArray7[68] = -97;
        byArray7[69] = 38;
        byArray7[70] = -84;
        byArray7[71] = 40;
        byArray7[72] = 44;
        byArray7[73] = -43;
        byArray7[74] = 52;
        byArray7[75] = 56;
        byArray7[76] = 64;
        byArray7[77] = 68;
        byArray7[78] = 76;
        byArray7[79] = 79;
        byArray7[80] = 81;
        byArray7[81] = 85;
        byArray7[82] = 87;
        byArray7[83] = 94;
        byArray7[84] = 98;
        byArray7[85] = 102;
        byArray7[86] = 106;
        byArray7[87] = -57;
        byArray7[88] = 110;
        byArray7[89] = 114;
        byArray7[90] = 118;
        byArray7[91] = 122;
        byArray7[92] = 32;
        byArray7[93] = 126;
        byArray7[94] = -126;
        byArray7[95] = -122;
        byArray7[97] = -112;
        byArray7[99] = -108;
        byArray7[100] = -102;
        byArray7[101] = -94;
        byArray7[102] = -99;
        byArray7[108] = -92;
        byArray7[109] = -88;
        byArray7[119] = -58;
        byArray7[127] = -41;
        byArrayArray[3] = byArray7;
        byte[][] Arabic1256 = byArrayArray;
        byte[] input = text.getBytes("Cp1256");
        boolean found = false;
        int i = 0;
        while (i < input.length) {
            if (input[i] == -20) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int LastAttr = 0;
            int NextAttr = 0;
            int ArabAttr = 0;
            int i2 = 0;
            while (i2 < input.length) {
                int ThisByte = input[i2] & 0xFF;
                if (ThisByte <= 32) {
                    LastAttr = 0;
                } else {
                    int NextByte;
                    ArabAttr = 0;
                    NextAttr = 0;
                    int n = NextByte = input.length - 1 == i2 ? 0 : input[i2] & 0xFF;
                    if (NextByte >= 128) {
                        NextByte = Arabic1256[1][NextByte - 128] & 0xFF;
                        NextAttr = ArabicAttr[NextByte] & 0xFF;
                    }
                    if (NextAttr & true) {
                        ArabAttr |= 2;
                    }
                    if ((LastAttr & 2) != 0) {
                        ArabAttr |= 1;
                    }
                    if (ThisByte < 64) {
                        ThisByte = codetable == 23 ? (Arabic1256M[ThisByte - 32] & 0xFF) + 32 : (Arabic1256F[ThisByte - 32] & 0xFF) + 32;
                    } else {
                        ThisByte = (Arabic1256[ArabAttr][ThisByte - 128] & 0xFF) + 32;
                        if (codetable == 24 && (ThisByte == 198 || ThisByte == 199)) {
                            ThisByte -= 2;
                        }
                        ArabAttr = ArabicAttr[ThisByte - 32] & 0xFF;
                    }
                    LastAttr = ArabAttr;
                }
                output.write(ThisByte);
                ++i2;
            }
            input = output.toByteArray();
            Printer printer = this;
            synchronized (printer) {
                this.selectCodetable(21);
                this.write(input);
                this.selectCodetable(codetable);
            }
        }
        Printer printer = this;
        synchronized (printer) {
            this.selectCodetable(codetable);
            this.write(input);
        }
    }

    private static void convertARGBToGrayscale(int[] argb, int width, int height) {
        int pixels = width * height;
        int i = 0;
        while (i < pixels) {
            int color;
            int r = argb[i] >> 16 & 0xFF;
            int g = argb[i] >> 8 & 0xFF;
            int b = argb[i] & 0xFF;
            argb[i] = color = r * 19 + g * 38 + b * 7 >> 6 & 0xFF;
            ++i;
        }
    }

    private static void ditherImageByFloydSteinberg(int[] grayscale, int width, int height) {
        int stopXM1 = width - 1;
        int stopYM1 = height - 1;
        int[] coef = new int[]{3, 5, 1};
        int y = 0;
        int offs = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int ed;
                int error;
                int v = grayscale[offs];
                if (v < 128) {
                    grayscale[offs] = 0;
                    error = v;
                } else {
                    grayscale[offs] = 255;
                    error = v - 255;
                }
                if (x != stopXM1) {
                    ed = grayscale[offs + 1] + error * 7 / 16;
                    grayscale[offs + 1] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                }
                if (y != stopYM1) {
                    int i = -1;
                    int j = 0;
                    while (i <= 1) {
                        if (x + i >= 0 && x + i < width) {
                            ed = grayscale[offs + width + i] + error * coef[j] / 16;
                            grayscale[offs + width + i] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                        }
                        ++i;
                        ++j;
                    }
                }
                ++x;
                ++offs;
            }
            ++y;
        }
    }

    private int cropImage(int[] grayscale, int width, int height) {
        int length = width * height;
        int offset = 0;
        while (offset < length) {
            if (grayscale[length - 1 - offset] < 128) break;
            ++offset;
        }
        int newHeight = height - offset / width;
        return newHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printImage(int[] argb, int width, int height, int align, boolean dither, boolean crop) throws IOException {
        byte[] buf = null;
        int bufOffs = 0;
        if (argb == null) {
            throw new NullPointerException("The argb is null");
        }
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The size of image is illegal");
        }
        Printer.convertARGBToGrayscale(argb, width, height);
        if (dither) {
            Printer.ditherImageByFloydSteinberg(argb, width, height);
        }
        if (crop) {
            height = this.cropImage(argb, width, height);
        }
        buf = new byte[width * 3 + 9];
        Printer printer = this;
        synchronized (printer) {
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 51;
            buf[bufOffs++] = 24;
            this.write(buf, 0, bufOffs);
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 97;
            buf[bufOffs++] = (byte)align;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 42;
            buf[bufOffs++] = 33;
            buf[bufOffs++] = (byte)(width % 256);
            buf[bufOffs++] = (byte)(width / 256);
            buf[buf.length - 1] = 10;
            int j = 0;
            int offs = 0;
            while (j < height) {
                int i;
                if (j > 0 && j % 24 == 0) {
                    this.write(buf);
                    i = bufOffs;
                    while (i < buf.length - 1) {
                        buf[i] = 0;
                        ++i;
                    }
                }
                i = 0;
                while (i < width) {
                    int n = bufOffs + i * 3 + j % 24 / 8;
                    buf[n] = (byte)(buf[n] | (byte)((argb[offs] < 128 ? 1 : 0) << 7 - j % 8));
                    ++i;
                    ++offs;
                }
                ++j;
            }
            this.write(buf);
        }
    }

    public void printImage(int[] argb, int width, int height, int align, boolean dither) throws IOException {
        this.printImage(argb, width, height, align, dither, false);
    }

    private static int compressRLE(byte[] src, int srcOffs, byte[] dst, int dstOffs, int length) {
        int offset = 0;
        int dstLen = 0;
        while (offset < length) {
            int count = 1;
            int currValue = src[srcOffs + offset] & 0xFF;
            int i = offset + 1;
            while (i < length && count < 64) {
                int nextValue = src[srcOffs + i] & 0xFF;
                if (currValue != nextValue) break;
                ++count;
                ++i;
            }
            if (count > 1) {
                dst[dstOffs + dstLen] = (byte)(0xC0 | count);
                dst[dstOffs + ++dstLen] = (byte)currValue;
                ++dstLen;
            } else if ((currValue & 0xC0) == 192) {
                dst[dstOffs + dstLen] = -63;
                dst[dstOffs + ++dstLen] = (byte)currValue;
                ++dstLen;
            } else {
                dst[dstOffs + dstLen] = (byte)currValue;
                ++dstLen;
            }
            offset += count;
        }
        return dstLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompressedImage(int[] argb, int width, int height, int align, boolean dither, boolean crop) throws IOException {
        if (argb == null) {
            throw new NullPointerException("The argb is null");
        }
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The size of image is illegal");
        }
        Printer.convertARGBToGrayscale(argb, width, height);
        if (dither) {
            Printer.ditherImageByFloydSteinberg(argb, width, height);
        }
        if (crop) {
            height = this.cropImage(argb, width, height);
        }
        Printer printer = this;
        synchronized (printer) {
            int horzSizeInBytes = (width + 7) / 8;
            byte[] buffer = new byte[horzSizeInBytes * 24 + 7];
            byte[] packed = new byte[horzSizeInBytes * 24 * 2];
            int cmdOffset = 0;
            cmdOffset = 0;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 51;
            buffer[cmdOffset++] = 24;
            this.write(buffer, 0, cmdOffset);
            cmdOffset = 0;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 97;
            buffer[cmdOffset++] = (byte)align;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 42;
            buffer[cmdOffset++] = 17;
            buffer[cmdOffset++] = (byte)horzSizeInBytes;
            int j = 0;
            int offset = 0;
            while (j < height) {
                if (j > 0 && j % 24 == 0) {
                    int length = Printer.compressRLE(buffer, cmdOffset, packed, 0, buffer.length - cmdOffset);
                    this.write(buffer, 0, cmdOffset);
                    this.write(packed, 0, length);
                    this.write(10);
                    int i = cmdOffset;
                    while (i < buffer.length) {
                        buffer[i] = 0;
                        ++i;
                    }
                }
                int i = 0;
                while (i < width) {
                    int n = cmdOffset + i / 8 + j % 24 * horzSizeInBytes;
                    buffer[n] = (byte)(buffer[n] | (byte)((argb[offset] < 128 ? 1 : 0) << i % 8));
                    ++i;
                    ++offset;
                }
                ++j;
            }
            int length = Printer.compressRLE(buffer, cmdOffset, packed, 0, buffer.length - cmdOffset);
            this.write(buffer, 0, cmdOffset);
            this.write(packed, 0, length);
            this.write(10);
        }
    }

    public void printCompressedImage(int[] argb, int width, int height, int align, boolean dither) throws IOException {
        this.printCompressedImage(argb, width, height, align, dither, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo(boolean wide, boolean high) throws IOException {
        byte mode = 0;
        if (wide) {
            mode = (byte)(mode + 1);
        }
        if (high) {
            mode = (byte)(mode + 2);
        }
        byte[] buf = new byte[]{29, 47, mode};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo() throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 47;
        byte[] buf = byArray;
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    public void setBarcode(int align, boolean small, int scale, int hri, int height) {
        if (align < 0) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (scale < 2 || scale > 4) {
            throw new IllegalArgumentException("The scale is illegal");
        }
        if (hri < 0) {
            throw new IllegalArgumentException("The hri is negative");
        }
        if (height < 1 || height > 255) {
            throw new IllegalArgumentException("The height is illegal");
        }
        this.mSettings.barcodeAlign = align;
        this.mSettings.barcodeHriFont = small ? 1 : 0;
        this.mSettings.barcodeScale = scale;
        this.mSettings.barcodeHriCode = hri;
        this.mSettings.barcodeHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBarcode(int type, byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null.");
        }
        byte[] buf = new byte[21 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 119;
        buf[offs++] = (byte)this.mSettings.barcodeScale;
        buf[offs++] = 29;
        buf[offs++] = 104;
        buf[offs++] = (byte)this.mSettings.barcodeHeight;
        buf[offs++] = 29;
        buf[offs++] = 72;
        buf[offs++] = (byte)this.mSettings.barcodeHriCode;
        buf[offs++] = 29;
        buf[offs++] = 102;
        buf[offs++] = (byte)this.mSettings.barcodeHriFont;
        switch (type) {
            case 65: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCA barcode data must be 11 symbols");
            }
            case 66: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCE barcode data must be 11 symbols");
            }
            case 67: {
                if (data.length == 12) break;
                throw new IllegalArgumentException("The length of EAN13 barcode data must be 12 symbols");
            }
            case 68: {
                if (data.length == 7) break;
                throw new IllegalArgumentException("The length of EAN8 barcode data must be 7 symbols");
            }
            case 74: {
                if (data.length >= 1 && data.length <= 1000) break;
                throw new IllegalArgumentException("The length of PDF417 barcode data must be between 1 and 1000 symbols");
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: {
                if (data.length >= 1 && data.length <= 255) break;
                throw new IllegalArgumentException("The length of barcode data must be between 1 and 255 symbols");
            }
            default: {
                throw new IllegalArgumentException("Invalid barcode type");
            }
        }
        buf[offs++] = 29;
        buf[offs++] = 107;
        buf[offs++] = (byte)type;
        if (type == 73 && data[0] != 123) {
            buf[offs++] = (byte)(data.length + 2);
            buf[offs++] = 123;
            buf[offs++] = 66;
        } else if (type == 74) {
            buf[offs++] = 0;
            buf[offs++] = (byte)(data.length & 0xFF);
            buf[offs++] = (byte)(data.length >> 8 & 0xFF);
        } else {
            buf[offs++] = (byte)data.length;
        }
        int i = 0;
        while (i < data.length) {
            buf[offs++] = data[i];
            ++i;
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf, 0, offs);
        }
    }

    public void printBarcode(int type, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printBarcode(type, data.getBytes());
    }

    public void printQRCode(int size, int eccLv, byte[] data) throws IOException {
        byte[] buf = new byte[10 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 81;
        buf[offs++] = 6;
        buf[offs++] = (byte)size;
        buf[offs++] = (byte)eccLv;
        buf[offs++] = (byte)data.length;
        buf[offs++] = (byte)(data.length >> 8);
        int i = 0;
        while (i < data.length) {
            buf[offs++] = data[i];
            ++i;
        }
        this.write(buf);
    }

    public void printQRCode(int size, int eccLv, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printQRCode(size, eccLv, data.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calibrateBMMSensor() throws IOException {
        byte[] buf = new byte[]{27, 67, 65, 76, 3};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedLabel() throws IOException {
        byte[] buf = new byte[]{12};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPageMode() throws IOException {
        byte[] buf = new byte[]{27, 76, 24};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectStandardMode() throws IOException {
        byte[] buf = new byte[]{29, 85};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage() throws IOException {
        byte[] buf = new byte[]{29, 90};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageRegion(int x, int y, int width, int height, int direction) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || direction < 0 || direction > 3) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 87, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), 29, 84, (byte)(direction & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageXY(int x, int y) throws IOException {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 36, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), 29, 36, (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageRectangle(int x, int y, int width, int height, int fillMode) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 82, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageFrame(int x, int y, int width, int height, int fillMode, int thickness) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2 || thickness < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 88, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF), (byte)(thickness & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSettings(int type) throws IOException {
        byte[] buffer = new byte[2044];
        int offset = 0;
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 115, (byte)type});
            do {
                this.request(++offset, 1000);
            } while (buffer[offset - 1] != 0);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < offset) {
            if ((buffer[i] & 0xFF) > 32) {
                sb.append((char)(buffer[i] & 0xFF));
            } else if ((buffer[i] & 0xFF) > 0) {
                sb.append('\n');
            }
            ++i;
        }
        return sb.toString().substring(1).split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntensity(int level) throws IOException {
        byte[] buf = new byte[]{27, 89, (byte)level};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    public TouchChip getTouchChip() {
        TouchChip instance = new TouchChip(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected byte[] transmit(byte[] input) throws IOException {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(27);
                buffer.write(39);
                int i22 = 0;
                while (i22 < input.length) {
                    int v = input[i22] & 0xFF;
                    if (v < 32) {
                        buffer.write(16);
                        buffer.write(v + 32);
                    } else {
                        buffer.write(v);
                    }
                    ++i22;
                }
                Printer i22 = Printer.this;
                synchronized (i22) {
                    Printer.this.clear();
                    Printer.this.output(buffer.toByteArray());
                    int offset = 0;
                    do {
                        Printer.this.request(++offset, 31000);
                    } while (offset < Printer.this.mDataBuffer.length - 1 && Printer.this.mDataBuffer[offset - 1] != 10);
                    buffer.reset();
                    int i = 0;
                    while (i < offset - 2) {
                        int v = Printer.this.mDataBuffer[i] & 0xFF;
                        if (v == 16) {
                            v = (Printer.this.mDataBuffer[++i] & 0xFF) - 32;
                        }
                        buffer.write(v);
                        ++i;
                    }
                }
                byte[] result = buffer.toByteArray();
                return result;
            }
        };
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalFormat() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(69);
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(o.toByteArray());
            this.request(3, 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalWrite(byte[] data) throws IOException {
        if (data.length > 400) {
            throw new IllegalArgumentException("The parameter 'text' is out of limits");
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(119);
        o.write(data.length);
        o.write(data.length >> 8);
        o.write(data);
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(o.toByteArray());
            this.request(3, 1000);
        }
    }

    public void journalWrite(String text, String charset) throws IOException {
        byte[] data = text.getBytes(charset);
        this.journalWrite(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalPrint() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(80);
        Printer printer = this;
        synchronized (printer) {
            this.output(o.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] journalRead(boolean first) throws IOException {
        byte[] buffer = new byte[]{29, 35, 37, 38, 42, first ? (byte)70 : 78};
        Printer printer = this;
        synchronized (printer) {
            int len;
            block5: {
                this.clear();
                this.output(buffer);
                int cnt = 1;
                len = 0;
                do {
                    this.request(++cnt, 1000);
                    len = (this.mDataBuffer[1] & 0xFF) + ((this.mDataBuffer[2] & 0xFF) << 8);
                } while (cnt < 3 || len != cnt - 3);
                if (this.mDataBuffer[0] != 70) break block5;
                return null;
            }
            byte[] tmp = new byte[len];
            System.arraycopy(this.mDataBuffer, 3, tmp, 0, tmp.length);
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] journalRead() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        Printer printer = this;
        synchronized (printer) {
            byte[] res = this.journalRead(true);
            if (res != null) {
                o.write(res);
                while ((res = this.journalRead(false)) != null) {
                    o.write(res);
                }
            }
        }
        return o.toByteArray();
    }

    public String journalRead(String charset) throws IOException {
        byte[] data = this.journalRead();
        return new String(data, 0, data.length, charset);
    }

    public static interface ConnectionListener {
        public void onDisconnect();
    }

    private class Settings {
        public int barcodeAlign;
        public int barcodeScale;
        public int barcodeHeight;
        public int barcodeHriFont;
        public int barcodeHriCode;

        private Settings() {
        }
    }
}

