/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.printer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtocolAdapter {
    private static final int MAX_PACKET_SIZE = 2048;
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int HEADER_SIZE = 4;
    private static final int PACKET_SIZE = 2048;
    private static final int DATA_SIZE = 2044;
    private static final int EVENT_BARCODE = 1;
    private static final int EVENT_MSR = 2;
    private static final int EVENT_PAPER_IN = 4;
    private static final int EVENT_ENCRYPTED_MSR = 16;
    private static final int EVENT_PAPER_OUT = 32;
    private static final int STATUS_FAILED = 1;
    private static final int STATUS_FULL = 2;
    private static final int STATUS_INVALID = 4;
    private static final int STATUS_LOWBATTERY = 8;
    private static final int STATUS_OVERHEATED = 16;
    private static final int STATUS_NOPAPER = 32;
    private static final int COMMAND_OPEN = 0;
    private static final int COMMAND_CLOSE = 1;
    private static final int COMMAND_SEND = 2;
    private static final int COMMAND_REQUEST = 3;
    private static final int COMMAND_GETSTATUS = 4;
    private static final int COMMAND_SETPORT = 5;
    public static final int CHANNEL_PRINTER = 1;
    public static final int CHANNEL_EMSR = 15;
    public static final int CHANNEL_UNIVERSAL_READER = 16;
    public static final int CHANNEL_RFID = 13;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private IOException mLastError;
    private InputStream mRawInputStream;
    private OutputStream mRawOutputStream;
    private byte[] mDataBuffer;
    private int mDataBufferLen;
    private boolean mProtoEnabled;
    private BarcodeListener mBarcodeListener;
    private CardListener mCardListener;
    private PrinterListener mPrinterListener;
    private boolean mLastPaperState;
    private boolean mLastBatteryState;
    private boolean mLastThermalHeadState;
    private long mLastAccessTime;
    private int mLastStatus;
    private static boolean sDebug = false;
    private static final byte[] EMPTY = new byte[0];

    public ProtocolAdapter(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = in;
        this.mBaseOutputStream = out;
        this.mDataBuffer = new byte[4096];
        this.mDataBufferLen = 0;
        this.mLastPaperState = false;
        this.mLastBatteryState = false;
        this.mLastThermalHeadState = false;
        this.mLastAccessTime = System.currentTimeMillis();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                byte[] buffer = new byte[2048];
                try {
                    while (true) {
                        if (ProtocolAdapter.this.mLastError != null) {
                            return;
                        }
                        int bytesRead = ProtocolAdapter.this.read(buffer, 0, buffer.length);
                        byte[] byArray = ProtocolAdapter.this.mDataBuffer;
                        synchronized (byArray) {
                            int length = Math.min(ProtocolAdapter.this.mDataBuffer.length - ProtocolAdapter.this.mDataBufferLen, bytesRead);
                            System.arraycopy(buffer, 0, ProtocolAdapter.this.mDataBuffer, ProtocolAdapter.this.mDataBufferLen, length);
                            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
                            protocolAdapter.mDataBufferLen = protocolAdapter.mDataBufferLen + length;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException e) {
                    if (sDebug) {
                        e.printStackTrace();
                    }
                    if (ProtocolAdapter.this.mLastError != null) return;
                    ProtocolAdapter.this.mLastError = e;
                }
            }
        });
        t.start();
        this.mProtoEnabled = this.getProtocolMode();
    }

    public synchronized void close() {
        this.mLastError = new IOException("The object is closed");
        try {
            this.mBaseInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mBaseOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private void debug(String text) {
        if (sDebug) {
            System.out.println(text);
        }
    }

    private void debug(String text, byte[] buffer, int offset, int count) {
        if (sDebug) {
            this.debug("<ProtocolAdapter> " + text + ProtocolAdapter.byteArrayToHexString(buffer, offset, count) + "(" + count + ")");
        }
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        int i = 0;
        while (i < length) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
            ++i;
        }
        return new String(buf, 0, offs);
    }

    private void write(byte[] b, int offset, int length) throws IOException {
        this.mBaseOutputStream.write(b, offset, length);
        this.mBaseOutputStream.flush();
        this.debug(">> ", b, offset, length);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.mBaseInputStream.read(buffer, offset, length);
        if (bytesRead < 0) {
            throw new IOException("The end of the stream is reached");
        }
        if (bytesRead > length) {
            throw new IOException("Invalid stream result " + bytesRead);
        }
        if (bytesRead > 0) {
            this.debug("<< ", buffer, offset, bytesRead);
        }
        return bytesRead;
    }

    private void request(int length, int timeout) throws IOException {
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (this.mDataBufferLen < length) {
            if (this.mLastError != null) {
                throw this.mLastError;
            }
            if (endTime < System.currentTimeMillis()) {
                throw new IOException("Timeout");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(int length) {
        byte[] byArray = this.mDataBuffer;
        synchronized (this.mDataBuffer) {
            if (length > this.mDataBufferLen) {
                length = this.mDataBufferLen;
            }
            this.mDataBufferLen -= length;
            System.arraycopy(this.mDataBuffer, length, this.mDataBuffer, 0, this.mDataBufferLen);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pending() {
        byte[] byArray = this.mDataBuffer;
        synchronized (this.mDataBuffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mDataBufferLen;
        }
    }

    private boolean getProtocolMode() throws IOException {
        this.debug("Get if printer is into protocol mode");
        do {
            this.consume(2048);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.pending() > 0);
        this.writePacket(1, 2);
        try {
            this.request(4, 500);
        }
        catch (IOException e) {
            this.debug("Protocol mode enabled");
            return false;
        }
        this.consume(2048);
        this.debug("Protocol mode disabled");
        return true;
    }

    private void raiseReadBarcode() {
        final BarcodeListener l = this.mBarcodeListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onReadBarcode();
                }
            }).start();
        }
    }

    private void raiseReadCard(final boolean encrypted) {
        final CardListener l = this.mCardListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onReadCard(encrypted);
                }
            }).start();
        }
    }

    private void raiseBatteryStateChanged(final boolean state) {
        final PrinterListener l = this.mPrinterListener;
        if (l != null && this.mLastBatteryState != state) {
            this.mLastBatteryState = state;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onBatteryStateChanged(state);
                }
            }).start();
        }
    }

    private void raisePaperStateChanged(final boolean state) {
        final PrinterListener l = this.mPrinterListener;
        if (l != null && this.mLastPaperState != state) {
            this.mLastPaperState = state;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onPaperStateChanged(state);
                }
            }).start();
        }
    }

    private void raiseThermalHeadStateChanged(final boolean state) {
        final PrinterListener l = this.mPrinterListener;
        if (l != null && this.mLastThermalHeadState != state) {
            this.mLastThermalHeadState = state;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onThermalHeadStateChanged(state);
                }
            }).start();
        }
    }

    private void processEvent(int event) {
        if ((event & 1) != 0) {
            this.raiseReadBarcode();
        }
        if ((event & 2) != 0) {
            this.raiseReadCard(false);
        }
        if ((event & 4) != 0) {
            this.raisePaperStateChanged(true);
        }
        if ((event & 0x20) != 0) {
            this.raisePaperStateChanged(false);
        }
        if ((event & 0x10) != 0) {
            this.raiseReadCard(true);
        }
    }

    private void suspendTransmit(int time) {
        long elapsed = System.currentTimeMillis() - this.mLastAccessTime;
        if (elapsed < (long)time) {
            try {
                Thread.sleep((long)time - elapsed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void writePacket(int channel, int command, byte[] data, int offset, int length) throws IOException {
        byte[] buffer = new byte[4 + length];
        buffer[0] = (byte)channel;
        buffer[1] = (byte)command;
        buffer[2] = (byte)(length >> 8);
        buffer[3] = (byte)(length & 0xFF);
        System.arraycopy(data, offset, buffer, 4, length);
        this.write(buffer, 0, buffer.length);
    }

    private void writePacket(int channel, int command, byte[] data) throws IOException {
        this.writePacket(channel, command, data, 0, data.length);
    }

    private void writePacket(int channel, int command) throws IOException {
        this.writePacket(channel, command, new byte[0]);
    }

    private byte[] readPacket(int reqChannel) throws IOException {
        byte[] data;
        int status;
        int channel;
        while (true) {
            if (this.mDataBufferLen > 0 && this.mDataBuffer[0] == 43) {
                this.consume(1);
                continue;
            }
            this.request(4, 1000);
            channel = this.mDataBuffer[0] & 0xFF;
            status = this.mDataBuffer[1] & 0xFF;
            int length = (this.mDataBuffer[2] & 0xFF) << 8 | this.mDataBuffer[3] & 0xFF;
            data = EMPTY;
            if ((channel & 0x80) == 0) {
                this.processEvent(length);
                length = 0;
            } else if (length > 0) {
                this.request(4 + length, 1000);
                data = new byte[length];
                System.arraycopy(this.mDataBuffer, 4, data, 0, data.length);
            }
            this.consume(4 + length);
            if ((channel ^= 0x80) == reqChannel) break;
        }
        this.mLastStatus = status;
        if (channel == 1) {
            if ((status & 1) > 0) {
                throw new IOException("Command failed");
            }
            if ((status & 4) > 0) {
                throw new IOException("Invalid command");
            }
            if ((status & 8) > 0) {
                this.raiseBatteryStateChanged(false);
            } else {
                this.raiseBatteryStateChanged(false);
            }
            if ((status & 0x10) > 0) {
                this.raiseThermalHeadStateChanged(true);
            } else {
                this.raiseThermalHeadStateChanged(false);
            }
            if ((status & 0x20) > 0) {
                this.raisePaperStateChanged(true);
            } else {
                this.raisePaperStateChanged(false);
            }
        }
        return data;
    }

    private synchronized void writeToChannel(int reqChannel, byte[] buffer, int offset, int length) throws IOException {
        this.suspendTransmit(10);
        while (length > 0) {
            int chunkSize = Math.min(length, 2044);
            this.writePacket(reqChannel, 2, buffer, offset, chunkSize);
            this.readPacket(reqChannel);
            if ((this.mLastStatus & 2) != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            offset += chunkSize;
            length -= chunkSize;
        }
        this.mLastAccessTime = System.currentTimeMillis();
    }

    private synchronized int readFromChannel(int reqChannel, byte[] buffer, int offset, int length) throws IOException {
        this.suspendTransmit(10);
        this.writePacket(reqChannel, 3);
        byte[] result = this.readPacket(reqChannel);
        if (result.length > length) {
            throw new IOException("Insufficient buffer size");
        }
        this.mLastAccessTime = System.currentTimeMillis();
        System.arraycopy(result, 0, buffer, offset, result.length);
        return result.length;
    }

    public void setBarcodeListener(BarcodeListener listener) {
        this.mBarcodeListener = listener;
    }

    public void setCardListener(CardListener listener) {
        this.mCardListener = listener;
    }

    public void setPrinterListener(PrinterListener listener) {
        this.mPrinterListener = listener;
    }

    public boolean isProtocolEnabled() {
        return this.mProtoEnabled;
    }

    public Channel getChannel(int channel) {
        if (!this.isProtocolEnabled()) {
            throw new IllegalAccessError("Protocol mode is not supported");
        }
        return new Channel(channel);
    }

    public InputStream getRawInputStream() {
        if (this.mRawInputStream == null) {
            this.mRawInputStream = new InputStream(){

                @Override
                public int available() throws IOException {
                    if (ProtocolAdapter.this.mLastError != null) {
                        throw ProtocolAdapter.this.mLastError;
                    }
                    return ProtocolAdapter.this.pending();
                }

                @Override
                public int read() throws IOException {
                    byte[] buffer = new byte[1];
                    this.read(buffer);
                    return buffer[0] & 0xFF;
                }

                @Override
                public int read(byte[] buffer, int offset, int length) throws IOException {
                    int bytesAvailable = 0;
                    while ((bytesAvailable = this.available()) == 0) {
                        if (ProtocolAdapter.this.mLastError != null) {
                            throw ProtocolAdapter.this.mLastError;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    length = Math.min(length, bytesAvailable);
                    System.arraycopy(ProtocolAdapter.this.mDataBuffer, 0, buffer, offset, length);
                    ProtocolAdapter.this.consume(length);
                    return length;
                }

                @Override
                public int read(byte[] buffer) throws IOException {
                    return this.read(buffer, 0, buffer.length);
                }

                @Override
                public void close() throws IOException {
                    ProtocolAdapter.this.mBaseInputStream.close();
                }
            };
        }
        return this.mRawInputStream;
    }

    public OutputStream getRawOutputStream() {
        if (this.mRawOutputStream == null) {
            this.mRawOutputStream = this.mBaseOutputStream;
        }
        return this.mRawOutputStream;
    }

    public static interface BarcodeListener {
        public void onReadBarcode();
    }

    public static interface CardListener {
        public void onReadCard(boolean var1);
    }

    public class Channel {
        private int mChannel;
        private boolean mSuspended;

        public void suspend() {
            this.mSuspended = true;
        }

        public void resume() {
            this.mSuspended = false;
        }

        private Channel(int channel) {
            this.mChannel = channel;
        }

        public int getChannel() {
            return this.mChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() throws IOException {
            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
            synchronized (protocolAdapter) {
                ProtocolAdapter.this.writePacket(this.mChannel, 0);
                ProtocolAdapter.this.readPacket(this.mChannel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
            synchronized (protocolAdapter) {
                ProtocolAdapter.this.writePacket(this.mChannel, 1);
                ProtocolAdapter.this.readPacket(this.mChannel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChannel(int speed, int flow) throws IOException {
            byte[] buffer = new byte[]{(byte)speed, (byte)flow};
            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
            synchronized (protocolAdapter) {
                ProtocolAdapter.this.writePacket(this.mChannel, 5, buffer, 0, buffer.length);
                ProtocolAdapter.this.readPacket(this.mChannel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLedMode(int mode) throws IOException {
            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
            synchronized (protocolAdapter) {
                switch (mode) {
                    case 0: {
                        ProtocolAdapter.this.writePacket(this.mChannel, 6);
                        break;
                    }
                    case 1: {
                        ProtocolAdapter.this.writePacket(this.mChannel, 5, new byte[]{1});
                        break;
                    }
                    case 2: {
                        ProtocolAdapter.this.writePacket(this.mChannel, 5);
                    }
                }
                ProtocolAdapter.this.readPacket(this.mChannel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getStatus() throws IOException {
            ProtocolAdapter protocolAdapter = ProtocolAdapter.this;
            synchronized (protocolAdapter) {
                ProtocolAdapter.this.writePacket(this.mChannel, 4);
                return ProtocolAdapter.this.readPacket(this.mChannel);
            }
        }

        public InputStream getInputStream() {
            return new InputStream(){
                private byte[] mBuffer = new byte[2044];
                private int mOffset = 0;
                private int mLength = 0;
                private IOException mIOException;

                @Override
                public synchronized int available() throws IOException {
                    if (this.mIOException != null) {
                        throw this.mIOException;
                    }
                    if (this.mLength == 0) {
                        try {
                            this.mOffset = 0;
                            this.mLength = Channel.this.mSuspended ? 0 : ProtocolAdapter.this.readFromChannel(Channel.this.mChannel, this.mBuffer, 0, this.mBuffer.length);
                        }
                        catch (IOException e) {
                            this.mIOException = e;
                            throw e;
                        }
                    }
                    return this.mLength;
                }

                @Override
                public synchronized int read(byte[] b, int off, int len) throws IOException {
                    while (this.available() == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int chunkSize = Math.min(this.mLength, len);
                    System.arraycopy(this.mBuffer, this.mOffset, b, off, chunkSize);
                    this.mOffset += chunkSize;
                    this.mLength -= chunkSize;
                    return chunkSize;
                }

                @Override
                public synchronized int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public synchronized int read() throws IOException {
                    byte[] b = new byte[1];
                    this.read(b);
                    return b[0] & 0xFF;
                }

                @Override
                public void close() throws IOException {
                    if (this.mIOException != null) {
                        this.mIOException = new IOException("The stream is closed");
                    }
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(){
                private IOException mIOException;

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (this.mIOException != null) {
                        throw this.mIOException;
                    }
                    try {
                        ProtocolAdapter.this.writeToChannel(Channel.this.mChannel, b, off, len);
                    }
                    catch (IOException e) {
                        this.mIOException = e;
                        throw e;
                    }
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b});
                }

                @Override
                public void close() throws IOException {
                    if (this.mIOException != null) {
                        this.mIOException = new IOException("The stream is closed");
                    }
                }
            };
        }
    }

    public static interface PrinterListener {
        public void onBatteryStateChanged(boolean var1);

        public void onThermalHeadStateChanged(boolean var1);

        public void onPaperStateChanged(boolean var1);
    }
}

