/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.rfid;

import com.datecs.api.rfid.ContactlessCard;
import com.datecs.api.rfid.RC663;
import com.datecs.api.rfid.RFIDException;
import java.io.IOException;

public class FeliCaCard
extends ContactlessCard {
    private static final int FELICA_MAX_READ = 4;
    private static final int FELICA_MAX_WRITE_BLOCKS = 11;
    private static final int FELICA_MAX_WRITE = 176;
    public static final int FELICA_SMARTTAG_BATTERY_NORMAL1 = 0;
    public static final int FELICA_SMARTTAG_BATTERY_NORMAL2 = 1;
    public static final int FELICA_SMARTTAG_BATTERY_LOW1 = 2;
    public static final int FELICA_SMARTTAG_BATTERY_LOW2 = 3;
    public static final int FELICA_SMARTTAG_DRAW_WHITE_BACKGROUND = 0;
    public static final int FELICA_SMARTTAG_DRAW_BLACK_BACKGROUND = 1;
    public static final int FELICA_SMARTTAG_DRAW_KEEP_BACKGROUND = 2;
    public static final int FELICA_SMARTTAG_DRAW_USE_LAYOUT = 3;
    private byte mFelicaSeq = 1;

    public FeliCaCard(RC663 module) {
        super(module);
    }

    @Override
    protected boolean deinitialize() throws IOException {
        try {
            while (true) {
                this.poll();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RFIDException e) {
            return true;
        }
    }

    @Override
    public boolean initialize() throws IOException {
        this.blockSize = 16;
        return true;
    }

    private byte[] poll() throws IOException, RFIDException {
        byte[] byArray = new byte[6];
        byArray[0] = 6;
        byArray[2] = -1;
        byArray[3] = -1;
        byte[] cmd = byArray;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, cmd.length);
        byte[] uuid = new byte[8];
        System.arraycopy(result, 2, uuid, 0, uuid.length);
        return uuid;
    }

    private byte[] transmitRawCommand(int command, byte[] data, int length) throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        int n = ++index;
        cmd[n] = (byte)command;
        System.arraycopy(this.uid, 0, cmd, ++index, this.uid.length);
        System.arraycopy(data, 0, cmd, index += this.uid.length, length);
        cmd[0] = (byte)((index += length) - 0);
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        byte[] tmp = new byte[result.length - 8];
        tmp[0] = result[0];
        System.arraycopy(result, 9, tmp, 1, result.length - 9);
        return tmp;
    }

    public byte[] read(int serviceCode, int startBlock, int blocks) throws IOException, RFIDException {
        if (blocks > 4) {
            throw new IllegalArgumentException("Too much blocks");
        }
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 1;
        cmd[index++] = (byte)(serviceCode >> 8);
        cmd[index++] = (byte)serviceCode;
        cmd[index++] = (byte)blocks;
        int i = 0;
        while (i < blocks) {
            cmd[index++] = -128;
            cmd[index++] = (byte)(startBlock + i);
            ++i;
        }
        byte[] result = null;
        int i2 = 0;
        while (i2 < 3) {
            try {
                result = this.transmitRawCommand(6, cmd, index);
                break;
            }
            catch (RFIDException e) {
                if (e.getErrorCode() != -6) {
                    throw e;
                }
                ++i2;
            }
        }
        if (result != null) {
            if (result[1] != false || result[2] != 0) {
                throw new RFIDException(-20);
            }
            byte[] tmp = new byte[result.length - 4];
            System.arraycopy(result, 4, tmp, 0, tmp.length);
            return tmp;
        }
        throw new RFIDException(-20);
    }

    public void write(int serviceCode, int startBlock, byte[] data) throws IOException, RFIDException {
        if (data.length == 0 || data.length % this.blockSize != 0 || data.length / this.blockSize > 11) {
            throw new IllegalArgumentException("Illegal data size");
        }
        int blocks = data.length / this.blockSize;
        byte[] cmd = new byte[192];
        int index = 0;
        cmd[index++] = 1;
        cmd[index++] = (byte)(serviceCode >> 8);
        cmd[index++] = (byte)serviceCode;
        cmd[index++] = (byte)blocks;
        int i = 0;
        while (i < blocks) {
            cmd[index++] = -128;
            cmd[index++] = (byte)(startBlock + i);
            ++i;
        }
        System.arraycopy(data, 0, cmd, index, 16 * blocks);
        byte[] result = this.transmitRawCommand(8, cmd, index += 16 * blocks);
        if (result[1] != 0 || result[2] != 0) {
            throw new RFIDException(-20);
        }
    }

    private byte[] smartTagGetStatus(boolean ignoreErrors, boolean wait) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int i = 0;
        while (true) {
            int index = 0;
            int n = 0;
            while (n < cmd.length) {
                cmd[n] = 0;
                ++n;
            }
            cmd[index++] = 1;
            cmd[index++] = 9;
            cmd[index++] = 0;
            cmd[index++] = 1;
            cmd[index++] = -128;
            cmd[index++] = 0;
            cmd[index++] = -48;
            cmd[index++] = 1;
            cmd[index++] = 1;
            cmd[index++] = 0;
            cmd[index++] = 0;
            cmd[index++] = 0;
            cmd[index++] = 0;
            cmd[index++] = 0;
            byte[] result = this.transmitRawCommand(8, cmd, index += 8);
            if (result[1] != 0 || result[2] != 0) {
                throw new RFIDException(-20);
            }
            int nBlocks = 1;
            result = this.read(2304, 0, nBlocks);
            this.mFelicaSeq = result[4];
            if (result[3] == -16 || result[3] == -15 || !wait && result[3] == -14) {
                byte[] tmp = new byte[16];
                System.arraycopy(result, 0, tmp, 0, tmp.length);
                return tmp;
            }
            if (!(result[3] == -14 && i < 10 || ignoreErrors)) {
                throw new RFIDException(-20);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private byte[] smartTagWaitCompletion() throws IOException, RFIDException {
        return this.smartTagGetStatus(false, true);
    }

    private byte[] smartTagReadResponse(int blocks) throws IOException, RFIDException {
        if (blocks > 0) {
            int nBlocks = blocks + 1;
            byte[] result = this.read(2304, nBlocks, 0);
            if (result[3] != -16 && result[3] != -15) {
                throw new RFIDException(-20);
            }
            byte[] tmp = new byte[blocks * 16];
            System.arraycopy(result, 16, tmp, 0, tmp.length);
            return tmp;
        }
        return new byte[0];
    }

    private void smartTagCommand(int command, int fsum, int fnum, byte[] param, int blocks, byte[] data) throws IOException, RFIDException {
        byte[] result;
        byte[] cmd = new byte[1920];
        int index = 0;
        cmd[index++] = 1;
        cmd[index++] = 9;
        cmd[index++] = 0;
        cmd[index++] = (byte)(blocks + 1);
        int i = 0;
        while (i < blocks + 1) {
            cmd[index++] = -128;
            cmd[index++] = 0;
            ++i;
        }
        cmd[index++] = (byte)command;
        cmd[index++] = (byte)fsum;
        cmd[index++] = (byte)fnum;
        cmd[index++] = (byte)(blocks * 16);
        if (command == 208) {
            this.mFelicaSeq = 0;
        } else {
            this.mFelicaSeq = (byte)(this.mFelicaSeq + 1);
            if (this.mFelicaSeq == 0) {
                this.mFelicaSeq = 1;
            }
        }
        cmd[index++] = this.mFelicaSeq;
        cmd[index++] = 0;
        cmd[index++] = 0;
        cmd[index++] = 0;
        if (param != null) {
            System.arraycopy(param, 0, cmd, index, 8);
        }
        index += 8;
        if (data != null) {
            System.arraycopy(data, 0, cmd, index, 16 * blocks);
        }
        if ((result = this.transmitRawCommand(8, cmd, index += 16 * blocks))[0] != 0 || result[1] != 0) {
            throw new RFIDException(-20);
        }
    }

    public int smartTagGetBatteryStatus() throws IOException, RFIDException {
        byte[] result = this.smartTagGetStatus(true, false);
        return result[6] & 0xFF;
    }

    public void smartTagClearScreen() throws IOException, RFIDException {
        this.smartTagCommand(161, 1, 1, null, 0, null);
        this.smartTagGetStatus(false, false);
    }

    public void smartTagDrawImage(int x, int y, int width, int height, int drawMode, int layout, byte[] data) throws IOException, RFIDException {
        int m1 = 0;
        int m2 = 0;
        int w = 0;
        w = (width + 7) / 8;
        m1 = x % 8;
        m2 = 8 - (x + width) % 8;
        if (m2 == 8) {
            m2 = 0;
        }
        int nBlocks = (w * height + 15) / 16;
        int nPackets = (nBlocks + 11 - 1) / 11;
        int i = 0;
        int packet = 1;
        while (i < nBlocks) {
            int tosend = nBlocks - i;
            if (tosend > 11) {
                tosend = 11;
            }
            byte[] cmd = new byte[]{(byte)(x / 8 + 1), (byte)(y + 1), (byte)m1, (byte)m2, (byte)w, (byte)drawMode, (byte)layout, 3};
            byte[] tmp = new byte[16];
            System.arraycopy(data, i * 16, tmp, 0, tmp.length);
            this.smartTagCommand(160, nPackets, packet, cmd, tosend, tmp);
            i += tosend;
            ++packet;
        }
        this.smartTagGetStatus(false, false);
    }

    public void smartTagSaveLayout(int layout) throws IOException, RFIDException {
        byte[] byArray = new byte[8];
        byArray[0] = (byte)layout;
        byte[] cmd = byArray;
        this.smartTagCommand(178, 1, 1, cmd, 0, null);
    }

    public void smartTagDisplayLayout(int layout) throws IOException, RFIDException {
        byte[] byArray = new byte[8];
        byArray[5] = 3;
        byArray[6] = (byte)layout;
        byArray[7] = 1;
        byte[] cmd = byArray;
        this.smartTagCommand(160, 1, 1, cmd, 0, null);
    }

    public void smartTagWrite(int address, byte[] data) throws IOException, RFIDException {
        int length = data.length;
        int nBlocks = (length + 15) / 16;
        int nPackets = (nBlocks + 11 - 1) / 11;
        int i = 0;
        int packet = 1;
        while (i < nBlocks) {
            int toSendLength;
            int tosend = nBlocks - i;
            if (tosend > 11) {
                tosend = 11;
            }
            if ((toSendLength = tosend * 16) > length) {
                toSendLength = length;
            }
            byte[] byArray = new byte[8];
            byArray[0] = (byte)(address >> 8);
            byArray[1] = (byte)address;
            byArray[2] = (byte)(toSendLength >> 8);
            byArray[3] = (byte)toSendLength;
            byte[] cmdWrite = byArray;
            byte[] tmp = new byte[16];
            System.arraycopy(data, i * 16, tmp, 0, tmp.length);
            this.smartTagCommand(176, nPackets, packet, cmdWrite, tosend, tmp);
            i += tosend;
            address += toSendLength;
            length -= toSendLength;
            ++packet;
        }
        this.smartTagGetStatus(false, true);
    }

    public byte[] smartTagRead(int address, int length) throws IOException, RFIDException {
        byte[] data = new byte[length];
        int offset = 0;
        while (length > 0) {
            int toReadBlocks = (length + 15) / 16;
            if (toReadBlocks > 11) {
                toReadBlocks = 11;
            }
            int toReadLength = toReadBlocks * 16;
            byte[] byArray = new byte[8];
            byArray[0] = (byte)(address >> 8);
            byArray[1] = (byte)address;
            byArray[2] = (byte)(toReadLength >> 8);
            byArray[3] = (byte)toReadLength;
            byte[] cmdRead = byArray;
            this.smartTagCommand(192, 1, 1, cmdRead, 0, null);
            byte[] result = this.smartTagReadResponse(toReadBlocks);
            System.arraycopy(result, 0, data, offset, result.length);
            address += toReadLength;
            offset += toReadLength;
            length -= toReadLength;
        }
        return data;
    }
}

