/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.barcode;

public class Barcode {
    public static final int BARCODE_ALL = 0;
    public static final int BARCODE_UPCA = 1;
    public static final int BARCODE_CODABAR = 2;
    public static final int BARCODE_CODE25_NI2OF5 = 3;
    public static final int BARCODE_CODE25_I2OF5 = 4;
    public static final int BARCODE_CODE39 = 5;
    public static final int BARCODE_CODE93 = 6;
    public static final int BARCODE_CODE128 = 7;
    public static final int BARCODE_CODE11 = 8;
    public static final int BARCODE_CPCBINARY = 9;
    public static final int BARCODE_DUN14 = 10;
    public static final int BARCODE_EAN2 = 11;
    public static final int BARCODE_EAN5 = 12;
    public static final int BARCODE_EAN8 = 13;
    public static final int BARCODE_EAN13 = 14;
    public static final int BARCODE_EAN128 = 15;
    public static final int BARCODE_GS1DATABAR = 16;
    public static final int BARCODE_ITF14 = 17;
    public static final int BARCODE_LATENT_IMAGE = 18;
    public static final int BARCODE_PHARMACODE = 19;
    public static final int BARCODE_PLANET = 20;
    public static final int BARCODE_POSTNET = 21;
    public static final int BARCODE_INTELLIGENT_MAIL = 22;
    public static final int BARCODE_MSI_PLESSEY = 23;
    public static final int BARCODE_POSTBAR = 24;
    public static final int BARCODE_RM4SCC = 25;
    public static final int BARCODE_TELEPEN = 26;
    public static final int BARCODE_UK_PLESSEY = 27;
    public static final int BARCODE_PDF417 = 28;
    public static final int BARCODE_MICROPDF417 = 29;
    public static final int BARCODE_DATAMATRIX = 30;
    public static final int BARCODE_AZTEK = 31;
    public static final int BARCODE_QRCODE = 32;
    public static final int BARCODE_MAXICODE = 33;
    public static final int BARCODE_RESERVED1 = 34;
    public static final int BARCODE_RESERVED2 = 35;
    public static final int BARCODE_RESERVED3 = 36;
    public static final int BARCODE_RESERVED4 = 37;
    public static final int BARCODE_RESERVED5 = 38;
    public static final int BARCODE_UPCA_2 = 39;
    public static final int BARCODE_UPCA_5 = 40;
    public static final int BARCODE_UPCE = 41;
    public static final int BARCODE_UPCE_2 = 42;
    public static final int BARCODE_UPCE_5 = 43;
    public static final int BARCODE_EAN13_2 = 44;
    public static final int BARCODE_EAN13_5 = 45;
    public static final int BARCODE_EAN8_2 = 46;
    public static final int BARCODE_EAN8_5 = 47;
    public static final int BARCODE_CODE39_FULL = 48;
    public static final int BARCODE_ITA_PHARMA = 49;
    public static final int BARCODE_CODABAR_ABC = 50;
    public static final int BARCODE_CODABAR_CX = 51;
    public static final int BARCODE_SCODE = 52;
    public static final int BARCODE_MATRIX_2OF5 = 53;
    public static final int BARCODE_IATA = 54;
    public static final int BARCODE_KOREAN_POSTAL = 55;
    public static final int BARCODE_CCA = 56;
    public static final int BARCODE_CCB = 57;
    public static final int BARCODE_CCC = 58;
    public static final int BARCODE_LAST = 59;
    public static final int BARCODE_UNKNOWN = -1;
    private int mType = -1;
    private byte[] mData;
    private boolean mIsOpticonEngine;

    private Barcode(byte[] data, boolean isOpticonEngine) {
        this.mIsOpticonEngine = isOpticonEngine;
        if (data.length >= 3 && data[0] == 93) {
            byte[] typebuf = Barcode.subarray(data, 0, 3);
            byte[] barcode = Barcode.subarray(data, 3, data.length - 3);
            this.mType = Barcode.convertBarcodeType(typebuf, barcode);
            this.mData = barcode;
        } else if (isOpticonEngine && data.length >= 1) {
            this.mType = Barcode.convertOpticonBarcodeType(data[0]);
            this.mData = Barcode.subarray(data, 1, data.length - 1);
        }
    }

    private static byte[] subarray(byte[] buffer, int index, int count) {
        byte[] tmp = new byte[count];
        System.arraycopy(buffer, index, tmp, 0, count);
        return tmp;
    }

    private static int convertOpticonBarcodeType(int type) {
        switch (type) {
            case 67: {
                return 1;
            }
            case 70: {
                return 39;
            }
            case 71: {
                return 40;
            }
            case 68: {
                return 41;
            }
            case 72: {
                return 42;
            }
            case 73: {
                return 43;
            }
            case 66: {
                return 14;
            }
            case 76: {
                return 44;
            }
            case 77: {
                return 45;
            }
            case 65: {
                return 13;
            }
            case 74: {
                return 46;
            }
            case 75: {
                return 47;
            }
            case 86: {
                return 5;
            }
            case 87: {
                return 48;
            }
            case 89: {
                return 49;
            }
            case 82: {
                return 2;
            }
            case 83: {
                return 50;
            }
            case 102: {
                return 51;
            }
            case 79: {
                return 3;
            }
            case 78: {
                return 4;
            }
            case 103: {
                return 52;
            }
            case 81: {
                return 53;
            }
            case 80: {
                return 54;
            }
            case 90: {
                return 23;
            }
            case 100: {
                return 26;
            }
            case 97: {
                return 27;
            }
            case 84: {
                return 7;
            }
            case 85: {
                return 6;
            }
            case 98: {
                return 8;
            }
            case 99: {
                return 55;
            }
            case 121: {
                return 16;
            }
            case 109: {
                return 56;
            }
            case 110: {
                return 57;
            }
            case 108: {
                return 58;
            }
            case 116: {
                return 30;
            }
            case 111: {
                return 31;
            }
            case 117: {
                return 32;
            }
            case 118: {
                return 33;
            }
            case 115: {
                return 29;
            }
            case 114: {
                return 28;
            }
        }
        return -1;
    }

    private static String convertISO15424BarcodeType(int barcodeType) {
        switch (barcodeType) {
            case 1: {
                return "]E0";
            }
            case 2: {
                return "]F0";
            }
            case 3: {
                return "]S0";
            }
            case 4: {
                return "]I0";
            }
            case 5: {
                return "]A0";
            }
            case 6: {
                return "]X0";
            }
            case 7: {
                return "]C0";
            }
            case 8: {
                return "]H0";
            }
            case 9: {
                return "]X0";
            }
            case 10: {
                return "]X0";
            }
            case 11: {
                return "]E3";
            }
            case 12: {
                return "]E3";
            }
            case 13: {
                return "]E4";
            }
            case 14: {
                return "]E0";
            }
            case 15: {
                return "]C0";
            }
            case 16: {
                return "]e0";
            }
            case 17: {
                return "]X0";
            }
            case 18: {
                return "]X0";
            }
            case 19: {
                return "]X0";
            }
            case 20: {
                return "]X0";
            }
            case 21: {
                return "]X0";
            }
            case 22: {
                return "]X0";
            }
            case 23: {
                return "]M0";
            }
            case 24: {
                return "]X0";
            }
            case 25: {
                return "]X0";
            }
            case 26: {
                return "]B0";
            }
            case 27: {
                return "]X0";
            }
            case 28: {
                return "]L0";
            }
            case 29: {
                return "]L0";
            }
            case 30: {
                return "]d0";
            }
            case 31: {
                return "]z0";
            }
            case 32: {
                return "]Q0";
            }
            case 33: {
                return "]U0";
            }
            case 39: {
                return "]E3";
            }
            case 40: {
                return "]E3";
            }
            case 41: {
                return "]E0";
            }
            case 42: {
                return "]E3";
            }
            case 43: {
                return "]E3";
            }
            case 44: {
                return "]E3";
            }
            case 45: {
                return "]E3";
            }
            case 46: {
                return "]E7";
            }
            case 47: {
                return "]E7";
            }
            case 48: {
                return "]A4";
            }
            case 49: {
                return "]X0";
            }
            case 50: {
                return "]F1";
            }
            case 51: {
                return "]F0";
            }
            case 52: {
                return "]X0";
            }
            case 53: {
                return "]X0";
            }
            case 54: {
                return "]X0";
            }
            case 55: {
                return "]X0";
            }
            case 56: {
                return "]e1";
            }
            case 57: {
                return "]e1";
            }
            case 58: {
                return "]e1";
            }
        }
        return "]X0";
    }

    private static int convertBarcodeType(byte[] type, byte[] barcode) {
        byte a = type[1];
        byte b = type[2];
        if (a == 88 && b == 52) {
            return 14;
        }
        if (a == 69 && (b == 48 || b == 51)) {
            if (barcode.length == 13 && barcode[0] != 48) {
                return 14;
            }
            return 1;
        }
        if (a == 69 && b == 52) {
            return 13;
        }
        if (a == 69 && b == 55) {
            return 13;
        }
        if (a == 65) {
            return 5;
        }
        if (a == 70) {
            return 2;
        }
        if (a == 83 && b == 48) {
            return 3;
        }
        if (a == 73) {
            return 4;
        }
        if (a == 77) {
            return 23;
        }
        if (a == 88 && b == 48) {
            return 23;
        }
        if (a == 66) {
            return 26;
        }
        if (a == 67 && b == 48) {
            return 7;
        }
        if (a == 67 && b == 49) {
            return 15;
        }
        if (a == 71 && b == 48) {
            return 6;
        }
        if (a == 72) {
            return 8;
        }
        if (a == 101 && b == 48) {
            return 16;
        }
        if (a == 100) {
            return 30;
        }
        if (a == 122) {
            return 31;
        }
        if (a == 81) {
            return 32;
        }
        if (a == 76 && (b == 48 || b == 50)) {
            return 28;
        }
        if (a == 76 && (b == 48 || b == 51)) {
            return 29;
        }
        return -1;
    }

    public static final Barcode parse(byte[] input) {
        return new Barcode(input, true);
    }

    public int getType() {
        return this.mType;
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return "ALL";
            }
            case 1: {
                return "UPCA";
            }
            case 2: {
                return "CODABAR";
            }
            case 3: {
                return "CODE25 NI2OF5";
            }
            case 4: {
                return "CODE25 I2OF5";
            }
            case 5: {
                return "CODE39";
            }
            case 6: {
                return "CODE93";
            }
            case 7: {
                return "CODE128";
            }
            case 8: {
                return "CODE11";
            }
            case 9: {
                return "CPCBINARY";
            }
            case 10: {
                return "DUN14";
            }
            case 11: {
                return "EAN2";
            }
            case 12: {
                return "EAN5";
            }
            case 13: {
                return "EAN8";
            }
            case 14: {
                return "EAN13";
            }
            case 15: {
                return "EAN128";
            }
            case 16: {
                return "GS1 DATABAR";
            }
            case 17: {
                return "ITF14";
            }
            case 18: {
                return "LATENT IMAGE";
            }
            case 19: {
                return "PHARMACODE";
            }
            case 20: {
                return "PLANET";
            }
            case 21: {
                return "POSTNET";
            }
            case 22: {
                return "INTELLIGENT MAIL";
            }
            case 23: {
                return "MSI PLESSEY";
            }
            case 24: {
                return "POSTBAR";
            }
            case 25: {
                return "RM4SCC";
            }
            case 26: {
                return "TELEPEN";
            }
            case 27: {
                return "UK PLESSEY";
            }
            case 28: {
                return "PDF417";
            }
            case 29: {
                return "MICROPDF417";
            }
            case 30: {
                return "DATAMATRIX";
            }
            case 31: {
                return "AZTEK";
            }
            case 32: {
                return "QRCODE";
            }
            case 33: {
                return "MAXICODE";
            }
            case 34: {
                return "RESERVED 1";
            }
            case 35: {
                return "RESERVED 2";
            }
            case 36: {
                return "RESERVED 3";
            }
            case 37: {
                return "RESERVED 4";
            }
            case 38: {
                return "RESERVED 5";
            }
            case 39: {
                return "UPCA 2";
            }
            case 40: {
                return "UPCA 5";
            }
            case 41: {
                return "UPCE";
            }
            case 42: {
                return "UPCE 2";
            }
            case 43: {
                return "UPCE 5";
            }
            case 44: {
                return "EAN13 2";
            }
            case 45: {
                return "EAN13 5";
            }
            case 46: {
                return "EAN8 2";
            }
            case 47: {
                return "EAN8 5";
            }
            case 48: {
                return "CODE39 FULL";
            }
            case 49: {
                return "ITA PHARMA";
            }
            case 50: {
                return "CODABAR ABC";
            }
            case 51: {
                return "CODABAR CX";
            }
            case 52: {
                return "SCODE";
            }
            case 53: {
                return "MATRIX 2OF5";
            }
            case 54: {
                return "IATA";
            }
            case 55: {
                return "KOREAN POSTAL";
            }
            case 56: {
                return "CCA";
            }
            case 57: {
                return "CCB";
            }
            case 58: {
                return "CCC";
            }
            case 59: {
                return "LAST";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return "UNSPECIFIED";
    }

    public String getISO15424() {
        return Barcode.convertISO15424BarcodeType(this.mType);
    }

    public byte[] getData() {
        return this.mData;
    }

    public String getDataString() {
        byte[] data = this.getData();
        return new String(data, 0, data.length);
    }

    public boolean isOpticonEngine() {
        return this.mIsOpticonEngine;
    }

    public String toString() {
        return "Barcode [Type=" + this.getTypeString() + "(" + this.getType() + ")" + ",Data=" + this.getDataString() + "]";
    }
}

