/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.rfid;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class RFID {
    private static final boolean _D = true;
    public static final int CARD_SUPPORT_TYPE_A = 1;
    public static final int CARD_SUPPORT_TYPE_B = 2;
    public static final int CARD_SUPPORT_FELICA = 4;
    public static final int CARD_SUPPORT_NFC = 8;
    public static final int CARD_SUPPORT_JEWEL = 16;
    public static final int CARD_SUPPORT_ISO15 = 32;
    public static final int CARD_SUPPORT_STSRI = 64;
    private InputStream mInputStream;
    private OutputStream mOutputStream;
    private boolean mActive;
    private String mLastError;

    RFID(InputStream in, OutputStream out) {
        if (in == null) {
            throw new IllegalArgumentException("The argument 'in' is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("The argument 'out' is null");
        }
        this.mInputStream = in;
        this.mOutputStream = out;
        this.mActive = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        RFID.this.recvDataProc();
                    }
                    catch (Exception e) {
                        if (!RFID.this.mActive) break block2;
                        e.printStackTrace();
                        RFID.this.mLastError = e.getMessage();
                    }
                }
            }
        }).start();
    }

    private static final void log(String text, byte[] b, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        int i = 0;
        while (i < length) {
            buf[offs++] = hex[b[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[b[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
            ++i;
        }
        System.out.println(String.valueOf(text) + new String(buf, 0, offs) + "(" + length + ")");
    }

    private void recvDataProc() throws IOException {
        byte[] buffer = new byte[2048];
        while (this.mActive) {
            int res = this.mInputStream.read(buffer);
            if (res < 0) {
                throw new IOException("The end of the stream has been reached");
            }
            if (res > 0) {
                RFID.log("<RFID> recv: ", buffer, 0, res);
                this.onDataReceived(buffer, res);
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract void onDataReceived(byte[] var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBlock(byte[] b, int offset, int length) throws IOException {
        OutputStream outputStream = this.mOutputStream;
        synchronized (outputStream) {
            this.mOutputStream.write(b, offset, length);
            RFID.log("<RFID> send: ", b, offset, length);
        }
    }

    public String getLastError() {
        return this.mLastError;
    }

    public void close() {
        this.mActive = false;
        try {
            this.mInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

