/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.universalreader;

import com.datecs.api.smartcard.AnswerToReset;
import com.datecs.api.smartcard.ResponseAPDU;
import com.datecs.api.universalreader.TouchEvent;
import com.datecs.api.universalreader.UniversalReaderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class UniversalReader {
    private static final int PACKET_HEADER_SIZE = 4;
    private static final int PACKET_MAX_SIZE = 2048;
    private static final int IO_TIME = 5000;
    private static final int BARCODE_IO_TIME = 6000;
    private static final int STATUS_ERROR = 1;
    private static final int STATUS_PRESSED = 2;
    private static final int STATUS_AUTO = 4;
    private static final int STATUS_MULTIFRAME = 8;
    private static final int COMMAND_IDENTIFICATION = 1;
    private static final int COMMAND_POWER = 2;
    private static final int COMMAND_SMARTCARD_AVAILABLE = 3;
    private static final int COMMAND_GET_STATUS = 5;
    private static final int COMMAND_SMARTCARD_SELECT = 6;
    private static final int COMMAND_SMARTCARD_RESET = 16;
    private static final int COMMAND_SMARTCARD_APDU_OUT = 17;
    private static final int COMMAND_SMARTCARD_APDU_IN = 18;
    private static final int COMMAND_SMARTCARD_C_APDU = 19;
    private static final int COMMAND_BARCODE_READ = 33;
    private static final int COMMAND_TOUCHSCREEN_GETCOORDS = 49;
    private static final int COMMAND_MIFARE = 57;
    private static final int COMMAND_CAPABILITIES = 254;
    public static final int ERROR_0K = 0;
    public static final int ERROR_INVALID = 1;
    public static final int ERROR_NOTPERMITTED = 2;
    public static final int ERROR_CARD = 3;
    public static final int ERROR_SYNTAX = 4;
    public static final int ERROR_NORESPONCE = 5;
    public static final int ERROR_NODATA = 6;
    public static final int ERROR_BARCODE = 16;
    public static final int ERROR_BARCODE_NODATA = 17;
    public static final int ERROR_BARCODE_INVALID = 18;
    public static final int ERROR_BARCODE_NOTPRESENT = 19;
    public static final int ERROR_MIFARE_TIMEOUT = -1;
    public static final int ERROR_MIFARE_COLLISION = -2;
    public static final int ERROR_MIFARE_PARITY = -3;
    public static final int ERROR_MIFARE_FRAME = -4;
    public static final int ERROR_MIFARE_CRC = -5;
    public static final int ERROR_MIFARE_FIFO = -6;
    public static final int ERROR_MIFARE_EEPROM = -7;
    public static final int ERROR_MIFARE_KEY = -8;
    public static final int ERROR_MIFARE_GENERIC = -9;
    public static final int ERROR_MIFARE_AUTHENTICATION = -10;
    public static final int ERROR_MIFARE_CODE = -11;
    public static final int ERROR_MIFARE_BIT = -12;
    public static final int ERROR_MIFARE_ACCESS = -13;
    public static final int ERROR_MIFARE_VALUE = -14;
    public static final int CAPABILITY_DEBUG = 1;
    public static final int CAPABILITY_SMARTCARD = 2;
    public static final int CAPABILITY_BARCODE = 4;
    public static final int CAPABILITY_TOUCHSCREEN = 8;
    public static final int CAPABILITY_GSM = 16;
    public static final int CAPABILITY_MIFARE = 32;
    public static final int CAPABILITY_BUTTON = 64;
    public static final int CAPABILITY_LCD2X16 = 128;
    public static final int CAPABILITY_FIRMWARE = 256;
    public static final int CAPABILITY_MAGNETIC = 512;
    public static final int CAPABILITY_EV15 = 1024;
    public static final int BUTTON_MODE_NONE = 0;
    public static final int BUTTON_MODE_BARCODE = 1;
    public static final int BUTTON_MODE_STATUS = 2;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private IOException mLastError;
    private byte[] mDataBuffer;
    private int mDataBufferLength;
    private BarcodeListener mBarcodeListener;
    private CardListener mCardListener;
    private ButtonListener mButtonListener;
    private ConnectionListener mConnListener;
    private int mLastStatusByte1;
    private int mLastStatusByte2;
    private static boolean sDebug = false;

    public UniversalReader(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("The in is null.");
        }
        this.mBaseInputStream = in;
        if (out == null) {
            throw new NullPointerException("The out is null.");
        }
        this.mBaseOutputStream = out;
        this.mDataBuffer = new byte[16384];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                UniversalReader.this.readDataThreadProc();
            }
        });
        t.start();
    }

    public synchronized void close() {
        this.mLastError = new IOException("The object is closed");
        try {
            if (this.mBaseInputStream != null) {
                this.mBaseInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mBaseOutputStream != null) {
                this.mBaseOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        int i = 0;
        while (i < length) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
            ++i;
        }
        return new String(buf, 0, offs);
    }

    private void debug(String text) {
        if (sDebug) {
            System.out.println(text);
        }
    }

    private void debug(String text, byte[] buffer, int offset, int count) {
        if (sDebug) {
            this.debug(String.valueOf(text) + UniversalReader.byteArrayToHexString(buffer, offset, count) + "(" + count + ")");
        }
    }

    private void write(byte[] b, int offset, int length) throws IOException {
        this.mBaseOutputStream.write(b, offset, length);
        this.mBaseOutputStream.flush();
        this.debug("<UniversalReader> >> ", b, offset, length);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.mBaseInputStream.read(buffer, offset, length);
        if (bytesRead == -1) {
            throw new IOException("The end of the stream is reached");
        }
        if (bytesRead > 0) {
            this.debug("<UniversalReader> << ", buffer, offset, bytesRead);
        }
        return bytesRead;
    }

    private void raiseReadBarcode(final int type, final byte[] barcode) {
        final BarcodeListener l = this.mBarcodeListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onReadBarcode(type, barcode);
                }
            }).start();
        }
    }

    private void raiseReadCard(final boolean encrypted) {
        final CardListener l = this.mCardListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onReadCard(encrypted);
                }
            }).start();
        }
    }

    private void raiseButtonStateChanged(final boolean state) {
        final ButtonListener l = this.mButtonListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.OnButtonStateChanged(state);
                }
            }).start();
        }
    }

    private void raiseDisconnect() {
        final ConnectionListener l = this.mConnListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onDisconnect();
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readDataThreadProc() {
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        try {
            try {
                while (true) {
                    int dataLength22;
                    int packetLength;
                    if (this.mLastError != null) {
                        return;
                    }
                    bytesRead += this.read(buffer, bytesRead, buffer.length - bytesRead);
                    while (bytesRead >= 4 && bytesRead >= (packetLength = 4 + (dataLength22 = (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF))) {
                        if ((buffer[0] & 4) != 0) {
                            this.processEvent(buffer, packetLength);
                        } else {
                            byte[] byArray = this.mDataBuffer;
                            // MONITORENTER : this.mDataBuffer
                            if (this.mDataBufferLength + packetLength > this.mDataBuffer.length) {
                                this.mDataBufferLength = 0;
                            }
                            System.arraycopy(buffer, 0, this.mDataBuffer, this.mDataBufferLength, packetLength);
                            this.mDataBufferLength += packetLength;
                            // MONITOREXIT : byArray
                        }
                        System.arraycopy(buffer, packetLength, buffer, 0, bytesRead -= packetLength);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException dataLength22) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                if (this.mLastError == null) {
                    this.mLastError = e;
                }
                this.raiseDisconnect();
                return;
            }
        }
        finally {
            this.raiseDisconnect();
        }
    }

    private void processEvent(byte[] buffer, int length) {
        int sb1 = buffer[0] & 0xFF;
        int sb2 = buffer[1] & 0xFF;
        switch (sb2) {
            case 0: {
                if (length > 4) {
                    int type = buffer[4] & 0xFF;
                    byte[] barcode = new byte[length - 4 - 1];
                    System.arraycopy(buffer, 5, barcode, 0, barcode.length);
                    this.raiseReadBarcode(type, barcode);
                    break;
                }
                this.raiseButtonStateChanged((sb1 & 2) != 0);
                break;
            }
            case 130: {
                this.raiseReadCard(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        byte[] byArray = this.mDataBuffer;
        synchronized (this.mDataBuffer) {
            this.mDataBufferLength = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void request(int command, byte[] data) throws IOException {
        byte[] buffer = new byte[4 + data.length];
        if (data.length > 2044) {
            throw new IllegalArgumentException("Invalid packet size");
        }
        buffer[0] = (byte)command;
        buffer[1] = 0;
        buffer[2] = (byte)(data.length >> 8);
        buffer[3] = (byte)data.length;
        System.arraycopy(data, 0, buffer, 4, data.length);
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private byte[] response(int timeout) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
        long expireAt = System.currentTimeMillis() + (long)timeout;
        while (true) {
            if (this.mDataBufferLength > 0) {
                byte[] byArray = this.mDataBuffer;
                // MONITORENTER : this.mDataBuffer
                this.mLastStatusByte1 = this.mDataBuffer[0] & 0xFF;
                this.mLastStatusByte2 = this.mDataBuffer[1] & 0xFF;
                int dataLength = (this.mDataBuffer[2] & 0xFF) << 8 | this.mDataBuffer[3] & 0xFF;
                int packetLength = 4 + dataLength;
                buffer.write(this.mDataBuffer, 4, dataLength);
                this.mDataBufferLength -= packetLength;
                System.arraycopy(this.mDataBuffer, packetLength, this.mDataBuffer, 0, this.mDataBufferLength);
                if ((this.mLastStatusByte1 & 8) == 0) {
                    // MONITOREXIT : byArray
                    return buffer.toByteArray();
                }
                // MONITOREXIT : byArray
            }
            if (expireAt < System.currentTimeMillis()) {
                throw new IOException("Timeout");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized byte[] executeCmd(int command, byte[] data, int timeout) throws IOException, UniversalReaderException {
        byte[] response = null;
        this.clear();
        this.request(command, data);
        response = this.response(timeout);
        if ((this.mLastStatusByte1 & 1) != 0) {
            throw new UniversalReaderException(this.mLastStatusByte2);
        }
        return response;
    }

    private synchronized byte[] executeCmd(int command, byte[] data) throws IOException, UniversalReaderException {
        return this.executeCmd(command, data, 5000);
    }

    private synchronized byte[] executeCmd(int command) throws IOException, UniversalReaderException {
        return this.executeCmd(command, new byte[0]);
    }

    public void setBarcodeListener(BarcodeListener listener) {
        this.mBarcodeListener = listener;
    }

    public void setCardListener(CardListener listener) {
        this.mCardListener = listener;
    }

    public void setButtonListener(ButtonListener listener) {
        this.mButtonListener = listener;
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.mConnListener = listener;
    }

    public void enableMagneticCardReader(boolean enable) throws IOException, UniversalReaderException {
        this.executeCmd(73, new byte[]{1, enable ? (byte)1 : 0});
    }

    public void enableMagneticCardReaderEvents(boolean enable) throws IOException, UniversalReaderException {
        this.executeCmd(73, new byte[]{5, enable ? (byte)1 : 0});
    }

    public void setButton(int mode) throws IOException, UniversalReaderException {
        this.executeCmd(2, new byte[]{8, (byte)mode});
    }

    public byte[] readTrackData(int track) throws IOException, UniversalReaderException {
        return this.executeCmd(73, new byte[]{3, (byte)track});
    }

    public String getIdentification() throws IOException, UniversalReaderException {
        byte[] buf = this.executeCmd(1);
        return new String(buf, 0, buf.length - 2);
    }

    public boolean isButtonPressed() throws IOException, UniversalReaderException {
        return this.isButtonPressed(true);
    }

    public boolean isButtonPressed(boolean update) throws IOException, UniversalReaderException {
        if (update) {
            this.executeCmd(5);
        }
        return (this.mLastStatusByte1 & 2) != 0;
    }

    public void turnOff() throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{3};
        this.executeCmd(2, buf);
    }

    public void setAutoOff(int time) throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{4, (byte)(time >> 8), (byte)time};
        this.executeCmd(2, buf);
    }

    public void playSound(int frequency, int duration) throws IOException, UniversalReaderException {
        byte[] byArray = new byte[6];
        byArray[0] = 9;
        byArray[2] = (byte)(frequency >> 8);
        byArray[3] = (byte)frequency;
        byArray[4] = (byte)(duration >> 8);
        byArray[5] = (byte)duration;
        byte[] buf = byArray;
        this.executeCmd(2, buf);
    }

    public void displayText(String first, String second) throws IOException, UniversalReaderException {
        byte[] bufFirst = first.getBytes();
        byte[] bufSecond = second.getBytes();
        byte[] buf = new byte[33];
        buf[0] = 10;
        int i = 0;
        while (i < 16 && i < bufFirst.length) {
            buf[1 + i] = bufFirst[i];
            ++i;
        }
        i = 0;
        while (i < 16 && i < bufSecond.length) {
            buf[17 + i] = bufSecond[i];
            ++i;
        }
        this.executeCmd(2, buf);
    }

    public String getSerialNumber() throws IOException, UniversalReaderException {
        byte[] buf = new byte[]{12};
        buf = this.executeCmd(2, buf);
        StringBuffer sb = new StringBuffer(16);
        int i = 0;
        while (i < buf.length && buf[i] != 0) {
            sb.append((char)buf[i]);
            ++i;
        }
        return sb.toString();
    }

    public int getCapabilities() throws IOException, UniversalReaderException {
        byte[] buf = this.executeCmd(254, new byte[0]);
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public BarcodeReader getBarcodeReader() {
        return new BarcodeReader();
    }

    public SmartCardReader getSmartCardReader() {
        return new SmartCardReader();
    }

    public TouchScreen getTouchScreen() {
        return new TouchScreen();
    }

    public MifareReader getMifareReader() {
        return new MifareReader();
    }

    public static interface BarcodeListener {
        public void onReadBarcode(int var1, byte[] var2);
    }

    public final class BarcodeReader {
        private BarcodeReader() {
        }

        public String read() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(33, new byte[0], 6000);
            return new String(buf);
        }
    }

    public static interface ButtonListener {
        public void OnButtonStateChanged(boolean var1);
    }

    public static interface CardListener {
        public void onReadCard(boolean var1);
    }

    public static interface ConnectionListener {
        public void onDisconnect();
    }

    public final class MifareReader {
        private MifareReader() {
        }

        public void setPower(boolean on) throws IOException, UniversalReaderException {
            byte[] buf;
            if (on) {
                byte[] byArray = new byte[2];
                byArray[1] = 1;
                buf = byArray;
            } else {
                buf = new byte[2];
            }
            UniversalReader.this.executeCmd(57, buf);
        }

        private void checkMifareStatus(byte status) throws UniversalReaderException {
            if (status != 0) {
                throw new UniversalReaderException(status);
            }
        }

        public void config() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{1};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public int request(boolean all) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{2, (byte)(all ? 1 : 0)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 8) + (buf[2] & 0xFF);
        }

        public int anticollision() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{3};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 8) + (buf[4] & 0xFF);
        }

        public int select(int sn) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{4, (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return buf[1] & 0xFF;
        }

        public void authenticate(int sn, int block, int type, byte[] key) throws IOException, UniversalReaderException {
            if (key == null) {
                throw new NullPointerException("The key is null");
            }
            if (key.length != 6) {
                throw new IllegalArgumentException("The key.length is invalid");
            }
            byte[] buf = new byte[]{5, key[0], key[1], key[2], key[3], key[4], key[5], (byte)(type & 0xFF), (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF), (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public byte[] read(int block) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{6, (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            byte[] tbuf = new byte[buf.length - 1];
            System.arraycopy(buf, 1, tbuf, 0, tbuf.length);
            return tbuf;
        }

        public void write(int block, byte[] data) throws IOException, UniversalReaderException {
            if (data == null) {
                throw new NullPointerException("The data is null");
            }
            if (data.length != 16) {
                throw new IllegalArgumentException("The data.length is invalid");
            }
            byte[] buf = new byte[17];
            buf[0] = 7;
            System.arraycopy(data, 0, buf, 1, data.length);
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void increment(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -63, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void decrement(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -64, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void restore(int src, int dst, int value) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{8, -62, (byte)(src & 0xFF), (byte)(value >> 24), (byte)value, (byte)(value >> 8), (byte)(value & 0xFF), (byte)(dst & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void halt() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{9};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public int getSerialNumber() throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{10};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            return ((buf[1] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 8) + (buf[4] & 0xFF);
        }

        public void writeEeprom(int address, byte[] data) throws IOException, UniversalReaderException {
            if (data == null) {
                throw new NullPointerException("The data is null");
            }
            if (data.length < 1 || data.length > 255) {
                throw new IllegalArgumentException("The data.length is invalid");
            }
            byte[] buf = new byte[3 + data.length];
            buf[0] = 11;
            buf[1] = (byte)(address >> 8);
            buf[2] = (byte)(address & 0xFF);
            System.arraycopy(data, 0, buf, 3, data.length);
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void write(int block, int data) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{12, (byte)(block & 0xFF), (byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)(data & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void loadKey(int selector, byte[] key) throws IOException, UniversalReaderException {
            if (key == null) {
                throw new NullPointerException("The key is null");
            }
            if (key.length != 6) {
                throw new IllegalArgumentException("The key.length is invalid");
            }
            byte[] buf = new byte[]{13, (byte)(selector & 0xFF), key[0], key[1], key[2], key[3], key[4], key[5]};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public void authenticate(int sn, int block, int type, int selector) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{14, (byte)(type & 0xFF), (byte)(sn >> 24), (byte)(sn >> 16), (byte)(sn >> 8), (byte)(sn & 0xFF), (byte)(selector & 0xFF), (byte)(block & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
        }

        public byte[] readEeprom(int address, int length) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{15, (byte)(address >> 8), (byte)(address & 0xFF), (byte)(length & 0xFF)};
            buf = UniversalReader.this.executeCmd(57, buf);
            this.checkMifareStatus(buf[0]);
            byte[] tbuf = new byte[buf.length - 1];
            System.arraycopy(buf, 1, tbuf, 0, tbuf.length);
            return tbuf;
        }
    }

    public final class SmartCardReader {
        private SmartCardReader() {
        }

        public void setPower(boolean on) throws IOException, UniversalReaderException {
            byte[] buf = null;
            buf = on ? new byte[]{1} : new byte[1];
            UniversalReader.this.executeCmd(2, buf);
        }

        public AnswerToReset reset() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(16);
            return new AnswerToReset(buf);
        }

        public ResponseAPDU write(int cla, int ins, int p1, int p2, byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            int datalen = 0;
            datalen = data != null ? data.length : 0;
            buf = new byte[5 + datalen];
            buf[0] = (byte)(cla & 0xFF);
            buf[1] = (byte)(ins & 0xFF);
            buf[2] = (byte)(p1 & 0xFF);
            buf[3] = (byte)(p2 & 0xFF);
            buf[4] = (byte)(datalen & 0xFF);
            if (datalen > 0) {
                int i = 0;
                while (i < datalen) {
                    buf[i + 5] = data[i];
                    ++i;
                }
            }
            buf = UniversalReader.this.executeCmd(17, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU write(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(17, data);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU read(int cla, int ins, int p1, int p2, int lc) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{(byte)(cla & 0xFF), (byte)(ins & 0xFF), (byte)(p1 & 0xFF), (byte)(p2 & 0xFF), (byte)(lc & 0xFF)};
            buf = UniversalReader.this.executeCmd(18, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU read(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(18, data);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU transmit(int cla, int ins, int p1, int p2, byte[] data) throws IOException, UniversalReaderException {
            int datalen = data != null ? data.length : -1;
            byte[] buf = new byte[5 + datalen];
            buf[0] = (byte)(cla & 0xFF);
            buf[1] = (byte)(ins & 0xFF);
            buf[2] = (byte)(p1 & 0xFF);
            buf[3] = (byte)(p2 & 0xFF);
            if (datalen > -1) {
                buf[4] = (byte)(datalen & 0xFF);
                int i = 0;
                while (i < datalen) {
                    buf[i + 5] = data[i];
                    ++i;
                }
            }
            buf = UniversalReader.this.executeCmd(19, buf);
            return new ResponseAPDU(buf);
        }

        public ResponseAPDU transmit(byte[] data) throws IOException, UniversalReaderException {
            byte[] buf = null;
            if (data == null) {
                throw new NullPointerException("The data is null.");
            }
            buf = UniversalReader.this.executeCmd(19, data);
            return new ResponseAPDU(buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ResponseAPDU> transmit(List<byte[]> data) throws IOException, UniversalReaderException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
            ArrayList<ResponseAPDU> result = new ArrayList<ResponseAPDU>(data.size());
            int itemCount = 0;
            SmartCardReader smartCardReader = this;
            synchronized (smartCardReader) {
                UniversalReader.this.clear();
                for (byte[] tmp : data) {
                    buffer.write(19);
                    buffer.write(0);
                    buffer.write(tmp.length >> 8);
                    buffer.write(tmp.length);
                    buffer.write(tmp);
                    ++itemCount;
                }
                byte[] output = buffer.toByteArray();
                UniversalReader.this.write(output, 0, output.length);
                int n = 0;
                while (n < itemCount) {
                    byte[] tmp = UniversalReader.this.response(5000);
                    if ((UniversalReader.this.mLastStatusByte1 & 1) != 0) {
                        throw new UniversalReaderException(UniversalReader.this.mLastStatusByte2);
                    }
                    ResponseAPDU response = new ResponseAPDU(tmp);
                    result.add(response);
                    ++n;
                }
            }
            return result;
        }

        public boolean isCardPresent() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(3);
            return buf[0] != 0;
        }

        public void select(int slot) throws IOException, UniversalReaderException {
            byte[] buf = new byte[]{(byte)(slot & 0xFF)};
            UniversalReader.this.executeCmd(6, buf);
        }
    }

    public final class TouchScreen {
        private TouchScreen() {
        }

        public TouchEvent[] getEvents() throws IOException, UniversalReaderException {
            byte[] buf = UniversalReader.this.executeCmd(49);
            if (buf.length == 0) {
                return null;
            }
            return TouchEvent.obtainArray(buf);
        }
    }
}

