/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.universalreader;

import java.io.IOException;

public final class UniversalReaderException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int mErrorCode;

    public UniversalReaderException() {
        this.mErrorCode = 0;
    }

    public UniversalReaderException(String message) {
        super(message);
        this.mErrorCode = 0;
    }

    public UniversalReaderException(int errorCode) {
        super(UniversalReaderException.getDescription(errorCode));
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    private static String getDescription(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "Operation sucessful";
            }
            case 1: {
                return "Invalid command code";
            }
            case 2: {
                return "Command not permitted";
            }
            case 3: {
                return "Card error";
            }
            case 4: {
                return "Syntax error";
            }
            case 5: {
                return "No response from device";
            }
            case 6: {
                return "No data available";
            }
            case 16: {
                return "Barcode reader communication error";
            }
            case 17: {
                return "No barcode read";
            }
            case 18: {
                return "Barcode reader invalid command";
            }
            case 19: {
                return "Barcode reader not present";
            }
            case -1: {
                return "Mifare timeout error";
            }
            case -2: {
                return "Mifare collision error";
            }
            case -3: {
                return "Mifare parity error";
            }
            case -4: {
                return "Mifare frame error";
            }
            case -5: {
                return "Mifare CRC error";
            }
            case -6: {
                return "Mifare FIFO overflow";
            }
            case -7: {
                return "Mifare EEPROM error";
            }
            case -8: {
                return "Mifare invalid key";
            }
            case -9: {
                return "Mifare generic error";
            }
            case -10: {
                return "Mifare authentication error";
            }
            case -11: {
                return "Mifare code error";
            }
            case -12: {
                return "Mifare bit count error";
            }
            case -13: {
                return "Mifare access error";
            }
            case -14: {
                return "Mifare value error";
            }
        }
        return "Unspecify error code " + errorCode;
    }
}

