/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.api.rfid;

import com.datecs.api.rfid.RC663;
import com.datecs.api.rfid.RFID;
import java.io.IOException;

public abstract class ContactlessCard {
    public static final int CARD_UNKNOWN = 0;
    public static final int CARD_MIFARE_MINI = 1;
    public static final int CARD_MIFARE_CLASSIC_1K = 2;
    public static final int CARD_MIFARE_CLASSIC_4K = 3;
    public static final int CARD_MIFARE_ULTRALIGHT = 4;
    public static final int CARD_MIFARE_ULTRALIGHT_C = 5;
    public static final int CARD_ISO14443A = 6;
    public static final int CARD_MIFARE_PLUS = 7;
    public static final int CARD_ISO15693 = 8;
    public static final int CARD_MIFARE_DESFIRE = 9;
    public static final int CARD_ISO14443B = 10;
    public static final int CARD_FELICA = 11;
    public static final int CARD_ST_SRI = 12;
    public static final int CARD_PAYMENT = 13;
    public static final int CARD_PICOPASS_15693 = 14;
    public static final int CARD_PICOPASS_14443B = 15;
    public boolean hyatt64Card;
    public int channel;
    public int type;
    public byte[] uid;
    public int capacity;
    public short atqa;
    public short sak;
    public byte afi;
    public byte dsfid;
    public int blockSize;
    public int maxBlocks;
    protected RC663 mModule;

    public ContactlessCard(RC663 module) {
        this.mModule = module;
    }

    protected abstract boolean initialize() throws IOException;

    protected abstract boolean deinitialize() throws IOException;

    public void waitRemove() throws IOException {
        this.deinitialize();
        this.mModule.resume();
    }

    public RFID getModule() {
        return this.mModule;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Mifare Mini";
            }
            case 2: {
                return "Mifare Classic 1K";
            }
            case 3: {
                return "Mifare Classic 4K";
            }
            case 4: {
                return "Mifare Ultralight";
            }
            case 5: {
                return "Mifare Ultralight C";
            }
            case 6: {
                return "ISO 14443A";
            }
            case 7: {
                return "Mifare Plus";
            }
            case 8: {
                return "ISO 15693";
            }
            case 9: {
                return "Mifare Desfire";
            }
            case 10: {
                return "ISO 14443B";
            }
            case 11: {
                return "FeliCa";
            }
            case 12: {
                return "ST SRI";
            }
        }
        return "Unknown";
    }
}

