package com.datecs.lineaprodemo; 

import com.datecs.api.linea.LineaPro.BatteryInfo;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;

public class MainFragment extends Fragment {

    private ActionHandler mActionHandler;
    
    private ScrollView mLogScroll;
    
    private TextView mLogView;
    
    private ImageView mBatteryIconView;
    
    private ImageView mChargingIconView;
    
    private TextView mBatteryInfoView;
    
    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        
        Log.d("LineaProDemo", "Attach to main fragment");
        
        // This makes sure that the container activity has implemented
        // the callback interface. If not, it throws an exception
        try {
            mActionHandler = (ActionHandler) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement ActionListener");
        }
    }   
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        Log.d("LineaProDemo", "Create main fragment");
    }
       
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
        Bundle savedInstanceState) {
        
        Log.d("LineaProDemo", "Create main fragment view");
        
        View contentView = inflater.inflate(R.layout.fragment_main, container, false);
        
        mLogScroll = (ScrollView) contentView.findViewById(R.id.scroll_log);
        
        mLogView = (TextView) contentView.findViewById(R.id.txt_log);
        
        mBatteryIconView = (ImageView) contentView.findViewById(R.id.battery);      
        
        mChargingIconView = (ImageView) contentView.findViewById(R.id.charging);      
        
        mBatteryInfoView = (TextView) contentView.findViewById(R.id.battery_text);
        
        contentView.findViewById(R.id.btn_scan).setOnTouchListener(new View.OnTouchListener() { 
            @SuppressLint("ClickableViewAccessibility")
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case MotionEvent.ACTION_DOWN: {
                        mActionHandler.startScan();
                        break;
                    }
                    case MotionEvent.ACTION_UP: {
                        mActionHandler.stopScan();
                        break;
                    }
                }
                
                return false;
            }
        });
        
        contentView.findViewById(R.id.battery_info).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mActionHandler.readBatteryInfo();
            }
        });
        
        contentView.findViewById(R.id.btn_read_card).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mActionHandler.readCard();
            }
        });
        
        contentView.findViewById(R.id.btn_read_info).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mActionHandler.readInfo();
            }
        });
        
        contentView.findViewById(R.id.btn_settings).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mActionHandler.showSettings();   
            }
        });
        
        return contentView;
    }

    public void addLog(String text, int color, boolean bold) {
        int start = mLogView.getText().length();
        mLogView.append(text);
        
        int end = mLogView.getText().length();
        Spannable spannableText = (Spannable) mLogView.getText();
        spannableText.setSpan(new ForegroundColorSpan(color), start, end, 0);
        if (bold) {
            spannableText.setSpan(new StyleSpan(android.graphics.Typeface.BOLD), start,
                    end, 0);
        }
        
        mLogScroll.post(new Runnable() {
            @Override
            public void run() {
                mLogScroll.fullScroll(View.FOCUS_DOWN);
            }
        });
    }
    
    public void clearLog() {
        mLogView.setText("");
    }
    
    public void setBattery(BatteryInfo batteryInfo) {
        int capacity = batteryInfo.getCapacity();
        
        if (capacity <= 15) {
            mBatteryIconView.setImageResource(R.drawable.battery1);
        } else if (capacity <= 30) {
            mBatteryIconView.setImageResource(R.drawable.battery2);
        } else if (capacity <= 45) {
            mBatteryIconView.setImageResource(R.drawable.battery3);
        } else if (capacity <= 60) {
            mBatteryIconView.setImageResource(R.drawable.battery4);
        } else if (capacity <= 75) {
            mBatteryIconView.setImageResource(R.drawable.battery5);
        } else {
            mBatteryIconView.setImageResource(R.drawable.battery6); 
        }
        
        StringBuffer sb = new StringBuffer();
        sb.append("" + batteryInfo.getVoltage() + "mV\n");
        sb.append("" + batteryInfo.getInitialCapacity() + "mAh\n");
        sb.append("SoC: " + batteryInfo.getCapacity() + "%\n");
        sb.append("SoH: " + batteryInfo.getHealthLevel() + "%");        
        
        if (batteryInfo.isCharging()) {
            mChargingIconView.setVisibility(View.VISIBLE);
        } else {
            mChargingIconView.setVisibility(View.INVISIBLE);
        }
        
        mBatteryInfoView.setText(sb.toString());
    }
    
    public String getLog() {
        return mLogView.getText().toString();
    }
}
