package com.datecs.lineaprodemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.Preference.OnPreferenceClickListener;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;

public class SettingsFragment extends PreferenceFragment implements OnSharedPreferenceChangeListener {
        
    private ActionHandler mActionHandler;  
        
    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        
        // This makes sure that the container activity has implemented
        // the callback interface. If not, it throws an exception
        try {
            mActionHandler = (ActionHandler) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement ActionHandler");
        }
    }
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Load the preferences from an XML resource
        addPreferencesFromResource(R.xml.settings);
        
        findPreference("reset_barcode_engine").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                mActionHandler.resetBarcodeEngine();
                return true;                
            }
        });
        
        findPreference("switch_all_in_green").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                mActionHandler.switchLeds(0);
                return true;                
            }
        });
        
        findPreference("switch_all_in_red").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                mActionHandler.switchLeds(1);
                return true;                
            }
        });
        
        findPreference("switch_all_in_yellow").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                mActionHandler.switchLeds(2);
                return true;                
            }
        });
        
        findPreference("switch_all_in_blue").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                mActionHandler.switchLeds(3);
                return true;                
            }
        });
        
        findPreference("about_preference").setOnPreferenceClickListener(new OnPreferenceClickListener() {
            @Override
            public boolean onPreferenceClick(Preference preference) {
                AlertDialog dialog = new AlertDialog.Builder(getActivity())
                    .setTitle(R.string.app_name)
                    .setMessage(getAppVersion())
                    .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {                        
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    })
                    .create();                              
                dialog.show();
                
                return true;                
            }
        });
                
        bindPreferenceEntryToSummary((ListPreference) findPreference("device_timeout_period"));        
        bindPreferenceEntryToSummary((ListPreference) findPreference("barcode_scan_mode"));
        
        PreferenceManager.getDefaultSharedPreferences(getActivity()).registerOnSharedPreferenceChangeListener(this);        
    }
        
    @Override
    public void onDestroy() {
        super.onDestroy();
        
        PreferenceManager.getDefaultSharedPreferences(getActivity()).unregisterOnSharedPreferenceChangeListener(this);
    }

    private String getAppVersion() {
        Context context = getActivity();
        String versionName = "";
        try {
            versionName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        return getString(R.string.app_version, versionName);
    }

    private void bindPreferenceEntryToSummary(ListPreference preference) {
        preference.setSummary(preference.getEntry());
    } 
    
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        Preference preference = findPreference(key);

        if (preference instanceof ListPreference) {
            ListPreference listPref = (ListPreference) preference;
            preference.setSummary(listPref.getEntry());
        }
    }
}
