package com.datecs.lineaprodemo.connectivity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import android.content.Context;

public abstract class AbstractConnector {

    private Context mContext;
    
    public AbstractConnector(Context context) {
        this.mContext = context;
    }
    
    public Context getContext() {
        return mContext;        
    }
    
    public abstract void connect() throws IOException;
    
    public abstract void close() throws IOException;
    
    public abstract InputStream getInputStream() throws IOException;
    
    public abstract OutputStream getOutputStream() throws IOException;

}
