//
//  TestView.m
//  FiscalDemo
//
//  Created by Flex on 10/13/14.
//  Copyright (c) 2014 Datecs. All rights reserved.
//

#import "TestView.h"

@implementation TestView

-(IBAction)onGetDiagnostic:(id)sender
{
    printer=[FP_BGR sharedInstance];
    
    NSArray *ports=[ORSSerialPortManager sharedSerialPortManager].availablePorts;
    
    for(int i=0;i<ports.count;i++)
    {
        ORSSerialPort *port=[ports objectAtIndex:i];
        if([port.name hasSuffix:@"DATECSRS"] || [port.name hasPrefix:@"usbserial"] || [port.name.lowercaseString rangeOfString:@"bluetooth"].location!=NSNotFound)
        {
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                serStream=[[SerialStream alloc] initWithPort:port];
                NSError *error;
                if([printer connectWithStreams:(NSInputStream *)serStream outputStream:(NSOutputStream *)serStream error:&error])
                {
                    NSDictionary *r=[printer command90Variant0Version0AndReturnError:&error];
                    NSLog(@"Result: %@",r);
                    [printer disconnect];
                }
                dispatch_async(dispatch_get_main_queue(), ^{
                });
            });
            break;
        }
    }
    
//    SerialStream *ser=[[SerialStream alloc] initWithFile:<#(NSString *)#> managerDelegate:<#(id)#>
    
    NSLog(@"waa");
}
- (IBAction)onPrintDiagnostic:(id)sender {
}

@end
