//
//  FD_ROU.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 24.04.2013
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Provides universal access to all supported devices' functions.
 In order to use one of the supported accessories in your program, several steps have to be performed:
 - Include DTDevices.h and libdtdev.a in your project.
 - Go to Frameworks and add ExternalAccessory framework
 - Edit your program plist file, add new element and select "Supported external accessory protocols" from the list, then add the protocol names of the accessories you want to connect to:
 <br>For Linea series: com.datecs.linea.pro.msr and com.datecs.linea.pro.bar
 <br>For Pinpad: com.datecs.iserial.communication and com.datecs.ppad
 <br>For iSerial: com.datecs.iserial.communication
 <br>For ESC/POS printers: com.datecs.printer.escpos
 
 <br>Since this SDK is based on features, the specific device is not that important, for example, if your program relies on barcode scanning, then Linea, Pinpad or the ESC/POS printers can provide that functionality, so you can include all their protocols.
 */
@interface FMP10_ROU : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(bool)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) bool deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) bool infoMandatoryZReportEndOfDay;
@property(readonly) bool infoMandatoryEKLPrintBeforeZReport;
@property(readonly) bool infoMandatoryEKLSave;
@property(readonly) bool infoMandatoryMonthlyReport;
@property(readonly) bool infoMandatoryYearlyReport;
@property(readonly) bool statusDisplayNotConnected;
@property(readonly) bool statusTransparentDisplayMode;
@property(readonly) bool statusFiscalMemoryMissing;
@property(readonly) bool statusPrintingHeadOverheated;
@property(readonly) bool statusSeconRollNoPaperPlace;
@property(readonly) bool statusSeconRollOutOfPaper;
@property(readonly) bool statusEndOfEKL;
@property(readonly) bool statusDrawerOpened;
@property(readonly) bool statusEKLNotEmpty;
@property(readonly) bool statusEKLPrinted;
@property(readonly) bool statusEKLNearEnd;
@property(readonly) bool statusKLENNearEnd;
@property(readonly) bool statusSecondRollNotEnoughPaper;
@property(readonly) bool statusAutomaticPaperCutting;
@property(readonly) bool statusPrintingHeadNotConnected;
@property(readonly) bool supportEKL;
@property(readonly) bool supportNRATerminal;
@property(readonly) bool supportKLEN;
@property(readonly) bool supportEIK;
@property(readonly) bool supportServiceContractsInformation;
@property(readonly) bool supportIOSANumber;
@property(readonly) bool supportFiscalReceipts;
@property(readonly) bool supportRotatedFiscalReceipts;
@property(readonly) bool supportNonFiscalReceipts;
@property(readonly) bool supportRotatedNonFiscalReceipts;
@property(readonly) bool supportBluetooth;
@property(readonly) bool supportWiFi;
@property(readonly) bool supportTCPIP;
@property(readonly) bool supportFTP;
@property(readonly) bool supportHTTP;
@property(readonly) bool supportSoftwareSwitches;
@property(readonly) bool supportClientDisplay;
@property(readonly) bool supportDrawerOpening;
@property(readonly) bool supportDrawerStatus;
@property(readonly) bool supportSecondRoll;
@property(readonly) bool supportAutoCutPaper;
@property(readonly) bool supportAdditionalMatrixPrint;
@property(readonly) bool supportPrintingHeadTemperatureControl;
@property(readonly) bool supportAsynchronousMode;
@property(readonly) bool supportTransactionsBufferForCommands;
@property(readonly) bool supportReceiptVoid;
@property(readonly) bool supportSaleRowVoid;
@property(readonly) bool supportVoidReceipt;
@property(readonly) bool supportVoidSale;
@property(readonly) bool statusEIKSet;
@property(readonly) bool statusSerialNumberSet;
@property(readonly) bool statusFMNumberSet;
@property(readonly) bool statusPrinterFiscalized;
@property(readonly) bool statusFiscalMemoryFormated;
@property(readonly) bool statusTaxRatesOk;
@property(readonly) bool statusLowBattery;
@property(readonly) bool statusGeneralErrorType1;
@property(readonly) bool statusGeneralErrorType2;
@property(readonly) bool statusPrintingHeadFailure;
@property(readonly) bool statusPrinterClockNotSet;
@property(readonly) bool statusInvalidCommand;
@property(readonly) bool statusSyntaxError;
@property(readonly) bool statusNRATerminalNotRespond;
@property(readonly) bool statusRamError;
@property(readonly) bool statusRamCleared;
@property(readonly) bool statusCommandNotAllowed;
@property(readonly) bool statusFieldOverflow;
@property(readonly) bool statusFiscalMemoryFull;
@property(readonly) bool statusFiscalMemoryReadError;
@property(readonly) bool statusFiscalMemoryWriteError;
@property(readonly) bool statusFiscalMemoryReadOnly;
@property(readonly) bool statusOutOfPaper;
@property(readonly) bool statusEndOfKLEN;
@property(readonly) bool statusFiscalReceiptOpened;
@property(readonly) bool statusNonFiscalReceiptOpened;
@property(readonly) bool statusRotatedReceiptOpened;
@property(readonly) bool statusFiscalMemoryNearEnd;
@property(readonly) bool statusCoverWasOpened;
@property(readonly) bool statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) bool infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterSpecialTax;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterToDisplay;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;

@property(readonly) NSData *statusBytes;



/* machine-oriented interface begin */

/**
26h (38)	Opening a non-fiscal receipt.

<p>
 - Data field:
		 -# None
 - Response:
		 -# Allreceipt	The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).

<p>

<p>
 The FP performs the following actions:
 - Prints the header
 - Prints the tax registration number of the seller
 - A response is received, which contains Allreceipt

<p>
 The command cannot be executed, S1.1 is raised if.
 - The fiscal memory has not been formatted
 - There is an opened fiscal or non-fiscal receipt
 - There is no paper
 - The clock is not set
 - The electronic journal is full


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).
*/

    -(NSDictionary *)command38Variant0Version0AndReturnError:(NSError **)error;
/**
27h (39)	Closing a non-fiscal receipt

<p>
 - Data field:
		 -# None
 - Response:
		 -# Allreceipt	The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).

<p>
The FP performs the following actions:
 - Prints the footer
 - The sequence number, date and hour of document are printed
 - "NON-FISCAL RECEIPT" is printed in expanded style.

<p>
If the S1.1 flag is raised, the command is not executed because there is no opened non-fiscal receipt.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).
*/

    -(NSDictionary *)command39Variant0Version0AndReturnError:(NSError **)error;
/**
29h (41)	SET MEMORY SWITCHES

<p>
 - Data field:
		 -# Switches	8 bytes with value '0' or '1' - the configuration switches.
 - Response:
		 -# None

<p>

<p>

<p>
Note:

<p>
The command writes to flash memory the switches value, graphics logo, bar code height, print darkness and default drawer pulse length. After RAM reset they are restored with the saved values.
If the switches parameter is not present, then the old switches are kept.


 <p>
 @param switches - 8 bytes with value '0' or '1' - the configuration switches.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command41Variant0Version0Switches:(NSString *)switches error:(NSError **)error;
/**
29h (41)	SET MEMORY SWITCHES

<p>
 - Data field:
		 -# None
 - Response:
		 -# None

<p>

<p>
The command writes to flash memory the switches value, graphics logo, bar code height, print darkness and default drawer pulse length. 
After RAM reset they are restored with the saved values.
If the switches parameter is not present, then the old switches are kept.


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command41Variant0Version1AndReturnError:(NSError **)error;
/**
2Ah (42)	PRINTING OF A FREE NON-FISCAL TEXT

<p>
 - Data field:
		 -# inputText	A text of 30 symbols (at most). The symbols after 30 are cut off.
 - Response:
		 -# None

<p>

<p>

<p>
If S1.1 is raised, there is no non-fiscal receipt opened and the text is not printed.


 <p>
 @param inputText - A text of 30 symbols (at most). The symbols after 30 are cut off.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command42Variant0Version0InputText:(NSString *)inputText error:(NSError **)error;
/**
2Bh (43)	SETTING FOOTER AND PRINTING OPTIONS

<p>
 - Data field:
		 -# itemIndex
		 -# dataValue
 - Response:
		 -# Entries from the data field

<p>
FOOTER consists of 2 lines of text printed at the end of each receipt. HEADER and FOOTER are automatically center aligned.
 - itemIndex	One symbol having the following meaning:
		 -# "6" to "7"	"6" and "7" select the first or second FOOTER line.
		 -# "B"	Set bar code height in pixels (0.125 mm). Possible values from 24 (3 mm) to 240 (30 mm). The barcode is printed with command 84 (54H).
		 -# "D"	Set print darkness. Possible values:
			 -# '1':	Very low
			 -# '2':	Low
			 -# '3':	Normal
			 -# '4':	Dark
			 -# '5':	Very dark
		 -# "E"	Disable / enable printing of total receipt sum in EUR when first Total (53) command is executed. Optionally the command sets the valid exchange rate EUR / LEI. Syntax of the data:
			 -# \<Enable>[,Rate]
			 -# Enable	Disable / enable flag. One byte: '0' or '1'.
			 -# Rate	Exchange rate. A float number with up to 5 decimal places and 8 significant digits. If not preset, then old value remains active. If 0.00000, then EUR value is not printed independent of the value of Enable flag.
		 -# "L"	Height of graphic logo and permission/rejection of the printing of graphic logo immediately before the header. This logo is defined with command 115 (73H).
		 -# "Z"	Set auto off time in seconds. Possible values from 60 to 3600. Setting 0 disables the auto off.
		 -# "I"	Gives us the option to read values, set earlier with command 43. After the letter "I" only one more symbol follows which coincides with some of the above.

<p>
 - dataValue	A text string:
		 -# If \<item> is '0' to '7' - the text of the header / footer line (up to 38 symbols).
		 -# If \<item> = 'B' - A number - the height of bar code in pixels.
		 -# If \<item> = 'D' - The print darkness (1 to 5).
		 -# If \<item> = 'E' - Returns Enable,Rate, where Enable is Disable / enable flag and Rate is current exchange rata EUR / LEI.
		 -# If \<item> = `L' Syntax \<Height>,\<Enabled>
			 -# Height	Graphics logo height in lines (0.125 mm). A number from 8 to 96.
			 -# Enabled	'0' or '1', where '1' means, that logo printing is enabled.
		 -# If \<item> = `Z' Syntax \<OffTime>


 <p>
 @param itemIndex - One symbol having the following meaning:
		 -# "6" to "7"	"6" and "7" select the first or second FOOTER line.
		 -# "B"	Set bar code height in pixels (0.125 mm). Possible values from 24 (3 mm) to 240 (30 mm). The barcode is printed with command 84 (54H).
		 -# "D"	Set print darkness. Possible values:
			 -# '1':	Very low
			 -# '2':	Low
			 -# '3':	Normal
			 -# '4':	Dark
			 -# '5':	Very dark
		 -# "E"	Disable / enable printing of total receipt sum in EUR when first Total (53) command is executed. Optionally the command sets the valid exchange rate EUR / LEI. Syntax of the data:
			 -# \<Enable>[,Rate]
			 -# Enable	Disable / enable flag. One byte: '0' or '1'.
			 -# Rate	Exchange rate. A float number with up to 5 decimal places and 8 significant digits. If not preset, then old value remains active. If 0.00000, then EUR value is not printed independent of the value of Enable flag.
		 -# "L"	Height of graphic logo and permission/rejection of the printing of graphic logo immediately before the header. This logo is defined with command 115 (73H).
		 -# "Z"	Set auto off time in seconds. Possible values from 60 to 3600. Setting 0 disables the auto off.
		 -# "I"	Gives us the option to read values, set earlier with command 43. After the letter "I" only one more symbol follows which coincides with some of the above.

 @param dataValue - A text string:
		 -# If \<item> is '0' to '7' - the text of the header / footer line (up to 38 symbols).
		 -# If \<item> = 'B' - A number - the height of bar code in pixels.
		 -# If \<item> = 'D' - The print darkness (1 to 5).
		 -# If \<item> = 'E' - Returns Enable,Rate, where Enable is Disable / enable flag and Rate is current exchange rata EUR / LEI.
		 -# If \<item> = `L' Syntax \<Height>,\<Enabled>
			 -# Height	Graphics logo height in lines (0.125 mm). A number from 8 to 96.
			 -# Enabled	'0' or '1', where '1' means, that logo printing is enabled.
		 -# If \<item> = `Z' Syntax \<OffTime>

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command43Variant0Version0ItemIndex:(NSString *)itemIndex dataValue:(NSString *)dataValue error:(NSError **)error;
/**
2Ch(44) ADVANCING PAPER
 - Data field:	targetLines
 - Response:	None

<p>
 - targetLines 	Advancing paper measured in text lines. The programmed line count cannot be greater than 99 (1 or 2 bytes).
 - If the parameter is not there, the default setting is 1 line.


 <p>
 @param targetLines - Advancing paper measured in text lines. The programmed line count cannot be greater than 99 (1 or 2 bytes). If the parameter is not there, the default setting is 1 line. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command44Variant0Version0TargetLines:(NSString *)targetLines error:(NSError **)error;
/**
2Dh (45)	OPENING A RECEIPT FOR 90 DEGREES ROTATED TEXT

<p>
 - Data field:	 None
 - Response:	 allRotationReceipt

<p>
 - allRotationReceipt	Rotated receipt number after last Z-report. 4 bytes.

<p>
The command opens a non-fiscal receipt for 90 degrees rotated text.

<p>
The command will be not executed if:
 - A receipt is open (fiscal or non-fiscal).
 - Out of paper.
 - The clock has to be set.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allRotationReceipt" - Rotated receipt number after last Z-report. 4 bytes.
*/

    -(NSDictionary *)command45Variant0Version0AndReturnError:(NSError **)error;
/**
2Eh(46) PRINT 90 DEGREES ROTATED TEXT

<p>
 - Data field:	Text
 - Response:	None

<p>
 - Text	The line to be print. Length is up to 100 symbols. It is possible to print bold and underline:
		 -# \<Tab>B	Start bold printing.
		 -# \<Tab>b	Cancel bold printing.
		 -# \<Tab>U	Start underlined printing.
		 -# \<Tab>u	Cancel underlined printing.

<p>
The command sends text for 90 degrees rotated lines. On the paper can be placed up to 12 rotated lines. 
Sent lines are accumulated in printer's memory. 
If the command is executed more than 12 times, then the text is printed and the printer expects new lines or command 47 (close the receipt). 
The printer detects the longest text line and fill all other lines to the same length with spaces (ASCII 20h).
If more than 12 lines are sent, then more than one column of lines is printed. 
There is no space between the columns, so rotated lines of unlimited length can be printed.

<p>
The command is not permitted, if no rotated receipt is open.


 <p>
 @param rotatedTextRow - The line to be print. Length is up to 100 symbols. It is possible to print bold and underline:
		 -# \<Tab>B	Start bold printing.
		 -# \<Tab>b	Cancel bold printing.
		 -# \<Tab>U	Start underlined printing.
		 -# \<Tab>u	Cancel underlined printing.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command46Variant0Version0RotatedTextRow:(NSString *)rotatedTextRow error:(NSError **)error;
/**
2Fh(47) CLOSING A RECEIPT FOR 90 DEGREES ROTATED TEXT

<p>
 - Data field:
		 -# None
 - Response:
		 -# allRotationReceipt	Rotated receipt number after last Z-report. 4 bytes.

<p>
The command closes the receipt. If there are unprinted lines, they are automatically printed before this.

<p>
The command will be not executed, if no rotated receipt is open.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allRotationReceipt" - Rotated receipt number after last Z-report. 4 bytes.
*/

    -(NSDictionary *)command47Variant0Version0AndReturnError:(NSError **)error;
/**
30h(48) OPENING A FISCAL CLIENT'S RECEIPT

<p>
 - Data field:
		 -# operatorCode
		 -# operatorPassword
		 -# tillNumber
 - Response:
		 -# allReceiptNumber
		 -# fiscalReceiptNumber

<p>
 - operatorCode		Operator's number (1 to 16)
 - operatorPassword		Operator's password (4 to 8 digits)
 - tillNumber			Number of point of sale (a whole number of maximum 5 digits)

<p>
 - allReceiptNumber		The number of all issued receipts (fiscal or non-) from the last daily closure up to the moment (4 bytes).
 - fiscalReceiptNumber		The number of all fiscal receipts from the last daily closure up to the moment (4 bytes).

<p>
The FP performs the following actions:
 - Prints the HEADER
 - Prints the tax registration number
 - Prints the number and name of operator as well as the cashier desk number
 - Allreceipt and FiscReceipt are returned

<p>
The command will not be successful if:
 - There is an opened fiscal or non-fiscal receipt
 - The maximum number of receipts, as fixed for the day, has already been issued
 - The fiscal memory is full
 - The fiscal memory is damaged
 - No code or operator password, or cashier desk number available
 - Less than 2 HEADER lines are programmed
 - No VAT registration number available
 - Wrong operator password
 - The clock needs setting
 - Journal is full

<p>
After entering three wrong operator's passwords, the printer blocks and must be switched off and on again to restart operation.


 <p>
 @param operatorCode - Operator's number (1 to 16)
 @param operatorPassword - Operator's password (4 to 8 digits)
 @param tillNumber - Number of point of sale (a whole number of maximum 5 digits)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceiptNumber" - The number of all issued receipts (fiscal or non-) from the last daily closure up to the moment (4 bytes).
 - KeyValue - \@"fiscalReceiptNumber" - The number of all fiscal receipts from the last daily closure up to the moment (4 bytes).
*/

    -(NSDictionary *)command48Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
 - Response:	None

<p>
		 -# taxGroup		One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice		This is a single price that consists of 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
 - Response:	None

<p>
		 -# taxGroup		One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice		This is a single price that consists of 8 meaningful digits.
		 -# specialTax		Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version1TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version5TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version7TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version9TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version11TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
 - Response:	None

<p>
		 -# textRow1		A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2		A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup		One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice		This is a single price that consists of 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
 - Response:	None

<p>
		 -# textRow1		A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2		A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup		One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice		This is a single price that consists of 8 meaningful digits.
		 -# specialTax		Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version13TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
 - Response:	None

<p>
		 -# textRow1		A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2		A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup		One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice		This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity	The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax		Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - A non-mandatory parameter setting the quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version15TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version1TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version5TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version7TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version9TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/
-(bool)command49Variant1Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;

/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version11TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version13TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the currently performed sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version15TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version0TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version1TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version2TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits. =
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version4TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version5TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version6TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version7TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version8TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version9TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version10TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version11TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version12TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version13TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version14TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h(49) REGISTRATION OF SALES

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# taxGroup
		 -# itemPrice
		 -# itemQuantity
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:	None

<p>
		 -# textRow1			A text of up to 30 bytes containing one line of description of sale.
		 -# textRow2			A text of up to 30 bytes containing a second line describing the sale.
		 -# taxGroup			One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
		 -# itemPrice			This is a single price that consists of 8 meaningful digits.
		 -# itemQuantity		The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.
		 -# specialTax			Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
		 -# sellWithPercentDiscount	The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

<p>

<p>
FP performs the following actions:
 - - The text, describing sale is printed out together with the price and code of discount or surcharge. If there is a set quantity, the information on it is printed out too.
 - - The price of the items sold is accumulated to the sums already stored in the operational memory. In case of memory overflow the value of respective bites of the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is then added to a specially maintained registers within the printer. The values for the day are printed out together with the daily financial report.

<p>
The command will not be correctly executed if and when:
No fiscal receipt has been opened
 - - The maximum number of sales for one receipt have already been performed (380)
 - - The 35h command has been successfully executed
 - - The sum for some of the tax groups has become negative
 - - The sum of discounts and surcharges within the same receipt has become negative
 - - Journal is full


 <p>
 @param textRow1 - A text of up to 30 bytes containing one line of description of sale.
 @param textRow2 - A text of up to 30 bytes containing a second line describing the sale.
 @param taxGroup - One byte containing letter, which indicates the type of tax. There is a restriction, depending on the enabled tax groups (command 83).
 @param itemPrice - This is a single price that consists of 8 meaningful digits. 
 @param itemQuantity - The quantity of items for sale. By default, this is 1.000.The length of this parameter is 9 meaningful digits (not more than 3 after the decimal point). 
The result Price*Quan is rounded up to the set number of digits and cannot be longer than 8 meaningful digits.

 @param specialTax - Special tax. Has the dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. 
The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

 @param sellWithPercentDiscount - The value of discount or surcharge (depending on the sign) in percent over the currently performed sale. 
Possible values are between - 99.00% and 99.00%, where up to 2 decimal places are acceptable.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version15TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
32h(50) TAX RATES ENTERED DURING THE ACCOUNTED PERIOD

<p>
 - Data field:	\<Start>,\<End>
 - Response:	Data

<p>
 - Start	The starting date of the period - DDMMYY/6 bytes/
 - End	The end date of the period - DDMMYY /6 bytes/
 - Data
		 -# 'F' if no tax rates for the period have been found, or in case of error
		 -# 'PAA,BB,CC,DD,DDMMYY' if rates have been found, where 'P' means 'PASS' after which the last active rates for the period are listed out as well as the date of their entry.
		 -# If there are unused groups (disabled by command 83) for them, instead of rate in percent a 'DT' is returned (Disabled tax).

<p>
The command prints a report on the changes made in the decimal points and tax rates during the selected period.


 <p>
 @param startDate - StartDate		The starting date of the period - DDMMYY/6 bytes/
 @param endDate - EndDate The end date of the period - DDMMYY /6 bytes/
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fResult" -  'F' if no tax rates for the period have been found, or in case of error
 'P' means 'PASS' after which the last active rates for the period

 - KeyValue - \@"aA" - The last active rates for the period are listed out as well as the date of their entry. 
If there are unused groups (disabled by command 83) for them, instead of rate in percent a 'DT' is returned (Disabled tax).

 - KeyValue - \@"bB" - The last active rates for the period are listed out as well as the date of their entry. 
If there are unused groups (disabled by command 83) for them, instead of rate in percent a 'DT' is returned (Disabled tax).

 - KeyValue - \@"cC" - The last active rates for the period are listed out as well as the date of their entry. 
If there are unused groups (disabled by command 83) for them, instead of rate in percent a 'DT' is returned (Disabled tax).

 - KeyValue - \@"dD" - The last active rates for the period are listed out as well as the date of their entry. 
If there are unused groups (disabled by command 83) for them, instead of rate in percent a 'DT' is returned (Disabled tax).

 - KeyValue - \@"dDMMYY" - Day Month Year
*/

    -(NSDictionary *)command50Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
33h(51) SUBTOTAL

<p>
 - Data field:		toPrintOption,toDisplayOption
 - Response:		subTotal,taxGroupA,taxGroupB,taxGroupC,taxGroupD,taxGroupE,specialTax

<p>
 - toPrintOption	One byte, which if '1' the sum of the subtotal will be printed out.
 - toDisplayOption	One byte, which if '1' the sum of the subtotal will be displayed out.

<p>

<p>
 - SubTotal		The sum accumulated for the current fiscal receipt (10 bytes).
 - taxGroupA	The sum over tax group A /10 bytes/
 - taxGroupB	The sum over tax group B /10 bytes/
 - taxGroupC	The sum over tax group C /10 bytes/
 - taxGroupD	The sum over tax group D /10 bytes/
 - taxGroupE	The sum over tax group E - VAT exempt /10 bytes/
 - specialTax		The sum over special tax /10 bytes/

<p>
The sum of all sales registered in the fiscal receipt is calculated. 
The calculated total sum and the accumulated separate sums for each tax group are returned to the PC. 


 <p>
 @param toPrintOption - One byte, which if '1' the sum of the subtotal will be printed out.
 @param toDisplayOption - One byte, which if '1' the sum of the subtotal will be displayed out.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - The sum accumulated for the current fiscal receipt (10 bytes).
 - KeyValue - \@"taxGroupA" - The sum over tax group A /10 bytes/
 - KeyValue - \@"taxGroupB" - The sum over tax group B /10 bytes/
 - KeyValue - \@"taxGroupC" - The sum over tax group C /10 bytes/
 - KeyValue - \@"taxGroupD" - The sum over tax group D /10 bytes/
 - KeyValue - \@"taxGroupE" - The sum over tax group E - VAT exempt /10 bytes/
 - KeyValue - \@"specialTax" - The sum over special tax /10 bytes/
*/
    -(NSDictionary *)command51Variant0Version0ToPrintOption:(NSString *)toPrintOption toDisplayOption:(NSString *)toDisplayOption error:(NSError **)error;
	
/**
33h(51) SUBTOTAL

<p>
 - Data field:		toPrintOption,toDisplayOption,subtotalWithPercentDiscount
 - Response:		subTotal,taxGroupA,taxGroupB,taxGroupC,taxGroupD,taxGroupE,specialTax

<p>
 - toPrintOption	One byte, which if '1' the sum of the subtotal will be printed out.
 - toDisplayOption	One byte, which if '1' the sum of the subtotal will be displayed out.

<p>
 - subtotalWithPercentDiscount	The value of discount or surcharge in percent over the sum accumulated so far.

<p>
 - subTotal			The sum accumulated for the current fiscal receipt (10 bytes).
 - taxGroupA		The sum over tax group A /10 bytes/
 - taxGroupB		The sum over tax group B /10 bytes/
 - taxGroupC		The sum over tax group C /10 bytes/
 - taxGroupD		The sum over tax group D /10 bytes/
 - taxGroupE		The sum over tax group E - VAT exempt /10 bytes/
 - specialTax			The sum over special tax /10 bytes/

<p>
The sum of all sales registered in the fiscal receipt is calculated. 
The calculated total sum and the accumulated separate sums for each tax group are returned to the PC. 


 <p>
 @param toPrintOption - One byte, which if '1' the sum of the subtotal will be printed out.
 @param toDisplayOption - One byte, which if '1' the sum of the subtotal will be displayed out.
 @param subtotalWithPercentDiscount - The value of discount or surcharge in percent over the sum accumulated so far.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - The sum accumulated for the current fiscal receipt (10 bytes).
 - KeyValue - \@"taxGroupA" - The sum over tax group A /10 bytes/
 - KeyValue - \@"taxGroupB" - The sum over tax group B /10 bytes/
 - KeyValue - \@"taxGroupC" - The sum over tax group C /10 bytes/
 - KeyValue - \@"taxGroupD" - The sum over tax group D /10 bytes/
 - KeyValue - \@"taxGroupE" - The sum over tax group E - VAT exempt /10 bytes/
 - KeyValue - \@"specialTax" - The sum over special tax /10 bytes/
*/
    -(NSDictionary *)command51Variant0Version1ToPrintOption:(NSString *)toPrintOption toDisplayOption:(NSString *)toDisplayOption subtotalWithPercentDiscount:(NSString *)subtotalWithPercentDiscount error:(NSError **)error;
	
	/**
33h(51) SUBTOTAL

<p>
 - Data field:		toPrintOption,toDisplayOption,subtotalWithAbsoluteSumDiscount
 - Response:		subTotal,taxGroupA,taxGroupB,taxGroupC,taxGroupD,taxGroupE,specialTax

<p>
 - toPrintOption			One byte, which if '1' the sum of the subtotal will be printed out.
 - toDisplayOption			One byte, which if '1' the sum of the subtotal will be displayed out.
 - subtotalWithAbsoluteSumDiscount	The value of discount as absolute value (up to 8 digits).

<p>
The subtotal will be printed out.

<p>
 - subTotal				The sum accumulated for the current fiscal receipt (10 bytes).
 - taxGroupA			The sum over tax group A /10 bytes/
 - taxGroupB			The sum over tax group B /10 bytes/
 - taxGroupC			The sum over tax group C /10 bytes/
 - taxGroupD			The sum over tax group D /10 bytes/
 - taxGroupE			The sum over tax group E - VAT exempt /10 bytes/
 - specialTax				The sum over special tax /10 bytes/

<p>
The sum of all sales registered in the fiscal receipt is calculated. 
The calculated total sum and the accumulated separate sums for each tax group are returned to the PC. 


 <p>
 @param toPrintOption - One byte, which if '1' the sum of the subtotal will be printed out.
 @param toDisplayOption - One byte, which if '1' the sum of the subtotal will be displayed out.
 @param subtotalWithAbsoluteSumDiscount - The value of discount as absolute value (up to 8 digits).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - The sum accumulated for the current fiscal receipt (10 bytes).
 - KeyValue - \@"taxGroupA" - The sum over tax group A /10 bytes/
 - KeyValue - \@"taxGroupB" - The sum over tax group B /10 bytes/
 - KeyValue - \@"taxGroupC" - The sum over tax group C /10 bytes/
 - KeyValue - \@"taxGroupD" - The sum over tax group D /10 bytes/
 - KeyValue - \@"taxGroupE" - The sum over tax group E - VAT exempt /10 bytes/
 - KeyValue - \@"specialTax" - The sum over special tax /10 bytes/
*/
	-(NSDictionary *)command51Variant0Version2ToPrintOption:(NSString *)toPrintOption toDisplayOption:(NSString *)toDisplayOption subtotalWithAbsoluteSumDiscount:(NSString *)subtotalWithAbsoluteSumDiscount error:(NSError **)error;
	
/**
35h(53) CALCULATION OF A TOTAL

<p>
 - Data field:
		 -# paidMode
		 -# amountIn

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - paidMode		Code indicating the terms of payment. It may have the following values:
				 -# 'P'	Payment in cash
				 -# 'N'	Payment via credit
				 -# 'C'	Payment in cheques
				 -# 'D'	Payment with a debit card
				 -# 'I'	Programmable payment 1
				 -# 'J'	Programmable payment 2
				 -# 'K'	Programmable payment 3
				 -# 'L'	Programmable payment 4
 - amountIn		The sum tendered (up to 10 meaningful symbols)
			 -# Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param paidMode - Code indicating the terms of payment. It may have the following values:
 - 'P'	Payment in cash
 - 'N'	Payment via credit
 - 'C'	Payment in cheques
 - 'D'	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - The sum tendered (up to 10 meaningful symbols). Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant0Version0PaidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
 - Data field:
		 -# textRow2
		 -# paidMode
		 -# amountIn

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow2		A text of 30 bytes containing the second line
 - paidMode		Code indicating the terms of payment. It may have the following values:
				 -# 'P'	Payment in cash
				 -# 'N'	Payment via credit
				 -# 'C'	Payment in cheques
				 -# 'D'	Payment with a debit card
				 -# 'I'	Programmable payment 1
				 -# 'J'	Programmable payment 2
				 -# 'K'	Programmable payment 3
				 -# 'L'	Programmable payment 4
 - amountIn		The sum tendered (up to 10 meaningful symbols)
			 -# Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.

<p>

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow2 - A text of 30 bytes containing the second line
 @param paidMode - Code indicating the terms of payment. It may have the following values:
 - 'P'	Payment in cash
 - 'N'	Payment via credit
 - 'C'	Payment in cheques
 - 'D'	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - The sum tendered (up to 10 meaningful symbols). Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant0Version1TextRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
 - Data field:
		 -# textRow1
		 -# paidMode
		 -# amountIn

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow1		A text of 30 bytes containing the first line
 - paidMode		Code indicating the terms of payment. It may have the following values:
				 -# 'P'	Payment in cash
				 -# 'N'	Payment via credit
				 -# 'C'	Payment in cheques
				 -# 'D'	Payment with a debit card
				 -# 'I'	Programmable payment 1
				 -# 'J'	Programmable payment 2
				 -# 'K'	Programmable payment 3
				 -# 'L'	Programmable payment 4
 - amountIn		The sum tendered (up to 10 meaningful symbols)
			 -# Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.

<p>

<p>

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow1 - A text of 30 bytes containing the first line
 @param paidMode - Code indicating the terms of payment. It may have the following values:
 - 'P'	Payment in cash
 - 'N'	Payment via credit
 - 'C'	Payment in cheques
 - 'D'	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - The sum tendered (up to 10 meaningful symbols). Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant0Version2TextRow1:(NSString *)textRow1 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
 - Data field:
		 -# textRow1
		 -# textRow2
		 -# paidMode
		 -# amountIn

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow1		A text of 30 bytes containing the first line
 - textRow2		A text of 30 bytes containing the second line
 - paidMode		Code indicating the terms of payment. It may have the following values:
				 -# 'P'	Payment in cash
				 -# 'N'	Payment via credit
				 -# 'C'	Payment in cheques
				 -# 'D'	Payment with a debit card
				 -# 'I'	Programmable payment 1
				 -# 'J'	Programmable payment 2
				 -# 'K'	Programmable payment 3
				 -# 'L'	Programmable payment 4
 - amountIn		The sum tendered (up to 10 meaningful symbols)
			 -# Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.

<p>

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow1 - A text of 30 bytes containing the first line
 @param textRow2 - A text of 30 bytes containing the second line
 @param paidMode - Code indicating the terms of payment. It may have the following values:
 - 'P'	Payment in cash
 - 'N'	Payment via credit
 - 'C'	Payment in cheques
 - 'D'	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - The sum tendered (up to 10 meaningful symbols). Depending on the code, the sums are accumulated in different registers and may be recovered in the daily report.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant0Version4TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
Payment in cash!!!

<p>
 - Data field:	 None

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant1Version0AndReturnError:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
Payment in cash!!!

<p>
 - Data field:
		 -# textRow2

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow2		A text of 30 bytes containing the second line
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow2 - A text of 30 bytes containing the second line
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant1Version1TextRow2:(NSString *)textRow2 error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
Payment in cash!!!

<p>
 - Data field:
		 -# textRow1

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow1		A text of 30 bytes containing the first line
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow1 - A text of 30 bytes containing the first line
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant1Version2TextRow1:(NSString *)textRow1 error:(NSError **)error;
/**
35h(53) CALCULATION OF A TOTAL

<p>
Payment in cash!!!

<p>
 - Data field:
		 -# textRow1
		 -# textRow2

<p>
 - Response:
		 -# paidCode
		 -# amountOut

<p>
 - textRow1		A text of 30 bytes containing the first line
 - textRow2		A text of 30 bytes containing the second line

<p>

<p>

<p>

<p>

<p>
 - paidCode		One byte - resulting from the execution of the command
				 -# 'F'	Error
				 -# 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
				 -# 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
				 -# 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
				 -# 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.
 - amountOut	Up to 9 digits with a sign. Depends on PaidCode.

<p>

<p>
This command starts the calculation of the sums from fiscal receipt, the printing of the sum with a special font. 
An additional text may also be printed.
When the command has been successfully executed a further command for opening a cash drawer is activated. 

<p>

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - The accumulated sum is negative,
 - - If some of the accumulated sums under taxation (tax group) is negative.

<p>

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.


 <p>
 @param textRow1 - A text of 30 bytes containing the first line
 @param textRow2 - A text of 30 bytes containing the second line
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to Amount.

<p>
Notes: 
1. After the successful completion of the command, fiscal printer will not perform the commands 49 and 51 within the opened receipt, although it can still perform command 53.
2. The codes of error 'E' and 'I' will never appear in this version of the printer because commands 49 and 52 (registering a sale) do not accept negative sums.

 - KeyValue - \@"amountOut" - Up to 9 digits with a sign. Depends on PaidCode.
*/

    -(NSDictionary *)command53Variant1Version3TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 error:(NSError **)error;
/**
36h(54) PRINTING A FREE FISCAL TEXT

<p>
 - Data field:		textIn
 - Response:		None

<p>
 - textIn		Up to 30 bytes text

<p>
A fiscal receipt must be opened because, in the opposite case, the text will not be printed and the S1.1. flag is raised. 
If the text is longer than 30 symbols, the redundant letters are cut off. 


 <p>
 @param textIn - Up to 30 bytes text
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command54Variant0Version0TextIn:(NSString *)textIn error:(NSError **)error;
/**
38h(56) CLOSING A FISCAL RECEIPT

<p>
 - Data field:		No data
 - Response:		allReceipt, fiscalReceipt

<p>
 - allReceipt		All issued receipts from the last daily closure up to the moment
 - fiscalReceipt	All issued fiscal receipts from the last daily closure up to the moment

<p>
The accumulated sums from the fiscal receipt are added to the daily sums in the registries of operational memory.

<p>
The command will not be successful if:
 - - No fiscal receipt has been opened,
 - - Command 53 (35h) has failed,
 - - The sum paid under command 53 is less than the total sum on the fiscal receipt.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - All issued receipts from the last daily closure up to the moment
 - KeyValue - \@"fiscalReceipt" - All issued fiscal receipts from the last daily closure up to the moment
*/

    -(NSDictionary *)command56Variant0Version0AndReturnError:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
 - Response:
		 -# None

<p>
 - signPlu		The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity	The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant0Version0SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
		 -# specialTax
 - Response:
		 -# None

<p>
 - signPlu		The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity	The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 - specialTax		The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param specialTax - The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant0Version1SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax error:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
		 -# sellWithAbsoluteSumDiscount
 - Response:
		 -# None

<p>
 - signPlu			The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity		The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 - sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the current sale. Up to 8 significant digits.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the current sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant1Version0SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
		 -# specialTax
		 -# sellWithAbsoluteSumDiscount
 - Response:
		 -# None

<p>
 - signPlu			The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity		The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 - specialTax			The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
 - sellWithAbsoluteSumDiscount	The value of discount or surcharge (depending on the sign) over the current sale. Up to 8 significant digits.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param specialTax - The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the current sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant1Version1SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
		 -# sellWithPercentDiscount
 - Response:
		 -# None

<p>
 - signPlu			The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity		The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 - sellWithPercentDiscount	The value of surcharge or discount (depending on the symbol) in percent over the current sale. Possible values are between -99.00% to 99.00%. Up to 2 digits after the decimal point are acceptable.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param sellWithPercentDiscount - The value of surcharge or discount (depending on the symbol) in percent over the current sale. Possible values are between -99.00% to 99.00%. Up to 2 digits after the decimal point are acceptable.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant2Version0SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
3Ah(58) REGISTERING THE SALE OF AN PROGRAMMED ITEM

<p>
 - Data field:
		 -# signPlu
		 -# itemQuantity
		 -# specialTax
		 -# sellWithPercentDiscount
 - Response:
		 -# None

<p>
 - signPlu			The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 - itemQuantity		The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 - specialTax			The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
 - sellWithPercentDiscount	The value of surcharge or discount (depending on the symbol) in percent over the current sale. Possible values are between -99.00% to 99.00%. Up to 2 digits after the decimal point are acceptable.

<p>

<p>
The fiscal printer performs the following operations:
 - - The name, price and tax group of the item is read from items list, programmed in the printer.
 - - Prints out the name of the item, selected quantity and singular price. The second printed line contains the final price together with the letter, designating the tax group from which the sale will be performed. The registries for accumulated sums and item quantities are updated.
 - - The price of the item is added to the accumulated sums in the registries of operational memory. In case of overflow, the respective bytes from the status field will be set.
 - - If there is a discount or surcharge, it is printed out on a separate line and is added in specially selected registries in the printer. The values from the whole day will be printed together with the daily financial report.

<p>
The command will not be successful if:
 - - No item has been programmed under the given number,
 - - No fiscal receipt has been opened,
 - - The maximum number of sales for one receipt (380) has already been registered.
 - - The command 35h has been successfully executed,
 - - The sum under one or more of the tax groups has turned out negative,
 - - The sum of surcharges and discounts within the receipt has remained negative,
 - - The journal is full


 <p>
 @param signPlu - The individual number of the item - a whole number between 1 and 999999999 (not more than 9 digits)(with sign "+" or "-" ).
 @param itemQuantity - The quantity of the items for sale with a default value of 1.000. Length cannot be longer than 8 meaningful digits (not more than 3 after the decimal point). The resulting singular price (*Quan) is rounded up to the set number of digits after the decimal point and also cannot be greater than 9 meaningful digits.
 @param specialTax - The dimensions of a single price. This value is subtracted from the single price before applying any VAT calculations and is printed on a separate line in the receipt. The accumulated value is stored in the fiscal memory and is printed in the Z-report an periodical reports, if not 0.
 @param sellWithAbsoluteSumDiscount - The value of discount or surcharge (depending on the sign) over the current sale. Up to 8 significant digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/
    -(bool)command58Variant2Version1SignPlu:(NSString *)signPlu itemQuantity:(NSString *)itemQuantity specialTax:(NSString *)specialTax sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
	
/**
3Ch(60) CANCEL FISCAL RECEIPT

<p>
 - Data field:	None
 - Response:	None

<p>
The command cancels an open fiscal receipt. 
All sales in the receipt are discarded. 
The message "===CANCELLED===" is printed and then the receipt is closed as non-fiscal. 
The command is not permitted, if command 53 (Total) is already executed for this receipt.


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command60Variant0Version0AndReturnError:(NSError **)error;
/**
3Dh(61) SETTING THE CLOCK - DATE AND HOUR

<p>
 - Data field:
		 -# targetDate
		 -# targetTime
 - Response:	None

<p>
You cannot set a date, which is earlier than the date of the last entry into the fiscal memory of device and the capacity of this memory includes the year 2099. 
After RESET of memory, this command must be executed - otherwise, the normal functioning of device cannot be resumed. 
The printer's real-time clock must always be set correctly.


 <p>
 @param targetDate - DD-MM-YY 
 @param targetTime - HH:MM[:SS]
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command61Variant0Version0TargetDate:(NSString *)targetDate targetTime:(NSString *)targetTime error:(NSError **)error;
/**
3Eh (62)	READING CURRENT DATE AND HOUR

<p>
 - Data field:	None
 - Response:
		 -# outputText	DD-MM-YY HH:MM:SS


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outputText" - DD-MM-YY HH:MM:SS
*/

    -(NSDictionary *)command62Variant0Version0AndReturnError:(NSError **)error;
/**
40h(64) LAST FISCAL CLOSURE DETAILS

<p>
 - Data field:	None
 - Response:
		 -# errorCode
		 -# receiptCount
		 -# totalSumInTaxGroupA
		 -# totalSumInTaxGroupB
		 -# totalSumInTaxGroupC
		 -# totalSumInTaxGroupD
		 -# totalSumInTaxGroupE
		 -# specialTaxSum
		 -# fiscalRecordDate

<p>

<p>
 - errorCode:
		 -# 'P'	Successful command. Data present after ',' symbol.
		 -# 'F'	Can't read last record. No data present.

<p>
 - receiptCount		Receipt count
 - totalSumInTaxGroupX	VAT group total (12 bytes with sign).
 - specialTax			Special tax sum (12 bytes with sign).
 - fiscalRecordDate		Closure date in format DDMMYY.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - 'P'	Successful command. Data present after ',' symbol.
'F'	Can't read last record. No data present.

 - KeyValue - \@"receiptCount" - Receipt count
 - KeyValue - \@"totalSumInTaxGroupA" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupB" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupC" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupD" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupE" - VAT group total (12 bytes with sign).
 - KeyValue - \@"specialTax" - Special tax sum (12 bytes with sign).
 - KeyValue - \@"fiscalRecordDate" - Closure date in format DDMMYY.
*/

    -(NSDictionary *)command64Variant0Version0AndReturnError:(NSError **)error;
/**
41h(65) DAILY TOTALS

<p>
 - Data field:	None
 - Response:
		 -# totalSumInTaxGroupA
		 -# totalSumInTaxGroupB
		 -# totalSumInTaxGroupC
		 -# totalSumInTaxGroupD
		 -# totalSumInTaxGroupE
		 -# specialTax

<p>
 - totalSumInTaxGroupX	VAT group total (12 bytes with sign).
 - specialTax			Special tax sum (12 bytes with sign).


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"totalSumInTaxGroupA" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupB" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupC" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupD" - VAT group total (12 bytes with sign).
 - KeyValue - \@"totalSumInTaxGroupE" - VAT group total (12 bytes with sign).
 - KeyValue - \@"specialTax" - Special tax sum (12 bytes with sign).
*/

    -(NSDictionary *)command65Variant0Version0AndReturnError:(NSError **)error;
/**
44h (68)	THE NUMBER OF FREE FIELDS IN THE FISCAL MEMORY

<p>
 - Data field:	None
 - Response:
		 -# logicalFiscalRecordsCount

<p>
 - logicalFiscalRecordsCount	The number of logical locations for fiscal entries (4 bytes)

<p>
The number of free fields in the fiscal memory, reserved for saving information from the daily report.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"logicalFiscalRecordsCount" - The number of logical locations for fiscal entries (4 bytes)
*/

    -(NSDictionary *)command68Variant0Version0AndReturnError:(NSError **)error;
/**
45h(69) DAILY FINANCIAL REPORT

<p>
 - Data field:
		 -# reportTypeOption
 - Response:
		 -# fiscalRecordNumber
		 -# totalSumForTheDay
		 -# totalSumInTaxGroupA,
		 -# totalSumInTaxGroupB,
		 -# totalSumInTaxGroupC,
		 -# totalSumInTaxGroupD,
		 -# totalSumInTaxGroupE,
		 -# totalSumInSpecialTax

<p>

<p>
 - reportTypeOption	Parameter controlling the type of generated report.
		 -# '0'	A Z-report is printed. The printout ends with inscriptions "NON-FISCAL RECEIPT" if the printer is not fiscalised.
		 -# '2'	A X-report is generated, i.e., no entry into the fiscal memory is made and no closures are performed. The printout ends with inscription "NON-FISCAL RECEIPT". The same actions may be generated directly from the printer if during switching on the "FEED" button is hold for 2 to 4 seconds.
		 -# N	The presence of this symbol at the end of the data cancels the option to clear the data accumulated on the operators during a Z-report.
		 -# A	The presence of this symbol at the end of the data cancels the option to clear the data about sold article quantities during a Z-report.

<p>
 - fiscalRecordNumber		Fiscal closure (Daily report) number - 4 bytes.
 - totalSumForTheDay		The sum of all sales for the day - 12 bytes with a sign.
 - totalSumInTaxGroupX	The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - totalSumInSpecialTax	Special tax sum (12 bytes with sign).

<p>
The command with option '0' (Z-report) must be executed immediately after printing and deleting the electronic journal. 
If there is information in the journal, the command is not permitted. 


 <p>
 @param reportTypeOption - Parameter controlling the type of generated report.
 - '0'	A Z-report is printed. The printout ends with inscriptions "NON-FISCAL RECEIPT" if the printer is not fiscalised.
 - '2'	A X-report is generated, i.e., no entry into the fiscal memory is made and no closures are performed. The printout ends with inscription "NON-FISCAL RECEIPT". The same actions may be generated directly from the printer if during switching on the \<FEED> button is hold for 2 to 4 seconds.
 - N	The presence of this symbol at the end of the data cancels the option to clear the data accumulated on the operators during a Z-report.
 - A	The presence of this symbol at the end of the data cancels the option to clear the data about sold article quantities during a Z-report.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Fiscal closure (Daily report) number - 4 bytes.
 - KeyValue - \@"totalSumForTheDay" - The sum of all sales for the day - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupA" - The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - KeyValue - \@"totalSumInSpecialTax" - TotF	The total under tax category - 12 bytes with a sign.
*/

    -(NSDictionary *)command69Variant0Version0ReportTypeOption:(NSString *)reportTypeOption error:(NSError **)error;
/**
46h(70) INTERNAL DEBITING AND CREDITING (servICE In and Out)

<p>
 - Data field:
		 -# amountInOut

<p>
 - Response:
		 -# exitCode
		 -# sumInCashRegister
		 -# totalForAllInputs
		 -# totalForOutputs

<p>

<p>
 - amountInOut	The sum, which will be registered (up to 9 bytes). Depending on the sign of the digit, this sum is interpreted either as credit or debit (serveIn or serveOut).
 - exitCode:
		 -# 'P'	The order has been completed. If the ordered sum is not 0, the printer will print an interior receipt for registering the operation.
		 -# 'F'	The order has been canceled. This happens if:
				 -# - the cash sum available is less than the ordered interior credit (serveIn),
				 -# - there is an opened fiscal and non-fiscal receipt.

<p>
 - sumInCashRegister		Available cash. Apart from this command, the sum grows after each payment in cash.
 - totalForAllInputs		The sum from all commands "Interior credit"
 - totalForOutputs		The sum from all commands "Interior debit"

<p>

<p>
Changes the content of the cash availability register. 
Depending on the sign of the sum in question, it is accumulated in the register for interior debit-credit. 
The information is not saved in the fiscal memory of device and is accessible until the performance of the daily closure. 
It is printed out at the command 69 (45h) and at the generation of the daily report without closure from the printer itself. 
At successful completion of this command, the drawer "kick-out" function is automatically activated.


 <p>
 @param amountInOut - The sum, which will be registered (up to 9 bytes). Depending on the sign of the digit, this sum is interpreted either as credit or debit (serveIn or serveOut).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"exitCode" - 'P'	The order has been completed. If the ordered sum is not 0, the printer will print an interior receipt for registering the operation.
'F'	The order has been canceled. This happens if:
		 -# - the cash sum available is less than the ordered interior credit (serveIn),
		 -# - there is an opened fiscal and non-fiscal receipt.

 - KeyValue - \@"sumInCashRegister" - Available cash. Apart from this command, the sum grows after each payment in cash.
 - KeyValue - \@"totalForAllInputs" - The sum from all commands "Interior credit"
 - KeyValue - \@"totalForOutputs" - The sum from all commands "Interior debit"
*/

    -(NSDictionary *)command70Variant0Version0AmountInOut:(NSString *)amountInOut error:(NSError **)error;
/**
46h(70) INTERNAL DEBITING AND CREDITING (read only)

<p>
 - Data field: None

<p>
 - Response:
		 -# exitCode
		 -# sumInCashRegister
		 -# totalForAllInputs
		 -# totalForOutputs

<p>

<p>
 - amountInOut	The sum, which will be registered (up to 9 bytes). Depending on the sign of the digit, this sum is interpreted either as credit or debit (serveIn or serveOut).
 - exitCode:
		 -# 'P'	The order has been completed. If the ordered sum is not 0, the printer will print an interior receipt for registering the operation.
		 -# 'F'	The order has been canceled. This happens if:
				 -# - the cash sum available is less than the ordered interior credit (serveIn),
				 -# - there is an opened fiscal and non-fiscal receipt.

<p>
 - sumInCashRegister		Available cash. Apart from this command, the sum grows after each payment in cash.
 - totalForAllInputs		The sum from all commands "Interior credit"
 - totalForOutputs		The sum from all commands "Interior debit"

<p>

<p>
Changes the content of the cash availability register. 
Depending on the sign of the sum in question, it is accumulated in the register for interior debit-credit. 
The information is not saved in the fiscal memory of device and is accessible until the performance of the daily closure. 
It is printed out at the command 69 (45h) and at the generation of the daily report without closure from the printer itself. 
At successful completion of this command, the drawer "kick-out" function is automatically activated.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"exitCode" - 'P'	The order has been completed. If the ordered sum is not 0, the printer will print an interior receipt for registering the operation.
'F'	The order has been canceled. This happens if:
		 -# - the cash sum available is less than the ordered interior credit (serveIn),
		 -# - there is an opened fiscal and non-fiscal receipt.

 - KeyValue - \@"sumInCashRegister" - Available cash. Apart from this command, the sum grows after each payment in cash.
 - KeyValue - \@"totalForAllInputs" - The sum from all commands "Interior credit"
 - KeyValue - \@"totalForOutputs" - The sum from all commands "Interior debit"
*/

    -(NSDictionary *)command70Variant0Version1AndReturnError:(NSError **)error;
/**
47h(71) PRINTING DIAGNOSTIC INFORMATION

<p>
 - Data field:	No data
 - Response:	None

<p>
The command initiates the generation of an interior receipt containing diagnostic information as follows:
 - - Prints the date and version of the employed software,
 - - Prints the control sum of the employed firmware,
 - - Prints the serial port's band rate,
 - - Prints out the status of memory switches,
 - - Prints emergency time after power supply cut-off,
 - - Prints the number, date and hour of the last reset of the RAM (if there is such),
 - - Prints the current temperature of the two printer heads,
 - - Prints the overall number of fields in the fiscal memory and the number of the free fields,
 - - Prints the current date and hour.

<p>
The command will not be executed when there is an open receipt in progress or when the paper roll has finished. 
It may also be activated by pressing the "FEED" button while power on for less than 2 seconds.

<p>


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command71Variant0Version0AndReturnError:(NSError **)error;
/**
49H (73)	DETAILED FISCAL MEMORY REPORT BY CLOSURE NUMBER

<p>
 - Data field:
		 -# startRecordNumber
		 -# endRecordNumber
 - Response:	None

<p>
 - startRecordNumber		The number of the starting fiscal entry - 4 bytes
 - endRecordNumber		The number of the ending fiscal entry - 4 bytes

<p>
The command leads to printing of a detailed report of the fiscal memory from one selected number to another.


 <p>
 @param startRecordNumber - The number of the starting fiscal entry - 4 bytes
 @param endRecordNumber - The number of the ending fiscal entry - 4 bytes
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command73Variant0Version0StartRecordNumber:(NSString *)startRecordNumber endRecordNumber:(NSString *)endRecordNumber error:(NSError **)error;
	
	
	
/**
4Ah(74) READING THE STATUS BYTES

<p>
 - Data field:	None
 - Response:
		 -# statusByte0	Status byte 0
		 -# statusByte1	Status byte 1
		 -# statusByte2	Status byte 2
		 -# statusByte3	Status byte 3
		 -# statusByte4	Status byte 4
		 -# statusByte5	Status byte 5

<p>
All printer buffers must be printed out first.

 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"statusByte0" - statusByte0
 - KeyValue - \@"statusByte1" - statusByte1
 - KeyValue - \@"statusByte2" - statusByte2
 - KeyValue - \@"statusByte3" - statusByte3
 - KeyValue - \@"statusByte4" - statusByte4
 - KeyValue - \@"statusByte5" - statusByte5
*/	
	-(NSDictionary *)command74Variant0Version0AndReturnError:(NSError **)error;
	
/**
4Ah(74) READING THE STATUS BYTES

<p>
 - Data field:	None
 - Response:
		 -# statusByte0	Status byte 0
		 -# statusByte1	Status byte 1
		 -# statusByte2	Status byte 2
		 -# statusByte3	Status byte 3
		 -# statusByte4	Status byte 4
		 -# statusByte5	Status byte 5

<p>
The status is returned immediately (default).


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"statusByte0" - statusByte0
 - KeyValue - \@"statusByte1" - statusByte1
 - KeyValue - \@"statusByte2" - statusByte2
 - KeyValue - \@"statusByte3" - statusByte3
 - KeyValue - \@"statusByte4" - statusByte4
 - KeyValue - \@"statusByte5" - statusByte5
*/
    -(NSDictionary *)command74Variant1Version0AndReturnError:(NSError **)error;
	
	
/**
4Ch(76) STATUS OF THE FISCAL TRANSACTION

<p>
 - Data field:	None
 - Repsonse:
		 -# receiptIsOpened
		 -# countOfRegisteredSales
		 -# lastFiscalReceiptAmount
		 -# lastFiscalReceiptTender

<p>
The command will return the information on the current state of the sum due for payment by client.

<p>
 - receiptIsOpened	One byte:
				 -# '1'   - if a fiscal or a non-fiscal receipt has been opened (which can be understood from the status bytes);
				 -# '0'   - if there is no opened receipt;

<p>
 - countOfRegisteredSales	The number of sales registered on the current or last fiscal receipt - 4 bytes.
 - lastFiscalReceiptAmount	The sum from the last fiscal receipt - 9 bytes with a sign.
 - lastFiscalReceiptTender	The sum tendered against the current or the last receipt - 9 bytes with a sign.

<p>
The command supports the PC application's ability to monitor the status and, if needed, to restore and complete an already started fiscal 
operation, which has been interrupted on emergency or out of time - for example, as a result of a power failure.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"receiptIsOpened" - One byte, which is
 - '1'   - if a fiscal or a non-fiscal receipt has been opened (which can be understood from the status bytes);
 - '0'   - if there is no opened receipt;

<p>

 - KeyValue - \@"countOfRegisteredSales" - The number of sales registered on the current or last fiscal receipt - 4 bytes.
 - KeyValue - \@"lastFiscalReceiptAmount" - The sum from the last fiscal receipt - 9 bytes with a sign.
 - KeyValue - \@"lastFiscalReceiptTender" - The sum tendered against the current or the last receipt - 9 bytes with a sign.
*/

    -(NSDictionary *)command76Variant0Version0AndReturnError:(NSError **)error;
/**
4Fh(79) SHORT FISCAL MEMORY REPORT BY CLOSURE DATE

<p>
 - Data field:
		 -# startDate
		 -# endDate
 - Response:	None

<p>
 - startDate	Starting date - 6 bytes (DDMMYY)
 - endDate	End date - 6 bytes (DDMMYY)

<p>
The command generates printing out of a short periodic financial report.


 <p>
 @param startDate - Starting date - 6 bytes (DDMMYY)
 @param endDate - End date - 6 bytes (DDMMYY)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command79Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
50h(80) SOUND SIGNAL

<p>
 - Data field:
		 -# soundData
 - Response:	None

<p>

<p>
If the input data looks like: \<Hz>,\<mSec> where Hz and mSec are integer numbers, then a sound signal with frequency Hz (100-5000) and duration mSec milliseconds (50-2000) is generated.
In all other cases data must be in format, similar to the one used for writing notes and can be of any length up to 218 bytes. 
The first invalid character cancels the command. SoundData format is a sequence of the following subcommands:
 - Notes of the scale: One latine letter with value from 'A' to 'G'.
		 -# 'C' - Do
		 -# 'D' - Re
		 -# 'E' - Mi
		 -# 'F' - Fa
		 -# 'G' - Sol
		 -# 'A' - La
		 -# 'B' - Si
		 -# If immediately after the note comes character '#', then the note is higher in pitch by a semitone (sharp). If immediately after the note comes character '&', then the note is lower in pitch by a semitone (flat).

<p>
 - Pause: Character space (ASCII 20h).
 - After a note or pause there can be one or a few bytes, which specify the duration. Valid are characters from '0' to '5', they have the following meaning:
		 -# '0'	basic duration of a note/pause
		 -# '1'	basic duration * 2
		 -# '2'	basic duration * 4
		 -# '3'	basic duration * 8
		 -# '4'	basic duration * 16
		 -# '5'	basic duration * 32
		 -# If there are a few durations one after another they are summed up.

<p>
 - Going to higher scale: character '+'.
 - Going to lower scale: character '-'.
 - Specifying tempo: character '^', followed by a number. The number specifies the percentage: duration of notes and intervals to basic duration. Values:
		 -# '1'	200 %
		 -# '2'	175 %
		 -# '3'	140 %
		 -# '4'	120 %
		 -# '5'	100 %
		 -# '6'	80 %
		 -# '7'	60 %
		 -# '8'	50 %
		 -# '9'	40 %
 - Return to scale 1 (it is default). Character '@'. Tone 'La' in it is 440 Hz.


 <p>
 @param soundData - 
<p>
If the input data looks like: \<Hz>,\<mSec> where Hz and mSec are integer numbers, then a sound signal with frequency Hz (100-5000) and duration mSec milliseconds (50-2000) is generated.
In all other cases data must be in format, similar to the one used for writing notes and can be of any length up to 218 bytes. 
The first invalid character cancels the command. SoundData format is a sequence of the following subcommands:
 - Notes of the scale: One latine letter with value from 'A' to 'G'.
		 -# 'C' - Do
		 -# 'D' - Re
		 -# 'E' - Mi
		 -# 'F' - Fa
		 -# 'G' - Sol
		 -# 'A' - La
		 -# 'B' - Si
		 -# If immediately after the note comes character '#', then the note is higher in pitch by a semitone (sharp). If immediately after the note comes character '&', then the note is lower in pitch by a semitone (flat).

<p>
 - Pause: Character space (ASCII 20h).
 - After a note or pause there can be one or a few bytes, which specify the duration. Valid are characters from '0' to '5', they have the following meaning:
		 -# '0'	basic duration of a note/pause
		 -# '1'	basic duration * 2
		 -# '2'	basic duration * 4
		 -# '3'	basic duration * 8
		 -# '4'	basic duration * 16
		 -# '5'	basic duration * 32
		 -# If there are a few durations one after another they are summed up.

<p>
 - Going to higher scale: character '+'.
 - Going to lower scale: character '-'.
 - Specifying tempo: character '^', followed by a number. The number specifies the percentage: duration of notes and intervals to basic duration. Values:
		 -# '1'	200 %
		 -# '2'	175 %
		 -# '3'	140 %
		 -# '4'	120 %
		 -# '5'	100 %
		 -# '6'	80 %
		 -# '7'	60 %
		 -# '8'	50 %
		 -# '9'	40 %
 - Return to scale 1 (it is default). Character '@'. Tone 'La' in it is 440 Hz.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command80Variant0Version0SoundData:(NSString *)soundData error:(NSError **)error;
/**
53h(83) SETTING THE MULTIPLIER, DECIMALS, CURRENCY NAME AND DISABLED TAXES
 - Data fields:
		 -# inputMultiplier
		 -# inputDecimals
		 -# inputCurrency
		 -# inputEnabledTaxesArray
		 -# inputTaxGroupA
		 -# inputTaxGroupB
		 -# inputTaxGroupC
		 -# inputTaxGroupD

<p>
 - Response:
		 -# outputMultiplier
		 -# outputDecimals
		 -# outputCurrency
		 -# outputEnabledTaxesArray
		 -# outputTaxGroupA
		 -# outputTaxGroupB
		 -# outputTaxGroupC
		 -# outputTaxGroupD

<p>
 - (input/output)Multiplier		A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value (at present deactivated and out of use).
 - (input/output)Decimals		One byte with a value 0 or 2 and shows the exact place of the decimal point.
 - (input/output)Currency		The currency name. Up to 6 bytes.
 - (input/output)EnabledTaxesArray	4 bytes with value '0' or '1', corresponding to VAT groups 'A', 'B', 'C', 'D'. '0' means disabled VAT group, '1' - enabled VAT group.
 - (input/output)TaxGroupX		The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).

<p>
If nothing is entered in the data field, the FP returns the currently valid values. Even when only one of the parameters must be changed, the rest must be entered too.
The fiscal memory has a fixed capacity for a set number of entries, and for that reason the command can be performed not more than 20 times after the fiscalisation. 
Before the fiscalisation the data are hold in RAM only and may be changed without limitations. 
The command may be executed only before the first fiscal receipt for the day.


 <p>
 @param inputMultiplier - A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value (at present deactivated and out of use).
 @param inputDecimals - One byte with a value 0 or 2 and shows the exact place of the decimal point.
 @param inputCurrency - The currency name. Up to 6 bytes.
 @param inputEnabledTaxesArray - 4 bytes with value '0' or '1', corresponding to VAT groups 'A', 'B', 'C', 'D'. '0' means disabled VAT group, '1' - enabled VAT group. 
 @param inputTaxGroupA - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 @param inputTaxGroupB - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 @param inputTaxGroupC - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 @param inputTaxGroupD - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outputMultiplier" - A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value (at present deactivated and out of use).
 - KeyValue - \@"outputDecimals" - One byte with a value 0 or 2 and shows the exact place of the decimal point.
 - KeyValue - \@"outputCurrency" - The currency name. Up to 6 bytes.
 - KeyValue - \@"outputEnabledTaxesArray" - 4 bytes with value '0' or '1', corresponding to VAT groups 'A', 'B', 'C', 'D'. '0' means disabled VAT group, '1' - enabled VAT group. 
 - KeyValue - \@"outputTaxGroupA" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxGroupB" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxGroupC" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxGroupD" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
*/

    -(NSDictionary *)command83Variant0Version0InputMultiplier:(NSString *)inputMultiplier inputDecimals:(NSString *)inputDecimals inputCurrency:(NSString *)inputCurrency inputEnabledTaxesArray:(NSString *)inputEnabledTaxesArray inputTaxGroupA:(NSString *)inputTaxGroupA inputTaxGroupB:(NSString *)inputTaxGroupB inputTaxGroupC:(NSString *)inputTaxGroupC inputTaxGroupD:(NSString *)inputTaxGroupD error:(NSError **)error;
/**
53h(83) SETTING THE MULTIPLIER, DECIMALS, CURRENCY NAME AND DISABLED TAXES
 - Data fields: None

<p>
 - Response:
		 -# outputMultiplier
		 -# outputDecimals
		 -# outputCurrency
		 -# outputEnabledTaxesArray
		 -# outputTaxGroupA
		 -# outputTaxGroupB
		 -# outputTaxGroupC
		 -# outputTaxGroupD

<p>
 - (input/output)Multiplier		A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value (at present deactivated and out of use).
 - (input/output)Decimals		One byte with a value 0 or 2 and shows the exact place of the decimal point.
 - (input/output)Currency		The currency name. Up to 6 bytes.
 - (input/output)EnabledTaxesArray	4 bytes with value '0' or '1', corresponding to VAT groups 'A', 'B', 'C', 'D'. '0' means disabled VAT group, '1' - enabled VAT group.
 - (input/output)TaxGroupX		The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).

<p>
If nothing is entered in the data field, the FP returns the currently valid values. Even when only one of the parameters must be changed, the rest must be entered too.
The fiscal memory has a fixed capacity for a set number of entries, and for that reason the command can be performed not more than 20 times after the fiscalisation. 
Before the fiscalisation the data are hold in RAM only and may be changed without limitations. 
The command may be executed only before the first fiscal receipt for the day.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outputMultiplier" - A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value (at present deactivated and out of use).
 - KeyValue - \@"outputDecimals" - One byte with a value 0 or 2 and shows the exact place of the decimal point.
 - KeyValue - \@"outputCurrency" - The currency name. Up to 6 bytes.
 - KeyValue - \@"outputEnabledTaxesArray" - 4 bytes with value '0' or '1', corresponding to VAT groups 'A', 'B', 'C', 'D'. '0' means disabled VAT group, '1' - enabled VAT group. 
 - KeyValue - \@"outputTaxA" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxB" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxC" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
 - KeyValue - \@"outputTaxD" - The VAT rate for the corresponding VAT group in % with up to 2 decimals (0.00 to 99.00).
*/

    -(NSDictionary *)command83Variant1Version0AndReturnError:(NSError **)error;
/**
54h(84) PRINTING A BAR CODE

<p>
The command prints a bar code. It is permitted in an open fiscal or non-fiscal receipt. Bar code is printed centered. 
Note: Below the bar code is printed the information as text.

<p>

<p>
 - Data field:
		 -# barcodeType
		 -# barcodeData
 - Response:	None

<p>
 - barcodeType	Bar code type. One byte with value:
				 -# '1'	EAN8. Data contain only digits and is 7 bytes long. Check sum is calculated by the printer.
				 -# '2'	EAN13. Data contain only digits and is 12 bytes long. Check sum is calculated by the printer.
				 -# '3'	Code 128. Data contain symbols with ASCII from 32 to 127. Length is from 9 to 18 symbols (depends on the contents - maximum length is possible if all symbols are digits). Check sum is calculated by the printer.
				 -# '4'	ITF (Interleaved 2 of 5). Data contain only digits.
				 -# '5'	ITF (Interleaved 2 of 5). Data contain only digits. Check sum is calculated and printed by the printer.
 - barcodeData
		 -# - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
		 -# - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
		 -# - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
		 -# (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
		 -# - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
		 -# - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
		 -# and printed.

<p>

<p>
If data length is wrong or invalid characters are used, the "Syntax error" status is set and nothing is printed.
Bar code length is ser using command 43.


 <p>
 @param barcodeType - Bar code type. One byte with value:
 - '1'	EAN8. Data contain only digits and is 7 bytes long. Check sum is calculated by the printer.
 - '2'	EAN13. Data contain only digits and is 12 bytes long. Check sum is calculated by the printer.
 - '3'	Code 128. Data contain symbols with ASCII from 32 to 127. Length is from 9 to 18 symbols (depends on the contents - maximum length is possible if all symbols are digits). Check sum is calculated by the printer.
 - '4'	ITF (Interleaved 2 of 5). Data contain only digits.
 - '5'	ITF (Interleaved 2 of 5). Data contain only digits. Check sum is calculated and printed by the printer.

 @param barcodeData - BC_Data

<p>
 - - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
 - - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
 - - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
 - (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
 - and printed.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command84Variant0Version0BarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData error:(NSError **)error;
/**
54h(84) PRINTING A BAR CODE

<p>
The command prints a bar code. It is permitted in an open fiscal or non-fiscal receipt. Bar code is printed centered. 

<p>

<p>

<p>
 - Data field:
		 -# barcodeType
		 -# barcodeData
 - Response:	None

<p>
 - barcodeType	Bar code type. One byte with value:
				 -# '1'	EAN8. Data contain only digits and is 7 bytes long. Check sum is calculated by the printer.
				 -# '2'	EAN13. Data contain only digits and is 12 bytes long. Check sum is calculated by the printer.
				 -# '3'	Code 128. Data contain symbols with ASCII from 32 to 127. Length is from 9 to 18 symbols (depends on the contents - maximum length is possible if all symbols are digits). Check sum is calculated by the printer.
				 -# '4'	ITF (Interleaved 2 of 5). Data contain only digits.
				 -# '5'	ITF (Interleaved 2 of 5). Data contain only digits. Check sum is calculated and printed by the printer.
 - barcodeData
		 -# - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
		 -# - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
		 -# - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
		 -# (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
		 -# - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
		 -# - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
		 -# and printed.

<p>

<p>
If data length is wrong or invalid characters are used, the "Syntax error" status is set and nothing is printed.
Bar code length is ser using command 43.


 <p>
 @param barcodeType - Bar code type. One byte with value:
 - '1'	EAN8. Data contain only digits and is 7 bytes long. Check sum is calculated by the printer.
 - '2'	EAN13. Data contain only digits and is 12 bytes long. Check sum is calculated by the printer.
 - '3'	Code 128. Data contain symbols with ASCII from 32 to 127. Length is from 9 to 18 symbols (depends on the contents - maximum length is possible if all symbols are digits). Check sum is calculated by the printer.
 - '4'	ITF (Interleaved 2 of 5). Data contain only digits.
 - '5'	ITF (Interleaved 2 of 5). Data contain only digits. Check sum is calculated and printed by the printer.

 @param barcodeData - BC_Data

<p>
 - - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
 - - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
 - - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
 - (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
 - and printed.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command84Variant0Version1BarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData error:(NSError **)error;
/**
55H(85) DIFINE ADDITIONAL PAYMENT TYPES NAME

<p>
 - Data field:
		 -# additionalPaymentTypeOption:
			 -# 'I'	Additional payment 1
			 -# 'J'	Additional payment 2
			 -# 'K'	Additional payment 3
			 -# 'L'	Additional payment 4
		 -# inputAdditionalPaymentName:	Comment text of the payment. Up to 31 bytes. If not present, the current name is returned.

<p>
 - Response:
		 -# outputText:
			 -# 'P'	No error.
			 -# 'F'	Name longer than 31 bytes.

<p>
The command defines the comment text, printed before the additional (programmable) payments. 
The command is not permitted after the first fiscal receipt for the day.


 <p>
 @param additionalPaymentTypeOption -  - 'I'	Additional payment 1
 - 'J'	Additional payment 2
 - 'K'	Additional payment 3
 - 'L'	Additional payment 4

 @param inputAdditionalPaymentName - Comment text of the payment. Up to 31 bytes. If not present, the current name is returned.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outputText" -  - 'P'	No error.
 - 'F'	Name longer than 31 bytes.

*/

    -(NSDictionary *)command85Variant0Version0AdditionalPaymentTypeOption:(NSString *)additionalPaymentTypeOption inputAdditionalPaymentName:(NSString *)inputAdditionalPaymentName error:(NSError **)error;
/**
55H(85) DIFINE ADDITIONAL PAYMENT TYPES NAME

<p>
 - Data field:
		 -# additionalPaymentTypeOption:
			 -# 'I'	Additional payment 1
			 -# 'J'	Additional payment 2
			 -# 'K'	Additional payment 3
			 -# 'L'	Additional payment 4
 - Response:
		 -# outputAdditionalPaymentName: Comment text of the payment. Up to 31 bytes. If not present, the current name is returned.


 <p>
 @param additionalPaymentTypeOption - 
<p>
 - 'I'	Additional payment 1
 - 'J'	Additional payment 2
 - 'K'	Additional payment 3
 - 'L'	Additional payment 4

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outputAdditionalPaymentName" - Comment text of the payment. Up to 31 bytes. If not present, the current name is returned.
*/

    -(NSDictionary *)command85Variant0Version1AdditionalPaymentTypeOption:(NSString *)additionalPaymentTypeOption error:(NSError **)error;
/**
56H(86) GET LATEST FISCAL MEMORY RECORD DATE

<p>
 - Data field:
			 -# None
 - Response:
			 -# lastFiscalMemoryDate	Date of last (latest) record in the fiscal memory in format:DD-MM-YYYY


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"lastFiscalMemoryDate" - Date of last (latest) record in the fiscal memory in format:DD-MM-YYYY
*/

    -(NSDictionary *)command86Variant0Version0AndReturnError:(NSError **)error;
/**
 57H(87) GET SHIFT LENGTH
 
 <p>
 - Data field:  None
 - Response:  secondsAfterFirstReceipt
 
 <p>
 - secondsAfterFirstReceipt Seconds count after the first fiscal receipt for the day.
 
 <p>
 Opening fiscal receipt will be blocked if this count is > 86400 (24 hours).
 
 
 <p>
 
 <p>
 @return NSDictionary
 - KeyValue - \@"secondsAfterFirstReceipt" - Seconds count after the first fiscal receipt for the day.
 */
-(NSDictionary *)command87Variant0Version0AndReturnError:(NSError **)error;

/**
5Ah(90) RETURNS DIAGONSTIC INFORMATION

<p>
 - Data field:
		 -# None
 - Response:
		 -# printerName		Fiscal device name.
		 -# firmwareRevision		The version of the software program - 4 bytes.
		 -# firmwareDate		The date of the software program DDMmmYY - 7 bytes.
		 -# firmwareTime		Hour of the software program HHMM - 4 bytes.
		 -# checkSum			The EPROM control sum - a 4 bytes string in the hexadecimal code.
		 -# softwareSwitches		The configuration switches from Sw1 to Sw8 - an 8 bytes string with '0' or '1'.
		 -# serialNumber		The serial number - 8 bytes.
		 -# fiscalMemoryNumber	Number of the fiscal module - 8 bytes.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printerName" - Fiscal device name.
 - KeyValue - \@"firmwareRevision" - The version of the software program - 4 bytes.
 - KeyValue - \@"firmwareDate" - The date of the software program DDMmmYY - 7 bytes.
 - KeyValue - \@"firmwareTime" - Hour of the software program HHMM - 4 bytes.
 - KeyValue - \@"checkSum" - The EPROM control sum - a 4 bytes string in the hexadecimal code. 
 - KeyValue - \@"softwareSwitches" - The configuration switches from Sw1 to Sw8 - an 8 bytes string with '0' or '1'.
 - KeyValue - \@"serialNumber" - The serial number - 8 bytes.
 - KeyValue - \@"fiscalMemoryNumber" - Number of the fiscal module - 8 bytes.
*/
    -(NSDictionary *)command90Variant0Version0AndReturnError:(NSError **)error;
	
/**
5Ah(90) RETURNS DIAGONSTIC INFORMATION

<p>
 - Data field:
		 -# None
 - Response:
		 -# printerName		Fiscal device name.
		 -# firmwareRevision		The version of the software program - 4 bytes.
		 -# firmwareDate		The date of the software program DDMmmYY - 7 bytes.
		 -# firmwareTime		Hour of the software program HHMM - 4 bytes.
		 -# checkSum			The EPROM control sum - a 4 bytes string in the hexadecimal code.
		 -# printerIsDiscoverable		'0' or '1'. The printer is  bluetooth discoverable if the value is 1.
		 -# serialNumber		The serial number - 8 bytes.
		 -# fiscalMemoryNumber	Number of the fiscal module - 8 bytes.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printerName" - Fiscal device name.
 - KeyValue - \@"firmwareRevision" - The version of the software program - 4 bytes.
 - KeyValue - \@"firmwareDate" - The date of the software program DDMmmYY - 7 bytes.
 - KeyValue - \@"firmwareTime" - Hour of the software program HHMM - 4 bytes.
 - KeyValue - \@"checkSum" - The EPROM control sum - a 4 bytes string in the hexadecimal code.
 - KeyValue - \@"printerIsDiscoverable" - '0' or '1'. The printer is  bluetooth discoverable if the value is 1
 - KeyValue - \@"serialNumber" - The serial number - 8 bytes.
 - KeyValue - \@"fiscalMemoryNumber" - Number of the fiscal module - 8 bytes.
*/
    -(NSDictionary *)command90Variant0Version1AndReturnError:(NSError **)error;
/**
5Eh(94) DETAILED FISCAL MEMORY REPORT BY CLOSURE DATE

<p>
 - Data field:
			 -# startDate
			 -# endDate
 - Response:		None

<p>
 - startDate		Starting date of selected fiscal entry - 6 bytes DDMMYY
 - endDate		End date of the fiscal entry - 6 bytes DDMMYY

<p>
This command prints out a detailed financial report of the period between two selected dates.


 <p>
 @param startDate - Starting date of selected fiscal entry - 6 bytes (DDMMYY)
 @param endDate - End date of the fiscal entry - 6 bytes (DDMMYY)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command94Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
5Fh(95) SHORT FISCAL MEMORY REPORT BY CLOSURE NUMBER

<p>
 - Data field:
			 -# startFiscalRecordNumber
			 -# endFiscalRecordNumber
 - Response:	None

<p>
 - startFiscalRecordNumber	Starting number of fiscal entry
 - endFiscalRecordNumber	End number of fiscal entry

<p>
The command starts the calculation and the printing of a short periodic financial report.


 <p>
 @param startFiscalRecordNumber - Starting number of fiscal entry
 @param endFiscalRecordNumber - End number of fiscal entry
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command95Variant0Version0StartFiscalRecordNumber:(NSString *)startFiscalRecordNumber endFiscalRecordNumber:(NSString *)endFiscalRecordNumber error:(NSError **)error;
/**
61h(97) READING THE SET TAX RATES

<p>
 - Data field:		None
 - Response:
			 -# taxGroupA
			 -# taxGroupB
			 -# taxGroupC
			 -# taxGroupD

<p>
 - taxGroupA	Current tax rate A
 - taxGroupB	Current tax rate B
 - taxGroupC	Current tax rate C
 - taxGroupD	Current tax rate D


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"taxGroupA" - Current tax rate A
 - KeyValue - \@"taxGroupB" - Current tax rate B
 - KeyValue - \@"taxGroupC" - Current tax rate C
 - KeyValue - \@"taxGroupD" - Current tax rate D
*/

    -(NSDictionary *)command97Variant0Version0AndReturnError:(NSError **)error;
/**
63h(99) Reading the TAX REGISTRATION NUMBER

<p>
 - Data field:	None
 - Response:
		 -# vatNumber

<p>
 - vatNumber	The VAT number as a text (up to 14 bytes).


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"vatNumber" - The VAT number as a text (up to 14 bytes).
*/

    -(NSDictionary *)command99Variant0Version0AndReturnError:(NSError **)error;
/**
65h(101) SETTING THE OPERATOR'S PASSWORD

<p>
 - Data field:
		 -# operatorCode		Operator's code (1 to 16)
		 -# oldOperatorPassword	Old password (4 to 8 digits)
		 -# newOperatorPassword	New password (4 to 8 digits)

<p>
 - Response:
		 -# None

<p>

<p>
Sets one of the 16 operator's passwords, which will be demanded upon opening a fiscal receipt. 
After three erroneous password entries, the printer will block, it must then be switched OFF and ON again to continue operating.
After initialization or reset of the operational memory, all 16 passwords are "0000".


 <p>
 @param operatorCode - Operator's code (1 to 16)
 @param oldOperatorPassword - Old password (4 to 8 digits)
 @param newOperatorPassword - New password (4 to 8 digits)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command101Variant0Version0OperatorCode:(NSString *)operatorCode oldOperatorPassword:(NSString *)oldOperatorPassword newOperatorPassword:(NSString *)newOperatorPassword error:(NSError **)error;
/**
66h(102) ENTERING OPERATOR'S NAME

<p>
 - Data field:
		 -# OpCode	Operator's code (1 to 16)
		 -# Pwd	Password (4 to 8 digits)
		 -# OpName	Name of the operator (up to 30 symbols)
 - Response:
		 -# None

<p>

<p>

<p>
Enters one of the 16 operator names. The number and name of the operator are printed at the beginning of each fiscal (clients) receipt. 
After three erroneous password entries, the printer will block, it must then be switched OFF and ON again to continue operating. 
After initialization or reset of the operational memory, all 16 password locations are empty.


 <p>
 @param operatorCode - Operator's code (1 to 16)
 @param operatorPassword - Password (4 to 8 digits)
 @param operatorName - Name of the operator (up to 30 symbols)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command102Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword operatorName:(NSString *)operatorName error:(NSError **)error;
/**
67h(103) INFORMATION ON THE CURRENT RECEIPT

<p>
 - Data field:	None
 - Response:
		 -# saleVoidIsPossible	Possible/impossible return (sale registration with a negative sign) ['0' / '1']
		 -# taxGroupA	The sum accumulated under tax A
		 -# taxGroup|B	The sum accumulated under tax B
		 -# taxGroupC	The sum accumulated under tax C
		 -# taxGroupD	The sum accumulated under tax D
		 -# taxGroupE	The sum accumulated under tax E
		 -# SpecTax		The special tax sum

<p>
The command offers information on sums accumulated so far under the different tax groups and whether it is possible to return the registered 
items sold.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"saleVoidIsPossible" - Possible/impossible return (sale registration with a negative sign) ['0' / '1']
 - KeyValue - \@"taxGroupA" - The sum accumulated under tax A
 - KeyValue - \@"taxGroupB" - The sum accumulated under tax B
 - KeyValue - \@"taxGroupC" - The sum accumulated under tax C
 - KeyValue - \@"taxGroupD" - The sum accumulated under tax D
 - KeyValue - \@"taxGroupE" - The sum accumulated under tax E
 - KeyValue - \@"specialTax" - The special tax sum
*/

    -(NSDictionary *)command103Variant0Version0AndReturnError:(NSError **)error;
/**
68h(105) OPERATOR'S REPORT

<p>
 - Data field:	None
 - Response:	None

<p>
Information on the sales, performed by the operators, is printed out where for each separate operator the following data is printed out: 
name, individual number, number of fiscal receipts, discharges made, surcharge, sum adjustments and accumulated total sums.


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command105Variant0Version0AndReturnError:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
 - Data field:
			 -# None
 - Response:
			 -# errorCode - One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command
			 -# maximumItemCount		Total programmable article count (13000 for this printer).
			 -# currentItemCount		Programmed article count.
			 -# maximumItemNameLength	Maximal article name length (36 for this printer).

<p>

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"maximumItemCount" - Total programmable article count (13000 for this printer).
 - KeyValue - \@"currentItemCount" - Programmed article count.
 - KeyValue - \@"maximumItemNameLength" - Maximal article name length (36 for this printer).
*/

    -(NSDictionary *)command107Variant0Version0AndReturnError:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
 - Input data:
			 -# taxGroup
			 -# itemPlu
			 -# itemGroup
			 -# singleItemPrice
			 -# replaceQuantity
			 -# itemQuantity
			 -# itemName
 - Response:
			 -# ErrorCode

<p>

<p>
 - taxGroup		Tax group. One byte ('A', 'B', 'C',  'D' or 'E').
 - itemPlu		Number of the item (1 to 999999999)
 - itemGroup	Article group (1 - 99).
 - singleItemPrice	Singular price - up to 8 meaningful digits.
 - replaceQuantity	A non-mandatory parameter - one byte with value 'A'. Changes the meaning of the next parameter (Quantity).
 - itemQuantity	A number with up to 3 decimals - the available quantity of the article. If Replace is present, then the available quantity is replaced with this parameter, otherwise it is added to the old value (if the article is already programmed, of course). Every sale command of this article will decrease this value.
 - itemName		Name of the item - up to 36 bytes.

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Up to 13000 different items may be programmed and the command will be rejected if a similar item has already been programmed in the memory of printer and sales of this item have been registered.

<p>


 <p>
 @param taxGroup - Tax group. One byte ('A', 'B', 'C',  'D' or 'E').
 @param itemPlu - Number of the item (1 to 999999999)
 @param itemGroup - Article group (1 - 99).
 @param singleItemPrice - Singular price - up to 8 meaningful digits.
 @param replaceQuantity - A non-mandatory parameter - one byte with value 'A'. Changes the meaning of the next parameter (Quantity).
 @param itemQuantity - A number with up to 3 decimals - the available quantity of the article. 
If Replace is present, then the available quantity is replaced with this parameter, otherwise it is added to the old value (if the article is already programmed, of course).
Every sale command of this article will decrease this value.

 @param itemName - Name of the item - up to 36 bytes.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant1Version0TaxGroup:(NSString *)taxGroup itemPlu:(NSString *)itemPlu itemGroup:(NSString *)itemGroup singleItemPrice:(NSString *)singleItemPrice replaceQuantity:(NSString *)replaceQuantity itemQuantity:(NSString *)itemQuantity itemName:(NSString *)itemName error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>

<p>
 - Input data:
			 -# itemPlu
			 -# itemQuantity
 - Response:
			 -# ErrorCode

<p>
 - itemPlu		Article number (1 to 999999999).
 - itemQuantity	Quantity correction - a floating-point number with 3 decimal places. Positive number increases the available quantity, negative decreases it.

<p>

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Changing the quantity is possible, if the article is programmed.

<p>


 <p>
 @param itemPlu - Article number (1 to 999999999).
 @param itemQuantity - Quantity correction - a floating-point number with 3 decimal places. Positive number increases the available quantity, negative decreases it.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant2Version0ItemPlu:(NSString *)itemPlu itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Change the price of an item

<p>
 - Input data:
			 -# itemPlu
			 -# singleItemPrice
 - Response:
			 -# ErrorCode

<p>
 - itemPlu		Article number (1 to 999999999).
 - singleItemPrice	Singular price - up to 8 meaningful digits.

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Changing the price is possible, if the article is programmed and no sales of this article are made in the fiscal receipt (if a fiscal receipt is open).


 <p>
 @param itemPlu - Article number (1 to 999999999).
 @param singleItemPrice - Singular price - up to 8 meaningful digits.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant3Version0ItemPlu:(NSString *)itemPlu singleItemPrice:(NSString *)singleItemPrice error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Delete all items with non-zero accumulated sums.

<p>
 - Input data:
			 -# None
 - Responce:
			 -# ErrorCode

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
NOTE:
Delete all items with non-zero accumulated sums.

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant4Version0AndReturnError:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>

<p>
 - Input data:
			 -# itemPlu
 - Responce:
			 -# errorCode

<p>
 - itemPlu		Deletes article with selected number if there are no accumulated sums.

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Note:
Deletes article with selected number if there are no accumulated sums.


 <p>
 @param itemPlu - Deletes article with selected number if there are no accumulated sums.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant4Version1ItemPlu:(NSString *)itemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>

<p>
 - Input data:
			 -# startItemPlu
			 -# lastItemPlu
 - Responce:
			 -# errorCode

<p>
 - startItemPlu,lastItemPlu	Deletes the articles within a set interval which do not have accumulated sums.

<p>

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Note:
Deletes the articles within a set interval which do not have accumulated sums.


 <p>
 @param startItemPlu - Starting number
 @param lastItemPlu - Last number (End of the interval) 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command107Variant4Version2StartItemPlu:(NSString *)startItemPlu lastItemPlu:(NSString *)lastItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Reading Item data

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>

<p>
If the item cannot be found, one 'F' byte is returned.

<p>


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant5Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the first found programmed item.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
If the parameter PLU is present, then the first programmed article with number greater than or equal to PLU is returned. If missing, PLU=1 is assumed. 
The returned data is similar to the: "command107Variant5Version0"


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant6Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the programmed item with the greatest number.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
If the parameter PLU is present, then the first programmed article with number lower than or equal to PLU is returned. 
If missing, PLU=999999999 is assumed.

<p>


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant7Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the next found programmed item. 
Depending of the starting command, the articles are enumerated in ascending or descending order.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
The last three commands are used to receive a list of programmed items. 
The subcommand 'F' or 'L' is followed by 'N' until the response 'F' comes. 
This means that the process of reading has ended with the last available item.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant8Version0AndReturnError:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the first sold item.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
If the parameter PLU is present, then the first sold article with number greater than or equal to PLU is returned. 
If missing, PLU=1 is assumed.


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant9Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the sold item with the greatest number.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
If the parameter PLU is present, then the first sold article with number lower than or equal to PLU is returned. 
If missing, PLU=999999999 is assumed.


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant10Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the next found sold item. 
Depending of the starting command, the articles are enumerated in ascending or descending order.

<p>
 - Input data:
			 -# targetItemPlu
 - Responce:
			 -# errorCode
			 -# itemPlu
			 -# taxGroup
			 -# itemGroup
			 -# singleItemPrice
			 -# accumulatedSum
			 -# soldItemQuantity
			 -# availableItemQuantity
			 -# itemName

<p>
 - targetItemPlu	Individual number of the item. 9 digits (000000001 to 999999999)
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)
 - taxGroup			Tax group - 1 byte
 - itemGroup		Article group. 2 digits (01 - 99).
 - singleItemPrice		Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - accumulatedSum		Accumulated sum for this article.
 - soldItemQuantity		Accumulated quantity - a floating-point number with 3 decimal places.
 - availableItemQuantity		Available quantity of this article.
 - itemName			The name of the item. Up to 36 symbols.

<p>
Note:
The process of reading has ended with the last available item.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available quantity of this article.
 - KeyValue - \@"itemName" - The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant11Version0AndReturnError:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the first free item.

<p>
 - Input data:		targetItemPlu
 - Responce:		errorCode
			 -# itemPlu

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)

<p>
If the parameter PLU is present, then the first free (not programmed) article with number greater than or equal to PLU is returned. 
If missing, PLU=1 is assumed.


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
*/

    -(NSDictionary *)command107Variant12Version0TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Bh(107) DEFINING AND READING ITEMS

<p>
Returning the data on the last free item.

<p>
 - Input data:		targetItemPlu
 - Responce:		errorCode
			 -# itemPlu

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>
 - itemPlu			Individual number of the item. 9 digits (000000001 to 999999999)

<p>
If the parameter PLU is present, then the first free (not programmed) article with number lower than or equal to PLU is returned. 
If missing, PLU=999999999 is assumed.


 <p>
 @param targetItemPlu - Individual number of the item. 9 digits (000000001 to 999999999)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

 - KeyValue - \@"itemPlu" - Individual number of the item. 9 digits (000000001 to 999999999)
*/

    -(NSDictionary *)command107Variant12Version1TargetItemPlu:(NSString *)targetItemPlu error:(NSError **)error;
/**
6Ch (108)	EXTENDED DAILY FINANCIAL REPORT

<p>
 - Data field:
		 -# reportTypeOption
 - Response:
		 -# fiscalRecordNumber
		 -# totalSumForTheDay
		 -# totalSumInTaxGroupA,
		 -# totalSumInTaxGroupB,
		 -# totalSumInTaxGroupC,
		 -# totalSumInTaxGroupD,
		 -# totalSumInTaxGroupE,
		 -# totalSumInSpecialTax

<p>

<p>
 - reportTypeOption	Parameter controlling the type of generated report.
		 -# '0'	A Z-report is printed. The printout ends with inscriptions "NON-FISCAL RECEIPT" if the printer is not fiscalised.
		 -# '2'	A X-report is generated, i.e., no entry into the fiscal memory is made and no closures are performed. The printout ends with inscription "NON-FISCAL RECEIPT". The same actions may be generated directly from the printer if during switching on the "FEED" button is hold for 2 to 4 seconds.
		 -# N	The presence of this symbol at the end of the data cancels the option to clear the data accumulated on the operators during a Z-report.
		 -# A	The presence of this symbol at the end of the data cancels the option to clear the data about sold article quantities during a Z-report.

<p>
 - fiscalRecordNumber		Fiscal closure (Daily report) number - 4 bytes.
 - totalSumForTheDay		The sum of all sales for the day - 12 bytes with a sign.
 - totalSumInTaxGroupX	The totals under all tax categories - A, B, C, D and E - 12 bytes with a sign.
 - totalSumInSpecialTax	Special tax sum (12 bytes with sign).

<p>
The command with option '0' (Z-report) must be executed immediately after printing and deleting the electronic journal. 
If there is information in the journal, the command is not permitted.
In the beginning is printed a list of the sold articles with PLU's less or equal than 100.


 <p>
 @param reportTypeOption - Parameter controlling the type of generated report.
 - '0'	A Z-report is printed. The printout ends with inscriptions "NON-FISCAL RECEIPT" if the printer is not fiscalised.
 - '2'	A X-report is generated, i.e., no entry into the fiscal memory is made and no closures are performed. The printout ends with inscription "NON-FISCAL RECEIPT". The same actions may be generated directly from the printer if during switching on the \<FEED> button is hold for 2 to 4 seconds.
 - N	The presence of this symbol at the end of the data cancels the option to clear the data accumulated on the operators during a Z-report.
 - A	The presence of this symbol at the end of the data cancels the option to clear the data about sold article quantities during a Z-report.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Fiscal closure (Daily report) number - 4 bytes.
 - KeyValue - \@"totalSumForTheDay" - The sum of all sales for the day - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupA" - The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInSpecialTax" - Special tax sum (12 bytes with sign).
*/

    -(NSDictionary *)command108Variant0Version0ReportTypeOption:(NSString *)reportTypeOption error:(NSError **)error;
/**
6Dh(109) PRINTING A DUPLICATE RECEIPT

<p>

<p>
 - Data field:		receiptCount
 - Response:		None

<p>

<p>
 - receiptCount	Number of duplicate receipts (only a value of 1 or 2 is accepted!).

<p>
The command initiates the printing of a copy of the last closed receipt containing registered sales. 
Immediately after the tax registration number the inscription "DUPLICATE" is printed out in bold letters.
The printer will refuse to execute this command twice.


 <p>
 @param receiptCount - Number of duplicate receipts (only a value of 1 or 2 is accepted!).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command109Variant0Version0ReceiptCount:(NSString *)receiptCount error:(NSError **)error;
/**
6Eh(110) ADDITIONAL DAILY INFORMATION

<p>

<p>
 - Data field:		None
 - Response:
			 -# paidInCash
			 -# paidWithCreditCart
			 -# paidWithDebitCard
			 -# paidWithCheque
			 -# paidInAdditionalPaymentType1
			 -# paidInAdditionalPaymentType2
			 -# paidInAdditionalPaymentType3
			 -# paidInAdditionalPaymentType4
			 -# currentFiscalRecordNumber
			 -# nextFiscalReceiptNumber

<p>
 - paidInCash			Paid in cash
 - paidWithCreditCart			Payment credited
 - paidWithDebitCard			Paid with a debit card
 - paidWithCheque			Paid with a cheque
 - paidInAdditionalPaymentTypeX		Payd with one of the additional payment types ('I', 'J', 'K', 'L').
 - currentFiscalRecordNumber		Current (last) fiscal entry
 - nextFiscalReceiptNumber		Number of the next fiscal receipt

<p>
Returns information on distribution of the daily sum according to terms of payment used.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidInCash" - Paid in cash
 - KeyValue - \@"paidWithCreditCart" - Payment credited
 - KeyValue - \@"paidWithDebitCard" - Paid with a debit card
 - KeyValue - \@"paidWithCheque" - Paid with a cheque
 - KeyValue - \@"paidInAdditionalPaymentType1" - Payd with one of the additional payment types ('I').
 - KeyValue - \@"paidInAdditionalPaymentType2" - Payd with one of the additional payment types ('J').
 - KeyValue - \@"paidInAdditionalPaymentType3" - Payd with one of the additional payment types ('K').
 - KeyValue - \@"paidInAdditionalPaymentType4" - Payd with one of the additional payment types ('L').
 - KeyValue - \@"currentFiscalRecordNumber" - Current (last) fiscal entry
 - KeyValue - \@"nextFiscalReceiptNumber" - Number of the next fiscal receipt
*/

    -(NSDictionary *)command110Variant0Version0AndReturnError:(NSError **)error;
/**
6Fh(111) ITEMS REPORT

<p>
Data field:
		 -# printOption
		 -# startItemNumber
		 -# endItemNumber
Reponse:
		 -# errorCode

<p>
 - printOption	Defines the type of information under print. Possible values:
				 -# - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
				 -# - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.
 - startItemNumber	First article number (PLU) printed. PLUs less than this are not included in the report. Default: 1.
 - endItemNumber	Last article number (PLU) printed. PLUs greater than this are not included in the report. Default: 999999999.

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>
Items are arranged according to their individual numbers.
When a Z-report is printed, then the accumulated sums are cleared, if the parameter 'A' is not present in the command line.


 <p>
 @param printOption - Defines the type of information under print. Possible values:
 - - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
 - - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.

 @param startItemNumber - First article number (PLU) printed. PLUs less than this are not included in the report. Default: 1.
 @param endItemNumber - Last article number (PLU) printed. PLUs greater than this are not included in the report. Default: 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command111Variant0Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber error:(NSError **)error;
/**
6Fh(111) ITEMS REPORT

<p>
Data field:
 - printOption	Defines the type of information under print. Possible values:
				 -# - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
				 -# - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.
 - startItemNumber	First article number (PLU) printed. PLUs less than this are not included in the report. Default: 1.
 - endItemNumber	Last article number (PLU) printed. PLUs greater than this are not included in the report. Default: 999999999.
 - itemGroup	A number from 1 to 99. If present, only articles from this group are printed, otherwise all articles are printed.
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command
Reponse:
		 -# errorCode

<p>

<p>
Items are arranged according to their individual numbers.
When a Z-report is printed, then the accumulated sums are cleared, if the parameter 'A' is not present in the command line.


 <p>
 @param printOption - Defines the type of information under print. Possible values:
 - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
 - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.

 @param startItemNumber - First article number (PLU) printed. PLUs less than this are not included in the report. Default: 1.
 @param endItemNumber - Last article number (PLU) printed. PLUs greater than this are not included in the report. Default: 999999999.
 @param itemGroup - A number from 1 to 99. If present, only articles from this group are printed, otherwise all articles are printed.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command111Variant1Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber itemGroup:(NSString *)itemGroup error:(NSError **)error;
/**
6Fh(111) ITEMS REPORT

<p>
Data field:
		 -# printOption
Reponse:
		 -# errorCode

<p>
 - printOption	Defines the type of information under print. Possible values:
				 -# - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
				 -# - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.

<p>
 - errorCode		One byte, showing the result from the operation and having the following meaning:
				 -# 'P'	Successful command
				 -# 'F'	Unsuccessful command

<p>

<p>

<p>
Items are arranged according to their individual numbers.
When a Z-report is printed, then the accumulated sums are cleared, if the parameter 'A' is not present in the command line.


 <p>
 @param printOption - Defines the type of information under print. Possible values:
 - - 'S'	Only sold items are printed out. The data on these items include: the individual number, VAT group, group, name, single price, sold quantity and total sum for the day.
 - - 'P'	All programmed items are printed out, containing their number, VAT group, group, name, sold quantity, available quantity and single price.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte, showing the result from the operation and having the following meaning:
 - 'P'	Successful command
 - 'F'	Unsuccessful command

*/

    -(NSDictionary *)command111Variant2Version0PrintOption:(NSString *)printOption error:(NSError **)error;
/**
70h(112) READING INFORMATION ON THE OPERATOR

<p>
 - Data field:
			 -# operatorCode
 - Response:
			 -# receiptCountForOperator
			 -# registeredSalesCountForOperator
			 -# totalAccumulatedSum
			 -# discountCountForOperator
			 -# totalDiscounts
			 -# surchargeCountForOperator
			 -# totalSurcharges
			 -# voidCountForOperator
			 -# totalVoidSum
			 -# operatorName
			 -# operatorPassword

<p>
 - operatorCode			Number of the operator (1 to 16)
 - receiptCountForOperator		Number of fiscal receipts, issued by the operator
 - registeredSalesCountForOperator	Number of registered sales
 - totalAccumulatedSum		Total accumulated sum
 - discountCountForOperator		Number of discounts
 - totalDiscounts			Total number of discounts
 - surchargeCountForOperator		Number of surcharges
 - totalSurcharges			Total number of surcharges made
 - voidCountForOperator		Number of voids (and corrections of sums)
 - totalVoidSum			Total sum of the voids
 - operatorName			Name of the operator
 - operatorPassword			Operators password. Present only if the printer is in service mode.

<p>
The command leads to the reading of the available information, which will be printed out in the operator's report. 
The sums are returned as floating-point numbers incorporating the currently set number of decimal places.


 <p>
 @param operatorCode - Number of the operator (1 to 16)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"receiptCountForOperator" - Number of fiscal receipts, issued by the operator
 - KeyValue - \@"registeredSalesCountForOperator" - Number of registered sales
 - KeyValue - \@"totalAccumulatedSum" - Total accumulated sum
 - KeyValue - \@"discountCountForOperator" - Number of discounts
 - KeyValue - \@"totalDiscounts" - Total number of discounts
 - KeyValue - \@"surchargeCountForOperator" - Number of surcharges
 - KeyValue - \@"totalSurcharges" - Total number of surcharges made
 - KeyValue - \@"voidCountForOperator" - Number of voids (and corrections of sums)
 - KeyValue - \@"totalVoidSum" - Total sum of the voids
 - KeyValue - \@"operatorName" - Name of the operator
 - KeyValue - \@"operatorPassword" - Operators password. Present only if the printer is in service mode.
*/

    -(NSDictionary *)command112Variant0Version0OperatorCode:(NSString *)operatorCode error:(NSError **)error;
/**
71h(113) READING THE NUMBER OF THE LAST PRINTED DOCUMENT

<p>

<p>
 - Data field:		None
 - Response:		lastDocumentNumber

<p>

<p>
lastDocumentNumber	The number of the last issued document (7 digits)


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"lastDocumentNumber" - The number of the last issued document (7 digits)
*/

    -(NSDictionary *)command113Variant0Version0AndReturnError:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>

<p>
The command returns information on different tax groups for each separate entry and or a selected period of time. 
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# lastTaxRatesRecordNumber
			 -# decimalsCount
			 -# enabledTaxArray
			 -# taxPercentRateA
			 -# taxPercentRateB
			 -# taxPercentRateC
			 -# taxPercentRateD
			 -# dateAndTime

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - lastTaxRatesRecordNumber		Last (active) decimals and VAT rates record number.
 - decimalsCount			Decimals count for this Z-report record.
 - enabledTaxArray			Enabled VAT rates mask - 4 bytes with values '0' or '1', where '1' means "enabled".
 - taxPercentRateX			VAT rate for the corresponding VAT group in percents.
 - dateAndTime			Date and time of the data in format: DD-MM-YY hh:mm:ss.


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"lastTaxRatesRecordNumber" - Last (active) decimals and VAT rates record number.
 - KeyValue - \@"decimalsCount" - Decimals count for this Z-report record.
 - KeyValue - \@"enabledTaxArray" - Enabled VAT rates mask - 4 bytes with values '0' or '1', where '1' means "enabled".
 - KeyValue - \@"taxPercentRateA" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateB" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateC" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateD" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"dateAndTime" - Date and time of the data in format: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant0Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>

<p>
Information about total (turnover) sums for the Z-report record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# totalTurnoverInTaxGroupA
			 -# totalTurnoverInTaxGroupB
			 -# totalTurnoverInTaxGroupC
			 -# totalTurnoverInTaxGroupD
			 -# totalTurnoverInTaxGroupE
			 -# specialTax

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - totalTurnoverInTaxGroupX	Total (turnover) sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>

<p>


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"totalTurnoverInTaxGroupA" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupB" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupC" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupD" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupE" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"specialTax" - Special tax accumulated sum.
*/

    -(NSDictionary *)command114Variant1Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>

<p>
Information about total (turnover) sums for the Z-report record(interval).
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber1
			 -# fiscalRecordNumber2
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# totalTurnoverInTaxGroupA
			 -# totalTurnoverInTaxGroupB
			 -# totalTurnoverInTaxGroupC
			 -# totalTurnoverInTaxGroupD
			 -# totalTurnoverInTaxGroupE
			 -# specialTax

<p>
 - fiscalRecordNumberX	Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - totalTurnoverInTaxGroupX	Total (turnover) sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>
Note:
The data returned is for the period with starting record Closure1 and last record Closure2 for references.


 <p>
 @param fiscalRecordNumber1 - Number of the fiscal memory record.
 @param fiscalRecordNumber2 - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"totalTurnoverInTaxGroupA" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupB" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupC" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupD" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"totalTurnoverInTaxGroupE" - Total (turnover) sum for the corresponding VAT group.
 - KeyValue - \@"specialTax" - Special tax accumulated sum.
*/

    -(NSDictionary *)command114Variant1Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>
Information about net sums for the Z-report record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# netAmountInTaxGroupA
			 -# netAmountInTaxGroupB
			 -# netAmountInTaxGroupC
			 -# netAmountInTaxGroupD
			 -# netAmountInTaxGroupE
			 -# specialTax

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - netAmountInTaxGroupX	Net sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>

<p>


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"netAmountInTaxGroupA" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupB" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupC" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupD" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupE" - Net sum for the corresponding VAT group.
 - KeyValue - \@"specialTax" - Special tax accumulated sum.
*/

    -(NSDictionary *)command114Variant2Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>
Information about net sums for the Z-report record(period).
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber1
			 -# fiscalRecordNumber2
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# netAmountInTaxGroupA
			 -# netAmountInTaxGroupB
			 -# netAmountInTaxGroupC
			 -# netAmountInTaxGroupD
			 -# netAmountInTaxGroupE
			 -# specialTax

<p>
 - fiscalRecordNumberX	Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - netAmountInTaxGroupX	Net sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>

<p>


 <p>
 @param fiscalRecordNumber1 - Number of the fiscal memory record.
 @param fiscalRecordNumber2 - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"netAmountInTaxGroupA" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupB" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupC" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupD" - Net sum for the corresponding VAT group.
 - KeyValue - \@"netAmountInTaxGroupE" - Net sum for the corresponding VAT group.
 - KeyValue - \@"specialTax" - Special tax accumulated sum.
*/

    -(NSDictionary *)command114Variant2Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>
Information about VAT sums for the Z-report record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# vatSumInTaxGroupA
			 -# vatSumInTaxGroupB
			 -# vatSumInTaxGroupC
			 -# vatSumInTaxGroupD

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - vatSumInTaxGroupX	VAT sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>

<p>


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"vatSumInTaxGroupA" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupB" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupC" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupD" - VAT sum for the corresponding VAT group.
*/

    -(NSDictionary *)command114Variant3Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>
Information about net sums for the Z-report record(period).
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber1
			 -# fiscalRecordNumber2
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# fiscalReceiptsCount
			 -# vatSumInTaxGroupA
			 -# vatSumInTaxGroupB
			 -# vatSumInTaxGroupC
			 -# vatSumInTaxGroupD

<p>
 - fiscalRecordNumberX	Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - outputFiscalRecordNumber	Z-report record number.
 - fiscalReceiptsCount		Fiscal receipts count for the day.
 - vatSumInTaxGroupX	VAT sum for the corresponding VAT group.
 - specialTax			Special tax accumulated sum.

<p>

<p>


 <p>
 @param fiscalRecordNumber1 - Number of the fiscal memory record.
 @param fiscalRecordNumber2 - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"fiscalReceiptsCount" - Fiscal receipts count for the day.
 - KeyValue - \@"vatSumInTaxGroupA" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupB" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupC" - VAT sum for the corresponding VAT group.
 - KeyValue - \@"vatSumInTaxGroupD" - VAT sum for the corresponding VAT group.
*/

    -(NSDictionary *)command114Variant3Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>
Additional information about the Z-report record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# outputFiscalRecordNumber
			 -# lastTaxRatesRecordNumber
			 -# lastResetRecordNumber
			 -# lastElectronicJournalNumber
			 -# dateAndTime

<p>

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.

<p>
 - outputFiscalRecordNumber		Z-report record number.
 - lastTaxRatesRecordNumber		Last (active) decimals and VAT rates record number.
 - lastResetRecordNumber		Last RAM reset number for this Z-report record.
 - lastElectronicJournalNumber		Last electronic journal number for this Z-report record.
 - dateAndTime			Date and time of the data in format: DD-MM-YY hh:mm:ss.


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"outputFiscalRecordNumber" - Z-report record number.
 - KeyValue - \@"lastTaxRatesRecordNumber" - Last (active) decimals and VAT rates record number.
 - KeyValue - \@"lastResetRecordNumber" - Last RAM reset number for this Z-report record.
 - KeyValue - \@"lastElectronicJournalNumber" - Last electronic journal number for this Z-report record.
 - KeyValue - \@"dateAndTime" - Date and time of the data in format: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant4Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>

<p>
Information about decimals and VAT rates record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# decimalsCount
			 -# enabledTaxArray
			 -# taxPercentRateA
			 -# taxPercentRateB
			 -# taxPercentRateC
			 -# taxPercentRateD
			 -# dateAndTime

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - decimalsCount			Decimals count for this Z-report record.
 - enabledTaxArray			Enabled VAT rates mask - 4 bytes with values '0' or '1', where '1' means "enabled".
 - taxPercentRateX			VAT rate for the corresponding VAT group in percents.
 - dateAndTime			Date and time of the data in format: DD-MM-YY hh:mm:ss.


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"decimalsCount" - Decimals count for this Z-report record.
 - KeyValue - \@"enabledTaxArray" - Enabled VAT rates mask - 4 bytes with values '0' or '1', where '1' means "enabled".
 - KeyValue - \@"taxPercentRateA" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateB" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateC" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"taxPercentRateD" - VAT rate for the corresponding VAT group in percents.
 - KeyValue - \@"dateAndTime" - Date and time of the data in format: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant5Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h(114) INFORMATION ON THE FISCAL ENTRY OR A FISCAL PERIOD

<p>

<p>
Information about RAM reset record.
Periodic references for longer time periods may take few seconds to process.

<p>
 - Data field:		fiscalRecordNumber
 - Response:
			 -# errorCode
			 -# dateAndTime

<p>
 - fiscalRecordNumber		Number of the fiscal memory record.
 - errorCode			One byte with a value of:
					 -# - 'P'	The data are valid.
					 -# - 'F'	Wrong control sum in the entry. No data available.
					 -# - 'E'	The selected entry is empty. No data available.
 - dateAndTime			Date and time of the data in format: DD-MM-YY hh:mm:ss.


 <p>
 @param fiscalRecordNumber - Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - One byte with a value of:
 - - 'P'	The data are valid.
 - - 'F'	Wrong control sum in the entry. No data available.
 - - 'E'	The selected entry is empty. No data available.

 - KeyValue - \@"dateAndTime" - Date and time of the data in format: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant6Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
73h(115) PROGRAMMING A GRAPHIC LOGO
 - Data field:
			 -# rowNumber
			 -# rowData

<p>
 - Response:
			 -# None

<p>
 - rowNumber	Shows the line, which is being programmed - a number between 0 and 95
 - rowData		Graphic data.
			 -# Two symbols for each byte of information are entered in the hexadecimal code (Two symbols for every byte).
			 -# The length of the data is up to 48 bytes, and if they are less, an automatic addition of "00" follows.

<p>

<p>
Note:
This command offers the option to define a graphic logo with dimensions 48 x 12 mm (384 x 96 dots) designed by the user themselves. 
The printing of this logo is activated with command 43. 
It is printed out immediately before the HEADER - at the beginning of each fiscal or non-fiscal receipt. In order to define the whole logo, the command 
must be executed 96 times - once for each line. After RESET of memory, default logo is active.


 <p>
 @param rowNumber - Shows the line, which is being programmed - a number between 0 and 95
 @param rowData - Graphic data. Two symbols for each byte of information are entered in the hexadecimal code (Two symbols for every byte). The length of the data is up to 48 bytes, and if they are less, an automatic addition of "00" follows.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command115Variant0Version0RowNumber:(NSString *)rowNumber rowData:(NSString *)rowData error:(NSError **)error;
/**
73h(115) PROGRAMMING A GRAPHIC LOGO
 - Data field:
			 -# rowNumber

<p>
 - Response:
			 -# rowData

<p>
 - rowNumber	Shows the line, which is being programmed - a number between 0 and 95
 - rowData		Graphic data.
			 -# Two symbols for each byte of information are entered in the hexadecimal code (Two symbols for every byte).
			 -# The length of the data is up to 48 bytes, and if they are less, an automatic addition of "00" follows.

<p>

<p>
Note:
This command offers the option to define a graphic logo with dimensions 48 x 12 mm (384 x 96 dots) designed by the user themselves. 
The printing of this logo is activated with command 43. 
It is printed out immediately before the HEADER - at the beginning of each fiscal or non-fiscal receipt. In order to define the whole logo, the command 
must be executed 96 times - once for each line. After RESET of memory, default logo is active.


 <p>
 @param rowNumber - Shows the line, which is being programmed - a number between 0 and 95
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"rowData" - Graphic data. Two symbols for each byte of information are entered in the hexadecimal code (Two symbols for every byte). The length of the data is up to 48 bytes, and if they are less, an automatic addition of "00" follows.
*/

    -(NSDictionary *)command115Variant1Version0RowNumber:(NSString *)rowNumber error:(NSError **)error;
/**
78h(120) SWITCHING THE PRINTER OFF

<p>
 - Data field:		No data
 - Response:		fiscalPrinterAnswer

<p>
 - fiscalPrinterAnswer		Contains the text 'OFF'.

<p>
The printer is switched off (eventually after finishing the printing). 


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalPrinterAnswer" - Contains the text 'OFF'.
*/

    -(NSDictionary *)command120Variant0Version0AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Electronic journal information.

<p>
 - Data field:		None
 - Response:		journalNumber
			 -# jnumberAfterLastZ
			 -# nextJournalNumber
			 -# totalJLinesAfterErase
			 -# freeBytesCount
			 -# totalBytesCount

<p>

<p>

<p>
journalNumber		Journal number
jnumberAfterLastZ		Journal number after last Z-report
nextJournalNumber		Next journal number (Subcommand 'N' will get this line number).
totalJLinesAfterErase		Total journal lines written after last erase.
freeBytesCount		Free bytes count in el. journal.
totalBytesCount		Total bytes count in el. journal

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"journalNumber" - Journal number
 - KeyValue - \@"jnumberAfterLastZ" - Journal number after last Z-report
 - KeyValue - \@"nextJournalNumber" - Next journal number (Subcommand 'N' will get this line number).
 - KeyValue - \@"totalJLinesAfterErase" - Total journal lines written after last erase.
 - KeyValue - \@"freeBytesCount" - Free bytes count in el. journal.
 - KeyValue - \@"totalBytesCount" - Total bytes count in el. journal
*/

    -(NSDictionary *)command122Variant0Version0AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Get first journal line.

<p>

<p>
 - Data field:		None
 - Response:		errorCode
			 -# journalLineText

<p>

<p>

<p>
 - errorCode
				 -# 'F'	No journal line found
				 -# 'P'	Journal line successfully read

<p>
 - journalLineText	The journal line.

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" -  One byte, showing the result from the operation and having the following meaning:
 - 'F'	No journal line found
 - 'P'	Journal line successfully read

 - KeyValue - \@"journalLineText" - The journal line.
*/

    -(NSDictionary *)command122Variant1Version0AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Get next journal line.

<p>

<p>
 - Data field:		None
 - Response:		errorCode
			 -# journalLineText

<p>

<p>

<p>
 - errorCode
				 -# 'F'	No journal line found
				 -# 'P'	Journal line successfully read

<p>
 - journalLineText	The journal line.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"" -  One byte, showing the result from the operation and having the following meaning:
 - 'F'	No journal line found
 - 'P'	Journal line successfully read

 - KeyValue - \@"" - The journal line.
*/

    -(NSDictionary *)command122Variant1Version1AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Print electronic journal using half-height font starting from the first journal line.

<p>

<p>
 - Data field:		None
 - Response:		None

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command122Variant2Version0AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Print electronic journal using normal font starting from the first journal line.

<p>

<p>
 - Data field:		None
 - Response:		None

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command122Variant2Version1AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Continue printing of the electronic journal using half-height font - starting with the first non-printed line.

<p>

<p>
 - Data field:		None
 - Response:		None

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command122Variant3Version0AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Continue printing of the electronic journal using normal font - starting with the first non-printed line.

<p>

<p>
 - Data field:		None
 - Response:		None

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command122Variant3Version1AndReturnError:(NSError **)error;
/**
7Ah(122) JOURNAL SUPPORT

<p>

<p>
Erase electronic journal. Before this the journal must be printed!

<p>

<p>
 - Data field:		None
 - Response:		None

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command122Variant4Version0AndReturnError:(NSError **)error;



/* machine-oriented interface end */

/* human-oriented interface - begin */

-(NSString *)customCommand:(int)cmd data:(NSString *)data error:(NSError **)error;

/*some informations*/
/**
diagnosticInfoGetAndReturnError - RETURNS DIAGONSTIC INFORMATION

<p>
 - Data field:
		 -# None
 - Response:
		 -# printerName		Fiscal device name.
		 -# firmwareRevision		The version of the software program - 4 bytes.
		 -# firmwareDate		The date of the software program DDMmmYY - 7 bytes.
		 -# firmwareTime		Hour of the software program HHMM - 4 bytes.
		 -# checkSum			The EPROM control sum - a 4 bytes string in the hexadecimal code.
		 -# softwareSwitches		The configuration switches from Sw1 to Sw8 - an 8 bytes string with '0' or '1'.
		 -# serialNumber		The serial number - 8 bytes.
		 -# fiscalMemoryNumber	Number of the fiscal module - 8 bytes.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printerName" - Fiscal device name.
 - KeyValue - \@"firmwareRevision" - The version of the software program - 4 bytes.
 - KeyValue - \@"firmwareDate" - The date of the software program DDMmmYY - 7 bytes.
 - KeyValue - \@"firmwareTime" - Hour of the software program HHMM - 4 bytes.
 - KeyValue - \@"checkSum" - The EPROM control sum - a 4 bytes string in the hexadecimal code. 
 - KeyValue - \@"softwareSwitches" - The configuration switches from Sw1 to Sw8 - an 8 bytes string with '0' or '1'.
 - KeyValue - \@"serialNumber" - The serial number - 8 bytes.
 - KeyValue - \@"fiscalMemoryNumber" - Number of the fiscal module - 8 bytes.
*/
-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;

/**
diagnosticInfoPrintAndReturnError - PRINTING DIAGNOSTIC INFORMATION

<p>
 - Data field:	No data
 - Response:	None

<p>
The command initiates the generation of an interior receipt containing diagnostic information as follows:
 - - Prints the date and version of the employed software,
 - - Prints the control sum of the employed firmware,
 - - Prints the serial port's band rate,
 - - Prints out the status of memory switches,
 - - Prints emergency time after power supply cut-off,
 - - Prints the number, date and hour of the last reset of the RAM (if there is such),
 - - Prints the current temperature of the two printer heads,
 - - Prints the overall number of fields in the fiscal memory and the number of the free fields,
 - - Prints the current date and hour.

<p>
The command will not be executed when there is an open receipt in progress or when the paper roll has finished. 
It may also be activated by pressing the "FEED" button while power on for less than 2 seconds.

<p>


 <p>
 @return TRUE upon success, FALSE otherwise
*/
-(bool)diagnosticInfoPrintAndReturnError:(NSError **)error;

/**
getStatusBytesAndReturnError - READING THE STATUS BYTES

<p>
 - Data field:	None
 - Response:
		 -# statusByte0	Status byte 0
		 -# statusByte1	Status byte 1
		 -# statusByte2	Status byte 2
		 -# statusByte3	Status byte 3
		 -# statusByte4	Status byte 4
		 -# statusByte5	Status byte 5

<p>
The status is returned immediately (default).


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"statusByte0" - statusByte0
 - KeyValue - \@"statusByte1" - statusByte1
 - KeyValue - \@"statusByte2" - statusByte2
 - KeyValue - \@"statusByte3" - statusByte3
 - KeyValue - \@"statusByte4" - statusByte4
 - KeyValue - \@"statusByte5" - statusByte5
*/
-(NSDictionary *)getStatusBytesAndReturnError:(NSError **)error;

/*non-fiscal bon*/
/**
nonFiscalReceiptOpenAndReturnError - Opening a non-fiscal receipt.

<p>
 - Data field:
		 -# None
 - Response:
		 -# Allreceipt	The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).

<p>

<p>
 The FP performs the following actions:
 - Prints the header
 - Prints the tax registration number of the seller
 - A response is received, which contains Allreceipt

<p>
 The command cannot be executed, S1.1 is raised if.
 - The fiscal memory has not been formatted
 - There is an opened fiscal or non-fiscal receipt
 - There is no paper
 - The clock is not set
 - The electronic journal is full


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).
*/
-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;

/**
nonFiscalReceiptPrintText - PRINTING OF A FREE NON-FISCAL TEXT

<p>
 - Data field:
		 -# inputText	A text of 30 symbols (at most). The symbols after 30 are cut off.
 - Response:
		 -# None

<p>

<p>

<p>
If S1.1 is raised, there is no non-fiscal receipt opened and the text is not printed.


 <p>
 @param inputText - A text of 30 symbols (at most). The symbols after 30 are cut off.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/
-(bool)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;

/**
nonFiscalReceiptCloseAndReturnError - Closing a non-fiscal receipt

<p>
 - Data field:
		 -# None
 - Response:
		 -# Allreceipt	The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).

<p>
The FP performs the following actions:
 - Prints the footer
 - The sequence number, date and hour of document are printed
 - "NON-FISCAL RECEIPT" is printed in expanded style.

<p>
If the S1.1 flag is raised, the command is not executed because there is no opened non-fiscal receipt.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - The number of all issued receipts (fiscal and non-fiscal) from the last daily closure on (4 bytes).
*/
-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;

/*fiscal bon*/
-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
-(bool)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
-(bool)fiscalReceiptSellAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;

/*emergency*/
-(bool)checkAndResolveAndReturnError:(NSError **)error;

/* human-oriented interface - end */

@end
