//
//  ViewController.m
//  FiscalDemo
//
//  Created by Flex on 9/4/12.
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import "FMP10ViewController.h"

@implementation FMP10ViewController

static NSString *OPERATIONS[]=
{
    @"Получаване на диагностична информация",
    @"Функция getDiagnosticInfo",
	
    @"Печат на диагностична информация",
    @"Функция printDiagnosticInfo",
	
    @"Нефискален бон",
    @"",
	
    @"Фискален бон",
    @"Демонстрация на продажба във втора данъчна група и субтотал",
	
    @"Фискален бон",
    @"Демонстрация на печат на баркод и на продажба ",
	
    @"Нефискален бон",
    @"Демонстрация на печат на баркод",
	
    @"Дневен отчет",
    @"Демонстрация на дневен отчет с различни опции",

    @"Аварийно затваряне",
    @"Демонстрация на аварийно затваряне",
    
    @"Задаване на дата и час",
    @"",
};

static NSString *OPERATIONS_ROU[]=
{
    @"Get diagnostic info",
    @"Function getDiagnosticInfo",
	
    @"Print diagnostic info",
    @"Function printDiagnosticInfo",
	
    @"Nonfical receipt",
    @"",
	
    @"Fiscal receipt",
    @"",
    
    @"X report",
    @"Raport zilnic informativ",
    
    @"Z report",
    @"Raport fiscal zilnic",

    @"Check and resolve",
    @"Closes opened checks and other stuff",
    
    @"Set clock",
    @"Synchronizes the clock on the fiscal device",
    
    @"RAM Reset",
    @"Service use only",
};

-(bool)executeFunction_ROU:(int)funcNo error:(NSError **)error
{
    switch (funcNo)
    {
        case 0:
		{
			NSDictionary *tmpResult;
			tmpResult = [fmp10_rou diagnosticInfoGetAndReturnError:error];
			if(tmpResult)
			{
				[self appendLog:[NSString stringWithFormat:@"Printer name: %@",[tmpResult valueForKey:@"printerName"]]];
				[self appendLog:[NSString stringWithFormat:@"Serial number: %@",[tmpResult valueForKey:@"serialNumber"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware revision: %@",[tmpResult valueForKey:@"firmwareRevision"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware date: %@",[tmpResult valueForKey:@"firmwareDate"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware time: %@",[tmpResult valueForKey:@"firmwareTime"]]];
                
                tmpResult = [fmp10_rou command83Variant1Version0AndReturnError:error];
                [self appendLog:[NSString stringWithFormat:@"command83: %@",tmpResult]];
                
                [self appendLog:[NSString stringWithFormat:@"FiscalMemoryFormatted: %d",fmp10_rou.statusFiscalMemoryFormated]];
				return true;
			}
            
            
			break;
		}
        case 1:
		{
			return [fmp10_rou diagnosticInfoPrintAndReturnError:error];
		}
        case 2:
		{
			NSDictionary *tmpResult;
			tmpResult = [fmp10_rou nonFiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fmp10_rou nonFiscalReceiptPrintText:@" Demonstation print" error:error]) return false;
				if (![fmp10_rou nonFiscalReceiptPrintText:@" inside nonfiscal receipt." error:error]) return false;
				tmpResult = [fmp10_rou nonFiscalReceiptCloseAndReturnError:error];
				return true;
			}
			break;
		}
        case 3:
		{
			fmp10_rou.sellParameterOperatorCode = @"1";
			fmp10_rou.sellParameterOperatorPassword = @"0000";
			fmp10_rou.sellParameterOperatorTillNumber = @"1";
			
			NSDictionary *tmpResult;
			tmpResult = [fmp10_rou fiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fmp10_rou fiscalReceiptPrintText:@" Demonstation fiscal receipt" error:error]) return false;
				
				fmp10_rou.sellParameterTextRow1 = @" Text row 1 ";
				fmp10_rou.sellParameterTextRow2 = @" Text row 2 ";
				fmp10_rou.sellParameterTaxGroup = @"B";
				fmp10_rou.sellParameterPrice = @"1.00";
				fmp10_rou.sellParameterQuantity = @"3.00";
				if (![fmp10_rou fiscalReceiptSellAndReturnError:error]) return 0;
                
				if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" Subtotal demo " error:error]) return 0;
				fmp10_rou.subtotalParameterPercent = @"0";
				tmpResult = [fmp10_rou fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
				

				if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" Demo sale " error:error]) return 0;
				fmp10_rou.sellParameterTextRow1 = @" Text row 1 ";
				fmp10_rou.sellParameterTextRow2 = @" Text row 2 ";
				fmp10_rou.sellParameterTaxGroup = @"B";
				fmp10_rou.sellParameterPrice = @"2.00";
				fmp10_rou.sellParameterQuantity = @"5.00";
				if (![fmp10_rou fiscalReceiptSellAndReturnError:error]) return 0;
				
                if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
                if (![fmp10_rou fiscalReceiptPrintText:@" Subtotal demo " error:error]) return 0;
                if (![fmp10_rou fiscalReceiptPrintText:@" With absolute discount " error:error]) return 0;
                fmp10_rou.subtotalParameterAbsoluteSum = @"-3.00";
                tmpResult = [fmp10_rou fiscalReceiptSubtotalAndReturnError:error];
                if (!tmpResult) return 0;
                
				if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" Demo sale " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" and fixed discount " error:error]) return 0;
				
				fmp10_rou.sellParameterTextRow1 = @" Text row 1 ";
				fmp10_rou.sellParameterTextRow2 = @" Text row 2 ";
				fmp10_rou.sellParameterTaxGroup = @"B";
				fmp10_rou.sellParameterPrice = @"2.00";
				fmp10_rou.sellParameterQuantity = @"5.00";
				fmp10_rou.sellParameterPercent = @"";
				fmp10_rou.sellParameterAbsoluteSum = @"-9.90";
				if (![fmp10_rou fiscalReceiptSellAndReturnError:error]) return 0;
                
				if (![fmp10_rou fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" Subtotal demo " error:error]) return 0;
				if (![fmp10_rou fiscalReceiptPrintText:@" and 99% discount " error:error]) return 0;
				fmp10_rou.subtotalParameterPercent = @"-99.00";
				tmpResult = [fmp10_rou fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
                
				fmp10_rou.totalParameterTextRow1 = @" Text row 1 ";
				fmp10_rou.totalParameterTextRow2 = @" Text row 2 ";
				fmp10_rou.totalParameterPaidMode = @"P";
				fmp10_rou.totalParameterAmount = @"20.00";
				if (![fmp10_rou fiscalReceiptTotalAndReturnError:error]) return 0;
				
				if (![fmp10_rou fiscalReceiptCloseAndReturnError:error]) return 0;
				return true;
			}
			break;
		}
        case 4:
		{
            if([fmp10_rou command69Variant0Version0ReportTypeOption:@"2" error:error])
				return true;
			break;
		}
        case 5:
		{
            if([fmp10_rou command122Variant2Version1AndReturnError:error] &&
               [fmp10_rou command122Variant4Version0AndReturnError:error] &&
               [fmp10_rou command69Variant0Version0ReportTypeOption:@"0" error:error])
				return true;
			break;
		}
        case 6:
		{
            if([fmp10_rou checkAndResolveAndReturnError:error])
				return true;
			break;
		}
        case 7:
		{
            NSDateFormatter *dateFormat=[[NSDateFormatter alloc] init];
            [dateFormat setDateFormat:@"dd-MM-YY"];
            NSString *dateString = [dateFormat stringFromDate:[NSDate date]];
            [dateFormat setDateFormat:@"HH:mm:ss"];
            NSString *timeString = [dateFormat stringFromDate:[NSDate date]];
            
            if([fmp10_rou command61Variant0Version0TargetDate:dateString targetTime:timeString error:error])
				return true;    
			break;
		}
        case 8:
		{
//			NSDictionary *tmpResult;
//            
//			tmpResult = [fmp10_rou command87Variant0Version0AndReturnError:error];
//			if(tmpResult)
//                [self appendLog:[NSString stringWithFormat:@"Response: %@",tmpResult]];
//            
//
            if([fmp10_rou customCommand:128 data:nil error:error])
            {
                [self appendLog:[NSString stringWithFormat:@"Ram status 1: %@",(fmp10_rou.statusRamCleared?@"Reset":@"Ok")]];
                [self appendLog:[NSString stringWithFormat:@"Status bytes: %@",fmp10_rou.statusBytes]];
                [fmp10_rou getStatusBytesAndReturnError:error];
                [self appendLog:[NSString stringWithFormat:@"Ram status 2: %@",(fmp10_rou.statusRamCleared?@"Reset":@"Ok")]];
                [self appendLog:[NSString stringWithFormat:@"Status bytes: %@",fmp10_rou.statusBytes]];
				return true;
            }
			break;
		}
    }
    return false;
}

-(bool)executeFunction:(int)funcNo error:(NSError **)error
{
    switch (funcNo)
    {
        case 0:
		{
			NSDictionary *tmpResult;
			tmpResult = [fiscal_bg diagnosticInfoGetAndReturnError:error];
			if(tmpResult)
			{
				[self appendLog:[NSString stringWithFormat:@"Printer name: %@",[tmpResult valueForKey:@"printerName"]]];
				[self appendLog:[NSString stringWithFormat:@"Serial number: %@",[tmpResult valueForKey:@"serialNumber"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware revision: %@",[tmpResult valueForKey:@"firmwareRevision"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware date: %@",[tmpResult valueForKey:@"firmwareDate"]]];
				[self appendLog:[NSString stringWithFormat:@"Firmware time: %@",[tmpResult valueForKey:@"firmwareTime"]]];
				return true;		
			}
			break;
		}
        case 1:
		{
			return [fiscal_bg diagnosticInfoPrintAndReturnError:error];
		}
        case 2:
		{
			NSDictionary *tmpResult;
			tmpResult = [fiscal_bg nonFiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fiscal_bg nonFiscalReceiptPrintText:@" Демонстрация на печат" error:error]) return false;
				if (![fiscal_bg nonFiscalReceiptPrintText:@" в рамките на нефискален бон." error:error]) return false;
				tmpResult = [fiscal_bg nonFiscalReceiptCloseAndReturnError:error];
				return true;
			}
			break;
		}
        case 3:
		{
			fiscal_bg.sellParameterOperatorCode = @"1";
			fiscal_bg.sellParameterOperatorPassword = @"0000";
			fiscal_bg.sellParameterOperatorTillNumber = @"1";
			
			NSDictionary *tmpResult;
			tmpResult = [fiscal_bg fiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на печат" error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" в рамките на фискален бон." error:error]) return 0;
				
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.01";
				fiscal_bg.sellParameterQuantity = @"3.00";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на субтотал " error:error]) return 0;
				tmpResult = [fiscal_bg fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
				if(tmpResult)
				{
					[self appendLog:[NSString stringWithFormat:@"Сумата до момента за текущия фискален бон: %@ ст.",[tmpResult valueForKey:@"subTotal"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група A: %@ ст.",[tmpResult valueForKey:@"taxGroupA"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група B: %@ ст.",[tmpResult valueForKey:@"taxGroupB"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група C: %@ ст.",[tmpResult valueForKey:@"taxGroupC"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група D: %@ ст.",[tmpResult valueForKey:@"taxGroupD"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група E: %@ ст.",[tmpResult valueForKey:@"taxGroupE"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група F: %@ ст.",[tmpResult valueForKey:@"taxGroupF"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група G: %@ ст.",[tmpResult valueForKey:@"taxGroupG"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група H: %@ ст.",[tmpResult valueForKey:@"taxGroupH"]]];
				}				
				

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на продажба " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 30% " error:error]) return 0;
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.20";
				fiscal_bg.sellParameterQuantity = @"5.00";
				fiscal_bg.sellParameterPercent = @"-30.00";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;				
				

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на продажба " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 90 стотинки " error:error]) return 0;			
				
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.20";
				fiscal_bg.sellParameterQuantity = @"5.00";
				fiscal_bg.sellParameterPercent = @"";
				fiscal_bg.sellParameterAbsoluteSum = @"-0.90";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на субтотал " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 99% " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" върху цялата натрупана " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" сума. " error:error]) return 0;
				fiscal_bg.subtotalParameterPercent = @"-99.00";
				tmpResult = [fiscal_bg fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
				if(tmpResult)
				{
					[self appendLog:[NSString stringWithFormat:@"Сумата до момента за текущия фискален бон: %@ ст.",[tmpResult valueForKey:@"subTotal"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група A: %@ ст.",[tmpResult valueForKey:@"taxGroupA"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група B: %@ ст.",[tmpResult valueForKey:@"taxGroupB"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група C: %@ ст.",[tmpResult valueForKey:@"taxGroupC"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група D: %@ ст.",[tmpResult valueForKey:@"taxGroupD"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група E: %@ ст.",[tmpResult valueForKey:@"taxGroupE"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група F: %@ ст.",[tmpResult valueForKey:@"taxGroupF"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група G: %@ ст.",[tmpResult valueForKey:@"taxGroupG"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група H: %@ ст.",[tmpResult valueForKey:@"taxGroupH"]]];
				}				
				
				fiscal_bg.totalParameterTextRow1 = @" Първи ред в команда тотал ";
				fiscal_bg.totalParameterTextRow2 = @" Втори ред в команда тотал ";
				fiscal_bg.totalParameterPaidMode = @"P";
				fiscal_bg.totalParameterAmount = @"20.00";
				if (![fiscal_bg fiscalReceiptTotalAndReturnError:error]) return 0;
				
				if (![fiscal_bg fiscalReceiptCloseAndReturnError:error]) return 0;
				return true;
			}
			break;
		}
        case 4:
		{
			fiscal_bg.sellParameterOperatorCode = @"1";
			fiscal_bg.sellParameterOperatorPassword = @"0000";
			fiscal_bg.sellParameterOperatorTillNumber = @"1";
			
			NSDictionary *tmpResult;
			tmpResult = [fiscal_bg fiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на центриран" error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" печат на DataMatrix " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" баркод в рамките на " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" фискален бон." error:error]) return 0;				
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C3,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C5,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C12,Примерен DataMatrix баркод" error:error]) return 0;
				
				if (![fiscal_bg fiscalReceiptPrintText:@" Ляво подравнен " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" печат на DataMatrix " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" баркод в рамките на " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" фискален бон." error:error]) return 0;				
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"L3,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"L12,Примерен DataMatrix баркод" error:error]) return 0;
				
				if (![fiscal_bg fiscalReceiptPrintText:@" Дясно подравнен " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" печат на DataMatrix " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" баркод в рамките на " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" фискален бон." error:error]) return 0;				
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"R5,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"R12,Примерен DataMatrix баркод" error:error]) return 0;
				
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.01";
				fiscal_bg.sellParameterQuantity = @"3.00";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на субтотал " error:error]) return 0;
				tmpResult = [fiscal_bg fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
				if(tmpResult)
				{
					[self appendLog:[NSString stringWithFormat:@"Сумата до момента за текущия фискален бон: %@ ст.",[tmpResult valueForKey:@"subTotal"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група A: %@ ст.",[tmpResult valueForKey:@"taxGroupA"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група B: %@ ст.",[tmpResult valueForKey:@"taxGroupB"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група C: %@ ст.",[tmpResult valueForKey:@"taxGroupC"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група D: %@ ст.",[tmpResult valueForKey:@"taxGroupD"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група E: %@ ст.",[tmpResult valueForKey:@"taxGroupE"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група F: %@ ст.",[tmpResult valueForKey:@"taxGroupF"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група G: %@ ст.",[tmpResult valueForKey:@"taxGroupG"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група H: %@ ст.",[tmpResult valueForKey:@"taxGroupH"]]];
				}				
				

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на продажба " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 30% " error:error]) return 0;
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.20";
				fiscal_bg.sellParameterQuantity = @"5.00";
				fiscal_bg.sellParameterPercent = @"-30.00";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;				
				

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на продажба " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 90 стотинки " error:error]) return 0;			
				
				fiscal_bg.sellParameterTextRow1 = @" Първи ред в продажбата ";
				fiscal_bg.sellParameterTextRow2 = @" Втори ред в продажбата ";
				fiscal_bg.sellParameterTaxGroup = @"B";
				fiscal_bg.sellParameterPrice = @"0.20";
				fiscal_bg.sellParameterQuantity = @"5.00";
				fiscal_bg.sellParameterPercent = @"";
				fiscal_bg.sellParameterAbsoluteSum = @"-0.90";
				if (![fiscal_bg fiscalReceiptSellAndReturnError:error]) return 0;

				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" Демонстрация на субтотал " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" и отстъпка 99% " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" върху цялата натрупана " error:error]) return 0;
				if (![fiscal_bg fiscalReceiptPrintText:@" сума. " error:error]) return 0;
				fiscal_bg.subtotalParameterPercent = @"-99.00";
				tmpResult = [fiscal_bg fiscalReceiptSubtotalAndReturnError:error];
				if (!tmpResult) return 0;
				if(tmpResult)
				{
					[self appendLog:[NSString stringWithFormat:@"Сумата до момента за текущия фискален бон: %@ ст.",[tmpResult valueForKey:@"subTotal"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група A: %@ ст.",[tmpResult valueForKey:@"taxGroupA"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група B: %@ ст.",[tmpResult valueForKey:@"taxGroupB"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група C: %@ ст.",[tmpResult valueForKey:@"taxGroupC"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група D: %@ ст.",[tmpResult valueForKey:@"taxGroupD"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група E: %@ ст.",[tmpResult valueForKey:@"taxGroupE"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група F: %@ ст.",[tmpResult valueForKey:@"taxGroupF"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група G: %@ ст.",[tmpResult valueForKey:@"taxGroupG"]]];
					[self appendLog:[NSString stringWithFormat:@"Сумата по данъчна група H: %@ ст.",[tmpResult valueForKey:@"taxGroupH"]]];
				}				
				
				fiscal_bg.totalParameterTextRow1 = @" Първи ред в команда тотал ";
				fiscal_bg.totalParameterTextRow2 = @" Втори ред в команда тотал ";
				fiscal_bg.totalParameterPaidMode = @"P";
				fiscal_bg.totalParameterAmount = @"20.00";
				if (![fiscal_bg fiscalReceiptTotalAndReturnError:error]) return 0;
				
				if (![fiscal_bg fiscalReceiptCloseAndReturnError:error]) return 0;
				return true;
			}
			break;
		}
        case 5:
		{
			NSDictionary *tmpResult;
			tmpResult = [fiscal_bg nonFiscalReceiptOpenAndReturnError:error];
			if(tmpResult)
			{
				if (![fiscal_bg nonFiscalReceiptPrintText:@" Демонстрация на центриран" error:error]) return 0;
				if (![fiscal_bg nonFiscalReceiptPrintText:@" печат на DataMatrix " error:error]) return 0;
				if (![fiscal_bg nonFiscalReceiptPrintText:@" баркод в рамките на " error:error]) return 0;
				if (![fiscal_bg nonFiscalReceiptPrintText:@" нефискален бон." error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C3,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C5,Примерен DataMatrix баркод" error:error]) return 0;
				if (![fiscal_bg command84Variant0Version0BarcodeType:@"D" barcodeData:@"C12,Примерен DataMatrix баркод" error:error]) return 0;
				tmpResult = [fiscal_bg nonFiscalReceiptCloseAndReturnError:error];
				return true;
			}
			break;
		}
		case 6:
		{
			if(![fiscal_bg command69Variant0Version0ReportTypeOption:@"0" clearOperatorsDataOption:@"" error:error]) return 0;
			if(![fiscal_bg command69Variant0Version0ReportTypeOption:@"2" clearOperatorsDataOption:@"" error:error]) return 0;
			if(![fiscal_bg command69Variant0Version0ReportTypeOption:@"0" clearOperatorsDataOption:@"N" error:error]) return 0;
			break;
		}
		case 7:
		{
			NSDictionary *tmpResult;
			if([fiscal_bg checkAndResolveAndReturnError:error])
			{
				tmpResult = [fiscal_bg nonFiscalReceiptOpenAndReturnError:error];
				if(tmpResult)
				{
					if (![fiscal_bg nonFiscalReceiptPrintText:@" Демонстрация на отваряне" error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" на нефискален бон, " error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" печат на текст и " error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" аварийно затваряне." error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" Ако бона е останал" error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" поради някаква причина - " error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" използвайте метод: " error:error]) return 0;
					if (![fiscal_bg nonFiscalReceiptPrintText:@" checkAndResolve" error:error]) return 0;
					return [fiscal_bg checkAndResolveAndReturnError:error];
				}
			}
			break;
		}
        case 8:
		{
            NSDateFormatter *dateFormat=[[NSDateFormatter alloc] init];
            [dateFormat setDateFormat:@"dd-MM-YY"];
            NSString *dateString = [dateFormat stringFromDate:[NSDate date]];
            [dateFormat setDateFormat:@"HH:mm:ss"];
            NSString *timeString = [dateFormat stringFromDate:[NSDate date]];
            
            if([fiscal_bg command61Variant0Version0TargetDate:dateString tdrgetTime:timeString error:error])
				return true;
			break;
		}
    }
    return false;
}

-(void)appendLog:(NSString *)log
{
    logView.text=[logView.text stringByAppendingFormat:@"%@\n",log];
}

#define ERRMSG(title) {UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:error.localizedDescription delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil, nil]; [alert show];}

-(void)displayAlert:(NSString *)title message:(NSString *)message
{
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil, nil];
	[alert show];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Number of sections is the number of region dictionaries
    return 1;
}

- (NSString *)tableView:(UITableView *)aTableView titleForHeaderInSection:(NSInteger)section {
	return @"Fiscal Operations";
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Number of rows is the number of names in the region dictionary for the specified section
    if(fiscal_bg.deviceConnected)
        return (sizeof(OPERATIONS)/sizeof(NSString *))/2;
    if(fmp10_rou.deviceConnected)
        return (sizeof(OPERATIONS_ROU)/sizeof(NSString *))/2;
    
    return 0;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSError *error=nil;
    
	if(!fiscal_bg.deviceConnected && !fmp10_rou.deviceConnected)
		return;
    
    logView.text=@"";
	
    [progressViewController viewWillAppear:FALSE];
    [self.view addSubview:progressViewController.view];
    [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.01]];
    
    if(fiscal_bg.deviceConnected)
        [self executeFunction:indexPath.row error:&error];
    
    if(fmp10_rou.deviceConnected)
        [self executeFunction_ROU:indexPath.row error:&error];
    
    [progressViewController.view removeFromSuperview];
    [tableView reloadData];
    
    if(error)
        ERRMSG(@"Command failed!");
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	UITableViewCell *cell=[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"OperationsCell"];
	
    if(fiscal_bg.deviceConnected)
    {
        [cell.textLabel setText:OPERATIONS[indexPath.row*2+0]];
        [cell.detailTextLabel setText:OPERATIONS[indexPath.row*2+1]];
    }
    if(fmp10_rou.deviceConnected)
    {
        if(indexPath.row<(sizeof(OPERATIONS_ROU)/sizeof(NSString *))/2)
        {
            [cell.textLabel setText:OPERATIONS_ROU[indexPath.row*2+0]];
            [cell.detailTextLabel setText:OPERATIONS_ROU[indexPath.row*2+1]];
        }
    }
    cell.accessoryType=UITableViewCellAccessoryNone;
    
	return cell;
}

- (void)viewWillAppear:(BOOL)animated
{
    [operationsTable reloadData];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    fiscal_bg=[FP_BGR sharedInstance];
    [fiscal_bg addDelegate:self];
    fmp10_rou=[FMP10_ROU sharedInstance];
    [fmp10_rou addDelegate:self];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}


@end
