﻿//
//  FP_BGR.h
//  FiscalLibrary
//
//  Created by Flex and Doba on 24.10.2012
//  Modified on 25.09.2013
//  Copyright (c) 2012 Datecs. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Provides universal access to all supported devices' functions.
 In order to use one of the supported accessories in your program, several steps have to be performed:
 - Include DTDevices.h and libdtdev.a in your project.
 - Go to Frameworks and add ExternalAccessory framework
 - Edit your program plist file, add new element and select "Supported external accessory protocols" from the list, then add the protocol names of the accessories you want to connect to:
 <br>For Linea series: com.datecs.linea.pro.msr and com.datecs.linea.pro.bar
 <br>For Pinpad: com.datecs.iserial.communication and com.datecs.ppad
 <br>For iSerial: com.datecs.iserial.communication
 <br>For ESC/POS printers: com.datecs.printer.escpos
 <br>For Fiscal printers connected directly via bluetooth: com.datecs.printer.fiscal
 
 <br>Since this SDK is based on features, the specific device is not that important, for example, if your program relies on barcode scanning, then Linea, Pinpad or the ESC/POS printers can provide that functionality, so you can include all their protocols.
 */
@interface FP_BGR : NSObject
{
    
}

+(id)sharedInstance;

/**
 Allows unlimited delegates to be added to a single class instance. This is useful in the case of global
 class and every view can use addDelegate when the view is shown and removeDelegate when no longer needs to monitor events
 @param newDelegate the delegate that will be notified of Linea events
 **/
-(void)addDelegate:(id)newDelegate;

/**
 Removes delegate, previously added with addDelegate
 @param newDelegate the delegate that will be no longer be notified of Linea events
 **/
-(void)removeDelegate:(id)newDelegate;

/**
 Connect to the fiscal device using streams
 */
-(bool)connectWithStreams:(NSInputStream *)inStream outputStream:(NSOutputStream *)outStream error:(NSError **)error;

/**
 Disconnects from the stream
 */
-(void)disconnect;

/**
 Adds delegate to the class
 **/
@property(unsafe_unretained) id delegate;

/**
 Provides a list of currently registered delegates
 */
@property(readonly) NSMutableArray *delegates;

@property(readonly) bool deviceConnected;
@property(readonly) int infoPrinterCodePage;
@property(readonly) int infoMajorNumberSDKVersion;
@property(readonly) int infoMinorNumberSDKVersion;
@property(readonly) int infoReleaseNumberSDKVersion;
@property(readonly) int infoBuildNumberSDKVersion;
@property(readonly) int infoMaxLogoHigh;
@property(readonly) int infoMaxLogoWidth;
@property(readonly) int infoMaxHeaderLinesCount;
@property(readonly) int infoMaxFooterLinesCount;
@property(readonly) int infoMaxTransactionsCountInFiscalReceipt;
@property(readonly) int infoMaxSymbolCountInSellTextRow1;
@property(readonly) int infoMaxSymbolCountInSellTextRow2;
@property(readonly) int infoMaxSymbolCountInNonFiscalText;
@property(readonly) int infoMaxSymbolCountInNonFiscalRotatedText;
@property(readonly) int infoMaxSymbolCountInFiscalText;
@property(readonly) int infoMaxDepartmentCount;
@property(readonly) int infoMaxItemsCount;
@property(readonly) int infoTaxRatesMaxCount;
@property(readonly) int infoDisplayCodePage;
@property(readonly) int infoLastClassErrorCode;
@property(readonly) bool infoMandatoryZReportEndOfDay;
@property(readonly) bool infoMandatoryEKLPrintBeforeZReport;
@property(readonly) bool infoMandatoryEKLSave;
@property(readonly) bool infoMandatoryMonthlyReport;
@property(readonly) bool infoMandatoryYearlyReport;
@property(readonly) bool statusDisplayNotConnected;
@property(readonly) bool statusTransparentDisplayMode;
@property(readonly) bool statusFiscalMemoryMissing;
@property(readonly) bool statusPrintingHeadOverheated;
@property(readonly) bool statusSeconRollNoPaperPlace;
@property(readonly) bool statusSeconRollOutOfPaper;
@property(readonly) bool statusEndOfEKL;
@property(readonly) bool statusDrawerOpened;
@property(readonly) bool statusEKLNotEmpty;
@property(readonly) bool statusEKLPrinted;
@property(readonly) bool statusEKLNearEnd;
@property(readonly) bool statusKLENNearEnd;
@property(readonly) bool statusSecondRollNotEnoughPaper;
@property(readonly) bool statusAutomaticPaperCutting;
@property(readonly) bool statusPrintingHeadNotConnected;
@property(readonly) bool supportEKL;
@property(readonly) bool supportNRATerminal;
@property(readonly) bool supportKLEN;
@property(readonly) bool supportEIK;
@property(readonly) bool supportServiceContractsInformation;
@property(readonly) bool supportIOSANumber;
@property(readonly) bool supportFiscalReceipts;
@property(readonly) bool supportRotatedFiscalReceipts;
@property(readonly) bool supportNonFiscalReceipts;
@property(readonly) bool supportRotatedNonFiscalReceipts;
@property(readonly) bool supportBluetooth;
@property(readonly) bool supportWiFi;
@property(readonly) bool supportTCPIP;
@property(readonly) bool supportFTP;
@property(readonly) bool supportHTTP;
@property(readonly) bool supportSoftwareSwitches;
@property(readonly) bool supportClientDisplay;
@property(readonly) bool supportDrawerOpening;
@property(readonly) bool supportDrawerStatus;
@property(readonly) bool supportSecondRoll;
@property(readonly) bool supportAutoCutPaper;
@property(readonly) bool supportAdditionalMatrixPrint;
@property(readonly) bool supportPrintingHeadTemperatureControl;
@property(readonly) bool supportAsynchronousMode;
@property(readonly) bool supportTransactionsBufferForCommands;
@property(readonly) bool supportReceiptVoid;
@property(readonly) bool supportSaleRowVoid;
@property(readonly) bool supportVoidReceipt;
@property(readonly) bool supportVoidSale;
@property(readonly) bool statusEIKSet;
@property(readonly) bool statusSerialNumberSet;
@property(readonly) bool statusFMNumberSet;
@property(readonly) bool statusPrinterFiscalized;
@property(readonly) bool statusFiscalMemoryFormated;
@property(readonly) bool statusTaxRatesOk;
@property(readonly) bool statusLowBattery;
@property(readonly) bool statusGeneralErrorType1;
@property(readonly) bool statusGeneralErrorType2;
@property(readonly) bool statusPrintingHeadFailure;
@property(readonly) bool statusPrinterClockNotSet;
@property(readonly) bool statusInvalidCommand;
@property(readonly) bool statusSyntaxError;
@property(readonly) bool statusNRATerminalNotRespond;
@property(readonly) bool statusRamError;
@property(readonly) bool statusRamCleared;
@property(readonly) bool statusCommandNotAllowed;
@property(readonly) bool statusFieldOverflow;
@property(readonly) bool statusFiscalMemoryFull;
@property(readonly) bool statusFiscalMemoryReadError;
@property(readonly) bool statusFiscalMemoryWriteError;
@property(readonly) bool statusFiscalMemoryReadOnly;
@property(readonly) bool statusOutOfPaper;
@property(readonly) bool statusEndOfKLEN;
@property(readonly) bool statusFiscalReceiptOpened;
@property(readonly) bool statusNonFiscalReceiptOpened;
@property(readonly) bool statusRotatedReceiptOpened;
@property(readonly) bool statusFiscalMemoryNearEnd;
@property(readonly) bool statusCoverWasOpened;
@property(readonly) bool statusNotEnoughPaper;
@property(readonly) NSString *infoTaxEnabledArray;
@property(readonly) NSString *infoServiceEIKNumber;
@property(readonly) NSString *infoServiceEndDate;
@property(readonly) NSString *infoPrinterName;
@property(readonly) NSString *infoFirmwareRevision;
@property(readonly) NSString *infoFirmwareDateTime;
@property(readonly) NSString *infoSerialNumber;
@property(readonly) NSString *infoFiscalModuleNumber;
@property(readonly) bool infoBluetoothDiscoverable;
@property(readonly) NSString *infoMACAddress;
@property(readonly) NSString *infoIPAddress;
@property(readonly) NSString *infoIOSANumber;
@property(readonly) NSString *infoTaxArray;
@property(readonly) NSString *infoLastErrorText;
@property(copy) NSString *sellParameterTextRow1;
@property(copy) NSString *sellParameterTextRow2;
@property(copy) NSString *sellParameterTaxGroup;
@property(copy) NSString *sellParameterPrice;
@property(copy) NSString *sellParameterQuantity;
@property(copy) NSString *sellParameterPLU;
@property(copy) NSString *sellParameterDepartment;
@property(copy) NSString *sellParameterPercent;
@property(copy) NSString *sellParameterAbsoluteSum;
@property(copy) NSString *sellParameterOperatorCode;
@property(copy) NSString *sellParameterOperatorPassword;
@property(copy) NSString *sellParameterOperatorTillNumber;
@property(copy) NSString *subtotalParameterToPrint;
@property(copy) NSString *subtotalParameterPercent;
@property(copy) NSString *subtotalParameterAbsoluteSum;
@property(copy) NSString *totalParameterTextRow1;
@property(copy) NSString *totalParameterTextRow2;
@property(copy) NSString *totalParameterPaidMode;
@property(copy) NSString *totalParameterAmount;





/* machine-oriented interface begin */
/**
24h (36) 	ИНФОРМАЦИЯ И ОТЧЕТ НА СЕРВИЗНИТЕ ДОГОВОРИ

<p>
Командата връща данни за срока на последния регистриран договор (или "F" ако няма регистриран договор). 

<p>
 - Област за данни:
				 -# Няма данни
 - Отговор:
				 -# Left
				 -# RegDtTm
				 -# EIK
				 -# EndDate
			 -# или
				 -# "F"
 - Left		Цяло число - брой оставащи полета за регистрация на сервизен договор.
 - RegDtTm		Дата и час на регистрация на сервизен договор: "DD-MM-YYYY hh:mm:ss".
 - EndDate		Дата на изтичане на сервизен договор във формат "DD-MM-YYYY".
 - ЕИК		9 или 13 цифри - ЕИК на сервизната фирма.

<p>
Забележка:
Срокът на изтичане на текущия сервизен договор се печати в края на всеки дневен отчет с нулиране. 


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"left" - Left		Цяло число - брой оставащи полета за регистрация на сервизен договор.
 - KeyValue - \@"registrationDateTime" - RegDtTm		Дата и час на регистрация на сервизен договор: "DD-MM-YYYY hh:mm:ss".
 - KeyValue - \@"endDate" - EndDate		Дата на изтичане на сервизен договор във формат "DD-MM-YYYY".
 - KeyValue - \@"eIK" - EIK		9 или 13 цифри - ЕИК на сервизната фирма.
*/

    -(NSDictionary *)command36Variant0Version0AndReturnError:(NSError **)error;
/**
24h (36) 	ИНФОРМАЦИЯ И ОТЧЕТ НА СЕРВИЗНИТЕ ДОГОВОРИ

<p>
Командата печата отчет на всички регистрирани договори по данни от фискалната памет.

<p>

<p>
 - Област за данни:
				 -# Няма данни
 - Отговор:
				 -# Left
				 -# RegDtTm
				 -# EIK
				 -# EndDate
			 -# или
				 -# "F"
 - Left		Цяло число - брой оставащи полета за регистрация на сервизен договор.
 - RegDtTm		Дата и час на регистрация на сервизен договор: "DD-MM-YYYY hh:mm:ss".
 - EndDate		Дата на изтичане на сервизен договор във формат "DD-MM-YYYY".
 - EIK		9 или 13 цифри - ЕИК на сервизната фирма.

<p>
Забележка:
Срокът на изтичане на текущия сервизен договор се печати в края на всеки дневен отчет с нулиране. 


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"left" - Left		Цяло число - брой оставащи полета за регистрация на сервизен договор.
 - KeyValue - \@"registrationDateTime" - RegDtTm		Дата и час на регистрация на сервизен договор: "DD-MM-YYYY hh:mm:ss".
 - KeyValue - \@"endDate" - EndDate		Дата на изтичане на сервизен договор във формат "DD-MM-YYYY".
 - KeyValue - \@"eIK" - EIK		9 или 13 цифри - ЕИК на сервизната фирма.
*/

    -(NSDictionary *)command36Variant0Version1AndReturnError:(NSError **)error;
/**
26h (38) 	ОТВАРЯНЕ НА СЛУЖЕБЕН БОН

<p>
 - Област за данни:
		 -# Няма данни
 - Отговор:
		 -# Allreceipt
		 -# ErrCode

<p>
 - Allreceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента /4 байта/.
 - ErrCode		Код на грешката при неуспешно изпълнена команда /1 байт/.

<p>
Забележка:

<p>
ФП извършва следните действия:
-	Отпечатва се HEADER.
-	Отпечатва се ЕИК на продавача.
-	Връща се отговор, съдържащ Allreceipt.
Командата не може да се изпълни, ако:
-	Фискалната памет не е форматирана.
-	Има отворен фискален бон.
-	Вече е отворен служебен бон.
-	Часовникът не е сверен.

<p>


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - Allreceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента /4 байта/.
*/

    -(NSDictionary *)command38Variant0Version0AndReturnError:(NSError **)error;
/**
27h (39) 	ЗАТВАРЯНЕ НА СЛУЖЕБЕН БОН

<p>
 - Област за данни:
		 -# Няма данни
 - Отговор:
		 -# Allreceipt

<p>
 - Allreceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня
			 -# до момента /4 байта/.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Отпечатва се FOOTER.
 - -	Отпечатва се поредния номер, датата и часа  на документа
 - -	Отпечатва се с широк печат "СЛУЖЕБЕН БОН".
 - -	Връща се отговор, съдържащ Allreceipt.

<p>
Ако е вдигнат S1.1 командата не е изпълнена защото в момента не е отворен служебен бон.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - AllReceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента /4 байта/.
*/

    -(NSDictionary *)command39Variant0Version0AndReturnError:(NSError **)error;
/**
29H (41)	ЗАПОМНЯНЕ НА НАСТРОЙКИТЕ И КЛЮЧЕТАТА ВЪВ FLASH-ПАМЕТТА

<p>
 - Data field:
		 -# Switches
 - Response:
		 -# Няма данни

<p>
 - Switches		8 байта със стойност '0' или '1' - конфигурационните "ключета".

<p>
Забележка:

<p>
Принтерът няма хардуерни ключета и използува за целта област във флаш-паметта. 
Установяването им става с тази команда. 

<p>
ВНИМАНИЕ! Номерацията започва от най-младшия бит.

<p>
Командата запомня следните дании в енергонезависимата (flash) памет:
 - -	Header и footer (от команда 43).
 - -	Текстът на допълнителните типове плащане (от команда 85).
 - -	Графичното лого (от команда 115).
 - -	Опциите за печат (от команда 43).
 - -	Конфигурационните ключета.

<p>
След RAM ресет стойностите им се възстановяват от тези във флаша.

<p>
Switch
 - 1	Задава скоростта на предаване на серийния порт
 - 2	Задава скоростта на предаване на серийния порт
 - 3	Задава скоростта на предаване на серийния порт
 - 4	- Не се използва
 - 5	- Не се използва
 - 6	- Не се използва
 - 7	- Не се използва
 - 8
		 -# Изключено	- Bluetooth е в режим DISCOVERABLE
		 -# Включено	- Bluetooth е в режим NON DISCOVERABLE

<p>

<p>

<p>

<p>

<p>
 - **********************************************
 - Ключе 1	Ключе 2	Ключе 3		Скорост
 - **********************************************
 - 0	     0	     0		1200 bps
 - 1	     0	     0		2400 bps
 - 0	     1	     0		4800 bps
 - 1	     1	     0		9600 bps
 - 0	     0	     1		19200 bps
 - 1	     0	     1		38400 bps
 - 0	     1	     1		57600 bps
 - 1	     1	     1		115200 bps
 - **********************************************

<p>


 <p>
 @param switches - Switches		8 байта със стойност '0' или '1' - конфигурационните "ключета".
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command41Variant0Version0Switches:(NSString *)switches error:(NSError **)error;
/**
29H (41)	ЗАПОМНЯНЕ НА НАСТРОЙКИТЕ И КЛЮЧЕТАТА ВЪВ FLASH-ПАМЕТТА

<p>
 - Data field:
		 -# Няма данни
 - Response:
		 -# Няма данни

<p>

<p>
Забележка:

<p>
Командата запомня следните дании в енергонезависимата (flash) памет:
 - -	Header и footer (от команда 43).
 - -	Текстът на допълнителните типове плащане (от команда 85).
 - -	Графичното лого (от команда 115).
 - -	Опциите за печат (от команда 43).

<p>
След RAM ресет стойностите им се възстановяват от тези във флаша.


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command41Variant0Version1AndReturnError:(NSError **)error;
/**
2Ah (42)	ПЕЧАТАНЕ НА СВОБОДЕН ТЕКСТ В СЛУЖЕБЕН БОН

<p>
 - Област за данни:
		 -# TheText
 - Отговор:
		 -# Няма данни

<p>
 - TheText	Текст до 30 символа. Символите след 30-я се отрязват.

<p>
Забележка:

<p>
В началото и края на реда се отпечатва символът '#'.
Ако е вдигнат S1.1, значи в момента не е отворен служебен бон и текста не е отпечатан.


 <p>
 @param inText - TheText	Текст до 30 символа. Символите след 30-я се отрязват.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command42Variant0Version0InText:(NSString *)inText error:(NSError **)error;
/**
2Bh (43) 	УСТАНОВЯВАНЕ НА HEADER И FOOTER И ОПЦИИ ЗА ПЕЧАТ

<p>
Този метод се използва за запис.

<p>
 - Област за данни:
		 -# ITEM_INDEX
		 -# DATA_VALUE
 - Отговор:
		 -# Зависи от областта за данни

<p>

<p>
 - ITEM_INDEX
		 -# Един символ със следното значение:

<p>
		 -# '0' до '7' 	е номера на линията, която се задава. Линиите на HEADER са с номера от 0 до 5, а тези
			 -# на FOOTER - 6 и 7.

<p>
		 -# 'А'	Автоматично форматиране на продажбите като за фактура (4 отделни реда).

<p>
		 -# 'B'	Задава височината на баркода в пиксели (0.125 mm). Възможни стойности от 24 (3 mm)
			 -# до 240 (30 mm). Баркодът се печати с команда 84 (54H).

<p>
		 -# 'D'	Задава плътност на печат. Възможни стойности:
			 -# '1':	Много блед
			 -# '2':	Блед
			 -# '3':	Нормален
			 -# '4':	Плътен
			 -# '5':	Много плътен

<p>
		 -# 'E'	Разрешаване / забраняване на печата на общата сума в EUR при първата команда за плащане
			 -# (53) във фискален бон. По подразбиране печатът е забранен. Опционално командата задава
			 -# и валидния курс EUR/ЛВ. Синтаксис на данните:
			 -# <Enable>[,Rate]
				 -# Enable	Флаг за забрана / разрешаване на печата. Един байт: '0' или '1'.
				 -# Rate	Обменен курс. Плаващо число с до 8 значещи цифри и 5 десетични знака.
					 -# Ако липсва, запазва се старата стойност.
					 -# Ако е 0.00000, то стойност в евро не се печати независимо от Enable.

<p>
		 -# 'L'	Разрешаване / забраняване печата на графичното лого непосредствено преди HEADER-а.
			 -# Данните Text са във формат <Enable>,<H>.
				 -# H е височината на логото в пиксели;
				 -# Enable е един байт със стойност '1' (разрешено) или '0' (забранено);

<p>
		 -# 'N'	Разрешаване / забраняване на отпечатването на името на департамента в началото на
			 -# всеки фискален бон.

<p>
		 -# 'R'	Добавяне на допълнително разстояние между символите в режим "печат на завъртян на
			 -# 90 градуса текст". След буквата следва едно цяло число със стойност от 0 до 4.

<p>
		 -# 'T'	Разрешаване / забраняване на отпечатването на натрупания ДДС за бона в нормален
			 -# (не разширен) фискален бон.

<p>
		 -# 'X'	Разрешаване / забраняване на автоматичното генерирането на импулс за отваряне на
			 -# чекмедже при команди 53 (35H) и 70 (46H).

<p>
		 -# DATA_VALUE
			 -# Текст до 36 символа, като:

<p>
			 -# Ако <Item> е цифра от '0' до '7' - текста от който се състои съответната линия.

<p>
			 -# Ако <Item> = 'А' - един символ '0' или '1', като '0' забранява, а '1' разрешава форматирането
				 -# тип "фактура". Ако е разрешено, тогава за всяка продажба се отпечатват по 4 реда
				 -# - за име, единична цена, количество и цена с данъчна група.

<p>
			 -# Ако <Item>  =  'B' - Число, задаващо височината в на баркода пиксели.
			 -# Ако <Item>  =  'D' - Плътността на печат (от 1 до 5).
			 -# Ако <Item> = 'E' - Връща се Enable,Rate, където
				 -# - Enable е флагът забранено / разрешено;
				 -# - Rate е текущият програмиран обменен курс.
			 -# Ако <Item> = 'L' - Връща се Enable,H, където H е височината на графичното лого, а Enable е
				 -# флагът забранено / разрешено.
			 -# Ако <Item> = 'N' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# името на департамента в началото на всеки фискален бон.
			 -# Ако <Item> = 'R' - цяло число от 0 до 4: Допълнителното разстояние между символите в режим
				 -# "печат на завъртян на 90 градуса текст".
			 -# Ако <Item> = 'Т' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# натрупания ДДС в нормален (не разширен) фискален бон.
			 -# Ако <Item> = 'X' - един символ '0' или '1', като '1' забранява, а '0' разрешава автоматичното отваряне
				 -# на чекмедже при команди 53 (35H) и 70 (46H).

<p>
Забележка - неща които трябва да се знаят предварително:
 - 1. HEADER се състои от 6 реда текст, които се отпечатват в началото на всеки фискален или служебен бон.
 - 2. За нормална работа на принтера е необходимо да се зададат поне 2 реда Header.
 - 3. ЕИК (зададен от команда 98) се печати винаги на трети ред, така че редовете от HEADER-а след втория
 - автоматично се преместват с една позиция надолу.
 - 4. FOOTER се състои от 2 линии текст, които се отпечатват в края на всеки бон.
 - 5. HEADER и FOOTER се центрират автоматично.
 - 6. Тази команда трябва да се изпълни до 8 пъти, за да се зададат всичките линии на HEADER и FOOTER.
 - 7. Логото се дефинира с команда 115.

<p>

<p>


 <p>
 @param itemIndex -  - ITEM_INDEX
		 -# Един символ със следното значение:

<p>
		 -# '0' до '7' е номера на линията, която се задава. Линиите на HEADER са с номера от 0 до 5, а тези на FOOTER - 6 и 7.
		 -# 'А'	Автоматично форматиране на продажбите като за фактура (4 отделни реда).

<p>
		 -# 'B'	Задава височината на баркода в пиксели (0.125 mm). Възможни стойности от 24 (3 mm) до 240 (30 mm).
			 -# Баркодът се печати с команда 84 (54H).

<p>
		 -# 'D'	Задава плътност на печат. Възможни стойности:
			 -# '1':	Много блед
			 -# '2':	Блед
			 -# '3':	Нормален
			 -# '4':	Плътен
			 -# '5':	Много плътен

<p>
		 -# 'E'	Разрешаване / забраняване на печата на общата сума в EUR при първата команда за плащане (53) във
			 -# фискален бон. По подразбиране печатът е забранен.
			 -# Опционално командата задава и валидния курс EUR/ЛВ.
			 -# Синтаксис на данните:
			 -# <Enable>[,Rate]
				 -# Enable	Флаг за забрана / разрешаване на печата. Един байт: '0' или '1'.
				 -# Rate	Обменен курс. Плаващо число с до 8 значещи цифри и 5 десетични знака.
					 -# Ако липсва, запазва се старата стойност.
					 -# Ако е 0.00000, то стойност в евро не се печати независимо от Enable.

<p>
		 -# 'L'	Разрешаване / забраняване печата на графичното лого непосредствено преди HEADER-а.
			 -# Данните Text са във формат <Enable>,<H>.
				 -# H е височината на логото в пиксели;
				 -# Enable е един байт със стойност '1' (разрешено) или '0' (забранено);

<p>
		 -# 'N'	Разрешаване / забраняване на отпечатването на името на департамента в началото на всеки
			 -# фискален бон.

<p>
		 -# 'R'	Добавяне на допълнително разстояние между символите в режим "печат на завъртян на
			 -# 90 градуса текст".
			 -# След буквата следва едно цяло число със стойност от 0 до 4.

<p>
		 -# 'T'	Разрешаване / забраняване на отпечатването на натрупания ДДС за бона в нормален (не разширен)
			 -# фискален бон.

<p>
		 -# 'X'	Разрешаване / забраняване на автоматичното генерирането на импулс за отваряне на чекмедже при
			 -# команди 53 (35H) и 70 (46H).

 @param dataValue - DATA_VALUE	
 - Текст до 36 символа, като:

<p>
 - Ако <Item> е цифра от '0' до '7' - текста от който се състои съответната линия.

<p>
 - Ако <Item> = 'А' - един символ '0' или '1', като '0' забранява, а '1' разрешава форматирането тип "фактура".
		 -# Ако е разрешено, тогава за всяка продажба се отпечатват по 4 реда - за име, единична цена, количество и
		 -# цена с данъчна група.

<p>
 - Ако <Item>  =  'B' - Число, задаващо височината в на баркода пиксели.
 - Ако <Item>  =  'D' - Плътността на печат (от 1 до 5).
 - Ако <Item> = 'E' - Връща се Enable,Rate, където
		 -# Enable е флагът забранено / разрешено;
		 -# Rate е текущият програмиран обменен курс.
 - Ако <Item> = 'L' - Връща се Enable,H, където
		 -# H е височината на графичното лого;
		 -# Enable е флагът забранено / разрешено;
 - Ако <Item> = 'N' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на името на
		 -# департамента в началото на всеки фискален бон.
 - Ако <Item> = 'R' - цяло число от 0 до 4: Допълнителното разстояние между символите в режим "печат на завъртян на
		 -# 90 градуса текст".
 - Ако <Item> = 'Т' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на натрупания ДДС в
		 -# нормален (не разширен) фискален бон.
 - Ако <Item> = 'X' - един символ '0' или '1', като '1' забранява, а '0' разрешава автоматичното отваряне на чекмедже при
		 -# команди 53 (35H) и 70 (46H).

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command43Variant0Version0ItemIndex:(NSString *)itemIndex dataValue:(NSString *)dataValue error:(NSError **)error;
/**
2Bh (43) 	УСТАНОВЯВАНЕ НА HEADER И FOOTER И ОПЦИИ ЗА ПЕЧАТ

<p>
 - Област за данни:
		 -# INP_STR

<p>
 - Отговор:
		 -# OUTP_STR	Зависи от областта за данни

<p>
Забележка - неща които трябва да се знаят предварително:
 - 1. HEADER се състои от 6 реда текст, които се отпечатват в началото на всеки фискален или служебен бон.
 - 2. За нормална работа на принтера е необходимо да се зададат поне 2 реда Header.
 - 3. ЕИК (зададен от команда 98) се печати винаги на трети ред, така че редовете от HEADER-а след втория
 - автоматично се преместват с една позиция надолу.
 - 4. FOOTER се състои от 2 линии текст, които се отпечатват в края на всеки бон.
 - 5. HEADER и FOOTER се центрират автоматично.
 - 6. Тази команда трябва да се изпълни до 8 пъти, за да се зададат всичките линии на HEADER и FOOTER.
 - 7. Логото се дефинира с команда 115.

<p>

<p>
 - INP_STR
		 -# Един символ със следното значение:

<p>
		 -# '0' до '7' 	е номера на линията, която се задава. Линиите на HEADER са с номера от 0 до 5, а тези
			 -# на FOOTER - 6 и 7.

<p>
		 -# 'А'	Автоматично форматиране на продажбите като за фактура (4 отделни реда).

<p>
		 -# 'B'	Задава височината на баркода в пиксели (0.125 mm). Възможни стойности от 24 (3 mm)
			 -# до 240 (30 mm). Баркодът се печати с команда 84 (54H).

<p>
		 -# 'D'	Задава плътност на печат. Възможни стойности:
			 -# '1':	Много блед
			 -# '2':	Блед
			 -# '3':	Нормален
			 -# '4':	Плътен
			 -# '5':	Много плътен

<p>
		 -# 'E'	Разрешаване / забраняване на печата на общата сума в EUR при първата команда за плащане
			 -# (53) във фискален бон. По подразбиране печатът е забранен. Опционално командата задава
			 -# и валидния курс EUR/ЛВ. Синтаксис на данните:
			 -# <Enable>[,Rate]
				 -# Enable	Флаг за забрана / разрешаване на печата. Един байт: '0' или '1'.
				 -# Rate	Обменен курс. Плаващо число с до 8 значещи цифри и 5 десетични знака.
					 -# Ако липсва, запазва се старата стойност.
					 -# Ако е 0.00000, то стойност в евро не се печати независимо от Enable.

<p>
		 -# 'L'	Разрешаване / забраняване печата на графичното лого непосредствено преди HEADER-а.
			 -# Данните Text са във формат <Enable>,<H>.
				 -# H е височината на логото в пиксели;
				 -# Enable е един байт със стойност '1' (разрешено) или '0' (забранено);

<p>
		 -# 'N'	Разрешаване / забраняване на отпечатването на името на департамента в началото на
			 -# всеки фискален бон.

<p>
		 -# 'R'	Добавяне на допълнително разстояние между символите в режим "печат на завъртян на
			 -# 90 градуса текст". След буквата следва едно цяло число със стойност от 0 до 4.

<p>
		 -# 'T'	Разрешаване / забраняване на отпечатването на натрупания ДДС за бона в нормален
			 -# (не разширен) фискален бон.

<p>
		 -# 'X'	Разрешаване / забраняване на автоматичното генерирането на импулс за отваряне на
			 -# чекмедже при команди 53 (35H) и 70 (46H).

<p>
 - OUTP_STR
			 -# Текст до 36 символа, като:

<p>
			 -# Ако <INP_STR> е цифра от '0' до '7' - текста от който се състои съответната линия.

<p>
			 -# Ако <INP_STR> = 'А' - един символ '0' или '1', като '0' забранява, а '1' разрешава форматирането
				 -# тип "фактура". Ако е разрешено, тогава за всяка продажба се отпечатват по 4 реда
				 -# - за име, единична цена, количество и цена с данъчна група.

<p>
			 -# Ако <INP_STR>  =  'B' - Число, задаващо височината в на баркода пиксели.
			 -# Ако <INP_STR> = 'C' - един символ '0' или '1', като '0' забранява, а '1' разрешава автоматичното
			 -# отрязване на бона.
			 -# Ако <INP_STR>  =  'D' - Плътността на печат (от 1 до 5).
			 -# Ако <INP_STR> = 'E' - Връща се Enable,Rate, където
				 -# - Enable е флагът забранено / разрешено;
				 -# - Rate е текущият програмиран обменен курс.
			 -# Ако <INP_STR> = 'L' - Връща се Enable,H, където H е височината на графичното лого, а Enable е
				 -# флагът забранено / разрешено.
			 -# Ако <INP_STR> = 'N' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# името на департамента в началото на всеки фискален бон.
			 -# Ако <INP_STR> = 'R' - цяло число от 0 до 4: Допълнителното разстояние между символите в режим
				 -# "печат на завъртян на 90 градуса текст".
			 -# Ако <INP_STR> = 'Т' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# натрупания ДДС в нормален (не разширен) фискален бон.
			 -# Ако <INP_STR> = 'X' - един символ '0' или '1', като '1' забранява, а '0' разрешава автоматичното отваряне
				 -# на чекмедже при команди 53 (35H) и 70 (46H).

<p>

<p>


 <p>
 @param inText - INP_STR	
		 -# Един символ със следното значение:

<p>
		 -# '0' до '7' е номера на линията, която се задава. Линиите на HEADER са с номера от 0 до 5, а тези на FOOTER - 6 и 7.
		 -# 'А'	Автоматично форматиране на продажбите като за фактура (4 отделни реда).

<p>
		 -# 'B'	Задава височината на баркода в пиксели (0.125 mm). Възможни стойности от 24 (3 mm) до 240 (30 mm).
			 -# Баркодът се печати с команда 84 (54H).

<p>
		 -# 'D'	Задава плътност на печат. Възможни стойности:
			 -# '1':	Много блед
			 -# '2':	Блед
			 -# '3':	Нормален
			 -# '4':	Плътен
			 -# '5':	Много плътен

<p>
		 -# 'E'	Разрешаване / забраняване на печата на общата сума в EUR при първата команда за плащане (53) във
			 -# фискален бон. По подразбиране печатът е забранен.
			 -# Опционално командата задава и валидния курс EUR/ЛВ.
			 -# Синтаксис на данните:
			 -# <Enable>[,Rate]
				 -# Enable	Флаг за забрана / разрешаване на печата. Един байт: '0' или '1'.
				 -# Rate	Обменен курс. Плаващо число с до 8 значещи цифри и 5 десетични знака.
					 -# Ако липсва, запазва се старата стойност.
					 -# Ако е 0.00000, то стойност в евро не се печати независимо от Enable.

<p>
		 -# 'L'	Разрешаване / забраняване печата на графичното лого непосредствено преди HEADER-а.
			 -# Данните Text са във формат <Enable>,<H>.
				 -# H е височината на логото в пиксели;
				 -# Enable е един байт със стойност '1' (разрешено) или '0' (забранено);

<p>
		 -# 'N'	Разрешаване / забраняване на отпечатването на името на департамента в началото на всеки
			 -# фискален бон.

<p>
		 -# 'R'	Добавяне на допълнително разстояние между символите в режим "печат на завъртян на
			 -# 90 градуса текст".
			 -# След буквата следва едно цяло число със стойност от 0 до 4.

<p>
		 -# 'T'	Разрешаване / забраняване на отпечатването на натрупания ДДС за бона в нормален (не разширен)
			 -# фискален бон.

<p>
		 -# 'X'	Разрешаване / забраняване на автоматичното генерирането на импулс за отваряне на чекмедже при
			 -# команди 53 (35H) и 70 (46H).

<p>
		 -# 'I' 	Дава възможност да прочетем стойностите, зададени по-рано с команда 43.
			 -# След буквата 'I' следва точно още един символ, съвпадащ с някой от по-горните.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outText" - OUTP_STR	
			 -# Текст до 36 символа, като:

<p>
			 -# Ако <INP_STR> е цифра от '0' до '7' - текста от който се състои съответната линия.

<p>
			 -# Ако <INP_STR> = 'А' - един символ '0' или '1', като '0' забранява, а '1' разрешава форматирането
				 -# тип "фактура". Ако е разрешено, тогава за всяка продажба се отпечатват по 4 реда
				 -# - за име, единична цена, количество и цена с данъчна група.

<p>
			 -# Ако <INP_STR>  =  'B' - Число, задаващо височината в на баркода пиксели.
			 -# Ако <INP_STR>  =  'D' - Плътността на печат (от 1 до 5).
			 -# Ако <INP_STR> = 'E' - Връща се Enable,Rate, където
				 -# - Enable е флагът забранено / разрешено;
				 -# - Rate е текущият програмиран обменен курс.
			 -# Ако <INP_STR> = 'L' - Връща се Enable,H, където H е височината на графичното лого, а Enable е
				 -# флагът забранено / разрешено.
			 -# Ако <INP_STR> = 'N' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# името на департамента в началото на всеки фискален бон.
			 -# Ако <INP_STR> = 'R' - цяло число от 0 до 4: Допълнителното разстояние между символите в режим
				 -# "печат на завъртян на 90 градуса текст".
			 -# Ако <INP_STR> = 'Т' - един символ '0' или '1', като '0' забранява, а '1' разрешава отпечатването на
				 -# натрупания ДДС в нормален (не разширен) фискален бон.
			 -# Ако <INP_STR> = 'X' - един символ '0' или '1', като '1' забранява, а '0' разрешава автоматичното отваряне
				 -# на чекмедже при команди 53 (35H) и 70 (46H).

<p>

*/

    -(NSDictionary *)command43Variant0Version1InText:(NSString *)inText error:(NSError **)error;
/**
2Ch (44)	ПРИДВИЖВАНЕ НА ХАРТИЯТА.

<p>
 - Област за данни:
				 -# Lines
 - Отговор:
				 -# Няма данни

<p>
TRGT_LINES	Броят на редовете, с които да бъде придвижена хартията. 
		 -# Трябва да бъде положително число не по-голямо от 99 /1 или 2 байта/.


 <p>
 @param targetLines - TRGT_LINES	Броят на редовете, с които да бъде придвижена хартията. 
		 -# Трябва да бъде положително число не по-голямо от 99 /1 или 2 байта/.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command44Variant0Version0TargetLines:(NSString *)targetLines error:(NSError **)error;
/**
30h (48)	ОТВАРЯНЕ НА ФИСКАЛЕН (КЛИЕНТСКИ) БОН

<p>
 - Област за данни:
			 -# OpCode
			 -# OpPwd
			 -# TillNmb
 - Отговор:
			 -# Allreceipt
			 -# FiscReceipt

<p>
 - OpCode		Номер на оператор /1 до 16/
 - OpPwd		Операторска парола /4 до 8 цифри/
 - TillNmb		Номер на касово място /цяло число от 1 до 99999/

<p>
 - Allreceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента. /4 байта/
 - FiscReceipt	Броят на всички издадени фискални бонове от последното приключване на деня до момента. /4 байта/

<p>

<p>
Забележка:

<p>
ФП извършва следните действия:
-	Отпечатва се HEADER.
-	Отпечатва се ЕИК.
-	Отпечатва се номер и име на оператор и номер на касово място.
-	Връщат се AllReceipt и FiscReceipt.

<p>
Командата няма да бъде изпълнена успешно, ако:
-	Има отворен фискален или служебен бон.
-	Фискалната памет е пълна.
-	Фискалната памет е повредена.
-	Липсва код или парола на оператор, или номер на касово място.
-	HEADER съдържа по-малко от 2 реда.
-	Не е зададен ЕИК.
-	Не е вярна операторската парола.
-	Часовникът не е сверен.
-	КЛЕН е пълна или не фунционира.
-	Данъчният терминал не функционира, или информацията в него не съответствува на тази във фискалната памет

<p>
При три грешни операторски пароли принтерът блокира и трябва да се изключи и включи за продължаване на работата.


 <p>
 @param operatorCode - OpCode	Operator's number (1 to 16)
 @param operatorPassword - OpPwd	Operator's password (4 to 8 digits)
 @param tillNumber - TillNmb	Number of point of sale (a whole number of maximum 5 digits)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceiptNumber" - Allreceipt	 Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента. /4 байта/ 
 - KeyValue - \@"fiscalReceiptNumber" - FiscReceipt	Броят на всички издадени фискални бонове от последното приключване на деня до момента. /4 байта/
*/

    -(NSDictionary *)command48Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error;
/**
30h (48)	ОТВАРЯНЕ НА ФИСКАЛЕН (КЛИЕНТСКИ) БОН - ФАКТУРА (разширена клиентска бележка)

<p>
 - Област за данни:
			 -# OpCode
			 -# OpPwd
			 -# TillNmb
 - Отговор:
			 -# Allreceipt
			 -# FiscReceipt

<p>
 - OpCode		Номер на оператор /1 до 16/
 - OpPwd		Операторска парола /4 до 8 цифри/
 - TillNmb		Номер на касово място /цяло число от 1 до 99999/

<p>
 - Allreceipt		Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента. /4 байта/
 - FiscReceipt	Броят на всички издадени фискални бонове от последното приключване на деня до момента. /4 байта/

<p>
Забележка:

<p>
Метода предизвиква отпечатването на разширена клиентска бележка (фактура). 
Автоматично след HEADER-а се отпечатва номера на фактурата, а след първата команда за плащане разпечатка на сумите по данъчни групи. 
След плащането трябва да се отпечата информация за купувача с команда 57 (39h).

<p>
ФП извършва следните действия:
-	Отпечатва се HEADER.
-	Отпечатва се ЕИК.
-	Отпечатва се номер и име на оператор и номер на касово място.
-	Връщат се AllReceipt и FiscReceipt.

<p>
Командата няма да бъде изпълнена успешно, ако:
-	Има отворен фискален или служебен бон.
-	Фискалната памет е пълна.
-	Фискалната памет е повредена.
-	Липсва код или парола на оператор, или номер на касово място.
-	HEADER съдържа по-малко от 2 реда.
-	Не е зададен ЕИК.
-	Не е вярна операторската парола.
-	Часовникът не е сверен.
-	КЛЕН е пълна или не фунционира.
-	Данъчният терминал не функционира, или информацията в него не съответствува на тази във фискалната памет

<p>
При три грешни операторски пароли принтерът блокира и трябва да се изключи и включи за продължаване на работата.


 <p>
 @param operatorCode - OpCode	Operator's number (1 to 16)
 @param operatorPassword - OpPwd	Operator's password (4 to 8 digits)
 @param tillNumber - TillNmb	Number of point of sale (a whole number of maximum 5 digits)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceiptNumber" - Allreceipt	 Броят на всички издадени бонове (фискални и служебни) от последното приключване на деня до момента. /4 байта/ 
 - KeyValue - \@"fiscalReceiptNumber" - FiscReceipt	Броят на всички издадени фискални бонове от последното приключване на деня до момента. /4 байта/
*/

    -(NSDictionary *)command48Variant0Version1OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword tillNumber:(NSString *)tillNumber error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля
		 -# 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата
		 -# продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията
		 -# за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват
		 -# съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите
		 -# за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка 
от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant0Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant1Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant2Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant3Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant3Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant3Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
		 -# Qwan
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant3Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant4Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant4Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant4Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
		 -# Qwan
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant4Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant5Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant5Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
Забележка:

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant5Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
		 -# Qwan
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.
 - Qwan	Параметър, задаващ количеството на стоката. По подразбиране е 1.000.
		 -# Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 8 значещи цифри.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група. Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет. В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера. Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param itemQuantity - Qwan	

<p>
Параметър, задаващ количеството на стоката. По подразбиране е 1.000. 
Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението Price*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да надхвърля 
8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant5Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните
		 -# ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри.
		 -# Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant6Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните
		 -# ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри.
		 -# Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant6Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните
		 -# ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри.
		 -# Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant6Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните
		 -# ставки в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри.
		 -# Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant6Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата 	продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant7Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата 	продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant7Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата 	продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant7Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата 	продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant7Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# TaxCd
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant8Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# TaxCd
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant8Version1TextRow1:(NSString *)textRow1 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# TaxCd
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant8Version2TextRow2:(NSString *)textRow2 taxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# TaxCd
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>

<p>
 - TaxCd	Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).
		 -# Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки
		 -# в команда 83.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се
		 -# отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param taxGroup - TaxCd	

<p>
Един байт съдържащ буквата показваща видът на данъка ('А', 'Б', 'В', ...).  
Има ограничение зависещо от параметъра Enabled_Taxes, който се установява при задаването на данъчните ставки в команда 83.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant8Version3TaxGroup:(NSString *)taxGroup itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant9Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant9Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant9Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant9Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата продажба. Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant10Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата продажба. Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant10Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата продажба. Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant10Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
		 -# Perc
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - Perc	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата продажба. Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithPercentDiscount - Perc	

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant10Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# L2
		 -# Dept
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant11Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L1
		 -# Dept
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow1 - L1	Текст до 30 байта съдържащ ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant11Version1TextRow1:(NSString *)textRow1 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# L2
		 -# Dept
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param textRow2 - L2	Текст до 30 байта съдържащ втори ред, описващ продажбата
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant11Version2TextRow2:(NSString *)textRow2 sellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
31h (49)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА СТОКА

<p>
 - Област за данни:
		 -# Dept
		 -# Price
		 -# AbsSum
 - Отговор:
		 -# Няма данни

<p>
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
		 -# Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.
 - Price	Това е единичната цена и е до 8 значещи цифри. Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка
		 -# от нула.
 - AbsSum	Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като
		 -# сума. Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
ФП извършва следните действия:
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Текстът описващ продажбата се отпечатва заедно с цената и кода на данъчната група.
		 -# Ако има зададено количество, информацията за него също се отпечатва.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него.
		 -# Надбавките и отстъпките, ако има такива, се отчитат.

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.

<p>
ВНИМАНИЕ!!! 
За да се осъществи успешен войд - трябва да изпълните съвсем точно последната продажба (дори и текста), като цената трябва да е 
със знак "-",т.е. по-малка от нула.


 <p>
 @param sellInDepartment - Dept

<p>
Номер на департамент. Цяло число от 1 до 60 включително. 
Продажбата се причислява към данъчната група, с която е асоцииран департаментът при програмирането му.

 @param itemPrice - Price	

<p>
Това е единичната цена и е до 8 значещи цифри. 
Ако ще правите войд - цената трябва да е със знак "-",т.е. по-малка от нула.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command49Variant11Version3SellInDepartment:(NSString *)sellInDepartment itemPrice:(NSString *)itemPrice sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
32h (50)	ДАНЪЧНИ СТАВКИ ЗАДАВАНИ ПРЕЗ СЪОТВЕТНИЯ ПЕРИОД

<p>
 - Област за данни:
		 -# StartDate
		 -# EndDate
 - Отговор:
		 -# Data

<p>
 - StartDate		Дата за начало на периода - DDMMYY /6 bytes/.
 - EndDate		Дата за край на периода - DDMMYY /6 bytes/.

<p>
 - Data
			 -# F - ако не са намерени данъчни ставки за периода или в случай на грешка.
			 -# PАА,BB,CC,DD,EE,FF,GG,HH,DDMMYY ако са намерени ставки, като 'P' означава 'PASS' и след
			 -# това се изброяват последните активни ставки за посочения период и датата на тяхното задаване.

<p>
Забележка:

<p>
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 
Командата разпечатва отчет на промените на десетичните знаци и данъчните ставки за посочения период.


 <p>
 @param startDate - StartDate		The starting date of the period - DDMMYY/6 bytes/
 @param endDate - EndDate The end date of the period - DDMMYY /6 bytes/
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fResult" - F_RESULT	'F' if no tax rates for the period have been found, or in case of error
		 -# 'P' means 'PASS' after which the last active rates for the period

 - KeyValue - \@"aA" - AA

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"bB" - BB

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"cC" - CC

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"dD" - DD

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"eE" - EE

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"fF" - FF

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"gG" - GG

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"hH" - HH

<p>
изброяват се последните активни ставки за посочения период и датата на тяхното задаване.
Ако има групи, които не се използват (забранени с Enabled_rates), то за тях вместо ставка в проценти се връща 'DT' (Disabled Tax). 

 - KeyValue - \@"dDMMYY" - DDMMYY	

<p>

<p>
'AA,BB,CC,DD,DDMMYY' last active rates for the period are listed out as well as the date of their entry. If there are 
unused groups (disabled by command 83) for them, instead of  rate in percent a 'DT' is returned (Disabled tax).

*/

    -(NSDictionary *)command50Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
33h (51)	МЕЖДИННА СУМА

<p>
 - Област за данни:
			 -# ToPrint
			 -# ToDisplay

<p>
 - Отговор:
			 -# SubTotal,
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - ToPrint		Един байт, който ако е '1' стойността на под сумата ще се отпечата.
 - ToDisplay		Един байт, който ако е '1' стойността на под сумата ще се покаже на дисплея.

<p>
 - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - TaxA		Сумата по данъчна група А /до 10 байта/
 - TaxB		Сумата по данъчна група Б /до 10 байта/
 - TaxC		Сумата по данъчна група В /до 10 байта/
 - TaxD		Сумата по данъчна група Г /до 10 байта/
 - TaxE		Сумата по данъчна група Д /до 10 байта/
 - TaxF		Сумата по данъчна група Е /до 10 байта/
 - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - TaxH		Сумата по данъчна група З /до 10 байта/

<p>
Забележка:

<p>
Изчислява се сума на всички продажби регистрирани във фискалния бон до момента. 
По желание сумата може да бъде отпечатана и/или показана на дисплея. 
Към PC се връща изчислената сума и натрупаните до момента суми за всяка данъчна група. 
Ако е посочена надбавка или отстъпка, тя се отпечатва на отделен ред и натрупаните суми по данъчни групи се коригират съответно.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - KeyValue - \@"taxGroupA" - TaxA		Сумата по данъчна група А /до 10 байта/
 - KeyValue - \@"taxGroupB" - TaxB		Сумата по данъчна група Б /до 10 байта/
 - KeyValue - \@"taxGroupC" - TaxC		Сумата по данъчна група В /до 10 байта/
 - KeyValue - \@"taxGroupD" - TaxD		Сумата по данъчна група Г /до 10 байта/
 - KeyValue - \@"taxGroupE" - TaxE		Сумата по данъчна група Д /до 10 байта/
 - KeyValue - \@"taxGroupF" - TaxF		Сумата по данъчна група Е /до 10 байта/
 - KeyValue - \@"taxGroupG" - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - KeyValue - \@"taxGroupH" - TaxH		Сумата по данъчна група З /до 10 байта/
*/

    -(NSDictionary *)command51Variant0Version0AndReturnError:(NSError **)error;
/**
33h (51)	МЕЖДИННА СУМА

<p>
 - Област за данни:
			 -# ToPrint
			 -# ToDisplay
			 -# Perc

<p>
 - Отговор:
			 -# SubTotal,
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - ToPrint		Един байт, който ако е '1' стойността на под сумата ще се отпечата.
 - ToDisplay		Един байт, който ако е '1' стойността на под сумата ще се покаже на дисплея.
 - Perc		Параметър, който показва стойността в проценти на отстъпката или
			 -# надбавката върху натрупаната до момента сума.

<p>
 - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - TaxA		Сумата по данъчна група А /до 10 байта/
 - TaxB		Сумата по данъчна група Б /до 10 байта/
 - TaxC		Сумата по данъчна група В /до 10 байта/
 - TaxD		Сумата по данъчна група Г /до 10 байта/
 - TaxE		Сумата по данъчна група Д /до 10 байта/
 - TaxF		Сумата по данъчна група Е /до 10 байта/
 - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - TaxH		Сумата по данъчна група З /до 10 байта/

<p>
Забележка:

<p>
Изчислява се сума на всички продажби регистрирани във фискалния бон до момента. 
По желание сумата може да бъде отпечатана и/или показана на дисплея. 
Към PC се връща изчислената сума и натрупаните до момента суми за всяка данъчна група. 
Ако е посочена надбавка или отстъпка, тя се отпечатва на отделен ред и натрупаните суми по данъчни групи се коригират съответно.


 <p>
 @param withPercent - Perc

<p>
Незадължителен параметър, който показва стойността в проценти на отстъпката или надбавката върху натрупаната до момента сума.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - KeyValue - \@"taxGroupA" - TaxA		Сумата по данъчна група А /до 10 байта/
 - KeyValue - \@"taxGroupB" - TaxB		Сумата по данъчна група Б /до 10 байта/
 - KeyValue - \@"taxGroupC" - TaxC		Сумата по данъчна група В /до 10 байта/
 - KeyValue - \@"taxGroupD" - TaxD		Сумата по данъчна група Г /до 10 байта/
 - KeyValue - \@"taxGroupE" - TaxE		Сумата по данъчна група Д /до 10 байта/
 - KeyValue - \@"taxGroupF" - TaxF		Сумата по данъчна група Е /до 10 байта/
 - KeyValue - \@"taxGroupG" - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - KeyValue - \@"taxGroupH" - TaxH		Сумата по данъчна група З /до 10 байта/
*/

    -(NSDictionary *)command51Variant0Version1WithPercent:(NSString *)withPercent error:(NSError **)error;
/**
33h (51)	МЕЖДИННА СУМА

<p>
 - Област за данни:
			 -# ToPrint
			 -# ToDisplay
			 -# AbsSum

<p>
 - Отговор:
			 -# SubTotal,
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - ToPrint		Един байт, който ако е '1' стойността на под сумата ще се отпечата.
 - ToDisplay		Един байт, който ако е '1' стойността на под сумата ще се покаже на дисплея.
 - AbsSum		Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака),
			 -# като сума (до 8 значещи цифри).
			 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>
 - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - TaxA		Сумата по данъчна група А /до 10 байта/
 - TaxB		Сумата по данъчна група Б /до 10 байта/
 - TaxC		Сумата по данъчна група В /до 10 байта/
 - TaxD		Сумата по данъчна група Г /до 10 байта/
 - TaxE		Сумата по данъчна група Д /до 10 байта/
 - TaxF		Сумата по данъчна група Е /до 10 байта/
 - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - TaxH		Сумата по данъчна група З /до 10 байта/

<p>
Забележка:

<p>
Изчислява се сума на всички продажби регистрирани във фискалния бон до момента. 
По желание сумата може да бъде отпечатана и/или показана на дисплея. 
Към PC се връща изчислената сума и натрупаните до момента суми за всяка данъчна група. 
Ако е посочена надбавка или отстъпка, тя се отпечатва на отделен ред и натрупаните суми по данъчни групи се коригират съответно.


 <p>
 @param withAbsoluteSum - AbsSum	

<p>
Това е незадължителен параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума (до 8 значещи цифри). 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"subTotal" - SubTotal		Сумата до момента за текущия фискален бон /до 10 байта/
 - KeyValue - \@"taxGroupA" - TaxA		Сумата по данъчна група А /до 10 байта/
 - KeyValue - \@"taxGroupB" - TaxB		Сумата по данъчна група Б /до 10 байта/
 - KeyValue - \@"taxGroupC" - TaxC		Сумата по данъчна група В /до 10 байта/
 - KeyValue - \@"taxGroupD" - TaxD		Сумата по данъчна група Г /до 10 байта/
 - KeyValue - \@"taxGroupE" - TaxE		Сумата по данъчна група Д /до 10 байта/
 - KeyValue - \@"taxGroupF" - TaxF		Сумата по данъчна група Е /до 10 байта/
 - KeyValue - \@"taxGroupG" - TaxG		Сумата по данъчна група Ж /до 10 байта/
 - KeyValue - \@"taxGroupH" - TaxH		Сумата по данъчна група З /до 10 байта/
*/

    -(NSDictionary *)command51Variant0Version2WithAbsoluteSum:(NSString *)withAbsoluteSum error:(NSError **)error;
/**
35h (53)	ИЗЧИСЛЯВАНЕ НА СБОР (ТОТАЛ)

<p>
 - Област за данни:
		 -# Line1
		 -# Line2
		 -# PaidMode
		 -# AmountIn
 - Отговор:
		 -# PaidCode
		 -# AmountOut

<p>

<p>
 - Line1		Текст до 36 байта съдържащ първия ред
 - Line2		Текст до 36 байта съдържащ втория ред

<p>
 - PaidMode		Незадължителен код, указващ начина на плащане. Може да има следните стойности:
		 -# 'P'	- Плащане в брой (по подразбиране);
		 -# 'N'	- Плащане с кредит;
		 -# 'C'	- Плащане с чек;
		 -# 'D'	- Плащане с дебитна карта
		 -# 'I'	- Програмируем тип плащане 1
		 -# 'J'	- Програмируем тип плащане 2
		 -# 'K'	- Програмируем тип плащане 3
		 -# 'L'	- Програмируем тип плащане 4
 - В зависимост от кода сумите се натрупват в различни регистри и могат да бъдат получени в дневния отчет.

<p>
 - Amount_In	Сумата, която се плаща /до 10 значещи цифри/.

<p>

<p>
 - PaidCode		Един байт - резултат от изпълнението на командата.
		 -# 'F'	Грешка.
		 -# 'E'	Изчислената под сума е отрицателна. Плащане не се извършва и Amount ще съдържа отрицателната под сума.
		 -# 'D'	Ако платената сума е по-малка от сумата на бона. Остатъкът за доплащане се връща в Amount.
		 -# 'R'	Ако платената сума е по-голяма от сбора на бележката. Ще се отпечата съобщение "РЕСТО" и рестото се
			 -# връща в Amount.
		 -# 'I'	Сумата по някоя данъчна група е бил отрицателен и затова се е получила грешка. В Amount се връща
			 -# текущата под сума.

<p>
 - Amount_Out	До 9 цифри със знак. Зависи от PaidCode.

<p>
Забележка:

<p>
Тази команда предизвиква изчисляването на сумите от фискалния бон, отпечатването на сумата със специален шрифт и показването й на 
дисплей. Възможно е отпечатването на допълнителен текст. 
При успешно изпълнение на командата се генерира импулс за отваряне на чекмедже, ако това е разрешено с подкоманда 'X' на команда 43. 

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Натрупаната сума е отрицателна.
 - -	Ако някоя от натрупаните суми по данъчни групи е отрицателна.
След успешното изпълнение на командата, фискалният принтер няма да изпълнява командите 49 и 51 в рамките на отворения бон, обаче 
може да изпълнява команда 53.

<p>
Забележка: 
Кодове на грешка 'E' и 'I' никога няма да се получат в българската версия на принтера, защото команди 49 и 52 
(Регистриране на продажба) няма да допуснат отрицателни суми.

<p>


 <p>
 @param textRow1 - Line1		Текст до 32 байта съдържащ първия ред
 @param textRow2 - Line2		Текст до 32 байта съдържащ втория ред
 @param paidMode - PaidMode	A non-mandatory code indicating the terms of payment. It may have the following values:
 - 'P' 	Payment in cash
 - 'N' 	Payment via credit
 - 'C' 	Payment in cheques
 - 'D' 	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - Amount_In	The sum tendered (up to 9 meaningful symbols)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - PaidCode	One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change
		 -# will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to
		 -# Amount.

 - KeyValue - \@"amountOut" - Amount_Out	The sum tendered (up to 9 meaningful symbols)
*/

    -(NSDictionary *)command53Variant0Version0TextRow1:(NSString *)textRow1 textRow2:(NSString *)textRow2 paidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
35h (53)	ИЗЧИСЛЯВАНЕ НА СБОР (ТОТАЛ)

<p>
 - Област за данни:
		 -# PaidMode
		 -# AmountIn
 - Отговор:
		 -# PaidCode
		 -# AmountOut

<p>

<p>
 - PaidMode		Незадължителен код, указващ начина на плащане. Може да има следните стойности:
		 -# 'P'	- Плащане в брой (по подразбиране);
		 -# 'N'	- Плащане с кредит;
		 -# 'C'	- Плащане с чек;
		 -# 'D'	- Плащане с дебитна карта
		 -# 'I'	- Програмируем тип плащане 1
		 -# 'J'	- Програмируем тип плащане 2
		 -# 'K'	- Програмируем тип плащане 3
		 -# 'L'	- Програмируем тип плащане 4
 - В зависимост от кода сумите се натрупват в различни регистри и могат да бъдат получени в дневния отчет.

<p>
 - Amount_In	Сумата, която се плаща /до 10 значещи цифри/.

<p>

<p>

<p>
 - PaidCode		Един байт - резултат от изпълнението на командата.
		 -# 'F'	Грешка.
		 -# 'E'	Изчислената под сума е отрицателна. Плащане не се извършва и Amount ще съдържа отрицателната под сума.
		 -# 'D'	Ако платената сума е по-малка от сумата на бона. Остатъкът за доплащане се връща в Amount.
		 -# 'R'	Ако платената сума е по-голяма от сбора на бележката. Ще се отпечата съобщение "РЕСТО" и рестото се
			 -# връща в Amount.
		 -# 'I'	Сумата по някоя данъчна група е бил отрицателен и затова се е получила грешка. В Amount се връща
			 -# текущата под сума.

<p>
 - Amount_Out	До 9 цифри със знак. Зависи от PaidCode.

<p>
Забележка:

<p>
Тази команда предизвиква изчисляването на сумите от фискалния бон, отпечатването на сумата със специален шрифт и показването й на 
дисплей. Възможно е отпечатването на допълнителен текст. 
При успешно изпълнение на командата се генерира импулс за отваряне на чекмедже, ако това е разрешено с подкоманда 'X' на команда 43. 

<p>
Командата няма да бъде изпълнена успешно, ако:
 - -	Не е отворен фискален бон.
 - -	Натрупаната сума е отрицателна.
 - -	Ако някоя от натрупаните суми по данъчни групи е отрицателна.
След успешното изпълнение на командата, фискалният принтер няма да изпълнява командите 49 и 51 в рамките на отворения бон, обаче 
може да изпълнява команда 53.

<p>
Забележка: 
Кодове на грешка 'E' и 'I' никога няма да се получат в българската версия на принтера, защото команди 49 и 52 
(Регистриране на продажба) няма да допуснат отрицателни суми.

<p>


 <p>
 @param paidMode - PaidMode	A non-mandatory code indicating the terms of payment. It may have the following values:
 - 'P' 	Payment in cash
 - 'N' 	Payment via credit
 - 'C' 	Payment in cheques
 - 'D' 	Payment with a debit card
 - 'I'	Programmable payment 1
 - 'J'	Programmable payment 2
 - 'K'	Programmable payment 3
 - 'L'	Programmable payment 4

 @param amountIn - Amount_In	The sum tendered (up to 9 meaningful symbols)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidCode" - PaidCode	One byte - resulting from the execution of the command
 - 'F'	Error
 - 'E'	The calculated sub-total sum is negative. Payment is withheld and Amount will contain a negative sub-total.
 - 'D'	If the paid sum is less than the sum on the receipt. The residual sum due for payment is returned to Amount
 - 'R'	When the paid sum is greater than the sum on the receipt. A message "CHANGE" will be printed out and the change
		 -# will be returned to Amount.
 - 'I'	An error has occurred because the sum under one of the tax groups is negative. The current subtotal is returned to
		 -# Amount.

 - KeyValue - \@"amountOut" - Amount_Out	The sum tendered (up to 9 meaningful symbols)
*/

    -(NSDictionary *)command53Variant0Version1PaidMode:(NSString *)paidMode amountIn:(NSString *)amountIn error:(NSError **)error;
/**
36h (54)	ПЕЧАТАНЕ НА ФИСКАЛЕН СВОБОДЕН ТЕКСТ

<p>
 - Област за данни:
			 -# Input_Text
 - Отговор:
			 -# Няма данни

<p>
 - Input_Text	Текст до 30 байта

<p>

<p>
Забележка:
В началото и края на реда се отпечатва символът '#'.
Необходимо е да е отворен фискален бон. В противен случай не се отпечатва текста и се вдига S1.1. 
Ако текстът е по-дълг от 30 символа, то буквите след 30-та се изрязват.


 <p>
 @param inText - Input_Text	Текст до 30 байта
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command54Variant0Version0InText:(NSString *)inText error:(NSError **)error;
/**
38h (56)	ЗАТВАРЯНЕ (ПРИКЛЮЧВАНЕ) НА ФИСКАЛЕН БОН

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# Allreceipt
			 -# FiscReceipt

<p>
 - Allreceipt		Всички издадени бележки от последното приключване на деня до момента.
 - FiscReceipt	Всички издадени фискални бележки от последното приключване на деня до момента.

<p>

<p>
Забележка:
Натрупаните суми от фискалния бон се прибавят към дневните суми в регистрите на оперативната памет.
Командата няма да бъде изпълнена успешно, ако:
-	Не е отворен фискален бон.
-	Команда 53 (35h) не е изпълнена успешно.
-	Платената сума по команда 53 е по-малка от общата сума на фискалния бон.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"allReceipt" - Allreceipt		Всички издадени бележки от последното приключване на деня до момента.
 - KeyValue - \@"fiscalReceipt" - FiscReceipt	Всички издадени фискални бележки от последното приключване на деня до момента.
*/

    -(NSDictionary *)command56Variant0Version0AndReturnError:(NSError **)error;
/**
39h (57)	ПЕЧАТ НА ИНФОРМАЦИЯ ЗА КЛИЕНТА

<p>
 - Област за данни:
			 -# Bulstat
			 -# Seller
			 -# Receiver
			 -# Client
			 -# TaxNo
			 -# Address
 - Отговор:
			 -# Няма данни

<p>
 - Bulstat		ЕИК номер на купувача. Между 9 и 14 символа. Ако преди него стои символа '#', данните се считат за ЕГН.
 - Seller		Име на продавача. До 26 символа.
 - Receiver		Име на получателя. До 26 символа.
 - ClientName	Име на купувача. До 26 символа.
 - TaxNo		ЗДДС номер на купувача. Между 10 и 14 символа.
 - Address1		Адрес на купувача. Максимално от 36 символа.
 - Address2		Адрес на купувача. Максимално от 36 символа.

<p>

<p>
Забележка:
Командата е допустима само във разширен фискален бон (фактура) за унифицирано оформяне на боновете. 
Трябва да се изпълни непосредствено след цялостно плащане на натрупаната за бона сума. 
След това вече е разрешено затварянето на бона.


 <p>
 @param bulstat - Bulstat

<p>
ЕИК номер на купувача. Между 9 и 14 символа. Ако преди него стои символа '#', данните се считат за ЕГН.

 @param sellerName - Seller

<p>
Име на продавача. До 26 символа.

 @param receiverName - Receiver		Име на получателя. До 26 символа.
 @param clientName - ClientName		Име на купувача. До 26 символа.
 @param taxNumber - TaxNo		ЗДДС номер на купувача. Между 10 и 14 символа.
 @param clientAddress1 - Address1		Адрес на купувача. Максимално от 36 символа.
 @param clientAddress2 - Address2		Адрес на купувача. Максимално от 36 символа.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command57Variant0Version0Bulstat:(NSString *)bulstat sellerName:(NSString *)sellerName receiverName:(NSString *)receiverName clientName:(NSString *)clientName taxNumber:(NSString *)taxNumber clientAddress1:(NSString *)clientAddress1 clientAddress2:(NSString *)clientAddress2 error:(NSError **)error;
/**
39h (57)	ПЕЧАТ НА ИНФОРМАЦИЯ ЗА КЛИЕНТА

<p>
 - Област за данни:
			 -# Bulstat
 - Отговор:
			 -# Няма данни

<p>
 - Bulstat		ЕИК номер на купувача. Между 9 и 14 символа.
			 -# Ако преди него стои символа '#', данните се считат за ЕГН.

<p>

<p>
Забележка:
Командата е допустима само във разширен фискален бон (фактура) за унифицирано оформяне на боновете. 
Трябва да се изпълни непосредствено след цялостно плащане на натрупаната за бона сума. 
След това вече е разрешено затварянето на бона.


 <p>
 @param clientEIK - Bulstat

<p>
ЕИК номер на купувача. Между 9 и 14 символа. Ако преди него стои символа '#', данните се считат за ЕГН.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command57Variant0Version1ClientEIK:(NSString *)clientEIK error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param sellWithPercentDiscount - Perc

<p>
Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant0Version0Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant0Version1Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant0Version2Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param sellWithPercentDiscount - Perc

<p>
Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant1Version0Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant1Version1Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellInDepartment - Dept	Номер на департамент. Цяло число от 1 до 60 включително. 
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant1Version2Plu:(NSString *)plu sellInDepartment:(NSString *)sellInDepartment error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Dept
			 -# Qwan
			 -# Perc
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да
		 -# надхвърля 8 значещи цифри.
 - Perc	Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба.
		 -# Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството и
		 -# цената се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param sellWithPercentDiscount - Perc

<p>
Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant2Version0Plu:(NSString *)plu itemQuantity:(NSString *)itemQuantity sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Dept
			 -# Qwan
			 -# AbsSum
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и също не
		 -# трябва да надхвърля 8 значещи цифри.
 - AbsSum	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството
		 -# и цената се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant2Version1Plu:(NSString *)plu itemQuantity:(NSString *)itemQuantity sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Dept
			 -# Qwan
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Dept	Номер на департамент. Цяло число от 1 до 60 включително.
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и
		 -# също не трябва да надхвърля 8 значещи цифри.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството и
		 -# цената се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param itemQuantity - Qwan

<p>
Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка). 
Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични 
знаци и също не трябва да надхвърля 8 значещи цифри.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant2Version2Plu:(NSString *)plu itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Qwan
			 -# Perc
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и
		 -# също не трябва да надхвърля 8 значещи цифри.
 - Perc	Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху
		 -# текущата продажба. Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството и
		 -# цената се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellWithPercentDiscount - Perc

<p>
Параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) в проценти върху текущата продажба. 
Допустими стойности са от -99.00 % до 99.00 %. Приемат се до 2 десетични знака.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant3Version0Plu:(NSString *)plu sellWithPercentDiscount:(NSString *)sellWithPercentDiscount error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Qwan
			 -# AbsSum
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва
		 -# да надхвърля 8 значещи цифри.
 - AbsSum	Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума.
		 -# Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството и
		 -# цената се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param sellWithAbsoluteSumDiscount - AbsSum

<p>
Това е параметър, показващ стойността на надбавката или отстъпката (в зависимост от знака) като сума. 
Не е допустима отстъпка със стойност по-голяма от стойността на продажбата.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant3Version1Plu:(NSString *)plu sellWithAbsoluteSumDiscount:(NSString *)sellWithAbsoluteSumDiscount error:(NSError **)error;
/**
3Ah (58)	РЕГИСТРИРАНЕ (ПРОДАЖБА) НА АРТИКУЛ

<p>

<p>
 - Област за данни:
			 -# Sign
			 -# PLU
			 -# Qwan
 - Отговор:
			 -# Няма данни

<p>
 - Продажбата става с БЕЗ показване на клиентския дисплей.

<p>
 - Sign	Незадължителен параметър - един байт със стойност '-'.
 - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 - Qwan	Количеството на стоката. Дължина до 8 значещи цифри (не повече от 3 след десетичната точка).
		 -# Произведението (Единична цена)*Qwan се закръгля от принтера до зададения брой десетични знаци и също не трябва да
		 -# надхвърля 8 значещи цифри.

<p>

<p>

<p>
Забележка:

<p>
 - ФП извършва следните действия:
 - -	Прочита се от таблицата с артикулите името, цената и данъчната група на стоката.
 - -	Ако продажбата е по департамент и е разрешено с команда 43, подкоманда 'N', отпечатва се името на департамента.
 - -	Отпечатва името на артикула, посоченото количество и единичната цена.
		 -# На втори ред се отпечатва получената цена заедно с буквата, определяща данъчната група.
		 -# Актуализират се регистрите за натрупани суми и количества на артикули.
		 -# Ако с команда 43h е зададено форматиране на текста тип фактура, то името на стоката, единичната цена, количеството и цената
		 -# се отпечатват на отделни редове.
 - -	Цената на стоката се прибавя към натрупаните суми в регистрите в оперативната памет.
		 -# В случай на препълване се установяват съответните битове от статус полето.
 - -	Ако има отстъпка или надбавка, тя се отпечатва на отделен ред и се добавя в предвидени за това регистри на принтера.
		 -# Стойностите за целия ден се отпечатват при дневния финансов отчет.
 - -	Ако е указан департамент, натрупаната стойност се прибавя към него. Надбавките и отстъпките, ако има такива, се отчитат.

<p>
 - Командата няма да бъде изпълнена успешно, ако:
 - -	Не програмиран артикул с посочения номер.
 - -	Не е отворен фискален бон.
 - -	Вече са направени максималния брой продажби за един бон (512).
 - -	Командата (35h) е изпълнена успешно.
 - -	Сумата по някоя от данъчните групи става отрицателна.
 - -	Сумата от надбавки или отстъпки в рамките на бона става отрицателна.
 - -	КЛЕН е пълна.


 <p>
 @param plu - PLU	Това е номер на артикула. Цяло число от 1 до 999999999 (до 9 цифри).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command58Variant3Version2Plu:(NSString *)plu error:(NSError **)error;
/**
3Ch (60)	ОТКАЗВАНЕ (ПРЕКРАТЯВАНЕ) НА ФИСКАЛЕН БОН

<p>
 - Област за данни:	Няма данни
 - Отговор:	Няма данни

<p>

<p>

<p>
Забележка:
Командата е допустима само в отворен фисакален бон, и то преди изпълнението на команда 53 (Total). 
Предизвиква отказването на всички натрупани в бона суми. 
Отпечатва се с двойна ширина "=АНУЛИРАНО=" и бонът завършва с надпис "ФИСКАЛЕН БОН". 


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command60Variant0Version0AndReturnError:(NSError **)error;
/**
3Dh (61)	УСТАНОВЯВАНЕ НА ДАТАТА И ЧАСА

<p>
 - Област за данни:
		 -# TRGT_DATE	DD-MM-YY
		 -# TRGT_TIME	HH:MM[:SS]
 - Отговор:	Няма данни

<p>

<p>

<p>
Забележка:
Не може да се установява дата, по-ранна от датата на последния запис във фискалната памет. 
Предвидено е да се работи до 2099 година включително. 

<p>
След RESET на паметта командата трябва задължително да се изпълни, за да се продължи нормалната работа, при което се извършва 
RESET запис във фискалната памет.

<p>
Внимание! Важна промяна спрямо версиите на фискалния принтер без КЛЕН!
Не е възможно задаване на дата и час по-ранна от последния отпечатан документ, записан в КЛЕН. 
Това е с цел коректно търсене на документи от КЛЕН по дата и час за печат или изтегляне по серийния порт като текст. 


 <p>
 @param targetDate - TRGT_DATE	DD-MM-YY 
 @param tdrgetTime - TRGT_TIME	HH:MM[:SS]
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command61Variant0Version0TargetDate:(NSString *)targetDate tdrgetTime:(NSString *)tdrgetTime error:(NSError **)error;
/**
3Eh (62)	ПРОЧИТАНЕ НА ДАТАТА И ЧАСА

<p>
Област за данни:	
 - Няма данни.
Отговор:		
 - FP_ANSWER	DD-MM-YY HH:MM:SS

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outText" - FP_ANSWER	DD-MM-YY HH:MM:SS
*/

    -(NSDictionary *)command62Variant0Version0AndReturnError:(NSError **)error;
/**
3Eh (62)	ПРОЧИТАНЕ НА ДАТАТА И ЧАСА

<p>
Област за данни:	
 - Няма данни.
Отговор:		
		 -# DD		Ден
		 -# MM		Месец
		 -# YY		Година
		 -# HH		Час
		 -# MMM		Минута
		 -# SS		Сек.

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"day" - DD	Ден
 - KeyValue - \@"month" - MM	Месец
 - KeyValue - \@"year" - YY	Година
 - KeyValue - \@"hour" - HH	Час
 - KeyValue - \@"minute" - MMM		Минута
 - KeyValue - \@"sec" - SS		Сек.
*/

    -(NSDictionary *)command62Variant0Version1AndReturnError:(NSError **)error;
/**
40h (64)	ИНФОРМАЦИЯ ЗА ПОСЛЕДНИЯ ФИСКАЛЕН ЗАПИС

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# ErrCode
			 -# LastFiscNum
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH
			 -# FiscRecDate

<p>
 - ErrCode	Код на грешка:
		 -# 'P'	Командата е успешна. Следват данни.
		 -# 'F'	Не се чете последния запис.

<p>
 - LastFiscNum	Това е номера на последния фискален запис - 4 байта.
 - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак.
 - FiscRecDate	Датата на фискалния запис - 6 байта /DDMMYY/.

<p>

<p>
Забележка:
Командата води до предаване на информацията от последния запис във фискалната памет към компютъра.

<p>


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrCode	

<p>
Код на грешка:
		 -# 'P'	Командата е успешна. Следват данни.
		 -# 'F'	Не се чете последния запис.

 - KeyValue - \@"lastFiscalRecordNumber" - LastFiscNum	Това е номера на последния фискален запис - 4 байта.
 - KeyValue - \@"totalSumInTaxGroupA" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupB" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupC" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupD" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupE" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupF" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupG" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"totalSumInTaxGroupH" - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', : - 12 байта със знак. 
 - KeyValue - \@"fiscalRecordDate" - FiscRecDate	Датата на фискалния запис - 6 байта /DDMMYY/. 
*/

    -(NSDictionary *)command64Variant0Version0AndReturnError:(NSError **)error;
/**
41h (65)	ИНФОРМАЦИЯ ЗА СУМИТЕ ПО ДАНЪЧНИ ГРУПИ ЗА ДЕНЯ

<p>
 - Област за данни:
			 -# Option

<p>
 - Отговор:
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - Option		Определя каква информация да се върне:
				 -# '0' - Общ оборот.
				 -# '1' - Натрупан ДДС.

<p>
 - TaxX		Сумите по всяка данъчна група 'А', 'Б', 'В', ... - 12 байта със знак.

<p>

<p>
Забележка:
Връщат се сумите по данъчни групи от последното приключване на деня до момента на получаване на командата.


 <p>
 @param option - Option

<p>
Определя каква информация да се върне: 
 - '0' - Общ оборот.
 - '1' - Натрупан ДДС.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"totalSumInTaxGroupA" - TotA	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"totalSumInTaxGroupB" - TotB	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"totalSumInTaxGroupC" - TotC	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"totalSumInTaxGroupD" - TotD	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"totalSumInTaxGroupE" - TotE	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"totalSumInTaxGroupF" - TotF	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"taxGroupG" - TotG	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

 - KeyValue - \@"taxGroupH" - TotH	With Option=0 : Tax group total
 - With Option=1 : Tax group VAT

*/

    -(NSDictionary *)command65Variant0Version0Option:(NSString *)option error:(NSError **)error;
/**
42h (66) 	ЗАДАВАНЕ НА ИНТЕРВАЛ ДОПУСТИМИ НОМЕРА НА ФАКТУРА

<p>
 - Област за данни:
			 -# START_NUM
			 -# END_NUM

<p>
 - Отговор:		Няма

<p>

<p>
 - START_NUM	Задава начална стойност на интервала. Цяло число до 10 цифри.
 - END_NUM	Задава крайна стойност на интервала. Цяло число до 10 цифри.

<p>

<p>
Забележка:
1. START_NUM трябва да е по-малко или равно на END_NUM. 
2. При успешно изпълнена команда текущият номер на фактура става START_NUM.

<p>
Командата е допустима, ако:
-	Не е изпълнявана след пускане на принтера в експлоатация.
-	Извършено е нулиране на RAM, поради което информацията за текущия брояч и допустимия 
 - интервал е загубена.
-	С нарастванев на брояча на фактурите той е излязъл вън от допустимия интервал. Трябва да се 
 - зададе нов интервал.


 <p>
 @param startNumber - START_NUM	Задава начална стойност на интервала. Цяло число до 10 цифри. 
 @param endNumber - END_NUM	Задава крайна стойност на интервала. Цяло число до 10 цифри.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command66Variant0Version0StartNumber:(NSString *)startNumber endNumber:(NSString *)endNumber error:(NSError **)error;
/**
42h (66) 	ЗАДАВАНЕ НА ИНТЕРВАЛ ДОПУСТИМИ НОМЕРА НА ФАКТУРА

<p>
Принтерът връща текущия интервал и брояч.

<p>

<p>
 - Област за данни:		Няма

<p>
 - Отговор:
			 -# START_NUM
			 -# END_NUM
			 -# CURRENT

<p>

<p>
 - START_NUM	Задава начална стойност на интервала. Цяло число до 10 цифри.
 - END_NUM	Задава крайна стойност на интервала. Цяло число до 10 цифри.
 - CURRENT	Текущата стойност на брояча на фактурите. Цяло число с 10 цифри.

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"startNumber" - START_NUM	Задава начална стойност на интервала. Цяло число до 10 цифри. 
 - KeyValue - \@"endNumber" - END_NUM	Задава крайна стойност на интервала. Цяло число до 10 цифри.
 - KeyValue - \@"currentInvoiceCounterValue" - CURRENT		Текущата стойност на брояча на фактурите. Цяло число с 10 цифри.
*/

    -(NSDictionary *)command66Variant0Version1AndReturnError:(NSError **)error;
/**
44h (68)	БРОЙ СВОБОДНИ ПОЛЕТА ВЪВ ФИСКАЛНАТА ПАМЕТ

<p>
 - Област за данни:	Няма данни
 - Отговор:
			 -# Logical

<p>
 - Logical		Броят на логическите места за фискални записи /4 байта/.

<p>

<p>
Забележка:
Връща се броя на свободните полета във фискалната памет, предвидени за запис на информация при 
дневен финансов отчет с нулиране (Z-отчет).


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"logicalFiscalRecordsCount" - Logical		Броят на логическите места за фискални записи /4 байта/.
*/

    -(NSDictionary *)command68Variant0Version0AndReturnError:(NSError **)error;
/**
45h (69)	ДНЕВЕН ФИНАНСОВ ОТЧЕТ

<p>
 - Област за данни:
		 -# Option
		 -# N
 - Response:
		 -# Closure
		 -# FM_Total
		 -# TotA
		 -# TotB
		 -# TotC
		 -# TotD
		 -# TotE
		 -# TotF
		 -# TotG
		 -# TotH

<p>
 - Option	Параметър, управляващ вида на генерирания отчет:
		 -# '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
		 -# '2'	Прави се дневен финансов отчет без нулиране (т. е. не се извършва запис във фискалната памет и
			 -# нулиране на регистрите). Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

<p>
 - N		Наличието на символ "N" забранява изчистването на натрупаните данни по оператори при
			 -# отчет с нулиране.

<p>
 - Closure		Номер на фискалния запис - 4 байта.
 - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - TotX		Сумите по всяка от данъчните групи 'А', 'Б', 'В', : - 12 байта със знак.

<p>

<p>
Забележка:
Дневен отчет без нулиране може да се предизвика и чрез задържането на бутон <FEED> при включване на принтера до третия 
звуков сигнал.


 <p>
 @param reportTypeOption - Option

<p>
Параметър, управляващ вида на генерирания отчет:
 - '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
 - '2'	Прави се дневен финансов отчет без нулиране
		 -# (т. е. не се извършва запис във фискалната памет и нулиране на регистрите).
		 -# Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

 @param clearOperatorsDataOption - Наличието на символ "N" забранява изчистването на натрупаните данни по оператори при отчет с нулиране.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Closure		Номер на фискалния запис - 4 байта.
 - KeyValue - \@"totalSumWithoutTaxes" - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - KeyValue - \@"totalSumInTaxGroupA" - TotA	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - TotB	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - TotC	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - TotD	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - TotE	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupF" - TotF	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupG" - TotG	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupH" - TotH	The total under tax category - 12 bytes with a sign.
*/

    -(NSDictionary *)command69Variant0Version0ReportTypeOption:(NSString *)reportTypeOption clearOperatorsDataOption:(NSString *)clearOperatorsDataOption error:(NSError **)error;
/**
46h (70)	СЛУЖЕБЕН ВНОС И ИЗНОС НА ПАРИ 

<p>
 - Област за данни:
			 -# Amount
 - Отговор:
			 -# ExitCode
			 -# CashSum
			 -# ServIn
			 -# ServOut

<p>
 - Amount		Сумата за регистриране (до 10 значещи цифри).
			 -# В зависимост от знака на числото тя се интерпретира като внос или износ.
 - ExitCode
			 -# 'P'	Заявката е изпълнена. Ако заявената сума е ненулева, принтерът отпечатва служебен бон за
				 -# регистриране на операцията.
			 -# 'F'	Заявката е отказана.
			 -# Това става, ако:
			 -# -	Касовата наличност е по-малка от заявения служебен износ.
			 -# -	Има отворен фискален или служебен бон.

<p>
 - CashSum		Касова наличност. Освен от тази команда сумата нараства и при всяко плащане в брой.
 - ServIn		Сумата от всички команди "Служебен внос".
 - ServOut		Сумата от всички команди "Служебен износ".

<p>

<p>
Забележка:
Променя съдържанието на регистъра за касова наличност. 
В зависимост от знака на посочената сума тя се натрупва в регистъра за служебен внос или износ. 
Информацията не се записва във фискалната памет и е достъпна до момента на приключване на деня. 
Разпечатва се при команда 69 (45h) и при предизвикване на дневен финансов отчет без нулиране от самия принтер. 
При успешно изпълнение на командата с параметър се генерира импулс за отваряне на чекмедже, ако това е разрешено с 
подкоманда 'X' на команда 43.


 <p>
 @param amountIn - Amount

<p>
Сумата за регистриране (до 10 значещи цифри). 
В зависимост от знака на числото тя се интерпретира като внос или износ. 

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"exitCode" - ExitCode	

<p>
 - 'P'	Заявката е изпълнена. Ако заявената сума е ненулева, принтерът отпечатва служебен бон за регистриране на операцията.
 - 'F'	Заявката е отказана.
 - Това става, ако:
		 -# -	Касовата наличност е по-малка от заявения служебен износ.
		 -# -	Има отворен фискален или служебен бон.

 - KeyValue - \@"sumInCashRegister" - CashSum		Касова наличност. Освен от тази команда сумата нараства и при всяко плащане в брой.
 - KeyValue - \@"totalForAllInputs" - ServIn		Сумата от всички команди "Служебен внос".
 - KeyValue - \@"totalForOutputs" - ServOut		Сумата от всички команди "Служебен износ".
*/

    -(NSDictionary *)command70Variant0Version0AmountIn:(NSString *)amountIn error:(NSError **)error;
/**
47h (71)	ПЕЧАТ НА ДИАГНОСТИЧНА ИНФОРМАЦИЯ

<p>

<p>
 - Област за данни:	Няма данни
 - Отговор:		Няма данни

<p>

<p>
Забележка:
Тази команда отпечатва служебен бон с диагностична информация.
Бонът съдържа следното:
-	Датата и версията на програмното осигуряване.
-	Контролната сума на фирмуера.
-	Скоростта на предаване на серийния порт.
-	Положението на конфигурационните ключета и името на страната.
-	Аварийното време при отпадане на захранването.
-	Номера, датата и часа на последното нулиране на RAM (ако има такова).
-	Текущата температура на печатащата глава.
-	Общия брой полета във фискалната памет и броя на свободните.
-	Текущата дата и час.
Командата няма да се изпълни при отворен бон и липса на хартия. 
Може да се предизвика и чрез задържането на бутон <FEED> при включване на принтера до първия звуков сигнал.

<p>

<p>


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command71Variant0Version0AndReturnError:(NSError **)error;
/**
49h (73) 	ОТПЕЧАТВАНЕ НА ФИСКАЛНАТА ПАМЕТ ПО НОМЕР НА БЛОК

<p>
 - Област за данни:
		 -# StartRec
		 -# EndRec
 - Отговор:
		 -# Няма

<p>

<p>
 - StartRec	Номер на началния фискален блок. 4 байта.
 - EndRec	Номер на крайния фискален блок. 4 байта.

<p>

<p>
Забележка:
Тази команда води до отпечатване на пълен отчет на фискалната памет от даден номер до друг. 
Ако няма входни данни, приема се целия перод на експлоатация.


 <p>
 @param startRecord - StartRec	The number of the starting fiscal entry - 4 bytes
 @param endRecord - EndRec	The number of the ending fiscal entry - 4 bytes
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command73Variant0Version0StartRecord:(NSString *)startRecord endRecord:(NSString *)endRecord error:(NSError **)error;
/**
4Ch (76)	СТАТУС НА ФИСКАЛНАТА ТРАНЗАКЦИЯ

<p>
 - Област за данни:	Няма
 - Отговор:
			 -# FT_Opened
			 -# Items
			 -# Amount
			 -# Tender

<p>

<p>
 - FT_Opened	Един байт, който е:
				 -# '1' ако е отворен фискален или служебен бон (какъв точно може да се разбере по статус битовете);
				 -# '0' ако няма отворен бон.
 - Sales_Num	Броят на продажбите регистрирани на текущия или на последния фискален бон. 4 байта.
 - Amount		Сумата от последния фискален бон - 9 байта със знак.
 - Tender		Сумата платена на поредния или последен бон. 9 байта със знак.

<p>

<p>
Забележка:

<p>
Тази команда дава възможност на приложението в PC да установи статуса, а ако е нужно и да възстанови и завърши фискална операция.
Например при изключване на ел. захранване. 


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"receiptIsOpened" - FT_Opened

<p>
Един байт, който е:
 - '1' 	ако е отворен фискален или служебен бон (какъв точно може да се разбере по статус битовете);
 - '0' 	ако няма отворен бон.

 - KeyValue - \@"countOfRegisteredSales" - Sales_Num	Броят на продажбите регистрирани на текущия или на последния фискален бон. 4 байта.
 - KeyValue - \@"lastFiscalReceiptAmount" - Amount		Сумата от последния фискален бон - 9 байта със знак.
 - KeyValue - \@"lastFiscalReceiptTender" - Tender		Сумата платена на поредния или последен бон. 9 байта със знак.
*/

    -(NSDictionary *)command76Variant0Version0AndReturnError:(NSError **)error;
/**
4Fh (79)	НАТРУПАНИ СУМИ ОТ ФИСКАЛНАТА ПАМЕТ ЗА ДАДЕН ПЕРИОД

<p>
Област за данни:
		 -# StartDate
		 -# EndDate
Отговор:	
		 -# Няма данни

<p>
StartDate		Начална дата - 6 байта (DDMMYY)
EndDate		Крайна дата - 6 байта (DDMMYY)

<p>

<p>
Забележка:

<p>
Командата води до изчисляване и отпечатване на съкратен отчет на фискалната памет.

<p>


 <p>
 @param startDate - StartDate		Начална дата - 6 байта (DDMMYY)
 @param endDate - EndDate		Крайна дата - 6 байта (DDMMYY)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command79Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
50H (80)	ЗВУКОВ СИГНАЛ

<p>
 - Област за данни:
			 -# SoundData
 - Отговор:		Няма данни

<p>

<p>
Забележка:

<p>
Командата служи за издаване на поредица от тонове със зададена честота и продължителност. 
Ако няма входни данни, издава се звуков сигнал с честота 2 kHz и продължителност 300 ms.
Ако входните данни са от вида: 
<Hz>,<mSec> където Hz и mSec са цели числа, то се издава звуков сигнал с честота Hz херца (м/у 100 и 5000) и продължителност mSec 
милисекунди (м/у 50 и 2000).

<p>
В останалите случаи данните са във формат, подобен на записа на ноти и могат да имат произволна дължина 
(не по-голяма от изискваната от протокола - 218 байта). 
Първият невалиден символ прекъсва командата. 

<p>
Допустимите подкоманди във данните са:
-	Нота: 
Една латинска главна буква със стойност от 'A' до'G'.
 - 'C'	до
 - 'D'	ре
 - 'E'	ми
 - 'F'	фа
 - 'G'	сол
 - 'A'	ла
 - 'B'	си
Ако непосредствено след нотата следва символът '#', то тя се повишава с един полутон (диез). 
Ако след нотата следва символът '&', то тя се понижава с един полутон (бемол).
-	Пауза: 
Символът интервал (ASCII 20h).

<p>
След нота или пауза може да има един или няколко байта, указващи продължителността. 

<p>
Валидни символи са от '0' до '5', като те имат следното значение:
 - '0'	Базова продължителност
 - '1'	Базова продължителност * 2
 - '2'	Базова продължителност * 4
 - '3'	Базова продължителност * 8
 - '4'	Базова продължителност * 16
 - '5'	Базова продължителност * 32

<p>
Ако има няколко продължителности една след друга, те се сумират.
 - -	Преминаване към по-висока гама: символът '+'.
 - -	Преминаване към по-ниска гама: символът '-'.
 - -	Задаване на темпо: Символът '^', следван от една цифра.
		 -# Цифрата определя процентно продължителността на нотите и интервалите спрямо базовата.
		 -# Допустима стойност:
			 -# '1'	200 %
			 -# '2'	175 %
			 -# '3'	140 %
			 -# '4'	120 %
			 -# '5'	100 %
			 -# '6'	80 %
			 -# '7'	60 %
			 -# '8'	50 %
			 -# '9'	40 %
 - -	Връщане към гама 1 (тя е и по подразбиране). Символът '@'. Тонът 'ла' за нея е 440 Hz.

<p>
Изсвирването на изпратената последователност е фоново и принтерът може да изпълнява команди по време на звуковия сигнал.


 <p>
 @param soundData - SoundData

<p>
Командата служи за издаване на поредица от тонове със зададена честота и продължителност. 
Ако няма входни данни, издава се звуков сигнал с честота 2 kHz и продължителност 300 ms.
Ако входните данни са от вида: 
<Hz>,<mSec> където Hz и mSec са цели числа, то се издава звуков сигнал с честота Hz херца (м/у 100 и 5000) и продължителност 
mSec милисекунди (м/у 50 и 2000).

<p>
В останалите случаи данните са във формат, подобен на записа на ноти и могат да имат произволна дължина (не по-голяма от 
изискваната от протокола - 218 байта). 
Първият невалиден символ прекъсва командата. 

<p>
Допустимите подкоманди във данните са:
 - -	Нота: Една латинска главна буква със стойност от 'A' до'G'.
 - 'C'	до
 - 'D'	ре
 - 'E'	ми
 - 'F'	фа
 - 'G'	сол
 - 'A'	ла
 - 'B'	си
Ако непосредствено след нотата следва символът '#', то тя се повишава с един полутон (диез). 
Ако след нотата следва символът '&', то тя се понижава с един полутон (бемол).
-	Пауза: Символът интервал (ASCII 20h).

<p>
След нота или пауза може да има един или няколко байта, указващи продължителността. 

<p>
Валидни символи са от '0' до '5', като те имат следното значение:
 - '0'	Базова продължителност
 - '1'	Базова продължителност * 2
 - '2'	Базова продължителност * 4
 - '3'	Базова продължителност * 8
 - '4'	Базова продължителност * 16
 - '5'	Базова продължителност * 32

<p>
Ако има няколко продължителности една след друга, те се сумират.
 - -	Преминаване към по-висока гама: символът '+'.
 - -	Преминаване към по-ниска гама: символът '-'.
 - -	Задаване на темпо: Символът '^', следван от една цифра.
		 -# Цифрата определя процентно продължителността на нотите и интервалите спрямо базовата.
		 -# Допустима стойност:
			 -# '1'	200 %
			 -# '2'	175 %
			 -# '3'	140 %
			 -# '4'	120 %
			 -# '5'	100 %
			 -# '6'	80 %
			 -# '7'	60 %
			 -# '8'	50 %
			 -# '9'	40 %
 - -	Връщане към гама 1 (тя е и по подразбиране). Символът '@'. Тонът 'ла' за нея е 440 Hz.

<p>
Изсвирването на изпратената последователност е фоново и принтерът може да изпълнява команди по време на звуковия сигнал.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command80Variant0Version0SoundData:(NSString *)soundData error:(NSError **)error;
/**
53h (83)	УСТАНОВЯВАНЕ НА ДЕСЕТИЧНИ ЗНАЦИ, ВАЛУТА И ДАНЪЧНИТЕ СТАВКИ

<p>
 - Област за данни:
			 -# INPUT_Multiplier
			 -# INPUT_Decimals
			 -# INPUT_Currency
			 -# INPUT_EnabledT
			 -# INPUT_TaxA
			 -# INPUT_TaxB
			 -# INPUT_TaxC
			 -# INPUT_TaxD
			 -# INPUT_TaxE
			 -# INPUT_TaxF
			 -# INPUT_TaxG
			 -# INPUT_TaxH
 - Отговор:
			 -# OUTPUT_Multiplier
			 -# OUTPUT_Decimals
			 -# OUTPUT_Currency
			 -# OUTPUT_EnabledT
			 -# OUTPUT_TaxA
			 -# OUTPUT_TaxB
			 -# OUTPUT_TaxC
			 -# OUTPUT_TaxD
			 -# OUTPUT_TaxE
			 -# OUTPUT_TaxF
			 -# OUTPUT_TaxG
			 -# OUTPUT_TaxH

<p>
 - Multiplier		Множител - между 0 и 3 и показва степента на 10 преди да се умножи с входното или изходното число.
			 -# В момента е деактивиран и не се използува.
 - Decimals		Това е един байт със стойност между 0 и 2 и показва мястото където да се сложи десетичната запетая.
 - Currency		Името на валутата. До 6 байта.
 - EnabledT		8 байта със възможна стойност '0' или '1', определящи дали съответната данъчна група е
			 -# забранена ('0') или разрешена ('1').
 - TaxX		Стойността на данъчните ставки.

<p>

<p>
Забележка:

<p>
Ако един от параметрите трябва да бъде указан, то тогава и останалите трябва да се зададат.
Установяването на нови данъчни ставки е разрешено само преди издаването на първия клиентски фискален бон за деня.
Преди фискализация данните от командата се пазят само в оперативната памет и могат да се променят неограничен брой пъти.


 <p>
 @param inMultiplier - INPUT_Multiplier	A multiplier between 0 and 3 which shows the degree of 10 before multiplying it times the input or output value 
		 -# (at present deactivated and out of use).

 @param inDecimals - INPUT_Decimals	One byte with a value 0 or 2 and shows the exact place of the decimal point.
 @param inCurrency - INPUT_Currency

<p>
Името на валутата. До 6 байта.

 @param inEnabledTaxesArray - INPUT_EnabledT

<p>
8 байта със възможна стойност '0' или '1', определящи дали съответната данъчна група е забранена ('0') или разрешена ('1').

 @param inTaxGroupA - INPUT_TaxA	Стойността на данъчната ставка.
 @param inTaxGroupB - INPUT_TaxB	Стойността на данъчната ставка.
 @param inTaxGroupC - INPUT_TaxC	Стойността на данъчната ставка.
 @param inTaxGroupD - INPUT_TaxD	Стойността на данъчната ставка.
 @param inTaxGroupE - INPUT_TaxE	Стойността на данъчната ставка.
 @param inTaxGroupF - INPUT_TaxF	Стойността на данъчната ставка.
 @param inTaxGroupG - INPUT_TaxG	Стойността на данъчната ставка.
 @param inTaxGroupH - INPUT_TaxH	Стойността на данъчната ставка.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outMultiplier" - OUTPUT_Multiplier	

<p>
Множител - между 0 и 3 и показва степента на 10 преди да се умножи с входното или изходното число. 
В момента е деактивиран и не се използува.

 - KeyValue - \@"outDecimals" - OUTPUT_Decimals

<p>
Това е един байт със стойност между 0 и 2 и показва мястото където да се сложи десетичната запетая.

 - KeyValue - \@"outCurrency" - OUTPUT_Currency

<p>
Името на валутата. До 6 байта.

 - KeyValue - \@"outEnabledTaxesArray" - OUTPUT_EnabledT

<p>
8 байта със възможна стойност '0' или '1', определящи дали съответната данъчна група е забранена ('0') или разрешена ('1').

 - KeyValue - \@"outTaxGroupA" - OUTPUT_TaxA	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupB" - OUTPUT_TaxB	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupC" - OUTPUT_TaxC	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupD" - OUTPUT_TaxD	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupE" - OUTPUT_TaxE	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupF" - OUTPUT_TaxF	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupG" - OUTPUT_TaxG	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupH" - OUTPUT_TaxH	Стойността на данъчната ставка.
*/

    -(NSDictionary *)command83Variant0Version0InMultiplier:(NSString *)inMultiplier inDecimals:(NSString *)inDecimals inCurrency:(NSString *)inCurrency inEnabledTaxesArray:(NSString *)inEnabledTaxesArray inTaxGroupA:(NSString *)inTaxGroupA inTaxGroupB:(NSString *)inTaxGroupB inTaxGroupC:(NSString *)inTaxGroupC inTaxGroupD:(NSString *)inTaxGroupD inTaxGroupE:(NSString *)inTaxGroupE inTaxGroupF:(NSString *)inTaxGroupF inTaxGroupG:(NSString *)inTaxGroupG inTaxGroupH:(NSString *)inTaxGroupH error:(NSError **)error;
/**
53h (83)	УСТАНОВЯВАНЕ НА ДЕСЕТИЧНИ ЗНАЦИ, ВАЛУТА И ДАНЪЧНИТЕ СТАВКИ

<p>
 - Област за данни:	Няма.
 - Отговор:
			 -# OUTPUT_Multiplier
			 -# OUTPUT_Decimals
			 -# OUTPUT_Currency
			 -# OUTPUT_EnabledT
			 -# OUTPUT_TaxA
			 -# OUTPUT_TaxB
			 -# OUTPUT_TaxC
			 -# OUTPUT_TaxD
			 -# OUTPUT_TaxE
			 -# OUTPUT_TaxF
			 -# OUTPUT_TaxG
			 -# OUTPUT_TaxH

<p>
 - Multiplier		Множител - между 0 и 3 и показва степента на 10 преди да се умножи с входното или изходното число.
			 -# В момента е деактивиран и не се използува.
 - Decimals		Това е един байт със стойност между 0 и 2 и показва мястото където да се сложи десетичната запетая.
 - Currency		Името на валутата. До 6 байта.
 - EnabledT		8 байта със възможна стойност '0' или '1', определящи дали съответната данъчна група е
			 -# забранена ('0') или разрешена ('1').
 - TaxX		Стойността на данъчните ставки.

<p>

<p>
Забележка:

<p>
Ако един от параметрите трябва да бъде указан, то тогава и останалите трябва да се зададат.
Установяването на нови данъчни ставки е разрешено само преди издаването на първия клиентски фискален бон за деня.
Преди фискализация данните от командата се пазят само в оперативната памет и могат да се променят неограничен брой пъти.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outMultiplier" - OUTPUT_Multiplier	

<p>
Множител - между 0 и 3 и показва степента на 10 преди да се умножи с входното или изходното число. 
В момента е деактивиран и не се използува.

 - KeyValue - \@"outDecimals" - OUTPUT_Decimals

<p>
Това е един байт със стойност между 0 и 2 и показва мястото където да се сложи десетичната запетая.

 - KeyValue - \@"outCurrency" - OUTPUT_Currency

<p>
Името на валутата. До 6 байта.

 - KeyValue - \@"outEnabledTaxesArray" - OUTPUT_EnabledT

<p>
8 байта със възможна стойност '0' или '1', определящи дали съответната данъчна група е забранена ('0') или разрешена ('1').

 - KeyValue - \@"outTaxGroupA" - OUTPUT_TaxA	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupB" - OUTPUT_TaxB	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupC" - OUTPUT_TaxC	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupD" - OUTPUT_TaxD	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupE" - OUTPUT_TaxE	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupF" - OUTPUT_TaxF	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupG" - OUTPUT_TaxG	Стойността на данъчната ставка.
 - KeyValue - \@"outTaxGroupH" - OUTPUT_TaxH	Стойността на данъчната ставка.
*/

    -(NSDictionary *)command83Variant0Version1AndReturnError:(NSError **)error;
/**
54H (84)	ПЕЧАТ НА БАРКОД

<p>
Област за данни:	
		 -# BC_Type
		 -# BC_Data
Отговор:		Няма данни

<p>
BC_Type		Тип на баркода. Един байт с допустима стойност:
			 -# '1'	EAN8. Данните съдържат само цифри и са 7 байта. Контролната сума се изчислява от принтера.

<p>
			 -# '2'	EAN13. Данните съдържат само цифри и са 12 байта. Контролната сума се изчислява от принтера.

<p>
			 -# '3'	Code 128. Данните са символи с ASCII кодове между 32 и 127.
				 -# Дължината им е между 22 и 42 символа (зависи от съдържанието - максималната дължина се
				 -# постига, ако всички символи са цифри). Контролната сума се изчислява от принтера.

<p>
			 -# '4'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.

<p>
			 -# '5'	ITF (Interleaved 2 of 5). Данните съдържат само цифри. Принтерът автоматично генерира и
				 -# отпечатва контролна сума.

<p>

<p>
Забележка:

<p>
Командата отпечатва баркод. 
Допустима е само в отворен фискален или служебен бон. 
Баркодът се печати центриран. 
Под баркода се печати информацията и в текстов вид. 
Ако дължината на данните или съдържанието им е навалидно, вдига се статус бит "Синтактична грешка" и баркодът не се отпечатва.
Височината на баркода се задава с команда 43.


 <p>
 @param barcodeType - BC_Type		Тип на баркода. 

<p>
Един байт с допустима стойност:
 - '1'	EAN8. Данните съдържат само цифри и са 7 байта. Контролната сума се изчислява от принтера.

<p>
 - '2'	EAN13. Данните съдържат само цифри и са 12 байта. Контролната сума се изчислява от принтера.

<p>
 - '3'	Code 128. Данните са символи с ASCII кодове между 32 и 127.
		 -# Дължината им е между 22 и 42 символа (зависи от съдържанието - максималната дължина се постига, ако всички символи са цифри).
		 -# Контролната сума се изчислява от принтера.

<p>
 - '4'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.

<p>
 - '5'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.
		 -# Принтерът автоматично генерира и отпечатва контролна сума.

<p>
 - 'D'	DataMatrix. Данните имат формат: <Align><Size>,<BData>
		 -# Align	Подравняване на баркода. Един байт:
			 -# L	Ляво
			 -# C	Центрирано
			 -# R	Дясно
		 -# Size	Размер на модула (пиксела). Цяло число от 3 до 12.
		 -# BData	Данните за печат. До 160 байта.

<p>

 @param barcodeData - BC_Data

<p>
 - - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
 - - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
 - - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
 - (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
 - and printed.
 - - DataMatrix. Данните имат формат: <Align><Size>,<BData>
		 -# Align	Подравняване на баркода. Един байт:
			 -# L	Ляво
			 -# C	Центрирано
			 -# R	Дясно
		 -# Size	Размер на модула (пиксела). Цяло число от 3 до 12.
		 -# BData	Данните за печат. До 160 байта.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command84Variant0Version0BarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData error:(NSError **)error;
/**
54H (84)	ПЕЧАТ НА БАРКОД

<p>
Област за данни:	
		 -# BC_Type
		 -# BC_Data
Отговор:		Няма данни

<p>
BC_Type		Тип на баркода. Един байт с допустима стойност:
			 -# '1'	EAN8. Данните съдържат само цифри и са 7 байта. Контролната сума се изчислява от принтера.

<p>
			 -# '2'	EAN13. Данните съдържат само цифри и са 12 байта. Контролната сума се изчислява от принтера.

<p>
			 -# '3'	Code 128. Данните са символи с ASCII кодове между 32 и 127.
				 -# Дължината им е между 22 и 42 символа (зависи от съдържанието - максималната дължина се
				 -# постига, ако всички символи са цифри). Контролната сума се изчислява от принтера.

<p>
			 -# '4'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.

<p>
			 -# '5'	ITF (Interleaved 2 of 5). Данните съдържат само цифри. Принтерът автоматично генерира и
				 -# отпечатва контролна сума.

<p>

<p>
Забележка:

<p>
Командата отпечатва баркод. 
Допустима е само в отворен фискален или служебен бон. 
Баркодът се печати центриран. 
Ако дължината на данните или съдържанието им е навалидно, вдига се статус бит "Синтактична грешка" и баркодът не се отпечатва.
Височината на баркода се задава с команда 43.


 <p>
 @param barcodeType - BC_Type		Тип на баркода. 

<p>
Един байт с допустима стойност:
 - '1'	EAN8. Данните съдържат само цифри и са 7 байта. Контролната сума се изчислява от принтера.

<p>
 - '2'	EAN13. Данните съдържат само цифри и са 12 байта. Контролната сума се изчислява от принтера.

<p>
 - '3'	Code 128. Данните са символи с ASCII кодове между 32 и 127.
		 -# Дължината им е между 22 и 42 символа (зависи от съдържанието - максималната дължина се постига, ако всички символи са цифри).
		 -# Контролната сума се изчислява от принтера.

<p>
 - '4'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.

<p>
 - '5'	ITF (Interleaved 2 of 5). Данните съдържат само цифри.
		 -# Принтерът автоматично генерира и отпечатва контролна сума.

 @param barcodeData - BC_Data

<p>
 - - EAN8 bar code. Data contains only digits and is 7 bytes long. The check sum is automatically calculated and printed.
 - - EAN13 bar code. Data contains only digits and is 12 bytes long. The check sum is automatically calculated and printed.
 - - Code128 bar code. Data contains symbols with ASCII codes between 32 and 127. Data length is between 16 and 32 symbols
 - (depends on the content - the maximum length is if all symbol are digits). The check sum is automatically calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 28 bytes long. No check sum is calculated and printed.
 - - Interleaved 2 of 5 bar code. Data contains only digits and is up to 27 bytes long. The check sum is automatically calculated
 - and printed.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command84Variant0Version1BarcodeType:(NSString *)barcodeType barcodeData:(NSString *)barcodeData error:(NSError **)error;
/**
55H (85)	УСТАНОВЯВАНЕ ИМЕНА НА ДОПЪЛНИТЕЛНИТЕ ПЛАЩАНИЯ

<p>
 - Област за данни:
				 -# Option
				 -# INPUT_NAME
 - Отговор:
		 -# FP_Result

<p>
 - Option:
		 -# 'I'	Допълнително плащане 1
		 -# 'J'	Допълнително плащане 2
		 -# 'K'	Допълнително плащане 3
		 -# 'L'	Допълнително плащане 4

<p>
 - INPUT_NAME	Име на съответния тип плащане (до 24 символа).

<p>
 - FP_Result:
		 -# 'P'	Няма грешка.
		 -# 'F'	Името е повече от 24 байта.

<p>

<p>
Забележка:

<p>

<p>
Командата задава коментарен текст, който се печати пред данните от допълнителните типове плащания (команда 53). 
Разрешена е само преди издаването на първия клиентски фискален бон за деня.


 <p>
 @param additionalPaymentTypeOption - OPTION
		 -# 'I'	Допълнително плащане 1
		 -# 'J'	Допълнително плащане 2
		 -# 'K'	Допълнително плащане 3
		 -# 'L'	Допълнително плащане 4

 @param inAdditionalPaymentTypeName - INPUT_NAME	Име на съответния тип плащане (до 24 символа).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outText" - One byte:
		 -# 'P'	Няма грешка.
		 -# 'F'	Името е повече от 24 байта.

*/

    -(NSDictionary *)command85Variant0Version0AdditionalPaymentTypeOption:(NSString *)additionalPaymentTypeOption inAdditionalPaymentTypeName:(NSString *)inAdditionalPaymentTypeName error:(NSError **)error;
/**
55H (85)	УСТАНОВЯВАНЕ ИМЕНА НА ДОПЪЛНИТЕЛНИТЕ ПЛАЩАНИЯ

<p>
 - Област за данни:
				 -# Option
 - Отговор:
		 -# OUTPUT_NAME

<p>
 - Option:
		 -# 'I'	Допълнително плащане 1
		 -# 'J'	Допълнително плащане 2
		 -# 'K'	Допълнително плащане 3
		 -# 'L'	Допълнително плащане 4

<p>

<p>
 - OUTPUT_NAME	Име на съответния тип плащане (до 24 символа).

<p>

<p>
Забележка:

<p>
Командата връща текущото име.
Разрешена е само преди издаването на първия клиентски фискален бон за деня.


 <p>
 @param inAdditionalPaymentTypeOption - OPTION
		 -# 'I'	Допълнително плащане 1
		 -# 'J'	Допълнително плащане 2
		 -# 'K'	Допълнително плащане 3
		 -# 'L'	Допълнително плащане 4

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outAdditionalPaymentTypeName" - OUTPUT_NAME	Име на съответния тип плащане (до 24 символа).
*/

    -(NSDictionary *)command85Variant0Version1InAdditionalPaymentTypeOption:(NSString *)inAdditionalPaymentTypeOption error:(NSError **)error;
/**
56H (86)	ПРОЧИТАНЕ НА ДАТАТА НА НАЙ-КЪСНИЯ ЗАПИС ВЪВ ФИСК. ПАМЕТ

<p>
 - Област за данни:	Няма
 - Отговор:		LFMR_DT

<p>
 - LFMR_DT	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет във формат:
			 -# DD-MM-YYYY hh:mm:ss

<p>

<p>
Забележка:


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outLastFiscalMemoryDate" - LFMR_DT	

<p>
Датата (или датата и часа) на последния (най-късен) запис във фискалната памет във формат:
DD-MM-YYYY hh:mm:ss

*/

    -(NSDictionary *)command86Variant0Version0AndReturnError:(NSError **)error;
/**
56H (86)	ПРОЧИТАНЕ НА ДАТАТА НА НАЙ-КЪСНИЯ ЗАПИС ВЪВ ФИСК. ПАМЕТ

<p>
 - Област за данни:
			 -# Няма
 - Отговор:
		 -# DD
		 -# MM
		 -# YYYY
		 -# HH
		 -# MMM
		 -# SS

<p>

<p>

<p>
Забележка:
 - Датата (или датата и часа) на последния (най-късен) запис във фискалната памет:

<p>
 - DD - Day
 - MM - Month
 - YYYY - Year
 - HH - Hours
 - MMM - Minutes
 - SS - Sec.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outLastFiscalMemoryDay" - DD	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Day 
 - KeyValue - \@"outLastFiscalMemoryMonth" - MM	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Month
 - KeyValue - \@"outLastFiscalMemoryYear" - YYYY	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Year
 - KeyValue - \@"outLastFiscalMemoryHour" - HH	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Hours
 - KeyValue - \@"outLastFiscalMemoryMinute" - MMM	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Minutes
 - KeyValue - \@"outLastFiscalMemorySec" - SS	Датата (или датата и часа) на последния (най-късен) запис във фискалната памет - Sec
*/

    -(NSDictionary *)command86Variant0Version1AndReturnError:(NSError **)error;
/**
57H (87)	ПРОГРАМИРАНЕ НА ИМЕ НА ДЕПАРТАМЕНТ

<p>
 - Област за данни:
			 -# Dept
			 -# TaxGr
			 -# Line1
			 -# Line2
 - Отговор:
			 -# Няма данни

<p>
 - Dept		Номер на департамент. Цяло число от 1 до 60.
 - TaxGr		Данъчна група, асоциирана с департамента.
 - Line1		Име или поясняващ текст за департамента. До 28 символа.
 - Line2		Име или поясняващ текст за департамента (втори ред) до 34 символа.

<p>

<p>
Забележка:

<p>
Командата може да се изпълни само ако за департамента не са издавани фискални бонове след последния Z-отчет. 
При нов принтер или след RAM ресет имената на департаментите са празни. 
Програмираното име се печати в разширения дневен финансов отчет с печат на департаментите (команда 117) и при 
желание в началото на всеки фискален бон.


 <p>
 @param inDepartmentNumber - Dept		Номер на департамент. Цяло число от 1 до 60.
 @param inTaxGroup - TaxGr		Данъчна група, асоциирана с департамента.
 @param inTextRow1 - Line1		Име или поясняващ текст за департамента. До 28 символа.
 @param inTextRow2 - Line2		Име или поясняващ текст за департамента (втори ред) до 34 символа.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command87Variant0Version0InDepartmentNumber:(NSString *)inDepartmentNumber inTaxGroup:(NSString *)inTaxGroup inTextRow1:(NSString *)inTextRow1 inTextRow2:(NSString *)inTextRow2 error:(NSError **)error;
/**
57H (87)	ПРОГРАМИРАНЕ НА ИМЕ НА ДЕПАРТАМЕНТ

<p>
 - Област за данни:
			 -# Dept
			 -# TaxGr
			 -# Line1
 - Отговор:
			 -# Няма данни

<p>
 - Dept		Номер на департамент. Цяло число от 1 до 60.
 - TaxGr		Данъчна група, асоциирана с департамента.
 - Line1		Име или поясняващ текст за департамента. До 28 символа.

<p>

<p>
Забележка:

<p>
Командата може да се изпълни само ако за департамента не са издавани фискални бонове след последния Z-отчет. 
При нов принтер или след RAM ресет имената на департаментите са празни. 
Програмираното име се печати в разширения дневен финансов отчет с печат на департаментите (команда 117) и при 
желание в началото на всеки фискален бон.


 <p>
 @param inDepartmentNumber - Dept		Номер на департамент. Цяло число от 1 до 60.
 @param inTaxGroup - TaxGr		Данъчна група, асоциирана с департамента.
 @param inTextRow1 - Line1		Име или поясняващ текст за департамента. До 28 символа.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command87Variant0Version1InDepartmentNumber:(NSString *)inDepartmentNumber inTaxGroup:(NSString *)inTaxGroup inTextRow1:(NSString *)inTextRow1 error:(NSError **)error;
/**
58H (88)	ПОЛУЧАВАНЕ ДАННИ ЗА НАТРУПАНИТЕ СУМИ ЗА ДЕПАРТАМЕНТ

<p>
 - Област за данни:
			 -# Dept
 - Отговор:
			 -# ExitCode
			 -# TaxGr
			 -# RecSales
			 -# RecSum
			 -# TotSales
			 -# TotSum
			 -# Line1
			 -# Line2

<p>
 - Dept		Номер на департамент. Цяло число от 1 до 60.
			 -# При стойност 0 на департамента се връщат данните за продабите, извършени без посочване на
			 -# департамент. В този случай липсва данъчната група.
 - ExitCode		Един байт с възможни стойности:
				 -# 'P'		Департаментът е програмиран. Следват описаните по-долу данни за него.
				 -# 'F'		Департаментът не е програмиран. Няма данни за него.
 - TaxGr		Данъчна група на департамента.
 - RecSales		Брой продажби за департамента в бона.
 - RecSum		Натрупана сума за текущия или последния фискален бон за съответния департамент.
			 -# Плаващо число с два десетични знака.
 - TotSales		Брой продажби за департамента за деня.
 - TotSum		Натрупана сума за деня за съответния департамент. Плаващо число с два десетични знака.
 - Line1		Име или поясняващ текст за департамента. До 28 символа.
 - Line2		Име или поясняващ текст за департамента - втори ред. До 34 символа.

<p>

<p>
Забележка:


 <p>
 @param inDepartmentNumber - Dept		Номер на департамент. Цяло число от 1 до 60.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outExitCode" - ExitCode

<p>
Един байт с възможни стойности:
 - 'P'		Департаментът е програмиран. Следват описаните по-долу данни за него.
 - 'F'		Департаментът не е програмиран. Няма данни за него.

 - KeyValue - \@"outTaxGroup" - TaxGr		Данъчна група на департамента.
 - KeyValue - \@"outLastReceiptSalesCountInDepartment" - RecSales		Брой продажби за департамента в бона.
 - KeyValue - \@"outLastReceiptSumInDepartment" - RecSum		Натрупана сума за текущия или последния фискален бон за съответния департамент. 
			 -# Плаващо число с два десетични знака.

 - KeyValue - \@"outTotalSalesCountInDepartment" - TotSales		Брой продажби за департамента за деня.
 - KeyValue - \@"outTotalSumInDepartment" - TotSum		Натрупана сума за деня за съответния департамент. Плаващо число с два десетични знака.
 - KeyValue - \@"outTextRow1" - Line1	Име или поясняващ текст за департамента. До 28 символа.
 - KeyValue - \@"outTextRow2" - Line2		Име или поясняващ текст за департамента - втори ред. До 34 символа.
*/

    -(NSDictionary *)command88Variant0Version0InDepartmentNumber:(NSString *)inDepartmentNumber error:(NSError **)error;
/**
5Ah (90) 	ЧЕТЕНЕ НА ДИАГНОСТИЧНА ИНФОРМАЦИЯ

<p>
 - Област за данни:	Няма
 - Отговор:
			 -# PrinterName
			 -# FwRev
			 -# FwDate
			 -# FwTime
			 -# Chk
			 -# Sw
			 -# Ser
			 -# FM

<p>

<p>
 - PrinterName	Име на фискалното устройство (в случая "FMP10KL").
 - FwRev		Версията на програмното осигуряване. 4 байта.
 - FwDate		Датата на програмното осигуряване DDMmmYY. 7 байта.
 - FwTime		Час на програмното осигуряване HHMM. 4 байта.
 - Chk		Контролна сума на EPROM. 4 байта стринг в шестнайсетичен вид.
			 -# Например, ако контролната сума е 214Ah, то тя ще се предаде 32h,31h,34h,41h.
 - Sw		Ключетата от Sw1 до Sw8.
			 -# 8 байта стринг с '0' или '1'
 - Ser		Индивидуален номер на устройството - 8 байта.
 - FМ		Номер на фискалния модул - 8 байта.

<p>

<p>

<p>
Забележка:


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printerName" - PrinterName	Име на фискалното устройство (в случая "FP1000KL").
 - KeyValue - \@"firmwareRevision" - FwRev		Версията на програмното осигуряване. 4 байта. 
 - KeyValue - \@"firmwareDate" - FwDate		Датата на програмното осигуряване DDMmmYY. 7 байта.
 - KeyValue - \@"firmwareTime" - FwTime		Час на програмното осигуряване HHMM. 4 байта.
 - KeyValue - \@"checkSum" - Chk		

<p>
Контролна сума на EPROM. 4 байта стринг в шестнайсетичен вид. 
Например, ако контролната сума е 214Ah, то тя ще се предаде 32h,31h,34h,41h.

 - KeyValue - \@"softwareSwitches" - Sw		Ключетата от Sw1 до Sw8. 
		 -# 8 байта стринг с '0' или '1'

 - KeyValue - \@"serialNumber" - Ser		Индивидуален номер на устройството - 8 байта.
 - KeyValue - \@"fiscalMemoryNumber" - FМ		Номер на фискалния модул - 8 байта.
*/

    -(NSDictionary *)command90Variant0Version0AndReturnError:(NSError **)error;
/**


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printerName" - PrinterName	Име на фискалното устройство (в случая "FP1000KL").
 - KeyValue - \@"firmwareRevision" - FwRev		Версията на програмното осигуряване. 4 байта. 
 - KeyValue - \@"firmwareDate" - FwDate		Датата на програмното осигуряване DDMmmYY. 7 байта.
 - KeyValue - \@"firmwareTime" - FwTime		Час на програмното осигуряване HHMM. 4 байта.
 - KeyValue - \@"checkSum" - Chk		

<p>
Контролна сума на EPROM. 4 байта стринг в шестнайсетичен вид. 
Например, ако контролната сума е 214Ah, то тя ще се предаде 32h,31h,34h,41h.

 - KeyValue - \@"printerIsDiscoverable" - Discoverable	'0' или '1'. BluetoothDiscoverable ако е със стойност 1
 - KeyValue - \@"serialNumber" - Ser		Индивидуален номер на устройството - 8 байта.
 - KeyValue - \@"fiscalMemoryNumber" - FМ		Номер на фискалния модул - 8 байта.
*/

    -(NSDictionary *)command90Variant0Version1AndReturnError:(NSError **)error;
/**
5Ch (92)	ПЕЧАТ НА РАЗДЕЛИТЕЛНА ЛИНИЯ

<p>
 - Област за данни:
			 -# LineType
 - Отговор:
			 -# Няма данни

<p>
 - LineType		Един байт с допустима стойност:
				 -# '1'	Запълване със символа '-'.
				 -# '2'	Запълване последователно със символите '-' и ' '.
				 -# '3'	Запълване със символа '='.

<p>

<p>
Забележка:

<p>
Принтерът печати разделителна линия от посочения тип по цялата ширина на хартията.
Трябва да е отворен фискален или служебен бон.


 <p>
 @param separatingLineType - LineType		

<p>
Един байт с допустима стойност:
 - '1'	Запълване със символа '-'.
 - '2'	Запълване последователно със символите '-' и ' '.
 - '3'	Запълване със символа '='.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command92Variant0Version0SeparatingLineType:(NSString *)separatingLineType error:(NSError **)error;
/**
5Eh (94)	ОТПЕЧАТВАНЕ НА ФИСКАЛНАТА ПАМЕТ ПО ДАТА НА ФИСКАЛЕН ЗАПИС

<p>

<p>
 - Област за данни:
			 -# StartDate
			 -# EndDate
 - Отговор:
			 -# Няма данни

<p>
 - StartDate		Началната дата на фискален запис. 6 байта (DDMMYY).
 - EndDate		Крайна дата на фискален запис. 6 байта (DDMMYY).

<p>

<p>
Забележка:

<p>
Тази команда отпечатва пълен отчет на фискалната памет за периода между две дати.


 <p>
 @param startDate - StartDate		Starting date of selected fiscal entry - 6 bytes (DDMMYY)
 @param endDate - EndDate	End date of the fiscal entry - 6 bytes (DDMMYY)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command94Variant0Version0StartDate:(NSString *)startDate endDate:(NSString *)endDate error:(NSError **)error;
/**
5Fh (95) 	НАТРУПАНИ СУМИ ОТ ФИСКАЛНАТА ПАМЕТ ЗА ДАДЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# StartNumber
			 -# EndNumber
 - Отговор:
			 -# Няма данни

<p>
 - StartNumber	Начален номер на фискален запис.
 - EndNumber	Краен номер на фискален запис.

<p>

<p>
Забележка:

<p>
Командата води до изчисляване и отпечатване на съкратен отчет на фискалната памет. 
Този отчет за целия период на употреба на фискалния принтер може да се предизвика и чрез 
задържането на бутон <FEED> при включване на принтера до четвъртия звуков сигнал.


 <p>
 @param startFiscalRecordNumber - StartNumber	Начален номер на фискален запис.
 @param endFiscalRecordNumber - EndNumber	Краен номер на фискален запис.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command95Variant0Version0StartFiscalRecordNumber:(NSString *)startFiscalRecordNumber endFiscalRecordNumber:(NSString *)endFiscalRecordNumber error:(NSError **)error;
/**
61h (97) 	ПРОЧИТАНЕ НА УСТАНОВЕНИТЕ ДАНЪЧНИ СТАВКИ

<p>

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - TaxA		Данъчна ставка А
 - TaxB		Данъчна ставка Б
 - TaxC		Данъчна ставка В
 - TaxD		Данъчна ставка Г
 - TaxE		Данъчна ставка Д
 - TaxF		Данъчна ставка Е
 - TaxG		Данъчна ставка Ж
 - TaxH		Данъчна ставка З

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"taxGroupA" - TaxA		Данъчна ставка А 
 - KeyValue - \@"taxGroupB" - TaxB		Данъчна ставка Б
 - KeyValue - \@"taxGroupC" - TaxC		Данъчна ставка В
 - KeyValue - \@"taxGroupD" - TaxD		Данъчна ставка Г
 - KeyValue - \@"taxGroupE" - TaxE		Данъчна ставка Д 
 - KeyValue - \@"taxGroupF" - TaxF		Данъчна ставка Е	
 - KeyValue - \@"taxGroupG" - TaxG		Данъчна ставка Ж
 - KeyValue - \@"taxGroupH" - TaxH		Данъчна ставка З
*/

    -(NSDictionary *)command97Variant0Version0AndReturnError:(NSError **)error;
/**
63h (99) 	ПРОЧИТАНЕ НА ЕИК

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# EIK_Text
			 -# EIK_Name

<p>
 - EIK_Text		ЕИК като текст.
 - EIK_Name	Коментарният текст преди ЕИК.

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"outTextEIKValue" - EIK_Text		ЕИК като текст.
 - KeyValue - \@"outTextEIKName" - EIK_Name	Коментарният текст преди ЕИК.
*/

    -(NSDictionary *)command99Variant0Version0AndReturnError:(NSError **)error;
/**
65h (101)	ЗАДАВАНЕ НА ОПЕРАТОРСКА ПАРОЛА

<p>
 - Област за данни:
			 -# OpCode
			 -# OldPwd
			 -# NewPwd
 - Отговор:
			 -# Няма данни

<p>
 - OpCode		Код на оператор. От 1 до 16.
 - OldPwd		Стара парола (4 до 8 цифри).
 - NewPwd		Нова парола (4 до 8 цифри).

<p>

<p>
Забележка:

<p>
Задава една от шестнайсетте операторски пароли. 
Паролата ще бъде поискана при отваряне на фискален бон. 
При три грешни опита за задаване на парола принтерът блокира и трябва да се изключи и включи 
за продължаване на работата.
След инициализация или нулиране на оперативната памет всички пароли са `0000`.


 <p>
 @param operatorCode - OpCode		Код на оператор. От 1 до 16.
 @param oldOperatorPassword - OldPwd		Стара парола (4 до 8 цифри).
 @param newOperatorPassword - NewPwd		Нова парола (4 до 8 цифри).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command101Variant0Version0OperatorCode:(NSString *)operatorCode oldOperatorPassword:(NSString *)oldOperatorPassword newOperatorPassword:(NSString *)newOperatorPassword error:(NSError **)error;
/**
66h (102)	ЗАДАВАНЕ НА ИМЕ НА ОПЕРАТОР

<p>
 - Област за данни:
			 -# OpCode
			 -# Pwd
			 -# OpName
 - Отговор:
			 -# Няма данни

<p>
 - OpCode		Код на оператор. От 1 до 16.
 - Pwd		Парола (4 до 8 цифри).
 - OpName		Име на оператор (до 24 символа).

<p>

<p>
Забележка:

<p>
Задава едно от шестнайсетте имена на оператори. 
Номерът и името на оператора се отпечатва в началото на всеки фискален (клиентски) бон. 
При три грешни пароли принтерът блокира и трябва да се изключи и включи за продължаване на работата.
След инициализация или нулиране на оперативната памет и шестнайсетте имена на оператори са празни.


 <p>
 @param operatorCode - OpCode		Код на оператор. От 1 до 16.
 @param operatorPassword - Pwd		Парола (4 до 8 цифри).
 @param operatorName - OpName		Име на оператор (до 24 символа).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command102Variant0Version0OperatorCode:(NSString *)operatorCode operatorPassword:(NSString *)operatorPassword operatorName:(NSString *)operatorName error:(NSError **)error;
/**
67h (103)	ИНФОРМАЦИЯ ЗА ТЕКУЩИЯ БОН

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# CanVd
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH
			 -# Inv
			 -# InvNum

<p>

<p>
 - CanVd:		Възможно ли е връщане (продажба с отрицателен знак) [0/1]
 - TaxA:		Натрупана сума по данъчна група А
 - TaxB:		Натрупана сума по данъчна група Б
 - TaxC:		Натрупана сума по данъчна група В
 - TaxD:		Натрупана сума по данъчна група Г
 - TaxE:		Натрупана сума по данъчна група Д
 - TaxF:		Натрупана сума по данъчна група Е
 - TaxG:		Натрупана сума по данъчна група Ж
 - TaxH:		Натрупана сума по данъчна група З
 - Inv:		Отворена ли е разширена клиентска бележка?
 - InvNmb:		Номер на следващата фактура /10 цифри/.

<p>

<p>
Забележка:
Дава информация за натрупаните суми по данъчни групи и дали е възможно връщане на регистрирани стоки.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"saleVoidIsPossible" - CanVd:		Възможно ли е връщане (продажба с отрицателен знак) [0/1]
 - KeyValue - \@"taxGroupA" - TaxA:		Натрупана сума по данъчна група А
 - KeyValue - \@"taxGroupB" - TaxB:		Натрупана сума по данъчна група Б
 - KeyValue - \@"taxGroupC" - TaxC:		Натрупана сума по данъчна група В
 - KeyValue - \@"taxGroupD" - TaxD:		Натрупана сума по данъчна група Г
 - KeyValue - \@"taxGroupE" - TaxE:		Натрупана сума по данъчна група Д
 - KeyValue - \@"taxGroupF" - TaxF:		Натрупана сума по данъчна група Е
 - KeyValue - \@"taxGroupG" - TaxG:		Натрупана сума по данъчна група Ж
 - KeyValue - \@"taxGroupH" - TaxH:		Натрупана сума по данъчна група З
 - KeyValue - \@"invoiceOpened" - Inv:		Отворена ли е разширена клиентска бележка? [0/1]
 - KeyValue - \@"nextInvoiceNumber" - InvNmb:		Номер на следващата фактура /10 цифри/.
*/

    -(NSDictionary *)command103Variant0Version0AndReturnError:(NSError **)error;
/**
68h (105)	ОТЧЕТ ОПЕРАТОРИ

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# Няма данни

<p>

<p>
Забележка:

<p>
Разпечатва се информация за продажбите по оператори. 
За всеки оператор се отпечатва името, номера, броя фискални бонове, отстъпки, надбавки, отстъпки, 
корекции и натрупаните суми.


 <p>
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command105Variant0Version0AndReturnError:(NSError **)error;
/**
6Ah (106)	ОТВАРЯНЕ НА ЧЕКМЕДЖЕ

<p>
 - Област за данни:
				 -# mSec
 - Отговор:
				 -# Няма данни

<p>
 - mSec			Дължина на импулса в милисекунди (5-100)

<p>

<p>
Забележка:

<p>
Изпраща импулс за отваряне на чекмедже. 
Параметърът задава нова стойност на дължината на импулса, която се запомня от принтера. 
След RESET на паметта се установява стойност 15 ms.


 <p>
 @param mSec - mSec			Дължина на импулса в милисекунди (5-100)
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command106Variant0Version0MSec:(NSString *)mSec error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>
 - Входни данни:
			 -# Няма
 - Отговор:
			 -# ErrorCode
			 -# Total
			 -# Prog
			 -# Len

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
 - Total		Общ брой програмируеми артикули (12000 за този принтер).
 - Progr		Брой на програмираните артикули.
 - Len		Максимална дължина на име на артикул.

<p>

<p>
Забележка:

<p>
Информация за артикулите.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode	

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"maximumItemCount" - Total		Общ брой програмируеми артикули (3000 за този принтер).
 - KeyValue - \@"currentItemCount" - Progr		Брой на програмираните артикули.
 - KeyValue - \@"maximumItemNameLength" - Len		Максимална дължина на име на артикул.
*/

    -(NSDictionary *)command107Variant0Version0AndReturnError:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>
 - Входни данни:
			 -# TaxGr
			 -# PLU
			 -# Group
			 -# SPrice
			 -# Replace
			 -# Quantity
			 -# ItemName
 - Отговор:
			 -# ErrorCode

<p>

<p>
 - TaxGr		Данъчна група ('А','Б','В','Г',...)
 - PLU		Номер на артикула (1 до 999999999)
 - Group		Стокова група (1 до 99)
 - SPrice		Единична цена. До 8 значещи цифри.
 - Replace		Незадължителен параметър - един байт със стойност 'A'.
			 -# Променя значението на следващия параметър (Quantity).
 - Quantity		Число с до 3 десетични знака - наличното количество за дадения артикул.
			 -# Ако параметърът Replace присъствува, то наличното количество се замества с Quantity, в противен
			 -# случай то се добавя към старото количество (ако артикулът вече е програмиран, разбира се).
			 -# Всяка команда за продажба на артикула ще намалява това количество.
 - ItemName		Име на артикула. До 36 байта.

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:

<p>
Програмиране на артикул

<p>
Могат да се програмират до 20000 артикула. 
Командата ще се отхвърли, ако вече има такъв артикул и по него има продажби. 
Може да се промени артикул с нулеви натрупани суми.

<p>


 <p>
 @param taxGroup - TaxGr		Данъчна група ('А','Б','В','Г',...)
 @param plu - PLU		Номер на артикула (1 до 999999999)
 @param itemGroup - Group		Стокова група (1 до 99)
 @param singleItemPrice - SPrice		Единична цена. До 8 значещи цифри.
 @param replaceQuantity - Replace		

<p>
Незадължителен параметър - един байт със стойност 'A'. 
Променя значението на следващия параметър (Quantity).

 @param itemQuantity - Quantity

<p>
Число с до 3 десетични знака - наличното количество за дадения артикул. 
Ако параметърът Replace присъствува, то наличното количество се замества с Quantity, в противен случай то се 
добавя към старото количество (ако артикулът вече е програмиран, разбира се). 
Всяка команда за продажба на артикула ще намалява това количество.

 @param itemName - ItemName		Име на артикула. До 36 байта.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode	

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command107Variant1Version0TaxGroup:(NSString *)taxGroup plu:(NSString *)plu itemGroup:(NSString *)itemGroup singleItemPrice:(NSString *)singleItemPrice replaceQuantity:(NSString *)replaceQuantity itemQuantity:(NSString *)itemQuantity itemName:(NSString *)itemName error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU
			 -# Quantity
 - Отговор:
			 -# ErrorCode

<p>
 - PLU		Номер на артикула (1 до 999999999).
 - Quantity		Корекция на количеството - плаващо число с до 3 десетични знаци.
			 -# Положителните числа увеличават количеството, отрицателните го намаляват.

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:

<p>
Промяна на наличното количество за артикул.
Командата се отхвърля ако артикулът не е програмиран.

<p>

<p>


 <p>
 @param plu - PLU		Article number (1 to 999999999).
 @param itemQuantity - Quantity		Quantity correction - a floating-point number with 3 decimal places. Positive number increases the available 
		 -# quantity, negative decreases it.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command107Variant2Version0Plu:(NSString *)plu itemQuantity:(NSString *)itemQuantity error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>
Изтриване на артикул - изтриване на всички артикули с ненулеви натрупани суми.

<p>
 - Входни данни:
			 -# Няма
 - Отговор:
			 -# ErrorCode

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:
Изтриване на артикул - изтриване на всички артикули с ненулеви натрупани суми.

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command107Variant4Version0AndReturnError:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode

<p>
 - PLU	Изтрива артикула с посочения номер, ако няма натрупани суми

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:
Изтриване на артикул - изтрива артикула с посочения номер, ако няма натрупани суми.


 <p>
 @param plu - PLU	Изтрива артикула с посочения номер, ако няма натрупани суми
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command107Variant4Version1Plu:(NSString *)plu error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU1
			 -# PLU2
 - Отговор:
			 -# ErrorCode

<p>
 - PLU1		Стартов номер на интервала.
 - PLU2		Краен номер на интервала.

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:
Изтрива артикулите в зададения интервал без натрупани суми.


 <p>
 @param startPLU - PLU1		Стартов номер на интервала.
 @param endPLU - PLU2		Краен номер на интервала.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command107Variant4Version2StartPLU:(NSString *)startPLU endPLU:(NSString *)endPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>

<p>
Забележка:

<p>
Reading Item data
При ненамерен артикул се връща един байт 'F'.

<p>


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - KeyValue - \@"taxGroup" - TaxGr		Данъчна група. Един байт.
 - KeyValue - \@"itemGroup" - Group		Стокова група. От 1 до 99.
 - KeyValue - \@"singleItemPrice" - SPrice		

<p>
Единична цена. 
Плаващо число с десетични знаци текущите за принтера.

 - KeyValue - \@"accumulatedSum" - Total		Натрупана сума за дадения артикул.
 - KeyValue - \@"soldItemQuantity" - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"availableItemQuantity" - Available		Налично количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"itemName" - ItemName		Име на артикула. До 36 байта.
*/

    -(NSDictionary *)command107Variant5Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>

<p>
Забележка:

<p>
Връщане на данните за първия намерен програмиран артикул.
ANSWER_PLU е първия програмиран артикул с номер по-голям или равен на PLU.

<p>

<p>


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - KeyValue - \@"taxGroup" - TaxGr		Данъчна група. Един байт.
 - KeyValue - \@"itemGroup" - Group		Стокова група. От 1 до 99.
 - KeyValue - \@"singleItemPrice" - SPrice	

<p>
Единична цена. 
Плаващо число с десетични знаци текущите за принтера.

 - KeyValue - \@"accumulatedSum" - Total		Натрупана сума за дадения артикул.
 - KeyValue - \@"soldItemQuantity" - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"availableItemQuantity" - Available		Налично количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"itemName" - ItemName		Име на артикула. До 36 байта.
*/

    -(NSDictionary *)command107Variant6Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
		 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>

<p>

<p>
Забележка:

<p>
Връщане на данните за последния намерен програмиран артикул.
ANSWER_PLU е номера на първия програмиран артикул с номер по-малък или равен PLU.

<p>

<p>


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - KeyValue - \@"taxGroup" - TaxGr		Данъчна група. Един байт.
 - KeyValue - \@"itemGroup" - Group		Стокова група. От 1 до 99.
 - KeyValue - \@"singleItemPrice" - SPrice		Единична цена. 
		 -# Плаващо число с десетични знаци текущите за принтера.

 - KeyValue - \@"accumulatedSum" - Total		Натрупана сума за дадения артикул.
 - KeyValue - \@"soldItemQuantity" - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"availableItemQuantity" - Available		Налично количество. Плаващо число с 3 десетични знака.
 - KeyValue - \@"itemName" - ItemName		Име на артикула. До 36 байта.
*/

    -(NSDictionary *)command107Variant7Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>
Забележка:
Връщане на данните за следващия намерен програмиран артикул.
В зависимост от стартиращата подкоманда ('First (CMD_107_6_0)' or 'Last (CMD_107_7_0)'), артикулите са в растящ или 
намаляващ ред.

<p>

<p>

<p>

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - TaxGr	Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Group	Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - SPrice	Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Total	Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Sold	Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available	Available quantity of this article.
 - KeyValue - \@"itemName" - ItemName	The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant8Version0AndReturnError:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>
Забележка:

<p>
Връщане на данните за първия намерен артикул с продажби по него.
ANSWER_PLU е първия намерен артикул с продажби с номер по-голям или равен на PLU. 

<p>

<p>


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - TaxGr	Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Group	Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - SPrice	Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Total	Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Sold	Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available	Available quantity of this article.
 - KeyValue - \@"itemName" - ItemName	The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant9Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>

<p>
Забележка:

<p>
Връщане на данните за последния намерен артикул с продажби по него.
ANSWER_PLU е първия намерен артикул с продажби с номер по-малък или равен на PLU. 

<p>

<p>


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - TaxGr	Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Group	Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - SPrice	Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Total	Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Sold	Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available	Available quantity of this article.
 - KeyValue - \@"itemName" - ItemName	The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant10Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# PLU
			 -# TaxGr
			 -# Group
			 -# SPrice
			 -# Total
			 -# Sold
			 -# Available
			 -# ItemName

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
 - TaxGr		Данъчна група. Един байт.
 - Group		Стокова група. От 1 до 99.
 - SPrice		Единична цена.
			 -# Плаващо число с десетични знаци текущите за принтера.
 - Total		Натрупана сума за дадения артикул.
 - Sold		Продадено количество. Плаващо число с 3 десетични знака.
 - Available		Налично количество. Плаващо число с 3 десетични знака.
 - ItemName		Име на артикула. До 36 байта.

<p>

<p>

<p>
Забележка:

<p>
Връщане на данните за следващия намерен артикул с продажби по него.
В зависимост от стартиращата подкоманда ('First (CMD_107_9_0)' or 'Last (CMD_107_10_0)'), артикулите са в 
растящ или намаляващ ред.

<p>

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Individual number of the item. 9 digits (000000001 to 999999999)
 - KeyValue - \@"taxGroup" - TaxGr	Tax group - 1 byte
 - KeyValue - \@"itemGroup" - Group	Article group. 2 digits (01 - 99).
 - KeyValue - \@"singleItemPrice" - SPrice	Singular price. A floating-point number - decimal places depend on the count set using command 83 (53h).
 - KeyValue - \@"accumulatedSum" - Total	Accumulated sum for this article.
 - KeyValue - \@"soldItemQuantity" - Sold	Accumulated quantity - a floating-point number with 3 decimal places.
 - KeyValue - \@"availableItemQuantity" - Available	Available quantity of this article.
 - KeyValue - \@"itemName" - ItemName	The name of the item. Up to 36 symbols.
*/

    -(NSDictionary *)command107Variant11Version0AndReturnError:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# ANSWER_PLU

<p>

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.

<p>

<p>
Забележка:

<p>
Намиране на първия свободен (непрограмиран) артикул.
ANSWER_PLU е първия свободен (непрограмиран) артикул с номер по-голям или равен на PLU. 


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
*/

    -(NSDictionary *)command107Variant12Version0InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Bh (107)	ДЕФИНИРАНЕ И ЧЕТЕНЕ НА АРТИКУЛИ

<p>

<p>
 - Входни данни:
			 -# PLU
 - Отговор:
			 -# ErrorCode
			 -# ANSWER_PLU

<p>

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>
 - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.

<p>

<p>

<p>

<p>
Забележка:

<p>
Намиране на последния свободен (непрограмиран) артикул.
ANSWER_PLU е първия свободен (непрограмиран) артикул с номер по-малък или равен на PLU. 


 <p>
 @param inPLU - PLU	Номер на артикула. Между 1 и 999999999.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт, показващ резултата от операцията, със значение:
 - -	'P	Командата е успешна.
 - -	'F'	Командата е неуспешна.

 - KeyValue - \@"outPLU" - ANSWER_PLU	Номер на артикула. Между 1 и 999999999.
*/

    -(NSDictionary *)command107Variant12Version1InPLU:(NSString *)inPLU error:(NSError **)error;
/**
6Ch (108)	РАЗШИРЕН ДНЕВЕН ФИНАНСОВ ОТЧЕТ

<p>

<p>

<p>
 - Област за данни:
			 -# Option
			 -# N
 - Response:
			 -# Closure
			 -# FM_Total
			 -# TotA
			 -# TotB
			 -# TotC
			 -# TotD
			 -# TotE
			 -# TotF
			 -# TotG
			 -# TotH

<p>
 - Option		Параметър, управляващ вида на генерирания отчет:
			 -# '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
			 -# '2'	Прави се дневен финансов отчет без нулиране (т. е. не се извършва запис във
				 -# фискалната памет и нулиране на регистрите).
				 -# Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

<p>
 - N		Наличието на този символ забранява изчистването на натрупаните данни по оператори
			 -# при отчет с нулиране.

<p>
 - Closure		Номер на фискалния запис - 4 байта.
 - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - TotX		Сумите по всяка от данъчните групи 'А', 'Б', 'В', : - 12 байта със знак.

<p>

<p>
Забележка:

<p>
В началото на дневния отчет се отпечатва и списъка на артикулите с PLU по-малко или равно на 10, по които има 
продажби за деня.

<p>
Дневен отчет без нулиране може да се предизвика и чрез задържането на бутон <FEED> при включване на принтера до 
третия звуков сигнал.


 <p>
 @param reportTypeOption - Option

<p>
Параметър, управляващ вида на генерирания отчет:
 - '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
 - '2'	Прави се дневен финансов отчет без нулиране
		 -# (т. е. не се извършва запис във фискалната памет и нулиране на регистрите).
		 -# Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

 @param clearOperatorsDataOption - Наличието на този символ забранява изчистването на натрупаните данни по оператори при отчет с нулиране.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Closure		Номер на фискалния запис - 4 байта.
 - KeyValue - \@"totalSumWithoutTaxes" - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - KeyValue - \@"totalSumInTaxGroupA" - TotA	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - TotB	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - TotC	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - TotD	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - TotE	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupF" - TotF	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupG" - TotG	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupH" - TotH	The total under tax category - 12 bytes with a sign.
*/

    -(NSDictionary *)command108Variant0Version0ReportTypeOption:(NSString *)reportTypeOption clearOperatorsDataOption:(NSString *)clearOperatorsDataOption error:(NSError **)error;
/**
6Dh (109)	ПЕЧАТ НА ДУБЛИРАЩ БОН

<p>
 - Област за данни:
				 -# EcrCount
 - Отговор:
				 -# Няма данни

<p>
 - EcrCount			Брой дублиращи бонове (приема се само стойност 1!).

<p>

<p>

<p>
Забележка:
Предизвиква отпечатването на копие на последния затворен фискален бон с продажби. 
Копието се маркира като СЛУЖЕБЕН БОН и веднага след HEADER-а се отпечатва ред с удебелен 
шрифт "ДУБЛИКАТ". 
При повторен опит командата ще откаже да печати. Отпечатването на дублиращ бон е невъзможно и ако 
броят редове в бона е по-голям от 1000.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command109Variant0Version0AndReturnError:(NSError **)error;
/**
6Еh (110)	ДОПЪЛНИТЕЛНА ИНФОРМАЦИЯ ЗА ДЕНЯ

<p>
 - Област за данни:
			 -# Няма данни
 - Отговор:
			 -# Cash
			 -# Credit
			 -# Debit
			 -# Cheque
			 -# Pay1
			 -# Pay2
			 -# Pay3
			 -# Pay4
			 -# Closure
			 -# Receipt

<p>

<p>
 - Cash		Платено в брой
 - Credit		На кредит
 - Debit		С дебитна карта
 - Cheque		Платено с чек
 - PayX		Платено по някой от допълнителните типове плащане
 - Closure		Текущ (последен) фискален запис
 - Receipt		Номер на следващия фискален бон

<p>

<p>
Забележка:

<p>
Връща информация за разпределението на сумата за деня по начин на плащане.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"paidInCash" - Cash		Платено в брой
 - KeyValue - \@"paidWithCreditCart" - Credit		На кредит
 - KeyValue - \@"paidWithDebitCard" - Debit		С дебитна карта
 - KeyValue - \@"paidWithCheque" - Cheque		Платено с чек
 - KeyValue - \@"paidInAdditionalPaymentType1" - PayX		Платено по някой от допълнителните типове плащане
 - KeyValue - \@"paidInAdditionalPaymentType2" - PayX		Платено по някой от допълнителните типове плащане
 - KeyValue - \@"paidInAdditionalPaymentType3" - PayX		Платено по някой от допълнителните типове плащане
 - KeyValue - \@"paidInAdditionalPaymentType4" - PayX		Платено по някой от допълнителните типове плащане
 - KeyValue - \@"currentFiscalRecordNumber" - Closure		Текущ (последен) фискален запис
 - KeyValue - \@"nextFiscalReceiptNumber" - Receipt		Номер на следващия фискален бон
*/

    -(NSDictionary *)command110Variant0Version0AndReturnError:(NSError **)error;
/**
6Fh (111)	ОТЧЕТ ПО АРТИКУЛИ

<p>
 - Област за данни:
			 -# Option
			 -# StartNum
			 -# EndNum

<p>
 - Отговор:
			 -# ErrorCode

<p>
 - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;
 - StartNum		Начален номер на артикул, който да се включи в отчета.
 - EndNum		Последен номер на артикул, който да се включи в отчета.

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>

<p>
Забележка:
Артикулите са сортирани по номер. 
При дневен финансов отчет с нулиране натрупаните суми по артикули се нулират, ако явно не е указано да се запазят.

<p>


 <p>
 @param printOption - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;

 @param startItemNumber - StartNum		Начален номер на артикул, който да се включи в отчета.
 @param endItemNumber - EndNum		Последен номер на артикул, който да се включи в отчета.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" -  - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command111Variant0Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber error:(NSError **)error;
/**
6Fh (111)	ОТЧЕТ ПО АРТИКУЛИ

<p>
 - Област за данни:
			 -# Option
			 -# StartNum
			 -# EndNum
			 -# GroupNum

<p>
 - Отговор:
			 -# ErrorCode

<p>
 - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;
 - StartNum		Начален номер на артикул, който да се включи в отчета.
 - EndNum		Последен номер на артикул, който да се включи в отчета.
 - GroupNum	Число от 1 до 99. Само артикулите от тази група се включват в отчета.

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>

<p>
Забележка:
Артикулите са сортирани по номер. 
При дневен финансов отчет с нулиране натрупаните суми по артикули се нулират, ако явно не е указано да се запазят.

<p>


 <p>
 @param printOption - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;

 @param startItemNumber - StartNum		Начален номер на артикул, който да се включи в отчета.
 @param endItemNumber - EndNum		Последен номер на артикул, който да се включи в отчета.
 @param itemGroupNumber - GroupNum	Число от 1 до 99. Само артикулите от тази група се включват в отчета.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" -  - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command111Variant1Version0PrintOption:(NSString *)printOption startItemNumber:(NSString *)startItemNumber endItemNumber:(NSString *)endItemNumber itemGroupNumber:(NSString *)itemGroupNumber error:(NSError **)error;
/**
6Fh (111)	ОТЧЕТ ПО АРТИКУЛИ

<p>
 - Област за данни:
			 -# Option

<p>
 - Отговор:
			 -# ErrorCode

<p>
 - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;

<p>
 - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

<p>

<p>
Забележка:

<p>
Артикулите са сортирани по номер. 
При дневен финансов отчет с нулиране натрупаните суми по артикули се нулират, ако явно не е указано да се запазят.

<p>


 <p>
 @param printOption - Option		Определя типа на отпечатваната информация. Възможни стойност:
			 -# -	'S'	Отпечатват се само артикулите с продажби за деня.
					 -# За всеки артикул се отпечатва
						 -# номера;
						 -# данъчната група;
						 -# стоковата група;
						 -# името;
						 -# единичната цена;
						 -# продаденото количество;
						 -# оборота;
			 -# -	'P'	Отпечатват се всички програмирани артикули
						 -# номер;
						 -# данъчна група;
						 -# стокова група;
						 -# име;
						 -# продадено количество;
						 -# налично количество;
						 -# единична цена;

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" -  - ErrorCode	Един байт, показващ резултата от операцията, със значение:
			 -# -	'P	Командата е успешна.
			 -# -	'F'	Командата е неуспешна.

*/

    -(NSDictionary *)command111Variant2Version0PrintOption:(NSString *)printOption error:(NSError **)error;
/**
70h (112)	ПОЛУЧАВАНЕ НА ИНФОРМАЦИЯ ЗА ОПЕРАТОР

<p>
 - Област за данни:
			 -# OperatorNumber
 - Отговор:
			 -# Receipts
			 -# Total
			 -# Discount
			 -# Surcharge
			 -# Void
			 -# Name

<p>
 - OperatorNumber		Номер на оператор (1 до 16).
 - ReceiptsNumber		Брой фискални бонове, издадени от оператора.
 - RegisteredSalesNumber	Брой продажби.
 - TotalAccumulatedSum	Обща натрупана сума.
 - DiscountsNumber		Брой отстъпки.
 - TotalDiscounts		Обща сума на отстъпките.
 - SurchargeNumber		Брой надбавки.
 - TotalSurcharge		Обща сума на надбавките.
 - VoidsNumber		Брой корекции.
 - VoidsTotal		Обща сума на корекциите.
 - OperatorName		Име на оператора.
 - OperatorPassword		Операторска парола.
				 -# Връща се само ако принтерът е със поставен сервизен джъмпер.

<p>

<p>
Забележка:
Командата позволява да се получи информацията, отпечатвана при отчет оператори. 
Сумите се връщат като плаващи числа с текущия брой десетични знаци.


 <p>
 @param operatorNumber - OperatorNumber		Номер на оператор (1 до 16).
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"receiptCountForOperator" - ReceiptsNumber		Брой фискални бонове, издадени от оператора.
 - KeyValue - \@"registeredSalesCountForOperator" - RegisteredSalesNumber	Брой продажби.
 - KeyValue - \@"totalAccumulatedSumForOperator" - TotalAccumulatedSum	Обща натрупана сума.
 - KeyValue - \@"discountCountForOperator" - DiscountsNumber		Брой отстъпки.
 - KeyValue - \@"totalDiscountsSumForOperator" - TotalDiscounts		Обща сума на отстъпките.
 - KeyValue - \@"surchargeCountForOperator" - SurchargeNumber		Брой надбавки.
 - KeyValue - \@"totalSurchargeSumForOperator" - TotalSurcharge		Обща сума на надбавките.
 - KeyValue - \@"voidCountForOperator" - VoidsNumber		Брой корекции.
 - KeyValue - \@"voidSumForOperator" - VoidsTotal		Обща сума на корекциите.
 - KeyValue - \@"operatorName" - OperatorName		Име на оператора.
 - KeyValue - \@"operatorPassword" - OperatorPassword

<p>
Операторска парола. 
Връща се само ако принтерът е със поставен сервизен джъмпер.

*/

    -(NSDictionary *)command112Variant0Version0OperatorNumber:(NSString *)operatorNumber error:(NSError **)error;
/**
71h (113)	ПОЛУЧАВАНЕ НОМЕРА НА ПОСЛЕДНИЯ ОТПЕЧАТАН ДОКУМЕНТ

<p>
 - Област за данни:	Няма данни
 - Отговор:		DocNum

<p>

<p>
 - DocNum		Номер на последния издаден документ (7 цифри).

<p>

<p>
Забележка:


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"lastDocumentNumber" - DocNum		Номер на последния издаден документ (7 цифри).
*/

    -(NSDictionary *)command113Variant0Version0AndReturnError:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
Командата връща информация за активните данъчни ставки за въпросния Z-отчет запис.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# DecRec
			 -# DecimalsCount
			 -# VATEnabled
			 -# PercA
			 -# PercB
			 -# PercC
			 -# PercD
			 -# PercE
			 -# PercF
			 -# PercG
			 -# PercH
			 -# DT

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - DecRec		Последен (активен) запис с данъчни ставки.
 - DecimalsCount	Брой десетични знаци за посочения Z-отчет запис.
 - VATEnabled	Разрешени данъчни ставки - 4 байта със ст-ст '0' или '1', където '1' означава "разрешено".
 - Perc...		Данъчна ставка за съответната данъчна група в проценти.
 - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.

<p>


 <p>
 @param fiscalRecordNumber - Closure1		Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"currentTaxRatesRecordNumber" - DecRec		Последен (активен) запис с данъчни ставки.
 - KeyValue - \@"decimalsCount" - DecimalsCount	Брой десетични знаци за посочения Z-отчет запис.
 - KeyValue - \@"enabledTaxArray" - VATEnabled

<p>
Разрешени данъчни ставки - 4 байта със ст-ст '0' или '1', където '1' означава "разрешено".

 - KeyValue - \@"taxRateA" - PercA	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateB" - PercB	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateC" - PercC	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateD" - PercD	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateE" - PercE	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateF" - PercF	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateG" - PercG	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateH" - PercH	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"dateAndTime" - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant0Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# TotA
			 -# TotB
			 -# TotC
			 -# TotD
			 -# TotE
			 -# TotF
			 -# TotG
			 -# TotH

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - TotX		Оборот за съответната данъчна група.

<p>

<p>

<p>
Забележка:

<p>
Командата връща информация за оборота за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"totalTurnoverInTaxGroupA" - TotA	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupB" - TotB	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupC" - TotC	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupD" - TotD	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupE" - TotE	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupF" - TotF	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupG" - TotG	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupH" - TotH	Оборот за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant1Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# NetA
			 -# NetB
			 -# NetC
			 -# NetD
			 -# NetE
			 -# NetF
			 -# NetG
			 -# NetH

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - NetX		Нето сума за съответната данъчна група.

<p>

<p>

<p>
Забележка:
Командата връща информация за нет-сумите за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"netAmountInTaxGroupA" - NetA		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupB" - NetB		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupC" - NetC		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupD" - NetD		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupE" - NetE		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupF" - NetF		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupG" - NetG		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupH" - NetH		Нето сума за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant2Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - TaxX		Начислен ДДС за съответната данъчна група.

<p>

<p>
Забележка:

<p>
Командата връща информация за начисления ДДС за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"vatSumInTaxGroupA" - TaxA		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupB" - TaxB		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupC" - TaxC		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupD" - TaxD		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupE" - TaxE		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupF" - TaxF		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupG" - TaxG		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupH" - TaxH		Начислен ДДС за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant3Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
			 -# Closure2
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# TotA
			 -# TotB
			 -# TotC
			 -# TotD
			 -# TotE
			 -# TotF
			 -# TotG
			 -# TotH

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.
 - Closure2		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - TotX		Оборот за съответната данъчна група.

<p>

<p>

<p>
Забележка:

<p>
Командата връща информация за оборота за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber1 - Closure1		Номер на запис от фискалната памет.
 @param fiscalRecordNumber2 - Closure2		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"totalTurnoverInTaxGroupA" - TotA	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupB" - TotB	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupC" - TotC	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupD" - TotD	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupE" - TotE	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupF" - TotF	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupG" - TotG	Оборот за съответната данъчна група.
 - KeyValue - \@"totalTurnoverInTaxGroupH" - TotH	Оборот за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant1Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
			 -# Closure2
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# NetA
			 -# NetB
			 -# NetC
			 -# NetD
			 -# NetE
			 -# NetF
			 -# NetG
			 -# NetH

<p>
 - Closure1		Номер на запис от фискалната памет.
 - Closure2		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - NetX		Нето сума за съответната данъчна група.

<p>

<p>

<p>
Забележка:
Командата връща информация за нет-сумите за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber1 - Closure1		Номер на запис от фискалната памет.
 @param fiscalRecordNumber2 - Closure2		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"netAmountInTaxGroupA" - NetA		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupB" - NetB		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupC" - NetC		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupD" - NetD		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupE" - NetE		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupF" - NetF		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupG" - NetG		Нето сума за съответната данъчна група.
 - KeyValue - \@"netAmountInTaxGroupH" - NetH		Нето сума за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant2Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
			 -# Closure2
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# Receipts
			 -# TaxA
			 -# TaxB
			 -# TaxC
			 -# TaxD
			 -# TaxE
			 -# TaxF
			 -# TaxG
			 -# TaxH

<p>
 - Closure1		Номер на запис от фискалната памет.
 - Closure2		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - Receipts		Брой фискални бонове.
 - TaxX		Начислен ДДС за съответната данъчна група.

<p>

<p>

<p>
Забележка:
Командата връща информация за начисления ДДС за посочения запис или период.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber1 - Closure1		Номер на запис от фискалната памет.
 @param fiscalRecordNumber2 - Closure2		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"fiscalReceiptsCount" - Receipts		Брой фискални бонове.
 - KeyValue - \@"vatSumInTaxGroupA" - TaxA		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupB" - TaxB		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupC" - TaxC		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupD" - TaxD		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupE" - TaxE		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupF" - TaxF		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupG" - TaxG		Начислен ДДС за съответната данъчна група.
 - KeyValue - \@"vatSumInTaxGroupH" - TaxH		Начислен ДДС за съответната данъчна група.
*/

    -(NSDictionary *)command114Variant3Version1FiscalRecordNumber1:(NSString *)fiscalRecordNumber1 fiscalRecordNumber2:(NSString *)fiscalRecordNumber2 error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# Closure
			 -# DecRec
			 -# ResetRec
			 -# KLEN
			 -# DT

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - Closure		Номер на фискален запис.
 - DecRec		Последен (активен) запис с данъчни ставки.
 - ResetRec		Последно нулиране на RAM до този фискален блок.
 - KLEN_NUM	Номер на КЛЕН за този фискален блок.
 - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.

<p>

<p>

<p>

<p>
Забележка:

<p>
Командата връща допълнителна информация за посочения запис.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Номер на запис от фискалната памет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"outFiscalRecordNumber" - Closure		Номер на фискален запис.
 - KeyValue - \@"currentTaxRatesRecordNumber" - DecRec		Последен (активен) запис с данъчни ставки.
 - KeyValue - \@"lastResetRecordNumber" - ResetRec		Последно нулиране на RAM до този фискален блок.
 - KeyValue - \@"currentKLENNumber" - KLEN_NUM	Номер на КЛЕН за този фискален блок.
 - KeyValue - \@"dateAndTime" - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant4Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# DecimalsCount
			 -# VATEnabled
			 -# PercA
			 -# PercB
			 -# PercC
			 -# PercD
			 -# DT

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - DecimalsCount	Брой десетични знаци за посочения Z-отчет запис.
 - VATEnabled	Разрешени данъчни ставки - 4 байта със ст-ст '0' или '1', където '1' означава "разрешено".
 - PercA/B/C/D	Данъчна ставка за съответната данъчна група в проценти.
 - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.

<p>

<p>

<p>
Забележка:

<p>
Командата връща информация за посочения запис от фискалната памет за задаване на данъчни ставки.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"decimalsCount" - DecimalsCount	Брой десетични знаци за посочения Z-отчет запис.
 - KeyValue - \@"enabledTaxArray" - VATEnabled

<p>
Разрешени данъчни ставки - 4 байта със ст-ст '0' или '1', където '1' означава "разрешено".

 - KeyValue - \@"taxRateA" - PercA	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateB" - PercB	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateC" - PercC	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"taxRateD" - PercD	Данъчна ставка за съответната данъчна група в проценти.
 - KeyValue - \@"dateAndTime" - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant5Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
72h (114)	ИНФОРМАЦИЯ ЗА ФИСКАЛЕН ЗАПИС ИЛИ ФИСКАЛЕН ПЕРИОД

<p>

<p>
 - Област за данни:
			 -# Closure1
 - Отговор:
			 -# ErrorCode
			 -# DT

<p>

<p>
 - Closure1		Номер на запис от фискалната памет.

<p>
 - ErrorCode	Един байт със стойност:
			 -# -	'P'	Данните са валидни.
			 -# -	'F'	Невалидна контролна сума на записа. Няма данни.
			 -# -	'E'	Няма такъв запис. Няма данни.
 - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.

<p>

<p>
Забележка:

<p>
Командата връща информация за за посочения запис от ФП с нулиране на RAM.
Периодичната справка за по-дълъг период може да отнеме няколко секунди.


 <p>
 @param fiscalRecordNumber - Closure1		Number of the fiscal memory record.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - ErrorCode

<p>
Един байт със стойност:
 - -	'P'	Данните са валидни.
 - -	'F'	Невалидна контролна сума на записа. Няма данни.
 - -	'E'	Няма такъв запис. Няма данни.

 - KeyValue - \@"dateAndTime" - DT		Дата и час на данните във формат: DD-MM-YY hh:mm:ss.
*/

    -(NSDictionary *)command114Variant6Version0FiscalRecordNumber:(NSString *)fiscalRecordNumber error:(NSError **)error;
/**
73h (115)	ПРОГРАМИРАНЕ НА ГРАФИЧНО ЛОГО

<p>
 - Област за данни:
			 -# RowNum
			 -# RowData

<p>
 - Отговор:
			 -# Няма

<p>
 - RowNum		Показва реда, който програмираме. Число от 0 до 95.
 - RowData		Графични данни.
			 -# Задават се в шестнайсетичен вид, два символа за всеки байт информация.
			 -# Дължината на данните е до 54 байта, ако са по-малко, се допълват автоматично с 00.

<p>

<p>
Забележка:
Командата дава възможност за дефиниране на графично лого с размер до 54x12mm (432x96 точки) по  желание на потребителя. 
Печатът му се активизира с команда 43. 
Със същата команда се задава и вертикалния му размер. 
За дефиниране на цялото лого командата трябва да се изпълни до 96 пъти, веднъж за всеки ред. 
При ресет на RAM логото се зарежда от флаш-паметта. 
Програмираното с команда 115 лого може да се прехвърли във флаш-паметта с команда 41.


 <p>
 @param rowNumber - RowNum		Shows the line, which is being programmed - a number between 0 and 95
 @param rowData - RowData		

<p>
Графични данни. 
Задават се в шестнайсетичен вид, два символа за всеки байт информация. 
Дължината на данните е до 54 байта, ако са по-малко, се допълват автоматично с 00.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command115Variant0Version0RowNumber:(NSString *)rowNumber rowData:(NSString *)rowData error:(NSError **)error;
/**
73h (115)	ПРОГРАМИРАНЕ НА ГРАФИЧНО ЛОГО

<p>
 - Област за данни:
			 -# RowNum

<p>
 - Отговор:
			 -# RowData

<p>
 - RowNum		Показва реда, който програмираме. Число от 0 до 95.
 - RowData		Графични данни.
			 -# Задават се в шестнайсетичен вид, два символа за всеки байт информация.
			 -# Дължината на данните е до 54 байта, ако са по-малко, се допълват автоматично с 00.

<p>

<p>
Забележка:
Командата дава възможност за дефиниране на графично лого с размер до 54x12mm (432x96 точки) по  желание на потребителя. 
Печатът му се активизира с команда 43. 
Със същата команда се задава и вертикалния му размер. 
За дефиниране на цялото лого командата трябва да се изпълни до 96 пъти, веднъж за всеки ред. 
При ресет на RAM логото се зарежда от флаш-паметта. 
Програмираното с команда 115 лого може да се прехвърли във флаш-паметта с команда 41.


 <p>
 @param rowNumber - RowNum		Показва реда, който четем. Число от 0 до 95.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"rowData" - RowData		

<p>
Графични данни. 
Задават се в шестнайсетичен вид, два символа за всеки байт информация. 
Дължината на данните е до 54 байта, ако са по-малко, се допълват автоматично с 00.

*/

    -(NSDictionary *)command115Variant1Version0RowNumber:(NSString *)rowNumber error:(NSError **)error;
/**
75h (117)	ДНЕВЕН ФИНАНСОВ ОТЧЕТ С ПЕЧАТ НА ДАННИ ПО ДЕПАРТАМЕНТИ

<p>
 - Област за данни:
		 -# Option
		 -# N
 - Отговор:
		 -# Closure
		 -# FM_Total
		 -# TotA
		 -# TotB
		 -# TotC
		 -# TotD
		 -# TotE
		 -# TotF
		 -# TotG
		 -# TotH

<p>
 - Option	Параметър, управляващ вида на генерирания отчет:
		 -# '0'	Отпечатва се Z-отчет.
			 -# Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
			 -# Нулират се и натрупаните данни по департаменти.
		 -# '2'	Прави се дневен финансов отчет без нулиране (т. е. не се извършва запис във
			 -# фискалната памет и нулиране на регистрите). Разпечатката завършва с л
			 -# ого "СЛУЖЕБЕН БОН".

<p>
 - N		Наличието на този символ забранява изчистването на натрупаните данни по оператори
			 -# при отчет с нулиране.

<p>
 - Closure		Номер на фискалния запис - 4 байта.
 - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - TotX		Сумите по всяка от данъчните групи 'А', 'Б', 'В', : - 12 байта със знак.

<p>

<p>
Забележка:
В началото на дневния отчет се отпечатват и департаментите, за които има продажби за деня.
Дневен отчет без нулиране може да се предизвика и чрез задържането на бутон <FEED> при включване на принтера до 
третия звуков сигнал.


 <p>
 @param reportTypeOption - Option

<p>
Параметър, управляващ вида на генерирания отчет:
 - '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
 - '2'	Прави се дневен финансов отчет без нулиране
		 -# (т. е. не се извършва запис във фискалната памет и нулиране на регистрите).
		 -# Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

 @param clearOperatorsDataOption - Наличието на този символ забранява изчистването на натрупаните данни по оператори при отчет с нулиране.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Closure		Номер на фискалния запис - 4 байта.
 - KeyValue - \@"totalSumWithoutTaxes" - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - KeyValue - \@"totalSumInTaxGroupA" - TotA	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - TotB	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - TotC	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - TotD	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - TotE	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupF" - TotF	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupG" - TotG	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupH" - TotH	The total under tax category - 12 bytes with a sign.
*/

    -(NSDictionary *)command117Variant0Version0ReportTypeOption:(NSString *)reportTypeOption clearOperatorsDataOption:(NSString *)clearOperatorsDataOption error:(NSError **)error;
/**
76h (118)	ДНЕВЕН ФИНАНСОВ ОТЧЕТ С ПЕЧАТ НА ДЕПАРТАМЕНТИ И АРТИКУЛИ

<p>
 - Област за данни:
		 -# Option
		 -# N
 - Отговор:
		 -# Closure
		 -# FM_Total
		 -# TotA
		 -# TotB
		 -# TotC
		 -# TotD
		 -# TotE
		 -# TotF
		 -# TotG
		 -# TotH

<p>
 - Option	Параметър, управляващ вида на генерирания отчет:
		 -# '0'	Отпечатва се Z-отчет.
			 -# Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
			 -# Нулират се и натрупаните данни по департаменти.
		 -# '2'	Прави се дневен финансов отчет без нулиране (т. е. не се извършва запис във фискалната
			 -# памет и нулиране на регистрите). Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

<p>
 - N		Наличието на този символ забранява изчистването на натрупаните данни по оператори при
			 -# отчет с нулиране.

<p>
 - Closure		Номер на фискалния запис - 4 байта.
 - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - TotX		Сумите по всяка от данъчните групи 'А', 'Б', 'В', : - 12 байта със знак.

<p>

<p>
Забележка:
В началото на дневния отчет се отпечатват и департаментите, за които има продажби за деня, както и артикулите с номера 
от 1 до 40, ако по тях има продажби. Дневен отчет без нулиране може да се предизвика и чрез задържането на бутон <FEED> 
при включване на принтера до третия звуков сигнал.


 <p>
 @param reportTypeOption - Option

<p>
Параметър, управляващ вида на генерирания отчет:
 - '0'	Отпечатва се Z-отчет. Разпечатката завършва с надпис "ФИСКАЛЕН БОН".
 - '2'	Прави се дневен финансов отчет без нулиране
		 -# (т. е. не се извършва запис във фискалната памет и нулиране на регистрите).
		 -# Разпечатката завършва с лого "СЛУЖЕБЕН БОН".

 @param clearOperatorsDataOption - Наличието на този символ забранява изчистването на натрупаните данни по оператори при отчет с нулиране.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"fiscalRecordNumber" - Closure		Номер на фискалния запис - 4 байта.
 - KeyValue - \@"totalSumWithoutTaxes" - FM_Total		Сумата от всички продажби без ДДС - 12 байта със знак
 - KeyValue - \@"totalSumInTaxGroupA" - TotA	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupB" - TotB	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupC" - TotC	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupD" - TotD	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupE" - TotE	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupF" - TotF	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupG" - TotG	The total under tax category - 12 bytes with a sign.
 - KeyValue - \@"totalSumInTaxGroupH" - TotH	The total under tax category - 12 bytes with a sign.
*/

    -(NSDictionary *)command118Variant0Version0ReportTypeOption:(NSString *)reportTypeOption clearOperatorsDataOption:(NSString *)clearOperatorsDataOption error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:	Няма
 - Отговор:		Няма

<p>

<p>
Забележка:
Отпечатва отчет за валидността на всички SHA-1 контролни суми за Z-отчети, намерени в КЛЕН. 
Сравняват се SHA-1 от КЛЕН и от фискалната памет. 
При разлика се отпечатва един ред с номера на Z-отчета, дата и часа.


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command119Variant0Version0AndReturnError:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# Z_NUM
 - Отговор:
			 -# F_RESULT
			 -# FDocs
			 -# DT
			 -# SK

<p>

<p>
 - Z_NUM		Номера на интересуващия ни Z-отчет.
 - F_RESULT
			 -# F	Не са намерени данни в КЛЕН за този Z-отчет.
			 -# P	Намерени са данни в КЛЕН за този Z-отчет.

<p>
 - FDocs		Номер на документ на Z-отчета.
 - DT		Дата и час на з отчета във формат "DD-MM-YYYY hh:mm:ss".
 - SK		40 символа - SHA-1 на Z-отчета в шестнайсетичен вид.

<p>

<p>

<p>
Забележка:

<p>
Връща информация от КЛЕН за Z-отчет с номер Num. 
Прочитат се данните от посочения Z-отчет като документ.


 <p>
 @param zReportNumber - Z_NUM		Номера на интересуващия ни Z-отчет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - F_RESULT
 - F	Не са намерени данни в КЛЕН за този Z-отчет.
 - P	Намерени са данни в КЛЕН за този Z-отчет.

 - KeyValue - \@"zReportDocumentNumber" - FDocs		Номер на документ на Z-отчета.
 - KeyValue - \@"dateAndTime" - DT		Дата и час на з отчета във формат "DD-MM-YYYY hh:mm:ss".
 - KeyValue - \@"zReportSHA1" - SK		40 символа - SHA-1 на Z-отчета в шестнайсетичен вид.
*/

    -(NSDictionary *)command119Variant0Version1ZReportNumber:(NSString *)zReportNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# Z_NUM
 - Отговор:
			 -# F_RESULT
			 -# Doc_Num
			 -# BUF_SIZE
			 -# SK
			 -# SZ

<p>

<p>
 - Z_NUM		Номера на интересуващия ни Z-отчет.
 - F_RESULT
			 -# F	Не са намерени данни в КЛЕН за този Z-отчет.
				 -# или
				 -# Контролната сума е невалидна. В този случай се попълват и променливите
				 -# Doc_Num,BUF_SIZE,SK,SZ.
			 -# P	Намерени са данни в КЛЕН за този Z-отчет. Попълват се промеливите
				 -# Doc_Num,BUF_SIZE,SK.

<p>
 - Doc_Num		Брой документа прочетени при проверката.
 - BUF_SIZE	Брой байтове прочетени при проверката.
 - SK		40 символа - SHA-1 на Z-отчета в шестнайсетичен вид, запомнена в КЛЕН.
 - SZ		40 символа - SHA-1 на Z-отчета в шестнайсетичен вид - изчислената контролна сума.

<p>

<p>

<p>
Забележка:

<p>
Връща информация от КЛЕН за Z-отчет с номер Num. 
Прочита се реалния текст на документите, записани в КЛЕН, изчислява се SHA-1 и се сравнява 
със SHA-1 от Z-отчета. 
Командата може да продължи дълго време при много документи в дневния отчет.

<p>


 <p>
 @param zReportNumber - Z_NUM		Номера на интересуващия ни Z-отчет.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - F_RESULT

<p>
 - F	Не са намерени данни в КЛЕН за този Z-отчет.
		 -# или
		 -# Контролната сума е невалидна. В този случай се попълват и променливите Doc_Num,BUF_SIZE,SK,SZ.
 - P	Намерени са данни в КЛЕН за този Z-отчет. Попълват се промеливите Doc_Num,BUF_SIZE,SK.

 - KeyValue - \@"documentCount" - Doc_Num		Брой документа прочетени при проверката.
 - KeyValue - \@"dateAndTime" - DT		Дата и час на з отчета във формат "DD-MM-YYYY hh:mm:ss".
 - KeyValue - \@"zReportSHA1" - SK		40 символа - SHA-1 на Z-отчета в шестнайсетичен вид.
*/

    -(NSDictionary *)command119Variant0Version2ZReportNumber:(NSString *)zReportNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН 

<p>

<p>
Командата връща информация за КЛЕН. 

<p>
 - Област за данни:	Няма
 - Отговор:
		 -# P
		 -# Tot
		 -# Used
		 -# C1
		 -# C2
		 -# D1
		 -# D2

<p>
 - F_RESULT
			 -# F	Грешка.
			 -# P	Ок.

<p>
 - Tot_Size		Общ размер на контролната лента в байтове.
 - Used_Size	Използуван размер на контролната лента в байтове.
 - C1		Първи номер на Z-отчет в КЛЕН.
 - C2		Последен номер на Z-отчет в КЛЕН.
 - D1		Първи номер на документ в КЛЕН.
 - D2		Последен номер на документ в КЛЕН.

<p>

<p>
Забележка:

<p>
Командата връща информация за КЛЕН. 


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - F_RESULT
			 -# F	Грешка.
			 -# P	Ок.

 - KeyValue - \@"totalKLENSize" - Tot_Size		Общ размер на контролната лента в байтове.
 - KeyValue - \@"usedKLENSize" - Used_Size		Използуван размер на контролната лента в байтове.
 - KeyValue - \@"firstZReportInKLEN" - C1		Първи номер на Z-отчет в КЛЕН.
 - KeyValue - \@"lastZReportInKLEN" - C2		Последен номер на Z-отчет в КЛЕН.
 - KeyValue - \@"firstDocumentNumberInKLEN" - D1		Първи номер на документ в КЛЕН.
 - KeyValue - \@"lastDocumentNumberInKLEN" - D2		Последен номер на документ в КЛЕН.
*/

    -(NSDictionary *)command119Variant1Version0AndReturnError:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# D1
			 -# D2
 - Отговор:
			 -# FP_RESULT
			 -# THE_TEXT

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>

<p>
Забележка:

<p>
Четене на данни от КЛЕН. 
Връща първия ред от документ номер D1 и задава край на търсенето при документ D2 (включително). 

<p>
Начинът на работа е следният:
1.	Подава се командата.
2.	Ако отговорът е 'F', то няма такива данни в КЛЕН. 
3.	В противен случай се изпраща команда CMD_119_3_0, докато се върне отговор 'F' (няма повече данни). 
 - Така може да се изтегли ред по ред желаната част от КЛЕН като текст.

<p>

<p>
ИНФОРМАЦИЯ ЗА ВИДА НА ВЪРНАТИЯ ТЕКСТ ПРИ ЧЕТЕНЕ НА КЛЕН

<p>
1.	Прочетените документи нямат графично лого.
2.	Центрирането се имитира с добавяне на интервали в началото на реда.
3.	Печатът с двойна ширина се имитира с добавяне на един интервал преди всяка буква.
4.	Ако във фискалните или служебните бонове има баркод, той се заменя с текста "БАРКОД [XXXX]", където 
 - XXXX е текстовата информация от баркода.
5.	Прочетеният ред съдържа само текст, без символите <CR> и <LF> в края на реда. 
 - При изтегляне на текстова информация от КЛЕН тези символи трябва да се добавят в края на всеки ред в тази последователност.

<p>


 <p>
 @param documentNumber1 -  D1	документ номер ...
 @param documentNumber2 -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - FP_RESULT	
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

 - KeyValue - \@"outText" - THE_TEXT	

<p>
Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата 
е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на 
SHA-1 контролната сума.

*/

    -(NSDictionary *)command119Variant2Version0DocumentNumber1:(NSString *)documentNumber1 documentNumber2:(NSString *)documentNumber2 error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# C1
			 -# D1
			 -# D2
 - Отговор:
			 -# FP_RESULT
			 -# THE_TEXT

<p>

<p>
Забележка:

<p>
Четене на данни от КЛЕН. 
Връща първия ред от документ номер D1 за Z-отчет Cl и задава край на търсенето при документ D2 (включително) за същия Z-отчет. 

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>
Начинът на работа е следният:
1.	Подава се командата.
2.	Ако отговорът е 'F', то няма такива данни в КЛЕН. 
3.	В противен случай се изпраща команда CMD_119_3_0, докато се върне отговор 'F' (няма повече данни). 
 - Така може да се изтегли ред по ред желаната част от КЛЕН като текст.

<p>

<p>
ИНФОРМАЦИЯ ЗА ВИДА НА ВЪРНАТИЯ ТЕКСТ ПРИ ЧЕТЕНЕ НА КЛЕН

<p>
1.	Прочетените документи нямат графично лого.
2.	Центрирането се имитира с добавяне на интервали в началото на реда.
3.	Печатът с двойна ширина се имитира с добавяне на един интервал преди всяка буква.
4.	Ако във фискалните или служебните бонове има баркод, той се заменя с текста "БАРКОД [XXXX]", където 
 - XXXX е текстовата информация от баркода.
5.	Прочетеният ред съдържа само текст, без символите <CR> и <LF> в края на реда. 
 - При изтегляне на текстова информация от КЛЕН тези символи трябва да се добавят в края на всеки ред в тази последователност.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param documentNumber1 -  D1	документ номер ...
 @param documentNumber2 -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - FP_RESULT	
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

 - KeyValue - \@"outText" - THE_TEXT	

<p>
Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата 
е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на 
SHA-1 контролната сума.

*/

    -(NSDictionary *)command119Variant2Version1ZReportNumber:(NSString *)zReportNumber documentNumber1:(NSString *)documentNumber1 documentNumber2:(NSString *)documentNumber2 error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# C1
 - Отговор:
			 -# FP_RESULT
			 -# THE_TEXT

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>

<p>
Забележка:

<p>
Четене на данни от КЛЕН. 
Връща първия ред Z-отчет Cl. Тази команда  може да се използва за изтегляне на всички документи от даден Z-отчет.

<p>
Начинът на работа е следният:
1.	Подава се командата.
2.	Ако отговорът е 'F', то няма такива данни в КЛЕН. 
3.	В противен случай се изпраща команда CMD_119_3_0, докато се върне отговор 'F' (няма повече данни). 
 - Така може да се изтегли ред по ред желаната част от КЛЕН като текст.

<p>

<p>
ИНФОРМАЦИЯ ЗА ВИДА НА ВЪРНАТИЯ ТЕКСТ ПРИ ЧЕТЕНЕ НА КЛЕН

<p>
1.	Прочетените документи нямат графично лого.
2.	Центрирането се имитира с добавяне на интервали в началото на реда.
3.	Печатът с двойна ширина се имитира с добавяне на един интервал преди всяка буква.
4.	Ако във фискалните или служебните бонове има баркод, той се заменя с текста "БАРКОД [XXXX]", където 
 - XXXX е текстовата информация от баркода.
5.	Прочетеният ред съдържа само текст, без символите <CR> и <LF> в края на реда. 
 - При изтегляне на текстова информация от КЛЕН тези символи трябва да се добавят в края на всеки ред в тази последователност.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - FP_RESULT	
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

 - KeyValue - \@"outText" - THE_TEXT	

<p>
Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата 
е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на 
SHA-1 контролната сума.

*/

    -(NSDictionary *)command119Variant2Version2ZReportNumber:(NSString *)zReportNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# Flg
			 -# DT1
			 -# DT2
 - Отговор:
			 -# FP_RESULT
			 -# THE_TEXT

<p>

<p>
 - Flg	Стринг от символи, задаващи тип на документ, който да се избере за четене.
		 -# Възможни символи в стринга:
			 -# 'A'	Всички видове документи.
			 -# 'F'	Фискални (клиентски) бонове.
			 -# 'N'	Служебни бонове.
			 -# 'R'	Служебни бонове със завъртян на 90 градуса печат.
			 -# 'S'	Бонове от сервизни операции.
			 -# 'X'	X-отчети.
			 -# 'Z'	Z-отчети.
 - DT1	Начални дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.
 - DT2	Крайни дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>

<p>
Забележка:

<p>
Четене на данни от КЛЕН. 
Връща първия ред от документ с дата и час DT1 и задава край на търсенето при документ с дата и час DT2 (включително). 
Има филтриране на документите, които са избрани, в зависимост от аргумента Flg. 

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>
Начинът на работа е следният:
1.	Подава се командата.
2.	Ако отговорът е 'F', то няма такива данни в КЛЕН. 
3.	В противен случай се изпраща команда CMD_119_3_0, докато се върне отговор 'F' (няма повече данни). 
 - Така може да се изтегли ред по ред желаната част от КЛЕН като текст.

<p>

<p>
ИНФОРМАЦИЯ ЗА ВИДА НА ВЪРНАТИЯ ТЕКСТ ПРИ ЧЕТЕНЕ НА КЛЕН

<p>
1.	Прочетените документи нямат графично лого.
2.	Центрирането се имитира с добавяне на интервали в началото на реда.
3.	Печатът с двойна ширина се имитира с добавяне на един интервал преди всяка буква.
4.	Ако във фискалните или служебните бонове има баркод, той се заменя с текста "БАРКОД [XXXX]", където 
 - XXXX е текстовата информация от баркода.
5.	Прочетеният ред съдържа само текст, без символите <CR> и <LF> в края на реда. 
 - При изтегляне на текстова информация от КЛЕН тези символи трябва да се добавят в края на всеки ред в тази последователност.

<p>


 <p>
 @param outputDocumentType - Flg	

<p>
Стринг от символи, задаващи тип на документ, който да се избере за четене. 
Възможни символи в стринга:
 - 'A'	Всички видове документи.
 - 'F'	Фискални (клиентски) бонове.
 - 'N'	Служебни бонове.
 - 'R'	Служебни бонове със завъртян на 90 градуса печат.
 - 'S'	Бонове от сервизни операции.
 - 'X'	X-отчети.
 - 'Z'	Z-отчети.

 @param startDateAndTime - DT1	

<p>
Начални дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.

 @param endDateAndTime - DT2

<p>
Крайни дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - FP_RESULT	
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

 - KeyValue - \@"outText" - THE_TEXT	

<p>
Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата 
е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на 
SHA-1 контролната сума.

*/

    -(NSDictionary *)command119Variant2Version3OutputDocumentType:(NSString *)outputDocumentType startDateAndTime:(NSString *)startDateAndTime endDateAndTime:(NSString *)endDateAndTime error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:	Няма
 - Отговор:
			 -# FP_RESULT
			 -# THE_TEXT

<p>
Командата връща един от отговорите, посочени по-долу:
 - FP_RESULT
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

<p>
 - THE_TEXT	Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата
			 -# е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на
			 -# SHA-1 контролната сума.

<p>

<p>
Забележка:

<p>
Четене на данни от КЛЕН. 
Използува се в комбинация с някои от командите от клас 'R'. 
Служи за прочитане на следващ текстови ред от КЛЕН. 

<p>
Възможните отговори са същите както при командите за получаване на първи ред:
 - CMD_119_2_0
 - CMD_119_2_1
 - CMD_119_2_2
 - CMD_119_2_3

<p>

<p>

<p>
ВНИМАНИЕ! 
Изпращането на тази команда без предхождаща за първи ред, задаваща обхвата на справката, може да доведе до четенето на 
безсмислени данни!

<p>
Начинът на работа е следният:
1.	Подава се командата.
2.	Ако отговорът е 'F', то няма такива данни в КЛЕН. 
3.	В противен случай се изпраща команда CMD_119_3_0, докато се върне отговор 'F' (няма повече данни). 
 - Така може да се изтегли ред по ред желаната част от КЛЕН като текст.

<p>

<p>
ИНФОРМАЦИЯ ЗА ВИДА НА ВЪРНАТИЯ ТЕКСТ ПРИ ЧЕТЕНЕ НА КЛЕН

<p>
1.	Прочетените документи нямат графично лого.
2.	Центрирането се имитира с добавяне на интервали в началото на реда.
3.	Печатът с двойна ширина се имитира с добавяне на един интервал преди всяка буква.
4.	Ако във фискалните или служебните бонове има баркод, той се заменя с текста "БАРКОД [XXXX]", където 
 - XXXX е текстовата информация от баркода.
5.	Прочетеният ред съдържа само текст, без символите <CR> и <LF> в края на реда. 
 - При изтегляне на текстова информация от КЛЕН тези символи трябва да се добавят в края на всеки ред в тази последователност.

<p>

<p>


 <p>
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"errorCode" - FP_RESULT	
		 -# P	Има пореден текстов ред в КЛЕН, съдържанието му е в THE_TEXT;
		 -# *	Има пореден текстов ред в КЛЕН и това е празен ред - разделител на документи.
		 -# F	Няма повече данни в КЛЕН.

 - KeyValue - \@"outText" - THE_TEXT	

<p>
Текстов ред в КЛЕН. Прочетеният текст е винаги в кодова таблица 1251, независимо дали от ключетата 
е избран режим DOS-овска кодова таблица. Кодовата таблица е важна за правилното пресмятане на 
SHA-1 контролната сума.

*/

    -(NSDictionary *)command119Variant3Version0AndReturnError:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:
			 -# D1
			 -# D2
 - Отговор:
			 -# PCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН.
Отпечатват се документите от номер D1 до номер D2 включително.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param startDocumentNumber -  D1	документ номер ...
 @param ednDocumentNumber -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount		Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version0StartDocumentNumber:(NSString *)startDocumentNumber ednDocumentNumber:(NSString *)ednDocumentNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# D1
			 -# D2
 - Отговор:
			 -# PrintedCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН с 1/2 височина на шрифта.
Отпечатват се документите от номер D1 до номер D2 включително.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param startDocumentNumber -  D1	документ номер ...
 @param endDocumentNumber -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount		Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version1StartDocumentNumber:(NSString *)startDocumentNumber endDocumentNumber:(NSString *)endDocumentNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# C1
			 -# D1
			 -# D2
 - Отговор:
			 -# PrintedCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН. 
Отпечатват се документите от документ номер D1 за Z-отчет Cl до номер D2 включително.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param startDocumentNumber -  D1	документ номер ...
 @param endDocumentNumber -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version2ZReportNumber:(NSString *)zReportNumber startDocumentNumber:(NSString *)startDocumentNumber endDocumentNumber:(NSString *)endDocumentNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:
			 -# C1
			 -# D1
			 -# D2
 - Отговор:
			 -# PrintedCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН с 1/2 височина на шрифта. 
Отпечатват се документите от документ номер D1 за Z-отчет Cl до номер D2 включително.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param startDocumentNumber -  D1	документ номер ...
 @param endDocumentNumber -  D2	документ номер ...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version3ZReportNumber:(NSString *)zReportNumber startDocumentNumber:(NSString *)startDocumentNumber endDocumentNumber:(NSString *)endDocumentNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:
			 -# C1
 - Отговор:
			 -# PrintedCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН. 
Отпечатват се документите за Z-отчет Cl.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version4ZReportNumber:(NSString *)zReportNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:
			 -# C1
 - Отговор:
			 -# PrintedCount

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН с 1/2 височина на шрифта. 
Отпечатват се документите за Z-отчет Cl.

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param zReportNumber - Cl	Z-отчет - номер...
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version5ZReportNumber:(NSString *)zReportNumber error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>

<p>
 - Област за данни:
			 -# Flg
			 -# DT1
			 -# DT2
 - Отговор:
			 -# PrintedCount

<p>
 - Flg	Стринг от символи, задаващи тип на документ, който да се избере за четене.
		 -# Възможни символи в стринга:
			 -# 'A'	Всички видове документи.
			 -# 'F'	Фискални (клиентски) бонове.
			 -# 'N'	Служебни бонове.
			 -# 'R'	Служебни бонове със завъртян на 90 градуса печат.
			 -# 'S'	Бонове от сервизни операции.
			 -# 'X'	X-отчети.
			 -# 'Z'	Z-отчети.
 - DT1	Начални дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.
 - DT2	Крайни дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>
Печат на данни от КЛЕН. 
Отпечатват се документите от дата и час DT1(включително) до дата и час DT2 (включително). 
Има филтриране на документите, които са избрани, в зависимост от аргумента Flg. 

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param outputDocumentType - Flg	

<p>
Стринг от символи, задаващи тип на документ, който да се избере за четене. 
Възможни символи в стринга:
 - 'A'	Всички видове документи.
 - 'F'	Фискални (клиентски) бонове.
 - 'N'	Служебни бонове.
 - 'R'	Служебни бонове със завъртян на 90 градуса печат.
 - 'S'	Бонове от сервизни операции.
 - 'X'	X-отчети.
 - 'Z'	Z-отчети.

 @param startDateAndTime - DT1	

<p>
Начални дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.

 @param endDateAndTime - DT2

<p>
Крайни дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version6OutputDocumentType:(NSString *)outputDocumentType startDateAndTime:(NSString *)startDateAndTime endDateAndTime:(NSString *)endDateAndTime error:(NSError **)error;
/**
77h (119)	РАБОТА С КЛЕН

<p>
 - Област за данни:
			 -# Flg
			 -# DT1
			 -# DT2
 - Отговор:
			 -# PrintedCount

<p>
 - Flg	Стринг от символи, задаващи тип на документ, който да се избере за четене.
		 -# Възможни символи в стринга:
			 -# 'A'	Всички видове документи.
			 -# 'F'	Фискални (клиентски) бонове.
			 -# 'N'	Служебни бонове.
			 -# 'R'	Служебни бонове със завъртян на 90 градуса печат.
			 -# 'S'	Бонове от сервизни операции.
			 -# 'X'	X-отчети.
			 -# 'Z'	Z-отчети.
 - DT1	Начални дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.
 - DT2	Крайни дата и час на справката във формат DDMMYY[hhmmss].
		 -# Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

<p>
 - PrintedCount	Броя отпечатани документи като цяло число.

<p>

<p>
Забележка:

<p>

<p>
Печат на данни от КЛЕН с 1/2 височина на шрифта. 
Отпечатват се документите от дата и час DT1(включително) до дата и час DT2 (включително). 
Има филтриране на документите, които са избрани, в зависимост от аргумента Flg. 

<p>
Копието на документите от КЛЕН е почти идентично с оригиналните документи. 

<p>
Разлики:
1.	Копията никога нямат графично лого преди header-а.
2.	В копията никъде не присъства графичното фискално лого.
3.	Надписът "ФИСКАЛЕН БОН" с фискалното лого се заменя с надпис 
 - "ФИСКАЛЕН БОН - КОПИЕ" с шрифт с двойна ширина.

<p>


 <p>
 @param outputDocumentType - Flg	

<p>
Стринг от символи, задаващи тип на документ, който да се избере за четене. 
Възможни символи в стринга:
 - 'A'	Всички видове документи.
 - 'F'	Фискални (клиентски) бонове.
 - 'N'	Служебни бонове.
 - 'R'	Служебни бонове със завъртян на 90 градуса печат.
 - 'S'	Бонове от сервизни операции.
 - 'X'	X-отчети.
 - 'Z'	Z-отчети.

 @param startDateAndTime - DT1	

<p>
Начални дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "000000", т.е 00:00:00.

 @param endDateAndTime - DT2

<p>
Крайни дата и час на справката във формат DDMMYY[hhmmss]. 
Ако се изпусне часа, то се подразбира "235959", т.е 23:59:59.

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"printedDocumentCount" - PrintedCount	Броя отпечатани документи като цяло число.
*/

    -(NSDictionary *)command119Variant4Version7OutputDocumentType:(NSString *)outputDocumentType startDateAndTime:(NSString *)startDateAndTime endDateAndTime:(NSString *)endDateAndTime error:(NSError **)error;
/**
78h (120) ИЗКЛЮЧВАНЕ НА ПРИНТЕРА

<p>
 - Област за данни:		Няма данни
 - Отговор:			FP_Answer

<p>
 - FP_Answer		Съдържа стринга 'OFF'.

<p>

<p>
Забележка:
Принтерът се изключва (евентуално след довършване на печата). 


 <p>
 @param outText - FP_Answer		Съдържа стринга 'OFF'.
 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command120Variant0Version0OutText:(NSString *)outText error:(NSError **)error;
/**
7AH (122)	ОТВАРЯНЕ НА СЛУЖЕБЕН БОН ЗА ЗАВЪРТЯН НА 90 ГРАДУСА ТЕКСТ

<p>
 - Област за данни:	Няма данни
 - Отговор:
			 -# RotRec

<p>
 - RotRec		Поредният номер на отворения завъртян на 90 градуса бон за деня.
			 -# 4 байта без знак.

<p>

<p>
Забележка:
Командата отваря служебен бон, в който може да се печати завъртян на 90 градуса текст.
Командата няма да се изпълни, ако:
-	Има отворен някакъв бон (служебен или фискален).
-	Няма хартия.
-	Не е сверен часовникът.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"currentRotatedReceiptNumber" - RotRec		

<p>
Поредният номер на отворения завъртян на 90 градуса бон за деня. 
4 байта без знак.

*/

    -(NSDictionary *)command122Variant0Version0AndReturnError:(NSError **)error;
/**
7BH (123)	ПЕЧАТ НА ЗАВЪРТЯН НА 90 ГРАДУСА ТЕКСТ

<p>
Командата служи за печат на завъртян на 90 градуса текст. 

<p>
 - Област за данни:
			 -# THE_TEXT
 - Отговор:
			 -# Няма данни

<p>

<p>
 - THE_TEXT	Съдържанието на поредния ред от текст, който искаме да отпечатаме.
			 -# Дължината му е до 100 символа.

<p>

<p>
Забележка:

<p>
Възможен е печатът на част от текста с атрибути удебелено (Bold) и подчертано (Underline). 
Те се включват и изключват съответно с:
 - <Tab>B	Стартира удебелен печат.
 - <Tab>b	Прекратява удебеления печат.
 - <Tab>U	Стартира подчертан печат. Може да се използува като разделителна хоризинтална линия
		 -# на таблица.
 - <Tab>u	Прекратява подчертания печат.
 - <Tab>A	Вмъква начална вертикална линия за таблици.
 - <Tab>Z	Вмъква крайна вертикална линия за таблици.
 - <Tab>T	Добавя нулев (непечатащ се) ред. Използува се за печат на хоризонтална линия в началото
		 -# на таблицата (преди първия завъртян ред). Следващите символи не се печатат, но ако има
		 -# включен атрибут "подчертаване", той предизвиква печат на линия с дебелина 2 точки.

<p>
Командата служи за печат на завъртян на 90 градуса текст. 
Хартиената лента побира до 13 реда текст. Изпратените редове текст се натрупват в паметта на принтера по реда 
на изпращането им. 
Ако командата се изпълни повече от тринадесет пъти след отварянето на бона, то натрупаната информация се 
отпечатва и принтерът очаква нови текстови редове или команда 124 (затваряне на бона). При отпечатването на 
информацията принтерът определя най-дългия от пратените редове и допълва останалите до същата дължина. 
Ако се пратят повече от 13 реда, то се отпечатва повече от една колона текст. Между двете колони няма никаква 
междина, така че с подходящо подбрани данни могат да се получат редове с неограничена дължина.

<p>
Командата няма да се изпълни, ако не е отворен бон за печат на завъртян служебен текст.

<p>


 <p>
 @param outText - THE_TEXT

<p>
Съдържанието на поредния ред от текст, който искаме да отпечатаме. 
Дължината му е до 100 символа. 

 @param error pointer to NSError object, where error information is stored in case function fails. You can pass nil if you don't want that information
 @return TRUE upon success, FALSE otherwise
*/

    -(bool)command123Variant0Version0OutText:(NSString *)outText error:(NSError **)error;
/**
7CH (124)	ЗАТВАРЯНЕ НА СЛУЖЕБЕН БОН ЗА ЗАВЪРТЯН НА 90 ГРАДУСА ТЕКСТ

<p>
 - Област за данни:	Няма данни
 - Отговор:
			 -# RotRec

<p>
 - RotRec		Поредният номер на затваряния завъртян на 90 градуса бон за деня.
			 -# 4 байта без знак.

<p>

<p>
Забележка:
Командата затваря бона. 
Ако има неотпечатани редове, те се отпечатват автоматично преди затварянето му.
Командата няма да се изпълни, ако не е отворен бон за печат на завъртян служебен текст.


 <p>
 
 <p> 
 @return NSDictionary
 - KeyValue - \@"currentRotatedReceiptNumber" - RotRec

<p>
Поредният номер на затваряния завъртян на 90 градуса бон за деня. 
4 байта без знак.

*/

    -(NSDictionary *)command124Variant0Version0AndReturnError:(NSError **)error;


/* machine-oriented interface - end */

/* human-oriented interface - begin */

/*some informations*/
-(NSDictionary *)diagnosticInfoGetAndReturnError:(NSError **)error;
-(bool)diagnosticInfoPrintAndReturnError:(NSError **)error;

/*non-fiscal bon*/
-(NSDictionary *)nonFiscalReceiptOpenAndReturnError:(NSError **)error;
-(bool)nonFiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
-(NSDictionary *)nonFiscalReceiptCloseAndReturnError:(NSError **)error;

/*fiscal bon*/
-(NSDictionary *)fiscalReceiptOpenAndReturnError:(NSError **)error;
-(bool)fiscalReceiptPrintText:(NSString *)text error:(NSError **)error;
-(bool)fiscalReceiptSellAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptSubtotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptTotalAndReturnError:(NSError **)error;
-(NSDictionary *)fiscalReceiptCloseAndReturnError:(NSError **)error;

/*emergency*/
-(bool)checkAndResolveAndReturnError:(NSError **)error;

/* human-oriented interface - end */


@end
