#import <Foundation/Foundation.h>
#import "SerialStream.h"
#import "ORSSerialPort.h"

#define READ_BUFFER_SIZE (16+4096)

@interface SerialStream : NSStream <ORSSerialPortDelegate>
{
    NSStreamStatus streamStatus;
    
    id <NSStreamDelegate> delegate;
    
	CFReadStreamClientCallBack copiedCallback;
	CFStreamClientContext copiedContext;
	CFOptionFlags requestedEvents;
    
    NSMutableData *streamData;
    
    uint8_t readBuffer[READ_BUFFER_SIZE];
    int readLen;

    NSLock *lock;
    
    ORSSerialPort *serial;
}

@property(nonatomic,unsafe_unretained) id managerDelegate;

@property(nonatomic,readonly) BOOL isOpen;
@property(nonatomic,assign) BOOL connected;
@property(nonatomic,assign) BOOL connectEnabled;
@property(nonatomic,assign) BOOL connectInProgress;

@property(unsafe_unretained) id controlDelegate;


- (id)initWithPort:(ORSSerialPort *)port;
-(BOOL)write:(const uint8_t *)data length:(size_t)length;
-(void)disconnect;

@end

@protocol SerialStreamDelegate
@end

