/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.TintResources;
import android.support.v7.widget.VectorEnabledTintResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TintContextWrapper
extends ContextWrapper {
    private static final Object CACHE_LOCK = new Object();
    private static ArrayList<WeakReference<TintContextWrapper>> sCache;
    private final Resources mResources;
    private final Resources.Theme mTheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context wrap(@NonNull Context context) {
        if (TintContextWrapper.shouldWrap(context)) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (sCache == null) {
                    sCache = new ArrayList();
                } else {
                    WeakReference<TintContextWrapper> ref;
                    int i;
                    for (i = sCache.size() - 1; i >= 0; --i) {
                        ref = sCache.get(i);
                        if (ref != null && ref.get() != null) continue;
                        sCache.remove(i);
                    }
                    for (i = sCache.size() - 1; i >= 0; --i) {
                        TintContextWrapper wrapper;
                        ref = sCache.get(i);
                        TintContextWrapper tintContextWrapper = wrapper = ref != null ? (TintContextWrapper)((Object)ref.get()) : null;
                        if (wrapper == null || wrapper.getBaseContext() != context) continue;
                        return wrapper;
                    }
                }
                TintContextWrapper wrapper = new TintContextWrapper(context);
                sCache.add(new WeakReference<TintContextWrapper>(wrapper));
                return wrapper;
            }
        }
        return context;
    }

    private static boolean shouldWrap(@NonNull Context context) {
        if (context instanceof TintContextWrapper || context.getResources() instanceof TintResources || context.getResources() instanceof VectorEnabledTintResources) {
            return false;
        }
        return Build.VERSION.SDK_INT < 21 || VectorEnabledTintResources.shouldBeUsed();
    }

    private TintContextWrapper(@NonNull Context base) {
        super(base);
        if (VectorEnabledTintResources.shouldBeUsed()) {
            this.mResources = new VectorEnabledTintResources((Context)this, base.getResources());
            this.mTheme = this.mResources.newTheme();
            this.mTheme.setTo(base.getTheme());
        } else {
            this.mResources = new TintResources((Context)this, base.getResources());
            this.mTheme = null;
        }
    }

    public Resources.Theme getTheme() {
        return this.mTheme == null ? super.getTheme() : this.mTheme;
    }

    public void setTheme(int resid) {
        if (this.mTheme == null) {
            super.setTheme(resid);
        } else {
            this.mTheme.applyStyle(resid, true);
        }
    }

    public Resources getResources() {
        return this.mResources;
    }

    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }
}

