/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.design.R;
import android.support.design.animation.AnimationUtils;
import android.support.design.animation.AnimatorSetCompat;
import android.support.design.widget.TextInputLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.Space;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

final class IndicatorViewController {
    private static final int CAPTION_TRANSLATE_Y_ANIMATION_DURATION = 217;
    private static final int CAPTION_OPACITY_FADE_ANIMATION_DURATION = 167;
    static final int ERROR_INDEX = 0;
    static final int HELPER_INDEX = 1;
    static final int COUNTER_INDEX = 2;
    private static final int CAPTION_STATE_NONE = 0;
    private static final int CAPTION_STATE_ERROR = 1;
    private static final int CAPTION_STATE_HELPER_TEXT = 2;
    private final Context context;
    private final TextInputLayout textInputView;
    private LinearLayout indicatorArea;
    private int indicatorsAdded;
    private FrameLayout captionArea;
    private int captionViewsAdded;
    @Nullable
    private Animator captionAnimator;
    private final float captionTranslationYPx;
    private int captionDisplayed;
    private int captionToShow;
    private CharSequence errorText;
    private boolean errorEnabled;
    private TextView errorView;
    private int errorTextAppearance;
    private CharSequence helperText;
    private boolean helperTextEnabled;
    private TextView helperTextView;
    private int helperTextTextAppearance;
    private Typeface typeface;

    public IndicatorViewController(TextInputLayout textInputView) {
        this.context = textInputView.getContext();
        this.textInputView = textInputView;
        this.captionTranslationYPx = this.context.getResources().getDimensionPixelSize(R.dimen.design_textinput_caption_translate_y);
    }

    void showHelper(CharSequence helperText) {
        this.cancelCaptionAnimator();
        this.helperText = helperText;
        this.helperTextView.setText(helperText);
        if (this.captionDisplayed != 2) {
            this.captionToShow = 2;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.helperTextView, helperText));
    }

    void hideHelperText() {
        this.cancelCaptionAnimator();
        if (this.captionDisplayed == 2) {
            this.captionToShow = 0;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.helperTextView, null));
    }

    void showError(CharSequence errorText) {
        this.cancelCaptionAnimator();
        this.errorText = errorText;
        this.errorView.setText(errorText);
        if (this.captionDisplayed != 1) {
            this.captionToShow = 1;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.errorView, errorText));
    }

    void hideError() {
        this.errorText = null;
        this.cancelCaptionAnimator();
        if (this.captionDisplayed == 1) {
            this.captionToShow = this.helperTextEnabled && !TextUtils.isEmpty((CharSequence)this.helperText) ? 2 : 0;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.errorView, null));
    }

    private boolean shouldAnimateCaptionView(TextView captionView, @Nullable CharSequence captionText) {
        return ViewCompat.isLaidOut((View)this.textInputView) && this.textInputView.isEnabled() && (this.captionToShow != this.captionDisplayed || captionView == null || !TextUtils.equals((CharSequence)captionView.getText(), (CharSequence)captionText));
    }

    private void updateCaptionViewsVisibility(final int captionToHide, final int captionToShow, boolean animate) {
        if (animate) {
            AnimatorSet captionAnimator = new AnimatorSet();
            this.captionAnimator = captionAnimator;
            ArrayList<Animator> captionAnimatorList = new ArrayList<Animator>();
            this.createCaptionAnimators(captionAnimatorList, this.helperTextEnabled, this.helperTextView, 2, captionToHide, captionToShow);
            this.createCaptionAnimators(captionAnimatorList, this.errorEnabled, this.errorView, 1, captionToHide, captionToShow);
            AnimatorSetCompat.playTogether(captionAnimator, captionAnimatorList);
            final TextView captionViewToHide = this.getCaptionViewFromDisplayState(captionToHide);
            final TextView captionViewToShow = this.getCaptionViewFromDisplayState(captionToShow);
            captionAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    IndicatorViewController.this.captionDisplayed = captionToShow;
                    IndicatorViewController.this.captionAnimator = null;
                    if (captionViewToHide != null) {
                        captionViewToHide.setVisibility(4);
                        if (captionToHide == 1 && IndicatorViewController.this.errorView != null) {
                            IndicatorViewController.this.errorView.setText(null);
                        }
                    }
                }

                public void onAnimationStart(Animator animator2) {
                    if (captionViewToShow != null) {
                        captionViewToShow.setVisibility(0);
                    }
                }
            });
            captionAnimator.start();
        } else {
            this.setCaptionViewVisibilities(captionToHide, captionToShow);
        }
        this.textInputView.updateEditTextBackground();
        this.textInputView.updateLabelState(animate);
        this.textInputView.updateTextInputBoxState();
    }

    private void setCaptionViewVisibilities(int captionToHide, int captionToShow) {
        TextView captionViewDisplayed;
        TextView captionViewToShow;
        if (captionToHide == captionToShow) {
            return;
        }
        if (captionToShow != 0 && (captionViewToShow = this.getCaptionViewFromDisplayState(captionToShow)) != null) {
            captionViewToShow.setVisibility(0);
            captionViewToShow.setAlpha(1.0f);
        }
        if (captionToHide != 0 && (captionViewDisplayed = this.getCaptionViewFromDisplayState(captionToHide)) != null) {
            captionViewDisplayed.setVisibility(4);
            if (captionToHide == 1) {
                captionViewDisplayed.setText(null);
            }
        }
        this.captionDisplayed = captionToShow;
    }

    private void createCaptionAnimators(List<Animator> captionAnimatorList, boolean captionEnabled, TextView captionView, int captionState, int captionToHide, int captionToShow) {
        if (captionView == null || !captionEnabled) {
            return;
        }
        if (captionState == captionToShow || captionState == captionToHide) {
            captionAnimatorList.add((Animator)this.createCaptionOpacityAnimator(captionView, captionToShow == captionState));
            if (captionToShow == captionState) {
                captionAnimatorList.add((Animator)this.createCaptionTranslationYAnimator(captionView));
            }
        }
    }

    private ObjectAnimator createCaptionOpacityAnimator(TextView captionView, boolean display) {
        float endValue = display ? 1.0f : 0.0f;
        ObjectAnimator opacityAnimator = ObjectAnimator.ofFloat((Object)captionView, (Property)View.ALPHA, (float[])new float[]{endValue});
        opacityAnimator.setDuration(167L);
        opacityAnimator.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        return opacityAnimator;
    }

    private ObjectAnimator createCaptionTranslationYAnimator(TextView captionView) {
        ObjectAnimator translationYAnimator = ObjectAnimator.ofFloat((Object)captionView, (Property)View.TRANSLATION_Y, (float[])new float[]{-this.captionTranslationYPx, 0.0f});
        translationYAnimator.setDuration(217L);
        translationYAnimator.setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        return translationYAnimator;
    }

    void cancelCaptionAnimator() {
        if (this.captionAnimator != null) {
            this.captionAnimator.cancel();
        }
    }

    boolean isCaptionView(int index) {
        return index == 0 || index == 1;
    }

    @Nullable
    private TextView getCaptionViewFromDisplayState(int captionDisplayState) {
        switch (captionDisplayState) {
            case 1: {
                return this.errorView;
            }
            case 2: {
                return this.helperTextView;
            }
        }
        return null;
    }

    void adjustIndicatorPadding() {
        if (this.canAdjustIndicatorPadding()) {
            ViewCompat.setPaddingRelative((View)this.indicatorArea, (int)ViewCompat.getPaddingStart((View)this.textInputView.getEditText()), (int)0, (int)ViewCompat.getPaddingEnd((View)this.textInputView.getEditText()), (int)0);
        }
    }

    private boolean canAdjustIndicatorPadding() {
        return this.indicatorArea != null && this.textInputView.getEditText() != null;
    }

    void addIndicator(TextView indicator, int index) {
        if (this.indicatorArea == null && this.captionArea == null) {
            this.indicatorArea = new LinearLayout(this.context);
            this.indicatorArea.setOrientation(0);
            this.textInputView.addView((View)this.indicatorArea, -1, -2);
            this.captionArea = new FrameLayout(this.context);
            this.indicatorArea.addView((View)this.captionArea, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            Space spacer = new Space(this.context);
            LinearLayout.LayoutParams spacerLp = new LinearLayout.LayoutParams(0, 0, 1.0f);
            this.indicatorArea.addView((View)spacer, (ViewGroup.LayoutParams)spacerLp);
            if (this.textInputView.getEditText() != null) {
                this.adjustIndicatorPadding();
            }
        }
        if (this.isCaptionView(index)) {
            this.captionArea.setVisibility(0);
            this.captionArea.addView((View)indicator);
            ++this.captionViewsAdded;
        } else {
            this.indicatorArea.addView((View)indicator, index);
        }
        this.indicatorArea.setVisibility(0);
        ++this.indicatorsAdded;
    }

    void removeIndicator(TextView indicator, int index) {
        if (this.indicatorArea == null) {
            return;
        }
        if (this.isCaptionView(index) && this.captionArea != null) {
            --this.captionViewsAdded;
            this.setViewGroupGoneIfEmpty((ViewGroup)this.captionArea, this.captionViewsAdded);
            this.captionArea.removeView((View)indicator);
        } else {
            this.indicatorArea.removeView((View)indicator);
        }
        --this.indicatorsAdded;
        this.setViewGroupGoneIfEmpty((ViewGroup)this.indicatorArea, this.indicatorsAdded);
    }

    private void setViewGroupGoneIfEmpty(ViewGroup viewGroup, int indicatorsAdded) {
        if (indicatorsAdded == 0) {
            viewGroup.setVisibility(8);
        }
    }

    void setErrorEnabled(boolean enabled) {
        if (this.errorEnabled == enabled) {
            return;
        }
        this.cancelCaptionAnimator();
        if (enabled) {
            this.errorView = new AppCompatTextView(this.context);
            this.errorView.setId(R.id.textinput_error);
            if (this.typeface != null) {
                this.errorView.setTypeface(this.typeface);
            }
            this.setErrorTextAppearance(this.errorTextAppearance);
            this.errorView.setVisibility(4);
            ViewCompat.setAccessibilityLiveRegion((View)this.errorView, (int)1);
            this.addIndicator(this.errorView, 0);
        } else {
            this.hideError();
            this.removeIndicator(this.errorView, 0);
            this.errorView = null;
            this.textInputView.updateEditTextBackground();
            this.textInputView.updateTextInputBoxState();
        }
        this.errorEnabled = enabled;
    }

    boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    boolean isHelperTextEnabled() {
        return this.helperTextEnabled;
    }

    void setHelperTextEnabled(boolean enabled) {
        if (this.helperTextEnabled == enabled) {
            return;
        }
        this.cancelCaptionAnimator();
        if (enabled) {
            this.helperTextView = new AppCompatTextView(this.context);
            this.helperTextView.setId(R.id.textinput_helper_text);
            if (this.typeface != null) {
                this.helperTextView.setTypeface(this.typeface);
            }
            this.helperTextView.setVisibility(4);
            ViewCompat.setAccessibilityLiveRegion((View)this.helperTextView, (int)1);
            this.setHelperTextAppearance(this.helperTextTextAppearance);
            this.addIndicator(this.helperTextView, 1);
        } else {
            this.hideHelperText();
            this.removeIndicator(this.helperTextView, 1);
            this.helperTextView = null;
            this.textInputView.updateEditTextBackground();
            this.textInputView.updateTextInputBoxState();
        }
        this.helperTextEnabled = enabled;
    }

    boolean errorIsDisplayed() {
        return this.isCaptionStateError(this.captionDisplayed);
    }

    boolean errorShouldBeShown() {
        return this.isCaptionStateError(this.captionToShow);
    }

    private boolean isCaptionStateError(int captionState) {
        return captionState == 1 && this.errorView != null && !TextUtils.isEmpty((CharSequence)this.errorText);
    }

    boolean helperTextIsDisplayed() {
        return this.isCaptionStateHelperText(this.captionDisplayed);
    }

    boolean helperTextShouldBeShown() {
        return this.isCaptionStateHelperText(this.captionToShow);
    }

    private boolean isCaptionStateHelperText(int captionState) {
        return captionState == 2 && this.helperTextView != null && !TextUtils.isEmpty((CharSequence)this.helperText);
    }

    CharSequence getErrorText() {
        return this.errorText;
    }

    CharSequence getHelperText() {
        return this.helperText;
    }

    void setTypefaces(Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.setTextViewTypeface(this.errorView, typeface);
            this.setTextViewTypeface(this.helperTextView, typeface);
        }
    }

    private void setTextViewTypeface(@Nullable TextView captionView, Typeface typeface) {
        if (captionView != null) {
            captionView.setTypeface(typeface);
        }
    }

    @ColorInt
    int getErrorViewCurrentTextColor() {
        return this.errorView != null ? this.errorView.getCurrentTextColor() : -1;
    }

    @Nullable
    ColorStateList getErrorViewTextColors() {
        return this.errorView != null ? this.errorView.getTextColors() : null;
    }

    void setErrorViewTextColor(@Nullable ColorStateList textColors) {
        if (this.errorView != null) {
            this.errorView.setTextColor(textColors);
        }
    }

    void setErrorTextAppearance(@StyleRes int resId) {
        this.errorTextAppearance = resId;
        if (this.errorView != null) {
            this.textInputView.setTextAppearanceCompatWithErrorFallback(this.errorView, resId);
        }
    }

    @ColorInt
    int getHelperTextViewCurrentTextColor() {
        return this.helperTextView != null ? this.helperTextView.getCurrentTextColor() : -1;
    }

    @Nullable
    ColorStateList getHelperTextViewColors() {
        return this.helperTextView != null ? this.helperTextView.getTextColors() : null;
    }

    void setHelperTextViewTextColor(@Nullable ColorStateList textColors) {
        if (this.helperTextView != null) {
            this.helperTextView.setTextColor(textColors);
        }
    }

    void setHelperTextAppearance(@StyleRes int resId) {
        this.helperTextTextAppearance = resId;
        if (this.helperTextView != null) {
            TextViewCompat.setTextAppearance((TextView)this.helperTextView, (int)resId);
        }
    }
}

