﻿using System;
using Android;
using Android.App;
using Android.Content.PM;
using Android.OS;
using Android.Runtime;
using Android.Support.Design.Widget;
using Android.Support.V4.App;
using Android.Support.V4.Content;
using Android.Support.V4.View;
using Android.Support.V4.Widget;
using Android.Support.V7.App;
using Android.Views;
using FiscalPrinterSDK;

namespace GetEJDocuments_DevGr_C
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme.NoActionBar", MainLauncher = true)]
    public class MainActivity : AppCompatActivity, NavigationView.IOnNavigationItemSelectedListener
    {
        public static FiscalPrinterSDK.FDGROUP_C_BGR fiscal;
        private const int LocationPermissionsRequestCode = 1000;
        private static readonly string[] LocationPermissions =
        {
            Manifest.Permission.AccessCoarseLocation,
            Manifest.Permission.AccessFineLocation
        };

        private static MainActivity _instance;

        public static MainActivity GetInstance()
        {
            return _instance;
        }
        protected override void OnCreate(Bundle savedInstanceState)
        {
            _instance = this;
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            SetContentView(Resource.Layout.activity_main);
            Android.Support.V7.Widget.Toolbar toolbar = FindViewById<Android.Support.V7.Widget.Toolbar>(Resource.Id.toolbar);
            SetSupportActionBar(toolbar);

            DrawerLayout drawer = FindViewById<DrawerLayout>(Resource.Id.drawer_layout);
            Android.Support.V7.App.ActionBarDrawerToggle toggle = new Android.Support.V7.App.ActionBarDrawerToggle(this, drawer, toolbar, Resource.String.navigation_drawer_open, Resource.String.navigation_drawer_close);
            drawer.AddDrawerListener(toggle);
            toggle.SyncState();

            NavigationView navigationView = FindViewById<NavigationView>(Resource.Id.nav_view);
            navigationView.SetNavigationItemSelectedListener(this);

            NavigateTo(itemID);
            var coarseLocationPermissionGranted =
                ContextCompat.CheckSelfPermission(this, Manifest.Permission.AccessCoarseLocation);
            var fineLocationPermissionGranted =
                ContextCompat.CheckSelfPermission(this, Manifest.Permission.AccessFineLocation);

            if (coarseLocationPermissionGranted != Permission.Denied ||
                fineLocationPermissionGranted == Permission.Denied)
                ActivityCompat.RequestPermissions(this, LocationPermissions, LocationPermissionsRequestCode);
        }

        public override void OnBackPressed()
        {
            DrawerLayout drawer = FindViewById<DrawerLayout>(Resource.Id.drawer_layout);
            if(drawer.IsDrawerOpen(GravityCompat.Start))
            {
                drawer.CloseDrawer(GravityCompat.Start);
            }
            else
            {
                base.OnBackPressed();
            }
        }

        public override bool OnCreateOptionsMenu(IMenu menu)
        {
            MenuInflater.Inflate(Resource.Menu.menu_main, menu);
            return true;
        }


        private void NavigateTo(int id)
        {
            if (id == Resource.Id.nav_connection || id == 0)
            {
                var myConnection = SupportFragmentManager.FindFragmentById(Resource.Id.linearLayoutConnection) as ConnectionFragment;
                if (myConnection == null)
                {
                    // Make new fragment to show this selection.
                    var newfr = ConnectionFragment.NewInstance();

                    // Execute a transaction, replacing any existing
                    // fragment with this one inside the frame.
                    var ft = SupportFragmentManager.BeginTransaction();
                    ft.Add(Resource.Id.fragment_container, new ConnectionFragment());
                    ft.Replace(Resource.Id.fragment_container, newfr);
                    //ft.SetTransition((int)FragmentTransit.FragmentFade);
                    ft.Commit();
                    ft.Show(new ConnectionFragment());
                }

            }
            else if (id == Resource.Id.nav_usb_connection)
            {
                var myConnection = SupportFragmentManager.FindFragmentById(Resource.Id.linearLayoutUsbConnection) as UsbConnectionFragment;
                if (myConnection == null)
                {
                    // Make new fragment to show this selection.
                    var newfr = UsbConnectionFragment.NewInstance();

                    // Execute a transaction, replacing any existing
                    // fragment with this one inside the frame.
                    var ft = SupportFragmentManager.BeginTransaction();
                    ft.Add(Resource.Id.fragment_container, new UsbConnectionFragment());
                    ft.Replace(Resource.Id.fragment_container, newfr);
                    //ft.SetTransition((int)FragmentTransit.FragmentFade);
                    ft.Commit();
                    ft.Show(new UsbConnectionFragment());
                }

            }
            else if (id == Resource.Id.nav_getEJDocs)
            {
                if (fiscal == null)
                {
                    ExecuteFragmentNotConnected();
                    return;
                }
                if (!fiscal.device_Connected)
                {
                    ExecuteFragmentNotConnected();
                    return;
                }
                var myJournal = SupportFragmentManager.FindFragmentById(Resource.Id.linearLayoutEJ) as ElectronicJournalFragment;
                if (myJournal == null)
                {
                    // Make new fragment to show this selection.
                    var newfr = ElectronicJournalFragment.NewInstance();

                    // Execute a transaction, replacing any existing
                    // fragment with this one inside the frame.
                    var ft = SupportFragmentManager.BeginTransaction();

                    ft.Add(Resource.Id.fragment_container, new ElectronicJournalFragment());
                    ft.Replace(Resource.Id.fragment_container, newfr);
                    //ft.SetTransition((int)FragmentTransit.FragmentFade);
                    ft.Commit();
                    ft.Show(new ElectronicJournalFragment());
                }
            }
            else if (id == Resource.Id.nav_statuses)
            {
                if (fiscal == null)
                {
                    ExecuteFragmentNotConnected();
                    return;
                }
                if (!fiscal.device_Connected)
                {
                    ExecuteFragmentNotConnected();
                    return;
                }
                var myStatuses = SupportFragmentManager.FindFragmentById(Resource.Id.linearLayoutStatuses) as StatusBytesFragment;
                if (myStatuses == null)
                {
                    // Make new fragment to show this selection.
                    var newfr = StatusBytesFragment.NewInstance();

                    // Execute a transaction, replacing any existing
                    // fragment with this one inside the frame.
                    var ft = SupportFragmentManager.BeginTransaction();

                    ft.Add(Resource.Id.fragment_container, new StatusBytesFragment());
                    ft.Replace(Resource.Id.fragment_container, newfr);
                    //ft.SetTransition((int)FragmentTransit.FragmentFade);
                    ft.Commit();
                    ft.Show(new StatusBytesFragment());
                }
            }
        }

        private static int itemID = 0;

       
        public bool OnNavigationItemSelected(IMenuItem item)
        {
            int id = item.ItemId;

            NavigateTo(id);

            DrawerLayout drawer = FindViewById<DrawerLayout>(Resource.Id.drawer_layout);
            drawer.CloseDrawer(GravityCompat.Start);
            itemID = id;
            return true;
        }

        private void ExecuteFragmentNotConnected()
        {
            var notConnectionf = SupportFragmentManager.FindFragmentById(Resource.Id.linearLayoutNotConnected) as DeviceNotConnectedFragment;
            if (notConnectionf == null)
            {
                // Make new fragment to show this selection.
                var newfr = DeviceNotConnectedFragment.NewInstance();

                // Execute a transaction, replacing any existing
                // fragment with this one inside the frame.
                var ft = SupportFragmentManager.BeginTransaction();
                ft.Add(Resource.Id.fragment_container, new DeviceNotConnectedFragment());
                ft.Replace(Resource.Id.fragment_container, newfr);
                //ft.SetTransition((int)FragmentTransit.FragmentFade);
                ft.Commit();
                ft.Show(new DeviceNotConnectedFragment());
            }
        }

        public static void ShowMessage(string msg, string title)
        {
            if (GetInstance() != null)
            {
                new Android.App.AlertDialog.Builder(GetInstance())
                .SetPositiveButton("OK", (sender, args) =>
                {
                    return;
                })
                .SetMessage(msg)
                .SetTitle(title)
                .Show();
            }
        }
        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}

