/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.biometric;

public class AnsiIso {
    private byte[] data;
    private boolean iso;

    AnsiIso(byte[] data, boolean iso) {
        this.data = data;
        this.iso = iso;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 2];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
        }
        return new String(buf, 0, offs);
    }

    private byte[] subArray(int offset, int length) {
        byte[] tmp = new byte[length];
        if (this.iso && offset >= 18) {
            offset -= 4;
        }
        System.arraycopy(this.data, offset, tmp, 0, length);
        return tmp;
    }

    private int subArrayToInt(int offset, int length) {
        byte[] tmp = this.subArray(offset, length);
        int value = 0;
        for (int i = 0; i < tmp.length; ++i) {
            value = value << 8 | tmp[i] & 0xFF;
        }
        return value;
    }

    private String subArrayToString(int offset, int length) {
        byte[] tmp = this.subArray(offset, length);
        return new String(tmp).trim();
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getHeader() {
        if (this.iso) {
            return this.subArray(0, 46);
        }
        return this.subArray(0, 50);
    }

    public String getHeaderAsHexString() {
        byte[] tmp = this.getHeader();
        return AnsiIso.byteArrayToHexString(tmp, 0, tmp.length);
    }

    public String getFormatIdentifierAsString() {
        return this.subArrayToString(0, 4);
    }

    public byte[] getFormatIdentifier() {
        return this.subArray(0, 4);
    }

    public String getVersionNumberAsString() {
        return this.subArrayToString(4, 4);
    }

    public byte[] getVersionNumber() {
        return this.subArray(4, 4);
    }

    public int getRecordLength() {
        return this.subArrayToInt(8, 6);
    }

    public byte[] getProductIdentifier() {
        if (this.iso) {
            return new byte[4];
        }
        return this.subArray(14, 4);
    }

    public String getProductIdentifierAsHexString() {
        byte[] tmp = this.getProductIdentifier();
        return AnsiIso.byteArrayToHexString(tmp, 0, tmp.length);
    }

    public byte[] getCaptureDeviceID() {
        return this.subArray(18, 2);
    }

    public String getCaptureDeviceIDAsHexString() {
        byte[] tmp = this.getCaptureDeviceID();
        return AnsiIso.byteArrayToHexString(tmp, 0, tmp.length);
    }

    public int getImageAsquisionLevel() {
        return this.subArrayToInt(20, 2);
    }

    public int getNumberOfFingers() {
        return this.subArrayToInt(22, 1);
    }

    public int getScaleUnits() {
        return this.subArrayToInt(23, 1);
    }

    public int getScanResolutionHorz() {
        return this.subArrayToInt(24, 2);
    }

    public int getScanResolutionVert() {
        return this.subArrayToInt(26, 2);
    }

    public int getImageResolutionHorz() {
        return this.subArrayToInt(28, 2);
    }

    public int getImageResolutionVert() {
        return this.subArrayToInt(30, 2);
    }

    public int getPixelDepth() {
        return this.subArrayToInt(32, 1);
    }

    public int getImageCompressionAlgorithm() {
        return this.subArrayToInt(33, 1);
    }

    public int getFingerDataBlockLength() {
        return this.subArrayToInt(36, 4);
    }

    public int getFingerPosition() {
        return this.subArrayToInt(40, 1);
    }

    public int getCountOfViews() {
        return this.subArrayToInt(41, 1);
    }

    public int getViewNumber() {
        return this.subArrayToInt(42, 1);
    }

    public int getFingerImageQuality() {
        return this.subArrayToInt(43, 1);
    }

    public int getImpressionType() {
        return this.subArrayToInt(44, 1);
    }

    public int getHorizontalLineLength() {
        return this.subArrayToInt(45, 2);
    }

    public int getVerticalLineLength() {
        return this.subArrayToInt(47, 2);
    }

    public byte[] getImageData() {
        return this.subArray(50, this.getFingerDataBlockLength() - 14);
    }

    public String toString() {
        if (this.iso) {
            return "ISO/IEC 19794-4-2005 Finger Image-Based Data Interchange Format Record";
        }
        return "ANSI INCITS 381-2004 Finger Image-Based Data Interchange Format Record";
    }
}

