/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AES {
    public static byte[] encryptECB(byte[] keyBytes, byte[] dataBytes) {
        String algorithm = keyBytes.length == 32 ? "AES256" : "AES";
        try {
            SecretKeySpec newKey = new SecretKeySpec(keyBytes, algorithm);
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, newKey);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptCBC(byte[] keyBytes, byte[] ivBytes, byte[] dataBytes) {
        String algorithm = keyBytes.length == 32 ? "AES256" : "AES";
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(keyBytes, algorithm);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)newKey, ivSpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptCBC(byte[] keyBytes, byte[] dataBytes) {
        return AES.encryptCBC(keyBytes, new byte[16], dataBytes);
    }

    public static byte[] decryptECB(byte[] keyBytes, byte[] dataBytes) {
        String algorithm = keyBytes.length == 32 ? "AES256" : "AES";
        try {
            SecretKeySpec newKey = new SecretKeySpec(keyBytes, algorithm);
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, newKey);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] ivBytes, byte[] dataBytes) {
        String algorithm = keyBytes.length == 32 ? "AES256" : "AES";
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec newKey = new SecretKeySpec(keyBytes, algorithm);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)newKey, ivSpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] dataBytes) {
        return AES.decryptCBC(keyBytes, new byte[16], dataBytes);
    }
}

