/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.Cipher;

public final class RSA {
    public static byte[] encrypt(byte[] modBytes, byte[] expBytes, byte[] data) {
        try {
            BigInteger modulus = new BigInteger(1, modBytes);
            BigInteger exponent = new BigInteger(1, expBytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            Cipher cipher = Cipher.getInstance("RSA");
            RSAPrivateKeySpec privateSpec = new RSAPrivateKeySpec(modulus, exponent);
            PrivateKey privateKey = factory.generatePrivate(privateSpec);
            cipher.init(1, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] modBytes, byte[] expBytes, byte[] data) {
        try {
            BigInteger modulus = new BigInteger(1, modBytes);
            BigInteger exponent = new BigInteger(1, expBytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            Cipher cipher = Cipher.getInstance("RSA");
            RSAPrivateKeySpec privateSpec = new RSAPrivateKeySpec(modulus, exponent);
            PrivateKey privateKey = factory.generatePrivate(privateSpec);
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] signSHA256(byte[] modBytes, byte[] expBytes, byte[] data) {
        try {
            BigInteger modulus = new BigInteger(1, modBytes);
            BigInteger exponent = new BigInteger(1, expBytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec privateSpec = new RSAPrivateKeySpec(modulus, exponent);
            PrivateKey privateKey = factory.generatePrivate(privateSpec);
            Signature rsaSignature = Signature.getInstance("SHA256withRSA");
            rsaSignature.initSign(privateKey);
            rsaSignature.update(data);
            return rsaSignature.sign();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

