/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.crypto;

import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TR31 {
    private static final char[] HEX_NIBS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int AES_BLOCK_SIZE = 16;

    private static void memclr(byte[] buffer, int offset, int length) {
        while (length-- > 0) {
            buffer[offset++] = 0;
        }
    }

    private static void memshl1(byte[] buffer, int offset, int length) {
        if (length > 0) {
            int n = offset++;
            buffer[n] = (byte)(buffer[n] << 1);
            while (--length > 0) {
                int n2 = offset - 1;
                buffer[n2] = (byte)(buffer[n2] + ((buffer[offset] & 0xFF) >> 7));
                int n3 = offset++;
                buffer[n3] = (byte)(buffer[n3] << 1);
            }
        }
    }

    private static void memxor(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length) {
        while (length-- > 0) {
            int n = dstOffset++;
            dst[n] = (byte)(dst[n] ^ src[srcOffset++]);
        }
    }

    private static void memcpy(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length) {
        System.arraycopy(src, srcOffset, dst, dstOffset, length);
    }

    private static byte[] doubleSubKey(byte[] k) {
        byte[] result = new byte[k.length];
        boolean firstBitSet = (k[0] & 0x80) != 0;
        for (int i = 0; i < k.length; ++i) {
            result[i] = (byte)(k[i] << 1);
            if (i + 1 >= k.length || (k[i + 1] & 0x80) == 0) continue;
            int n = i;
            result[n] = (byte)(result[n] | 1);
        }
        if (firstBitSet) {
            int n = result.length - 1;
            result[n] = (byte)(result[n] ^ 0xFFFFFF87);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encrypt3DES(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, byte[] desKey, int desKeyOffset) {
        byte[] buffer = new byte[24];
        if (desKey.length < 24) {
            TR31.memcpy(buffer, 0, desKey, desKeyOffset, 16);
            TR31.memcpy(buffer, 16, desKey, desKeyOffset, 8);
        } else {
            TR31.memcpy(buffer, 0, desKey, desKeyOffset, 24);
        }
        try {
            SecretKeySpec key = new SecretKeySpec(buffer, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, key);
            cipher.doFinal(src, srcOffset, length, dst, dstOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TR31.memclr(buffer, 0, buffer.length);
        }
    }

    private static void encryptAES(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, byte[] aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec iv = new IvParameterSpec(new byte[16]);
            cipher.init(1, (Key)key, iv);
            cipher.doFinal(src, srcOffset, length, dst, dstOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] deriveCMACSubkey(byte[] bpk) {
        byte[] buffer = new byte[16];
        TR31.encrypt3DES(buffer, 0, buffer, 0, 8, bpk, 0);
        if ((buffer[0] & 0x80) != 0) {
            TR31.memshl1(buffer, 0, 8);
            buffer[7] = (byte)(buffer[7] ^ 0x1B);
        } else {
            TR31.memshl1(buffer, 0, 8);
        }
        TR31.memcpy(buffer, 8, buffer, 0, 8);
        if ((buffer[8] & 0x80) != 0) {
            TR31.memshl1(buffer, 8, 8);
            buffer[15] = (byte)(buffer[15] ^ 0x1B);
        } else {
            TR31.memshl1(buffer, 8, 8);
        }
        return buffer;
    }

    private static byte[] deriveKeyBlockEncryptionKey(byte[] bpk) {
        byte[] buffer = TR31.deriveCMACSubkey(bpk);
        TR31.memcpy(buffer, 8, buffer, 0, 8);
        buffer[0] = (byte)(buffer[0] ^ 1);
        buffer[7] = (byte)(buffer[7] ^ 0x80);
        TR31.encrypt3DES(buffer, 0, buffer, 0, 8, bpk, 0);
        buffer[8] = (byte)(buffer[8] ^ 2);
        buffer[15] = (byte)(buffer[15] ^ 0x80);
        TR31.encrypt3DES(buffer, 8, buffer, 8, 8, bpk, 0);
        return buffer;
    }

    private static byte[] deriveKeyBlockMACKey(byte[] bpk) {
        byte[] buffer = TR31.deriveCMACSubkey(bpk);
        TR31.memcpy(buffer, 8, buffer, 0, 8);
        buffer[0] = (byte)(buffer[0] ^ 1);
        buffer[2] = (byte)(buffer[2] ^ 1);
        buffer[7] = (byte)(buffer[7] ^ 0x80);
        TR31.encrypt3DES(buffer, 0, buffer, 0, 8, bpk, 0);
        buffer[8] = (byte)(buffer[8] ^ 2);
        buffer[10] = (byte)(buffer[10] ^ 1);
        buffer[15] = (byte)(buffer[15] ^ 0x80);
        TR31.encrypt3DES(buffer, 8, buffer, 8, 8, bpk, 0);
        return buffer;
    }

    private static byte[] deriveKeyBlockEncryptionKeyAES(byte[] key) {
        byte[] encSub1 = new byte[]{1, 0, 0, 0, 0, 4, 1, 0, -128, 0, 0, 0, 0, 0, 0, 0};
        byte[] encSub2 = new byte[]{2, 0, 0, 0, 0, 4, 1, 0, -128, 0, 0, 0, 0, 0, 0, 0};
        byte[] k0 = new byte[16];
        TR31.encryptAES(k0, 0, k0, 0, k0.length, key);
        byte[] k1 = TR31.doubleSubKey(k0);
        byte[] k2 = TR31.doubleSubKey(k1);
        byte[] step1 = new byte[encSub1.length];
        TR31.memcpy(step1, 0, encSub1, 0, encSub1.length);
        TR31.memxor(step1, 0, k2, 0, k2.length);
        byte[] step2 = new byte[step1.length];
        TR31.encryptAES(step2, 0, step1, 0, step1.length, key);
        byte[] step3 = new byte[encSub2.length];
        TR31.memcpy(step3, 0, encSub2, 0, encSub2.length);
        TR31.memxor(step3, 0, k2, 0, k2.length);
        byte[] step4 = new byte[step3.length];
        TR31.encryptAES(step4, 0, step3, 0, step3.length, key);
        byte[] buffer = new byte[step2.length + step4.length];
        System.arraycopy(step2, 0, buffer, 0, step2.length);
        System.arraycopy(step4, 0, buffer, step2.length, step4.length);
        return buffer;
    }

    private static byte[] deriveKeyBlockAuthenticationKeyAES(byte[] key) {
        byte[] encSub1 = new byte[]{1, 0, 1, 0, 0, 4, 1, 0, -128, 0, 0, 0, 0, 0, 0, 0};
        byte[] encSub2 = new byte[]{2, 0, 1, 0, 0, 4, 1, 0, -128, 0, 0, 0, 0, 0, 0, 0};
        byte[] k0 = new byte[16];
        TR31.encryptAES(k0, 0, k0, 0, k0.length, key);
        byte[] k1 = TR31.doubleSubKey(k0);
        byte[] k2 = TR31.doubleSubKey(k1);
        byte[] step1 = new byte[encSub1.length];
        TR31.memcpy(step1, 0, encSub1, 0, encSub1.length);
        TR31.memxor(step1, 0, k2, 0, k2.length);
        byte[] step2 = new byte[step1.length];
        TR31.encryptAES(step2, 0, step1, 0, step1.length, key);
        byte[] step3 = new byte[encSub2.length];
        TR31.memcpy(step3, 0, encSub2, 0, encSub2.length);
        TR31.memxor(step3, 0, k2, 0, k2.length);
        byte[] step4 = new byte[step3.length];
        TR31.encryptAES(step4, 0, step3, 0, step3.length, key);
        byte[] buffer = new byte[step2.length + step4.length];
        System.arraycopy(step2, 0, buffer, 0, step2.length);
        System.arraycopy(step4, 0, buffer, step2.length, step4.length);
        return buffer;
    }

    private static byte[] calculateMAC(byte[] key, byte[] src, int srcOffset, int length) {
        byte[] subKey = TR31.deriveCMACSubkey(key);
        byte[] buffer = new byte[8];
        while (length > 0) {
            if (length > 8) {
                TR31.memxor(buffer, 0, src, srcOffset, Math.min(length, 8));
            } else {
                TR31.memxor(buffer, 0, src, srcOffset, Math.min(length, 8));
                TR31.memxor(buffer, 0, subKey, 0, 8);
            }
            srcOffset += 8;
            length -= 8;
            TR31.encrypt3DES(buffer, 0, buffer, 0, 8, key, 0);
        }
        return buffer;
    }

    private static byte[] calculateMACAES(byte[] key, byte[] data, byte[] aesKey) {
        byte[] iv = new byte[16];
        byte[] buffer = new byte[16];
        byte[] all = new byte[data.length + aesKey.length];
        byte[] padd = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(data, 0, all, 0, data.length);
        System.arraycopy(aesKey, 0, all, data.length, aesKey.length);
        byte[] k0 = new byte[16];
        TR31.encryptAES(k0, 0, k0, 0, k0.length, key);
        byte[] k1 = TR31.doubleSubKey(k0);
        byte[] k2 = TR31.doubleSubKey(k1);
        byte[] aesKey_k1 = k1;
        aesKey_k1 = all.length % 16 != 0 ? k2 : k1;
        byte[] some = new byte[all.length + all.length % 16];
        System.arraycopy(all, 0, some, 0, all.length);
        System.arraycopy(padd, 0, some, all.length, all.length % 16);
        int k = some.length / 16;
        int offset = 0;
        System.arraycopy(some, offset, buffer, 0, buffer.length);
        offset += 16;
        byte[] step1 = new byte[buffer.length];
        TR31.memcpy(step1, 0, buffer, 0, buffer.length);
        TR31.memxor(step1, 0, iv, 0, iv.length);
        byte[] step2 = new byte[step1.length];
        TR31.encryptAES(step2, 0, step1, 0, step1.length, key);
        for (int i = 0; i < k - 2; ++i) {
            System.arraycopy(some, offset, buffer, 0, buffer.length);
            offset += 16;
            TR31.memxor(step2, 0, buffer, 0, buffer.length);
            TR31.encryptAES(step2, 0, step2, 0, step2.length, key);
        }
        byte[] step5 = new byte[aesKey_k1.length];
        TR31.memcpy(step5, 0, aesKey_k1, 0, aesKey_k1.length);
        TR31.memxor(step5, 0, step2, 0, step2.length);
        System.arraycopy(some, offset, buffer, 0, buffer.length);
        byte[] step6 = new byte[buffer.length];
        TR31.memcpy(step6, 0, buffer, 0, buffer.length);
        TR31.memxor(step6, 0, step5, 0, step5.length);
        byte[] step7 = new byte[step6.length];
        TR31.encryptAES(step7, 0, step6, 0, step6.length, key);
        return step7;
    }

    private static void encryptData(byte[] mac, byte[] dst, int dstOffset, byte[] src, int srcOffset, int length, byte[] key, int keyOffset) {
        for (int n = 0; n < length; n += 8) {
            if (n > 0) {
                TR31.memcpy(dst, dstOffset + n, dst, dstOffset + n - 8, 8);
                TR31.memxor(dst, dstOffset + n, src, srcOffset + n, 8);
            } else {
                TR31.memcpy(dst, dstOffset + n, mac, 0, 8);
                TR31.memxor(dst, dstOffset + n, src, srcOffset + n, 8);
            }
            TR31.encrypt3DES(dst, dstOffset + n, dst, dstOffset + n, 8, key, keyOffset);
        }
    }

    public static byte[] create(byte[] bpk, String usage, String algorithm, String modeOfUse, String keyVersion, String exportability, byte[] key, byte[] ksn) {
        byte[] buffer = ksn != null ? new byte[104] : new byte[80];
        int offset = 0;
        buffer[offset++] = 66;
        buffer[offset++] = (byte)(48 + buffer.length / 1000 % 10);
        buffer[offset++] = (byte)(48 + buffer.length / 100 % 10);
        buffer[offset++] = (byte)(48 + buffer.length / 10 % 10);
        buffer[offset++] = (byte)(48 + buffer.length % 10);
        buffer[offset++] = (byte)usage.charAt(0);
        buffer[offset++] = (byte)usage.charAt(1);
        buffer[offset++] = (byte)algorithm.charAt(0);
        buffer[offset++] = (byte)modeOfUse.charAt(0);
        buffer[offset++] = (byte)keyVersion.charAt(0);
        buffer[offset++] = (byte)keyVersion.charAt(1);
        buffer[offset++] = (byte)exportability.charAt(0);
        if (ksn != null) {
            buffer[offset++] = 48;
            buffer[offset++] = 49;
            buffer[offset++] = 48;
            buffer[offset++] = 48;
            buffer[offset++] = 50;
            buffer[offset++] = 48;
            buffer[offset++] = 49;
            buffer[offset++] = 56;
            for (byte b : ksn) {
                buffer[offset++] = (byte)HEX_NIBS[(b & 0xFF) >> 4];
                buffer[offset++] = (byte)HEX_NIBS[b & 0xF];
            }
        } else {
            buffer[offset++] = 48;
            buffer[offset++] = 48;
            buffer[offset++] = 48;
            buffer[offset++] = 48;
        }
        buffer[offset++] = 0;
        buffer[offset++] = -128;
        for (byte b : key) {
            buffer[offset++] = b;
        }
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        buffer[offset++] = (byte)(Math.random() * 255.0 + 1.0);
        byte[] encKey = TR31.deriveKeyBlockEncryptionKey(bpk);
        byte[] macKey = TR31.deriveKeyBlockMACKey(bpk);
        byte[] mac = TR31.calculateMAC(macKey, buffer, 0, offset);
        TR31.encryptData(mac, buffer, buffer.length - 24, buffer, offset - 24, 24, encKey, 0);
        TR31.memclr(encKey, 0, encKey.length);
        TR31.memclr(macKey, 0, macKey.length);
        offset -= 24;
        for (int n = 0; n < 24; ++n) {
            buffer[offset++] = (byte)HEX_NIBS[(buffer[buffer.length - 24 + n] & 0xFF) >> 4];
            buffer[offset++] = (byte)HEX_NIBS[buffer[buffer.length - 24 + n] & 0xF];
        }
        for (byte b : mac) {
            buffer[offset++] = (byte)HEX_NIBS[(b & 0xFF) >> 4];
            buffer[offset++] = (byte)HEX_NIBS[b & 0xF];
        }
        return buffer;
    }

    public static byte[] create(byte[] bpk, String usage, String algorithm, String modeOfUse, String keyVersion, String exportability, byte[] key) {
        return TR31.create(bpk, usage, algorithm, modeOfUse, keyVersion, exportability, key, null);
    }

    public static byte[] createAES(long seed, byte[] bpk, String usage, String algorithm, String modeOfUse, String keyVersion, String exportability, byte[] key, byte[] ksn) {
        int keyBlockLength;
        byte[] random;
        int optional = ksn != null ? ksn.length * 2 + 4 : 0;
        if (key.length == 16) {
            random = new byte[14];
            keyBlockLength = 112 + optional;
        } else if (key.length == 24) {
            random = new byte[6];
            keyBlockLength = 112 + optional;
        } else if (key.length == 32) {
            random = new byte[14];
            keyBlockLength = 144 + optional;
        } else {
            throw new IllegalArgumentException("Invalid key length");
        }
        Random rand = new Random(seed);
        rand.nextBytes(random);
        byte[] prepAes = new byte[key.length + 2 + random.length];
        byte[] header = new byte[16 + optional];
        byte[] buffer = new byte[16];
        byte[] length = new byte[2];
        int keyBits = key.length * 8;
        length[0] = (byte)(keyBits / 256);
        length[1] = (byte)(keyBits % 256);
        System.arraycopy(length, 0, prepAes, 0, length.length);
        System.arraycopy(key, 0, prepAes, length.length, key.length);
        System.arraycopy(random, 0, prepAes, length.length + key.length, random.length);
        byte[] endBuffer = new byte[prepAes.length];
        byte[] derKBEK = TR31.deriveKeyBlockEncryptionKeyAES(bpk);
        byte[] derKBAK = TR31.deriveKeyBlockAuthenticationKeyAES(bpk);
        int offset = 0;
        header[offset++] = 68;
        header[offset++] = (byte)(48 + keyBlockLength / 1000 % 10);
        header[offset++] = (byte)(48 + keyBlockLength / 100 % 10);
        header[offset++] = (byte)(48 + keyBlockLength / 10 % 10);
        header[offset++] = (byte)(48 + keyBlockLength % 10);
        header[offset++] = (byte)usage.charAt(0);
        header[offset++] = (byte)usage.charAt(1);
        header[offset++] = (byte)algorithm.charAt(0);
        header[offset++] = (byte)modeOfUse.charAt(0);
        header[offset++] = (byte)keyVersion.charAt(0);
        header[offset++] = (byte)keyVersion.charAt(1);
        header[offset++] = (byte)exportability.charAt(0);
        if (ksn != null) {
            header[offset++] = 48;
            header[offset++] = 49;
            header[offset++] = 48;
            header[offset++] = 48;
            header[offset++] = 50;
            header[offset++] = 48;
            header[offset++] = (byte)HEX_NIBS[ksn.length * 2 + 4 >> 4 & 0xF];
            header[offset++] = (byte)HEX_NIBS[ksn.length * 2 + 4 & 0xF];
            for (byte b : ksn) {
                header[offset++] = (byte)HEX_NIBS[(b & 0xFF) >> 4];
                header[offset++] = (byte)HEX_NIBS[b & 0xF];
            }
        } else {
            header[offset++] = 48;
            header[offset++] = 48;
            header[offset++] = 48;
            header[offset++] = 48;
        }
        System.arraycopy(prepAes, 0, buffer, 0, buffer.length);
        byte[] mac = TR31.calculateMACAES(derKBAK, header, prepAes);
        int k = prepAes.length / 16;
        byte[] step1 = new byte[buffer.length];
        TR31.memcpy(step1, 0, buffer, 0, buffer.length);
        TR31.memxor(step1, 0, mac, 0, mac.length);
        byte[] step2 = new byte[step1.length];
        TR31.encryptAES(step2, 0, step1, 0, step1.length, derKBEK);
        System.arraycopy(step2, 0, endBuffer, 0, step2.length);
        offset = 16;
        for (int i = 1; i < k; ++i) {
            System.arraycopy(prepAes, offset, buffer, 0, buffer.length);
            TR31.memxor(step2, 0, buffer, 0, buffer.length);
            TR31.encryptAES(step2, 0, step2, 0, step2.length, derKBEK);
            System.arraycopy(step2, 0, endBuffer, offset, step2.length);
            offset += 16;
        }
        byte[] result = new byte[header.length + endBuffer.length * 2 + mac.length * 2];
        System.arraycopy(header, 0, result, 0, header.length);
        offset = header.length;
        for (byte b : endBuffer) {
            result[offset++] = (byte)HEX_NIBS[(b & 0xFF) >> 4];
            result[offset++] = (byte)HEX_NIBS[b & 0xF];
        }
        for (byte b : mac) {
            result[offset++] = (byte)HEX_NIBS[(b & 0xFF) >> 4];
            result[offset++] = (byte)HEX_NIBS[b & 0xF];
        }
        return result;
    }

    public static byte[] createAES(byte[] bpk, String usage, String algorithm, String modeOfUse, String keyVersion, String exportability, byte[] key, byte[] ksn) {
        long seed = System.currentTimeMillis();
        return TR31.createAES(seed, bpk, usage, algorithm, modeOfUse, keyVersion, exportability, key, ksn);
    }

    public static byte[] createAES(byte[] bpk, String usage, String algorithm, String modeOfUse, String keyVersion, String exportability, byte[] key) {
        return TR31.createAES(bpk, usage, algorithm, modeOfUse, keyVersion, exportability, key, null);
    }

    public static byte[] deriveKey(byte[] part1, byte[] part2) {
        byte[] key = new byte[part1.length];
        TR31.memcpy(key, 0, part1, 0, part1.length);
        TR31.memxor(key, 0, part2, 0, part2.length);
        return key;
    }
}

