/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.hub;

import com.datecs.hub.HubException;
import com.datecs.hub.SlaveConnection;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Hub
implements Closeable {
    private static boolean sDEBUG = false;
    private static final int DEVICE_TIMEOUT = 5000;
    private static final int MIN_PACKET_SIZE = 6;
    private static final int MAX_PACKET_SIZE = 2048;
    private static final int MAX_RECEIVE_BUFFER_SIZE = 8192;
    public static final int ERROR_INVALID_LENGTH = 2;
    public static final int ERROR_SLAVE = 3;
    public static final int ERROR_INVALID_COMMAND = 4;
    public static final int ERROR_TIMEOUT = 5;
    public static final int ERROR_COMMUNICATION = 19;
    public static final int ERROR_NVRAM = 20;
    public static final int SLAVE_TYPE_USB = 1;
    public static final int SLAVE_TYPE_RS232 = 2;
    public static final int SLAVE_STATE_DISCONNECTED = 0;
    public static final int SLAVE_STATE_READY = 1;
    public static final int SLAVE_STATE_UNKNOWN = 2;
    public static final int SLAVE_STATE_ERROR = 3;
    private static final int COMMAND_DATA_WRITE = 1;
    private static final int COMMAND_GET_SLAVE_TYPE = 2;
    private static final int COMMAND_CHECK_SLAVE_CONNECTION = 3;
    private static final int COMMAND_WRITE_DATA_NVRAM = 4;
    private static final int COMMAND_READ_DATA_NVRAM = 5;
    private static final int COMMAND_GET_DEVICE_DESCRIPTOR = 16;
    private static final int COMMAND_GET_STRING_DESCRIPTOR = 17;
    private static final int COMMAND_SET_APPLE_CHARGE = 18;
    private static final int COMMAND_CONFIGURE_RS232_SETTINGS = 32;
    public static final int EVENT_SLAVE_CONNECTED = 1;
    public static final int EVENT_SLAVE_DISCONNECTED = 2;
    public static final int EVENT_SLAVE_DATA_RECEIVED = 3;
    public static final int EVENT_SLAVE_OVERCURRENT = 4;
    private final byte[] mResponse = new byte[2048];
    private final Map<Integer, LinkedList<Byte>> mReceiverBuffers = new HashMap<Integer, LinkedList<Byte>>();
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private ReceiverThread mReceiver;
    private IOException mLastError;
    private SlaveConnection mSlaveConnection;

    public Hub(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The parameter 'inputStream' can not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("The parameter 'outputStream' can not be null");
        }
        this.mBaseInputStream = inputStream;
        this.mBaseOutputStream = outputStream;
        this.mReceiver = new ReceiverThread();
        this.mReceiver.start();
    }

    public Hub(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("The parameter 'fd' can not be null");
        }
        this.mBaseInputStream = new FileInputStream(fd);
        this.mBaseOutputStream = new FileOutputStream(fd);
        this.mReceiver = new ReceiverThread();
        this.mReceiver.start();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mBaseInputStream != null) {
            try {
                this.mBaseInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mBaseOutputStream != null) {
            try {
                this.mBaseOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setDebug(boolean on) {
        sDEBUG = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    private static final void debug(String message, byte[] buffer, int offset, int length) {
        if (sDEBUG) {
            System.out.println(message + Hub.byteArrayToHexString(buffer, offset, length) + "(" + length + ")");
        }
    }

    private void write(byte[] b) throws IOException {
        this.mBaseOutputStream.write(b);
        this.mBaseOutputStream.flush();
        Hub.debug(">> ", b, 0, b.length);
    }

    private int read(byte[] b, int offset, int size) throws IOException {
        int nbr = this.mBaseInputStream.read(b, offset, size);
        if (nbr < 0) {
            throw new IOException("The end of stream has been reached");
        }
        if (nbr > 0) {
            Hub.debug("<< ", b, offset, nbr);
        } else {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return nbr;
    }

    private void processEvent(int event, byte[] packet, int length) {
        int slaveID = packet[5] & 0xFF;
        switch (event) {
            case 1: {
                this.raiseSlaveConnected(slaveID);
                break;
            }
            case 2: {
                this.deleteReceiverBuffer(slaveID);
                this.raiseSlaveDisconnected(slaveID, false);
                break;
            }
            case 4: {
                this.deleteReceiverBuffer(slaveID);
                this.raiseSlaveDisconnected(slaveID, true);
                break;
            }
            case 3: {
                this.addReceiverBuffer(slaveID, packet, 6, length - 6);
            }
        }
    }

    private void raiseSlaveConnected(final int slaveID) {
        final SlaveConnection connection = this.mSlaveConnection;
        if (connection != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SlaveConnection slaveConnection = connection;
                    synchronized (slaveConnection) {
                        connection.onSlaveConnected(slaveID);
                    }
                }
            }).start();
        }
    }

    private void raiseSlaveDisconnected(final int slaveID, final boolean overCurrent) {
        final SlaveConnection connection = this.mSlaveConnection;
        if (connection != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SlaveConnection slaveConnection = connection;
                    synchronized (slaveConnection) {
                        connection.onSlaveDisconnected(slaveID, overCurrent);
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createReceiverBuffer(int slaveID) {
        Map<Integer, LinkedList<Byte>> map = this.mReceiverBuffers;
        synchronized (map) {
            if (this.mReceiverBuffers.containsKey(slaveID)) {
                return false;
            }
            this.mReceiverBuffers.put(slaveID, new LinkedList());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteReceiverBuffer(int slaveID) {
        Map<Integer, LinkedList<Byte>> map = this.mReceiverBuffers;
        synchronized (map) {
            this.mReceiverBuffers.remove(slaveID);
            this.mReceiverBuffers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReceiverBuffer(int slaveID, byte[] data, int offset, int length) {
        Map<Integer, LinkedList<Byte>> map = this.mReceiverBuffers;
        synchronized (map) {
            LinkedList<Byte> list = this.mReceiverBuffers.get(slaveID);
            if (list != null) {
                for (int i = 0; i < length; ++i) {
                    if (list.size() == 8192) {
                        list.removeFirst();
                    }
                    list.add(data[offset + i]);
                }
            }
            this.mReceiverBuffers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] transmit(int command, int slaveID, byte[] data, int offset, int length) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(62);
        buffer.write(command);
        buffer.write(0);
        buffer.write(length >> 8);
        buffer.write(length);
        buffer.write(slaveID);
        buffer.write(data, offset, length);
        byte[] byArray = this.mResponse;
        synchronized (this.mResponse) {
            this.mResponse[0] = 0;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.write(buffer.toByteArray());
            if (this.mResponse[0] != 60) {
                try {
                    byArray = this.mResponse;
                    synchronized (this.mResponse) {
                        this.mResponse.wait(5000L);
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            {
                byArray = this.mResponse;
                synchronized (this.mResponse) {
                    if (this.mResponse[0] != 60) {
                        throw new IOException("Timeout");
                    }
                    this.mResponse[0] = 0;
                    if (this.mResponse[2] != 0) {
                        throw new HubException(this.mResponse[2] & 0xFF);
                    }
                    int dataLen = ((this.mResponse[3] & 0xFF) << 8) + (this.mResponse[4] & 0xFF);
                    buffer.reset();
                    buffer.write(this.mResponse, 6, dataLen);
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return buffer.toByteArray();
                }
            }
        }
    }

    private synchronized byte[] transmit(int command, int slaveID, byte[] data) throws IOException {
        return this.transmit(command, slaveID, data, 0, data.length);
    }

    private synchronized byte[] transmit(int ins, int slaveID) throws IOException {
        return this.transmit(ins, slaveID, new byte[0]);
    }

    public void setSlaveConnectionListener(SlaveConnection connection) {
        this.mSlaveConnection = connection;
    }

    public int getSlaveType(int slaveID) throws IOException {
        return this.transmit(2, slaveID)[0] & 0xFF;
    }

    public int getSlaveState(int slaveID) throws IOException {
        return this.transmit(3, slaveID)[0] & 0xFF;
    }

    public void writeNVRAM(int slaveID, byte[] data) throws IOException {
        if (data.length > 128) {
            throw new IllegalArgumentException("The data length is invalid");
        }
        this.transmit(4, slaveID, data);
    }

    public byte[] readNVRAM(int slaveID) throws IOException {
        return this.transmit(5, slaveID);
    }

    public void setBaudRate(int slaveID, int baudRate) throws IOException {
        byte[] data = new byte[]{(byte)(baudRate >> 24), (byte)(baudRate >> 16), (byte)(baudRate >> 8), (byte)baudRate};
        this.transmit(32, slaveID, data);
    }

    public byte[] getUsbDeviceDescriptor(int slaveID) throws IOException {
        return this.transmit(16, slaveID);
    }

    public String getUsbStringDescriptor(int slaveID) throws IOException {
        return new String(this.transmit(17, slaveID));
    }

    public void setAppleChargeCurrent(int current) throws IOException {
        byte[] data = new byte[]{(byte)(current >> 8), (byte)current};
        this.transmit(18, 0, data);
    }

    public OutputStream getDataOutputStream(final int slaveID) throws IOException {
        return new BufferedOutputStream(new OutputStream(){
            private boolean mClosed = false;

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.mClosed) {
                    throw new IOException("The stream is closed");
                }
                Hub.this.transmit(1, slaveID, b, off, len);
            }

            @Override
            public void close() throws IOException {
                this.mClosed = true;
            }
        }, 2042);
    }

    public InputStream getDataInputStream(final int slaveID) throws IOException {
        if (!this.createReceiverBuffer(slaveID)) {
            throw new IOException("Busy");
        }
        return new InputStream(){
            private boolean mClosed = false;

            @Override
            public int available() throws IOException {
                if (this.mClosed) {
                    throw new IOException("The stream is closed");
                }
                if (Hub.this.mLastError != null) {
                    throw Hub.this.mLastError;
                }
                Map map = Hub.this.mReceiverBuffers;
                synchronized (map) {
                    LinkedList list = (LinkedList)Hub.this.mReceiverBuffers.get(slaveID);
                    if (list != null) {
                        return list.size();
                    }
                    throw new IOException("Connection is closed");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Map map;
                while (this.available() == 0) {
                    try {
                        map = Hub.this.mReceiverBuffers;
                        synchronized (map) {
                            Hub.this.mReceiverBuffers.wait(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                map = Hub.this.mReceiverBuffers;
                synchronized (map) {
                    LinkedList list = (LinkedList)Hub.this.mReceiverBuffers.get(slaveID);
                    if (list != null) {
                        int count = Math.min(list.size(), len);
                        for (int i = 0; i < count; ++i) {
                            b[off + i] = (Byte)list.removeFirst();
                        }
                        return count;
                    }
                    throw new IOException("Connection is closed");
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read() throws IOException {
                byte[] buffer = new byte[1];
                while (this.read(buffer) != 1) {
                }
                return buffer[0] & 0xFF;
            }

            @Override
            public void close() throws IOException {
                Hub.this.deleteReceiverBuffer(slaveID);
                this.mClosed = true;
            }
        };
    }

    private class ReceiverThread
    extends Thread {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                byte[] buffer = new byte[2048];
                int bufferPos = 0;
                try {
                    block5: do {
                        bufferPos += Hub.this.read(buffer, bufferPos, buffer.length - bufferPos);
                        while (bufferPos >= 6) {
                            int dataLen = ((buffer[3] & 0xFF) << 8) + (buffer[4] & 0xFF);
                            if (dataLen > 2042) {
                                throw new IOException("Invalid data size");
                            }
                            int packetLen = 6 + dataLen;
                            if (bufferPos < packetLen) continue block5;
                            int command = buffer[1] & 0xFF;
                            int eventID = buffer[2] & 0xFF;
                            if (command == 0 && eventID > 0) {
                                Hub.this.processEvent(eventID, buffer, packetLen);
                            } else {
                                byte[] byArray = Hub.this.mResponse;
                                synchronized (byArray) {
                                    System.arraycopy(buffer, 0, Hub.this.mResponse, 0, packetLen);
                                    Hub.this.mResponse.notify();
                                }
                            }
                            System.arraycopy(buffer, packetLen, buffer, 0, bufferPos - packetLen);
                            bufferPos -= packetLen;
                            if (Hub.this.mLastError == null) continue;
                        }
                    } while (Hub.this.mLastError == null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (Hub.this.mLastError != null) break block10;
                    Hub.this.mLastError = e;
                }
            }
        }
    }
}

