/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DUKPT {
    private static final boolean DEBUG = true;
    private static final char[] HEX_NIBS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static void debug(String s) {
        System.out.println(s);
    }

    private static void debug(String s, byte[] buffer) {
        DUKPT.debug(s, buffer, 0, buffer.length);
    }

    private static void debug(String s, byte[] buffer, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        for (int i = 0; i < length; ++i) {
            sb.append(HEX_NIBS[(buffer[offset + i] & 0xFF) >> 4]);
            sb.append(HEX_NIBS[buffer[offset + i] & 0xF]);
        }
        System.out.println(sb.toString());
    }

    private static int getKeyLength(KeyType keyType) {
        if (keyType == KeyType.DoubleTDEA) {
            return 128;
        }
        if (keyType == KeyType.TripleTDEA) {
            return 192;
        }
        if (keyType == KeyType.AES128) {
            return 128;
        }
        if (keyType == KeyType.AES192) {
            return 192;
        }
        if (keyType == KeyType.AES256) {
            return 256;
        }
        throw new IllegalArgumentException("Invalid key type");
    }

    private static void memxor(byte[] output, int outPos, byte[] a, int aPos, byte[] b, int bPos, int len) {
        for (int i = 0; i < len; ++i) {
            output[outPos + i] = (byte)(a[aPos + i] & 0xFF ^ b[bPos + i] & 0xFF);
        }
    }

    private static void memcpy(byte[] dst, int dstOffset, byte[] src, int srcOffset, int length) {
        System.arraycopy(src, srcOffset, dst, dstOffset, length);
    }

    private static void memset(byte[] dst, int dstOffset, int value, int length) {
        for (int i = 0; i < length; ++i) {
            dst[dstOffset + i] = (byte)value;
        }
    }

    private static void encryptDES(byte[] output, int outputOffset, byte[] input, int inputOffset, int length, byte[] desKey, int desKeyOffset) {
        try {
            SecretKeySpec key = new SecretKeySpec(desKey, desKeyOffset, 8, "DES");
            IvParameterSpec iv = new IvParameterSpec(new byte[8]);
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            cipher.init(1, (Key)key, iv);
            cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void encryptAESCBC(byte[] output, int outputOffset, byte[] input, int inputOffset, int length, byte[] aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey, 0, aesKey.length, "AES");
            IvParameterSpec iv = new IvParameterSpec(new byte[16]);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)key, iv);
            cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void encryptAES(byte[] output, int outputOffset, byte[] input, int inputOffset, int length, byte[] aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey, 0, aesKey.length, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, key);
            cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void encrypt3DES(byte[] output, int outputOffset, byte[] input, int inputOffset, int length, byte[] desKey) {
        byte[] keyValue = new byte[24];
        System.arraycopy(desKey, 0, keyValue, 0, 16);
        System.arraycopy(desKey, 0, keyValue, 16, 8);
        try {
            SecretKeySpec key = new SecretKeySpec(keyValue, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/None/NoPadding");
            cipher.init(1, key);
            cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] deriveKey(byte[] ksn, byte[] ipek) {
        byte[] r8 = new byte[8];
        byte[] r8a = new byte[8];
        byte[] r8b = new byte[8];
        byte[] key = new byte[16];
        DUKPT.memcpy(key, 0, ipek, 0, 16);
        DUKPT.memcpy(r8, 0, ksn, 2, 6);
        r8[5] = (byte)(r8[5] & 0xFFFFFFE0);
        int ec = (ksn[ksn.length - 3] & 0x1F) << 16 | (ksn[ksn.length - 2] & 0xFF) << 8 | ksn[ksn.length - 1] & 0xFF;
        byte[] pattern = new byte[]{-64, -64, -64, -64, 0, 0, 0, 0, -64, -64, -64, -64, 0, 0, 0, 0};
        for (int sr = 0x100000; sr != 0; sr >>= 1) {
            if ((sr & ec) == 0) continue;
            r8[5] = (byte)(r8[5] | sr >> 16);
            r8[6] = (byte)(r8[6] | sr >> 8);
            r8[7] = (byte)(r8[7] | sr);
            DUKPT.memxor(r8a, 0, key, 8, r8, 0, 8);
            DUKPT.encryptDES(r8a, 0, r8a, 0, 8, key, 0);
            DUKPT.memxor(r8a, 0, r8a, 0, key, 8, 8);
            DUKPT.memxor(key, 0, key, 0, pattern, 0, 16);
            DUKPT.memxor(r8b, 0, key, 8, r8, 0, 8);
            DUKPT.encryptDES(r8b, 0, r8b, 0, 8, key, 0);
            DUKPT.memxor(r8b, 0, r8b, 0, key, 8, 8);
            DUKPT.memcpy(key, 8, r8a, 0, 8);
            DUKPT.memcpy(key, 0, r8b, 0, 8);
        }
        DUKPT.memset(r8, 0, 0, r8.length);
        DUKPT.memset(r8a, 0, 0, r8a.length);
        DUKPT.memset(r8b, 0, 0, r8b.length);
        return key;
    }

    public static byte[] deriveDataKey(byte[] ksn, byte[] ipek) {
        byte[] dataKey = DUKPT.deriveKey(ksn, ipek);
        dataKey[5] = (byte)(dataKey[5] ^ 0xFF);
        dataKey[13] = (byte)(dataKey[13] ^ 0xFF);
        DUKPT.encrypt3DES(dataKey, 0, dataKey, 0, dataKey.length, dataKey);
        return dataKey;
    }

    public static byte[] derivePinKey(byte[] ksn, byte[] ipek) {
        byte[] dataKey = DUKPT.deriveKey(ksn, ipek);
        dataKey[7] = (byte)(dataKey[7] ^ 0xFF);
        dataKey[15] = (byte)(dataKey[15] ^ 0xFF);
        return dataKey;
    }

    public static byte[] deriveMacKey(byte[] ksn, byte[] ipek) {
        byte[] dataKey = DUKPT.deriveKey(ksn, ipek);
        dataKey[6] = (byte)(dataKey[6] ^ 0xFF);
        dataKey[14] = (byte)(dataKey[14] ^ 0xFF);
        return dataKey;
    }

    public static byte[] deriveIpek(byte[] bdk, byte[] ksn) {
        byte[] key = new byte[16];
        DUKPT.memcpy(key, 0, ksn, 0, 8);
        DUKPT.memcpy(key, 8, ksn, 0, 8);
        key[7] = (byte)(key[7] & 0xE0);
        key[15] = (byte)(key[15] & 0xE0);
        DUKPT.encrypt3DES(key, 0, key, 0, 8, bdk);
        byte[] tmp = new byte[16];
        DUKPT.memcpy(tmp, 0, bdk, 0, 16);
        tmp[0] = (byte)(tmp[0] & 0xC0);
        tmp[1] = (byte)(tmp[1] & 0xC0);
        tmp[2] = (byte)(tmp[2] & 0xC0);
        tmp[3] = (byte)(tmp[3] & 0xC0);
        tmp[8] = (byte)(tmp[8] & 0xC0);
        tmp[9] = (byte)(tmp[9] & 0xC0);
        tmp[10] = (byte)(tmp[10] & 0xC0);
        tmp[11] = (byte)(tmp[11] & 0xC0);
        DUKPT.encrypt3DES(key, 8, key, 8, 8, tmp);
        return key;
    }

    public static byte[] deriveKey(byte[] derivationKey, KeyType keyType, byte[] derivationData) {
        int L = DUKPT.getKeyLength(keyType);
        int n = (L + 127) / 128;
        byte[] result = new byte[n * 128];
        for (int i = 0; i < n; ++i) {
            derivationData[1] = (byte)(i + 1);
            DUKPT.encryptAES(result, i * 16, derivationData, 0, derivationData.length, derivationKey);
        }
        byte[] derivedKey = new byte[L / 8];
        DUKPT.memcpy(derivedKey, 0, result, 0, derivedKey.length);
        return derivedKey;
    }

    public static byte[] createDerivationData(DerivationPurpose derivationPurpose, KeyUsage keyUsage, KeyType derivedKeyType, byte[] initialKeyID, int counter) {
        byte[] derivationData = new byte[16];
        derivationData[0] = 1;
        derivationData[1] = 1;
        if (keyUsage == KeyUsage.KeyEncryptionKey) {
            derivationData[2] = 0;
            derivationData[3] = 2;
        } else if (keyUsage == KeyUsage.PINEncryption) {
            derivationData[2] = 16;
            derivationData[3] = 0;
        } else if (keyUsage == KeyUsage.MessageAuthenticationGeneration) {
            derivationData[2] = 32;
            derivationData[3] = 0;
        } else if (keyUsage == KeyUsage.MessageAuthenticationVerification) {
            derivationData[2] = 32;
            derivationData[3] = 1;
        } else if (keyUsage == KeyUsage.MessageAuthenticationBothWays) {
            derivationData[2] = 32;
            derivationData[3] = 2;
        } else if (keyUsage == KeyUsage.DataEncryptionEncrypt) {
            derivationData[2] = 48;
            derivationData[3] = 0;
        } else if (keyUsage == KeyUsage.DataEncryptionDecrypt) {
            derivationData[2] = 48;
            derivationData[3] = 1;
        } else if (keyUsage == KeyUsage.DataEncryptionBothWays) {
            derivationData[2] = 48;
            derivationData[3] = 2;
        } else if (keyUsage == KeyUsage.KeyDerivation) {
            derivationData[2] = -128;
            derivationData[3] = 0;
        } else if (keyUsage == KeyUsage.KeyDerivationInitialKey) {
            derivationData[2] = -128;
            derivationData[3] = 1;
        }
        if (derivedKeyType == KeyType.DoubleTDEA) {
            derivationData[4] = 0;
            derivationData[5] = 0;
        } else if (derivedKeyType == KeyType.TripleTDEA) {
            derivationData[4] = 0;
            derivationData[5] = 1;
        } else if (derivedKeyType == KeyType.AES128) {
            derivationData[4] = 0;
            derivationData[5] = 2;
        } else if (derivedKeyType == KeyType.AES192) {
            derivationData[4] = 0;
            derivationData[5] = 3;
        } else if (derivedKeyType == KeyType.AES256) {
            derivationData[4] = 0;
            derivationData[5] = 4;
        }
        if (derivedKeyType == KeyType.DoubleTDEA) {
            derivationData[6] = 0;
            derivationData[7] = -128;
        } else if (derivedKeyType == KeyType.TripleTDEA) {
            derivationData[6] = 0;
            derivationData[7] = -64;
        } else if (derivedKeyType == KeyType.AES128) {
            derivationData[6] = 0;
            derivationData[7] = -128;
        } else if (derivedKeyType == KeyType.AES192) {
            derivationData[6] = 0;
            derivationData[7] = -64;
        } else if (derivedKeyType == KeyType.AES256) {
            derivationData[6] = 1;
            derivationData[7] = 0;
        }
        if (derivationPurpose == DerivationPurpose.InitialKey) {
            DUKPT.memcpy(derivationData, 8, initialKeyID, 0, 8);
        } else if (derivationPurpose == DerivationPurpose.DerivationOrWorkingKey) {
            DUKPT.memcpy(derivationData, 8, initialKeyID, 4, 4);
            derivationData[12] = (byte)(counter >> 24);
            derivationData[13] = (byte)(counter >> 16);
            derivationData[14] = (byte)(counter >> 8);
            derivationData[15] = (byte)counter;
        }
        return derivationData;
    }

    public static byte[] deriveInitialKey(byte[] BDK, KeyType keyType, byte[] initialKeyID) {
        byte[] derivationData = DUKPT.createDerivationData(DerivationPurpose.InitialKey, KeyUsage.KeyDerivationInitialKey, keyType, initialKeyID, 0);
        return DUKPT.deriveKey(BDK, keyType, derivationData);
    }

    public static byte[] deriveWorkingKey(byte[] BDK, KeyType deriveKeyType, KeyUsage workingKeyUsage, KeyType workingKeyType, byte[] initialKeyID, int transactionCounter) {
        byte[] derivationData;
        byte[] initialKey = DUKPT.deriveInitialKey(BDK, deriveKeyType, initialKeyID);
        int workingCounter = 0;
        byte[] derivationKey = initialKey;
        for (int mask = Integer.MIN_VALUE; mask != 0; mask >>>= 1) {
            if ((mask & transactionCounter) == 0) continue;
            derivationData = DUKPT.createDerivationData(DerivationPurpose.DerivationOrWorkingKey, KeyUsage.KeyDerivation, deriveKeyType, initialKeyID, workingCounter |= mask);
            derivationKey = DUKPT.deriveKey(derivationKey, deriveKeyType, derivationData);
        }
        DUKPT.debug("derivationKey: ", derivationKey);
        derivationData = DUKPT.createDerivationData(DerivationPurpose.DerivationOrWorkingKey, workingKeyUsage, workingKeyType, initialKeyID, transactionCounter);
        DUKPT.debug("derivationData: ", derivationData);
        return DUKPT.deriveKey(derivationKey, workingKeyType, derivationData);
    }

    public static byte[] deriveWorkingKey(byte[] BDK, KeyType deriveKeyType, KeyUsage workingKeyUsage, KeyType workingKeyType, byte[] ksn) {
        int transactionCounter;
        byte[] initialKeyID = new byte[8];
        if (ksn.length == 10) {
            initialKeyID[7] = (byte)((ksn[7] & 0xFF) >> 5 | (ksn[6] & 0xFF) << 3);
            initialKeyID[6] = (byte)((ksn[6] & 0xFF) >> 5 | (ksn[5] & 0xFF) << 3);
            initialKeyID[5] = (byte)((ksn[5] & 0xFF) >> 5 | (ksn[4] & 0xFF) << 3);
            initialKeyID[4] = (byte)((ksn[4] & 0xFF) >> 5 | (ksn[3] & 0xFF) << 3);
            initialKeyID[3] = (byte)((ksn[3] & 0xFF) >> 5 | (ksn[2] & 0xFF) << 3);
            initialKeyID[2] = (byte)((ksn[2] & 0xFF) >> 5 | (ksn[1] & 0xFF) << 3);
            initialKeyID[1] = (byte)((ksn[1] & 0xFF) >> 5 | (ksn[0] & 0xFF) << 3);
            initialKeyID[1] = (byte)((ksn[0] & 0xFF) >> 5);
            transactionCounter = (ksn[9] & 0xFF) + ((ksn[8] & 0xFF) << 8) + ((ksn[7] & 0xFF) << 16) + ((ksn[6] & 0x1F) << 24);
        } else if (ksn.length == 12) {
            DUKPT.memcpy(initialKeyID, 0, ksn, 0, 8);
            transactionCounter = (ksn[11] & 0xFF) + ((ksn[10] & 0xFF) << 8) + ((ksn[9] & 0xFF) << 16) + (ksn[8] << 24);
        } else {
            throw new IllegalArgumentException("Invalid KSN length");
        }
        return DUKPT.deriveWorkingKey(BDK, deriveKeyType, workingKeyUsage, workingKeyType, initialKeyID, transactionCounter);
    }

    public static enum KeyType {
        DoubleTDEA,
        TripleTDEA,
        AES128,
        AES192,
        AES256;

    }

    public static enum KeyUsage {
        KeyEncryptionKey,
        PINEncryption,
        MessageAuthenticationGeneration,
        MessageAuthenticationVerification,
        MessageAuthenticationBothWays,
        DataEncryptionEncrypt,
        DataEncryptionDecrypt,
        DataEncryptionBothWays,
        KeyDerivation,
        KeyDerivationInitialKey;

    }

    public static enum DerivationPurpose {
        InitialKey,
        DerivationOrWorkingKey;

    }
}

