/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.emsr;

import com.datecs.emsr.EMSRException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class EMSR {
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final int STATUS_EMSR_OFFSET = 0;
    public static final int STATUS_EMSR_INVALID_COMMAND = 1;
    public static final int STATUS_EMSR_NO_PERMISSION = 2;
    public static final int STATUS_EMSR_CARD_ERROR = 3;
    public static final int STATUS_EMSR_SYNTAX_ERROR = 4;
    public static final int STATUS_EMSR_NO_RESPONSE = 5;
    public static final int STATUS_EMSR_NO_DATA = 6;
    public static final int STATUS_EMSR_BAD_ARRAY = 16;
    public static final int STATUS_EMSR_NO_BARCODE_READ = 17;
    public static final int STATUS_EMSR_BARCODE_MISHMASH = 18;
    public static final int STATUS_EMSR_BARCODE_NO_READER = 19;
    public static final int STATUS_EMSR_INVALID_LENGTH = 20;
    public static final int STATUS_EMSR_TAMPERED = 21;
    public static final int STATUS_EMSR_INVALID_SIGNATURE = 22;
    public static final int STATUS_EMSR_HARD = 23;
    public static final int KEY_AES_AUTHENTICATION = 0;
    public static final int KEY_AES_DATA_ENCRYPTION = 1;
    public static final int KEY_AES_KEK = 2;
    public static final int KEY_TMK_AES = 16;
    public static final int KEY_DUKPT_MASTER = 32;
    public static final int KEY_NO_KEY = 255;
    public static final int ENCRYPTION_TYPE_OLD_RSA = 0;
    public static final int ENCRYPTION_TYPE_RSA = 5;
    public static final int ENCRYPTION_TYPE_AES256 = 2;
    public static final int ENCRYPTION_TYPE_IDTECH = 3;
    public static final int MODE_READ_TRACK1 = 1;
    public static final int MODE_READ_TRACK2 = 2;
    public static final int MODE_READ_TRACK3 = 4;
    public static final int MODE_READ_JIS = 32;
    public static final int MODE_READ_RAW = 64;
    public static final int MODE_READ_PREFIX = 128;
    private InputStream mBaseInputStream;
    private IOException mBaseInputStreamException;
    private OutputStream mBaseOutputStream;
    private List<Byte> mDataQueue;
    private static boolean sDebug = false;

    public EMSR(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = in;
        this.mBaseOutputStream = out;
        this.mDataQueue = Collections.synchronizedList(new LinkedList());
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                block6: while (true) {
                    try {
                        while (EMSR.this.mBaseInputStreamException == null) {
                            int byteRead = EMSR.this.read(buffer, 0, buffer.length);
                            for (int i = 0; i < byteRead; ++i) {
                                EMSR.this.mDataQueue.add(buffer[i]);
                            }
                            try {
                                Thread.sleep(10L);
                                continue block6;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        if (EMSR.this.mBaseInputStreamException != null) break;
                        EMSR.this.mBaseInputStreamException = e;
                        break;
                    }
                }
            }
        });
        t.start();
    }

    public synchronized void close() {
        this.mBaseInputStreamException = new IOException("The object is closed");
        try {
            if (this.mBaseInputStream != null) {
                this.mBaseInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mBaseOutputStream != null) {
                this.mBaseOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private void debug(String text) {
        if (sDebug) {
            System.out.println(text);
        }
    }

    private void debug(String text, byte[] buffer, int offset, int count) {
        if (sDebug) {
            this.debug(text + EMSR.byteArrayToHexString(buffer, offset, count) + "(" + count + ")");
        }
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    private static final String byteArrayToHexString(byte[] data) {
        return EMSR.byteArrayToHexString(data, 0, data.length);
    }

    private synchronized void write(byte[] b, int offset, int length) throws IOException {
        this.mBaseOutputStream.write(b, offset, length);
        this.mBaseOutputStream.flush();
        this.debug("<EMSR> >> ", b, offset, length);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.mBaseInputStream.read(buffer, offset, length);
        if (bytesRead == -1) {
            throw new IOException("The end of the stream is reached");
        }
        if (bytesRead > 0) {
            this.debug("<EMSR> << ", buffer, offset, bytesRead);
        }
        return bytesRead;
    }

    private int readByte(int timeout) throws IOException {
        long endTime = System.currentTimeMillis() + (long)timeout;
        if (this.mDataQueue == null) {
            throw new IOException("The input stream is null");
        }
        while (this.mDataQueue.isEmpty()) {
            if (this.mBaseInputStreamException != null) {
                throw this.mBaseInputStreamException;
            }
            if (endTime < System.currentTimeMillis()) {
                throw new IOException("Timeout");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.mDataQueue.remove(0) & 0xFF;
    }

    public byte[] transmitEMSR(byte[] input) throws IOException {
        int status = 0;
        int length = 0;
        this.write(input, 0, input.length);
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        status = this.readByte(1000);
        o.write(status);
        status = this.readByte(1000);
        o.write(status);
        status = this.readByte(1000);
        o.write(status);
        length = status;
        status = this.readByte(1000);
        o.write(status);
        length = (length << 8) + status;
        for (int i = 0; i < length; ++i) {
            status = this.readByte(1000);
            o.write(status);
        }
        return o.toByteArray();
    }

    private byte[] transmitEMSR(int cmd, byte[] data) throws EMSRException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(cmd);
        out.write(0);
        out.write(data.length >> 8);
        out.write(data.length);
        out.write(data);
        byte[] result = this.transmitEMSR(out.toByteArray());
        int status = result[1] & 0xFF;
        if (status != 0) {
            throw new EMSRException(0 + status);
        }
        int length = ((result[2] & 0xFF) << 8) + (result[3] & 0xFF);
        if (length != result.length - 4) {
            throw new IOException("Invalid packet content");
        }
        byte[] buffer = new byte[length];
        System.arraycopy(result, 4, buffer, 0, buffer.length);
        return buffer;
    }

    private byte[] transmitEMSR(int cmd, int subCmd, byte[] data) throws EMSRException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(subCmd);
        out.write(data);
        return this.transmitEMSR(cmd, out.toByteArray());
    }

    private byte[] transmitEMSR(int cmd, int subCmd) throws EMSRException, IOException {
        return this.transmitEMSR(cmd, subCmd, new byte[0]);
    }

    public void enable() throws EMSRException, IOException {
        this.transmitEMSR(81, 1, new byte[]{1});
    }

    public void disable() throws EMSRException, IOException {
        this.transmitEMSR(81, 1, new byte[]{0});
    }

    public synchronized EMSRInformation getInformation() throws EMSRException, IOException {
        byte[] tmp = null;
        tmp = this.transmitEMSR(1, 1);
        String name = new String(tmp, 0, 16).trim();
        String version = "" + (tmp[18] & 0xFF) + "." + (tmp[19] & 0xFF);
        tmp = this.transmitEMSR(2, 12);
        String serial = EMSR.byteArrayToHexString(tmp);
        EMSRInformation info = new EMSRInformation(name, version, serial);
        return info;
    }

    public synchronized EMSRKeyInformation getKeyInformation(int keyId) throws EMSRException, IOException {
        byte[] result = this.transmitEMSR(81, 40, new byte[]{(byte)keyId});
        boolean tampered = result[0] != 0;
        int version = (result[2] & 0xFF000000) + (result[3] & 0xFF0000) + (result[4] & 0xFF00) + (result[5] & 0xFF);
        EMSRKeyInformation keyInfo = new EMSRKeyInformation(tampered, version);
        return keyInfo;
    }

    public synchronized void loadKey(byte[] keyData) throws EMSRException, IOException {
        this.transmitEMSR(81, keyData);
    }

    public synchronized void setEncryptionType(int type) throws EMSRException, IOException {
        this.transmitEMSR(81, 49, new byte[]{(byte)type});
    }

    public synchronized int test(int ms) throws EMSRException, IOException {
        byte[] tmp = null;
        long endTime = System.currentTimeMillis() + (long)ms;
        this.transmitEMSR(81, 1, new byte[]{1});
        while (endTime >= System.currentTimeMillis()) {
            block5: {
                try {
                    this.transmitEMSR(81, 2);
                }
                catch (EMSRException e) {
                    if (e.getStatusCode() != 6) {
                        throw e;
                    }
                    break block5;
                }
                tmp = this.transmitEMSR(81, 4);
            }
            if (tmp == null) continue;
        }
        this.transmitEMSR(81, 1, new byte[]{0});
        if (tmp == null || tmp.length == 0) {
            throw new EMSRException(6);
        }
        return tmp[0] % 255;
    }

    public synchronized byte[] readCardData(int mode) throws EMSRException, IOException {
        byte[] buffer = this.transmitEMSR(81, 34, new byte[]{(byte)mode});
        return buffer;
    }

    public static class EMSRKeyInformation {
        public final boolean tampered;
        public final int version;

        EMSRKeyInformation(boolean tampered, int version) {
            this.tampered = tampered;
            this.version = version;
        }

        public String toString() {
            return "EMSRKeyInformation[tampered=" + this.tampered + ",version=" + this.version + "]";
        }
    }

    public static class EMSRInformation {
        public final String name;
        public final String version;
        public final String serial;

        EMSRInformation(String name, String version, String serial) {
            this.name = name;
            this.version = version;
            this.serial = serial;
        }

        public String toString() {
            return "EMSRInformation[name=" + this.name + ",version=" + this.version + ",serial=" + this.serial + "]";
        }
    }
}

