/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.linea;

import com.datecs.barcode.Barcode;
import com.datecs.barcode.Intermec;
import com.datecs.barcode.Newland;
import com.datecs.linea.LineaProException;
import com.datecs.linea.LineaProInformation;
import com.datecs.rfid.RC663;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;

public class LineaPro {
    private static boolean sDebug = false;
    private static final int PACKET_HEADER_SIZE = 6;
    private static final int PACKET_DATA_SIZE = 2048;
    private static final int MAX_PACKET_SIZE = 2054;
    private static final int PACKET_TIMEOUT = 4000;
    private static final int CMD_SYSTEM = 1;
    private static final int CMD_GET_BATTERY_VOLTAGE = 13;
    private static final int CMD_BEEP = 15;
    private static final int CMD_SETTINGS = 58;
    private static final int CMD_BAR_SCAN_START = 3;
    private static final int CMD_BAR_SCAN_STOP = 4;
    private static final int CMD_BAR_SET_TIMEOUT = 8;
    private static final int CMD_BAR_SET_MODE = 9;
    private static final int CMD_BAR_ENABLE_SCAN_BUTTON = 10;
    private static final int CMD_BAR_SET_BEEP = 11;
    private static final int CMD_ENABLE_BATTERY_CHARGE = 16;
    private static final int CMD_BAR_DIRECT_READ = 22;
    private static final int CMD_BAR_DIRECT_WRITE = 23;
    private static final int CMD_BAR_HOLD_ON = 24;
    private static final int CMD_RFID = 32;
    private static final int CMD_BAR_CUSTOM_INIT = 35;
    private static final int CMD_BAR_START_FW_DWN = 36;
    private static final int CMD_BAR_DEFAULT = 51;
    private static final int CMD_LED = 52;
    private static final int CMD_VIBRATOR = 53;
    private static final int CMD_BATTERY_INFO = 64;
    private static final int CMD_FW_UPDATE_START = 240;
    private static final int CMD_FW_UPDATE_ERASE = 241;
    private static final int CMD_FW_UPDATE_WRITE = 242;
    private static final int CMD_FW_UPDATE_STOP = 243;
    private static final int EVN_BUTTON_STATE = 6;
    private static final int EVN_BAR_DATA = 5;
    private static final int EVN_RFID = 31;
    public static final int BARCODE_MODE_SINGLE_SCAN = 0;
    public static final int BARCODE_MODE_MULTI_SCAN = 1;
    public static final int BARCODE_MODE_MOTION_DETECT = 2;
    public static final int BARCODE_MODE_SINGLE_SCAN_ON_RELEASE = 3;
    public static final int BARCODE_MODE_MULTI_SCAN_NO_DUPLICATE = 4;
    public static final int RFID_MODULE_MURATA = 0;
    public static final int RFID_MODULE_CLRC663 = 1;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private ReceiverThread mReceiverThread;
    private List<byte[]> mPacketBuffer = null;
    private int mPacketSequence = 0;
    private IOException mLastError;
    private ConnectionListener mConnListener;
    private BarcodeListener mBarcodeListener;
    private ButtonListener mButtonListener;
    private LinkedList<Byte> mRfidInputBuffer = new LinkedList();

    public LineaPro(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            throw new NullPointerException("The argument 'inputStream' is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("The argument 'outputStream' is null");
        }
        this.mInputStream = inputStream;
        this.mOutputStream = outputStream;
        this.mPacketBuffer = new LinkedList<byte[]>();
        this.mPacketSequence = 0;
        this.mReceiverThread = new ReceiverThread();
        this.mReceiverThread.start();
    }

    public synchronized void close() throws IOException {
        this.mLastError = new IOException("The object is closed");
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    private static void debug(String s) {
        if (sDebug) {
            System.out.println(s);
        }
    }

    private static void debug(Exception e) {
        if (sDebug) {
            e.printStackTrace();
        }
    }

    private static void debug(String s, byte[] buffer, int offset, int length) {
        if (sDebug) {
            s = s + LineaPro.byteArrayToHexString(buffer, offset, length) + " (" + length + ")";
            System.out.println(s);
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.mConnListener = listener;
    }

    private void raiseDisconnect() {
        final ConnectionListener l = this.mConnListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onDisconnect();
                }
            }).start();
        }
    }

    public void setBarcodeListener(BarcodeListener listener) {
        this.mBarcodeListener = listener;
    }

    private void raiseBarcodeRead(final Barcode barcode) {
        final BarcodeListener l = this.mBarcodeListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onReadBarcode(barcode);
                }
            }).start();
        }
    }

    public void setButtonListener(ButtonListener listener) {
        this.mButtonListener = listener;
    }

    private void raiseButtonStateChanged(final int index, final boolean state) {
        final ButtonListener l = this.mButtonListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onButtonStateChanged(index, state);
                }
            }).start();
        }
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int status = this.mInputStream.read(buffer, offset, length);
        if (status == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            if (status < 0) {
                throw new IOException("The end of stream is reached");
            }
            LineaPro.debug("<< ", buffer, offset, status);
        }
        return status;
    }

    private void write(byte[] buffer, int offset, int length) throws IOException {
        this.mOutputStream.write(buffer, offset, length);
        this.mOutputStream.flush();
        LineaPro.debug(">> ", buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(byte[] buffer, int length) {
        int cmd = buffer[3] & 0xFF;
        int pos = 8;
        switch (cmd) {
            case 6: {
                int index = (buffer[pos] & 0xFF) >> 1;
                boolean state = (buffer[pos] & 1) != 0;
                this.raiseButtonStateChanged(index, state);
                break;
            }
            case 5: {
                byte[] data = new byte[length - pos];
                System.arraycopy(buffer, pos, data, 0, length - pos);
                Barcode barcode = Barcode.parse(data);
                this.raiseBarcodeRead(barcode);
                break;
            }
            case 31: {
                LinkedList<Byte> data = this.mRfidInputBuffer;
                synchronized (data) {
                    for (int i = pos; i < length; ++i) {
                        this.mRfidInputBuffer.add(buffer[i]);
                    }
                    break;
                }
            }
            default: {
                byte[] data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                List<byte[]> list = this.mPacketBuffer;
                synchronized (list) {
                    this.mPacketBuffer.add(data);
                    break;
                }
            }
        }
    }

    private void writePacket(int command, byte[] data) throws IOException {
        if (6 + data.length > 2054) {
            throw new IllegalArgumentException("Invalid data length");
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream(6 + data.length);
        o.write(0);
        o.write(data.length >> 8);
        o.write(data.length);
        o.write(command);
        o.write(3);
        o.write(this.mPacketSequence++);
        o.write(data, 0, data.length);
        byte[] tmp = o.toByteArray();
        this.write(tmp, 0, tmp.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readPacket(int timeout) throws IOException {
        long end = System.currentTimeMillis() + (long)timeout;
        byte[] result = null;
        do {
            List<byte[]> list = this.mPacketBuffer;
            synchronized (list) {
                int count = this.mPacketBuffer.size();
                if (count > 0) {
                    result = this.mPacketBuffer.remove(0);
                }
            }
            if (result != null) continue;
            if (System.currentTimeMillis() > end) {
                throw new IOException("Receive timeout expired");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (result == null);
        return result;
    }

    private synchronized byte[] transmit(int command) throws IOException {
        return this.transmit(command, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] transmit(int command, byte[] data) throws IOException {
        byte[] result = null;
        List<byte[]> list = this.mPacketBuffer;
        synchronized (list) {
            this.mPacketBuffer.clear();
        }
        this.writePacket(command, data);
        while (((result = this.readPacket(4000))[3] & 0xFF) != command) {
        }
        int errorCode = result[6] & 0xFF;
        if (errorCode != 0) {
            throw new LineaProException(errorCode);
        }
        byte[] tmp = new byte[result.length - 6 - 2];
        System.arraycopy(result, 8, tmp, 0, tmp.length);
        result = tmp;
        return result;
    }

    private synchronized byte[] transmit(int command, int subCommand, byte[] data) throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream(1 + data.length);
        o.write(subCommand);
        o.write(data, 0, data.length);
        return this.transmit(command, o.toByteArray());
    }

    private synchronized byte[] transmit(int command, int subCommand) throws IOException {
        return this.transmit(command, subCommand, new byte[0]);
    }

    public void turnOff() throws IOException, LineaProException {
        this.transmit(1, 1);
    }

    public void saveSettings() throws IOException, LineaProException {
        this.transmit(1, 2);
    }

    public void setRTC(Calendar clock) throws IOException, LineaProException {
        ByteArrayOutputStream o = new ByteArrayOutputStream(6);
        o.write(clock.get(1) - 2000);
        o.write(clock.get(2));
        o.write(clock.get(5));
        o.write(clock.get(11));
        o.write(clock.get(12));
        o.write(clock.get(13));
        this.transmit(1, 3, o.toByteArray());
    }

    public Calendar getRTC() throws IOException, LineaProException {
        byte[] tmp = this.transmit(1, 4);
        return new GregorianCalendar(tmp[0] + 2000, tmp[1], tmp[2], tmp[3], tmp[4], tmp[5]);
    }

    public LineaProInformation getInformation() throws IOException, LineaProException {
        byte[] tmp = this.transmit(1, 5);
        return LineaProInformation.create(tmp);
    }

    public float getBatteryVoltage() throws IOException, LineaProException {
        byte[] tmp = this.transmit(13);
        return (float)tmp[0] / 10.0f;
    }

    public int getBatteryLevel() throws IOException, LineaProException {
        float volts = this.getBatteryVoltage();
        int percent = 0;
        if ((double)volts >= 3.3) {
            percent = 1;
        }
        if ((double)volts >= 3.4) {
            percent = 5;
        }
        if ((double)volts >= 3.5) {
            percent = 10;
        }
        if ((double)volts >= 3.6) {
            percent = 25;
        }
        if ((double)volts >= 3.7) {
            percent = 50;
        }
        if ((double)volts >= 3.8) {
            percent = 75;
        }
        if ((double)volts >= 3.9) {
            percent = 90;
        }
        if ((double)volts >= 4.0) {
            percent = 95;
        }
        if ((double)volts >= 4.1) {
            percent = 100;
        }
        return percent;
    }

    public void beep(int volume, int[] pattern) throws IOException, LineaProException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(volume / 2);
        for (int node : pattern) {
            o.write(node >> 8);
            o.write(node);
        }
        this.transmit(15, o.toByteArray());
    }

    public void beep(int volume, int frequency, int duration) throws IOException, LineaProException {
        this.beep(volume, new int[]{frequency, duration});
    }

    public void setAutoOffTime(boolean connected, int autoOffTime) throws IOException, LineaProException {
        byte[] data = null;
        autoOffTime /= 1000;
        if (connected) {
            data = new byte[]{0, 4, (byte)(autoOffTime >> 24), (byte)(autoOffTime >> 16), (byte)(autoOffTime >> 8), (byte)(autoOffTime >> 0)};
            this.transmit(58, data);
        } else {
            data = new byte[]{0, 3, (byte)(autoOffTime >> 24), (byte)(autoOffTime >> 16), (byte)(autoOffTime >> 8), (byte)(autoOffTime >> 0)};
            this.transmit(58, data);
        }
    }

    public int getAutoOffTime(boolean connected) throws IOException, LineaProException {
        byte[] result = null;
        result = connected ? this.transmit(58, new byte[]{1, 4}) : this.transmit(58, new byte[]{1, 3});
        return (result[0] << 24 | result[1] << 16 | result[2] << 8 | result[3] << 0) * 1000;
    }

    public int getDeviceMode() throws IOException, LineaProException {
        byte[] result = this.transmit(58, new byte[]{1, 11});
        return result[0] & 0xFF;
    }

    public void setDeviceMode(int mode) throws IOException, LineaProException {
        this.transmit(58, new byte[]{0, 11, (byte)mode});
    }

    public void bcStartScan() throws IOException, LineaProException {
        this.transmit(3);
    }

    public void bcStopScan() throws IOException, LineaProException {
        this.transmit(4);
    }

    public void bcSetTimeout(int timeout) throws IOException, LineaProException {
        this.transmit(8, new byte[]{0, (byte)(timeout / 1000)});
    }

    public int bcGetTimeout() throws IOException, LineaProException {
        byte[] result = this.transmit(8, new byte[]{1});
        return result[0] * 1000;
    }

    public void bcSetMode(int mode) throws IOException, LineaProException {
        this.transmit(9, new byte[]{0, (byte)(mode >> 0)});
    }

    public int bcGetMode() throws IOException, LineaProException {
        byte[] result = this.transmit(9, new byte[]{1});
        return result[0] << 0;
    }

    public void enableScanButton(boolean enable) throws IOException, LineaProException {
        this.transmit(10, new byte[]{0, (byte)(enable ? 1 : 0)});
    }

    public boolean isScanButtonEnabled() throws IOException, LineaProException {
        byte[] result = this.transmit(10, new byte[]{1});
        return result[0] != 0;
    }

    public void enableBatteryCharge(boolean enable) throws IOException, LineaProException {
        this.transmit(16, new byte[]{0, (byte)(enable ? 1 : 0)});
    }

    public boolean isBatteryChargeEnabled() throws IOException, LineaProException {
        byte[] result = this.transmit(16, new byte[]{1});
        return result[0] != 0;
    }

    public Object bcGetEngine() throws IOException, LineaProException {
        LineaProInformation info = this.getInformation();
        if (info.hasIntermecEngine()) {
            return new Intermec(){

                @Override
                protected void init(byte[] data) throws IOException {
                    LineaPro.this.bcStopScan();
                    LineaPro.this.bcVendorInit(data);
                }

                @Override
                protected void write(byte[] data) throws IOException {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            LineaPro.this.bcWrite(data);
                            break;
                        }
                        catch (LineaProException e) {
                            if (e.getErrorCode() != 9) {
                                throw e;
                            }
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            continue;
                        }
                    }
                }

                @Override
                protected byte[] read() throws IOException {
                    return LineaPro.this.bcRead();
                }

                @Override
                protected void updateMode(byte[] data) throws IOException {
                    LineaPro.this.bcStartUpdateMode(data);
                }
            };
        }
        if (info.hasNewlandEngine()) {
            return new Newland(){

                @Override
                protected void init(byte[] data) throws IOException {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            LineaPro.this.bcVendorInit(data);
                            break;
                        }
                        catch (LineaProException e) {
                            if (e.getErrorCode() != 9) {
                                throw e;
                            }
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            continue;
                        }
                    }
                }
            };
        }
        return null;
    }

    public void bcSetBeep(int volume, int[] pattern) throws IOException, LineaProException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(volume / 2);
        for (int node : pattern) {
            o.write(node >> 8);
            o.write(node);
        }
        this.transmit(11, o.toByteArray());
    }

    public void bcStopBeep() throws IOException, LineaProException {
        this.bcSetBeep(0, new int[]{0, 0});
    }

    public byte[] bcRead() throws IOException, LineaProException {
        return this.transmit(22);
    }

    public void bcWrite(byte[] data) throws IOException, LineaProException {
        byte[] chunk;
        byte[] result;
        int length;
        int offset = 0;
        do {
            chunk = new byte[data.length - offset];
            System.arraycopy(data, offset, chunk, 0, chunk.length);
        } while ((offset += (length = ((result = this.transmit(23, chunk))[0] & 0xFF) << 8 | result[1] & 0xFF)) < data.length);
    }

    public void bcSetKeepAlive(boolean on) throws IOException, LineaProException {
        this.transmit(24, new byte[]{(byte)(on ? 1 : 0)});
    }

    public void bcVendorInit(byte[] data) throws IOException, LineaProException {
        this.transmit(35, data);
    }

    public void bcStartUpdateMode(byte[] data) throws IOException, LineaProException {
        this.transmit(36, data);
    }

    public void bcRestoreDefaultMode() throws IOException, LineaProException {
        this.transmit(51);
    }

    public void setLED(boolean red, boolean green, boolean blue) throws IOException, LineaProException {
        byte[] mask = new byte[4];
        mask[3] = (byte)(mask[3] + (byte)(red ? 2 : 0));
        mask[3] = (byte)(mask[3] + (byte)(green ? 1 : 0));
        mask[3] = (byte)(mask[3] + (byte)(blue ? 4 : 0));
        this.transmit(52, mask);
    }

    public void startVibrator(int duration) throws IOException, LineaProException {
        byte[] tmp = new byte[]{(byte)(duration >> 8), (byte)duration};
        this.transmit(53, tmp);
    }

    public void enableExternalSpeaker(boolean on) throws IOException, LineaProException {
        this.transmit(58, new byte[]{0, 6, (byte)(on ? 1 : 0)});
    }

    public boolean isExternalSpeakerEnabled() throws IOException, LineaProException {
        byte[] result = this.transmit(58, new byte[]{1, 6});
        return result[0] != 0;
    }

    public void enableExternalSpeakerButton(boolean on) throws IOException, LineaProException {
        this.transmit(58, new byte[]{0, 10, (byte)(on ? 1 : 0)});
    }

    public boolean isExternalSpeakerButtonEnabled() throws IOException, LineaProException {
        byte[] result = this.transmit(58, new byte[]{1, 10});
        return result[0] != 0;
    }

    public void enableMaxCurrent(boolean on) throws IOException, LineaProException {
        this.transmit(58, new byte[]{0, 12, (byte)(on ? 1 : 0)});
    }

    public boolean isMaxCurrentEnabled() throws IOException, LineaProException {
        byte[] result = this.transmit(58, new byte[]{1, 12});
        return result[0] != 0;
    }

    public BatteryInfo getBatteryInfo() throws IOException, LineaProException {
        while (true) {
            try {
                byte[] data = this.transmit(64);
                return BatteryInfo.create(data);
            }
            catch (LineaProException e) {
                if (e.getErrorCode() != 9) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public byte[] rfidTransmit(int module, byte[] data) throws IOException, LineaProException {
        switch (module) {
            case 0: {
                return this.transmit(32, data);
            }
            case 1: {
                return this.transmit(32, data);
            }
        }
        throw new IllegalArgumentException("The parameter 'module' is invalid");
    }

    private InputStream rfidGetInputStream(int module) throws IOException, LineaProException {
        InputStream inputStream = new InputStream(){
            private boolean mActive = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized int available() throws IOException {
                if (!this.mActive) {
                    throw new IOException("Stream is closed");
                }
                if (LineaPro.this.mLastError != null) {
                    throw LineaPro.this.mLastError;
                }
                LinkedList linkedList = LineaPro.this.mRfidInputBuffer;
                synchronized (linkedList) {
                    return LineaPro.this.mRfidInputBuffer.size();
                }
            }

            @Override
            public void close() throws IOException {
                this.mActive = false;
            }

            @Override
            public synchronized int read() throws IOException {
                byte[] b = new byte[1];
                while (this.read(b) == 0) {
                }
                return b[0] & 0xFF;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                while (this.available() == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LinkedList linkedList = LineaPro.this.mRfidInputBuffer;
                synchronized (linkedList) {
                    int count = Math.min(len, LineaPro.this.mRfidInputBuffer.size());
                    for (int i = 0; i < count; ++i) {
                        b[off + i] = (Byte)LineaPro.this.mRfidInputBuffer.remove(0);
                    }
                    return count;
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }
        };
        return inputStream;
    }

    private OutputStream rfidGetOutputStream(int module) throws IOException, LineaProException {
        final int moduleType = module;
        OutputStream outputStream = new OutputStream(){
            private boolean mActive = true;

            @Override
            public void close() throws IOException {
                this.mActive = false;
            }

            @Override
            public void flush() throws IOException {
                if (!this.mActive) {
                    throw new IOException("Stream is closed");
                }
                if (LineaPro.this.mLastError != null) {
                    throw LineaPro.this.mLastError;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                byte[] data = new byte[len];
                System.arraycopy(b, off, data, 0, len);
                this.write(data);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] b) throws IOException {
                byte[] data = LineaPro.this.rfidTransmit(moduleType, b);
                LinkedList linkedList = LineaPro.this.mRfidInputBuffer;
                synchronized (linkedList) {
                    for (int i = 0; i < data.length; ++i) {
                        LineaPro.this.mRfidInputBuffer.add(data[i]);
                    }
                }
            }

            @Override
            public void write(int b) throws IOException {
                byte[] data = new byte[]{(byte)b};
                this.write(data);
            }
        };
        return outputStream;
    }

    public RC663 rfidGetModule() throws IOException {
        return new RC663(this.rfidGetInputStream(1), this.rfidGetOutputStream(1));
    }

    public void fwStart() throws IOException, LineaProException {
        this.transmit(240);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void fwErase() throws IOException, LineaProException {
        this.transmit(241);
    }

    public void fwWrite(int address, byte[] data) throws IOException, LineaProException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(address >> 24);
        buffer.write(address >> 16);
        buffer.write(address >> 8);
        buffer.write(address);
        buffer.write(data);
        this.transmit(242, buffer.toByteArray());
    }

    public void fwStop() throws IOException, LineaProException {
        this.transmit(243);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fwUpdate(byte[] data) throws IOException, LineaProException {
        int length = data.length;
        LineaPro lineaPro = this;
        synchronized (lineaPro) {
            int tmplen;
            this.fwStart();
            this.fwErase();
            for (int offset = 0; offset < length; offset += tmplen) {
                tmplen = Math.min(2044, length - offset);
                byte[] tmp = new byte[tmplen];
                System.arraycopy(data, offset, tmp, 0, tmplen);
                this.fwWrite(offset, tmp);
            }
            this.fwStop();
        }
    }

    public static class BatteryInfo {
        private byte[] mData;
        private int mVoltage;
        private int mCapacity;
        private int mHealthLevel;
        private int mInitialCapacity;
        private boolean mChangingState;
        private Fuelgauge mFuelgauge;

        private BatteryInfo(byte[] data) {
            this.mData = data;
            if (data.length > 1) {
                this.mVoltage = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            }
            if (data.length > 2) {
                this.mCapacity = data[2] & 0xFF;
            }
            if (data.length > 3) {
                this.mHealthLevel = data[3] & 0xFF;
            }
            if (data.length > 5) {
                this.mInitialCapacity = (data[4] & 0xFF) << 8 | data[5] & 0xFF;
            }
            if (data.length > 6) {
                boolean bl = this.mChangingState = data[6] != 0;
            }
            if (data.length > 33) {
                byte[] tmp = new byte[26];
                System.arraycopy(data, 8, tmp, 0, tmp.length);
                this.mFuelgauge = new Fuelgauge(tmp);
            }
        }

        public static BatteryInfo create(byte[] data) {
            return new BatteryInfo(data);
        }

        public byte[] getData() {
            return this.mData;
        }

        public int getVoltage() {
            return this.mVoltage;
        }

        public int getCapacity() {
            return this.mCapacity;
        }

        public int getHealthLevel() {
            return this.mHealthLevel;
        }

        public int getInitialCapacity() {
            return this.mInitialCapacity;
        }

        public boolean isCharging() {
            return this.mChangingState;
        }

        public Fuelgauge getFuelgauge() {
            return this.mFuelgauge;
        }

        public class Fuelgauge {
            private int mTemperature;
            private int mVoltage;
            private int mNominalAvailableCapacity;
            private int mFullAvailableCapacity;
            private int mRemainingCapacity;
            private int mFullChargeCapacity;
            private int mAverageCurrent;
            private int mStandbyCurrent;
            private int mMaxLoadCurrent;
            private int mAveragePower;
            private int mStateOfCharge;
            private int mInternalTemperature;
            private int mStateOfHealth;

            private Fuelgauge(byte[] data) {
                this.mTemperature = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                this.mVoltage = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                this.mNominalAvailableCapacity = (data[5] & 0xFF) << 8 | data[4] & 0xFF;
                this.mFullAvailableCapacity = (data[7] & 0xFF) << 8 | data[6] & 0xFF;
                this.mRemainingCapacity = (data[9] & 0xFF) << 8 | data[8] & 0xFF;
                this.mFullChargeCapacity = (data[11] & 0xFF) << 8 | data[10] & 0xFF;
                this.mAverageCurrent = data[13] << 8 | data[12] & 0xFF;
                this.mStandbyCurrent = data[15] << 8 | data[14] & 0xFF;
                this.mMaxLoadCurrent = data[17] << 8 | data[16] & 0xFF;
                this.mAveragePower = data[19] << 8 | data[18] & 0xFF;
                this.mStateOfCharge = (data[21] & 0xFF) << 8 | data[20] & 0xFF;
                this.mInternalTemperature = (data[23] & 0xFF) << 8 | data[22] & 0xFF;
                this.mStateOfHealth = data[24] & 0xFF;
            }

            public float getTemperature() {
                return (float)this.mTemperature / 10.0f;
            }

            public int getVoltage() {
                return this.mVoltage;
            }

            public int getNominalAvailableCapacity() {
                return this.mNominalAvailableCapacity;
            }

            public int getFullAvailableCapacity() {
                return this.mFullAvailableCapacity;
            }

            public int getRemainingCapacity() {
                return this.mRemainingCapacity;
            }

            public int getFullChargeCapacity() {
                return this.mFullChargeCapacity;
            }

            public int getAverageCurrent() {
                return this.mAverageCurrent;
            }

            public int getStandbyCurrent() {
                return this.mStandbyCurrent;
            }

            public int getMaxLoadCurrent() {
                return this.mMaxLoadCurrent;
            }

            public int getAveragePower() {
                return this.mAveragePower;
            }

            public int getStateOfCharge() {
                return this.mStateOfCharge;
            }

            public float getInternalTemperature() {
                return (float)this.mInternalTemperature / 10.0f;
            }

            public int getStateOfHealth() {
                return this.mStateOfHealth;
            }
        }
    }

    private class ReceiverThread
    extends Thread {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buffer = new byte[2054];
            int offset = 0;
            try {
                block5: while (LineaPro.this.mLastError == null) {
                    int length;
                    offset += LineaPro.this.read(buffer, offset, buffer.length - offset);
                    while (offset >= 6 && offset >= (length = 6 + ((buffer[1] & 0xFF) << 8 | buffer[2] & 0xFF))) {
                        LineaPro.this.processPacket(buffer, length);
                        System.arraycopy(buffer, length, buffer, 0, offset - length);
                        offset -= length;
                        if (LineaPro.this.mLastError == null) continue;
                        continue block5;
                    }
                }
            }
            catch (IOException e) {
                LineaPro.debug(e);
                if (LineaPro.this.mLastError == null) {
                    LineaPro.this.mLastError = e;
                }
            }
            finally {
                LineaPro.this.raiseDisconnect();
            }
            LineaPro.debug("Device is disconnected");
        }
    }

    public static interface ConnectionListener {
        public void onDisconnect();
    }

    public static interface ButtonListener {
        public void onButtonStateChanged(int var1, boolean var2);
    }

    public static interface BarcodeListener {
        public void onReadBarcode(Barcode var1);
    }
}

