/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.printer;

import com.datecs.biometric.TouchChip;
import com.datecs.printer.PrinterInformation;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Printer {
    private static final int MAX_PACKET_SIZE = 2044;
    private static boolean sDebug = false;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int CARD_IO_TIME = 11000;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int BARCODE_UPCA = 65;
    public static final int BARCODE_UPCE = 66;
    public static final int BARCODE_EAN13 = 67;
    public static final int BARCODE_EAN8 = 68;
    public static final int BARCODE_CODE39 = 69;
    public static final int BARCODE_ITF = 70;
    public static final int BARCODE_CODABAR = 71;
    public static final int BARCODE_CODE93 = 72;
    public static final int BARCODE_CODE128 = 73;
    public static final int BARCODE_PDF417 = 74;
    public static final int BARCODE_CODE128AUTO = 75;
    public static final int BARCODE_EAN128 = 76;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int PAGE_LEFT = 0;
    public static final int PAGE_BOTTOM = 1;
    public static final int PAGE_RIGHT = 2;
    public static final int PAGE_TOP = 3;
    public static final int FILL_WHITE = 0;
    public static final int FILL_BLACK = 1;
    public static final int FILL_INVERTED = 2;
    public static final int SETTINGS_BLUETOOTH = 5;
    private InputStream mBaseInputStream;
    private OutputStream mBaseOutputStream;
    private IOException mLastError;
    private Settings mSettings;
    private ConnectionListener mConnListener;
    private byte[] mDataBuffer;
    private int mDataBufferLen;

    public Printer(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = null;
        this.mBaseOutputStream = new BufferedOutputStream(out, 2044);
        this.initDefaults();
    }

    public Printer(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException("The in is null");
        }
        if (out == null) {
            throw new NullPointerException("The out is null");
        }
        this.mBaseInputStream = in;
        this.mBaseOutputStream = new BufferedOutputStream(out, 2044);
        this.mDataBuffer = new byte[2044];
        this.initDefaults();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    byte[] buffer = new byte[2044];
                    block10: while (true) {
                        try {
                            while (Printer.this.mLastError == null) {
                                int bytesRead = Printer.this.read(buffer, 0, buffer.length);
                                byte[] byArray = Printer.this.mDataBuffer;
                                synchronized (byArray) {
                                    while (bytesRead + Printer.this.mDataBufferLen > Printer.this.mDataBuffer.length) {
                                        byte[] tmp = new byte[Printer.this.mDataBuffer.length + 2044];
                                        System.arraycopy(Printer.this.mDataBuffer, 0, tmp, 0, Printer.this.mDataBufferLen);
                                        Printer.access$202(Printer.this, tmp);
                                    }
                                    System.arraycopy(buffer, 0, Printer.this.mDataBuffer, Printer.this.mDataBufferLen, bytesRead);
                                    Printer.this.mDataBufferLen = Printer.this.mDataBufferLen + bytesRead;
                                }
                                try {
                                    Thread.sleep(10L);
                                    continue block10;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                            }
                            break block15;
                        }
                        catch (IOException e) {
                            if (sDebug) {
                                e.printStackTrace();
                            }
                            if (Printer.this.mLastError == null) {
                                Printer.this.mLastError = e;
                            }
                            break block15;
                        }
                    }
                    finally {
                        Printer.this.raiseDisconnect();
                    }
                }
            }
        });
        t.start();
    }

    public synchronized void close() {
        this.mLastError = new IOException("The object is closed");
        try {
            if (this.mBaseInputStream != null) {
                this.mBaseInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mBaseOutputStream != null) {
                this.mBaseOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    private void debug(String text) {
        if (sDebug) {
            System.out.println(text);
        }
    }

    private void debug(String text, byte[] buffer, int offset, int count) {
        if (sDebug) {
            this.debug(text + Printer.byteArrayToHexString(buffer, offset, count) + "(" + count + ")");
        }
    }

    private void initDefaults() {
        this.mSettings = new Settings();
        this.mSettings.barcodeAlign = 0;
        this.mSettings.barcodeScale = 3;
        this.mSettings.barcodeHeight = 162;
        this.mSettings.barcodeHriFont = 0;
        this.mSettings.barcodeHriCode = 0;
    }

    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int offset, int length) throws IOException {
        this.mBaseOutputStream.write(b, offset, length);
        this.debug("<Printer> >> ", b, offset, length);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.mBaseInputStream.read(buffer, offset, length);
        if (bytesRead < 0) {
            throw new IOException("The end of the stream is reached");
        }
        if (bytesRead > length) {
            throw new IOException("Invalid stream result " + bytesRead);
        }
        if (bytesRead > 0) {
            this.debug("<Printer> << ", buffer, offset, bytesRead);
        }
        return bytesRead;
    }

    private void output(byte[] buffer) throws IOException {
        this.write(buffer);
        this.mBaseOutputStream.flush();
    }

    private void request(int length, int timeout) throws IOException {
        long endTime = System.currentTimeMillis() + (long)timeout;
        if (this.mDataBuffer == null) {
            throw new IOException("Unable to read from input");
        }
        while (this.mDataBufferLen < length) {
            if (this.mLastError != null) {
                throw this.mLastError;
            }
            if (endTime < System.currentTimeMillis()) {
                throw new IOException("Timeout");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        byte[] byArray = this.mDataBuffer;
        synchronized (this.mDataBuffer) {
            this.mDataBufferLen = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void raiseDisconnect() {
        final ConnectionListener l = this.mConnListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onDisconnect();
                }
            }).start();
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.mConnListener = listener;
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean wait) throws IOException {
        byte[] tmp = new byte[1024];
        this.mBaseOutputStream.write(tmp);
        this.mBaseOutputStream.flush();
        if (wait) {
            this.getInformation(15000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrinterInformation getInformation() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 90});
            byte[] buffer = new byte[32];
            this.request(buffer.length, 5000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            PrinterInformation pi = new PrinterInformation(buffer);
            return pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            int n;
            this.clear();
            this.output(new byte[]{27, 78});
            for (n = 0; n < 13; ++n) {
                this.request(n + 1, 5000);
                if (this.mDataBuffer[n] == 0) break;
            }
            return new String(this.mDataBuffer, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrinterInformation getInformation(int timeout) throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 90});
            byte[] buffer = new byte[32];
            this.request(buffer.length, timeout);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            PrinterInformation pi = new PrinterInformation(buffer);
            return pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVoltage() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 96});
            byte[] buffer = new byte[2];
            this.request(buffer.length, 5000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return ((buffer[0] & 0xFF) - 32) * 100;
        }
    }

    public int getVoltagePercentage() throws IOException {
        PrinterInformation pi = this.getInformation();
        int voltage = this.getVoltage() / 100;
        int percent = 0;
        if (pi.getModel() == 5) {
            if (voltage >= 133 && voltage < 140) {
                voltage = 140;
            }
            voltage /= 2;
        }
        percent = voltage >= 82 ? 100 : (voltage == 81 ? 97 : (voltage == 80 ? 90 : (voltage == 79 ? 85 : (voltage == 78 ? 78 : (voltage == 77 ? 72 : (voltage == 76 ? 62 : (voltage == 75 ? 50 : (voltage == 74 ? 30 : (voltage == 73 ? 20 : (voltage == 72 ? 15 : (voltage == 71 ? 8 : (voltage == 70 ? 2 : 0))))))))))));
        return percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTemperature() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 96});
            byte[] buffer = new byte[2];
            this.request(buffer.length, 5000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return (buffer[1] & 0xFF) - 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 118});
            byte[] buffer = new byte[1];
            this.request(buffer.length, 5000);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return buffer[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(int timeout) throws IOException {
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 118});
            byte[] buffer = new byte[1];
            this.request(buffer.length, timeout);
            System.arraycopy(this.mDataBuffer, 0, buffer, 0, buffer.length);
            return buffer[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readCard(boolean first, boolean second, boolean third, int timeout) throws IOException {
        if (!(first || second || third)) {
            throw new IllegalArgumentException("No track selected");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            for (int repeat = 0; repeat < (timeout + 11000) / 11000; ++repeat) {
                int offset = 0;
                this.clear();
                this.output(new byte[]{27, 63, (byte)((first ? 1 : 0) | (second ? 2 : 0) | (third ? 4 : 0))});
                do {
                    this.request(++offset, 11000);
                } while (offset < this.mDataBuffer.length && this.mDataBuffer[offset - 1] != 0);
                if (offset <= 1) continue;
                String[] track = new String[3];
                int trackIndex = -1;
                block10: for (int i = 0; i < offset - 1; ++i) {
                    switch (this.mDataBuffer[i] & 0xFF) {
                        case 241: {
                            trackIndex = 0;
                            track[0] = "";
                            continue block10;
                        }
                        case 242: {
                            trackIndex = 1;
                            track[1] = "";
                            continue block10;
                        }
                        case 243: {
                            trackIndex = 2;
                            track[2] = "";
                            continue block10;
                        }
                        default: {
                            if (trackIndex < 0) continue block10;
                            int n = trackIndex;
                            track[n] = track[n] + (char)(this.mDataBuffer[i] & 0xFF);
                        }
                    }
                }
                return track;
            }
        }
        return new String[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readBarcode(int timeout) throws IOException {
        StringBuffer textBuffer = new StringBuffer();
        int offset = 0;
        if (timeout < 0) {
            throw new IllegalArgumentException("The wait is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            boolean consumeFF = false;
            this.clear();
            if (timeout == 0) {
                this.output(new byte[]{27, 66, (byte)(timeout + 32)});
            } else {
                this.output(new byte[]{27, 66, (byte)(timeout + 32), 27, 66, 32});
            }
            this.request(1, (timeout + 1) * 1000);
            while (this.mDataBuffer[offset] != 0) {
                if (this.mDataBuffer[offset] == -1) {
                    if (consumeFF) {
                        textBuffer.append('\u00ff');
                        textBuffer.append('\u00ff');
                        consumeFF = false;
                    } else {
                        consumeFF = true;
                    }
                } else {
                    if (consumeFF) {
                        int n = offset;
                        this.mDataBuffer[n] = (byte)(this.mDataBuffer[n] - 32);
                        consumeFF = false;
                    }
                    textBuffer.append((char)(this.mDataBuffer[offset] & 0xFF));
                }
                this.request(++offset, timeout);
            }
        }
        if (textBuffer.length() == 0) {
            return null;
        }
        return textBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        byte[] buf = new byte[]{27, 64, 27, 50, 27, 73, 0, 27, 33, 0, 29, 76, 0, 0};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() throws IOException {
        byte[] buf = new byte[]{27, 43};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printSelfTest() throws IOException {
        byte[] buf = new byte[]{27, 46};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCodetable(int codetable) throws IOException {
        byte[] buf = new byte[]{27, 117, (byte)codetable};
        if (codetable < 0) {
            throw new IllegalArgumentException("The codetable is negative");
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineSpace(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 51, (byte)(lines & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlign(int align) throws IOException {
        byte[] buf;
        switch (align) {
            case 0: 
            case 1: 
            case 2: {
                buf = new byte[]{27, 97, (byte)align};
                break;
            }
            default: {
                throw new IllegalArgumentException("The align is illegal");
            }
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedPaper(int lines) throws IOException {
        if (lines < 0 || lines > 255) {
            throw new IllegalArgumentException("The lines is out of range");
        }
        byte[] buf = new byte[]{27, 74, (byte)lines};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beep() throws IOException {
        byte[] tmp = new byte[]{27, 30};
        Printer printer = this;
        synchronized (printer) {
            this.write(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void melody(String data) throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(27);
        o.write(114);
        o.write(data.getBytes());
        Printer printer = this;
        synchronized (printer) {
            this.write(o.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(byte[] b) throws IOException {
        Printer printer = this;
        synchronized (printer) {
            byte[] tmp = b;
            this.write(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.printText(s.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        Printer printer = this;
        synchronized (printer) {
            this.printText(s.getBytes(encoding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTaggedText(byte[] b) throws IOException {
        int LEN = 6;
        int ELE = 123;
        int END = 125;
        int DET = 47;
        int BREAK = "br".hashCode();
        int SMALL = "s".hashCode();
        int BOLD = "b".hashCode();
        int HIGH = "h".hashCode();
        int WIDE = "w".hashCode();
        int UNDERLINE = "u".hashCode();
        int ITALIC = "i".hashCode();
        int RESET = "reset".hashCode();
        int LEFT = "left".hashCode();
        int CENTER = "center".hashCode();
        int RIGHT = "right".hashCode();
        if (b == null) {
            throw new NullPointerException("The b is null");
        }
        int len = b.length;
        byte[] tbuf = new byte[6 + len];
        int toffs = 0;
        byte mode = 0;
        int pos = 0;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 33;
        tbuf[toffs++] = mode;
        tbuf[toffs++] = 27;
        tbuf[toffs++] = 73;
        tbuf[toffs++] = 0;
        for (int i = 0; i < len; ++i) {
            int index;
            boolean set;
            byte value = b[i];
            tbuf[toffs++] = value;
            if (value == 123) {
                pos = toffs;
                continue;
            }
            if (value != 125 || pos < 1 || toffs - 1 - 6 > pos) continue;
            if (tbuf[pos] == 47) {
                set = false;
                index = pos + 1;
            } else {
                set = true;
                index = pos;
            }
            int hash = 0;
            int hashlen = toffs - 1 - index;
            for (int j = 0; j < hashlen; ++j) {
                int c = tbuf[index + j] & 0xFF;
                if (c >= 65 && c <= 90) {
                    c += 32;
                }
                hash = 31 * hash + c;
            }
            if (hash == BREAK) {
                toffs = pos - 1;
                tbuf[toffs++] = 10;
                continue;
            }
            if (hash == SMALL) {
                mode = set ? (byte)(mode | 1) : (byte)(mode & 0xFFFFFFFE);
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                continue;
            }
            if (hash == BOLD) {
                mode = set ? (byte)(mode | 8) : (byte)(mode & 0xFFFFFFF7);
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                continue;
            }
            if (hash == HIGH) {
                mode = set ? (byte)(mode | 0x10) : (byte)(mode & 0xFFFFFFEF);
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                continue;
            }
            if (hash == WIDE) {
                mode = set ? (byte)(mode | 0x20) : (byte)(mode & 0xFFFFFFDF);
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                continue;
            }
            if (hash == UNDERLINE) {
                mode = set ? (byte)(mode | 0x80) : (byte)(mode & 0xFFFFFF7F);
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                continue;
            }
            if (hash == ITALIC) {
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 73;
                tbuf[toffs++] = set ? (byte)1 : 0;
                continue;
            }
            if (hash == RESET) {
                mode = 0;
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 33;
                tbuf[toffs++] = mode;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 73;
                tbuf[toffs++] = 0;
                continue;
            }
            if (hash == LEFT) {
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 97;
                tbuf[toffs++] = 0;
                continue;
            }
            if (hash == CENTER) {
                toffs = pos - 1;
                tbuf[toffs++] = 27;
                tbuf[toffs++] = 97;
                tbuf[toffs++] = 1;
                continue;
            }
            if (hash != RIGHT) continue;
            toffs = pos - 1;
            tbuf[toffs++] = 27;
            tbuf[toffs++] = 97;
            tbuf[toffs++] = 2;
        }
        Printer printer = this;
        synchronized (printer) {
            byte[] tmp = new byte[toffs];
            System.arraycopy(tbuf, 0, tmp, 0, tmp.length);
            this.printText(tmp);
        }
    }

    public void printTaggedText(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes());
    }

    public void printTaggedText(String s, String encoding) throws IOException {
        if (s == null) {
            throw new NullPointerException("The s is null");
        }
        this.printTaggedText(s.getBytes(encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArabicText(int codetable, String text) throws IOException {
        int ARABIC_RAW = 21;
        int ARABIC_1256M = 23;
        int ARABIC_1256F = 24;
        boolean FROM_RIGHT = true;
        int FROM_LEFT = 2;
        byte[] ArabicAttr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 0, 1, 3, 2, 0, 1, 0, 1, 0, 1, 3, 2, 3, 1, 0, 1, 3, 2, 0, 1, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0};
        byte[] Arabic1256F = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, -80, -79, -78, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        byte[] Arabic1256M = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        byte[][] Arabic1256 = new byte[][]{{-54, 46, -76, -49, -73, -70, 0, 0, -67, -66, 58, 28, 0, 70, 90, 88, -120, -74, -75, -71, -72, -68, 0, 0, -124, -63, 88, 30, 0, 0, 0, -106, 0, 12, -53, -52, -51, -50, -48, -47, 0, -62, -96, -56, 0, 13, -61, 0, -65, -59, -64, 0, 0, 0, -46, -69, 0, 0, 27, -55, 0, 0, 0, 31, -96, 41, 33, 35, -98, 37, -86, 39, 42, -43, 50, 54, 62, 66, 74, 78, 80, 84, 86, 92, 96, 100, 104, -57, 108, 112, 116, 120, 32, 124, -128, -82, 0, -116, 0, -110, -104, -96, -100, 0, 0, 0, 0, 0, -92, -90, 0, 0, 0, 0, 0, 0, 0, 0, 0, -58, 0, 0, 0, 0, 0, 0, 0, -41}, {-54, 47, -76, -49, -73, -70, 0, 0, -67, -66, 59, 28, 0, 71, 91, 89, -119, -74, -75, -71, -72, -68, 0, 0, -123, -63, 89, 30, 0, 0, 0, -105, 0, 12, -53, -52, -51, -50, -48, -47, 0, -62, -95, -56, 0, 13, -61, 0, -65, -59, -64, 0, 0, 0, -46, -69, 0, 0, 27, -55, 0, 0, 0, 31, -46, 41, 34, 36, -97, 38, -85, 40, 43, -42, 51, 55, 63, 67, 75, 79, 81, 85, 87, 93, 97, 101, 105, -57, 109, 113, 117, 121, 32, 125, -127, -81, 0, -115, 0, -109, -103, -95, -99, 0, 0, 0, 0, 0, -91, -89, 0, 0, 0, 0, 0, 0, 0, 0, 0, -58, 0, 0, 0, 0, 0, 0, 0, -40}, {-54, 49, -76, -49, -73, -70, 0, 0, -67, -66, 61, 28, 0, 73, 90, 88, -117, -74, -75, -71, -72, -68, 0, 0, -121, -63, 88, 30, 0, 0, 0, -106, 0, 12, -53, -52, -51, -50, -48, -47, 0, -62, -93, -56, 0, 13, -61, 0, -65, -59, -64, 0, 0, 0, -46, -69, 0, 0, 27, -55, 0, 0, 0, 31, -44, 41, 33, 35, -98, 37, -83, 39, 45, -43, 53, 57, 65, 69, 77, 78, 80, 84, 86, 95, 99, 103, 107, -57, 111, 115, 119, 123, 32, 127, -125, -121, 0, -111, 0, -107, -101, -93, -100, 0, 0, 0, 0, 0, -92, -87, 0, 0, 0, 0, 0, 0, 0, 0, 0, -58, 0, 0, 0, 0, 0, 0, 0, -41}, {-54, 48, -76, -49, -73, -70, 0, 0, -67, -66, 60, 28, 0, 72, 91, 89, -118, -74, -75, -71, -72, -68, 0, 0, -122, -63, 89, 30, 0, 0, 0, -105, 0, 12, -53, -52, -51, -50, -48, -47, 0, -62, -94, -56, 0, 13, -61, 0, -65, -59, -64, 0, 0, 0, -46, -69, 0, 0, 27, -55, 0, 0, 0, 31, -45, 41, 34, 36, -97, 38, -84, 40, 44, -43, 52, 56, 64, 68, 76, 79, 81, 85, 87, 94, 98, 102, 106, -57, 110, 114, 118, 122, 32, 126, -126, -122, 0, -112, 0, -108, -102, -94, -99, 0, 0, 0, 0, 0, -92, -88, 0, 0, 0, 0, 0, 0, 0, 0, 0, -58, 0, 0, 0, 0, 0, 0, 0, -41}};
        byte[] input = text.getBytes("Cp1256");
        boolean found = false;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != -20) continue;
            found = true;
            break;
        }
        if (found) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int LastAttr = 0;
            int NextAttr = 0;
            int ArabAttr = 0;
            for (int i = 0; i < input.length; ++i) {
                int ThisByte = input[i] & 0xFF;
                if (ThisByte <= 32) {
                    LastAttr = 0;
                } else {
                    int NextByte;
                    ArabAttr = 0;
                    NextAttr = 0;
                    int n = NextByte = input.length - 1 == i ? 0 : input[i] & 0xFF;
                    if (NextByte >= 128) {
                        NextByte = Arabic1256[1][NextByte - 128] & 0xFF;
                        NextAttr = ArabicAttr[NextByte] & 0xFF;
                    }
                    if (NextAttr & true) {
                        ArabAttr |= 2;
                    }
                    if ((LastAttr & 2) != 0) {
                        ArabAttr |= 1;
                    }
                    if (ThisByte < 64) {
                        ThisByte = codetable == 23 ? (Arabic1256M[ThisByte - 32] & 0xFF) + 32 : (Arabic1256F[ThisByte - 32] & 0xFF) + 32;
                    } else {
                        ThisByte = (Arabic1256[ArabAttr][ThisByte - 128] & 0xFF) + 32;
                        if (codetable == 24 && (ThisByte == 198 || ThisByte == 199)) {
                            ThisByte -= 2;
                        }
                        ArabAttr = ArabicAttr[ThisByte - 32] & 0xFF;
                    }
                    LastAttr = ArabAttr;
                }
                output.write(ThisByte);
            }
            input = output.toByteArray();
            Printer printer = this;
            synchronized (printer) {
                this.selectCodetable(21);
                this.write(input);
                this.selectCodetable(codetable);
            }
        }
        Printer printer = this;
        synchronized (printer) {
            this.selectCodetable(codetable);
            this.write(input);
        }
    }

    private static void convertARGBToGrayscale(int[] argb, int width, int height) {
        int pixels = width * height;
        for (int i = 0; i < pixels; ++i) {
            int color;
            int r = argb[i] >> 16 & 0xFF;
            int g = argb[i] >> 8 & 0xFF;
            int b = argb[i] & 0xFF;
            argb[i] = color = r * 19 + g * 38 + b * 7 >> 6 & 0xFF;
        }
    }

    private static void ditherImageByFloydSteinberg(int[] grayscale, int width, int height) {
        int stopXM1 = width - 1;
        int stopYM1 = height - 1;
        int[] coef = new int[]{3, 5, 1};
        int offs = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int ed;
                int error;
                int v = grayscale[offs];
                if (v < 128) {
                    grayscale[offs] = 0;
                    error = v;
                } else {
                    grayscale[offs] = 255;
                    error = v - 255;
                }
                if (x != stopXM1) {
                    ed = grayscale[offs + 1] + error * 7 / 16;
                    grayscale[offs + 1] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                }
                if (y != stopYM1) {
                    int i = -1;
                    int j = 0;
                    while (i <= 1) {
                        if (x + i >= 0 && x + i < width) {
                            ed = grayscale[offs + width + i] + error * coef[j] / 16;
                            grayscale[offs + width + i] = ed = ed < 0 ? 0 : (ed > 255 ? 255 : ed);
                        }
                        ++i;
                        ++j;
                    }
                }
                ++x;
                ++offs;
            }
        }
    }

    private int cropImage(int[] grayscale, int width, int height) {
        int offset;
        int length = width * height;
        for (offset = 0; offset < length && grayscale[length - 1 - offset] >= 128; ++offset) {
        }
        int newHeight = height - offset / width;
        return newHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printImage(int[] argb, int width, int height, int align, boolean dither, boolean crop) throws IOException {
        byte[] buf = null;
        int bufOffs = 0;
        if (argb == null) {
            throw new NullPointerException("The argb is null");
        }
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The size of image is illegal");
        }
        Printer.convertARGBToGrayscale(argb, width, height);
        if (dither) {
            Printer.ditherImageByFloydSteinberg(argb, width, height);
        }
        if (crop) {
            height = this.cropImage(argb, width, height);
        }
        buf = new byte[width * 3 + 9];
        Printer printer = this;
        synchronized (printer) {
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 51;
            buf[bufOffs++] = 24;
            this.write(buf, 0, bufOffs);
            bufOffs = 0;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 97;
            buf[bufOffs++] = (byte)align;
            buf[bufOffs++] = 27;
            buf[bufOffs++] = 42;
            buf[bufOffs++] = 33;
            buf[bufOffs++] = (byte)(width % 256);
            buf[bufOffs++] = (byte)(width / 256);
            buf[buf.length - 1] = 10;
            int offs = 0;
            for (int j = 0; j < height; ++j) {
                int i;
                if (j > 0 && j % 24 == 0) {
                    this.write(buf);
                    for (i = bufOffs; i < buf.length - 1; ++i) {
                        buf[i] = 0;
                    }
                }
                i = 0;
                while (i < width) {
                    int n = bufOffs + i * 3 + j % 24 / 8;
                    buf[n] = (byte)(buf[n] | (byte)((argb[offs] < 128 ? 1 : 0) << 7 - j % 8));
                    ++i;
                    ++offs;
                }
            }
            this.write(buf);
        }
    }

    public void printImage(int[] argb, int width, int height, int align, boolean dither) throws IOException {
        this.printImage(argb, width, height, align, dither, false);
    }

    private static int compressRLE(byte[] src, int srcOffs, byte[] dst, int dstOffs, int length) {
        int count;
        int dstLen = 0;
        for (int offset = 0; offset < length; offset += count) {
            int nextValue;
            count = 1;
            int currValue = src[srcOffs + offset] & 0xFF;
            for (int i = offset + 1; i < length && count < 64 && currValue == (nextValue = src[srcOffs + i] & 0xFF); ++count, ++i) {
            }
            if (count > 1) {
                dst[dstOffs + dstLen] = (byte)(0xC0 | count);
                dst[dstOffs + ++dstLen] = (byte)currValue;
                ++dstLen;
                continue;
            }
            if ((currValue & 0xC0) == 192) {
                dst[dstOffs + dstLen] = -63;
                dst[dstOffs + ++dstLen] = (byte)currValue;
                ++dstLen;
                continue;
            }
            dst[dstOffs + dstLen] = (byte)currValue;
            ++dstLen;
        }
        return dstLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompressedImage(int[] argb, int width, int height, int align, boolean dither, boolean crop) throws IOException {
        if (argb == null) {
            throw new NullPointerException("The argb is null");
        }
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The size of image is illegal");
        }
        Printer.convertARGBToGrayscale(argb, width, height);
        if (dither) {
            Printer.ditherImageByFloydSteinberg(argb, width, height);
        }
        if (crop) {
            height = this.cropImage(argb, width, height);
        }
        Printer printer = this;
        synchronized (printer) {
            int horzSizeInBytes = (width + 7) / 8;
            byte[] buffer = new byte[horzSizeInBytes * 24 + 7];
            byte[] packed = new byte[horzSizeInBytes * 24 * 2];
            int cmdOffset = 0;
            cmdOffset = 0;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 51;
            buffer[cmdOffset++] = 24;
            this.write(buffer, 0, cmdOffset);
            cmdOffset = 0;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 97;
            buffer[cmdOffset++] = (byte)align;
            buffer[cmdOffset++] = 27;
            buffer[cmdOffset++] = 42;
            buffer[cmdOffset++] = 17;
            buffer[cmdOffset++] = (byte)horzSizeInBytes;
            int offset = 0;
            for (int j = 0; j < height; ++j) {
                if (j > 0 && j % 24 == 0) {
                    int length = Printer.compressRLE(buffer, cmdOffset, packed, 0, buffer.length - cmdOffset);
                    this.write(buffer, 0, cmdOffset);
                    this.write(packed, 0, length);
                    this.write(10);
                    for (int i = cmdOffset; i < buffer.length; ++i) {
                        buffer[i] = 0;
                    }
                }
                int i = 0;
                while (i < width) {
                    int n = cmdOffset + i / 8 + j % 24 * horzSizeInBytes;
                    buffer[n] = (byte)(buffer[n] | (byte)((argb[offset] < 128 ? 1 : 0) << i % 8));
                    ++i;
                    ++offset;
                }
            }
            int length = Printer.compressRLE(buffer, cmdOffset, packed, 0, buffer.length - cmdOffset);
            this.write(buffer, 0, cmdOffset);
            this.write(packed, 0, length);
            this.write(10);
        }
    }

    public void printCompressedImage(int[] argb, int width, int height, int align, boolean dither) throws IOException {
        this.printCompressedImage(argb, width, height, align, dither, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo(boolean wide, boolean high) throws IOException {
        byte mode = 0;
        if (wide) {
            mode = (byte)(mode + 1);
        }
        if (high) {
            mode = (byte)(mode + 2);
        }
        byte[] buf = new byte[]{29, 47, mode};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLogo() throws IOException {
        byte[] buf = new byte[]{29, 47, 0};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    public void setBarcode(int align, boolean small, int scale, int hri, int height) {
        if (align < 0) {
            throw new IllegalArgumentException("The align is illegal");
        }
        if (scale < 2 || scale > 4) {
            throw new IllegalArgumentException("The scale is illegal");
        }
        if (hri < 0) {
            throw new IllegalArgumentException("The hri is negative");
        }
        if (height < 1 || height > 255) {
            throw new IllegalArgumentException("The height is illegal");
        }
        this.mSettings.barcodeAlign = align;
        this.mSettings.barcodeHriFont = small ? 1 : 0;
        this.mSettings.barcodeScale = scale;
        this.mSettings.barcodeHriCode = hri;
        this.mSettings.barcodeHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBarcode(int type, byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null.");
        }
        byte[] buf = new byte[21 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 119;
        buf[offs++] = (byte)this.mSettings.barcodeScale;
        buf[offs++] = 29;
        buf[offs++] = 104;
        buf[offs++] = (byte)this.mSettings.barcodeHeight;
        buf[offs++] = 29;
        buf[offs++] = 72;
        buf[offs++] = (byte)this.mSettings.barcodeHriCode;
        buf[offs++] = 29;
        buf[offs++] = 102;
        buf[offs++] = (byte)this.mSettings.barcodeHriFont;
        switch (type) {
            case 65: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCA barcode data must be 11 symbols");
            }
            case 66: {
                if (data.length == 11) break;
                throw new IllegalArgumentException("The length of UPCE barcode data must be 11 symbols");
            }
            case 67: {
                if (data.length == 12) break;
                throw new IllegalArgumentException("The length of EAN13 barcode data must be 12 symbols");
            }
            case 68: {
                if (data.length == 7) break;
                throw new IllegalArgumentException("The length of EAN8 barcode data must be 7 symbols");
            }
            case 74: {
                if (data.length >= 1 && data.length <= 1000) break;
                throw new IllegalArgumentException("The length of PDF417 barcode data must be between 1 and 1000 symbols");
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: {
                if (data.length >= 1 && data.length <= 255) break;
                throw new IllegalArgumentException("The length of barcode data must be between 1 and 255 symbols");
            }
            default: {
                throw new IllegalArgumentException("Invalid barcode type");
            }
        }
        buf[offs++] = 29;
        buf[offs++] = 107;
        buf[offs++] = (byte)type;
        if (type == 73 && data[0] != 123) {
            buf[offs++] = (byte)(data.length + 2);
            buf[offs++] = 123;
            buf[offs++] = 66;
        } else if (type == 74) {
            buf[offs++] = 0;
            buf[offs++] = (byte)(data.length & 0xFF);
            buf[offs++] = (byte)(data.length >> 8 & 0xFF);
        } else {
            buf[offs++] = (byte)data.length;
        }
        for (int i = 0; i < data.length; ++i) {
            buf[offs++] = data[i];
        }
        Printer printer = this;
        synchronized (printer) {
            this.write(buf, 0, offs);
        }
    }

    public void printBarcode(int type, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printBarcode(type, data.getBytes());
    }

    public void printQRCode(int size, int eccLv, byte[] data) throws IOException {
        byte[] buf = new byte[10 + data.length];
        int offs = 0;
        buf[offs++] = 27;
        buf[offs++] = 97;
        buf[offs++] = (byte)this.mSettings.barcodeAlign;
        buf[offs++] = 29;
        buf[offs++] = 81;
        buf[offs++] = 6;
        buf[offs++] = (byte)size;
        buf[offs++] = (byte)eccLv;
        buf[offs++] = (byte)data.length;
        buf[offs++] = (byte)(data.length >> 8);
        for (int i = 0; i < data.length; ++i) {
            buf[offs++] = data[i];
        }
        this.write(buf);
    }

    public void printQRCode(int size, int eccLv, String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        this.printQRCode(size, eccLv, data.getBytes());
    }

    public void setQRCode(int cellSize) throws IOException {
        byte[] buffer = new byte[]{29, 83, (byte)cellSize};
        this.write(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calibrateBMMSensor() throws IOException {
        byte[] buf = new byte[]{27, 67, 65, 76, 3};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedLabel() throws IOException {
        byte[] buf = new byte[]{12};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPageMode() throws IOException {
        byte[] buf = new byte[]{27, 76, 24};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectStandardMode() throws IOException {
        byte[] buf = new byte[]{29, 85};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage() throws IOException {
        byte[] buf = new byte[]{29, 90};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageRegion(int x, int y, int width, int height, int direction) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || direction < 0 || direction > 3) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 87, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), 29, 84, (byte)(direction & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageXY(int x, int y) throws IOException {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{27, 36, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), 29, 36, (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageRectangle(int x, int y, int width, int height, int fillMode) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 82, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPageFrame(int x, int y, int width, int height, int fillMode, int thickness) throws IOException {
        if (x < 0 || y < 0 || width < 0 || height < 0 || fillMode < 0 || fillMode > 2 || thickness < 0) {
            throw new IllegalArgumentException("The illegal parameter");
        }
        byte[] buf = new byte[]{29, 88, (byte)(x & 0xFF), (byte)(x >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(fillMode & 0xFF), (byte)(thickness & 0xFF)};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSettings(int type) throws IOException {
        byte[] buffer = new byte[2044];
        int offset = 0;
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(new byte[]{27, 115, (byte)type});
            do {
                this.request(++offset, 5000);
            } while (buffer[offset - 1] != 0);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < offset; ++i) {
            if ((buffer[i] & 0xFF) > 32) {
                sb.append((char)(buffer[i] & 0xFF));
                continue;
            }
            if ((buffer[i] & 0xFF) <= 0) continue;
            sb.append('\n');
        }
        return sb.toString().substring(1).split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntensity(int level) throws IOException {
        byte[] buf = new byte[]{27, 89, (byte)level};
        Printer printer = this;
        synchronized (printer) {
            this.write(buf);
        }
    }

    public TouchChip getTouchChip() {
        TouchChip instance = new TouchChip(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected byte[] transmit(byte[] input) throws IOException {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(27);
                buffer.write(39);
                for (int i = 0; i < input.length; ++i) {
                    int v = input[i] & 0xFF;
                    if (v < 32) {
                        buffer.write(16);
                        buffer.write(v + 32);
                        continue;
                    }
                    buffer.write(v);
                }
                Printer i = Printer.this;
                synchronized (i) {
                    Printer.this.clear();
                    Printer.this.output(buffer.toByteArray());
                    int offset = 0;
                    do {
                        Printer.this.request(++offset, 31000);
                    } while (offset < Printer.this.mDataBuffer.length - 1 && Printer.this.mDataBuffer[offset - 1] != 10);
                    buffer.reset();
                    for (int i2 = 0; i2 < offset - 2; ++i2) {
                        int v = Printer.this.mDataBuffer[i2] & 0xFF;
                        if (v == 16) {
                            v = (Printer.this.mDataBuffer[++i2] & 0xFF) - 32;
                        }
                        buffer.write(v);
                    }
                }
                byte[] result = buffer.toByteArray();
                return result;
            }
        };
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalFormat() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(69);
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(o.toByteArray());
            this.request(3, 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalWrite(byte[] data) throws IOException {
        if (data.length > 400) {
            throw new IllegalArgumentException("The parameter 'text' is out of limits");
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(119);
        o.write(data.length);
        o.write(data.length >> 8);
        o.write(data);
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(o.toByteArray());
            this.request(3, 5000);
        }
    }

    public void journalWrite(String text, String charset) throws IOException {
        byte[] data = text.getBytes(charset);
        this.journalWrite(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void journalPrint() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        o.write(29);
        o.write(35);
        o.write(37);
        o.write(38);
        o.write(42);
        o.write(80);
        Printer printer = this;
        synchronized (printer) {
            this.output(o.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] journalRead(boolean first) throws IOException {
        byte[] buffer = new byte[]{29, 35, 37, 38, 42, first ? (byte)70 : 78};
        Printer printer = this;
        synchronized (printer) {
            this.clear();
            this.output(buffer);
            int cnt = 1;
            int len = 0;
            do {
                this.request(++cnt, 5000);
                len = (this.mDataBuffer[1] & 0xFF) + ((this.mDataBuffer[2] & 0xFF) << 8);
            } while (cnt < 3 || len != cnt - 3);
            if (this.mDataBuffer[0] == 70) {
                return null;
            }
            byte[] tmp = new byte[len];
            System.arraycopy(this.mDataBuffer, 3, tmp, 0, tmp.length);
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] journalRead() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        Printer printer = this;
        synchronized (printer) {
            byte[] res = this.journalRead(true);
            if (res != null) {
                o.write(res);
                while ((res = this.journalRead(false)) != null) {
                    o.write(res);
                }
            }
        }
        return o.toByteArray();
    }

    public String journalRead(String charset) throws IOException {
        byte[] data = this.journalRead();
        return new String(data, 0, data.length, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cutPaper(int m, int n) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(29);
        buf.write(86);
        buf.write(m);
        buf.write(n);
        Printer printer = this;
        synchronized (printer) {
            this.write(buf.toByteArray());
        }
    }

    public void cutPaper() throws IOException {
        this.cutPaper(1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresenterActiveMode(int n) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(27);
        buf.write(99);
        buf.write(57);
        buf.write(n);
        Printer printer = this;
        synchronized (printer) {
            this.write(buf.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresenterOpMode(int n) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(27);
        buf.write(114);
        buf.write(48);
        buf.write(n);
        Printer printer = this;
        synchronized (printer) {
            this.write(buf.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetractiveModeTimeout(int timeout) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(27);
        buf.write(114);
        buf.write(49);
        buf.write(timeout);
        Printer printer = this;
        synchronized (printer) {
            this.write(buf.toByteArray());
        }
    }

    static /* synthetic */ byte[] access$202(Printer x0, byte[] x1) {
        x0.mDataBuffer = x1;
        return x1;
    }

    public static interface ConnectionListener {
        public void onDisconnect();
    }

    private class Settings {
        public int barcodeAlign;
        public int barcodeScale;
        public int barcodeHeight;
        public int barcodeHriFont;
        public int barcodeHriCode;

        private Settings() {
        }
    }
}

