/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.drawer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class Drawer {
    private static boolean sDebug = false;
    private static final int PACKET_HEADER_SIZE = 4;
    private static final int PACKET_DATA_SIZE = 2048;
    private static final int MAX_PACKET_SIZE = 2052;
    private static final int PACKET_TIMEOUT = 4000;
    private static final int EVN_STATE_CHANGED = 1;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private ReceiverThread mReceiverThread;
    private List<byte[]> mPacketBuffer = null;
    private IOException mLastError;
    private ConnectionListener mConnectionListener;
    private StateListener mStateListener;

    public Drawer(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            throw new NullPointerException("The argument 'inputStream' is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("The argument 'outputStream' is null");
        }
        this.mInputStream = inputStream;
        this.mOutputStream = outputStream;
        this.mPacketBuffer = new LinkedList<byte[]>();
        this.mReceiverThread = new ReceiverThread();
        this.mReceiverThread.start();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDebug(boolean on) {
        sDebug = on;
    }

    private static final String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    private static void debug(String s) {
        if (sDebug) {
            System.out.println(s);
        }
    }

    private static void debug(Exception e) {
        if (sDebug) {
            e.printStackTrace();
        }
    }

    private static void debug(String s, byte[] buffer, int offset, int length) {
        if (sDebug) {
            s = s + Drawer.byteArrayToHexString(buffer, offset, length) + " (" + length + ")";
            System.out.println(s);
        }
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        int status = this.mInputStream.read(buffer, offset, length);
        if (status == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            if (status < 0) {
                throw new IOException("The end of stream is reached");
            }
            Drawer.debug("<< ", buffer, offset, status);
        }
        return status;
    }

    private void write(byte[] buffer, int offset, int length) throws IOException {
        this.mOutputStream.write(buffer, offset, length);
        this.mOutputStream.flush();
        Drawer.debug(">> ", buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transmit(int command, byte[] data) throws IOException {
        byte[] packet;
        block10: {
            List<byte[]> list = this.mPacketBuffer;
            synchronized (list) {
                this.mPacketBuffer.clear();
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            buffer.write(command);
            buffer.write(0);
            buffer.write(data.length >> 8);
            buffer.write(data.length);
            buffer.write(data);
            byte[] tmp = buffer.toByteArray();
            this.write(tmp, 0, tmp.length);
            long last = System.currentTimeMillis() + 4000L;
            do {
                List<byte[]> list2 = this.mPacketBuffer;
                synchronized (list2) {
                    if (!this.mPacketBuffer.isEmpty()) {
                        packet = this.mPacketBuffer.remove(0);
                        break block10;
                    }
                    try {
                        this.mPacketBuffer.wait(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } while (last >= System.currentTimeMillis());
            throw new IOException("timeout");
        }
        byte[] result = new byte[packet.length - 4];
        System.arraycopy(packet, 4, result, 0, result.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(byte[] buffer, int length) {
        boolean isEvent;
        boolean bl = isEvent = buffer[0] == 1;
        if (isEvent) {
            int id = buffer[1] & 0xFF;
            switch (id) {
                case 1: {
                    boolean isOpened = buffer[4] == 1;
                    this.raiseStateChanged(isOpened);
                    break;
                }
            }
        } else {
            byte[] packet = new byte[length];
            System.arraycopy(buffer, 0, packet, 0, packet.length);
            List<byte[]> list = this.mPacketBuffer;
            synchronized (list) {
                this.mPacketBuffer.add(packet);
                this.mPacketBuffer.notify();
            }
        }
    }

    private void raiseStateChanged(final boolean opened) {
        final StateListener l = this.mStateListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onStateChanged(opened);
                }
            }).start();
        }
    }

    private void raiseDisconnected() {
        final ConnectionListener l = this.mConnectionListener;
        if (l != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    l.onDisconnect();
                }
            }).start();
        }
    }

    public void setConnectionListener(ConnectionListener listener) {
        this.mConnectionListener = listener;
    }

    public void setStateListener(StateListener listener) {
        this.mStateListener = listener;
    }

    public boolean getState() throws IOException {
        byte[] result = this.transmit(2, new byte[0]);
        return result[0] == 1;
    }

    public void open(int impulse) throws IOException {
        this.transmit(1, new byte[]{(byte)(impulse >> 8), (byte)impulse});
    }

    public void open() throws IOException {
        this.open(30);
    }

    public void enableEvents(boolean on) throws IOException {
        this.transmit(3, new byte[]{(byte)(on ? 1 : 0)});
    }

    private class ReceiverThread
    extends Thread {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buffer = new byte[2052];
            int offset = 0;
            try {
                block5: while (Drawer.this.mLastError == null) {
                    int length;
                    offset += Drawer.this.read(buffer, offset, buffer.length - offset);
                    while (offset >= 4 && offset >= (length = 4 + ((buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF))) {
                        Drawer.this.processPacket(buffer, length);
                        System.arraycopy(buffer, length, buffer, 0, offset - length);
                        offset -= length;
                        if (Drawer.this.mLastError == null) continue;
                        continue block5;
                    }
                }
            }
            catch (IOException e) {
                Drawer.debug(e);
                if (Drawer.this.mLastError == null) {
                    Drawer.this.mLastError = e;
                }
            }
            finally {
                Drawer.this.raiseDisconnected();
            }
            Drawer.debug("Device is disconnected");
        }
    }

    public static interface StateListener {
        public void onStateChanged(boolean var1);
    }

    public static interface ConnectionListener {
        public void onDisconnect();
    }
}

