/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.rfid;

import com.datecs.rfid.ContactlessCard;
import com.datecs.rfid.FeliCaCard;
import com.datecs.rfid.ISO14443Card;
import com.datecs.rfid.ISO15693Card;
import com.datecs.rfid.RFID;
import com.datecs.rfid.RFIDException;
import com.datecs.rfid.STSRICard;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RC663
extends RFID {
    private static final int IO_TIMEOUT = 1000;
    private static final int PACKET_HEADER_SIZE = 4;
    private static final int PACKET_DATA_MAX_SIZE = 256;
    public static final int CHANNEL_MAIN = 0;
    public static final int CHANNEL_ISO1443A = 1;
    public static final int CHANNEL_ISO1443B = 2;
    public static final int CHANNEL_ISO15693 = 3;
    public static final int CHANNEL_FELICA = 4;
    public static final int CHANNEL_STSRI = 5;
    public static final int CARD_SUPPORT_TYPE_A = 1;
    public static final int CARD_SUPPORT_TYPE_B = 2;
    public static final int CARD_SUPPORT_FELICA = 4;
    public static final int CARD_SUPPORT_NFC = 8;
    public static final int CARD_SUPPORT_JEWEL = 16;
    public static final int CARD_SUPPORT_ISO15 = 32;
    public static final int CARD_SUPPORT_STSRI = 64;
    public static final int CARD_SUPPORT_PICOPASS_ISO14 = 128;
    public static final int CARD_SUPPORT_PICOPASS_ISO15 = 256;
    private static final int RC663_COMMAND_CLOSE = 1;
    private static final int RC663_COMMAND_TRANSCEIVE = 2;
    private static final int RC663_COMMAND_RESUME = 3;
    private static final int RC663_COMMAND_SET_DETECTION_PARAMS = 11;
    private static final int RC663_MAIN_INIT = 16;
    private static final int EVENT_BIT = 128;
    private int mSupportedCards;
    private byte[] mPacketBuffer;
    private int mPacketLength;
    private CardListener mCardListener;

    public RC663(InputStream in, OutputStream out, int supportedCards) {
        super(in, out);
        this.mSupportedCards = supportedCards;
        this.mPacketBuffer = new byte[260];
    }

    public RC663(InputStream in, OutputStream out) {
        this(in, out, -1);
    }

    private int getPacketLength() {
        int dataLength;
        int packLength;
        if (this.mPacketLength >= 4 && this.mPacketLength >= (packLength = 4 + (dataLength = (this.mPacketBuffer[2] & 0xFF) << 8 | this.mPacketBuffer[3] & 0xFF))) {
            return packLength;
        }
        return 0;
    }

    private byte[] getPacketData(boolean consume) {
        int packLength = this.getPacketLength();
        int dataLength = packLength - 4;
        if (dataLength >= 0) {
            byte[] tmp = new byte[dataLength];
            System.arraycopy(this.mPacketBuffer, 4, tmp, 0, tmp.length);
            if (consume) {
                this.mPacketLength -= packLength;
                System.arraycopy(this.mPacketBuffer, packLength, this.mPacketBuffer, 0, this.mPacketLength);
            }
            return tmp;
        }
        return null;
    }

    private void processCardEvent() {
        int packLen = this.getPacketLength();
        if (packLen > 0 && (this.mPacketBuffer[0] & 0x80) != 0) {
            final int channel = this.mPacketBuffer[1] & 0xFF;
            final byte[] data = this.getPacketData(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ContactlessCard card = RC663.this.initCard(channel, data);
                    if (card != null) {
                        RC663.this.raiseOnCardDetected(card);
                    } else {
                        try {
                            RC663.this.resume();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDataReceived(byte[] data, int size) {
        byte[] byArray = this.mPacketBuffer;
        synchronized (this.mPacketBuffer) {
            int chunkSize = Math.min(size, this.mPacketBuffer.length - this.mPacketLength);
            System.arraycopy(data, 0, this.mPacketBuffer, this.mPacketLength, size);
            this.mPacketLength += chunkSize;
            this.processCardEvent();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void raiseOnCardDetected(ContactlessCard card) {
        CardListener l = this.mCardListener;
        if (l != null) {
            l.onCardDetect(card);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private byte[] readPacket() throws IOException {
        long time = System.currentTimeMillis() + 1000L;
        while (true) {
            if (this.getLastError() != null) {
                throw new IOException(this.getLastError());
            }
            byte[] byArray = this.mPacketBuffer;
            // MONITORENTER : this.mPacketBuffer
            if (this.getPacketLength() > 0) {
                byte errCode = -this.mPacketBuffer[1];
                byte[] data = this.getPacketData(true);
                if (errCode != 0) {
                    throw new RFIDException(errCode);
                }
                // MONITOREXIT : byArray
                return data;
            }
            // MONITOREXIT : byArray
            if (time < System.currentTimeMillis()) {
                throw new IOException("Read packet timeout");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized byte[] transmit(byte[] data) throws IOException {
        this.writeBlock(data, 0, data.length);
        return this.readPacket();
    }

    private synchronized byte[] transmit(int channel, int command, byte[] data) throws IOException, RFIDException {
        byte[] input = new byte[4 + data.length];
        input[0] = (byte)channel;
        input[1] = (byte)command;
        input[2] = (byte)(data.length >> 8);
        input[3] = (byte)data.length;
        System.arraycopy(data, 0, input, 4, data.length);
        byte[] output = this.transmit(input);
        return output;
    }

    private byte[] transmit(int channel, int command) throws IOException, RFIDException {
        byte[] data = new byte[]{};
        return this.transmit(channel, command, data);
    }

    public byte[] transmitCard(int channel, byte[] data) throws IOException, RFIDException {
        byte[] result = this.transmit(channel, 2, data);
        if (channel == 4) {
            if (result.length < 9) {
                throw new RFIDException(-6);
            }
            byte[] tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
        }
        return result;
    }

    public byte[] transmitCard(int channel, byte[] data, int length) throws IOException, RFIDException {
        byte[] tmp = new byte[length];
        System.arraycopy(data, 0, tmp, 0, length);
        return this.transmitCard(channel, tmp);
    }

    private ContactlessCard initCard(int channel, byte[] data) {
        ContactlessCard card = null;
        boolean cardDetected = false;
        try {
            if (channel == 1) {
                card = new ISO14443Card(this);
                card.channel = channel;
                int index = 0;
                card.atqa = (short)((data[index + 0] & 0xFF) << 8 | data[index + 1] & 0xFF);
                card.sak = (short)(data[index += 2] & 0xFF);
                int uidLen = data.length - ++index;
                card.uid = new byte[uidLen];
                System.arraycopy(data, index, card.uid, 0, uidLen);
                cardDetected = card.initialize();
            } else if (channel == 2) {
                cardDetected = false;
            } else if (channel == 3) {
                card = new ISO15693Card(this);
                card.channel = channel;
                card.type = 8;
                card.dsfid = data[1];
                int uidLen = data.length - 2;
                card.uid = new byte[uidLen];
                System.arraycopy(data, 2, card.uid, 0, uidLen);
                cardDetected = card.initialize();
            } else if (channel == 4) {
                card = new FeliCaCard(this);
                card.channel = channel;
                card.type = 11;
                int uidLen = 8;
                card.uid = new byte[uidLen];
                System.arraycopy(data, 2, card.uid, 0, uidLen);
                cardDetected = card.initialize();
            } else if (channel == 5) {
                card = new STSRICard(this);
                card.channel = channel;
                card.type = 12;
                int uidLen = 8;
                card.uid = new byte[uidLen];
                System.arraycopy(data, 0, card.uid, 0, uidLen);
                cardDetected = card.initialize();
            } else {
                cardDetected = false;
            }
        }
        catch (IOException e) {
            cardDetected = false;
        }
        if (cardDetected) {
            return card;
        }
        return null;
    }

    public void setCardListener(CardListener l) {
        this.mCardListener = l;
    }

    public void enable() throws RFIDException, IOException {
        byte[] buffer = new byte[]{(byte)(this.mSupportedCards >> 8), (byte)this.mSupportedCards, 0, -56};
        this.transmit(0, 16, buffer);
    }

    public void disable() throws RFIDException, IOException {
        this.transmit(0, 1);
    }

    public void resume() throws RFIDException, IOException {
        this.transmit(0, 3);
    }

    public void setPollingParams(int requestCode, int systemCode, int timeSlot, int detectionTime, int intervalTime) throws RFIDException, IOException {
        byte[] cmd = new byte[]{4, (byte)(systemCode >> 8), (byte)systemCode, (byte)requestCode, (byte)timeSlot, (byte)(detectionTime >> 8), (byte)detectionTime, (byte)(intervalTime >> 8), (byte)intervalTime};
        this.transmit(0, 11, cmd);
    }

    public static interface CardListener {
        public void onCardDetect(ContactlessCard var1);
    }
}

