package bg.datecs.drawerdemo.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import bg.datecs.drawerdemo.R;

/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link CommandFragment.OnFragmentInteractionListener} interface
 * to handle interaction events.
 */
public class CommandFragment extends Fragment {

    private OnFragmentInteractionListener mListener;

    public CommandFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_command, container, false);
        view.findViewById(R.id.btn_open_drawer).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onOpenDrawer();
            }
        });
        view.findViewById(R.id.btn_get_state).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onGetState();
            }
        });
        return view;
    }

    public void onOpenDrawer() {
        if (mListener != null) {
            mListener.onOpenDrawer();
        }
    }

    public void onGetState() {
        if (mListener != null) {
            mListener.onGetState();
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {

        void onOpenDrawer();

        void onGetState();
    }
}
